#ifndef ALTNETREQUEST_H
#define ALTNETREQUEST_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETRequest.h 667 2007-11-17 06:34:13Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altNETRequest.h
 * \brief   Request
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETConnection.h>
#include <altMisc/altQue.h>
#include <altBase/altPtr.h>
#include <altBase/altMem.h>
#include <altBase/altUncopyable.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef alt_t(* altNETReceiveCallBack)(const altCNETConnectionPtr &, const altCharPtr &, const altUInt); ///< Call Back Data Receive Function

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Request Infomation Class
///
class altNETRequest : public altBase, private altUncopyable
{
public:
  ///
  /// \brief  Constructor
  ///
  altNETRequest();

  ///
  /// \brief  Destructor
  ///
  virtual ~altNETRequest();

  altNETReceiveCallBack   m_pReceiveCallBackFunc;   ///< Call Back Function
  altCNETConnectionPtr    m_pConnection;            ///< NET Connection
  altCharPtr              m_pData;                  ///< Received Data
  altUInt                 m_nSize;                  ///< Received Data Size
};

#endif  //ALTNETREQUEST_H
