#ifndef ALTINETADDRESS_H
#define ALTINETADDRESS_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altInetAddress.h 163 2007-05-24 07:01:15Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altInetAddress.h
 * \brief   Internet Socket Address
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altSocketAddress.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/


/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Internet Socket Address Class
///
class altInetAddress : public altSocketAddress
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altInetAddress();

  ///
  /// \brief  Constructor
  ///
  LIBALT_API altInetAddress(const SOCKADDR_IN & oAddr);

  ///
  /// \brief  Constructor
  ///
  /// \param  nPort   [I ] Port Number
  ///
  LIBALT_API altInetAddress(const altInt nPort);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altInetAddress();

  ///
  /// \brief  Initialize
  ///
  /// \param  szIP    [I ] IP Address
  /// \param  nPort   [I ] Port Number
  ///
  /// \return ALT_S_SUCCESS       success
  /// \return ALT_E_UNKOWN_HOST   unknown host error
  ///
  LIBALT_API alt_t Init(const altChar * szIP, const altInt nPort);

  ///
  /// \brief  Get Pointer of Internet Socket Address
  ///
  /// \return Pointer of Internet Socket Address
  ///
  LIBALT_API const SOCKADDR_IN * GetAddrInPtr() const;

  ///
  /// \brief  Set Internet Socket Address
  ///
  /// \param  oAddr [I ] Internet Socket Address
  ///
  LIBALT_API void SetAddr(const SOCKADDR_IN & oAddr);

  ///
  /// \brief Get IP Address
  ///
  /// \return IP Address
  ///
  LIBALT_API const altStr GetIP() const;

  ///
  /// \brief Get Port NO
  ///
  /// \return Port NO
  ///
  LIBALT_API altInt GetPort() const;

protected:
  SOCKADDR_IN m_oAddr;    ///< Internet Socket Address
};
#endif  //ALTINETADDRESS_H
