#ifndef ALTBZIP2_H
#define ALTBZIP2_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altBzip2.h 691 2007-11-20 00:25:47Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altBzip2.h
 * \brief   bzip2
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altLog.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  bzip2
///
class altBzip2 : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altBzip2();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altBzip2();

  ///
  /// \brief  Compress
  ///
  /// \param  pData   [IO] Data
  /// \param  nLen    [IO] Data Length
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_NOMEM     Out of memory
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t Compress(altChar * & pData, altUInt & nLen);

  ///
  /// \brief  Decompress
  ///
  /// \param  pData   [IO] Data
  /// \param  nLen    [IO] Data Length
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_NOMEM     Out of memory
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t Decompress(altChar * & pData, altUInt & nLen);

private:
  ///
  /// \brief  Compress
  ///
  /// \param  pDst    [ O] Data
  /// \param  nDstLen [ O] Data Length
  /// \param  pSrc    [I ] Data
  /// \param  nSrcLen [I ] Data Length
  ///
  /// \return ALT_S_SUCCESS         Success
  /// \return ALT_S_OUTBUFFER_FULL  Out Buffer Full
  /// \return ALT_E_ERROR           Error
  ///
  LIBALT_API alt_t Compress(altChar * pDst, altUInt nDstLen, altChar * pSrc, altUInt nSrcLen);

  ///
  /// \brief  Decompress
  ///
  /// \param  pDst    [ O] Data
  /// \param  nDstLen [ O] Data Length
  /// \param  pSrc    [I ] Data
  /// \param  nSrcLen [I ] Data Length
  ///
  /// \return ALT_S_SUCCESS         Success
  /// \return ALT_S_NOCOMPRESS      No Compress
  /// \return ALT_S_OUTBUFFER_FULL  Out Buffer Full
  /// \return ALT_E_ERROR           Error
  ///
  LIBALT_API alt_t Decompress(altChar * pDst, altUInt nDstLen, altChar * pSrc, altUInt nSrcLen);
};

#endif
