#ifndef ALTMOUSE_H
#define ALTMOUSE_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altMouse.h 733 2007-12-01 07:47:57Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altMouse.h
 * \brief   Mouse
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN

#include <altBase/altLog.h>
#include <altBase/altSingleton.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get Instance
///
#define aiMouse altMouse::GetInstance()

#ifndef WM_MOUSEWHEEL
  #define WM_MOUSEWHEEL 0x020A
#endif

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Mouse
///
class altMouse : public altSingleton<altMouse>
{
friend class altSingleton<altMouse>;
public:
  enum{
    LBTN_DOWN = 0x1,
    RBTN_DOWN = 0x2,
  };
private:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altMouse();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altMouse();

public:
  ///
  /// \brief  Move
  ///
  /// \param  x   [I ] X
  /// \param  y   [I ] Y
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Move(altInt x, altInt y);

  ///
  /// \brief  Left Button Down
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t LButtonDown();

  ///
  /// \brief  Left Button Up
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t LButtonUp();

  ///
  /// \brief  Right Button Down
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t RButtonDown();

  ///
  /// \brief  Right Button Up
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t RButtonUp();

  ///
  /// \brief  Wheel rotation
  ///
  /// \param  nRotation [I ] rotation
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t Wheel(altInt nRotation);

  ///
  /// \brief  Get wheel rotation
  ///
  /// \param  bReset  [I ] Reset
  ///
  /// \return rotation distance
  ///
  LIBALT_API altInt GetWheelRotation(altBool bReset = true);

  ///
  /// \brief  Get drag distance
  ///
  /// \param  x       [ O] X
  /// \param  y       [ O] Y
  /// \param  nFlags  [ O] Button flag
  /// \param  bReset  [I ] Reset
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t GetDragDistance(altInt & x, altInt & y, altInt & nFlags, altBool bReset = true);

  ///
  /// \brief  Get cursor position
  ///
  /// \param  x       [ O] X
  /// \param  y       [ O] Y
  /// \param  nFlags  [ O] Button flag
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t GetCurPos(altInt & x, altInt & y, altInt & nFlags);

  ///
  /// \brief  Get last cursor position
  ///
  /// \param  x       [ O] X
  /// \param  y       [ O] Y
  /// \param  nFlags  [ O] Button flag
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t GetLastCurPos(altInt & x, altInt & y, altInt & nFlags);

  ///
  /// \brief  Window Procedure
  ///
  /// \param  hwnd    [I ] Window handle
  /// \param  msg     [I ] message
  /// \param  wParam  [I ] parameter
  /// \param  lParam  [I ] parameter
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

  ///
  /// \brief  Get altMouse Instance
  ///
  /// \return altMouse Instance
  ///
  LIBALT_API static altMouse & GetInstance();

private:
  altInt    m_nFlags;
  POINT     m_oLastCurPos;
  POINT     m_oDragStCPos;
  altInt    m_nWheelRotation;
};

#endif
#endif

