#ifndef ALTDXINPUT_H
#define ALTDXINPUT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDXInput.h 736 2007-12-01 11:06:54Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altDXInput.h
 * \brief   DirectX Input
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altBase/altLog.h>
#include <altBase/altSingleton.h>
#include <dinput.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get Instance
///
#define aiDXInput altDXInput::GetInstance()

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::vector<altUInt>  altKeyContainer;

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Event
///
class altDXInput : public altSingleton<altDXInput>
{
friend class altSingleton<altDXInput>;
private:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDXInput();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altDXInput();

  ///
  /// \brief  Clean up
  ///
  LIBALT_API void Cleanup();

public:
  ///
  /// \brief  Set keyboard
  ///
  /// \param  dwCooperativeLevel  [I ] Cooperative level
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API alt_t SetKeyboard(DWORD dwCooperativeLevel = DISCL_NONEXCLUSIVE | DISCL_BACKGROUND);

  ///
  /// \brief  Get down key or not
  ///
  /// \param  nKey  [I ] Key
  ///
  /// \return true  down
  /// \return false not down
  ///
  LIBALT_API altBool DownKey(const altByte nKey);

  ///
  /// \brief  Get down key or not
  ///
  /// \return true  down
  /// \return false not down
  ///
  LIBALT_API altBool DownAnyKey();

  ///
  /// \brief  Get down keys
  ///
  /// \return Down keys
  ///
  LIBALT_API altKeyContainer GetDownKey();

  ///
  /// \brief  Get altDXInput Instance
  ///
  /// \return altDX Instance
  ///
  LIBALT_API static altDXInput & GetInstance();

  ///
  /// \brief  Delete Instance
  ///
  LIBALT_API static void DeleteInstance();

private:
  LPDIRECTINPUT8        m_pDinput;        ///< DirectX input
  LPDIRECTINPUTDEVICE8  m_pInputDevice;   ///< Input device
};

#endif
#endif
