#ifndef ALT2DQUAD_H
#define ALT2DQUAD_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: alt2DQuad.h 771 2007-12-19 03:46:08Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    alt2DQuad.h
 * \brief   DirectX 2D Quad
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN

#include <altDX/altCamera.h>
#include <altDX/altPolygon.h>
#include <altDX/altTexture.h>
#include <altDX/altComponent.h>
#include <altBase/altStatus.h>


/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
struct TLVERTEX
{
  D3DXVECTOR3   vPos;
  FLOAT         rhw;
  DWORD         color;
  FLOAT         tu;
  FLOAT         tv;

  static const DWORD  FVF_FORMAT;
};

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DirectX 2D Quad
///
class alt2DQuad : public altComponent
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API alt2DQuad();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~alt2DQuad();

  ///
  /// \brief  Set Position
  ///
  /// \param  x       [I ] X
  /// \param  y       [I ] Y
  /// \param  w       [I ] Width
  /// \param  h       [I ] Height
  /// \param  dwColor [I ] Color
  ///
  LIBALT_API alt_t SetPosition(const FLOAT x, const FLOAT y, const FLOAT w, const FLOAT h, const DWORD dwColor);

  ///
  /// \brief  Set Position
  ///
  /// \param  x [I ] X
  /// \param  y [I ] Y
  /// \param  w [I ] Width
  /// \param  h [I ] Height
  ///
  LIBALT_API alt_t SetPosition(const FLOAT x, const FLOAT y, const FLOAT w, const FLOAT h);

  ///
  /// \brief  Set color
  ///
  /// \param  dwColor [I ] Color
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t SetColor(const DWORD dwColor);

  ///
  /// \brief  Set Texture
  ///
  /// \param  sFileName [I ] File Name
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t SetTexture(const altStr & sFileName);

  ///
  /// \brief  Render
  ///
  /// \param  pd3dDevice  [I ] D3D Device
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Render(IDirect3DDevice9 * pd3dDevice);

  ///
  /// \brief  Release Memory
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t Cleanup();

private:
  ///
  /// \brief  Set Position
  ///
  /// \param  vPos    [I ] Position
  /// \param  vRect   [I ] Rectangle
  /// \param  dwColor [I ] Color
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t SetPosition(const D3DXVECTOR3 * vPos, const D3DXVECTOR2 * vRect, const DWORD dwColor);

  IDirect3DVertexBuffer9 *    m_pVB;      ///< Pointer of Vertex Buffer
  altTexture                  m_oTex;     ///< Texture
  FLOAT                       m_x;        ///< X
  FLOAT                       m_y;        ///< Y
  FLOAT                       m_w;        ///< Width
  FLOAT                       m_h;        ///< Height
  DWORD                       m_dwColor;  ///< Color
};

#endif
#endif
