#ifndef ALTSIGNAL_H
#define ALTSIGNAL_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSignal.h 558 2007-11-10 04:16:15Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSignal.h
 * \brief   Signal
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_LINUX
#include <altBase/altLog.h>
#include <signal.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Signal
///
class altSignal : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSignal();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSignal();

  ///
  /// \brief  Signal block
  ///
  /// \param  nSignal [I ] Signal Number
  ///
  /// \return ALT_S_SUCCESS success
  /// \return ALT_E_ERROR   error
  ///
  LIBALT_API static alt_t Block(altInt nSignal);

  ///
  /// \brief  Signal block handler
  ///
  /// \param  nSignal [I ] Signal number
  ///
  LIBALT_API static void BlockHandler(int nSignal);
};

#endif
#endif
