#ifndef ALTCLASS_H
#define ALTCLASS_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altRuntime.h 684 2007-11-18 05:58:59Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altClass.h
 * \brief   Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altBase.h>
#include <altBase/altStr.h>
#include <typeinfo>

#ifdef ALT_WIN
#pragma comment(lib, "imagehlp.lib")
#include <imagehlp.h>
#endif

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get typeid
///
/// \param  o [I ] paramter
///
#define ALT_GET_TYPE(o)           typeid (o)

///
/// \brief  Get type name
///
/// \param  o [I ] paramter
///
/// \return Type name
///
#define ALT_GET_TYPE_NAME(o)      ALT_GET_TYPE (o).name()

///
/// \brief  Get class name
///
/// \return Class name
///
#define ALT_GET_CLASS_NAME()      ALT_GET_TYPE_NAME (* this)

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Runtime Class
///
class altRuntime
{
private:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altRuntime();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altRuntime();

public:
  ///
  /// \brief  Get stack trace
  ///
  /// \return  Stack trace
  ///
  LIBALT_API static altStr GetStackTrace();

#ifdef ALT_WIN
  ///
  /// \brief  Convert address
  ///
  /// \param  hProcess  [I ] Proccess handle
  /// \param  dwAddr    [I ] Address
  /// \param  sOutBuf   [ O] Out buffer
  ///
  /// \return System size
  ///
  LIBALT_API static void ConvertAddress(HANDLE hProcess, DWORD dwAddr, altStr & sOutBuf);
#endif
};

#endif
