#ifndef ALTCHARPTR_H
#define ALTCHARPTR_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altCharPtr.h 718 2007-11-23 14:58:14Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altCharPtr.h
 * \brief   Char Pointer class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altPtr.h>
#include <altBase/altMem.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
class altCharPtr;

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Pointer Class
///
class altCharPtr : public altPtr<altChar>
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altCharPtr();

  ///
  /// \brief  Constructor
  ///
  /// \param  p [I ] Data
  ///
  LIBALT_API altCharPtr(altChar * p) ALT_THROWS (alt_t);

  ///
  /// \brief  Constructor
  ///
  /// \param  p [I ] Data
  ///
  LIBALT_API altCharPtr(const altCharPtr & p);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altCharPtr();

  ///
  /// \brief  Cast altChar *
  ///
  /// \return Pointer
  ///
  LIBALT_API operator altChar * () const;

  ///
  /// \brief  Cast altByte *
  ///
  /// \return Pointer
  ///
  LIBALT_API operator altByte * () const;

  ///
  /// \brief  = operator
  ///
  /// \param  pPtr  [I ] Pointer of altChar
  ///
  /// \return Pointer of altChar
  ///
  LIBALT_API altChar * operator = (altChar * pPtr) ALT_THROWS (alt_t);

  ///
  /// \brief  = operator
  ///
  /// \param  pPtr  [I ] Pointer of altByte
  ///
  /// \return Pointer of altByte
  ///
  LIBALT_API altByte * operator = (altByte * pPtr) ALT_THROWS (alt_t);
};

#endif
