#
# UTF-8 dictionary.
#
#	利用する環境により文字コードが化けてしまう事が有る為、UTF-8 で書いた。
#
#	JIS X 0208/0212 で使用できる物は t も u も付いていない。
#	JIS X 0208/0212 では使用できないが JIS X 0213 で使用できる物は t 付き。
#	JIS X 0208/0212/0213 どれでも使用できず、UCS/Unicode のみの物は u 付き。
#
#	注意：
#	エムダッシュは JIS X 0208/0212 では使用できず JIS X 0213 で使用でき、
#	水平線は JIS X 0208/0212 で使用できるが JIS X 0213 では使用できず、
#	どちらも各々の JIS に於いて同じコード 01区29点(0x213D) に
#	割り当てられていて紛らわしいので、UCS/Unicode のみと設定した。
#
#	備考：
#	JIS X 0213 で使用できる物は、JIS X 0213 EUC-JP でも使用できる。
#	JIS X 0212 で使用できる物は、JIS X 0212 EUC-JP でも使用できる。
#	JIS X 0208 で使用できる物は、JIS X 0208 EUC-JP でも使用できる。
#	JIS X 0208 で使用できる物は、eucJP-MS でも使用できる。
#
#	原作版 Anthy は eucJP-MS のみ対応。
#	iconv版 Anthy は、iconv が対応していれば、JIS X 0208/0212/0213 EUC-JP 全対応。
#
#
#	問題になる文字は、
#	波ダッシュ		JIS X 0208:01区33点	EUC-JP(JIS X 0208):A1C1		UCS/Unicode:U+301C	〜	「&#12316;」
#	FullWidth チルダ	JIS X 0212:02区23点	EUC-JP(JIS X 0212):8FA2B7	UCS/Unicode:U+FF5E	～	「&#65374;」	JIS X 0213 では面区点が違う。
#	FullWidth チルダ	JIS X 0213:1面02区18点	EUC-JP(JIS X 0213):A2B2		UCS/Unicode:U+FF5E	～	「&#65374;」	JIS X 0212 では区点が違う。
#	エムダッシュ		JIS X 0213:1面01区29点	EUC-JP(JIS X 0213):A1BD		UCS/Unicode:U+2014	—	「&#8212;」	JIS X 0212ベースとずれている。こちらが正しい。
#	水平線			JIS X 0208:01区29点	EUC-JP(JIS X 0208):A1BD		UCS/Unicode:U+2015	―	「&#8213;」	JIS X 0213ベースとずれている。こちらは誤り。
#	マイナス記号		JIS X 0208:01区61点	EUC-JP(JIS X 0208):A1DD		UCS/Unicode:U+2212	−	「&#8722;」
#	FullWidth ハイフン	JIS X 0213:1面02区17点	EUC-JP(JIS X 0213):A2B1		UCS/Unicode:U+FF0D	－	「&#65293;」
#	双柱			JIS X 0208:01区34点	EUC-JP(JIS X 0208):A1C2		UCS/Unicode:U+2016	‖	「&#8214;」
#	平行記号		JIS X 0213:1面02区52点	EUC-JP(JIS X 0213):A2D4		UCS/Unicode:U+2225	∥	「&#8741;」
#	セント記号		JIS X 0208:01区81点	EUC-JP(JIS X 0208):A1F1		UCS/Unicode:U+00A2	¢	「&#162;」
#	FullWidth セント記号	JIS:未定義		EUC-JP:未定義			UCS/Unicode:U+FFE0	￠	「&#65504;」
#	ポンド記号		JIS X 0208:01区82点	EUC-JP(JIS X 0208):A1F2		UCS/Unicode:U+00A3	£	「&#163;」
#	FullWidth ポンド記号	JIS:未定義		EUC-JP:未定義			UCS/Unicode:U+FFE1	￡	「&#65505;」
#	否定記号		JIS X 0208:02区44点	EUC-JP(JIS X 0208):A2CC		UCS/Unicode:U+00AC	¬	「&#172;」
#	FullWidth 否定記号	JIS:未定義		EUC-JP:未定義			UCS/Unicode:U+FFE2	￢	「&#65506;」
#	NEC機種依存文字		UCS/Unicode:U+E000〜U+E3AB	「&#57344;」〜「&#58283;」、「とうしょうへい」の「とう」の字とか。
#	です。
#
| #KJ*5 ‖
|t #KJ*5 ∥
~ #KJ*6 〜
~t #KJ*6 ～
〜 #KJ*5 ~
えむだっしゅu #KJ*5 —
えんだっしゅt #KJ*5 –
きごう #KJ*5 ¢
きごう #KJ*5 £
きごう #KJ*5 ¬
きごう #KJ*5 ‖
きごう #KJ*5 −
きごう #KJ*5 〜
きごうt #KJ*5 –
きごうt #KJ*5 ∥
きごうt #KJ*5 －
きごうt #KJ*5 ～
きごうu #KJ*5 —
きごうu #KJ*5 ―
きごうu #KJ*5 ￠
きごうu #KJ*5 ￡
きごうu #KJ*5 ￢
すいへいせんu #KJ*5 ―
すうがくきごう #KJ*5 ¬
すうがくきごうu #KJ*5 ￢
せんと #KJ*5 ¢
せんとu #KJ*5 ￠
そうちゅう #KJ*5 ‖
たんい #KJ*5 ¢
たんい #KJ*5 £
たんいu #KJ*5 ￠
たんいu #KJ*5 ￡
ちるだt #KJ*5 ～
つうか #KJ*5 ¢
つうか #KJ*5 £
つうかu #KJ*5 ￠
つうかu #KJ*5 ￡
とうしょうへいt #JN #_2鄧_6小平
なみだっしゅ #KJ*6 〜
はいふんまいなすt #KJ*5 －
はーとまーくu #T35 ❤
ひてい #KJ*5 ¬
ひていu #KJ*5 ￢
へいこうt #KJ*5 ∥
ぽんど #KJ*5 £
ぽんどu #KJ*5 ￡
まいなす #KJ*5 −
｜ #KJ*5 ‖
｜t #KJ*5 ∥
～ #KJ*5 ~
￣ #KJ*5 〜
￣t #KJ*5 ～
# [ End of File ]
