#!/bin/sh

TARGET="9100h"
WHICH_PATCH="patch13b"

gunzip -c anthy-${TARGET}.tar.gz | tar xf -

cd anthy-${TARGET}/

echo -n "Apply G-HAL's patch ? (Y/n): "
read U_CHOICE

case ${U_CHOICE} in
n|N)
   WHICH_PATCH="default"
      ;;
*)
   WHICH_PATCH="patch13b"
   echo " apply G-HALs patch:"
   bzcat ../anthy-9100h.patch13Bptn20.2009325.bz2 |\
   patch -p1
esac

echo " apply newdep-patch:"
patch -p1 < ../anthy-${TARGET}_${WHICH_PATCH}_newdep.patch
chmod a+x depgraph/mkdepword

echo " copying alt-cannadic:"
rm -rf ./alt-cannadic/
cp -r ../alt-cannadic-090308 ./alt-cannadic
cp ../data/${WHICH_PATCH}/Makefile.* alt-cannadic/
cp -p ../data/${WHICH_PATCH}/corpus_info calctrans/
cp -p ../data/${WHICH_PATCH}/weak_words calctrans/

echo " Done"
