// HotKeyCtrl.h
// (c) 2003 exeal

#ifndef _HOT_KEY_CTRL_H_
#define _HOT_KEY_CTRL_H_
#include "MWindow.h"
#include <commctrl.h>	// HOTKEY_CLASS


namespace Manah {
namespace Windows {
namespace Controls {

// CHotKeyCtrl class definition
/////////////////////////////////////////////////////////////////////////////

class CHotKeyCtrl : CWindow {
	// \bh
public:
	bool				Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT nId);
	bool				CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT nId);

	DWORD				GetHotKey() const;
	void				GetHotKey(WORD& wVirutalKeyCode, WORD& wModifiers) const;
	const TCHAR*		GetHotKeyName() const;
	static const TCHAR*	GetKeyName(UINT nVirtualKey, bool bExtended);
	void				SetHotKey(WORD wVirtualKeyCode, WORD wModifiers);
	void				SetRules(WORD wInvalidCombination, WORD wModifiers);
};


// CHotKeyCtrl class implementation
/////////////////////////////////////////////////////////////////////////////

inline bool CHotKeyCtrl::Create(DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT nId) {
	return CWindow::Create(false, HOTKEY_CLASS, _T(""),
			dwStyle, rect.left, rect.top, rect.right - rect.left,
			rect.bottom - rect.top, hwndParent, 0, 0L);
}

inline bool CHotKeyCtrl::CreateEx(DWORD dwExStyle, DWORD dwStyle, const RECT& rect, HWND hwndParent, UINT nId) {
	return CWindow::CreateEx(false, dwExStyle, HOTKEY_CLASS, _T(""),
			dwStyle, rect.left, rect.top, rect.right - rect.left,
			rect.bottom - rect.top, hwndParent, 0, 0L);
}

inline DWORD CHotKeyCtrl::GetHotKey() const {
	AssertValidAsWindow();
	return ::SendMessage(m_hWnd, HKM_GETHOTKEY, 0, 0L);
}

inline void CHotKeyCtrl::GetHotKey(WORD& wVirtualKeyCode, WORD& wModifiers) const {
	AssertValidAsWindow();
	DWORD	dwKeys = ::SendMessage(m_hWnd, HKM_GETHOTKEY, 0, 0L);
	wVirtualKeyCode = LOWORD(dwKeys);
	wModifiers = HIWORD(dwKeys);
}

inline const TCHAR* CHotKeyCtrl::GetHotKeyName() const {
	AssertValidAsWindow();
	static TCHAR	szHotKeyName[100];
	WORD			wVKey, wModifiers;

	GetHotKey(wVKey, wModifiers);
	szHotKeyName[0] = 0;
	if(toBoolean(wModifiers & HOTKEYF_CONTROL))	_tcscat(szHotKeyName, _T("Ctrl+"));
	if(toBoolean(wModifiers & HOTKEYF_SHIFT))	_tcscat(szHotKeyName, _T("Shift+"));
	if(toBoolean(wModifiers & HOTKEYF_ALT))		_tcscat(szHotKeyName, _T("Alt+"));
	if(toBoolean(wModifiers & HOTKEYF_EXT))		_tcscat(szHotKeyName, _T("Ext+"));
	_tcscat(szHotKeyName, GetKeyName(wVKey, false));

	return szHotKeyName;
}

inline const TCHAR* CHotKeyCtrl::GetKeyName(UINT nVirtualKey, bool bExtended) {
	static TCHAR	szKeyName[50];
	::GetKeyNameText(
		(::MapVirtualKey(nVirtualKey, 0) << 16) |
		((bExtended ? 1 : 0) << 24), szKeyName, 50);
	return szKeyName;
}

inline void CHotKeyCtrl::SetHotKey(WORD wVirtualKeyCode, WORD wModifiers) {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, HKM_SETHOTKEY, MAKEWORD(wVirtualKeyCode, wModifiers), 0L);
}

inline void CHotKeyCtrl::SetRules(WORD wInvalidCombination, WORD wModifiers) {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, HKM_SETRULES, wInvalidCombination, MAKELPARAM(wModifiers, 0));
}

} /* namespace Controls */
} /* namespace Windows */
} /* namespace Manah */

#endif /* _HOT_KEY_CTRL_H_ */

/* [EOF] */