// DraggingTextDataObject.cpp
// (c) 2002-2004 exeal

#include "StdAfx.h"
#include "DraggingTextDataObject.h"
using Armaiti::OLE::CDraggingTextDataObject;
using Armaiti::OLE::CDraggingTextDataObject::CAvailableFormatsEnumerator;


// CDraggingTextDataObject class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CDraggingTextDataObject::CDraggingTextDataObject(
		IDropSource* pDropSource, const TCHAR* lpszText /* = 0 */)
		: m_pDropSource(0), m_hAnsiData(0), m_hUnicodeData(0) {
	VERIFY(pDropSource != 0
		&& SUCCEEDED(pDropSource->QueryInterface(IID_IDropSource, reinterpret_cast<void**>(&m_pDropSource))));
	if(lpszText != 0)
		SetTextData(lpszText);
}

/// fXgN^
CDraggingTextDataObject::~CDraggingTextDataObject() {
	m_pDropSource->Release();
	if(m_hAnsiData != 0)	::GlobalFree(m_hAnsiData);
	if(m_hUnicodeData != 0)	::GlobalFree(m_hUnicodeData);
}

/**
 *	hbOAhhbvJn
 *	@param dwEffect	DoDragDrop Q
 *	@return			
 */
DWORD CDraggingTextDataObject::DoDragDrop(DWORD dwEffect) {
	DWORD	dwEffectOwn;
	HRESULT	hr;

	hr = ::DoDragDrop(static_cast<IDataObject*>(this), m_pDropSource, dwEffect, &dwEffectOwn);
	return SUCCEEDED(hr) ? dwEffectOwn : DROPEFFECT_NONE;
}

/**
 *	݃ZbgĂ镶擾̂ɗp\ȃNbv{[h`̐ݒ
 *	@param setClipFormats	Nbv{[h`̏W
 */
void CDraggingTextDataObject::SetAvailableFormatSet(const set<CLIPFORMAT>& setClipFormats) {
	m_setClipFormats = setClipFormats;
}

/**
 *	null I char* Zbg
 *	@param lpszText	ZbgeLXg
 */
void CDraggingTextDataObject::SetTextData(const char* lpszText) {
	assert(lpszText != 0);

	if(m_hAnsiData != 0) {
		::GlobalFree(m_hAnsiData);
		m_hAnsiData = 0;
	}
	if(m_hUnicodeData != 0) {
		::GlobalFree(m_hUnicodeData);
		m_hUnicodeData = 0;
	}

	m_hAnsiData = ::GlobalAlloc(GHND | GMEM_SHARE, sizeof(char) * (strlen(lpszText) + 1));
	strcpy(static_cast<char*>(::GlobalLock(m_hAnsiData)), lpszText);
	::GlobalUnlock(m_hAnsiData);
	m_setClipFormats.insert(CF_TEXT);
	m_setClipFormats.insert(CF_UNICODETEXT);
}

/**
 *	null I wchar_t* Zbg
 *	@param lpszText	ZbgeLXg
 */
void CDraggingTextDataObject::SetTextData(const wchar_t* lpszText) {
	assert(lpszText != 0);

	if(m_hAnsiData != 0) {
		::GlobalFree(m_hAnsiData);
		m_hAnsiData = 0;
	}
	if(m_hUnicodeData != 0) {
		::GlobalFree(m_hUnicodeData);
		m_hUnicodeData = 0;
	}

	m_hUnicodeData = ::GlobalAlloc(GHND | GMEM_SHARE, sizeof(wchar_t) * (wcslen(lpszText) + 1));
	wcscpy(static_cast<wchar_t*>(::GlobalLock(m_hUnicodeData)), lpszText);
	::GlobalUnlock(m_hUnicodeData);
	m_setClipFormats.insert(CF_TEXT);
	m_setClipFormats.insert(CF_UNICODETEXT);
}

/// @see	IDataObject::DAdvise
STDMETHODIMP CDraggingTextDataObject::DAdvise(LPFORMATETC pformatetc,
		DWORD advf, LPADVISESINK pAdvSink, LPDWORD pdwConnection) {
	return OLE_E_ADVISENOTSUPPORTED;
}

/// @see	IDataObject::DUnadvise
STDMETHODIMP CDraggingTextDataObject::DUnadvise(DWORD dwConnection) {
	return OLE_E_ADVISENOTSUPPORTED;
}

/// @see	IDataObject::EnumDAdvise
STDMETHODIMP CDraggingTextDataObject::EnumDAdvise(LPENUMSTATDATA* ppenumAdvise) {
	return OLE_E_ADVISENOTSUPPORTED;
}

/// @see	IDataObject::EnumFormatEtc
// MSDEV .NET Ƃ͂̃\bhgĂ
STDMETHODIMP CDraggingTextDataObject::EnumFormatEtc(DWORD dwDirection, LPENUMFORMATETC* ppenumFormatEtc) {
	if(dwDirection == DATADIR_SET)
		return E_NOTIMPL;
	else if(ppenumFormatEtc == 0)
		return E_INVALIDARG;

	*ppenumFormatEtc = new CAvailableFormatsEnumerator(m_setClipFormats);
	if(*ppenumFormatEtc != 0)
		return (*ppenumFormatEtc)->AddRef(), S_OK;
	return E_OUTOFMEMORY;
}

/// @see	IDataObject::GetCanonicalFormatEtc
STDMETHODIMP CDraggingTextDataObject::GetCanonicalFormatEtc(LPFORMATETC pformatectIn, LPFORMATETC pformatetcOut) {
	return DATA_S_SAMEFORMATETC;
}

/// @see	IDataObject::GetData
STDMETHODIMP CDraggingTextDataObject::GetData(LPFORMATETC pformatetcIn, LPSTGMEDIUM pmedium) {
	if(pformatetcIn == 0 || pmedium == 0)
		return E_INVALIDARG;
	if(m_hAnsiData == 0 && m_hUnicodeData == 0)
		return OLE_E_NOTRUNNING;
	if((pformatetcIn->cfFormat != CF_TEXT && pformatetcIn->cfFormat != CF_UNICODETEXT)
			|| pformatetcIn->dwAspect != DVASPECT_CONTENT
			|| pformatetcIn->lindex != -1
			|| !toBoolean(pformatetcIn->tymed & TYMED_HGLOBAL))
		return DV_E_FORMATETC;

	// vꂽ`̃f[^܂ꍇ
	if(pformatetcIn->cfFormat == CF_TEXT && m_hAnsiData == 0) {
		const wchar_t*	pwsz = static_cast<const wchar_t*>(::GlobalLock(m_hUnicodeData));
		int				cch = ::WideCharToMultiByte(CP_ACP, 0, pwsz, -1, 0, 0, 0, 0);
		m_hAnsiData = ::GlobalAlloc(GHND | GMEM_SHARE, sizeof(char) * cch);
		::WideCharToMultiByte(CP_ACP, 0, pwsz, -1, static_cast<char*>(::GlobalLock(m_hAnsiData)), cch, 0, 0);
		::GlobalUnlock(m_hAnsiData);
	} else if(pformatetcIn->cfFormat == CF_UNICODETEXT && m_hUnicodeData == 0) {
		const char*	psz = static_cast<const char*>(::GlobalLock(m_hAnsiData));
		int			cch = ::MultiByteToWideChar(CP_ACP, 0, psz, -1, 0, 0);
		m_hUnicodeData = ::GlobalAlloc(GHND | GMEM_SHARE, sizeof(wchar_t) * cch);
		::MultiByteToWideChar(CP_ACP, 0, psz, -1, static_cast<wchar_t*>(::GlobalLock(m_hUnicodeData)), cch);
		::GlobalUnlock(m_hUnicodeData);
	}

	pmedium->tymed = TYMED_HGLOBAL;
	pmedium->hGlobal = (pformatetcIn->cfFormat == CF_TEXT) ? m_hAnsiData : m_hUnicodeData;
	pmedium->pUnkForRelease = 0;

	return S_OK;
}

/// @see	IDataObject::GetDataHere
STDMETHODIMP CDraggingTextDataObject::GetDataHere(LPFORMATETC pformatetc, LPSTGMEDIUM pmedium) {
	return E_NOTIMPL;
}

/// @see	IDataObject::QueryGetData
STDMETHODIMP CDraggingTextDataObject::QueryGetData(LPFORMATETC pformatetc) {
	if(pformatetc == 0)
		return E_INVALIDARG;
	if(m_setClipFormats.find(pformatetc->cfFormat) == m_setClipFormats.end())
		return DV_E_FORMATETC;
	if(m_hAnsiData == 0 && m_hUnicodeData == 0)
		return OLE_E_NOTRUNNING;
	if(pformatetc->lindex != -1)
		return DV_E_LINDEX;
	if(!toBoolean(pformatetc->tymed & TYMED_HGLOBAL))
		return DV_E_TYMED;
	if(pformatetc->dwAspect != DVASPECT_CONTENT)
		return DV_E_DVASPECT;

	return S_OK;
}

/// @see	IDataObject::SetData
STDMETHODIMP CDraggingTextDataObject::SetData(LPFORMATETC pformatetc, LPSTGMEDIUM pmedium, BOOL fRelease) {
	return E_NOTIMPL;
}


// CAvailableFormatsEnumerator class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CAvailableFormatsEnumerator::CAvailableFormatsEnumerator(
		const set<CLIPFORMAT>& setFormats) : m_psetClipFormats(&setFormats) {
	Reset();
}

/// Rs[RXgN^
CAvailableFormatsEnumerator::CAvailableFormatsEnumerator(const CAvailableFormatsEnumerator& rhs) {
	m_psetClipFormats = rhs.m_psetClipFormats;
	m_it = rhs.m_it;
}

/// @see	IEnumFORMATETC::Clone
STDMETHODIMP CAvailableFormatsEnumerator::Clone(IEnumFORMATETC** ppenum) {
	if(ppenum == 0)
		return E_INVALIDARG;

	*ppenum = new CAvailableFormatsEnumerator(*this);
	if(*ppenum != 0)
		return (*ppenum)->AddRef(), S_OK;
	return E_OUTOFMEMORY;
}

/// @see	IEnumFORMATETC::Next
STDMETHODIMP CAvailableFormatsEnumerator::Next(ULONG celt, FORMATETC* rgelt, ULONG* pceltFetched) {
	if(celt > 1 && pceltFetched == 0)
		return E_INVALIDARG;

	ULONG	cFetched = 0;
	while(cFetched < celt && m_it != m_psetClipFormats->end()) {
		rgelt[cFetched].cfFormat = *m_it;
		rgelt[cFetched].ptd = 0;
		rgelt[cFetched].dwAspect = DVASPECT_CONTENT;
		rgelt[cFetched].lindex = -1;
		rgelt[cFetched].tymed = TYMED_HGLOBAL;
		++cFetched;
		++m_it;
	}
	if(pceltFetched != 0)
		*pceltFetched = cFetched;

	return (cFetched == celt) ? S_OK : S_FALSE;
}

/// @see	IEnumFORMATETC::Reset
STDMETHODIMP CAvailableFormatsEnumerator::Reset() {
	m_it = m_psetClipFormats->begin();
	return S_OK;
}

/// @see	IEnumFORMATETC::Skip
STDMETHODIMP CAvailableFormatsEnumerator::Skip(ULONG celt) {
	while(celt != 0 && m_it != m_psetClipFormats->end())
		++m_it;
	return (celt == 0) ? S_OK : S_FALSE;
}

/* [EOF] */