// ArmaitiImplementation.h
// (c) 2002-2004 exeal
/////////////////////////////////////////////////////////////////////////////

#ifndef _ARMAITI_IMPLEMENTATION_H_
#define _ARMAITI_IMPLEMENTATION_H_

#include <objbase.h>
#include <cassert>
#include <map>
#include <stdexcept>


// }NƂ
/////////////////////////////////////////////////////////////////////////////

#define RETURN_IF_FAILED(hr)	\
	if(FAILED(hr))				\
		return (hr)

#define VERIFY_POINTER(p)	\
	if((p) == 0)			\
		return E_POINTER

inline VARIANT_BOOL toVariantBoolean(bool b) {
	return b ? VARIANT_TRUE : VARIANT_FALSE;
}


namespace Armaiti {

// IUnknownImpl ̂߂3̃|V[NX
/////////////////////////////////////////////////////////////////////////////

/// QƃJEggpȂ
class CUnheapMemoryManageModel {
public:
	CUnheapMemoryManageModel() {}
	ULONG AddRef() {return 2;}
	ULONG Release() {return 1;}
private:
	CUnheapMemoryManageModel(const CUnheapMemoryManageModel&);
	operator =(CUnheapMemoryManageModel&);
};

/// PȎQƃJEggp
class CSingleThreadMemoryManageModel {
public:
	CSingleThreadMemoryManageModel() : m_cRef(0) {}
	ULONG AddRef() {return ++m_cRef;}
	ULONG Release() {return --m_cRef;}
private:
	LONG	m_cRef;
	CSingleThreadMemoryManageModel(const CSingleThreadMemoryManageModel&);
	operator =(const CSingleThreadMemoryManageModel&);
};

/// QƃJEg̑XbhZ[t
class CMultiThreadMemoryManageModel {
public:
	CMultiThreadMemoryManageModel() : m_cRef(0) {}
	ULONG AddRef() {return ::InterlockedIncrement(&m_cRef);}
	ULONG Release() {return ::InterlockedDecrement(&m_cRef);}
private:
	LONG	m_cRef;
	CMultiThreadMemoryManageModel(const CSingleThreadMemoryManageModel&);
	operator =(const CMultiThreadMemoryManageModel&);
};


// IUnknownImpl class definitions and implementations
/////////////////////////////////////////////////////////////////////////////

/// IUnknown ̎
template<class MemoryManageModel>
class IUnknownImpl {
	// RXgN^
public:
	///	RXgN^
	IUnknownImpl() {/* do nothing */}
	///	fXgN^
	virtual ~IUnknownImpl() {/* do nothing */}
private:
	IUnknownImpl(const IUnknownImpl&);

	// Zq
private:
	operator =(const IUnknownImpl&);

	// f[^o
protected:
	MemoryManageModel	mmm;	// Ǘf
};

#define IMPLEMENT_UNKNOWN()				\
	STDMETHODIMP_(ULONG)	AddRef() {	\
		return mmm.AddRef();			\
	}									\
	STDMETHODIMP_(ULONG)	Release() {	\
		LONG	cRef = mmm.Release();	\
		if(cRef == 0)					\
			delete this;				\
		return cRef;					\
	}

#define BEGIN_INTERFACE_TABLE()										\
	STDMETHODIMP	QueryInterface(REFIID riid, void** ppvObject) {	\
		if(ppvObject == 0)											\
			return E_POINTER;

#define END_INTERFACE_TABLE()								\
		else												\
			return (*ppvObject = 0), E_NOINTERFACE;			\
		reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();	\
		return S_OK;										\
	}

#define IMPLEMENTS_INTERFACE(InterfaceName)					\
		else if(riid == IID_##InterfaceName)				\
			*ppvObject = static_cast<InterfaceName*>(this);

#define IMPLEMENTS_LEFTMOST_INTERFACE(InterfaceName)					\
		else if(riid == IID_##InterfaceName || riid == IID_IUnknown)	\
			*ppvObject = static_cast<InterfaceName*>(this);


// CComPtr class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// CComPtr::operator-> Ԃ AddRef ARelease Ăяo֎~vLV
template<class T>
class CComPtrProxy : public T {
	// \bh
private:
	STDMETHOD_(ULONG, AddRef)() = 0;
	STDMETHOD_(ULONG, Release)() = 0;
//
//	// Zq
//private:
//	void	operator delete(void*);
};

/// COM X}[g|C^
template<class T>
class CComPtr {
	// RXgN^
public:
	///	RXgN^
	explicit CComPtr(T* p = 0) : m_pointee(p) {
		if(m_pointee != 0)
			m_pointee->AddRef();
	}
	///	Rs[RXgN^
	explicit CComPtr(const CComPtr<T>& rhs) : m_pointee(rhs.m_pointee) {
		if(m_pointee != 0)
			m_pointee->AddRef();
	}
	///	fXgN^
	virtual ~CComPtr() {
		if(m_pointee != 0)
			m_pointee->Release();
	}

	// Zq
public:
	/**
	 *	@brief	QƉZq
	 *	̉Zq̌ʂ͏o͈ƂĂ̂ݎgpB
	 *	ZqĂяoɃIuWFNg null łȂ΁A
	 *	O̒l Release 
	 */
	T** operator &() {
		if(m_pointee != 0)
			m_pointee->Release();
		return static_cast<T**>(&m_pointee);
	}

	///	oANZXZq
	CComPtrProxy<T>* operator ->() const {
		assert(m_pointee != 0);
		return static_cast<CComPtrProxy<T>*>(m_pointee);
	}
//	T& operator *() const {
//		assert(m_pointee != 0);
//		return *m_pointee;
//	}

	/**
	 *	@brief	Zq
	 *	<var>p</var>  null ł悢
	 */
	CComPtr<T>& operator =(T* p) {
		if(m_pointee != p) {
			if(m_pointee != 0)
				m_pointee->Release();
			m_pointee = p;
			if(m_pointee != 0)
				m_pointee->AddRef();
		}
		return *this;
	}

	///	Zq
	template<class I>
	CComPtr<T>& operator =(const CComPtr<I>& rhs) {
		if(this != &rhs) {
			if(m_pointee != 0)
				m_pointee->Release();
			m_pointee = rhs.m_pointee;
			m_pointee->AddRef();
		}
		return *this;
	}

	///	Zq
	bool operator ==(const T* p) const {
		return m_pointee == p;
	}

	///	sZq
	bool operator !=(const T* p) const {
		return m_pointee != p;
	}

	///	̃|C^^ւ̃LXg
	operator T*() const {
		return static_cast<T*>(m_pointee);
	}

	// \bh
public:
	///	::CoCreateInstance ɂIuWFNg
	HRESULT CreateInstance(REFCLSID rclsid,
			IUnknown* pUnkOuter = 0, DWORD dwClsContext = CLSCTX_ALL, REFIID riid = __uuidof(T)) {
		assert(m_pointee == 0);
		return ::CoCreateInstance(rclsid, pUnkOuter, dwClsContext, riid, reinterpret_cast<void**>(&m_pointee));
	}

	///	<var>p</var> ƓIuWFNgǂԂ
	bool IsEqualObject(IUnknown* p) const {
		if(m_pointee == 0 && p == 0)
			return true;
		else if(m_pointee == 0 || p == 0)
			return false;

		IUnknown*	p1 = 0;
		IUnknown*	p2 = 0;
		bool		b;

		m_pointee->QueryInterface(IID_IUnknown, reinterpret_cast<void**>(p1));
		p->QueryInterface(IID_IUnknown, reinterpret_cast<void**>(p2));
		b = p1 == p2;
		p1->Release();
		p2->Release();

		return b;
	}

	/**
	 *	@see		IUnknown::QueryInterface
	 *	@param pp	[out] LXg
	 */
	template<class I>
	HRESULT QueryInterface(I** pp) const {
		assert(m_pointee != 0);
		if(pp == 0)
			return E_POINTER;
		return m_pointee->QueryInterface(__uuidof(I), reinterpret_cast<void**>(pp));
	}

	// f[^o
private:
	T*	m_pointee;
};


// CComException class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	@brief	IErrorInfo  C++ OƂĈ߂̃bpNX
 *	o: Essential COM (Don Box)
 */
class CComException {
	// RXgN^
public:
	/**
	 *	RXgN^
	 *	@param hResult			SCODE
	 *	@param riid				IID
	 *	@param pwszSource		̗O𓊂NX
	 *	@param pwszDescription	O̐Bnull ̏ꍇ <var>hResult</var> 擾
	 *	@param pwszHelpFile		wvt@C̃pX
	 *	@param dwHelpContext	wvgsbN̔ԍ
	 */
	CComException(
			HRESULT hResult,
			REFIID riid,
			const OLECHAR* pwszSource,			// class threw this exception
			const OLECHAR* pwszDescription = 0,	// description of this error (set null to obtain from hResult)
			const OLECHAR* pwszHelpFile = 0,
			DWORD dwHelpContext = 0) {
		HRESULT				hr;
		ICreateErrorInfo*	pcei = 0;

		assert(FAILED(hResult));

		hr = ::CreateErrorInfo(&pcei);
		assert(SUCCEEDED(hr));

		hr = pcei->SetGUID(riid);
		assert(SUCCEEDED(hr));
		if(pwszSource != 0) {
			hr = pcei->SetSource(const_cast<OLECHAR*>(pwszSource));
			assert(SUCCEEDED(hr));
		}
		if(pwszDescription != 0) {
			hr = pcei->SetDescription(const_cast<OLECHAR*>(pwszDescription));
			assert(SUCCEEDED(hr));
		} else {
			BSTR	bstrDescription = 0;
			CComException::GetDescriptionOfSCode(hResult, bstrDescription);
			hr = pcei->SetDescription(bstrDescription);
			::SysFreeString(bstrDescription);
			assert(SUCCEEDED(hr));
		}
		if(pwszHelpFile != 0) {
			hr = pcei->SetHelpFile(const_cast<OLECHAR*>(pwszHelpFile));
			assert(SUCCEEDED(hr));
		}
		hr = pcei->SetHelpContext(dwHelpContext);
		assert(SUCCEEDED(hr));

		m_hResult = hResult;
		hr = pcei->QueryInterface(IID_IErrorInfo, reinterpret_cast<void**>(&m_pErrorInfo));
		assert(SUCCEEDED(hr));
		pcei->Release();
	}
	/// fXgN^
	virtual ~CComException() {
		if(m_pErrorInfo != 0)
			m_pErrorInfo->Release();
	}

	// \bh
public:
	/// G[ IErrorInfo Ԃ
	void	GetErrorInfo(IErrorInfo** pErrorInfo) const {
		assert(pErrorInfo != 0);
		*pErrorInfo = m_pErrorInfo;
		(*pErrorInfo)->AddRef();
	}

	///	G[ HRESULT Ԃ
	HRESULT	GetSCode() const {
		return m_hResult;
	}

	/// OIuWFNg_XbhOƂē
	void	ThrowLogicalThreadError() {
		::SetErrorInfo(0, m_pErrorInfo);
	}

	/**
	 *	HRESULT ɑΉG[bZ[WԂ
	 *	@param hResult			[in] HRESULT
	 *	@param bstrDescription	[out] G[bZ[W
	 *	@param dwLanguage		[in]  ID
	 */
	static void GetDescriptionOfSCode(HRESULT hResult,
			BSTR& bstrDescription, DWORD dwLanguageId = MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT)) {
		void*	pwszDescription = 0;

		FormatMessageW(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			0, hResult, dwLanguageId, reinterpret_cast<wchar_t*>(&pwszDescription), 0, 0);
		bstrDescription = ::SysAllocString(reinterpret_cast<OLECHAR*>(pwszDescription));
		::LocalFree(pwszDescription);
	}

	// f[^o
private:
	HRESULT		m_hResult;
	IErrorInfo*	m_pErrorInfo;

};


// ISupportErrorInfoImpl class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// ISupportErrorInfo ̕WIȎ
template<const IID* piid>
class ISupportErrorInfoImpl : public ISupportErrorInfo {
	STDMETHODIMP	InterfaceSupportsErrorInfo(REFIID riid) {
		return (riid == *piid) ? S_OK : S_FALSE;
	}
};


namespace OLE {

// CComBSTR class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// BSTR ̃bp
/// @see	comutil.h  _bstr_t NX
class CComBSTR {
	// RXgN^
public:
	///	RXgN^
	/// OLE 񂩂珉B
	explicit CComBSTR(const OLECHAR* psz = 0) : m_bstr(::SysAllocString(psz)) {
	}
	///	RXgN^B
	///	ANSI 񂩂珉
	explicit CComBSTR(const char* psz) {
		if(psz != 0) {
			int			cch = ::MultiByteToWideChar(CP_ACP, 0, psz, -1, 0, 0);
			wchar_t*	pwsz = new wchar_t[cch + 1];
			::MultiByteToWideChar(CP_ACP, 0, psz, -1, pwsz, cch);
			m_bstr = ::SysAllocString(pwsz);
			delete[] pwsz;
		} else
			m_bstr = 0;
	}
	///	RXgN^B
	///	ɕϊ\ VARIANT 珉
	explicit CComBSTR(const VARIANT& var) {
		if(var.vt == VT_BSTR)
			m_bstr = ::SysAllocString(var.bstrVal);
		else {
			VARIANT	var_;
			::VariantChangeType(&var_, const_cast<VARIANT*>(&var), 0, VT_BSTR);
			m_bstr = ::SysAllocString(var_.bstrVal);
			::SysFreeString(var_.bstrVal);
		}
	}
	/// Rs[RXgN^
	explicit CComBSTR(const CComBSTR& rhs) {
		m_bstr = ::SysAllocString(rhs.m_bstr);
	}
	/// fXgN^
	~CComBSTR() {
		if(m_bstr != 0)
			::SysFreeString(m_bstr);
	}

	// Zq
public:
	/// Zq
	bool	operator	==(const CComBSTR& rhs) const {
		return wcscmp(_SafeString(m_bstr), _SafeString(rhs.m_bstr)) == 0;
	}
	///	񓙉Zq
	bool	operator	!=(const CComBSTR& rhs) const {
		return !operator ==(rhs);
	}
	/// QƉZq
	BSTR*	operator	&() {
		if(m_bstr != 0)
			::SysFreeString(m_bstr);
		return &m_bstr;
	}
	friend bool	operator ==(const CComBSTR& lhs, const OLECHAR* rhs);
	friend bool	operator !=(const CComBSTR& lhs, const OLECHAR* rhs);

	// \bh
public:
	/// BSTR Ԃ
	const BSTR	GetBSTR() const {
		return m_bstr;
	}
	/// 󕶎񂩂ǂԂ
	bool IsEmpty() const {
		return m_bstr == 0 || wcslen(m_bstr) == 0;
	}
	/// ̒Ԃ
	size_t	Length() const {
		return (m_bstr != 0) ? wcslen(m_bstr) : 0;
	}
protected:
	static OLECHAR*	_SafeString(BSTR bstr) {
		return (bstr != 0) ? bstr : OLESTR("");
	}

	// f[^o
private:
	BSTR	m_bstr;
};

/// CComBSTR ̓Zq
inline bool operator ==(const CComBSTR& lhs, const OLECHAR* rhs) {
	assert(rhs != 0);
	return wcscmp(CComBSTR::_SafeString(lhs.m_bstr), rhs) == 0;
}

/// CComBSTR ̔񓙉Zq
inline bool operator !=(const CComBSTR& lhs, const OLECHAR* rhs) {
	return !operator ==(lhs, rhs);
}


// CComVariant class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// VARIANT AVARIANTARG ̃bp
/// @see	comutil.h  _variant_t NX
class CComVariant : public tagVARIANT {
	// RXgN^
public:
	CComVariant() {
		vt = VT_EMPTY;
	}
	CComVariant(const CComVariant& var) {
		vt = VT_EMPTY;
		Copy(&var);
	}
	CComVariant(const tagVARIANT& var) {
		vt = VT_EMPTY;
		Copy(&var);
	}
	CComVariant(const OLECHAR* psz) {
		vt = VT_EMPTY;
		*this = psz;
	}
	CComVariant(const BSTR bstr) {
		vt = VT_EMPTY;
		*this = bstr;
	}
	CComVariant(bool b) {
		vt = VT_BOOL;
		boolVal = b ? VARIANT_TRUE : VARIANT_FALSE;
	}
	CComVariant(int n) {
		vt = VT_I4;
		lVal = n;
	}
	CComVariant(unsigned int n) {
		vt = VT_UI4;
		ulVal = n;
	}
	CComVariant(BYTE bt) {
		vt = VT_UI1;
		bVal = bt;
	}
	CComVariant(short n) {
		vt = VT_I2;
		iVal = n;
	}
	CComVariant(unsigned short n) {
		vt = VT_UI2;
		uiVal = n;
	}
	CComVariant(long n, VARTYPE vtSrc = VT_I4) {
		assert(vtSrc == VT_I4 || vtSrc == VT_EMPTY);
		vt = vtSrc;
		lVal = n;
	}
	CComVariant(unsigned long n) {
		vt = VT_UI4;
		ulVal = n;
	}
	CComVariant(float n) {
		vt = VT_R4;
		fltVal = n;
	}
	CComVariant(double n) {
		vt = VT_R8;
		dblVal = n;
	}
	CComVariant(CY cy) {
		vt = VT_CY;
		cyVal.Hi = cy.Hi;
		cyVal.Lo = cy.Lo;
	}
	CComVariant(const IDispatch* pDisp) {
		vt = VT_DISPATCH;
		pdispVal = const_cast<IDispatch*>(pDisp);
		if(pdispVal != 0)
			pdispVal->AddRef();
	}
	CComVariant(const IUnknown* pUnk) {
		vt = VT_UNKNOWN;
		punkVal = const_cast<IUnknown*>(pUnk);
		if(punkVal != 0)
			punkVal->AddRef();
	}
	virtual ~CComVariant() {
		Clear();
	}

	// \bh
public:
	///	A^b`
	HRESULT Attach(const VARIANT* pVar) {
		HRESULT hr = Clear();
		if(SUCCEEDED(hr)) {
			memcpy(this, pVar, sizeof(VARIANT));
			vt = VT_EMPTY;
		}
		return hr;
	}

	///	^ύX
	HRESULT ChangeType(VARTYPE vt, const VARIANT* pSrc = 0) {
		return ::VariantChangeType(this, (pSrc == 0) ? this : const_cast<VARIANT*>(pSrc), 0, vt);
	}

	///	
	HRESULT Clear() {
		return ::VariantClear(this);
	}

	///	Rs[
	HRESULT Copy(const VARIANT* pSrc) {
		HRESULT hr = ::VariantCopy(this, const_cast<VARIANT*>(pSrc));
		if(FAILED(hr))
			vt = VT_ERROR, scode = hr;
		return hr;
	}

	///	f^b`
	HRESULT Detach(VARIANT* pVar) {
		HRESULT hr = ::VariantClear(pVar);
		if(SUCCEEDED(hr)) {
			memcpy(pVar, this, sizeof(VARIANT));
			vt = VT_EMPTY;
		}
		return hr;
	}

/*	HRESULT ReadFromStream(IStream* pStream) {
		return E_NOTIMPL;
	}

	HRESULT WriteToStream(IStream* pStream) {
		return E_NOTIMPL;
	}
*/
	// Zq
public:
	CComVariant& operator =(const CComVariant& var) {
		Copy(&var);
		return *this;
	}
	CComVariant& operator =(const tagVARIANT& var) {
		Copy(&var);
		return *this;
	}
	CComVariant& operator =(const OLECHAR* psz) {
		Clear();
		vt = VT_BSTR;
		bstrVal = ::SysAllocString(psz);
		if(bstrVal == 0 && psz != 0)
			vt = VT_ERROR, scode = E_OUTOFMEMORY;
		return *this;
	}
	CComVariant& operator =(const BSTR bstr) {
		Clear();
		vt = VT_BSTR;
		bstrVal = ::SysAllocString(bstr);
		if(bstrVal == 0 && bstr != 0)
			vt = VT_ERROR, scode = E_OUTOFMEMORY;
		return *this;
	}
	CComVariant& operator =(bool b) {
		if(vt != VT_BOOL)
			Clear(), vt = VT_BOOL;
		boolVal = b ? VARIANT_TRUE : VARIANT_FALSE;
		return *this;
	}
	CComVariant& operator =(int n) {
		if(vt != VT_I4)
			Clear(), vt = VT_I4;
		lVal = n;
		return *this;
	}
	CComVariant& operator =(BYTE bt) {
		if(vt != VT_UI1)
			Clear(), vt = VT_UI1;
		bVal = bt;
		return *this;
	}
	CComVariant& operator =(short n) {
		if(vt != VT_I2)
			Clear(), vt = VT_I2;
		iVal = n;
		return *this;
	}
	CComVariant& operator =(long n) {
		if(vt != VT_I4)
			Clear(), vt = VT_I4;
		lVal = n;
		return *this;
	}
	CComVariant& operator =(float n) {
		if(vt != VT_R4)
			Clear(), vt = VT_R4;
		fltVal = n;
		return *this;
	}
	CComVariant& operator =(double n) {
		if(vt != VT_R8)
			Clear(), vt = VT_R8;
		dblVal = n;
		return *this;
	}
	CComVariant& operator =(CY cy) {
		if(vt != VT_CY)
			Clear(), vt = VT_CY;
		cyVal.Hi = cy.Hi;
		cyVal.Lo = cy.Lo;
		return *this;
	}
	CComVariant& operator =(const IDispatch* pDisp) {
		Clear(), vt = VT_DISPATCH;
		pdispVal = const_cast<IDispatch*>(pDisp);
		if(pdispVal != 0)
			pdispVal->AddRef();
		return *this;
	}
	CComVariant& operator =(const IUnknown* pUnk) {
		Clear(), vt = VT_UNKNOWN;
		punkVal = const_cast<IUnknown*>(pUnk);
		if(punkVal != 0)
			punkVal->AddRef();
		return *this;
	}
	bool operator ==(const VARIANT& var) const {
		if(this == &var)
			return true;
		if(vt != var.vt)
			return false;
		switch(vt) {
		case VT_EMPTY:		return true;
		case VT_NULL:		return true;
		case VT_I2:			return iVal == var.iVal;
		case VT_I4:			return lVal == var.lVal;
		case VT_R4:			return fltVal == var.fltVal;
		case VT_R8:			return dblVal == var.dblVal;
		case VT_CY:			return memcmp(&cyVal, &var.cyVal, sizeof(CY)) == 0;
		case VT_DATE:		return date == var.date;
		case VT_BSTR:		return (::SysStringByteLen(bstrVal) == ::SysStringByteLen(var.bstrVal))
									&& (memcmp(bstrVal, var.bstrVal, ::SysStringByteLen(bstrVal)) == 0);
		case VT_DISPATCH:	return pdispVal == var.pdispVal;
		case VT_ERROR:		return scode == var.scode;
		case VT_BOOL:		return boolVal == var.boolVal;
		case VT_VARIANT:	return pvarVal == var.pvarVal;
		case VT_UNKNOWN:	return punkVal == var.punkVal;
		case VT_DECIMAL:	return memcmp(&decVal, &var.decVal, sizeof(DECIMAL)) == 0;
//		case VT_I1:			return cVal == var.cVal;
//		case VT_UI1:		return ;
		case VT_UI2:		return uiVal == var.uiVal;
		case VT_UI4:		return ulVal == var.ulVal;
//		case VT_I8:			return ;
//		case VT_UI8:		return ;
		case VT_INT:		return intVal == var.intVal;
		case VT_UINT:		return uintVal == var.uintVal;
		case VT_VOID:		return true;
		}
		return false;
	}
	bool operator !=(const VARIANT& var) const {
		return operator==(var);
	}
//	bool operator <(const VARIANT& var) {	// ??? comparison of VARIANT is not available now.
//		return (::VarCmp(this, const_cast<VARIANT*>(&var), LOCALE_USER_DEFAULT) == VARCMP_LT);
//	}
//	bool operator >(const VARIANT& var) {
//		return (::VarCmp(this, const_cast<VARIANT*>(&var), LOCALE_USER_DEFAULT) == VARCMP_GT);
//	}
	operator bool() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_BOOL);
		return (varDest.boolVal != 0);
	}
	operator BYTE() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_UI1);
		return varDest.bVal;
	}
	operator short() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_I2);
		return varDest.iVal;
	}
	operator int() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_I4);
		return varDest.lVal;
	}
	operator long() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_I4);
		return varDest.lVal;
	}
	operator float() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_R4);
		return varDest.fltVal;
	}
	operator double() const {	// DATE
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_R8);
		return varDest.dblVal;
	}
	operator CY() const {
		VARIANT	varDest;
		::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_CY);
		return varDest.cyVal;
	}
/*	operator CComBSTR() const {	// BSTR
		CComBSTR	str;
		VARIANT		varDest;
		wchar_t		wszDump[22];

		varDest.vt = VT_BSTR;
		if(vt == VT_BSTR)
			str = bstrVal;
		else if(vt == VT_UNKNOWN) {
			swprintf(wszDump, L"[IUnknown*]$0x%08lX", reinterpret_cast<long>(punkVal));
			str = wszDump;
		} else if(vt == VT_DISPATCH) {
			swprintf(wszDump, L"[IDispatch*]$0x%08lX", reinterpret_cast<long>(pdispVal));
			str = wszDump;
		} else {	// numeric compatible
			varDest.bstrVal = ::SysAllocStringLen(0, 100);
			::VariantChangeType(&varDest, const_cast<CComVariant*>(this), 0, VT_BSTR);
			str = varDest.bstrVal;
			::SysFreeString(varDest.bstrVal);
		}

		return str;
	}
*/	operator IDispatch*() const {
		return (vt == VT_DISPATCH) ? pdispVal : 0;
	}
	operator IUnknown*() const {
		if(vt == VT_UNKNOWN)
			return punkVal;
		else if(vt == VT_DISPATCH)
			return static_cast<IUnknown*>(pdispVal);
		else
			return 0;
	}
};


// IProvideClassInfo2Impl class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	IProvideClassInfo2 ̊{IȎ
 *	@param pclsid	CLSID
 *	@param piid		IID
 *	@param plibid	LIBID
 *	@param wMajor	W[o[W
 *	@param wMinor	}Ci[o[W
 */
template<const CLSID* pclsid, const IID* piid, const GUID* plibid, WORD wMajor = 1, WORD wMinor = 0>
class IProvideClassInfo2Impl : public IProvideClassInfo2 {
	// RXgN^
public:
	/// RXgN^
	IProvideClassInfo2Impl() : m_pTypeInfo(0) {
		CComPtr<ITypeLib>	pTypeLib;
		HRESULT				hr;

		hr = ::LoadRegTypeLib(*plibid, wMajor, wMinor, 0, &pTypeLib);
		assert(SUCCEEDED(hr));
		pTypeLib->GetTypeInfoOfGuid(*piid, &m_pTypeInfo);
		assert(SUCCEEDED(hr));
	}
	/// fXgN^
	virtual ~IProvideClassInfo2Impl() {
		if(m_pTypeInfo != 0)
			m_pTypeInfo->Release();
	}

	// \bh
public:
	///	@see	IProvideClassInfo::GetClassInfo
	STDMETHOD(GetClassInfo)(ITypeInfo** ppTypeInfo) {
		if(ppTypeInfo == 0)
			return E_POINTER;
		*ppTypeInfo = m_pTypeInfo;
		(*ppTypeInfo)->AddRef();
		return S_OK;
	}

	///	@see	IProvideClassInfo2::GetGUID
	STDMETHOD(GetGUID)(DWORD dwGuidKind, GUID* pGUID) {
		if(pGUID == 0)
			return E_POINTER;
		if(dwGuidKind == GUIDKIND_DEFAULT_SOURCE_DISP_IID && pclsid != 0) {
			*pGUID = iid;
			return S_OK;
		}
		*pGUID = 0;
		return E_INVALIDARG;
	}

	// f[^o
private:
	ITypeInfo*	m_pTypeInfo;
};


// IDispatchImpl NX̂߂2̃|V[NX
/////////////////////////////////////////////////////////////////////////////

/**
 *	LIBID ^CvCu[h
 *	@param plibid	^CvCu LIBID
 *	@param piid		IID
 *	@param wMajor	W[o[W
 *	@param wMinor	}Ci[o[W
 */
template<const GUID* plibid, const IID* piid, WORD wMajor = 1, WORD wMinor = 0>
class CRegTypeLibTypeInfoHolder {
public:
	/// RXgN^
	CRegTypeLibTypeInfoHolder() {
		CComPtr<ITypeLib>	pTypeLib;
		HRESULT				hr;

		assert(plibid != 0 && piid != 0);
		hr = ::LoadRegTypeLib(*plibid, wMajor, wMinor, 0, &pTypeLib);
		assert(SUCCEEDED(hr));
		hr = pTypeLib->GetTypeInfoOfGuid(*piid, &m_pTypeInfo);
		assert(SUCCEEDED(hr));
	}
	/// fXgN^
	virtual ~CRegTypeLibTypeInfoHolder() {
		if(m_pTypeInfo != 0)
			m_pTypeInfo->Release();
	}
	/// ITypeInfo CX^XԂ
	ITypeInfo*	GetTypeInfo() const {
		return m_pTypeInfo;
	}
private:
	ITypeInfo*	m_pTypeInfo;
};

/**
 *	ڃpXw肵ă^CvCu[h
 *	@param TypeLibPath	^CvCũpX񋟂NX
 *	@param piid			IID
 */
template<class TypeLibPath, const IID* piid>
class CPathTypeLibTypeInfoHolder {
public:
	/// RXgN^
	CPathTypeLibTypeInfoHolder() {
		CComPtr<ITypeLib>	pTypeLib;
		HRESULT				hr;

		hr = ::LoadTypeLib(TypeLibPath::GetPath(), &pTypeLib);
		assert(SUCCEEDED(hr));
		hr = pTypeLib->GetTypeInfoOfGuid(*piid, &m_pTypeInfo);
		assert(SUCCEEDED(hr));
	}
	/// fXgN^
	virtual ~CPathTypeLibTypeInfoHolder() {
		if(m_pTypeInfo != 0)
			m_pTypeInfo->Release();
	}
	/// ITypeInfo CX^XԂ
	ITypeInfo*	GetTypeInfo() const {
		return m_pTypeInfo;
	}
private:
	ITypeInfo*	m_pTypeInfo;
};


// IDispatchImpl class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	IDispatch ̕WIȎ
 *	@param DI				IDispatch ƂC^[tFCX
 *	@param TypeInfoHolder	ITypeInfo 񋟂NX
 */
template<class DI, class TypeInfoHolder>
class IDispatchImpl : public DI {
	// RXgN^
public:
	/// RXgN^
	IDispatchImpl() : m_pTypeInfoHolder(0) {
		m_pTypeInfoHolder = new TypeInfoHolder;
	}
	/// fXgN^
	virtual ~IDispatchImpl() {
		delete m_pTypeInfoHolder;
	}

	// \bh
public:
	/// @see	IDispatch::GetIDsOfNames
	STDMETHOD(GetIDsOfNames)(REFIID riid,
			OLECHAR** rgszNames, unsigned int cNames, LCID lcid, DISPID* rgDispId) {
		assert(m_pTypeInfoHolder != 0);
		assert(riid == IID_NULL);
		return ::DispGetIDsOfNames(m_pTypeInfoHolder->GetTypeInfo(), rgszNames, cNames, rgDispId);
	}

	/// @see	IDispatch::GetTypeInfo
	STDMETHOD(GetTypeInfo)(unsigned int iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo) {
		VERIFY_POINTER(ppTypeInfo);
		if(iTypeInfo != 0)
			return DISP_E_BADINDEX;
		else if(m_pTypeInfoHolder == 0)
			return (*ppTypeInfo = 0), TYPE_E_ELEMENTNOTFOUND;
		(*ppTypeInfo = m_pTypeInfoHolder->GetTypeInfo())->AddRef();
		return S_OK;
	}

	/// @see	IDispatch::GetTypeInfoCount
	STDMETHOD(GetTypeInfoCount)(unsigned int* pctInfo) {
		VERIFY_POINTER(pctInfo);
		*pctInfo = (m_pTypeInfoHolder != 0) ? 1 : 0;
		return S_OK;
	}

	/// @see	IDispatch::Invoke
	STDMETHOD(Invoke)(DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
			DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
		assert(m_pTypeInfoHolder != 0);
		assert(riid == IID_NULL);
		return ::DispInvoke(static_cast<DI*>(this),
				m_pTypeInfoHolder->GetTypeInfo(), dispidMember, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
	}

	// f[^o
private:
	TypeInfoHolder*	m_pTypeInfoHolder;
};

} /* namespace OLE */

} /* namespace Armaiti */


#endif /* _ARMAITI_IMPLEMENTATION_H_ */

/* [EOF] */