// OutlineParserDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "OutlineParserDlg.h"
#include "..\Manah\win_utils.h"
using Alpha::COutlineParserDlg;


// COutlineParserDlg class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	XML `ŃNbv{[hɕۑ
 */
void COutlineParserDlg::CopyAsXML() {
	wstring											strResult;
	list<TOutlineElement*>::const_iterator			itCurrentElement = m_oelmRoot.children.begin();
	stack<list<TOutlineElement*>*>					stkElementList;
	stack<list<TOutlineElement*>::const_iterator>	stkElementIterator;
	unsigned int									nNest = 0;		// lXgx
	wchar_t											wsz[256];

	while(true) {
		if(itCurrentElement == stkElementList.top()->end()) {	// 1ɏオ
			--nNest;
			_wcsnset(wsz, L'\t', nNest);
			wcscat(wsz + nNest, L"</function>\n");
			stkElementList.pop();
			itCurrentElement = stkElementIterator.top();
			stkElementIterator.pop();
			++itCurrentElement;
			if(nNest == 0)	// lXgx0ɖ߂̂ŏI
				break;
		} else if(!(*itCurrentElement)->children.empty()) {	// qvfΉ
			_wcsnset(wsz, L'\t', nNest);
			swprintf(wsz + nNest,
				L"<function name=\"%s\" line\"%d\">\n",
				(*itCurrentElement)->title.c_str(), (*itCurrentElement)->line);
			++nNest;
			stkElementList.push(&(*itCurrentElement)->children);
			stkElementIterator.push(itCurrentElement);
			itCurrentElement = (*itCurrentElement)->children.begin();
		} else {	// qvf̖vf
			_wcsnset(wsz, L'\t', nNest);
			swprintf(wsz + nNest,
				L"<function name=\"%s\" line=\"%d\"></function>\n",
				(*itCurrentElement)->title.c_str(), (*itCurrentElement)->line);
			strResult += wsz;
			++itCurrentElement;
		}
	}

	Manah::Windows::CClipboard::SetClipboardText(m_hWnd, strResult.c_str());	// Nbv{[hɃRs[
}

/**
 *	͂sA_CAÕc[ɕ\B
 *	̃\bh̓_CAO\ł DoModeless Ăяo_CAO\B
 *	܂ XML `ł̃Nbv{[hւ̕ۑ\ɂȂB
 *	̃\bȟʂ͑Să_CAOɏo͂邽߁A
 *	NCAgNX͉͌ʂłȂ̂ŒӁB
 *	͂Ɏsꍇ̓_CAOɃG[\B
 *	r܂Őꍇ͐łʂo͂B
 *
 *	iKł͉͎͎̂IȂ̂ŁA\͂Ȃǂ͂ĂȂB
 *	Iɂ͐mȉ͂s悤ɏC\
 *
 *	@param pEditDoc	͂hLg
 */
void COutlineParserDlg::Parse(const Ascension::CEditDoc* pEditDoc) {
	assert(pEditDoc != 0);

	if(!IsWindow())
		DoModeless();

	switch(m_oplLanguage) {
	case OPL_JSCRIPT:
		ParseAsJScript(pEditDoc);
		break;
	case OPL_VBSCRIPT:
		ParseAsVBScript(pEditDoc);
		break;
	default:
		assert(false);
	}
}

/**
 *	hLg JScript Ƃĉ
 */
void COutlineParserDlg::ParseAsJScript(const Ascension::CEditDoc* pEditDoc) {
}

/**
 *	hLg VBScript Ƃĉ
 *	VBScript ł͎ʎqɎg镶ȂBƂ肠 iswspace Ńg[Nɋ؂邱ƂɂĂ邪
 *	ܘ_s\Bςȕɂ̓G[oׂA͂܂ł͂ȂĂ낤B
 */
void COutlineParserDlg::ParseAsVBScript(const Ascension::CEditDoc* pEditDoc) {
	Ascension::LineIterator	it = pEditDoc->GetLineIterator(0);
	unsigned long			cLines = pEditDoc->GetLineCount();	// s
	unsigned long			cchLine;							// s̒
	unsigned long			iLine, iChar;						// ݈ʒu
	bool					bInClass = false;		// Class 
	bool					bInSub = false;			// Sub 
	bool					bInFunction = false;	// Function 
	bool					bInProperty = false;	// Property XXX 

	wchar_t			wszErrorMessage[256];

#define ALERT_ERROR(str)																			\
	swprintf(wszErrorMessage, L"͒ɃG[𔭌܂B\n\ns:\t%lu\n%s", iLine + 1, (str));	\
	MessageBox(wszErrorMessage, L"Alpha", MB_ICONEXCLAMATION);

	size_t	cchToken;
	for(iLine = 0; iLine < cLines; ++iLine, ++it) {	// Ss𑖍
		const wstring&	strLine = it->GetLine();
		cchLine = strLine.length();
		iChar = 0;
		while(iChar < cchLine) {
			if(strLine[iChar] == L'\'')	// Rg -> ̍s
				break;
			else if(strLine[iChar] == L'\"') {	// 񃊃e
				iChar = strLine.find(L'\"', iChar + 1);
				if(iChar == wstring::npos) {	// 񂪏IĂȂ -> G[!
					ALERT_ERROR(L"񂪏IĂ܂B");
					return;
				}
				++iChar;
			} else if(cchToken = GetIdentifierAsVBScript(strLine.c_str() + iChar, strLine.length() - iChar)) {	// ̉\
				const wstring&	strName = strLine.substr(iChar, cchToken);
				if(_wcsicmp(strName.c_str(), L"Class") == 0) {	// "Class"
					if(bInClass || bInSub || bInFunction || bInProperty) {	// ̕ɃNX` -> G[!
						ALERT_ERROR(L"̕ Class `܂B");
						return;
					}
					bInClass = true;
				} else if(_wcsicmp(strName.c_str(), L"Function") == 0) {	// "Function"
					if(bInSub || bInFunction || bInProperty) {	// ̕Ɋ֐` -> G[!
						ALERT_ERROR(L"̕ Function `܂B");
						return;
					}
					bInFunction = true;
				} else if(_wcsicmp(strName.c_str(), L"Sub") == 0) {	// "Sub"
					if(bInSub || bInFunction || bInProperty) {	// ̕ɃTu[`` -> G[!
						ALERT_ERROR(L"̕ Sub `܂B");
						return;
					}
					bInSub = true;
				} else if(_wcsicmp(strName.c_str(), L"Property") == 0) {	// "Property XXX"
					if(!bInClass) {	// NX`OɃvpeB` -> G[!
						ALERT_ERROR(L"NX`O Property `܂B");
						return;
					} else if(bInSub || bInFunction || bInProperty) {	// ̕ɃvpeB` -> G[!
						ALERT_ERROR(L"̕ Property `܂B");
						return;
					}
					bInProperty = true;
				} else if(_wcsicmp(strName.c_str(), L"End") == 0) {	// "End XXX"
				}
			} else	// ͖̑
				++iChar;
		}
	}

#undef ALERT_ERROR
}

///	@see	CDialog::OnCommand
bool COutlineParserDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	switch(wID) {
	case IDC_CHK_AUTOCLOSE:	// [Iɂ̃_CAO]
		m_bAutoClose = IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) & BST_CHECKED;
		break;
	case IDC_BTN_COPYASXML:	// [Rs[]
		CopyAsXML();
		break;
	case IDC_BTN_JUMP:		// [ړ]
		break;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

/* [EOF] */