// GotoLineDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "GotoLineDlg.h"
#include "Alpha.h"

using Alpha::CGotoLineDlg;
using Alpha::CAlphaApp;


// CGotoLineDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CGotoLineDlg::CGotoLineDlg(const CAlphaApp* pApp)
		: m_bLineUnit(true), m_bSaveSelection(false), m_bAutoClose(true), m_iLineNumber(1) {
	assert(pApp != 0);
	m_pApp = pApp;
}

///	@see	CDialog::OnClose
void CGotoLineDlg::OnClose() {
	m_iLineNumber = ::SendMessage(GetDlgItem(IDC_SPIN_LINENUMBER), UDM_GETPOS, 0, 0L);
	m_bLineUnit = IsDlgButtonChecked(IDC_RADIO_LOGICALLINE) == BST_CHECKED;
	m_bSaveSelection = IsDlgButtonChecked(IDC_CHK_SAVESELECTION) == BST_CHECKED;
	m_bAutoClose = IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED;

	CDialog::OnClose();
}

///	@see	CDialog::OnInitDialog
bool CGotoLineDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	ModifyStyleEx(0, WS_EX_LAYERED);
	SetLayeredWindowAttributes(0, 220, LWA_ALPHA);

	::SendMessage(GetDlgItem(IDC_SPIN_LINENUMBER), UDM_SETRANGE32, 1, INT_MAX);
	::SendMessage(GetDlgItem(IDC_SPIN_LINENUMBER), UDM_SETPOS, 0, 1);
	CheckRadioButton(IDC_RADIO_LOGICALLINE,
		IDC_RADIO_PHYSICALLINE, m_bLineUnit ? IDC_RADIO_LOGICALLINE : IDC_RADIO_PHYSICALLINE);
	CheckDlgButton(IDC_CHK_SAVESELECTION, m_bSaveSelection ? BST_CHECKED : BST_UNCHECKED);
	CheckDlgButton(IDC_CHK_AUTOCLOSE, m_bAutoClose ? BST_CHECKED : BST_UNCHECKED);

	return true;
}

///	@see	CDialog::OnOK()
void CGotoLineDlg::OnOK() {
	if(!m_pApp->GetActiveTab()->IsTextEditor())
		return;

	unsigned long		iLine;
	Alpha::CAlphaView*	pView = m_pApp->GetActiveTextEditor()->GetActiveView();

	// ړ̌
	iLine = ::SendMessage(GetDlgItem(IDC_SPIN_LINENUMBER), UDM_GETPOS, 0, 0L) - 1;
	if(IsDlgButtonChecked(IDC_RADIO_PHYSICALLINE) == BST_CHECKED)	// [\s]
		iLine = pView->LogicalCharFromDisplayChar(CCharPos(iLine, 0)).m_iLine;

	// ړ
	if(IsDlgButtonChecked(IDC_CHK_SAVESELECTION) == BST_CHECKED) {	// [Iێ]
		CCharPos	posBegin, posEnd;
		pView->GetSel(posBegin, posEnd);
		pView->SetSel(posBegin, CCharPos(iLine, 0));
	} else
		pView->SetSelWithoutSelection(iLine, 0);

	// ㏈
	pView->SetFocus();
	if(IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [IɃ_CAO]
		CDialog::OnOK();
}

/* [EOF] */