// FilePropertyDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "FilePropertyDlg.h"
#include "CodePageManager.h"
#include "..\Manah\ListCtrl.h"
using Alpha::CFilePropertyDlg;


// CFilePropertyDlg class implementation
/////////////////////////////////////////////////////////////////////////////

namespace {
	const wchar_t*	arrBreakTypeNames[] = {
		L"", L"LF (Unix)", L"CR (Macintosh)", L"CR+LF (Windows)",
		L"NEL (U+0085)", L"LS (U+2028)", L"PS (U+2029)"
	};
}

///	@see	CDialog::OnInitDialog
bool CFilePropertyDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	CListCtrl			oList;
	wchar_t				wsz[100];
	SHFILEINFOW			shfi;
	WIN32_FIND_DATAW	wfd;
	HANDLE				hFile = ::FindFirstFile(m_pDocument->GetPathName().c_str(), &wfd);
	bool				bExist = !m_pDocument->GetPathName().empty();
	bool				bTimesAvailable = hFile != INVALID_HANDLE_VALUE;

	if(bExist)
		::SHGetFileInfo(m_pDocument->GetPathName().c_str(), 0,
			&shfi, sizeof(SHFILEINFOW), SHGFI_ATTRIBUTES | SHGFI_TYPENAME);
	if(bTimesAvailable)
		::FindClose(hFile);

	oList.Attach(GetDlgItem(IDC_LIST_PROPERTIES));
	oList.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);
	oList.InsertColumn(0, L"vpeB", LVCFMT_LEFT, 90);
	oList.InsertColumn(1, L"l", LVCFMT_LEFT, 276);

	oList.InsertItem(0, L"t@C");
	oList.SetItemText(0, 1, bExist ? m_pDocument->GetTitle().c_str() : L"(hLg͕ۑĂ܂)");
	oList.InsertItem(1, L"tpX");
	oList.SetItemText(1, 1, bExist ? m_pDocument->GetPathName().c_str() : L"(hLg͕ۑĂ܂)");
	oList.InsertItem(2, L"t@C̎");
	oList.SetItemText(2, 1, bExist ? shfi.szTypeName : L"(hLg͕ۑĂ܂)");
	oList.InsertItem(3, L"R[h");
	oList.SetItemText(3, 1, CCodePageManager::GetCodePageName(m_pDocument->GetCodePage()));
	oList.InsertItem(4, L"sR[h");
	oList.SetItemText(4, 1, arrBreakTypeNames[m_pDocument->GetBreakType()]);
	oList.InsertItem(5, L"^Cv");
	oList.SetItemText(5, 1, m_strDocTypeName.c_str());
	oList.InsertItem(6, L"s");
	swprintf(wsz, L"%lu", m_pDocument->GetLineCount());
	oList.SetItemText(6, 1, wsz);

	if(bTimesAvailable) {
		SYSTEMTIME		st;
		wostringstream	ssAttributes;

		oList.InsertItem(7, L"TCY");
		swprintf(wsz, L"%lu oCg", wfd.nFileSizeLow);
		oList.SetItemText(7, 1, wsz);
		oList.InsertItem(8, L"쐬");
		::FileTimeToLocalFileTime(&wfd.ftCreationTime, &wfd.ftCreationTime);
		::FileTimeToSystemTime(&wfd.ftCreationTime, &st);
		::GetDateFormatW(LOCALE_SYSTEM_DEFAULT, 0, &st, 0, wsz, 100);
		wcscat(wsz, L" ");
		::GetTimeFormatW(LOCALE_SYSTEM_DEFAULT, 0, &st, 0, wsz + wcslen(wsz), 100);
		oList.SetItemText(8, 1, wsz);
		oList.InsertItem(9, L"XV");
		::FileTimeToLocalFileTime(&wfd.ftLastWriteTime, &wfd.ftLastWriteTime);
		::FileTimeToSystemTime(&wfd.ftLastWriteTime, &st);
		::GetDateFormatW(LOCALE_SYSTEM_DEFAULT, 0, &st, 0, wsz, 100);
		wcscat(wsz, L" ");
		::GetTimeFormatW(LOCALE_SYSTEM_DEFAULT, 0, &st, 0, wsz + wcslen(wsz), 100);
		oList.SetItemText(9, 1, wsz);

		oList.InsertItem(10, L"t@C");
		ssAttributes << hex << wfd.dwFileAttributes << L" (";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_ARCHIVE))		ssAttributes << L"archive;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_COMPRESSED))		ssAttributes << L"compressed;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))		ssAttributes << L"directory;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_ENCRYPTED))		ssAttributes << L"encrypted;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN))			ssAttributes << L"hidden;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_OFFLINE))		ssAttributes << L"offline;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_READONLY))		ssAttributes << L"readonly;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_REPARSE_POINT))	ssAttributes << L"reparse point;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_SPARSE_FILE))	ssAttributes << L"sparse file;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM))			ssAttributes << L"system;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY))		ssAttributes << L"temporary;";
		ssAttributes << L")";
		oList.SetItemText(10, 1, ssAttributes.str().c_str());
	}

	oList.Detach();

	return true;
}

///	@see	CDialog::OnSize
void CFilePropertyDlg::OnSize(UINT nType, int cx, int cy) {
	::MoveWindow(GetDlgItem(IDC_LIST_PROPERTIES), 12, 11, cx - 25, cy - 62, true);
	::MoveWindow(GetDlgItem(IDOK), cx - 100, cy - 32, 88, 20, true);
}

/* [EOF] */