// TextSearcher.h
// (c) 2004 exeal

#ifndef _TEXT_SEARCHER_H_
#define _TEXT_SEARCHER_H_
#include "..\..\Manah\Object.h"

namespace VBScript_RegExp_55 {
	interface IRegExp;	// O錾
}


namespace Ascension {

///	tO
typedef unsigned short	SearchFlag;
///	O
const SearchFlag	SF_FORWARD				= 0x0000;
///	
const SearchFlag	SF_BACKWARD				= 0x0001;
///	啶ʂȂ (P)
const SearchFlag	SF_IGNORE_CASE_SIMPLE	= 0x0002;
///	啶ʂȂ (S)
const SearchFlag	SF_IGNORE_CASE_FULL		= 0x0006;
///	ЉʂȂ
const SearchFlag	SF_IGNORE_KANATYPE		= 0x0008;
///	SppʂȂ
const SearchFlag	SF_IGNORE_WIDTH			= 0x0010;
///	̎ނʂȂ (0-9 ̂)
const SearchFlag	SF_IGNORE_DIGITTYPE		= 0x0020;
///	L𖳎
const SearchFlag	SF_IGNORE_SYMBOLS		= 0x0040;
///	ꏊƂȂ𖳎
const SearchFlag	SF_IGNORE_NONSPACE		= 0x0080;
///	JV_𖳎
const SearchFlag	SF_IGNORE_KASHIDA		= 0x0100;
///	𕪉
const SearchFlag	SF_DECOMPOSE			= 0x0200;
///	PPʂŌ
const SearchFlag	SF_WHOLEWORD			= 0x0400;
///	K\g
const SearchFlag	SF_REGEXP				= 0x1000;

/*
 *	.::.
 *
 *	tO͈ꕔ̎͊ȒPAłȂ̂B
 *	炩̈̕Ⴂ𖳎悤ȏ̏ꍇA
 *	r2̕𓯂Ƀ}bvKv邪A
 *	̏̉ł͕̕ω\B
 *	Ⴆ΁u啶ʂȂ (S)vł̓P[XtHfBOs
 *	̒ςÄvʒuȂȂB
 *	邽߂ɁAΏەϊƂɂǂŕω
 *	() LĂ΂낤B
 *
 *	Ȃ當̃}bv͂܂ȒPł͂ȂAUnicode 4.0
 *	ɏ]Ƃ΂Ȃ̎KvɂȂB
 *	@啶ʂȂ (P): CaseFolding.txt g
 *	@啶ʂȂ (S): CaseFolding.txt g
 *	@ЉʂȂ: LCMapStringW łǂ炩
 *	@SppʂȂ: LCMapStringW őSp
 *	@̎ނʂȂ: ArA0-9 (LCMapStringW ͕sS)
 *	@L𖳎: UnicodeData.txt g
 *	@ꏊƂȂ𖳎: ???
 *	@JV_𖳎: ???
 *	@𕪉: ???
 *
 *	!_ł͕̕ς}bv͎ĂȂ!
 */


///	K\GWpӂłȂƂ\O
class EFailedToLoadRegExpEngine {
public:
	///	RXgN^
	EFailedToLoadRegExpEngine(const wstring& str) : m_str(str) {
	}
	///	Ԃ
	wstring	GetDescription() const {
		return m_str;
	}

private:
	wstring	m_str;
};


///	eLXgs
class CTextSearcher : public Manah::CObject {
	// RXgN^
public:
	CTextSearcher();
	virtual ~CTextSearcher();
private:
	CTextSearcher(const CTextSearcher& rhs);
	operator =(const CTextSearcher& rhs);

	// \bh
public:
	bool	Search(size_t iBegin, size_t& iFound, size_t& cchFound) throw(EFailedToLoadRegExpEngine);
	void	SetFlag(SearchFlag flags);
	void	SetText(const wstring& strText);
	void	SetTargetText(const wstring& strText);

	// f[^o
protected:
	wstring		m_strTarget;
	wstring		m_strFindWhat;
	SearchFlag	m_sfFlags;
	VBScript_RegExp_55::IRegExp*	m_pRegExp;
};

} // namespace Ascension

#endif /* _TEXT_SEARCHER_H_ */

/* [EOF] */