// LineLayout.h
// (c) 2003 exeal

#ifndef _LINE_LAYOUT_H_
#define _LINE_LAYOUT_H_
#include <string>
#include <list>
#include <vector>


namespace Ascension {

class CEditView;

// sRg̎
enum MCommentType {
	MCT_NOTCOMMENT,	// sRgł͂Ȃ
	MCT_1,			// sRg1
	MCT_2			// sRg2
};

/// `悷镶̎
enum TextType {
	/// ʏ̃eLXg
	TT_NORMAL,
	/// Ï (F̂ݗL)
	TT_SELECTION,
	///	ANeBuÏ (F̂ݗL)
	TT_INACTIVESELECTION,
	/// CWP[^}[W
	TT_INDICATORMARGIN,
	/// sԍ
	TT_LINENUMBER,
	/// ԍ (ݎgpĂȂ)
	TT_COLUMNNUMBER,
	/// sԍ
	TT_EMPHASIZEDLINENUMBER,
	///  (Spp֌WȂASĂ UCS-4 󔒕)BIsWhiteSpace Œ`
	TT_SPACE,
	/// s}[N (F̂ݗL)
	TT_BREAK,
	/// plBIsNumeric Œ`
	TT_NUMERIC,
	/// dpBIsSingleQuotation Œ`
	TT_SINGLEQUOTATION,
	/// dpBIsDoubleQuotation Œ`
	TT_DOUBLEQUOTATION,
	/// L[[h1
	TT_KEYWORD1,
	/// L[[h2
	TT_KEYWORD2,
	/// Rg (P/s)
	TT_COMMENT,
	///	ʎq (L[[hȊO̒P)
	TT_IDENTIFIER,
	///	Zq
	TT_OPERATOR,
	///	ʂ̈v
	TT_BRACKETSMATCH,
	///	݂̃R[hy[Wɖ
	TT_INVALIDCHARACTER,
	/// [EOF] }[N
	TT_ENDOFFILE,
	TEXTTYPE_NUMBER
};


// CTokenInfo class definition
/////////////////////////////////////////////////////////////////////////////

///	g[N̏
class CTokenInfo {
	friend class CLineLayoutInfo;
	friend class CLineLayoutManager;

	// s̕\
	struct TSubstringDirection {
		unsigned long	iStartChar;
		bool			bRightToLeft;
	};
	typedef std::list<TSubstringDirection>	DirectionList;

	// RXgN^
private:
	CTokenInfo() {
	}

	// \bh
public:
	unsigned long	GetIndex() const {
		return m_iChar;
	}
	unsigned long	GetLeftEdge() const {
		return m_nLeftEdge;
	}
	unsigned long	GetStringLength() const {
		return m_cchToken;
	}
	unsigned long	GetTextWidth() const {
		return m_nTextWidth;
	}
	TextType		GetType() const {
		return m_ttType;
	}
	bool	GetCharDirection(unsigned long iChar) const {	// E獶Ȃ true Ԃ
		assert(this != 0);
		DirectionList::const_iterator	it;

		for(it = m_listDirections.begin(); it != m_listDirections.end(); ++it) {
			if(iChar < it->iStartChar)
				break;
		}
		return (--it)->bRightToLeft;
	}

	// f[^o
private:
	unsigned long	m_iChar;			// sł̃g[N̈ʒu
	unsigned long	m_nLeftEdge;		// g[N̍[̈ʒu
	unsigned long	m_nTextWidth;		// g[N̕
	unsigned long	m_cchToken;			// g[N̒
	TextType		m_ttType;			// g[N̎
	DirectionList	m_listDirections;	// eLXgωʒũXg
};

typedef std::list<CTokenInfo>	TokenList;


// CLineLayoutInfo class definition
/////////////////////////////////////////////////////////////////////////////

/**
 *	\brief	es̃CAEgۑ
 *
 *	CLineLayoutManager::GetLine() 擾łA_s̃CAEgێB
 *	O̍sƂ̊Ԃ̕sRǧpAg[ÑXgAẽLbgʒuA
 *	ubN}[NsA܂Ԃɕ`悷̂ɕKvȕȂǂƂĎB
 *
 *	eȏ CLineLayoutManager NXsBCAEg
 *	úvAusRĝ͍݉ς݁vAug[N܂ŉ͍ς݁v
 *	3̏ԂÂ߂Ɋes̉͂͒xB CEditView
 *	ANZXƂɂ́ug[N܂ŉ͍ς݁vł邱Ƃۏ؂B
 */
class CLineLayoutInfo {
	friend class CLineLayoutManager;

	// RXgN^
private:
	CLineLayoutInfo() : m_pNext(0), m_pPrev(0),
			m_mctFromPrev(MCT_NOTCOMMENT), m_mctToNext(MCT_NOTCOMMENT),
			m_bBookmarked(false), m_cxPixel(0), m_dwParam(0),
			m_bReady(false), m_bEdgeMCommentsCompleted(false) {
	}

	// \bh
public:
	const std::vector<int>&	GetCaretPositions() const {	// Lbgʒu̔zԂ
		return m_vecCaretPos;
	}
	MCommentType	GetMultilineCommentStatus(bool bToNextLine) const {	// sRǧp󋵂Ԃ
		return bToNextLine ? m_mctToNext : m_mctFromPrev;
	}
	const TokenList&	GetTokenList() const {	// g[ÑXgԂ
		return m_listTokens;
	}
	DWORD	GetUserDefinedValue() const {	// s̃[U`lԂ
		return m_dwParam;
	}
	const std::vector<unsigned long>&	GetWrappedPoints() const {	// ܂Ԃʒu̔zԂ
		return m_vecWrappedOffsets;
	}
	bool	IsBookmarked() const {	// ubN}[NsǂԂ
		return m_bBookmarked;
	}
	void	SetBookmark(bool bMark = true) {	// ubN}[N̐ݒ
		m_bBookmarked = bMark;
	}
	void	SetUserDefinedValue(DWORD dwValue) {	// [U`l̐ݒ
		m_dwParam = dwValue;
	}

	// f[^o
private:
	CLineLayoutInfo*			m_pNext;				// O̍s
	CLineLayoutInfo*			m_pPrev;				// ̍s
	MCommentType				m_mctFromPrev;			// O̕sRgIĂȂ΂̎
	MCommentType				m_mctToNext;			// sRg̍sɑĂ΂̎
	bool						m_bBookmarked;			// ubN}[Ns
	std::vector<unsigned long>	m_vecWrappedOffsets;	// ܂Ԃꂽ\s̊e擪ʒu (܂Ԃꍇ̂ݗL)
														// vf \s - 1
	unsigned long				m_cxPixel;				// ܂Ԃɕ`悷̂ɕKvȕ̕ (܂ԂȂꍇ̂ݗL)
	DWORD						m_dwParam;				// AvP[V`̒l

	bool						m_bReady;					// s̉͂Ă邩
	bool						m_bEdgeMCommentsCompleted;	// s̐擪Ɩ̕sRg񂪎擾ς݂
	TokenList					m_listTokens;				// g[ÑXg
	std::vector<int>			m_vecCaretPos;				// e̍[̈ʒu
};


// CLineLayoutManager class definition
/////////////////////////////////////////////////////////////////////////////

/**
 *	@brief	sCAEg̊Ǘ
 *
 *	CEditView NX̃CAEgsPʂŊǗACEditView NXł
 *	s̍폜A}AXV󂯂āACAEgXVĂB
 *
 *	̂߂ɂ̃NX̃\bh͕Kvȏ̑sȂB
 *	Ⴆ΂sɕsRgJn񂪑}ꂽꍇACEditView
 *	NX͂̍s̃CAEgXV邽߂ ModifyLine
 *	ĂяoA̍sւ̉e͖ (C̕Kvȍs͕Ԃ)B
 *	êsXV邩ǂf̂ CEditView NX̎dłB
 */
class CLineLayoutManager {
	// RXgN^
public:
	CLineLayoutManager(CEditView* pView);
	virtual ~CLineLayoutManager();

	// \bh
public:
	void				DeleteAllLines();
	void				DeleteLine(unsigned long iLine) throw(out_of_range);
	void				DeleteLines(unsigned long iStart, unsigned long iEnd) throw(out_of_range);
	CLineLayoutInfo*	GetLine(unsigned long iLine) const;
	unsigned long		GetMaxDisplayWidth() const;
	void				InsertLine(unsigned long iLine) throw(out_of_range);
	void				InsertLines(unsigned long iStart, unsigned long iEnd) throw(out_of_range);
	bool				IsLineParseComplete(unsigned long iLine) throw(out_of_range);
	void				ModifyAllLines(bool bReconstruct);
	unsigned long		ModifyLine(unsigned long iLine) throw(out_of_range);
	void				ParseLine(unsigned long iLine) throw(out_of_range);
protected:
	CLineLayoutInfo*	GetLineInternal(unsigned long iLine) const;
	void				ModifyMaxDisplayWidth();
	void				ParseLineEdgeComments(unsigned long iLine, CLineLayoutInfo* pInfo = 0);
	void				ParseLineTokens(unsigned long iLine, CLineLayoutInfo* pInfo = 0);

	// f[^o
private:
	CEditView*			m_pView;
	CLineLayoutInfo*	m_pHead;				// 擪
	unsigned long		m_pxMax;				// ő\
	CLineLayoutInfo*	m_pMaxDisplayWidthLine;	// ő\s

	unsigned long		m_iLineCache;			// ŌɃANZXsԍƗvf
	CLineLayoutInfo*	m_pInfoCache;			// s̒ǉƍ폜s\bhgpƖɂȂ
};

} // namespace Ascension


#endif /* _LINE_LAYOUT_H_ */

/* [EOF] */