// WinThread.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _WIN_THREAD_H_
#define _WIN_THREAD_H_

#include "Window.h"


// CWinThread class definition
/////////////////////////////////////////////////////////////////////////////

namespace Manah {
namespace Windows {

class CWinThread : public CSelfAssertable {
	// data members
private:
	long				m_cWaitCursor;
	HCURSOR				m_hOriginalCursor;

	HANDLE				m_hThread;
	CWindow*			m_pMainWindow;

	// constructors
public:
	CWinThread();
	virtual ~CWinThread();

	// methods
public:
	void				BeginWaitCursor();
	void				EndWaitCursor();
	void				RestoreWaitCursor();

	bool				CreateThread(DWORD dwCreateFlags = 0, UINT nStackSize = 0, LPSECURITY_ATTRIBUTES lpSecurityAttrs = 0);
	virtual CWindow*	GetMainWindow() const;
	int					GetThreadPriority();
	bool				SetThreadPriority(int nPriority) const;
	bool				PostThreadMessage(UINT msg, WPARAM wParam, LPARAM lParam);
	DWORD				ResumeThread();
	DWORD				SuspendThread();

	virtual int			ExitInstance();
	virtual bool		InitInstance();
	virtual bool		OnIdle(long nCount);
	virtual bool		PreTranslateMessage(MSG* pMsg);
	virtual bool		IsIdelMessage(MSG* pMsg);
	virtual LRESULT		ProcessWndProcException(std::exception& e, const MSG* pMSG);
	virtual bool		ProcessMessageFilter(int nCode, MSG* pMSG);
	virtual int			Run();
};


// CWinThread class implementation
/////////////////////////////////////////////////////////////////////////////

CWinThread::CWinThread() : m_cWaitCursor(0), m_hOriginalCursor(0), m_pMainWindow(0) {
}

CWinThread::~CWinThread() {
}

void CWinThread::BeginWaitCursor() {
	if(m_cWaitCursor == 0) {
		m_cWaitCursor++;
		m_hOriginalCursor = ::GetCursor();
		::SetCursor(::LoadCursor(0, IDC_WAIT));
	}
}

void CWinThread::EndWaitCursor() {
	--m_cWaitCursor;
	if(m_cWaitCursor <= 0) {
		m_cWaitCursor = 0;
		if(m_hOriginalCursor != 0)
			::SetCursor(m_hOriginalCursor);
		m_hOriginalCursor = 0;
	}
}

void CWinThread::RestoreWaitCursor() {
	m_cWaitCursor = 0;
	if(m_hOriginalCursor != 0)
		::SetCursor(m_hOriginalCursor);
	m_hOriginalCursor = 0;
}

CWindow* CWinThread::GetMainWindow() const {
	return m_pMainWindow;
}

int CWinThread::GetThreadPriority() const {
	return ::GetThreadPriority(m_hThread);
}

}; /* namespace Manah */

#endif /* _WIN_THREAD_H_ */

/*[EOF]*/