// ComboBox.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _COMBO_BOX_H_
#define _COMBO_BOX_H_

#include "Window.h"


// CComboBox class definition
/////////////////////////////////////////////////////////////////////////////

namespace Manah {
namespace Windows {
namespace Controls {

class CComboBox : public CStandardControl<CComboBox> {
	DEFINE_CLASS_NAME(_T("COMBOBOX"))

	// \bh
public:
	/* 쐬 */
	int		InitStorage(int nItems, UINT nBytes);

	/*  */
	int		GetCount() const;
	int		GetCurSel() const;
	void	GetDroppedControlRect(RECT& rect) const;
	bool	GetDroppedState() const;
	int		GetDroppedWidth() const;
	DWORD	GetEditSel() const;
	bool	GetExtendedUI() const;
	UINT	GetHorizontalExtent() const;
	DWORD	GetItemData(int index) const;
	void*	GetItemDataPtr(int index) const;
	int		GetItemHeight(int index) const;
	int		GetLBText(int index, TCHAR* lpszText) const;
	int		GetLBTextLen(int index) const;
	LCID	GetLocale() const;
	int		GetMinVisible() const;
	int		GetTopIndex() const;
	int		SetCurSel(int nSelect);
	int		SetDroppedWidth(UINT nWidth);
	bool	SetEditSel(int nStartChar, int nEndChar);
	int		SetExtendedUI(bool bExtended = true);
	void	SetHorizontalExtent(UINT nExtent);
	int		SetItemData(int index, DWORD dwItemData);
	int		SetItemDataPtr(int index, const void* pItemData);
	int		SetItemHeight(int index, UINT cyItemHeight);
	LCID	SetLocale(LCID lcid);
	bool	SetMinVisible(int nMinVisible);
	int		SetTopIndex(int index);

	/*  */
	int		AddString(const TCHAR* lpszText);
	int		DeleteString(UINT index);
	int		Dir(UINT nAttributes, const TCHAR* lpszFileSpec);
	int		FindString(int nStartAfter, const TCHAR* lpszText) const;
	int		FindStringExact(int iStart, const TCHAR* lpszText) const;
	int		InsertString(int index, const TCHAR* lpszText);
	bool	LimitText(int nMaxChars);
	void	ResetContent();
	int		SelectString(int nStartAfter, const TCHAR* lpszText);
	void	ShowDropDown(bool bShow = true);

	/* 񑀍 */

	/* Nbv{[h */
	void	Clear();
	void	Copy();
	void	Cut();
	void	Paste();

#ifdef CB_GETCOMBOBOXINFO
	bool	GetComboBoxInfo(COMBOBOXINFO& cbi) const;
#endif
};


// CComboBox class implementation
/////////////////////////////////////////////////////////////////////////////

#define UNCONST_THIS	const_cast<CComboBox*>(this)

inline int CComboBox::AddString(const TCHAR* lpszText) {
	return static_cast<int>(SendMessage(CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(lpszText)));
}

inline void CComboBox::Clear() {
	SendMessage(WM_CLEAR);
}

inline void CComboBox::Copy() {
	SendMessage(WM_COPY);
}

inline void CComboBox::Cut() {
	SendMessage(WM_CUT);
}

inline int CComboBox::DeleteString(UINT index) {
	return static_cast<int>(SendMessage(CB_DELETESTRING, index));
}

inline int CComboBox::Dir(UINT nAttributes, const TCHAR* lpszFileSpec) {
	return static_cast<int>(SendMessage(CB_DIR, nAttributes, reinterpret_cast<LPARAM>(lpszFileSpec)));
}

inline int CComboBox::FindString(int nStartAfter, const TCHAR* lpszText) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(
		CB_FINDSTRING, nStartAfter, reinterpret_cast<LPARAM>(lpszText)));
}

inline int CComboBox::FindStringExact(int iStart, const TCHAR* lpszText) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(
		CB_FINDSTRINGEXACT, iStart, reinterpret_cast<LPARAM>(lpszText)));
}

#ifdef CB_GETCOMBOBOXINFO
inline bool CComboBox::GetComboBoxInfo(COMBOBOXINFO& cbi) const {
	return toBoolean(UNCONST_THIS->SendMessage(CB_GETCOMBOBOXINFO, 0, reinterpret_cast<LPARAM>(&cbi)));
}
#endif /* !CB_GETCOMBOBOXINFO */

inline int CComboBox::GetCount() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(CB_GETCOUNT));
}

inline int CComboBox::GetCurSel() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(CB_GETCURSEL));
}

inline void CComboBox::GetDroppedControlRect(RECT& rect) const {
	UNCONST_THIS->SendMessage(CB_GETDROPPEDCONTROLRECT, 0, reinterpret_cast<LPARAM>(&rect));
}

inline bool CComboBox::GetDroppedState() const {
	return toBoolean(UNCONST_THIS->SendMessage(CB_GETDROPPEDSTATE));
}

inline int CComboBox::GetDroppedWidth() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(CB_GETDROPPEDWIDTH));
}

inline DWORD CComboBox::GetEditSel() const {
	WORD	wStart, wEnd;

	UNCONST_THIS->SendMessage(CB_GETEDITSEL, reinterpret_cast<WPARAM>(&wStart), reinterpret_cast<LPARAM>(&wEnd));
	return MAKELPARAM(wStart, wEnd);
}

inline bool CComboBox::GetExtendedUI() const {
	return toBoolean(UNCONST_THIS->SendMessage(CB_GETEXTENDEDUI));
}

inline UINT CComboBox::GetHorizontalExtent() const {
	return static_cast<UINT>(UNCONST_THIS->SendMessage(CB_GETHORIZONTALEXTENT));
}

inline DWORD CComboBox::GetItemData(int index) const {
	return UNCONST_THIS->SendMessage(CB_GETITEMDATA, index);
}

inline void* CComboBox::GetItemDataPtr(int index) const {
	return reinterpret_cast<void*>(UNCONST_THIS->SendMessage(CB_GETITEMDATA, index));
}

inline int CComboBox::GetItemHeight(int index) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(CB_GETITEMHEIGHT, index));
}

inline int CComboBox::GetLBText(int index, TCHAR* lpszText) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(CB_GETLBTEXT, index, reinterpret_cast<LPARAM>(lpszText)));
}

inline int CComboBox::GetLBTextLen(int index) const {
	return static_cast<int>(UNCONST_THIS->SendMessage(CB_GETLBTEXTLEN, index));
}

inline LCID CComboBox::GetLocale() const {
	return static_cast<LCID>(UNCONST_THIS->SendMessage(CB_GETLOCALE));
}

inline int CComboBox::GetMinVisible() const {
#ifndef CB_GETMINVISIBLE
	const UINT	CB_GETMINVISIBLE = 0x1702;
#endif /* !CB_GETMINVISIBLE */
	return static_cast<int>(UNCONST_THIS->SendMessage(CB_GETMINVISIBLE));
}

inline int CComboBox::GetTopIndex() const {
	return static_cast<int>(UNCONST_THIS->SendMessage(CB_GETTOPINDEX));
}

inline int CComboBox::InitStorage(int nItems, UINT nBytes) {
	return static_cast<int>(SendMessage(CB_INITSTORAGE, nItems, nBytes));
}

inline int CComboBox::InsertString(int index, const TCHAR* lpszText) {
	return static_cast<int>(SendMessage(CB_INSERTSTRING, index, reinterpret_cast<LPARAM>(lpszText)));
}

inline bool CComboBox::LimitText(int nMaxChars) {
	return toBoolean(SendMessage(CB_LIMITTEXT, nMaxChars));
}

inline void CComboBox::Paste() {
	SendMessage(WM_PASTE);
}

inline void CComboBox::ResetContent() {
	SendMessage(CB_RESETCONTENT);
}

inline int CComboBox::SelectString(int nStartAfter, const TCHAR* lpszText) {
	return static_cast<int>(SendMessage(CB_SELECTSTRING, nStartAfter, reinterpret_cast<LPARAM>(lpszText)));
}

inline int CComboBox::SetCurSel(int nSelect) {
	return static_cast<int>(SendMessage(CB_SETCURSEL, nSelect));
}

inline int CComboBox::SetDroppedWidth(UINT nWidth) {
	return static_cast<int>(SendMessage(CB_SETDROPPEDWIDTH, nWidth));
}

inline bool CComboBox::SetEditSel(int nStartChar, int nEndChar) {
	return toBoolean(SendMessage(CB_SETEDITSEL, nStartChar, nEndChar));
}

inline int CComboBox::SetExtendedUI(bool bExtended /* = true */) {
	return static_cast<int>(SendMessage(CB_SETEXTENDEDUI, bExtended));
}

inline void CComboBox::SetHorizontalExtent(UINT nExtent) {
	SendMessage(CB_SETHORIZONTALEXTENT, nExtent);
}

inline int CComboBox::SetItemData(int index, DWORD dwItemData) {
	return static_cast<int>(SendMessage(CB_SETITEMDATA, index, dwItemData));
}

inline int CComboBox::SetItemDataPtr(int index, const void* pItemData) {
	return static_cast<int>(SendMessage(CB_SETITEMDATA, index, reinterpret_cast<LPARAM>(pItemData)));
}

inline int CComboBox::SetItemHeight(int index, UINT cyItemHeight) {
	return static_cast<int>(SendMessage(CB_SETITEMHEIGHT, index, cyItemHeight));
}

inline LCID CComboBox::SetLocale(LCID lcid) {
	return static_cast<LCID>(SendMessage(CB_SETLOCALE, lcid));
}

inline bool CComboBox::SetMinVisible(int nMinVisible) {
#ifndef CB_SETMINVISIBLE
	const UINT	CB_SETMINVISIBLE = 0x1701;
#endif /* !CB_SETMINVISIBLE */
	return toBoolean(SendMessage(CB_SETMINVISIBLE, nMinVisible));
}

inline int CComboBox::SetTopIndex(int index) {
	return static_cast<int>(SendMessage(CB_SETTOPINDEX, index));
}

inline void CComboBox::ShowDropDown(bool bShow /* = true */) {
	SendMessage(CB_SHOWDROPDOWN, bShow);
}

#undef UNCONST_THIS

} /* namespace Controls */
} /* namespace Windows */
} /* namespace Manah */

#endif /* _COMBO_BOX_H_ */

/* [EOF] */