// WebBrowserContainer.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "WebBrowserContainer.h"
#if 0
#include "../Armaiti/ComBasic.h"
using Alpha::CWebBrowserContainer;
using Alpha::CAlphaEditController;
using Armaiti::CComPtr;
using namespace std;


///	RXgN^
CWebBrowserContainer::CWebBrowserContainer() : m_pBrowser(0) {
}

///	fXgN^
CWebBrowserContainer::~CWebBrowserContainer() {
	if(m_pBrowser != 0)
		m_pBrowser->Release();
}

/// @see	IOleInPlaceSite::CanInPlaceActivate
STDMETHODIMP CWebBrowserContainer::CanInPlaceActivate() {
	return E_NOTIMPL;
}

/// @see	IOleWindow::ContextSensitiveHelp
STDMETHODIMP CWebBrowserContainer::ContextSensitiveHelp(BOOL fEnterMode) {
	return E_NOTIMPL;
}

/**
 *	EBhE쐬
 *	@param hwndParent	eEBhE
 *	@param dwStyle		EBhEX^C (CreateWindow Ɠ)
 *	@param dwExStyle	gEBhEX^C (CreateWindowEx Ɠ)
 *	@return				
 */
bool CWebBrowserContainer::Create(HWND hwndParent, DWORD dwStyle, DWORD dwExStyle) {
	if(m_pBrowser != 0)
		return false;
	if(!toBoolean(::IsWindow(hwndParent)))
		return false;

#define CLEANUP_IF_FAILED()		\
	if(FAILED(hr)) {			\
		m_pBrowser->Release();	\
		m_pBrowser = 0;			\
		return false;			\
	}

	HRESULT	hr;
	hr = ::CoCreateInstance(CLSID_WebBrowser, 0, CLSCTX_ALL, IID_IWebBrowser2, reinterpret_cast<void**>(&m_pBrowser));
	if(FAILED(hr))
		return false;

	CComPtr<IOleObject>	pOleObject;
	hr = m_pBrowser->QueryInterface(IID_IOleObject, reinterpret_cast<void**>(&pOleObject));
	CLEANUP_IF_FAILED();
	hr = pOleObject->SetClientSite(this);
	CLEANUP_IF_FAILED();
	hr = pOleObject->DoVerb(OLEIVERB_INPLACEACTIVATE, 0, this, 0, hwndParent, 0);
	CLEANUP_IF_FAILED();

	HWND	hWnd;
	hr = m_pBrowser->get_HWND(reinterpret_cast<SHANDLE_PTR*>(&hWnd));
	CLEANUP_IF_FAILED();
	::SetWindowLong(hWnd, GWL_STYLE, dwStyle);
	::SetWindowLong(hWnd, GWL_EXSTYLE, dwExStyle);

	return true;
}

/// @see	IOleInPlaceSite::DeactivateAndUndo
STDMETHODIMP CWebBrowserContainer::DeactivateAndUndo() {
	return E_NOTIMPL;
}

///	@see	IDocumentContainer::DeleteInstance
void CWebBrowserContainer::DeleteInstance() {
	delete this;
}

/// @see	IOleInPlaceSite::DiscardUndoState
STDMETHODIMP CWebBrowserContainer::DiscardUndoState() {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceFrame::EnableModeless
STDMETHODIMP CWebBrowserContainer::EnableModeless(BOOL fEnable) {
	return E_NOTIMPL;
}

/// @see	IOleContainer::EnumObjects
STDMETHODIMP CWebBrowserContainer::EnumObjects(DWORD grfFlags, IEnumUnknown** ppenum) {
	return E_NOTIMPL;
}

///	@see	IOleClientSite::GetContainer
STDMETHODIMP CWebBrowserContainer::GetContainer(IOleContainer** ppContainer) {
	VERIFY_POINTER(ppContainer);
	*ppContainer = 0;
	return E_NOINTERFACE;
}

/// @see	IOleInPlaceUIWindow::GetBorder
STDMETHODIMP CWebBrowserContainer::GetBorder(LPRECT lprectBorder) {
	return E_NOTIMPL;
}

///	@see	IDocumentContainer::GetDescription
wstring CWebBrowserContainer::GetDescription() const {
	BSTR	bstr;

	if(SUCCEEDED(m_pBrowser->get_LocationURL(&bstr))) {
		const wstring	str = bstr;
		::SysFreeString(bstr);
		return str;
	} else
		return L"";
}

///	@see	IDocumentContainer::GetFilePath
wstring CWebBrowserContainer::GetFilePath() const {
	return GetDescription();
}

///	@see	IOleClientSite::GetMoniker
STDMETHODIMP CWebBrowserContainer::GetMoniker(DWORD dwAssign, DWORD dwWhichMoniker, IMoniker** ppmk) {
	VERIFY_POINTER(ppmk);
	*ppmk = 0;
	return E_NOTIMPL;
}

///	@see	IDocumentContainer::GetTextEditor
CAlphaEditController* CWebBrowserContainer::GetTextEditor() const {
	return 0;
}

///	@see	IDocumentContainer::GetTitle
wstring CWebBrowserContainer::GetTitle() const {
	BSTR	bstr;

	if(SUCCEEDED(m_pBrowser->get_LocationName(&bstr))) {
		const wstring	str = bstr;
		::SysFreeString(bstr);
		return str;
	} else
		return L"";
}

///	@see	IDocumentContainer::GetWindow
HWND CWebBrowserContainer::GetWindow() const {
	HWND	hWnd;
	m_pBrowser->get_HWND(reinterpret_cast<SHANDLE_PTR*>(&hWnd));
	return hWnd;
}

/// @see	IOleWindow::GetWindow
STDMETHODIMP CWebBrowserContainer::GetWindow(HWND* phwnd) {
	return E_NOTIMPL;
}

///  @see	IOleInPlaceSite::GetWindowContext
STDMETHODIMP CWebBrowserContainer::GetWindowContext(IOleInPlaceFrame** ppFrame,
		IOleInPlaceUIWindow** ppDoc, LPRECT lprcPosRect, LPRECT lprcClipRect, LPOLEINPLACEFRAMEINFO lpFrameInfo) {
	return E_NOTIMPL;
}

///	Õy[Wɖ߂
void CWebBrowserContainer::GoBack() {
	m_pBrowser->GoBack();
}

///	̃y[Wɐi
void CWebBrowserContainer::GoForward() {
	m_pBrowser->GoForward();
}

///	z[y[W\
void CWebBrowserContainer::GoHome() {
	m_pBrowser->GoHome();
}

/// @see	IOleInPlaceFrame::InsertMenus
STDMETHODIMP CWebBrowserContainer::InsertMenus(HMENU hmenuShared, LPOLEMENUGROUPWIDTHS lpMenuWidths) {
	return E_NOTIMPL;
}

/// @see	IOleContainer::LockContainer
STDMETHODIMP CWebBrowserContainer::LockContainer(BOOL fLock) {
	return E_NOTIMPL;
}

/**
 *	w肵 URI Ɉړ
 *	@param pwszUri	URI
 */
void CWebBrowserContainer::Navigate(const wchar_t* pwszUri) {
	assert(pwszUri);
	m_pBrowser->Navigate(const_cast<wchar_t*>(pwszUri), 0, 0, 0, 0);
}

///	@see	IDocumentContainer::OnActivate
void CWebBrowserContainer::OnActivate(bool bActive) {
	m_pBrowser->put_Visible(toVariantBoolean(bActive));
}

/// @see	IOleInPlaceSite::OnInPlaceActivate
STDMETHODIMP CWebBrowserContainer::OnInPlaceActivate() {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceSite::OnInPlaceDeactivate
STDMETHODIMP CWebBrowserContainer::OnInPlaceDeactivate() {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceSite::OnPosRectChange
STDMETHODIMP CWebBrowserContainer::OnPosRectChange(LPCRECT lprcPosRect) {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceSite::OnUIActivate
STDMETHODIMP CWebBrowserContainer::OnUIActivate() {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceSite::OnUIDeactivate
STDMETHODIMP CWebBrowserContainer::OnUIDeactivate(BOOL fUndoable) {
	return E_NOTIMPL;
}

///	@see	IOleClientSite::OnShowWindow
STDMETHODIMP CWebBrowserContainer::OnShowWindow(BOOL fShow) {
	return S_OK;
}

/// @see	IParseDisplayName::ParseDisplayName
STDMETHODIMP CWebBrowserContainer::ParseDisplayName(IBindCtx* pbc, LPOLESTR pszDisplayName, ULONG* pchEaten, IMoniker** ppmkOut) {
	return E_NOTIMPL;
}

///	@see	IDocumentContainer::RefreshWindow
void CWebBrowserContainer::RefreshWindow() {
	m_pBrowser->Refresh();
}

/// @see	IOleInPlaceFrame::RemoveMenus
STDMETHODIMP CWebBrowserContainer::RemoveMenus(HMENU hmenuShared) {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceUIWindow::RequestBorderSpace
STDMETHODIMP CWebBrowserContainer::RequestBorderSpace(LPCBORDERWIDTHS pborderwidths) {
	return E_NOTIMPL;
}

///	@see	IOleClientSite::RequestNewObjectLayout
STDMETHODIMP CWebBrowserContainer::RequestNewObjectLayout() {
	return E_NOTIMPL;
}

///	@see	IOleClientSite::SaveObject
STDMETHODIMP CWebBrowserContainer::SaveObject() {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceSite::Scroll
STDMETHODIMP CWebBrowserContainer::Scroll(SIZE scrollExtant) {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceUIWindow::SetActiveObject
STDMETHODIMP CWebBrowserContainer::SetActiveObject(IOleInPlaceActiveObject* pActiveObject, LPCOLESTR pszObjName) {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceUIWindow::SetBorderSpace
STDMETHODIMP CWebBrowserContainer::SetBorderSpace(LPCBORDERWIDTHS pborderwidths) {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceFrame::SetMenu
STDMETHODIMP CWebBrowserContainer::SetMenu(HMENU hmenuShared, HOLEMENU holemenu, HWND hwndActiveObject) {
	return E_NOTIMPL;
}

/// @see	IOleInPlaceFrame::SetStatusText
STDMETHODIMP CWebBrowserContainer::SetStatusText(LPCOLESTR pszStatusText) {
	return E_NOTIMPL;
}

///	@see	IOleClientSite::ShowObject
STDMETHODIMP CWebBrowserContainer::ShowObject() {
	return S_OK;
}

/// @see	IOleInPlaceFrame::TranslateAccelerator
STDMETHODIMP CWebBrowserContainer::TranslateAccelerator(LPMSG lpmsg, WORD wID) {
	return E_NOTIMPL;
}
#endif

/* [EOF] */