// NewFileFormatDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "NewFileFormatDlg.h"
#include "Alpha.h"
#include "../Manah/ComboBox.h"
using Alpha::CNewFileFormatDlg;
using Manah::Windows::Controls::CComboBox;
using namespace Ascension::Encodings;
using namespace std;


/// @see	CDialog::OnCommand
bool CNewFileFormatDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID != IDC_COMBO_CHARCODE || wNotifyCode != CBN_SELCHANGE)
		return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);

	const CodePage	cp = SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_GETITEMDATA,
							SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_GETCURSEL, 0, 0L), 0L);
	CComboBox		combobox;

	combobox.Attach(GetDlgItem(IDC_COMBO_BREAKCODE));
	if(cp == CPEX_UNICODE_UTF5 || cp == CP_UTF7 || cp == CP_UTF8
			|| cp == CPEX_UNICODE_UTF16LE || cp == CPEX_UNICODE_UTF16BE
			|| cp == CPEX_UNICODE_UTF32LE || cp == CPEX_UNICODE_UTF32BE) {
		if(combobox.GetCount() != 6) {
			const int	iOrg = (combobox.GetCount() != 0) ? combobox.GetCurSel() : 0;

			combobox.ResetContent();
			combobox.SetItemData(combobox.AddString(
				(m_lineBreak == Ascension::LB_CRLF) ? IDS_BREAK_CRLF L" *" : IDS_BREAK_CRLF), Ascension::LB_CRLF);
			combobox.SetItemData(combobox.AddString(
				(m_lineBreak == Ascension::LB_LF) ? IDS_BREAK_LF L" *" : IDS_BREAK_LF), Ascension::LB_LF);
			combobox.SetItemData(combobox.AddString(
				(m_lineBreak == Ascension::LB_CR) ? IDS_BREAK_CR L" *" : IDS_BREAK_CR), Ascension::LB_CR);
			combobox.SetItemData(combobox.AddString(
				(m_lineBreak == Ascension::LB_NEL) ? IDS_BREAK_NEL L" *" : IDS_BREAK_NEL), Ascension::LB_NEL);
			combobox.SetItemData(combobox.AddString(
				(m_lineBreak == Ascension::LB_LS) ? IDS_BREAK_LS L" *" : IDS_BREAK_LS), Ascension::LB_LS);
			combobox.SetItemData(combobox.AddString(
				(m_lineBreak == Ascension::LB_PS) ? IDS_BREAK_PS L" *" : IDS_BREAK_PS), Ascension::LB_PS);
			combobox.SetCurSel(iOrg);
		}
	} else {
		if(combobox.GetCount() != 3) {
			const int	iOrg = (combobox.GetCount() != 0) ? combobox.GetCurSel() : 0;

			combobox.ResetContent();
			combobox.SetItemData(combobox.AddString(
				(m_lineBreak == Ascension::LB_CRLF) ? IDS_BREAK_CRLF L" *" : IDS_BREAK_CRLF), Ascension::LB_CRLF);
			combobox.SetItemData(combobox.AddString(
				(m_lineBreak == Ascension::LB_LF) ? IDS_BREAK_LF L" *" : IDS_BREAK_LF), Ascension::LB_LF);
			combobox.SetItemData(combobox.AddString(
				(m_lineBreak == Ascension::LB_CR) ? IDS_BREAK_CR L" *" : IDS_BREAK_CR), Ascension::LB_CR);
			combobox.SetCurSel((iOrg < combobox.GetCount()) ? iOrg : 0);
		}
	}
	combobox.Detach();
	return true;
}

///	@see	CDialog::OnInitDialog
bool CNewFileFormatDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	CComboBox		combobox;
	set<CodePage>	codePages;

	// [R[hy[W]
	combobox.Attach(GetDlgItem(IDC_COMBO_CHARCODE));
	CEncoderFactory::GetInstance().EnumCodePages(codePages);
	for(set<CodePage>::const_iterator it = codePages.begin(); it != codePages.end(); ++it) {
		if(CEncoderFactory::GetInstance().IsCodePageForAutoDetection(*it))
			continue;
		if(const wchar_t* pwszCPName = CAlphaApp::GetCodePageName(*it)) {
			const int	iItem = combobox.AddString((*it == m_nCodePage) ?
				(pwszCPName + wstring(L" *")).c_str() : pwszCPName);
			combobox.SetItemData(iItem, *it);
			if(*it == m_nCodePage)
				combobox.SetCurSel(iItem);
		}
	}
	combobox.Detach();

	// [sR[h]
	OnCommand(IDC_COMBO_CHARCODE, CBN_SELCHANGE, 0);
	combobox.Attach(GetDlgItem(IDC_COMBO_BREAKCODE));
	for(int i = 0; i < 6; ++i) {
		if(m_lineBreak == static_cast<Ascension::LineBreak>(combobox.GetItemData(i))) {
			combobox.SetCurSel(i);
			break;
		}
	}
	combobox.Detach();

	// [^Cv]
	combobox.Attach(GetDlgItem(IDC_COMBO_DOCTYPENAMES));
	for(list<wstring>::const_iterator it =
			m_documentTypes.begin(); it != m_documentTypes.end(); ++it)
		combobox.AddString(it->c_str());
	combobox.SetCurSel(m_iDocumentType);
	combobox.Detach();

	return true;
}

///	@see	CDialog::OnOK
void CNewFileFormatDlg::OnOK() {
	m_nCodePage = SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_GETITEMDATA,
					SendDlgItemMessage(IDC_COMBO_CHARCODE, CB_GETCURSEL, 0, 0L), 0L);
	m_lineBreak = static_cast<Ascension::LineBreak>(SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_GETITEMDATA,
					SendDlgItemMessage(IDC_COMBO_BREAKCODE, CB_GETCURSEL, 0, 0L), 0L));
	m_iDocumentType = SendDlgItemMessage(IDC_COMBO_DOCTYPENAMES, CB_GETCURSEL, 0, 0L);

	CDialog::OnOK();
}

/* [EOF] */