// KeyboardMap.h
// (c) 2003-2005 exeal

#ifndef _KEYBOARD_MAP_H_
#define _KEYBOARD_MAP_H_

#include "AlphaInterfaces.h"
#include "resource.h"
#include "../Manah/Object.h"
#include <sstream>


namespace Alpha {
	class CKeyAssignableCommand;

	///	R}h̎ʎq ()
	typedef WORD	CommandId;	// typeof(ACCEL::cmd)

	/// zL[R[ȟ^
	typedef WORD	VirtualKey;	// typeof(ACCEL::key)
	const VirtualKey	VK_NULL = 0;	///< ȃL[

	/// zL[̏CL[
	typedef uchar	KeyModifier;
	const KeyModifier	KM_SHIFT	= 0x01;	///< Shift L[
	const KeyModifier	KM_CTRL		= 0x02;	///< Ctrl L[
	const KeyModifier	KM_ALT		= 0x04;	///< Alt L[

	/// 1Xg[ÑL[gݍ킹
	struct TKeyCombination {
		VirtualKey	key;		///< L[
		KeyModifier	modifiers;	///< CL[

		/// RXgN^
		TKeyCombination(VirtualKey key_ = VK_NULL, KeyModifier modifiers_ = 0) : key(key_), modifiers(modifiers_) {
			assert(key < 0x100);
			assert(modifiers <= (KM_SHIFT | KM_CTRL | KM_ALT));
		}
	};


	/// L[oCh̊Ǘ
	class CKeyboardMap : virtual public ISerializable {
		// RXgN^
	public:
		CKeyboardMap();
		~CKeyboardMap();

		// \bh
	public:
		bool	Assign(const CKeyAssignableCommand& command, const TKeyCombination& keys);
		bool	Assign(const CKeyAssignableCommand& command, const TKeyCombination& firstKeys, const TKeyCombination& secondKeys);
		void	Clear();
		CKeyAssignableCommand*		GetCommand(const TKeyCombination& keys) const;
		CKeyAssignableCommand*		GetCommand(const TKeyCombination& firstKeys, const TKeyCombination& secondKeys) const;
		std::wstring				GetKeyString(CommandId id, bool bShortName) const;
		void	Unassign(const TKeyCombination& keys);
		void	Unassign(const TKeyCombination& firstKeys, const TKeyCombination& secondKeys);

		static const wchar_t*	GetKeyName(VirtualKey key, bool bShortName) throw(std::out_of_range);
		static std::wstring		GetStrokeString(const TKeyCombination& keys, bool bShortName);
		static std::wstring		GetStrokeString(const TKeyCombination& firstKeys, const TKeyCombination& secondKeys, bool bShortName);

		// ISerializable \bh
		bool	IsDirty() const;
		bool	Load(const wchar_t* pwszPathName);
		bool	Save(const wchar_t* pwszPathName);

		// f[^o
	private:
		struct T1stKeyMap {
			CKeyAssignableCommand*		pCommand;		// L[V[PX1Xg[NŏIꍇ̓R}h
			CKeyAssignableCommand***	ppp2ndKeyMap;	// 2Xg[Ngꍇ 8 * 0x0100 ̔z
														// R}h蓖ĂĂȂꍇ͂̃o null
		};
		T1stKeyMap	m_firstKeyMaps[8][0x0100];	// (CL[) * (zL[R[h) ŃR}h͑2L[gݍ킹i[B
												// 0łΉo^ĂȂ
		bool		m_bDirty;
	};


	namespace {
		// L[̖O (蓖ĕs\ȃL[ null)
		const wchar_t*	longKeyNames[0x0100] = {
		/* 0x00 */	0,	0,	0,	0,	0,	0,	0,	0,
					L"BackSpace",	L"Tab",	0,	0,	L"Delete",	L"Enter",	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					L"Esc",	0,	0,	0,	0,	0,	0,	0,
		/* 0x20 */	L"Space",	L"PageUp",	L"PageDown",	L"End",	L"Home",	L"Left",	L"Top",	L"Right",
					L"Down",	0,	0,	0,	0,	L"Insert",	L"Delete",	0,
					L"0",	L"1",	L"2",	L"3",	L"4",	L"5",	L"6",	L"7",
					L"8",	L"9",	0,	0,	0,	0,	0,	0,
		/* 0x40 */	0,	L"A",	L"B",	L"C",	L"D",	L"E",	L"F",	L"G",
					L"H",	L"I",	L"J",	L"K",	L"L",	L"M",	L"N",	L"O",
					L"P",	L"Q",	L"R",	L"S",	L"T",	L"U",	L"V",	L"W",
					L"X",	L"Y",	L"Z",	0,	0,	0,	0,	0,
		/* 0x60 */	0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	L"numpad *",	L"numpad +",	L"|",	L"numpad -",	L"numpad .",	L"numpad /",
					L"F1",	L"F2",	L"F3",	L"F4",	L"F5",	L"F6",	L"F7",	L"F8",
					L"F9",	L"F10",	L"F11",	L"F12",	L"F13",	L"F14",	L"F15",	L"F16",
		/* 0x80 */	L"F17",	L"F18",	L"F19",	L"F20",	L"F21",	L"F22",	L"F23",	L"F24",
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
		/* 0xA0 */	0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	L":",	L";",	L",",	L"-",	L".",	L"/",
		/* 0xC0 */	L"@",	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	L"[",	L"\\",	L"]",	L"^",	0,
		/* 0xE0 */	0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0
		};
		const wchar_t*	shortKeyNames[0x0100] = {
		/* 0x00 */	0,	0,	0,	0,	0,	0,	0,	0,
					L"BS",	L"TAB",	0,	0,	L"Delete",	L"RET",	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					L"ESC",	0,	0,	0,	0,	0,	0,	0,
		/* 0x20 */	L"SPC",	L"PageUp",	L"PageDown",	L"End",	L"Home",	L"Left",	L"Up",	L"Right",
					L"Down",	0,	0,	0,	0,	L"Insert",	L"Delete",	0,
					L"0",	L"1",	L"2",	L"3",	L"4",	L"5",	L"6",	L"7",
					L"8",	L"9",	0,	0,	0,	0,	0,	0,
		/* 0x40 */	0,	L"a",	L"b",	L"c",	L"d",	L"e",	L"f",	L"g",
					L"h",	L"i",	L"j",	L"k",	L"l",	L"m",	L"n",	L"o",
					L"p",	L"q",	L"r",	L"s",	L"t",	L"u",	L"v",	L"w",
					L"x",	L"y",	L"z",	0,	0,	0,	0,	0,
		/* 0x60 */	0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	L"NUMPAD *",	L"NUMPAD +",	L"|",	L"NUMPAD -",	L"NUMPAD .",	L"NUMPAD /",
					L"F1",	L"F2",	L"F3",	L"F4",	L"F5",	L"F6",	L"F7",	L"F8",
					L"F9",	L"F10",	L"F11",	L"F12",	L"F13",	L"F14",	L"F15",	L"F16",
		/* 0x80 */	L"F17",	L"F18",	L"F19",	L"F20",	L"F21",	L"F22",	L"F23",	L"F24",
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
		/* 0xA0 */	0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	L":",	L";",	L",",	L"-",	L".",	L"/",
		/* 0xC0 */	L"@",	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	L"[",	L"\\",	L"]",	L"^",	0,
		/* 0xE0 */	0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0,
					0,	0,	0,	0,	0,	0,	0,	0
		};
	}


	/**
	 *	L[gݍ킹R}h擾
	 *	@param keys	L[gݍ킹
	 *	@return		蓖ĂĂR}hB蓖ĂĂȂƂ nullB
	 *				2Xg[N1Xg[Nڂł CMD_SPECIAL_WAITFOR2NDKEYS ɑ CBuiltInCommand
	 */
	inline CKeyAssignableCommand* CKeyboardMap::GetCommand(const TKeyCombination& keys) const {
		return m_firstKeyMaps[keys.modifiers][keys.key].pCommand;
	}

	/**
	 *	2Xg[ÑL[gݍ킹R}h擾
	 *	@param firstKeys 	1̃L[gݍ킹
	 *	@param secondKeys	2̃L[gݍ킹
	 *	@return				蓖ĂĂR}hB蓖ĂĂȂƂ null
	 */
	inline CKeyAssignableCommand* CKeyboardMap::GetCommand(
			const TKeyCombination& firstKeys, const TKeyCombination& secondKeys) const {
		const T1stKeyMap&	firstKeyMap = m_firstKeyMaps[firstKeys.modifiers][firstKeys.key];
		if(firstKeyMap.ppp2ndKeyMap == 0)
			return 0;
		return (firstKeyMap.ppp2ndKeyMap[secondKeys.modifiers] == 0) ?
			0 : firstKeyMap.ppp2ndKeyMap[secondKeys.modifiers][secondKeys.key];
	}

	/**
	 *	L[̖OԂ
	 *	@param key				zL[
	 *	@param bShortName		Z`̖O擾ꍇ true
	 *	@return					L[BΉL[ꍇ null
	 *	@exception out_of_range	<var>key</var> sȂƂX[
	 */
	inline const wchar_t* CKeyboardMap::GetKeyName(VirtualKey key, bool bShortName) throw(std::out_of_range) {
		if(key >= 0x100)
			throw std::out_of_range("The first argument is invalid as virutal key code.");
		return bShortName ? shortKeyNames[key] : longKeyNames[key];
	}

	/// L[Xg[N\镶Ԃ
	inline std::wstring CKeyboardMap::GetStrokeString(const TKeyCombination& keys, bool bShortName) {
		if(keys.modifiers == 0)
			return bShortName ? shortKeyNames[keys.key] : longKeyNames[keys.key];
		std::wostringstream	ss;

		if(toBoolean(keys.modifiers & KM_CTRL))		ss << (bShortName ? L"C-" : L"Ctrl+");
		if(toBoolean(keys.modifiers & KM_SHIFT))	ss << (bShortName ? L"S-" : L"Shift+");
		if(toBoolean(keys.modifiers & KM_ALT))		ss << (bShortName ? L"M-" : L"Alt+");
		ss << (bShortName ? shortKeyNames[keys.key] : longKeyNames[keys.key]);
		return ss.str();
	}

	/// L[Xg[N\镶Ԃ
	inline std::wstring CKeyboardMap::GetStrokeString(
			const TKeyCombination& firstKeys, const TKeyCombination& secondKeys, bool bShortName) {
		return GetStrokeString(TKeyCombination(firstKeys.key, firstKeys.modifiers), bShortName)
			+ L" " + GetStrokeString(TKeyCombination(secondKeys.key, secondKeys.modifiers), bShortName);
	}

	/// @see	ISerializable::IsDirty
	inline bool CKeyboardMap::IsDirty() const {
		return m_bDirty;
	}
}

#endif /* _KEYBOARD_MAP_H_ */

/* [EOF] */