// FilePropertyDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "FilePropertyDlg.h"
#include "Alpha.h"
#include "../Manah/ListCtrl.h"
using Alpha::CFilePropertyDlg;
using Alpha::CAlphaDoc;
using namespace std;


namespace {
	const wchar_t*	lineBreakNames[] = {
		L"", L"LF (Unix)", L"CR (Macintosh)", L"CR+LF (Windows)",
		L"NEL (U+0085)", L"LS (U+2028)", L"PS (U+2029)"
	};
}

/**
 *	RXgN^
 *	@param buffer	obt@
 */
CFilePropertyDlg::CFilePropertyDlg(const CAlphaDoc& buffer) : m_buffer(buffer) {
}

///	@see	CDialog::OnInitDialog
bool CFilePropertyDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	Manah::Windows::Controls::CListCtrl	propertyList;
	wchar_t				wsz[100];
	SHFILEINFOW			shfi;
	WIN32_FIND_DATAW	wfd;
	bool				bExist = m_buffer.GetPathName() != 0;
	HANDLE				hFile = ::FindFirstFileW(bExist ? m_buffer.GetPathName() : L"", &wfd);
	bool				bTimesAvailable = hFile != INVALID_HANDLE_VALUE;

	if(bExist)
		::SHGetFileInfoW(m_buffer.GetPathName(), 0,
			&shfi, sizeof(SHFILEINFOW), SHGFI_ATTRIBUTES | SHGFI_TYPENAME);
	if(bTimesAvailable)
		::FindClose(hFile);

	propertyList.Attach(GetDlgItem(IDC_LIST_PROPERTIES));
	propertyList.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);
	propertyList.InsertColumn(0, L"vpeB", LVCFMT_LEFT, 90);
	propertyList.InsertColumn(1, L"l", LVCFMT_LEFT, 276);

	propertyList.InsertItem(0, L"t@C");
	propertyList.SetItemText(0, 1, bExist ? m_buffer.GetFileName() : L"(hLg͕ۑĂ܂)");
	propertyList.InsertItem(1, L"tpX");
	propertyList.SetItemText(1, 1, bExist ? m_buffer.GetPathName() : L"(hLg͕ۑĂ܂)");
	propertyList.InsertItem(2, L"t@C̎");
	propertyList.SetItemText(2, 1, bExist ? shfi.szTypeName : L"(hLg͕ۑĂ܂)");
	propertyList.InsertItem(3, L"R[hy[W");
	propertyList.SetItemText(3, 1, CAlphaApp::GetCodePageName(m_buffer.GetCodePage()));
	propertyList.InsertItem(4, L"sR[h");
	propertyList.SetItemText(4, 1, lineBreakNames[m_buffer.GetLineBreak()]);
	propertyList.InsertItem(5, L"^Cv");
	propertyList.SetItemText(5, 1, m_buffer.m_strDocType.c_str());
	propertyList.InsertItem(6, L"s");
	swprintf(wsz, L"%lu", m_buffer.GetLineCount());
	propertyList.SetItemText(6, 1, wsz);

	if(bTimesAvailable) {
		SYSTEMTIME		st;
		wostringstream	ssAttributes;

		propertyList.InsertItem(7, L"TCY");
		swprintf(wsz, L"%lu oCg", wfd.nFileSizeLow);
		propertyList.SetItemText(7, 1, wsz);
		propertyList.InsertItem(8, L"쐬");
		::FileTimeToLocalFileTime(&wfd.ftCreationTime, &wfd.ftCreationTime);
		::FileTimeToSystemTime(&wfd.ftCreationTime, &st);
		::GetDateFormatW(LOCALE_SYSTEM_DEFAULT, 0, &st, 0, wsz, 100);
		wcscat(wsz, L" ");
		::GetTimeFormatW(LOCALE_SYSTEM_DEFAULT, 0, &st, 0, wsz + wcslen(wsz), 100);
		propertyList.SetItemText(8, 1, wsz);
		propertyList.InsertItem(9, L"XV");
		::FileTimeToLocalFileTime(&wfd.ftLastWriteTime, &wfd.ftLastWriteTime);
		::FileTimeToSystemTime(&wfd.ftLastWriteTime, &st);
		::GetDateFormatW(LOCALE_SYSTEM_DEFAULT, 0, &st, 0, wsz, 100);
		wcscat(wsz, L" ");
		::GetTimeFormatW(LOCALE_SYSTEM_DEFAULT, 0, &st, 0, wsz + wcslen(wsz), 100);
		propertyList.SetItemText(9, 1, wsz);

		propertyList.InsertItem(10, L"t@C");
		ssAttributes << hex << wfd.dwFileAttributes << L" (";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_ARCHIVE))		ssAttributes << L"archive;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_COMPRESSED))		ssAttributes << L"compressed;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))		ssAttributes << L"directory;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_ENCRYPTED))		ssAttributes << L"encrypted;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN))			ssAttributes << L"hidden;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_OFFLINE))		ssAttributes << L"offline;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_READONLY))		ssAttributes << L"readonly;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_REPARSE_POINT))	ssAttributes << L"reparse point;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_SPARSE_FILE))	ssAttributes << L"sparse file;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM))			ssAttributes << L"system;";
		if(toBoolean(wfd.dwFileAttributes & FILE_ATTRIBUTE_TEMPORARY))		ssAttributes << L"temporary;";
		ssAttributes << L")";
		propertyList.SetItemText(10, 1, ssAttributes.str().c_str());
	}

	propertyList.Detach();

	return true;
}

///	@see	CDialog::OnSize
void CFilePropertyDlg::OnSize(UINT nType, int cx, int cy) {
	RECT	rect;

	::MoveWindow(GetDlgItem(IDC_LIST_PROPERTIES), 12, 11, cx - 25, cy - 62, true);
	::GetWindowRect(GetDlgItem(IDOK), &rect);
	::MoveWindow(GetDlgItem(IDOK),
		cx - 12 - rect.right + rect.left, cy - 12 - rect.bottom + rect.top,
		rect.right - rect.left, rect.bottom - rect.top, true);
}

/* [EOF] */