// EventHandlerScript.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "EventHandlerScript.h"
#include "Ambient.h"
#include "AlphaScriptHost.h"
#include "Ascension\Encodings\Encoder.h"
#include "../Armaiti/ComBasic.h"
using namespace Ascension::Encodings;
using namespace Alpha;
using namespace Armaiti;
using namespace std;


// CEventHandlerScript class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CEventHandlerScript::CEventHandlerScript(HWND hWnd, CAlphaApp& app) : m_hWnd(hWnd), m_pScriptHost(0), m_app(app) {
	assert(::IsWindow(m_hWnd));
}

///	fXgN^
CEventHandlerScript::~CEventHandlerScript() {
	if(m_pScriptHost != 0) {
		m_pScriptHost->ReleaseScriptEngine();
		m_pScriptHost->ReleaseTopLevelObjects();
		m_pScriptHost->Release();
	}
}

/**
 *	CxgnhĂяo
 *	@param pwszHandlerName	nh
 *	@param pDispParams		
 *	@return					IDispatch::Invoke Ɠ
 */
HRESULT CEventHandlerScript::Invoke(const OLECHAR* pwszHandlerName, DISPPARAMS* pDispParams) {
	if(pwszHandlerName == 0 || pDispParams == 0)
		return E_INVALIDARG;
	if(m_pScriptHost == 0)
		return E_UNEXPECTED;

	// ݂̃XbhXNvgGW쐬XbhŖ
	// GUI XbhɈϏ
	if(::GetCurrentThreadId() != ::GetWindowThreadProcessId(m_hWnd, 0)) {
		pair<const OLECHAR*, DISPPARAMS*>	invocation;
		invocation.first = pwszHandlerName;
		invocation.second = pDispParams;
		::SendMessageW(m_hWnd, MYWM_EVENTHANDLER, 0, reinterpret_cast<LPARAM>(&invocation));
		return S_OK;
	}

	CComPtr<IActiveScript>	pScriptEngine;
	HRESULT					hr;
	IDispatch*				pHandler = 0;
	DISPID					dispid;
	unsigned int			iArgErr;

	m_pScriptHost->GetScriptEngine(*&pScriptEngine);
	if(FAILED(hr = pScriptEngine->GetScriptDispatch(0, &pHandler)))
		return hr;
	if(FAILED(hr = pHandler->GetIDsOfNames(IID_NULL,
			const_cast<OLECHAR**>(&pwszHandlerName), 1, LOCALE_USER_DEFAULT, &dispid)))
		return hr;
	hr = pHandler->Invoke(dispid, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, pDispParams, 0, 0, &iArgErr);
	pHandler->Release();

	return hr;
}

/**
 *	XNvgt@Cǂݍ݁A͂
 *	@param pwszFileName	t@C (ChJ[hL)
 *	@return				
 */
bool CEventHandlerScript::LoadScript(const wchar_t* pwszFileName) {
	assert(pwszFileName != 0);
	
	WIN32_FIND_DATAW	wfd;
	HANDLE				hFind;
	wchar_t				wszFilePath[MAX_PATH];

	// t@CT
	hFind = ::FindFirstFileW(pwszFileName, &wfd);
	if(hFind == INVALID_HANDLE_VALUE)
		return false;
	::FindClose(hFind);
	wcscpy(wszFilePath, pwszFileName);
	wcscpy(::PathFindFileNameW(wszFilePath), wfd.cFileName);

	HANDLE		hFile;
	HGLOBAL		hGlobal = 0;
	uchar*		psz = 0;
	wchar_t*	pwszSource = 0;
	DWORD		dwRead = 0;

	// XNvgǂݍ
	hFile = ::CreateFileW(wszFilePath, GENERIC_READ,
		FILE_SHARE_READ | FILE_SHARE_WRITE, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
	if(hFile == INVALID_HANDLE_VALUE)
		return false;
	hGlobal = ::GlobalAlloc(GMEM_MOVEABLE, wfd.nFileSizeLow);
	psz = static_cast<uchar*>(::GlobalLock(hGlobal));
	if(wfd.nFileSizeLow != 0)
		::ReadFile(hFile, psz, wfd.nFileSizeLow, &dwRead, 0);
	::CloseHandle(hFile);
	if(dwRead == 0) {
		::GlobalUnlock(hGlobal);
		::GlobalFree(hGlobal);
		return false;
	}

	// UTF-8  UTF-16 ɕϊ
	if(dwRead != 0) {
		CEncoder*	pEncoder = CEncoderFactory::GetInstance().CreateEncoder(CP_UTF8);
		pwszSource = new wchar_t[dwRead + 1];
		const size_t	cch = pEncoder->ConvertToUnicode(pwszSource, dwRead, psz, dwRead);
		pwszSource[cch] = 0;
		delete pEncoder;
	} else
		pwszSource = L"";
	::GlobalUnlock(hGlobal);
	::GlobalFree(hGlobal);

	// XNvgGWN
	HRESULT					hr;
	CLSID					clsidEngine;
	CComPtr<IActiveScript>	pScriptEngine;

	m_app.GetScriptLanguageByFileName(wfd.cFileName, clsidEngine);
	if(clsidEngine == CLSID_NULL)
		CAlphaScriptHost::FindScriptEngine(wfd.cFileName, clsidEngine);
	if(clsidEngine == CLSID_NULL) {	// gq猾GWłȂ
		delete[] pwszSource;		// Ƀ}b`t@Cgقǂ
		return false;
	}
	hr = ::CoCreateInstance(clsidEngine, 0, CLSCTX_INPROC,
		IID_IActiveScript, reinterpret_cast<void**>(&pScriptEngine));
	if(FAILED(hr)) {
		delete[] pwszSource;
		return false;
	}

	// p[T̎擾
	CComPtr<IActiveScriptParse>	pParser;

	m_pScriptHost = new CAlphaScriptHost(m_hWnd, pScriptEngine);
	m_pScriptHost->AddRef();
	m_pScriptHost->SetSecurityLevel(true, SSSL_ALLOW);
	m_pScriptHost->SetSecurityLevel(false, SSSL_ALLOW);
	m_pScriptHost->SetScriptPath(wszFilePath);
	hr = pScriptEngine->SetScriptSite(m_pScriptHost);	// ̃\bhĂяoXbhzXgXbh
//	hr = pScriptEngine->SetScriptState(SCRIPTSTATE_INITIALIZED);
	hr = pScriptEngine->QueryInterface(IID_IActiveScriptParse, reinterpret_cast<void**>(&pParser));

	// gbvxIuWFNg̗p
	CComPtr<Ambient::CApplication>	pApp;
	m_app.GetAutomation(&pApp, 0);
	m_pScriptHost->AddTopLevelObject(OLESTR("Ambient"), pApp, SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
//	m_pScriptHost->AddTopLevelObject(OLESTR("Alpha"), pApp, SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
	m_pScriptHost->AddTopLevelObject(OLESTR("WScript"), new Ambient::CScriptHost(m_pScriptHost), SCRIPTITEM_ISVISIBLE);
//	m_pScriptHost->AddTopLevelObject(OLESTR("WSH"), new Ambient::CScriptHost(m_pScriptHost), SCRIPTITEM_ISVISIBLE);

	ITypeLib*	pAmbientTlb;
	if(SUCCEEDED(::LoadTypeLib(Ambient::CAmbientTypeLibPath::GetPath(), &pAmbientTlb))) {
		m_pScriptHost->LoadConstants(*pAmbientTlb);
		pAmbientTlb->Release();
	}

	// 
	if(SUCCEEDED(hr)) {
		EXCEPINFO	exception;

		hr = pParser->InitNew();
		hr = pParser->ParseScriptText(pwszSource,
				0, 0, 0, 0, 0, SCRIPTTEXT_ISVISIBLE, 0,
				static_cast<EXCEPINFO*>(memset(&exception, 0, sizeof(EXCEPINFO))));
	}
	delete[] pwszSource;
	pScriptEngine->SetScriptState(SCRIPTSTATE_CONNECTED);

	if(SUCCEEDED(hr))
		return true;
	else {
		if(m_pScriptHost != 0) {
			m_pScriptHost->Release();
			m_pScriptHost = 0;
		}
		return false;
	}
}

/* [EOF] */