// BufferList.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "BufferList.h"
#include "AlphaDoc.h"
#include "resource.h"

using namespace Alpha;
using namespace std;


// CBufferList class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CBufferList::CBufferList() : m_hImageList(0) {
}

///	fXgN^
CBufferList::~CBufferList() {
	for(size_t i = 0; i < m_buffers.size(); ++i)
		delete m_buffers[i];
	if(m_hImageList != 0) {
		const int	cIcons = ::ImageList_GetImageCount(m_hImageList);
		for(int i = 0; i < cIcons; ++i)
			::DestroyIcon(::ImageList_GetIcon(m_hImageList, i, ILD_NORMAL));
		::ImageList_Destroy(m_hImageList);
	}
}

/// w肵obt@̃CfNXԂBȂꍇ -1
size_t CBufferList::Find(const CAlphaDoc& buffer) const {
	for(size_t i = 0; i < m_buffers.size(); ++i) {
		if(m_buffers[i] == &buffer)
			return i;
	}
	return -1;
}

/**
 *	obt@Xgňړ
 *	@param iBuffer		ړobt@̔ԍ
 *	@param iInsertion	ړ
 *	@throw out_of_range	<var>iBuffer</var> sȂƂX[
 */
void CBufferList::Move(size_t iBuffer, size_t iInsertion) throw(out_of_range) {
	if(iBuffer >= m_buffers.size())
		throw out_of_range("Specified index is out of range.");
	_ResetResources();
}

/**
 *	obt@Xg폜
 *	@param iBuffer	폜hLg̔ԍ
 *	@throw out_of_range	<var>iBuffer</var> sȂƂX[
 */
void CBufferList::Remove(size_t iBuffer) throw(out_of_range) {
	if(iBuffer >= m_buffers.size())
		throw out_of_range("Specified index is out of range.");
	CAlphaDoc*	pBuffer = m_buffers[iBuffer];
	m_buffers.erase(m_buffers.begin() + iBuffer);
	delete pBuffer;
	_ResetResources();
}

///	obt@̃XgɊÂăC[WXg () 쐬Aj[č\
void CBufferList::_ResetResources() {
	if(m_hImageList != 0) {
		const int	cIcons = ::ImageList_GetImageCount(m_hImageList);
		for(int i = 0; i < cIcons; ++i)
			::DestroyIcon(::ImageList_GetIcon(m_hImageList, i, ILD_NORMAL));
		::ImageList_Destroy(m_hImageList);
	}
	if(m_buffers.empty()) {
		m_hImageList = 0;
		return;
	}
	m_hImageList = ::ImageList_Create(::GetSystemMetrics(SM_CXSMICON),
		::GetSystemMetrics(SM_CYSMICON), ILC_COLOR32 | ILC_MASK, 0, m_buffers.size());
	while(m_bufferListMenu.GetItemCount() != 0)
		m_bufferListMenu.DeleteMenuItem(0, false);

	SHFILEINFOW	sfi;
	for(size_t i = 0; i < m_buffers.size(); ++i) {
		::SHGetFileInfoW(
			(m_buffers[i]->GetPathName() != 0) ? m_buffers[i]->GetPathName() : L"",
			0, &sfi, sizeof(SHFILEINFOW), SHGFI_ICON | SHGFI_SMALLICON);
		::ImageList_AddIcon(m_hImageList, sfi.hIcon);
		m_bufferListMenu.AppendMenuItem(i + CMD_VIEW_BUFFERLIST_START, MFT_OWNERDRAW, MFS_ENABLED, 0);
	}
}

/* [EOF] */