// BookmarkDlg.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "BookmarkDlg.h"
#include "Alpha.h"
#include "../Manah/ListCtrl.h"

using Alpha::CBookmarkDlg;
using Alpha::CAlphaApp;
using Alpha::CAlphaDoc;
using namespace Manah::Windows::Controls;
using namespace Ascension;
using namespace std;


///	RXgN^
CBookmarkDlg::CBookmarkDlg(CAlphaApp& app) : m_app(app) {
}

/**
 *	w肵ʒu̍ڏ𓾂
 *	@param iItem	ڂ̈ʒu
 *	@param ppBuffer	[out] obt@
 *	@param iLine	[out] sԍ (0x[X)
 */
void CBookmarkDlg::GetItemInfo(int iItem, CAlphaDoc** ppBuffer, length_t& iLine) const {
	AssertValid();

	CListCtrl	bookmarksList;
	wchar_t		wszLocation[300];
	wchar_t*	pwszDelimiter = 0;

	bookmarksList.Attach(GetDlgItem(IDC_LIST_BOOKMARKS));
	assert(iItem < bookmarksList.GetItemCount());
	bookmarksList.GetItemText(iItem, 1, wszLocation, 300);
	if(ppBuffer != 0)
		*ppBuffer = reinterpret_cast<CAlphaDoc*>(bookmarksList.GetItemData(iItem));
	bookmarksList.Detach();

	pwszDelimiter = wcsrchr(wszLocation, L'(');
	assert(pwszDelimiter != 0);
	iLine = wcstoul(pwszDelimiter + 1, 0, 10);
	--iLine;
}

///	[폜] {^̏
void CBookmarkDlg::OnBtnDelete() {
	HWND		hwndBookmarksListView = GetDlgItem(IDC_LIST_BOOKMARKS);
	const int	iSel = ListView_GetSelectionMark(hwndBookmarksListView);

	if(iSel == -1)	// I
		return;

	CAlphaDoc*	pBuffer;
	length_t	iLine;

	GetItemInfo(iSel, &pBuffer, iLine);
	if(m_bufferIndices.find(pBuffer) == m_bufferIndices.end())
		return;

	pBuffer->GetActiveView().GetBookmarker().SetBookmark(iLine, false);
	ListView_DeleteItem(hwndBookmarksListView, iSel);
	if(ListView_GetItemCount(hwndBookmarksListView) != 0) {
		ListView_SetItemState(hwndBookmarksListView,
			0, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
	} else {
		::EnableWindow(GetDlgItem(IDOK), false);
		::EnableWindow(GetDlgItem(IDC_BTN_DELETE), false);
	}
}

///	ubN}[NXg̍XV
void CBookmarkDlg::UpdateList() {
	const CBufferList&	buffers = m_app.GetBufferList();
	CListCtrl			bookmarksList;
	list<length_t>		lines;
	char_t				wszLocation[300];
	int					iItem = 0;

	m_bufferIndices.clear();
	bookmarksList.Attach(GetDlgItem(IDC_LIST_BOOKMARKS));
	bookmarksList.DeleteAllItems();

	if(IsDlgButtonChecked(IDC_CHK_SHOWALLFILES) == BST_CHECKED) {	// SẴhLgꍇ
		for(size_t i = 0; i < buffers.GetCount(); ++i) {
			const CAlphaDoc&	buffer = buffers.GetAt(i);
			const CAlphaView&	view = buffer.GetActiveView();
			const length_t		nLineOffset = view.GetLayoutSettings().GetSettings().lineNumberLayout.iStartLine;
			const length_t		iTopLine = buffer.GetStartPoint().m_iLine;
			const length_t		iBottomLine = buffer.GetEndPoint().m_iLine;
			length_t			iLine = -1;

			while((iLine = view.GetBookmarker().GetNextBookmark(iLine)) != -1) {
				if(iLine >= iTopLine && iLine <= iBottomLine) {
					string_t	strLine = buffer.GetLine(iLine).substr(0, 100);

					++iItem;
					replace_if(strLine.begin(), strLine.end(), bind2nd(equal_to<wchar_t>(), L'\t'), L' ');
					iItem = bookmarksList.InsertItem(iItem, strLine.c_str());
					swprintf(wszLocation, L"%s(%lu)", buffer.GetFileName(), iLine + nLineOffset);
					bookmarksList.SetItemText(iItem, 1, wszLocation);
					bookmarksList.SetItemData(iItem, reinterpret_cast<DWORD>(&buffer));
					m_bufferIndices[const_cast<CAlphaDoc*>(&buffer)] = i;
				}
			}
		}
	} else {
		// ANeBuȃhLgΏۂɂꍇ
		const CAlphaView&	activeView = m_app.GetActiveView();
		const CAlphaDoc&	activeBuffer = activeView.GetDocument();
		const length_t		nLineOffset = activeView.GetLayoutSettings().GetSettings().lineNumberLayout.iStartLine;
		const length_t		iTopLine = activeBuffer.GetStartPoint().m_iLine;
		const length_t		iBottomLine = activeBuffer.GetEndPoint().m_iLine;
		length_t			iLine = -1;

		while((iLine = activeView.GetBookmarker().GetNextBookmark(iLine)) != -1) {
			if(iLine >= iTopLine && iLine <= iBottomLine) {
				string_t	strLine = activeBuffer.GetLine(iLine).substr(0, 100);

				++iItem;
				replace_if(strLine.begin(), strLine.end(), bind2nd(equal_to<wchar_t>(), L'\t'), L' ');
				iItem = bookmarksList.InsertItem(iItem, strLine.c_str());
				swprintf(wszLocation, L"%s(%lu)", activeBuffer.GetFileName(), iLine + nLineOffset);
				bookmarksList.SetItemText(iItem, 1, wszLocation);
				bookmarksList.SetItemData(iItem, reinterpret_cast<DWORD>(&activeBuffer));
			}
		}
		m_bufferIndices[const_cast<CAlphaDoc*>(&activeBuffer)] = m_app.GetActiveBufferIndex();
	}

	if(bookmarksList.GetItemCount() != 0) {
		bookmarksList.SetItemState(0, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
		::EnableWindow(GetDlgItem(IDOK), true);
		::EnableWindow(GetDlgItem(IDC_BTN_DELETE), true);
	} else {
		::EnableWindow(GetDlgItem(IDOK), false);
		::EnableWindow(GetDlgItem(IDC_BTN_DELETE), false);
	}
	bookmarksList.Detach();
}

///	@see	CDialog::OnCommand
bool CBookmarkDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	switch(wID) {
	case IDC_BTN_ADD: {	// [ǉ]
		m_app.GetActiveView().GetBookmarker().SetBookmark(
			m_app.GetActiveView().GetSelection().GetActivePoint().GetLineNumber(), true);
		UpdateList();
	}
		break;
	case IDC_BTN_DELETE:	// [폜]
		OnBtnDelete();
		break;
	case IDC_BTN_UPDATE:	// [XV]
	case IDC_CHK_SHOWALLFILES:	// [JĂSẴhLg\]
		UpdateList();
		break;
	}

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CBookmarkDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	ModifyStyleEx(0, WS_EX_LAYERED);
	SetLayeredWindowAttributes(0, 220, LWA_ALPHA);

	CListCtrl	bookmarksList;

	bookmarksList.Attach(GetDlgItem(IDC_LIST_BOOKMARKS));
	bookmarksList.ModifyStyleEx(WS_EX_NOPARENTNOTIFY, 0);
	bookmarksList.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);
	bookmarksList.InsertColumn(0, CAlphaApp::GetInstance().LoadString(MSG_LINE).c_str(), LVCFMT_LEFT, 279, -1);
	bookmarksList.InsertColumn(1, CAlphaApp::GetInstance().LoadString(MSG_POSITION).c_str(), LVCFMT_LEFT, 100, -1);
	bookmarksList.Detach();
	UpdateList();

	return true;
}

///	@see	CDialog::OnNotify
bool CBookmarkDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(idCtrl == IDC_LIST_BOOKMARKS && lpNMHDR->code == NM_DBLCLK) {
		OnOK();
		return true;
	}
	return CDialog::OnNotify(idCtrl, lpNMHDR);
}

///	@see	CDialog::OnOK
void CBookmarkDlg::OnOK() {
	const int	iSel = ListView_GetSelectionMark(GetDlgItem(IDC_LIST_BOOKMARKS));

	if(iSel == -1)	// I
		return;

	CAlphaDoc*	pBuffer;
	length_t	iLine;

	GetItemInfo(iSel, &pBuffer, iLine);
	if(m_bufferIndices.find(pBuffer) == m_bufferIndices.end())
		return;

	m_app.GetActiveView().GetSelection().MoveTo(CCharPos(iLine, 0), true);
	m_app.SetActiveBuffer(m_bufferIndices[pBuffer]);
	::SetActiveWindow(GetParent());

	if(IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [Iɕ]
		CDialog::OnOK();
}

/* [EOF] */