// TextSearcher.h
// (c) 2004-2005 exeal

#ifndef _TEXT_SEARCHER_H_
#define _TEXT_SEARCHER_H_
#include "AscensionCommon.h"
#include "../../Manah/Object.h"
#include <stdexcept>
#include <stack>


namespace boost {
	template<class charT, class traits> class basic_regex;
	template<class BidirectionalIterator> struct sub_match;
	template<class BidirectionalIterator, class Allocator> class match_results;
}

namespace Ascension {

	namespace Private {
		// 2̃NX CTextSearcher ANZX邽߂ɖOt̖OԂɓĂ
#ifndef ASCENSION_NO_REGEXP
		class CAscensionRegexTraits;
		typedef boost::basic_regex<char_t, CAscensionRegexTraits>	AscensionRegex;
#endif /* !ASCENSION_NO_REGEXP */
		class CBmSearcher;
	}

	/// 啶̓ꎋ
	enum CaseSensitivity {
		CS_NONE,	///< ʂ
		CS_ASCII,	///< ASCII At@xbĝ݋ʂȂ
		CS_SIMPLE,	///< Unicode P[XtHfBO (P)
		CS_FULL		///< Unicode P[XtHfBO (S)()
	};

	/// @
	enum SearchType {
		ST_LITERAL,		///< ʂ̌
		ST_REGEXP,		///< K\
		ST_WILDCARD,	///< ChJ[h ()
		ST_MIGEMO		///< Migemo
	};

	/// tH[fBOIvV
	typedef ulong	FoldingOption;
	const FoldingOption
		FO_NONE					= 0,							///< 
		FO_ACCENT_REMOVAL		= 1,							///< ANZgL̏
		FO_CANONICAL_DUPLICATES	= FO_ACCENT_REMOVAL << 1,		///< do^R[h|Cg
		FO_DASHES				= FO_CANONICAL_DUPLICATES << 1,	///< _bV (Pd)  U+002D: Hyphen-Minus 
		FO_GREEK_LETTERFORMS	= FO_DASHES << 1,				///< MVLMV
		FO_HEBREW_ALTERNATES	= FO_GREEK_LETTERFORMS << 1,	///< wuC֕ (Sp) wuC
		FO_JAMO					= FO_HEBREW_ALTERNATES,			///< nO݊`
		FO_MATH_SYMBOL			= FO_JAMO << 1,					///< wL <tHg݊> }bsO
		FO_NATIVE_DIGIT			= FO_MATH_SYMBOL << 1,			///<  (Nd)  ASCII ̐
		FO_NOBREAK				= FO_NATIVE_DIGIT << 1,			///< <s֎~݊> }bsO
		FO_OVERLINE				= FO_NOBREAK << 1,				///<  U+203E: Overline 
		FO_POSITIONAL_FORMS		= FO_OVERLINE << 1,				///< <ꓪ`Aꒆ`Aꖖ`A`> ݊}bsO
		FO_SMALL_FORMS			= FO_POSITIONAL_FORMS << 1,		///< <`> ݊}bsO
		FO_SPACE				= FO_SMALL_FORMS << 1,			///< 󔒗ޕ (Zs)  U+0020: Space 
		FO_SPACING_ACCENTS		= FO_SPACE << 1,				///< 肠ANZgL𑗂薳ANZgL (񐄏)
		FO_SUBSCRIPT			= FO_SPACING_ACCENTS << 1,		///< <t> ݊}bsO
		FO_SYMBOL				= FO_SUBSCRIPT << 1,			///< L𕶎 (񐄏)
		FO_UNDERLINE			= FO_SYMBOL << 1,				///<  U+005F: Underline 
		FO_VERTICAL_FORMS		= FO_UNDERLINE << 1;			///< <c> ݊}bsO

	/// WJIvV
	typedef ushort	MultigraphExpansionOption;
	const MultigraphExpansionOption
		MEO_NONE				= 0,							///< 
		MEO_CIRCLED_SYMBOLS		= 1,							///< <ەt> ݊}bsO
		MEO_DOTTED				= MEO_CIRCLED_SYMBOLS << 1,		///< hbgt (U+2488..249B)
		MEO_ELLIPSIS			= MEO_DOTTED << 1,				///< ȗ (U+2024..2026)
		MEO_FRACTION			= MEO_ELLIPSIS << 1,			///< <> ݊}bsO
		MEO_INTEGRAL			= MEO_FRACTION << 1,			///< ϕL (U+222C..222D, U+222F..2230)
		MEO_LIGATURE			= MEO_INTEGRAL << 1,			///< ̑̍
		MEO_PARENTHESIZED		= MEO_LIGATURE << 1,			///< ʕt̕
		MEO_PRIMES				= MEO_PARENTHESIZED << 1,		///< vC (U+2033..2034, U+2036..2037)
		MEO_ROMAN_NUMERALS		= MEO_PRIMES << 1,				///< [} (U+2160..2183)
		MEO_SQUARED				= MEO_ROMAN_NUMERALS << 1,		///< <gݕ> ݊}bsO
		MEO_SQUARED_UNMARKED	= MEO_SQUARED << 1,				///< <square> tĂȂ <gݕ> ݊}bsOs
		MEO_DIGRAPH				= MEO_SQUARED_UNMARKED << 1,	///< d
		MEO_OTHER_MULTIGRAPHS	= MEO_DIGRAPH << 1;				///< d

	/// ătH[fBOIvV
	typedef uchar	ProvisionalFoldingOption;
	const ProvisionalFoldingOption
		PFO_NONE				= 0,							///< 
		PFO_DIACRITIC_REMOVAL	= 1,							///< 敪L̏
		PFO_HAN_RADICAL			= PFO_DIACRITIC_REMOVAL << 1,	///< 񂩂犿
		PFO_KANA				= PFO_HAN_RADICAL << 1,			///< ƕЉ
		PFO_LETTER_FORMS		= PFO_KANA << 1,				///< ώ핶ƌ^
		PFO_SIMPLIFIED_HAN		= PFO_LETTER_FORMS << 1,		///< ȑ̎
		PFO_SUPERSCRIPT			= PFO_SIMPLIFIED_HAN << 1,		///< <t> ݊}bsO
		PFO_SUZHOU_NUMERAL		= PFO_SUPERSCRIPT << 1,			///< hB () Ɗ
		PFO_WIDTH				= PFO_SUZHOU_NUMERAL << 1;		///< Sp`Ɣp`

	/// 镶
	typedef uchar	CharacterSkipOption;
	const CharacterSkipOption
		CSO_NONE			= 0,						///< 
		CSO_PUNCTUATIONS	= 1,						///< ؂蕶
		CSO_SYMBOLS			= CSO_PUNCTUATIONS << 1,	///< L
		CSO_WHITESPACES		= CSO_SYMBOLS << 1,			///< 󔒗ޕ
		CSO_DIACRITICS		= CSO_WHITESPACES << 1,		///< 敪L
		CSO_VOWELS			= CSO_DIACRITICS << 1,		///< ꉹ
		CSO_KASHIDA			= CSO_VOWELS << 1,			///< JV_
		CSO_CONTROLS		= CSO_KASHIDA << 1;			///< 䕶

	/// 
	struct TMatchRange {
		length_t	iFound;		// ʒu
		length_t	cchFound;	// ̒
	};

#ifndef ASCENSION_NO_REGEXP
	/// G[
	class CSearchError {
	public:
		/// G[R[h
		enum Code {
			SUCCEEDED,	///< 
			NO_MATCH,	///< }b`Ȃ
			// ȉAsȐK\p^[̃G[ (boost::regex_constants::error_type 蕡)
			BADPATTERN_BACK_REFERENCE_TO_NON_EXSISTANT,	///< ݂Ȃւ̌Q
			BADPATTERN_INVALID_BRACE_CONTENTS,			///< ʂ̒gs
			BADPATTERN_INVALID_CHARACTER_CLASS_NAME,	///< sȕNX
			BADPATTERN_INVALID_CHARACTER_RANGE,			///< sȕ͈
			BADPATTERN_INVALID_CHARACTER_SET,			///< sȕZbg
			BADPATTERN_INVALID_COLLATING_ELEMENT,		///< sȏƍvf
			BADPATTERN_INVALID_OR_TRAILING_ESCAPE,		///< sȃGXP[v
			BADPATTERN_INVALID_REPEAT,					///< sȌJԂ
			BADPATTERN_MISMATCHED_PAREN,				///< Ήۊʂ
			BADPATTERN_MISMATCHED_BRACE,				///< Ή钆ʂ
			BADPATTERN_TOO_COMPLEX,						///< p^[GȂ߃RpCłȂ
			BADPATTERN_UNKNOWN_ERROR,					///< p^[Ȃڍוs
			// ȉAK\sG[ (boost::regex_constants::error_type 蕡)
			RUNTIMEERROR_OUT_OF_MEMORY,			///< s
			RUNTIMEERROR_OUT_OF_STACK_SPACE,	///< X^bNԂ̌͊
#ifndef ASCENSION_NO_MIGEMO
			// ȉAMigemo G[
			MIGEMO_ERROR,	///< Migemo K\p^[̍쐬Ɏs
#endif /* !ASCENSION_NO_MIGEMO */
		};

		/// RXgN^
		CSearchError() {}
		/// RXgN^
		explicit CSearchError(Code code, length_t position = -1) : m_code(code), m_position(position) {}
		/// G[R[h SUCCEEDED ł true Ԃ
		operator bool() const {return m_code == SUCCEEDED;}
		/// G[R[hԂ
		Code GetCode() const {return m_code;}
		/// p^[擪̈ʒuԂBʒusȏꍇ -1 Ԃ
		length_t GetPosition() const {return m_position;}
		/// K\p^[ԈĂ邱ƂɂG[
		bool IsBadRegexError() const {return m_code >= BADPATTERN_BACK_REFERENCE_TO_NON_EXSISTANT && m_code <= BADPATTERN_UNKNOWN_ERROR;}
		/// vIȃG[
		bool IsFatalError() const {return m_code != SUCCEEDED && m_code != NO_MATCH;}
		/// 񕜕s\ȃG[
		bool IsUnrecoverable() const {return m_code >= RUNTIMEERROR_OUT_OF_MEMORY;}

	private:
		Code		m_code;
		length_t	m_position;
	};
	typedef CSearchError	SearchResult;
#else
	typedef bool			SearchResult;
#endif /* !ASCENSION_NO_REGEXP */

	/**
	 *	@brief	IvV
	 *
	 *	̃tH[fBO UTR #30: Character Foldings ɂ
	 *	(http://www.unicode.org/reports/tr30/)
	 */
	struct TSearchOptions {
		bool						bWholeWord;			///< PPʂŌ
		SearchType					type;				///< @
		CaseSensitivity				caseSensitivity;	///< 啶̋
		FoldingOption				foldingOptions;		///< tH[fBOIvV
		MultigraphExpansionOption	multigraphExpansionOptions;	///< WJIvV
		ProvisionalFoldingOption	provisionalFoldingOptions;	///< ătH[fBOIvV
		CharacterSkipOption			characterSkipOptions;		///< 镶

		/// Zq
		bool operator ==(const TSearchOptions& rhs) const {
			return bWholeWord == rhs.bWholeWord
				&& type == rhs.type
				&& caseSensitivity == rhs.caseSensitivity
				&& foldingOptions == rhs.foldingOptions
				&& multigraphExpansionOptions == rhs.multigraphExpansionOptions
				&& provisionalFoldingOptions == rhs.provisionalFoldingOptions
				&& characterSkipOptions == rhs.characterSkipOptions;
		}
		/// 񓙉Zq
		bool operator !=(const TSearchOptions& rhs) const {
			return !operator ==(rhs);
		}
		/// RXgN^
		TSearchOptions() : bWholeWord(false), type(ST_LITERAL), caseSensitivity(CS_NONE),
				foldingOptions(0), multigraphExpansionOptions(0), /*provisionalFoldingOptions(0),*/ characterSkipOptions(0) {
		}
		/// tH[fBOŕ񒷂̕ςIvVݒ肳Ă邩
		bool IsComplex() const {
			static const FoldingOption	COMPLEX_FOLDING_OPTION_MASK = FO_ACCENT_REMOVAL | FO_JAMO;
			return toBoolean(foldingOptions & COMPLEX_FOLDING_OPTION_MASK)
				|| multigraphExpansionOptions != 0 || characterSkipOptions != 0;
		}
		/// ̓ꎋsIvV1ݒ肳ĂȂ
		bool IsEmpty() const {
			return caseSensitivity == CS_NONE
				&& foldingOptions == 0 && multigraphExpansionOptions == 0
				&& provisionalFoldingOptions == 0 && characterSkipOptions == 0;
		}
	};

/*	/// {BtO (ꎋ镶A\LȂǁBMS Word ̃pN)B
	/// ̃tO͐K\ɂ͎gpłȂ
	typedef ushort	JapaneseFuzzySearchFlag;
	const JapaneseFuzzySearchFlag
		JFSF_KANATYPE					= 0x0001,	///< /Љ
		JFSF_YOUON_SOKUON				= 0x0002,	///< X/
		JFSF_MINUS_PROLONGEDMARK_DASH	= 0x0004,	///< }CiX//_bV
		JFSF_ITERATIONMARK				= 0x0008,	///< JԂL
		JFSF_UNUNIFIEDKANJI				= 0x0010,	///< \L̂
		JFSF_LEGACY_MODERN_KANAFIGURE	= 0x0020,	///< ̐V/
		JFSF_PROLONGEDMARK_VOWEL		= 0x0040,	///< ƕꉹ
		JFSF_DI_JI_DU_ZU				= 0x0080,	///< a/WAd/Y
		JFSF_BA_VA_HA_FA				= 0x0100,	///< o/@An/t@
		JFSF_TSI_THI_TI_DHI_JI			= 0x0200,	///< cB/eB/`AfB/W
		JFSF_HYU_FYU_BYU_VYU			= 0x0400,	///< q/tAr/
		JFSF_SE_SYE_ZE_JE				= 0x0800,	///< Z/VFA[/WF
		JFSF_A_YA_FOLLOWING_I_E			= 0x1000,	///< CiAGiɑA/
		JFSF_KI_KU_FOLLOWEDBY_S			= 0x2000;	///< Ts̑ÕL/N
*/

	/// CN^JnĂȂƂ\O
	/// @see	CIncrementalSearcher
	class EIncrementalSearchIsNotRunning : public std::logic_error {
	public:
		/// RXgN^
		EIncrementalSearchIsNotRunning() : std::logic_error("Incremental search is not running") {}
	};

	/// CN^AhDłȂԂŃAhD悤ƂƂ\O
	/// @see	CIncrementalSearcher::Undo
	class EIncrementalSearchUndoBufferIsEmpty : public std::logic_error {
	public:
		/// RXgN^
		EIncrementalSearchUndoBufferIsEmpty() : std::logic_error("Undo buffer of ncremental search is empty and not undoable.") {}
	};

	class CLexer;
	class CBoundarySearcher;

	/**
	 *	@brief	eLXgs
	 *
	 *	GfB^͂̃NX̃CX^XێĂA錟ɂ̃IuWFNggpB
	 *	NCAg̓GfB^ێĂIuWFNg CEditView::GetTextSearcher
	 *	\bhœ邱Ƃł鑼AŃCX^X쐬邱Ƃł
	 */
	class CTextSearcher : public Manah::CSelfAssertable, public Manah::CNoncopyable {
		// RXgN^
	public:
		CTextSearcher();
		virtual ~CTextSearcher();

		// \bh
	public:
		/*  */
		const string_t&			GetReplaceText() const;
		const string_t&			GetSearchText() const;
		const TSearchOptions&	GetOptions() const;
		bool					IsChangedSinceLastSearch() const;
		static bool				IsMigemoAvailable();
		static bool				IsRegexAvailable();
		void					SetOptions(const TSearchOptions& options);
		void					SetReplaceText(const string_t& strText);
		void					SetSearchText(const string_t& strText);
		/*  */
		SearchResult	Match(const char_t* first, const char_t* last, const CBoundarySearcher& boundary);
		SearchResult	Replace(const char_t* first, const char_t* last, string_t& strReplaced, const CBoundarySearcher& boundary);
		SearchResult	Search(const string_t& strText,
							length_t iBegin, bool bForward, TMatchRange& result, const CBoundarySearcher& boundary);
	private:
		void			_ClearPatternCache();
#ifndef ASCENSION_NO_REGEXP
		CSearchError	_CompileRegexPattern() throw(std::logic_error);
#endif /* !ASCENSION_NO_REGEXP */
		CodePoint	_Fold(CodePoint cp) const;
		template<SearchType type>
		SearchResult	_Match(const char_t* first, const char_t* last, const CBoundarySearcher& boundary);
		template<SearchType type>
		SearchResult	_Replace(const char_t* first, const char_t* last, string_t& strReplaced, const CBoundarySearcher& boundary);
		template<SearchType type>
		SearchResult	_Search(const string_t& strText,
							length_t iBegin, bool bForward, TMatchRange& result, const CBoundarySearcher& boundary);

		// f[^o
	protected:
		string_t		m_strFindWhat;		// 
		string_t		m_strReplaceWith;	// u
		TSearchOptions	m_options;			// IvV
		bool			m_bChangedFromLast;

		friend class Private::CBmSearcher;
		Private::CBmSearcher*		m_pLastLiteralPattern;
#ifndef ASCENSION_NO_REGEXP
		friend class Private::CAscensionRegexTraits;
		Ascension::Private::AscensionRegex*	m_pLastRegexPattern;
		boost::match_results<
			const char_t*, std::allocator<
				boost::sub_match<const char_t*>
			>
		>*	m_pLastRegexMatchResults;
#endif /* !ASCENSION_NO_REGEXP */
	};


	/// CN^
	class CIncrementalSearcher : public Manah::CSelfAssertable {
	public:
		/// CN^̏
		enum State {
			NOT_RUNNING,		///< ͍sĂȂ
			LITERAL_FORWARD,	///< O (̖) 
			LITERAL_BACKWARD,	///<  (̐擪) 
			REGEXP_FORWARD,		///< OK\
			REGEXP_BACKWARD,	///< K\
			MIGEMO_FORWARD,		///< O Migemo 
			MIGEMO_BACKWARD		///<  Migemo 
		};

		/// CxgXi
		interface IEventListener {
			/// OnPatternChanged œn錋
			enum Result {
				FOUND,			///<  (̏ꍇ̌ʂɂȂ)
				NOT_FOUND,		///< Ȃ
				BAD_REGEXP,		///< sȐK͂ꂽ
				REGEXP_ERROR	///< K\ɃG[
			};
			/// fXgN^
			virtual ~IEventListener() {}
			/// ~B̌ OnCompleted Ăяo
			virtual void OnISearchAborted() = 0;
			/// I
			virtual void OnISearchCompleted() = 0;
			/**
			 *	ύXꂽ
			 *	@param result	Vł̌
			 */
			virtual void OnISearchPatternChanged(const SearchResult& result) = 0;
			/// JnB̌ OnPatternChanged Ăяo
			virtual void OnISearchStarted() = 0;
		};

		/// CxgXi̋
		class CEventAdapter : virtual public IEventListener {
			virtual ~CEventAdapter() {}
			virtual void OnISearchAborted() {}
			virtual void OnISearchCompleted() {}
			virtual void OnISearchPatternChanged(const SearchResult& result) {}
			virtual void OnISearchStarted() {}
		};

		// \bh
	public:
		/*  */
		bool			CanUndo() const;
		const string_t&	GetSearchText() const;
		State			GetState() const;
		bool			IsRunning() const;
		/*  */
		void			AbortSearch();
		SearchResult	AddCharacter(char_t ch) throw(EIncrementalSearchIsNotRunning);
		SearchResult	AddCharacter(CodePoint cp) throw(EIncrementalSearchIsNotRunning);
		SearchResult	AddString(const char_t* first, const char_t* last) throw(EIncrementalSearchIsNotRunning, std::invalid_argument);
		SearchResult	AddString(const string_t& str) throw(EIncrementalSearchIsNotRunning, std::invalid_argument);
		void			BeginSearch(CEditView& view, State type, IEventListener* pEventListener = 0);
		void			EndSearch();
		SearchResult	JumpToNextMatch(State type) throw(EIncrementalSearchIsNotRunning, std::invalid_argument);
		void			Reset() throw(EIncrementalSearchIsNotRunning);
		SearchResult	Undo() throw(EIncrementalSearchIsNotRunning, EIncrementalSearchUndoBufferIsEmpty);
	private:
		SearchResult	_Update();
		
		// f[^o
	private:
		enum _Operation {TYPE, JUMP};
		struct _TStatus {
			CCharPos	pos0, pos1;	// }b`ʒu
			State		state;		// ̂Ƃ̌
		};
		CEditView*				m_pView;			// Ώۃr[
		IEventListener*			m_pEventListener;	// CxgXi
		std::stack<_Operation>	m_operationHistory;	// 엚
		std::stack<_TStatus>	m_statusHistory;	// ԗ
		_TStatus*				m_pFirstStatus;		// m_statusHistory ̈ԉւ̃|C^
		string_t				m_strPattern;		// 
		string_t				m_strLastPattern;	// O񌟍Ǐ
		bool					m_bMatched;			// Ō _Update ĂяoňveLXg
	};


	/**
	 *	@brief	NX^EAPꋫEAE
	 *
	 *	GfB^͂̃NX̃CX^XێĂAEA
	 *	PꋫÊɂ̃IuWFNggpBNCAg̓GfB^ێĂIuWFNg
	 *	CEditView::GetBoundarySearcher \bhœ邱Ƃł鑼A
	 *	ŃCX^X쐬邱Ƃł
	 */
	class CBoundarySearcher : public Manah::CSelfAssertable {
		// 
	public:
		/// ̌\bhŎgtO
		enum SearchPart {
			START					= 0x01,						///< 擪
			END						= 0x02,						///< I[
			AROUND					= START | END,				///< [
			ALPHA_NUMERIC			= 0x04,						///< P\̂
			WORD_START				= START | ALPHA_NUMERIC,	///< P擪
			WORD_END				= END | ALPHA_NUMERIC,		///< PI[
			WORD_AROUND				= AROUND | ALPHA_NUMERIC,	///< Pꗼ[
			ONLY_CURRENT_LINE		= 0x08,						///< Jnsł̂݌
			RESTRICTION_EFFECTIVE	= 0x10						///< i[CỎe󂯂
		};

		// RXgN^
	public:
		CBoundarySearcher(const CEditDoc& document, const CLexer& lexer);

		// \bh
	public:
		static bool		AreSameScriptType(CodePoint cp1, CodePoint cp2);
		const CEditDoc&	GetDocument() const;
		const CLexer&	GetLexer() const;
		bool			HasParagraphBoundaryAt(const string_t& str, length_t index) const;
		bool			HasSentenceBoundaryAt(const string_t& str, length_t index) const;
		bool			HasWordBoundaryAt(const string_t& str, length_t index) const;
		static bool		IsGraphemeBase(CodePoint cp);
		CCharPos		SearchGraphemeBase(const CCharPos& pos, bool bForward) const;
		CCharPos		SearchParagraphBoundary(const CCharPos& pos, bool bForward, SearchPart part) const;
		CCharPos		SearchSentenceBoundary(const CCharPos& pos, bool bForward, SearchPart part) const;
		CCharPos		SearchWordBoundary(const CCharPos& pos, bool bForward, SearchPart part) const;
	private:
		enum _WBClass {
			format, aLetter, midLetter, midNumLet, midNum,
			numeric, space, other, uncalculated
		} _GetWordBoundaryClass(CodePoint cp) const;

		// f[^o
	private:
		const CEditDoc&	m_document;
		const CLexer&	m_lexer;
	};


// inline implementation
////////////////////////////////////////////////////////////////////////////////

	/// AhD\Ԃ
	inline bool CIncrementalSearcher::CanUndo() const {
		AssertValid();
		return !m_operationHistory.empty();
	}

	/// ݂̌Ԃ
	inline const string_t& CIncrementalSearcher::GetSearchText() const {
		AssertValid();
		return m_strPattern;
	}

	/// ݂̌^CvԂ
	inline CIncrementalSearcher::State CIncrementalSearcher::GetState() const {
		AssertValid();
		return m_statusHistory.empty() ? NOT_RUNNING : m_statusHistory.top().state;
	}

	/// ݌sԂ
	inline bool CIncrementalSearcher::IsRunning() const {
		AssertValid();
		return GetState() != CIncrementalSearcher::NOT_RUNNING;
	}

	/// ݐݒ肳Ă錟Ԃ
	inline const TSearchOptions& CTextSearcher::GetOptions() const {
		AssertValid();
		return m_options;
	}

	/// uԂ
	inline const string_t& CTextSearcher::GetReplaceText() const {
		AssertValid();
		return m_strReplaceWith;
	}

	/// Ԃ
	inline const string_t& CTextSearcher::GetSearchText() const {
		AssertValid();
		return m_strFindWhat;
	}

	/// ŌɌĂ猟IvVύXĂ邩Ԃ
	inline bool CTextSearcher::IsChangedSinceLastSearch() const {
		AssertValid();
		return m_bChangedFromLast;
	}

	///	K\\ǂԂ
	inline bool CTextSearcher::IsRegexAvailable() {
#ifdef ASCENSION_NO_REGEXP
		return false;
#else
		return true;
#endif /* ASCENSION_NO_REGEXP */
	}

	/**
	 *	݂̖̌ɕǉ
	 *	@param str	ǉ镶
	 *	@return		Č̐
	 *	@throw		std::invalid_argument	<var>str</var> 󕶎̂ƂX[
	 */
	inline SearchResult CIncrementalSearcher::AddString(const string_t& str) throw(EIncrementalSearchIsNotRunning, std::invalid_argument) {
		return AddString(str.data(), str.data() + str.length());
	}

	///	hLgԂ
	inline const CEditDoc& CBoundarySearcher::GetDocument() const {
		AssertValid();
		return m_document;
	}

	///	͊Ԃ
	inline const CLexer& CBoundarySearcher::GetLexer() const {
		AssertValid();
		return m_lexer;
	}

} // namespace Ascension

#endif /* _TEXT_SEARCHER_H_ */

/* [EOF] */