// TextSearcher.cpp
// (c) 2004-2005 exeal

/**
 *	@file	TextSearcher.cpp
 *	eLXgIuWFNg̎
 *
 *	Ascension ł͐K\̎ Boost.Regex (http://www.boost.org/libs/regex/)A
 *	{꒼ڌ̎ C/Migemo (http://www.kaoriya.net/#CMigemo) gpB
 *	̊OCupӂłȂꍇ Config.h ŕKvȃV{ (ASCENSION_NO_*) `
 *
 *	<h2>K\ (Boost.Regex)</h2>
 *
 *	_ł͐K\CuƂ
 *	Boost.Regex gĂ邪Ap郉Cu͕ω\BA
 *	wb_ (TextSearcher.h) ɂ̓Cuւ̎QƂ͖AAscension ̃NCAgɂ
 *	Boost.Regex gĂ邱Ƃ͕ȂBBoost.Regex 瓊ꂽOS
 *	Ascension ŏăNCAgɂ͓]Ȃ
 *	(x҂߂ɗOł͂ȂG[R[h (SearchError) Ԃ)
 *
 *	<h2>{꒼ڌ (C/Migemo)</h2>
 *
 *	{꒼ڌ͐K\p\łȂΗpłȂ
 *
 *	<h2>płȂꍇ̃NCAg̑Ή</h2>
 *
 *	K\ɂĂ ASCENSION_NO_REGEXP A{꒼ڌɂĂ ASCENSION_NO_MIGEMO
 *	`邱ƂŁAOCuւ̎QƂACupӂłȂꍇł
 *	Ascension rh邱ƂłBNCAǧ@\pł邩𒲂ׂɂ
 *	CTextSearcher NX̐ÓI\bh CTextSearcher::IsRegexAvailable ACTextSearcher::IsMigemoAvailable
 *	gƂ悢B̌ʂ͈xm肷΃vZX̏I܂œlԂB
 *	ACMigemo ɂĂ͎s DLL ǂݍނ߁ARpCɂ͗p\ǂłȂ
 *
 *	płȂꍇɌsƂ assert Ɏs邽߁A
 *	Ăяo͕Kȏ̃\bhgČ^Cvp\ׂȂ΂ȂȂ
 *	(O𓊂݌vł͂Ȃ)
 */

#include "StdAfx.h"
#include "TextSearcher.h"
#include "EditView.h"

#ifndef ASCENSION_NO_REGEXP
#include "Lexer.h"
#include <boost/regex.hpp>
namespace {
	inline Ascension::CSearchError::Code TranslateRegexError(boost::regex_constants::error_type code) {
		using namespace boost::regex_constants;
		using Ascension::CSearchError;
		switch(code) {
		case error_collate:		return CSearchError::BADPATTERN_INVALID_COLLATING_ELEMENT;
		case error_ctype:		return CSearchError::BADPATTERN_INVALID_CHARACTER_CLASS_NAME;
		case error_escape:		return CSearchError::BADPATTERN_INVALID_OR_TRAILING_ESCAPE;
		case error_backref:		return CSearchError::BADPATTERN_BACK_REFERENCE_TO_NON_EXSISTANT;
		case error_brack:		return CSearchError::BADPATTERN_INVALID_CHARACTER_SET;
		case error_paren:		return CSearchError::BADPATTERN_MISMATCHED_PAREN;
		case error_brace:		return CSearchError::BADPATTERN_MISMATCHED_BRACE;
		case error_badbrace:	return CSearchError::BADPATTERN_INVALID_BRACE_CONTENTS;
		case error_range:		return CSearchError::BADPATTERN_INVALID_CHARACTER_RANGE;
		case error_space:		return CSearchError::RUNTIMEERROR_OUT_OF_MEMORY;
		case error_badrepeat:	return CSearchError::BADPATTERN_INVALID_REPEAT;
		case error_complexity:	return CSearchError::BADPATTERN_TOO_COMPLEX;
		case error_stack:		return CSearchError::RUNTIMEERROR_OUT_OF_STACK_SPACE;
		case error_bad_pattern:	return CSearchError::BADPATTERN_UNKNOWN_ERROR;
		default:				assert(false);
		}
		return static_cast<CSearchError::Code>(-1);	// Ӗ
	}
}
#endif /* !ASCENSION_NO_REGEXP */

using namespace Ascension;
using namespace std;

#ifndef ASCENSION_NO_REGEXP
#	define MATCH_TAG			CSearchError(CSearchError::SUCCEEDED)
#	define NO_MATCH_TAG			CSearchError(CSearchError::NO_MATCH)
#	define MAKE_REGEX_ERROR(e)	CSearchError(TranslateRegexError(e.code()), e.position())
#else
#	define MATCH_TAG			true
#	define NO_MATCH_TAG			false
#endif /* !ASCENSION_NO_REGEXP */


// private helpers
/////////////////////////////////////////////////////////////////////////////

#ifndef ASCENSION_NO_MIGEMO
#include "migemo.h"
namespace {	// C/Migemo
	class CMigemo {
	public:
		CMigemo() : m_hDll(0), m_pszLast(0), m_pwszLast(0), m_migemoQuery(0), m_migemoRelease(0), m_migemoIsEnable(0) {
		}
		~CMigemo() {
			if(m_hDll != 0) {
				ReleasePatterns();
				if(migemo_close_t migemo_close = reinterpret_cast<migemo_close_t>(::GetProcAddress(m_hDll, "migemo_close")))
					migemo_close(m_pInstance);
				::FreeLibrary(m_hDll);
			}
		}
		const unsigned char* Query(const unsigned char* psz) {
			if(m_pInstance == 0)
				const_cast<CMigemo*>(this)->_Open();
			assert(m_migemoQuery != 0 && m_migemoRelease != 0);
			if(m_pszLast != 0)
				m_migemoRelease(m_pInstance, m_pszLast);
			return m_pszLast = m_migemoQuery(m_pInstance, const_cast<unsigned char*>(psz));
		}
		const char_t* Query(const char_t* pwsz, size_t cchInput, size_t& cchOutput) {
			assert(pwsz != 0);
			if(!toBoolean(::IsValidCodePage(932)))
				return 0;
			const int	cchMultiBytes = ::WideCharToMultiByte(932, 0, pwsz, cchInput, 0, 0, 0, 0);
			uchar*		pszCp932 = new uchar[cchMultiBytes + 1];

			::WideCharToMultiByte(932, 0, pwsz, cchInput, reinterpret_cast<char*>(pszCp932), cchMultiBytes, 0, 0);
			pszCp932[cchMultiBytes] = 0;
			Query(pszCp932);
			delete[] pszCp932;

			if(m_pszLast == 0)
				return 0;

			const size_t	cbPattern = strlen(reinterpret_cast<const char*>(m_pszLast));

			cchOutput = ::MultiByteToWideChar(932, MB_PRECOMPOSED,
								reinterpret_cast<const char*>(m_pszLast), cbPattern, 0, 0);
			delete[] m_pwszLast;
			m_pwszLast = new char_t[cchOutput];
			::MultiByteToWideChar(932, MB_PRECOMPOSED,
				reinterpret_cast<const char*>(m_pszLast), cbPattern, m_pwszLast, cchOutput);
			return m_pwszLast;
		}
		const char_t* Query(const string_t& str, size_t& cchOutput) {
			return Query(str.data(), str.length(), cchOutput);
		}
		void ReleasePatterns() {	// explicit release
			if(m_pszLast != 0) {
				m_migemoRelease(m_pInstance, m_pszLast);
				m_pszLast = 0;
			}
			delete[] m_pwszLast;
			m_pwszLast = 0;
		}
		bool IsEnable() const {
			if(m_pInstance == 0) {
				if(!const_cast<CMigemo*>(this)->_Open())
					return false;
			}
			if(m_migemoIsEnable == 0)
				return false;
			return toBoolean(m_migemoIsEnable(m_pInstance));
		}
	private:
		bool _Open() {
			WCHAR	wszPath[MAX_PATH + 12];

			wcscpy(wszPath, Ascension::CEditView::GetMigemoPath(true));

			size_t	cchPath = wcslen(wszPath);

			if(cchPath == 0)
				return false;
			wcscpy(wszPath + cchPath, (wszPath[cchPath - 1] != L'\\') ? L"\\migemo.dll" : L"migemo.dll");
			if(m_hDll = ::LoadLibraryW(wszPath)) {
				if(migemo_open_t migemo_open = reinterpret_cast<migemo_open_t>(::GetProcAddress(m_hDll, "migemo_open"))) {
					m_pInstance = migemo_open(0);
					m_migemoQuery = reinterpret_cast<migemo_query_t>(::GetProcAddress(m_hDll, "migemo_query"));
					m_migemoRelease = reinterpret_cast<migemo_release_t>(::GetProcAddress(m_hDll, "migemo_release"));
					m_migemoIsEnable = reinterpret_cast<migemo_is_enable_t>(::GetProcAddress(m_hDll, "migemo_is_enable"));

					wcscpy(wszPath, Ascension::CEditView::GetMigemoPath(false));
					cchPath = wcslen(wszPath);
					if(cchPath == 0)
						return false;
					else if(wszPath[cchPath - 1] != L'\\') {
						wcscpy(wszPath + cchPath, L"\\");
						++cchPath;
					}

					char*		pszDictionaryPath;
					const int	cbMultiBytes = ::WideCharToMultiByte(CP_ACP, 0, wszPath, cchPath + 1, 0, 0, 0, 0);

					pszDictionaryPath = new char[cbMultiBytes + 16];
					::WideCharToMultiByte(CP_ACP, 0, wszPath, cchPath + 1, pszDictionaryPath, cbMultiBytes, 0, 0);

					migemo_load_t	migemo_load = reinterpret_cast<migemo_load_t>(::GetProcAddress(m_hDll, "migemo_load"));

					strcpy(pszDictionaryPath + cbMultiBytes - 1, "migemo-dict");
					migemo_load(m_pInstance, MIGEMO_DICTID_MIGEMO, pszDictionaryPath);
					strcpy(pszDictionaryPath + cbMultiBytes - 1, "roma2hira.dat");
					migemo_load(m_pInstance, MIGEMO_DICTID_ROMA2HIRA, pszDictionaryPath);
					strcpy(pszDictionaryPath + cbMultiBytes - 1, "hira2kata.dat");
					migemo_load(m_pInstance, MIGEMO_DICTID_HIRA2KATA, pszDictionaryPath);
					strcpy(pszDictionaryPath + cbMultiBytes - 1, "han2zen.dat");
					migemo_load(m_pInstance, MIGEMO_DICTID_HAN2ZEN, pszDictionaryPath);
					delete[] pszDictionaryPath;

					migemo_set_operator_t	migemo_set_operator =
						reinterpret_cast<migemo_set_operator_t>(::GetProcAddress(m_hDll, "migemo_set_operator"));
					migemo_set_operator(m_pInstance, MIGEMO_OPINDEX_OR, reinterpret_cast<uchar*>("\\|"));
					migemo_set_operator(m_pInstance, MIGEMO_OPINDEX_NEST_IN, reinterpret_cast<uchar*>("\\("));
					migemo_set_operator(m_pInstance, MIGEMO_OPINDEX_NEST_OUT, reinterpret_cast<uchar*>("\\)"));

					return true;
				}
			}
			return false;
		}
	private:
		typedef migemo*(*migemo_open_t)(char*);
		typedef void(*migemo_close_t)(migemo*);
		typedef unsigned char*(*migemo_query_t)(migemo*, unsigned char*);
		typedef void(*migemo_release_t)(migemo*, unsigned char*);
		typedef int(*migemo_load_t)(migemo*, int, char*);
		typedef int(*migemo_is_enable_t)(migemo*);
		typedef int(*migemo_set_operator_t)(migemo*, int, unsigned char*);

		HMODULE				m_hDll;
		migemo*				m_pInstance;
		unsigned char*		m_pszLast;
		wchar_t*			m_pwszLast;
		migemo_query_t		m_migemoQuery;
		migemo_release_t	m_migemoRelease;
		migemo_is_enable_t	m_migemoIsEnable;
	} g_migemo;
} // namespace `anonymous'
#endif /* !ASCENSION_NO_MIGEMO */


namespace {	// R[h|Cg̕
	const CodePoint	_IGNORABLE_CODE_POINT = 0xFFFFFFFF;

	// ʕނ Pc, Pd, Ps, Pe, Pi, Pf, Po łR[h|Cg unicat.pl 萶
	const CodePoint	punctuations[] = {
#if(ASCENSION_UNICODE_VERSION != 0x0410)
#error Included file version differs from Ascension Unicode version. Update correspoding file.
#endif
#include "script\TextSearcher_Punctuation"
	};

	// ʕނ Sm, Sc, Sk, So łR[h|Cg unicat.pl 萶
	const CodePoint	symbols[] = {
#if(ASCENSION_UNICODE_VERSION != 0x0410)
#error Included file version differs from Ascension Unicode version. Update correspoding file.
#endif
#include "script\TextSearcher_Symbol"
	};

	// ʕނ Zs łR[h|Cg unicat.pl 萶
	// Lexer::IsWhiteSpace Q
#if(ASCENSION_UNICODE_VERSION != 0x0410)
#error Included file version differs from Ascension Unicode version. Update correspoding file.
#endif
	const char_t	zs[] = {
		0x0020, 0x00A0, 0x1680, 0x180E, 0x2000, 0x2001, 0x2002, 0x2003,
		0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009, 0x200A, 0x202F,
		0x205F, 0x3000,
	};

	// ʕނ Cc, Cf łR[h|Cg unicat.pl 萶
	const CodePoint	controls[] = {
#if(ASCENSION_UNICODE_VERSION != 0x0410)
#error Included file version differs from Ascension Unicode version. Update correspoding file.
#endif
#include "script\TextSearcher_Control"
	};

#ifndef ASCENSION_NO_REGEXP
	struct TUnicodeBlock {
		const char_t*	pwszClassName;
		CodePoint		nStartCodePoint, nEndCodePoint;
	};
	const TUnicodeBlock	blocks[] = {
#if(ASCENSION_UNICODE_VERSION != 0x0410)
#error Included file version differs from Ascension Unicode version. Update correspoding file.
#endif
#include "script\TextSearcher_Blocks"
	};
#endif /* !ASCENSION_NO_REGEXP */
} // namespace `anonymous'

namespace {	// tH_̒`
	template<CaseSensitivity> class CCaseFolder {
		public:	static CodePoint	Fold(CodePoint cp);
	};
	template<FoldingOption> class CFolder {
		public:	static CodePoint	Fold(CodePoint cp);
	};
//	template<MultigraphExpansionOption> class CMultigraphExpander {
//		public:	static size_t Expand(CodePoint cp, );
//	};
	template<ProvisionalFoldingOption> class CProvisionalFolder {
		public:	static CodePoint	Fold(CodePoint cp);
	};
	template<CharacterSkipOption> class CCharacterSkipper {
		public:	static bool	IsIgnorable(CodePoint cp);
	};

	const char_t smallFormsFoldingTable[] = {	// for CFolder<FO_SMALL_FORMS>
		0x002C, 0x3001, 0x002E, 0x003B, 0x003A, 0x003F, 0x0021, 0x2014,
		0x0028, 0x0029, 0x007B, 0x007D, 0x3014, 0x3015, 0x0023, 0x0026,
		0x002A, 0x002B, 0x002D, 0x003C, 0x003E, 0x003D, 0x005C, 0x0024,
		0x0025, 0x0040,
	};

	template<> inline CodePoint CCaseFolder<CS_NONE>::Fold(CodePoint cp) {
		return cp;
	}
	template<> inline CodePoint CCaseFolder<CS_ASCII>::Fold(CodePoint cp) {
		return (cp < 0x80) ? towlower(static_cast<wchar_t>(cp)) : cp;
	}
	template<> inline CodePoint CCaseFolder<CS_SIMPLE>::Fold(CodePoint cp) {
		return CLexer::CaseFoldCharacter(cp);
	}

	template<> inline CodePoint CFolder<FO_CANONICAL_DUPLICATES>::Fold(CodePoint cp) {
		switch(cp) {
		case 0x0374:	return 0x02B9;	// Greek Numeral Sign -> Modifier Letter Prime
		case 0x037E:	return 0x003B;	// Greek Question Mark -> Semicolon
		case 0x0387:	return 0x00B7;	// Greek Ano Teleia -> Middle Dot
		case 0x1FBE:	return 0x03B9;	// Greek Prosgegrammeni -> Greek Small Letter Iota
		case 0x1FEF:	return 0x0060;	// Greek Varia -> Grave Accent
		case 0x1FFD:	return 0x00B4;	// Greek Oxia -> Acute Accent
		case 0x2000:	return 0x2002;	// En Quad -> En Space
		case 0x2001:	return 0x2003;	// Em Quad -> Em Space
		case 0x2126:	return 0x03A9;	// Ohm Sign -> Greek Capital Letter Omega
		case 0x212A:	return 0x004B;	// Kelvin Sign -> Latin Capital Letter K
		case 0x212B:	return 0x00C5;	// Angstrom Sign -> Latin Capital Letter A With Ring Above
		case 0x2329:	return 0x3008;	// Left-Pointing Angle Bracket -> Left Angle Bracket
		case 0x232A:	return 0x3009;	// Right-Pointing Angle Bracket -> Right Angle Bracket
		default:		return cp;
		}
	}
	template<> inline CodePoint CFolder<FO_DASHES>::Fold(CodePoint cp) {
		static const wchar_t	pd[] = {
			0x058A, 0x1806, 0x2010, 0x2011, 0x2012, 0x2013, 0x2014, 0x2015,
			0x301C, 0x3030, 0x30A0, 0xFE31, 0xFE32, 0xFE58, 0xFE63, 0xFF0D
		};
		return binary_search(pd, _endof(pd), cp) ? 0x002D : cp;
	}
	template<> inline CodePoint CFolder<FO_GREEK_LETTERFORMS>::Fold(CodePoint cp) {
		switch(cp) {
		case 0x03D0:	return 0x03B2;	// Greek Beta Symbol -> Greek Small Letter Beta
		case 0x03D1:	return 0x03B8;	// Greek Theta Symbol -> Greek Small Letter Theta
		case 0x03D2:	return 0x03A5;	// Greek Upsilon With Hook Symbol -> Greek Capital Letter Upsilon
		case 0x03D5:	return 0x03C6;	// Greek Phi Symbol -> Greek Small Letter Phi
		case 0x03D6:	return 0x03C0;	// Greek Pi Symbol -> Greek Small Letter Pi
		case 0x03F0:	return 0x03BA;	// Greek Kappa Symbol -> Greek Small Letter Kappa
		case 0x03F1:	return 0x03C1;	// Greek Rho Symbol -> Greek Small Letter Rho
		case 0x03F2:	return 0x03C2;	// Greek Lunate Sigma Symbol -> Greek Small Letter Final Sigma
		case 0x03F4:	return 0x0398;	// Greek Capital Theta Symbol -> Greek Capital Letter Theta
		case 0x03F5:	return 0x03B5;	// Greek Lunate Epsilon Symbol -> Greek Small Letter Epsilon
		default:		return cp;
		}
	}
	template<> inline CodePoint CFolder<FO_HEBREW_ALTERNATES>::Fold(CodePoint cp) {
		if(cp >= 0xFB20 && cp <= 0xFB28) {
			static const wchar_t	hebrewAlternatives[] = {
				0x05E2, 0x05D0, 0x05D3, 0x05D4, 0x05DB, 0x05DC, 0x05DD, 0x05E8, 0x05EA
			};
			return hebrewAlternatives[cp - 0xFB20];
		}
		return cp;
	}
	template<> inline CodePoint CFolder<FO_OVERLINE>::Fold(CodePoint cp) {
		return (cp >= 0xFE49 && cp <= 0xFE4C) ? 0x203E : cp;
	}
	template<> inline CodePoint CFolder<FO_NATIVE_DIGIT>::Fold(CodePoint cp) {
		return FoldDigit(cp);
	}
	template<> inline CodePoint CFolder<FO_NOBREAK>::Fold(CodePoint cp) {
		switch(cp) {
		case 0x00A0:	return 0x0020;	// No-Break Space -> Space
		case 0x0F0C:	return 0x0F0D;	// Tibetan Mark Delimiter Tsheg Bstar -> Tibetan Mark Shad
		case 0x2007:	return 0x0020;	// Figure Space -> Space
		case 0x2011:	return 0x2010;	// Non-Breaking Hyphen -> Hyphen
		case 0x202F:	return 0x0020;	// Narrow No-Break Space -> Space
		default:		return cp;
		}
	}
	template<> inline CodePoint CFolder<FO_SPACE>::Fold(CodePoint cp) {
		return binary_search(zs, _endof(zs), cp) ? 0x0020 : cp;
	}
	template<> inline CodePoint CFolder<FO_SMALL_FORMS>::Fold(CodePoint cp) {
		return (cp >= 0xFE50 && cp <= 0xFE6B) ? smallFormsFoldingTable[cp - 0xFE50] : cp;
	}
	template<> inline CodePoint CFolder<FO_UNDERLINE>::Fold(CodePoint cp) {
		return (cp == 0x2017 || (cp >= 0xFE4D && cp <= 0xFE4F)) ? 0x005E : cp;
	}

	template<> inline CodePoint CProvisionalFolder<PFO_KANA>::Fold(CodePoint cp) {
		// Љɓ
		return ((cp >= 0x30A1 && cp <= 0x30F6) || cp == 0x30FD || cp == 0x30FE) ? cp - 0x0060 : cp;
	}
	template<> inline CodePoint CProvisionalFolder<PFO_LETTER_FORMS>::Fold(CodePoint cp) {
		// based on LetterformFolding.txt obtained from UTR #30
		switch(cp) {
		case 0x017F:	return 0x0073;	// Latin Small Letter Long S -> Latin Small Letter S
		case 0x03D0:	return 0x03B2;	// Greek Beta Symbol -> Greek Small Letter Beta
		case 0x03D1:	return 0x03B8;	// Greek Theta Symbol -> Greek Small Letter Theta
		case 0x03D2:	return 0x03A5;	// Greek Upsilon With Hook Symbol -> Greek Capital Letter Upsilon
		case 0x03D5:	return 0x03C6;	// Greek Phi Symbol -> Greek Small Letter Phi
		case 0x03D6:	return 0x03C0;	// Greek Pi Symbol -> Greek Small Letter Pi
		case 0x03F0:	return 0x03BA;	// Greek Kappa Symbol -> Greek Small Letter Kappa
		case 0x03F1:	return 0x03C1;	// Greek Rho Symbol -> Greek Small Letter Rho
		case 0x03F2:	return 0x03C2;	// Greek Lunate Sigma Symbol -> Greek Small Letter Final Sigma
		case 0x03F4:	return 0x0398;	// Greek Capital Theta Symbol -> Greek Capital Letter Theta
		case 0x03F5:	return 0x03B5;	// Greek Lunate Epsilon Symbol -> Greek Small Letter Epsilon
		case 0x03F9:	return 0x03A3;	// Greek Capital Lunate Sigma Symbol -> Greek Capital Letter Sigma
		case 0x2107:	return 0x0190;	// Euler Constant -> Latin Capital Letter Open E
		case 0x2135:	return 0x05D0;	// Alef Symbol -> Hebrew Letter Alef
		case 0x2136:	return 0x05D1;	// Bet Symbol -> Hebrew Letter Bet
		case 0x2137:	return 0x05D2;	// Gimel Symbol -> Hebrew Letter Gimel
		case 0x2138:	return 0x05D3;	// Dalet Symbol -> Hebrew Letter Dalet
		default:		return cp;
		}
	}
	template<> inline CodePoint CProvisionalFolder<PFO_WIDTH>::Fold(CodePoint cp) {
		static	char_t	wsz[2];
		if(cp >= 0x10000)
			return cp;
		if(::LCMapStringW(LOCALE_USER_DEFAULT, LCMAP_HALFWIDTH, reinterpret_cast<WCHAR*>(&cp), 1, wsz, 1) != 0)
			return wsz[0];
		return cp;
		//return ToHalfWidth(ch);	// pJi͑ΏۊO
	}

	template<> inline bool CCharacterSkipper<CSO_CONTROLS>::IsIgnorable(CodePoint cp) {
		return binary_search(controls, _endof(controls), cp);
	}
//	template<> inline bool CCharacterSkipper<CSO_DIACRITICS>::IsIgnorable(CodePoint cp) {
//	}
	template<> inline bool CCharacterSkipper<CSO_KASHIDA>::IsIgnorable(CodePoint cp) {
		// does not consider <U+FE71: Arabic Tatweel With Fathatan Above> like IE6...
		return cp == 0x0640;	// Arabic Tatweel
	}
	template<> inline bool CCharacterSkipper<CSO_PUNCTUATIONS>::IsIgnorable(CodePoint cp) {
		return binary_search(punctuations, _endof(punctuations), cp);
	}
	template<> inline bool CCharacterSkipper<CSO_SYMBOLS>::IsIgnorable(CodePoint cp) {
		return binary_search(symbols, _endof(symbols), cp);
	}
//	template<> inline bool CCharacterSkipper<CSO_VOWELS>::IsIgnorable(CodePoint cp) {
//	}
	template<> inline bool CCharacterSkipper<CSO_WHITESPACES>::IsIgnorable(CodePoint cp) {
		return binary_search(zs, _endof(zs), cp);
	}
} // namespace `anonymous'

namespace Ascension {
namespace Private {
	/// BM ̎
	class CBmSearcher {
		// RXgN^
	public:
		/**
		 *	RXgN^
		 *	@param pCharFolder	1̃tH[hBsvȏꍇ null
		 *	@param bForward		Ȍꍇ true
		 *	@param pwszPattern	 (󕶎s)BIuWFNg͂̃̕Rs[<strong>Ȃ</strong>
		 *	@param cchPattern	񒷁Bȗ null IƂČvZ
		 */
		CBmSearcher(const CTextSearcher* pCharFolder, bool bForward, const char_t* pwszPattern, length_t cchPattern = -1)
				: m_pCharFolder(pCharFolder), m_bForward(bForward), m_pwszPattern(pwszPattern),
				m_cchPattern((cchPattern != -1) ? cchPattern : wcslen(pwszPattern)) {
			assert(pwszPattern);
			assert(cchPattern != 0);

			std::fill(m_lastAppearances, _endof(m_lastAppearances), m_cchPattern);
			if(m_bForward) {
				for(std::size_t i = 0; i < cchPattern; ++i)
					m_lastAppearances[_Fold(m_pwszPattern[i])] = cchPattern - i - 1;
			} else {
				for(std::size_t i = cchPattern - 1; ; --i) {
					m_lastAppearances[_Fold(m_pwszPattern[i])] = i;
					if(i == 0)
						break;
				}
			}
		}
		/*
		 *	s
		 *	@param pwszTarget	Ώە
		 *	@param cchTarget	Ώە񒷁Bȗ null IƂČvZ
		 *	@return				vʒuւ̃|C^BȂꍇ null
		 */
		const char_t* Search(const char_t* pwszTarget, length_t cchTarget = -1) const {
			assert(pwszTarget != 0);
			assert(cchTarget != 0);

			if(cchTarget == -1)
				cchTarget = wcslen(pwszTarget);
			if(cchTarget < m_cchPattern)
				return 0;
			if(m_bForward) {
				for(length_t iTarget = m_cchPattern - 1, iPattern; iTarget < cchTarget;
						iTarget += std::max(
							m_lastAppearances[_Fold(pwszTarget[iTarget])], m_cchPattern - iPattern)) {
					for(iPattern = m_cchPattern - 1;
							_Fold(pwszTarget[iTarget]) == _Fold(m_pwszPattern[iPattern]);
							--iTarget, --iPattern) {
						if(iPattern == 0)
							return pwszTarget + iTarget;
					}
				}
			} else {
				for(length_t iTarget = cchTarget - m_cchPattern, iPattern, cchSkip; ; iTarget -= cchSkip) {
					for(iPattern = 0;
							_Fold(pwszTarget[iTarget]) == _Fold(m_pwszPattern[iPattern]);
							++iTarget, ++iPattern) {
						if(iPattern == m_cchPattern - 1)
							return pwszTarget + iTarget - m_cchPattern + 1;
					}
					cchSkip = std::max(m_lastAppearances[_Fold(pwszTarget[iTarget])], iPattern + 1);
					if(cchSkip > iTarget)
						break;
				}
			}
			return 0;
		}

	private:
		char_t _Fold(char_t ch) const {
			return (m_pCharFolder != 0) ? static_cast<char_t>(m_pCharFolder->_Fold(ch)) : ch;
		}

		// f[^o
	private:
		const CTextSearcher*	m_pCharFolder;
		const bool				m_bForward;
		const char_t* const		m_pwszPattern;
		const length_t			m_cchPattern;
		length_t				m_lastAppearances[65536];
	};
} // namespace Private
} // namespace Ascension

#ifndef ASCENSION_NO_REGEXP
namespace Ascension {
namespace Private {
	///	K\Ŏg̓
	class CAscensionRegexTraits : public boost::cpp_regex_traits<char_t> {
		// \bh
	public:
		static char_t translate_nocase(char_t c) {return translate(c, true);}
		static char_t translate(char_t c, bool icase) {
			if(!m_bAsMigemo && m_pSearcher != 0)	// GfB^̌IvVgꍇ
				return static_cast<char_t>(m_pSearcher->_Fold(c));
			else if(icase)	// P[XtH[fBO
				return static_cast<char_t>(CLexer::CaseFoldCharacter(c));
			else	// ȊO͂̂܂
				return c;
		}
		static char_t tolower(char_t c) {return static_cast<char_t>(CLexer::CaseFoldCharacter(c));}
//		static char_t toupper(char_t c) {}
		boost::w32_regex_traits<char_t>::char_class_type lookup_classname(const char_t* p1, const char_t* p2) const {
/*			if(!m_bAsMigemo) {
				for(size_t i = 0; i < _countof(blocks); ++i) {
					if(wcslen(blocks[i].pwszClassName) == last - first
							&& wcsncmp(blocks[i].pwszClassName, first, last - first) == 0)
						return static_cast<boost::uint32_t>(i + 1) << 24;
				}
			}
*/			return _BaseTraits::lookup_classname(p1, p2);
		}
/*		static bool isctype(char_t c, boost::w32_regex_traits<char_t>::char_class_type f) {
			if(m_bAsMigemo)
				return _BaseType::isctype(c, f);

			// ̕NX͉肵ĒׂƁAWin32 `ɈϏ
			switch(f) {
			case boost::regex_constants::alpha:	return m_pLexer->IsIdentifierContinueCodePoint(c);
			case base_type::char_class_cntrl:	return CCharacterSkipper<CSO_CONTROLS>::IsIgnorable(c);
			case base_type::char_class_punct:	return CCharacterSkipper<CSO_PUNCTUATIONS>::IsIgnorable(c);
			case base_type::char_class_space:	return m_pLexer->IsWhiteSpace(c, false);
			case base_type::char_class_blank:	return m_pLexer->IsWhiteSpace(c, true);
			case base_type::char_class_alnum:
			case base_type::char_class_word:	return iswdigit(c) || m_pLexer->IsIdentifierContinueCodePoint(c);
			}

			// ƎgNX
			const boost::uint32_t	nExtendedClass = f >> 24;
			for(size_t i = 0; i < _countof(blocks); ++i) {
				if((i + 1) == nExtendedClass && c >= blocks[i].nStartCodePoint && c <= blocks[i].nEndCodePoint)
					return true;
			}

			return (f != base_type::char_class_none) ? base_type::is_class(c, f) : false;
		}
*/
		// f[^o
	public:
		static const CLexer*	m_pLexer;
		static CTextSearcher*	m_pSearcher;
		static bool				m_bAsMigemo;
	private:
		typedef boost::cpp_regex_traits<char_t>	_BaseTraits;
	};

	CTextSearcher*	CAscensionRegexTraits::m_pSearcher = 0;
	const CLexer*	CAscensionRegexTraits::m_pLexer = 0;
	bool			CAscensionRegexTraits::m_bAsMigemo = false;

//	typedef boost::basic_regex<char_t, CAscensionRegExpTraits>	AscensionRegex;
} // namespace Private
} // namespace Ascension
#endif /* !ASCENSION_NO_REGEXP */


// CTextSearcher class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextSearcher::CTextSearcher() : m_bChangedFromLast(false), m_pLastLiteralPattern(0)
#ifndef ASCENSION_NO_REGEXP
		, m_pLastRegexPattern(0), m_pLastRegexMatchResults(0)
#endif /* !ASCENSION_NO_REGEXP */
{}

/// fXgN^
CTextSearcher::~CTextSearcher() {
	_ClearPatternCache();
}

///  (p^[) ̃LbVNA
void CTextSearcher::_ClearPatternCache() {
	delete m_pLastLiteralPattern;
	m_pLastLiteralPattern = 0;
#ifndef ASCENSION_NO_REGEXP
	delete m_pLastRegexPattern;
	m_pLastRegexPattern = 0;
	delete m_pLastRegexMatchResults;
	m_pLastRegexMatchResults = 0;
#endif /* !ASCENSION_NO_REGEXP */
}

#ifndef ASCENSION_NO_REGEXP
/**
 *	񂩂琳Kp^[쐬
 *	@return	
 */
CSearchError CTextSearcher::_CompileRegexPattern() throw(logic_error) {
	if(m_pLastRegexPattern != 0)
		return CSearchError(CSearchError::SUCCEEDED);
	else if(m_options.type == ST_REGEXP) {
		assert(IsRegexAvailable());
		try {
			m_pLastRegexPattern = new Private::AscensionRegex(m_strFindWhat, boost::regex_constants::perl);
		} catch(boost::regex_error& e) {
			return MAKE_REGEX_ERROR(e);
		}
		return MATCH_TAG;
	} else if(m_options.type == ST_MIGEMO) {
		assert(IsMigemoAvailable());
		size_t			cchPattern;
		const char_t*	pwszPattern = g_migemo.Query(m_strFindWhat, cchPattern);

		if(pwszPattern == 0)
			return CSearchError(CSearchError::MIGEMO_ERROR);
		try {
			m_pLastRegexPattern = new Private::AscensionRegex(pwszPattern, pwszPattern + cchPattern,
				boost::regex_constants::emacs | boost::regex_constants::icase | boost::regex_constants::perl);
		} catch(boost::bad_pattern& e) {
			g_migemo.ReleasePatterns();
			return MAKE_REGEX_ERROR(e);
		}
		return MATCH_TAG;
	} else
		throw logic_error("Current search type is not based on regular expression.");
}
#endif /* !ASCENSION_NO_REGEXP */

/**
 *	ݐݒ肳Ă錟ɊÂāAϊ
 *	@param cp	ϊR[h|Cg
 *	@return		ϊꂽR[h|CgB_IGNORABLE_CODE_POINT Ԃꍇ͂̃R[h|Cg͖ł
 */
inline CodePoint CTextSearcher::_Fold(CodePoint cp) const {
	AssertValid();

	// łR[h|Cg
	if(toBoolean(m_options.characterSkipOptions & CSO_PUNCTUATIONS) && CCharacterSkipper<CSO_PUNCTUATIONS>::IsIgnorable(cp))
		return _IGNORABLE_CODE_POINT;
	if(toBoolean(m_options.characterSkipOptions & CSO_SYMBOLS) && CCharacterSkipper<CSO_SYMBOLS>::IsIgnorable(cp))
		return _IGNORABLE_CODE_POINT;
	if(toBoolean(m_options.characterSkipOptions & CSO_WHITESPACES) && CCharacterSkipper<CSO_WHITESPACES>::IsIgnorable(cp))
		return _IGNORABLE_CODE_POINT;
	if(toBoolean(m_options.characterSkipOptions & CSO_KASHIDA) && CCharacterSkipper<CSO_KASHIDA>::IsIgnorable(cp))
		return _IGNORABLE_CODE_POINT;
	if(toBoolean(m_options.characterSkipOptions & CSO_CONTROLS) && CCharacterSkipper<CSO_CONTROLS>::IsIgnorable(cp))
		return _IGNORABLE_CODE_POINT;

	// 啶
	if(m_options.caseSensitivity == CS_NONE)		cp = CCaseFolder<CS_NONE>::Fold(cp);
	else if(m_options.caseSensitivity == CS_ASCII)	cp = CCaseFolder<CS_ASCII>::Fold(cp);
	else if(m_options.caseSensitivity == CS_SIMPLE)	cp = CCaseFolder<CS_SIMPLE>::Fold(cp);
//	else if(m_options.caseSensitivity == CS_FULL)	cp = CCaseFolder<CS_FULL>::Fold(cp);

	// R[h|CgƂ̕ϊ
#define FOLD_WITH_ONE_TO_ONE_MAP(option)	\
	if(toBoolean(m_options.foldingOptions & option))	cp = CFolder<option>::Fold(cp)

	FOLD_WITH_ONE_TO_ONE_MAP(FO_CANONICAL_DUPLICATES);
	FOLD_WITH_ONE_TO_ONE_MAP(FO_DASHES);
	FOLD_WITH_ONE_TO_ONE_MAP(FO_GREEK_LETTERFORMS);
	FOLD_WITH_ONE_TO_ONE_MAP(FO_HEBREW_ALTERNATES);
	FOLD_WITH_ONE_TO_ONE_MAP(FO_OVERLINE);
	FOLD_WITH_ONE_TO_ONE_MAP(FO_NATIVE_DIGIT);
	FOLD_WITH_ONE_TO_ONE_MAP(FO_NOBREAK);
	FOLD_WITH_ONE_TO_ONE_MAP(FO_SMALL_FORMS);
	FOLD_WITH_ONE_TO_ONE_MAP(FO_SPACE);
	FOLD_WITH_ONE_TO_ONE_MAP(FO_UNDERLINE);
	if(toBoolean(m_options.provisionalFoldingOptions & PFO_KANA))
		cp = CProvisionalFolder<PFO_KANA>::Fold(cp);
	if(toBoolean(m_options.provisionalFoldingOptions & PFO_LETTER_FORMS))
		cp = CProvisionalFolder<PFO_LETTER_FORMS>::Fold(cp);
	if(toBoolean(m_options.provisionalFoldingOptions & PFO_WIDTH))
		cp = CProvisionalFolder<PFO_WIDTH>::Fold(cp);
	return cp;

#undef FOLD_WITH_ONE_TO_ONE_MAP
}

/// Migemo gp\Ԃ
bool CTextSearcher::IsMigemoAvailable() {
#ifdef ASCENSION_NO_MIGEMO
	return false;
#else
	return IsRegexAvailable() && g_migemo.IsEnable() && toBoolean(::IsValidCodePage(932));
#endif /* ASCENSION_NO_MIGEMO */
}

template<> inline SearchResult
CTextSearcher::_Match<ST_LITERAL>(const char_t* first, const char_t* last, const CBoundarySearcher& boundary) {
	if(!m_options.IsComplex() && last - first != m_strFindWhat.length())
		return NO_MATCH_TAG;
	else if(m_options.IsEmpty())
		return (m_strFindWhat.compare(first) == 0) ? MATCH_TAG : NO_MATCH_TAG;
	else if(!m_options.IsComplex()) {
		for(size_t i = 0; i < m_strFindWhat.length(); ++i) {
			if(_Fold(first[i]) != _Fold(m_strFindWhat[i]))
				return NO_MATCH_TAG;
		}
		return MATCH_TAG;
	} else {
		// TODO: complex match
	}
}

template<> inline SearchResult
CTextSearcher::_Match<ST_REGEXP>(const char_t* first, const char_t* last, const CBoundarySearcher& boundary) {
	assert(IsRegexAvailable());

#ifndef ASCENSION_NO_REGEXP
	Private::CAscensionRegexTraits::m_pLexer = &boundary.GetLexer();
	Private::CAscensionRegexTraits::m_pSearcher = this;
	Private::CAscensionRegexTraits::m_bAsMigemo = false;

	const CSearchError	result = _CompileRegexPattern();
	if(result.GetCode() != CSearchError::SUCCEEDED)
		return result;
	try {
		return CSearchError(boost::regex_match(first, last, *m_pLastRegexPattern,
			boost::regex_constants::match_perl | boost::regex_constants::match_nosubs) ?
				CSearchError::SUCCEEDED : CSearchError::NO_MATCH);
	} catch(boost::regex_error& e) {
		return MAKE_REGEX_ERROR(e);
	}
#else
	return false;
#endif /* !ASCENSION_NO_REGEXP */
}

/**
 *	}b`s
 *	@param first, last	}b`Ώە
 *	@param boundary		E`
 *	@return				
 */
SearchResult CTextSearcher::Match(const char_t* first, const char_t* last, const CBoundarySearcher& boundary) {
	assert(first != 0 && last != 0 && first <= last);
	switch(m_options.type) {
	case ST_LITERAL:	return _Match<ST_LITERAL>(first, last, boundary);
	case ST_REGEXP:		return _Match<ST_REGEXP>(first, last, boundary);
//	case ST_WILDCARD:	return _Match<ST_WILDCARD>(first, last, boundary);
//	case ST_MIGEMO:		return _Match<ST_MIGEMO>(first, last, boundary);
	default:			return SearchResult();	// 蓾
	}
}

template<> inline SearchResult CTextSearcher::_Replace<ST_LITERAL>(
		const char_t* first, const char_t* last, string_t& strReplaced, const CBoundarySearcher& boundary) {
	const SearchResult	result = _Match<ST_LITERAL>(first, last, boundary);
	if(!result)
		return result;
	strReplaced.assign(m_strReplaceWith);
	return result;
}

template<> inline SearchResult CTextSearcher::_Replace<ST_REGEXP>(
		const char_t* first, const char_t* last, string_t& strReplaced, const CBoundarySearcher& boundary) {
	assert(IsRegexAvailable());
#ifndef ASCENSION_NO_REGEXP
	const CSearchError	result = _Match<ST_REGEXP>(first, last, boundary);
	if(result.GetCode() != CSearchError::SUCCEEDED)
		return result;
	try {
		strReplaced.assign(m_pLastRegexMatchResults->format(m_strReplaceWith, boost::regex_constants::format_perl));
		return CSearchError(CSearchError::SUCCEEDED);
	} catch(boost::regex_error& e) {
		return MAKE_REGEX_ERROR(e);
	}
#else
	return false;
#endif /* ASCENSION_NO_REGEXP */
}

/**
 *	@brief	us
 *
 *	̃\bh͒us킯ł͂ȂAuԂŁA
 *	ۂ̒u͌Ăяos
 *
 *	uΏۂ͂̕܂Ǎ݂Ƀ}b`邩`FbNB
 *	}b`Ȃꍇ͒u͎s (false Ԃ)
 *
 *	@param first, last	[in] uΏۂ̕
 *	@param strReplaced	[out] uBĂяo͌̕̕Œu
 *	@param boundary		[in] E`
 *	@return				
 */
SearchResult CTextSearcher::Replace(
		const char_t* first, const char_t* last, string_t& strReplaced, const CBoundarySearcher& boundary) {
	assert(first != 0 && last != 0 && first <= last);
	switch(m_options.type) {
	case ST_LITERAL:	return _Replace<ST_LITERAL>(first, last, strReplaced, boundary);
	case ST_REGEXP:		return _Replace<ST_REGEXP>(first, last, strReplaced, boundary);
//	case ST_WILDCARD:	return _Replace<ST_WILDCARD>(first, last, strReplaced, boundary);
//	case ST_MIGEMO:		return _Replace<ST_MIGEMO>(first, last, strReplaced, boundary);
	default:			return SearchResult();	// 蓾
	}
}

template<> SearchResult CTextSearcher::_Search<ST_LITERAL>(const string_t& strText,
		length_t iBegin, bool bForward, TMatchRange& result, const CBoundarySearcher& boundary) {
	const bool			bComplex = m_options.IsComplex();
	const char_t* const	pwszFindWhatOrg = m_strFindWhat.data();
	const char_t* const	pwszTargetOrg = strText.data();
	char_t* const		pwszFindWhatFolded = bComplex ? new char_t[m_strFindWhat.length()] : 0;
	char_t* const		pwszTargetFolded = bComplex ? new char_t[strText.length()] : 0;
	CodePoint			cp, cpFolded;
	length_t			iFolded = 0;

	//  folding
	if(bComplex) {
		for(length_t i = 0; i < m_strFindWhat.length(); ++i) {
			cp = DecodeUtf16SurrogatesToCodePoint(pwszFindWhatOrg + i, m_strFindWhat.length() - i);
			cpFolded = _Fold(cp);
			if(cpFolded != 0xFFFFFFFF) {
				if(EncodeCodePointToUtf16Surrogates(cpFolded, pwszFindWhatFolded + iFolded))
					iFolded += 2;
				else
					++iFolded;
			}
			if(cp >= 0x10000)
				++i;
		}
	}
	const length_t	cchPattern = bComplex ? iFolded : m_strFindWhat.length();

	if(m_pLastLiteralPattern == 0)
		m_pLastLiteralPattern =
			new Private::CBmSearcher((bComplex || m_options.IsEmpty()) ? 0 : this,
				bForward, bComplex ? pwszFindWhatFolded : pwszFindWhatOrg, cchPattern);

	// Ώە folding
	list<length_t>	shortenedPositions;
	if(bComplex) {
		iFolded = 0;
		for(length_t i = !bForward ? 0 : iBegin; i < (!bForward ? iBegin : strText.length()); ++i) {
			cp = DecodeUtf16SurrogatesToCodePoint(pwszTargetOrg + i, strText.length() - i);
			cpFolded = _Fold(cp);
			if(cpFolded != 0xFFFFFFFF) {
				if(EncodeCodePointToUtf16Surrogates(cpFolded, pwszTargetFolded + iFolded))
					iFolded += 2;
				else
					++iFolded;
			} else
				shortenedPositions.push_back(i);
			if(cp >= 0x10000)
				++i;
		}
	}
	const char_t* const	pwszTarget = bComplex ? pwszTargetFolded : (pwszTargetOrg + (bForward ? iBegin : 0));
	const length_t		cchTarget = bComplex ? iFolded : (bForward ? strText.length() : iBegin);

	// 
	result.iFound = iBegin;
	do {
		const char_t*	pwszFound =
			m_pLastLiteralPattern->Search(pwszTarget + (bForward ? result.iFound - iBegin : 0), cchTarget);

		if(pwszFound == 0) {
			result.iFound = -1;
			break;
		}
		result.iFound = pwszFound - pwszTarget;
		if(bForward)
			result.iFound += iBegin;

		// vʒu𖳎镶菜ÖʒuɃ}bv
		length_t	iEnd = result.iFound + cchPattern;	// vI[
		for(list<length_t>::const_iterator it = shortenedPositions.begin(); it != shortenedPositions.end(); ++it) {
			if(result.iFound >= *it)
				++result.iFound;
			if(iEnd > *it)
				++iEnd;
			else
				break;
		}
		if(!m_options.bWholeWord
				|| (boundary.HasWordBoundaryAt(strText.data(), result.iFound)
				&& boundary.HasWordBoundaryAt(strText.data(), iEnd))) {
			result.cchFound = iEnd - result.iFound;
			break;
		}
		result.iFound += bForward ? 1 : -1;	// PPʂł̌Ɏs蒼
	} while(true);

	delete[] pwszFindWhatFolded;
	delete[] pwszTargetFolded;
	return (result.iFound != -1) ? MATCH_TAG : NO_MATCH_TAG;
}
		
template<> SearchResult CTextSearcher::_Search<ST_REGEXP>(const string_t& strText,
		length_t iBegin, bool bForward, TMatchRange& result, const CBoundarySearcher& boundary) {
	assert(IsRegexAvailable());

#ifndef ASCENSION_NO_REGEXP
	using namespace Private;

	CAscensionRegexTraits::m_pLexer = &boundary.GetLexer();
	CAscensionRegexTraits::m_pSearcher = this;
	CAscensionRegexTraits::m_bAsMigemo = m_options.type == ST_MIGEMO;

	// p^[̃RpC
	{
		const CSearchError	result = _CompileRegexPattern();
		if(result.GetCode() != CSearchError::SUCCEEDED)
			return result;
	}

	const boost::match_flag_type	flags = boost::regex_constants::match_perl | boost::regex_constants::match_nosubs;
	boost::match_results<string_t::const_iterator>	results;
	if(bForward) {	// O
		do {
			if(m_options.type == ST_MIGEMO) {
				if(!boost::regex_search(strText.begin() + iBegin, strText.end(), results, *m_pLastRegexPattern, flags))
					return NO_MATCH_TAG;
			} else {
				try {
					if(!boost::regex_search(strText.begin() + iBegin, strText.end(), results, *m_pLastRegexPattern, flags))
						return NO_MATCH_TAG;
				} catch(boost::regex_error& e) {
					return CSearchError(TranslateRegexError(e.code()), e.position());
				}
			}
			result.iFound = results.position() + iBegin;
			result.cchFound = results.length();
			if(!m_options.bWholeWord	// PPʂŒTꍇ
					|| (boundary.HasWordBoundaryAt(strText.data(), result.iFound)
					&& boundary.HasWordBoundaryAt(strText.data(), result.iFound + result.cchFound)))
				return MATCH_TAG;
			iBegin = result.iFound + result.cchFound;
		} while(true);
	} else {	// 
		// ܂ōsɃ}b`Ώۂg債
		for(length_t iStart = (iBegin == 0) ? 0 : iBegin - 1; iStart != -1; --iStart) {
			if(m_options.type == ST_MIGEMO) {
				if(!boost::regex_search(strText.begin() + iStart, strText.end(),
						results, *m_pLastRegexPattern,
						(iStart != 0) ? flags | boost::regex_constants::match_prev_avail : flags))
					continue;
			} else {
				try {
					if(!boost::regex_search(strText.begin() + iStart, strText.end(),
							results, *m_pLastRegexPattern,
							(iStart != 0) ? flags | boost::regex_constants::match_prev_avail : flags))
						continue;
				} catch(boost::regex_error& e) {
					return MAKE_REGEX_ERROR(e);
				}
			}
			if(results.position() == 0) {
				result.iFound = results.position() + iStart;
				result.cchFound = results.length();
				if(!m_options.bWholeWord	// PPʂŒTꍇ
						|| (boundary.HasWordBoundaryAt(strText.data(), result.iFound)
						&& boundary.HasWordBoundaryAt(strText.data(), result.iFound + result.cchFound)))
					return MATCH_TAG;
			}
		}
	}
#endif /* !ASCENSION_NO_REGEXP */
	return NO_MATCH_TAG;
}

/**
 *	s
 *	@param strText	Ώە (󕶎񂾂ƏɎs)
 *	@param iBegin	Jnʒu (-1 ƕ̏I[)
 *	@param bForward	Ȍꍇ true
 *	@param iFound	[out] ʒu
 *	@param cchFound	[out] ̒
 *	@param boundary	[in] PꋫE
 *	@return			
 */
SearchResult CTextSearcher::Search(const string_t& strText,
		length_t iBegin, bool bForward, TMatchRange& result, const CBoundarySearcher& boundary) {
	AssertValid();

	if(strText.empty() || (iBegin == 0 && !bForward))
		return NO_MATCH_TAG;
	else if(iBegin == -1)
		iBegin = strText.length();

	// 
	if(m_options.type == ST_REGEXP	// K\g
			|| (m_options.type == ST_MIGEMO && IsMigemoAvailable())) {
		assert(IsRegexAvailable());

#ifndef ASCENSION_NO_REGEXP
		using namespace Private;

		CAscensionRegexTraits::m_pLexer = &boundary.GetLexer();
		CAscensionRegexTraits::m_pSearcher = this;
		CAscensionRegexTraits::m_bAsMigemo = m_options.type == ST_MIGEMO;

		const CSearchError	res = _CompileRegexPattern();
		if(res.GetCode() != CSearchError::SUCCEEDED)
			return res;
		return _Search<ST_REGEXP>(strText, iBegin, bForward, result, boundary);
#else
		return false;
#endif  /* !ASCENSION_NO_REGEXP */
	} else
		return _Search<ST_LITERAL>(strText, iBegin, bForward, result, boundary);
}

///	IvV̐ݒ
void CTextSearcher::SetOptions(const TSearchOptions& options) {
	AssertValid();
	if(options != m_options) {
		m_options = options;
		m_bChangedFromLast = true;
		_ClearPatternCache();
	}
}

///	u̐ݒ
void CTextSearcher::SetReplaceText(const string_t& strText) {
	AssertValid();
	m_strReplaceWith = strText;
}

///	̐ݒ
void CTextSearcher::SetSearchText(const string_t& strText) {
	AssertValid();
	if(strText != m_strFindWhat) {
		m_strFindWhat = strText;
		m_bChangedFromLast = true;
		_ClearPatternCache();
	}
}


// CIncrementalSearcher
/////////////////////////////////////////////////////////////////////////////

#define UPDATE_ISEARCH_AND_RETURN()						\
	const SearchResult	res = _Update();				\
	if(m_pEventListener != 0)							\
		m_pEventListener->OnISearchPatternChanged(res);	\
	return res

/// ̒~
void CIncrementalSearcher::AbortSearch() {
	if(!m_statusHistory.empty()) {
		if(m_pEventListener != 0)
			m_pEventListener->OnISearchAborted();
		m_pView->GetSelection().Select(m_pFirstStatus->pos0, m_pFirstStatus->pos1, false, true);
		EndSearch();
	}
}

/**
 *	݂̖̌ɕǉ
 *	@param ch	ǉ镶
 *	@return		Č̐
 */
SearchResult CIncrementalSearcher::AddCharacter(char_t ch) throw(EIncrementalSearchIsNotRunning) {
	if(m_statusHistory.empty())
		throw EIncrementalSearchIsNotRunning();
	m_strPattern += ch;
	m_operationHistory.push(TYPE);
	UPDATE_ISEARCH_AND_RETURN();
}


/**
 *	݂̖̌ɕǉ
 *	@param cp	ǉ镶
 *	@return		Č̐
 */
SearchResult CIncrementalSearcher::AddCharacter(CodePoint cp) throw(EIncrementalSearchIsNotRunning) {
	if(m_statusHistory.empty())
		throw EIncrementalSearchIsNotRunning();
	if(cp < 0x010000)
		return AddCharacter(static_cast<char_t>(cp));

	char_t	wszSurrogates[2];
	EncodeCodePointToUtf16Surrogates(cp, wszSurrogates);
	return AddString(wszSurrogates, wszSurrogates + 2);
}

/**
 *	݂̖̌ɕǉ
 *	@param first, last				ǉ镶
 *	@return							Č̐
 *	@throw std::invalid_argument	<var>str</var> 󕶎̂ƂX[
 */
SearchResult CIncrementalSearcher::AddString(
		const char_t* first, const char_t* last) throw(EIncrementalSearchIsNotRunning, invalid_argument) {
	assert(first != 0 && last != 0 && first <= last);
	if(m_statusHistory.empty())
		throw EIncrementalSearchIsNotRunning();
	else if(first == last)
		throw invalid_argument("Added string is empty.");
	m_strPattern.append(first, last);
	for(const char_t* p = first; p < last; ++p)
		m_operationHistory.push(TYPE);
	UPDATE_ISEARCH_AND_RETURN();
}

/**
 *	̊Jn
 *	@param view				Ώۃr[
 *	@param type				̌^Cv (NOT_RUNNING ƌI)
 *	@param pEventListener	CxgXi
 */
void CIncrementalSearcher::BeginSearch(CEditView& view, State type, IEventListener* pEventListener /* = 0 */) {
	if(!m_statusHistory.empty())
		EndSearch();
	if(type == NOT_RUNNING)
		return;

	const CCharPos	pos0 = view.GetSelection().GetAnchorPoint();
	const CCharPos	pos1 = view.GetSelection().GetActivePoint();
	const _TStatus	status = {min(pos0, pos1), max(pos0, pos1), type};

	m_pView = &view;
	m_statusHistory.push(status);
	m_pFirstStatus = &m_statusHistory.top();
	if(m_pEventListener = pEventListener) {
		m_pEventListener->OnISearchStarted();
		m_pEventListener->OnISearchPatternChanged(MATCH_TAG);
	}
}

/// ̏I
void CIncrementalSearcher::EndSearch() {
	while(!m_statusHistory.empty())
		m_statusHistory.pop();
	if(m_pEventListener != 0)
		m_pEventListener->OnISearchCompleted();
	m_pView = 0;
	m_pEventListener = 0;
	m_pFirstStatus = 0;
	m_strLastPattern = m_strPattern;
	m_strPattern.erase();
}

/**
 *	̃}b`ʒuֈړ
 *	@param type						V^Cv
 *	@throw std::invalid_argument	<var>type</var>  NOT_RUNNING w肷ƃX[
 *	@return							
 */
SearchResult CIncrementalSearcher::JumpToNextMatch(State type) {
	if(m_statusHistory.empty())
		throw EIncrementalSearchIsNotRunning();
	if(type == NOT_RUNNING)
		throw invalid_argument("Specified search type is invalid");

	if(m_strPattern.empty()) {
		m_statusHistory.top().state = type;
		if(!m_strLastPattern.empty())
			return AddString(m_strLastPattern);	// OĨp^[Ō
		else {
			const SearchResult	result = MATCH_TAG;
			if(m_pEventListener != 0)
				m_pEventListener->OnISearchPatternChanged(result);
			return result;
		}
	} else if(!m_operationHistory.empty() && m_operationHistory.top() == JUMP && !m_bMatched)
		return NO_MATCH_TAG;	// }b`ĂȂԂŃWv悤Ƃ
	else {
		const CCharPos	pos0 = m_pView->GetSelection().GetAnchorPoint();
		const CCharPos	pos1 = m_pView->GetSelection().GetActivePoint();
		const _TStatus	status = {min(pos0, pos1), max(pos0, pos1), type};

		m_statusHistory.push(status);
		m_operationHistory.push(JUMP);
		UPDATE_ISEARCH_AND_RETURN();
	}
}

/// ̏Ԃɖ߂
void CIncrementalSearcher::Reset() throw(EIncrementalSearchIsNotRunning) {
	if(m_statusHistory.empty())
		throw EIncrementalSearchIsNotRunning();

	while(!m_operationHistory.empty())
		m_operationHistory.pop();
	while(m_statusHistory.size() > 1)
		m_statusHistory.pop();
	m_strPattern.erase();
	m_pView->GetSelection().Select(m_statusHistory.top().pos0, m_statusHistory.top().pos1, false, true);
	if(m_pEventListener != 0)
		m_pEventListener->OnISearchPatternChanged(MATCH_TAG);
}

/**
 *	1̑ȌԂɖ߂
 *	@return	
 *	@throw EIncrementalSearchUndoBufferIsEmpty	AhDłȂꍇɌĂяoƃX[
 */
SearchResult CIncrementalSearcher::Undo() throw(EIncrementalSearchUndoBufferIsEmpty) {
	if(m_statusHistory.empty())
		throw EIncrementalSearchIsNotRunning();
	else if(!CanUndo())
		throw EIncrementalSearchUndoBufferIsEmpty();

	const _Operation	lastOperation = m_operationHistory.top();

	m_operationHistory.pop();
	if(lastOperation == TYPE) {	// ̓͂ɖ߂ -> ̖
		const char_t* const	pwszPattern = m_strPattern.data();
		const length_t		cchPattern = m_strPattern.length();

		if(cchPattern > 1
				&& IsUtf16HighSurrogate(pwszPattern[cchPattern - 2])
				&& IsUtf16LowSurrogate(pwszPattern[cchPattern - 1]))
			m_strPattern.erase(cchPattern - 2);
		else
			m_strPattern.erase(cchPattern - 1);
		UPDATE_ISEARCH_AND_RETURN();
	} else if(lastOperation == JUMP) {	// ̃}b`ʒuւ̃Wvɖ߂ -> 1ȌԂɖ߂
		const _TStatus	lastStatus = m_statusHistory.top();

		m_pView->GetSelection().Select(lastStatus.pos0, lastStatus.pos1, false, true);
		m_statusHistory.pop();
		return MATCH_TAG;
	} else
		return SearchResult();	// 蓾
}

/// ݂̏ԂŌ蒼
SearchResult CIncrementalSearcher::_Update() {
	assert(!m_statusHistory.empty());

	if(m_strPattern.empty()) {
		m_pView->GetSelection().Select(m_pFirstStatus->pos0, m_pFirstStatus->pos1, false, true);
		m_bMatched = true;
		return MATCH_TAG;
	}
	m_bMatched = false;

	const CEditDoc&		document = m_pView->GetDocument();
	CTextSearcher&		searcher = m_pView->GetTextSearcher();
	TSearchOptions		options = searcher.GetOptions();
	const SearchType	originalType = options.type;
	const _TStatus&		status = m_statusHistory.top();
	const bool			bForward = status.state == LITERAL_FORWARD
							|| status.state == REGEXP_FORWARD || status.state == MIGEMO_FORWARD;
	const CCharPos&		posSearchBegin = bForward ? status.pos1 : status.pos0;
	const length_t		cchSearchText = m_strPattern.length();
	const length_t		cLines = document.GetLineCount();

	switch(status.state) {
	case LITERAL_FORWARD:	case LITERAL_BACKWARD:	options.type = ST_LITERAL;	break;
	case REGEXP_FORWARD:	case REGEXP_BACKWARD:	options.type = ST_REGEXP;	break;
	case MIGEMO_FORWARD:	case MIGEMO_BACKWARD:	options.type = ST_MIGEMO;	break;
	}
	
	searcher.SetOptions(options);
	searcher.SetSearchText(m_strPattern);

	TMatchRange	result;

	// O
	if(bForward) {
		const CCharPos	endPoint = document.GetEndPoint();	// I_
		for(length_t iLine = posSearchBegin.m_iLine; iLine <= endPoint.m_iLine; ++iLine) {
			const SearchResult	res = searcher.Search(
				(iLine != endPoint.m_iLine) ?
					document.GetLine(iLine) : document.GetLine(iLine).substr(0, endPoint.m_iChar),
				(iLine != posSearchBegin.m_iLine) ?
					0 : posSearchBegin.m_iChar, true, result, m_pView->GetBoundarySearcher());
			if(m_bMatched = res) {
				m_pView->GetSelection().Select(CCharPos(iLine, result.iFound),
					CCharPos(iLine, result.iFound + result.cchFound), false, true);
				break;
			}
#ifndef ASCENSION_NO_REGEXP
			else if(res.IsFatalError())	// ss\
				break;
#endif /* !ASCENSION_NO_REGEXP */
		}
	}

	// 
	else {
		const CCharPos	startPoint = document.GetStartPoint();	// I_
		for(length_t iLine = posSearchBegin.m_iLine; ; --iLine) {
			const string_t&	strLine = document.GetLine(iLine);
			const length_t	iBegin = (iLine != posSearchBegin.m_iLine) ? strLine.length() : posSearchBegin.m_iChar;
			const length_t	cchOffset = (iLine != startPoint.m_iLine) ? 0 : startPoint.m_iChar;

			if(status.state == LITERAL_BACKWARD) {
				if(iBegin >= cchSearchText) {
					const SearchResult	res = searcher.Search(
							(cchOffset == 0) ? strLine : strLine.substr(cchOffset), iBegin - cchOffset,
							false, result, m_pView->GetBoundarySearcher());
					if(m_bMatched = res)
						result.iFound += cchOffset;
				}
			} else {
				const SearchResult	res = searcher.Search(
						(cchOffset == 0) ? strLine : strLine.substr(cchOffset), iBegin - cchOffset,
						false, result, m_pView->GetBoundarySearcher());
				if(m_bMatched = res)
					result.iFound += cchOffset;
#ifndef ASCENSION_NO_REGEXP
				if(!m_bMatched && res.IsFatalError())	// ss\
					break;
#endif /* !ASCENSION_NO_REGEXP */
			}

			if(m_bMatched) {
				m_pView->GetSelection().Select(
					CCharPos(iLine, result.iFound), CCharPos(iLine, result.iFound + cchSearchText), false, true);
				break;
			} else if(iLine == startPoint.m_iLine)
				break;
		}
	}

	// ꎞIɕύXIvVɖ߂
	options.type = originalType;
	searcher.SetOptions(options);

	return m_bMatched ? MATCH_TAG : NO_MATCH_TAG;
}

#undef UPDATE_ISEARCH_AND_RETURN


// CBoundarySearcher
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param document	hLg
 *	@param lexer	͊
 */
CBoundarySearcher::CBoundarySearcher(const CEditDoc& document, const CLexer& lexer) : m_document(document), m_lexer(lexer) {
}

/**
 *	@brief	2̃R[h|CgXNvgǂԂ
 *
 *	̃\bh2̃R[h|CgAt@xbgł邱ƂOƂĂA
 *	`FbN͈؍sȂ
 *
 *	X ASCII ͑S Latin XNvgƂĈ
 *
 *	@param cp1, cp2	ׂR[h|Cg (ʒuɒ)
 *	@return			XNvg̏ꍇ true
 */
bool CBoundarySearcher::AreSameScriptType(CodePoint cp1, CodePoint cp2) {
#define IN_RANGE(start, end, another_cond)	\
	((cp1 >= start && cp1 <= end) || another_cond)
#define IN_RANGE_(start, end)	\
	(cp1 >= start && cp1 <= end)
#define ARE_SAME_SCRIPT(cond)	\
	if(cond)	return (cp1 = cp2), cond
#define ARE_SAME_SCRIPT_(start, end)	\
	ARE_SAME_SCRIPT(IN_RANGE_(start, end))

	// UCD  Scripts.txt 쐬 (Unicode 4.0)
#if(ASCENSION_UNICODE_VERSION != 0x0410)
#error This method is based on old version of Unicode.
#endif

	// {̑艼?
	// ЉAEłΒPꋫEł͂Ȃ
	if(PRIMARYLANGID(::GetUserDefaultLangID()) == LANG_JAPANESE) {
		if(cp2 >= 0x3041 && cp2 <= 0x309F &&
				IN_RANGE(0x30A1, 0x30FF,	// Katakana
				IN_RANGE(0x31F0, 0x31FF,
				IN_RANGE(0x2E80, 0x2FD5,	// Han
				IN_RANGE(0x3005, 0x303B,
				IN_RANGE(0x3400, 0x4DB5,
				IN_RANGE(0x4E00, 0x9FA5,
				IN_RANGE(0xF900, 0xFA6A,
				IN_RANGE(0x20000, 0x2A6D6,
				IN_RANGE_(0x2F800, 0x2FA1D))))))))))
			return true;
	}

	// o: Latin XNvg̐mȍŏ͈̔͂ U+0041 - U+007A ł

	ARE_SAME_SCRIPT(IN_RANGE(0x0021, 0x007E,	// Latin
					IN_RANGE(0x00AA, 0x02E4,
					IN_RANGE(0x1D00, 0x1DBF,
					IN_RANGE(0x1E00, 0x1EF9,
					IN_RANGE(0x2071, 0x207F,
					IN_RANGE(0x212A, 0x212B,
					IN_RANGE_(0xFB00, 0xFB06))))))));
	ARE_SAME_SCRIPT_(0xFF21, 0xFF5A);			// Fullwidth Latin
	ARE_SAME_SCRIPT(IN_RANGE(0x037A, 0x03FB,	// Greek
					IN_RANGE(0x1D26, 0x1FFC,
					IN_RANGE_(0x2126, 0x2126))));
	ARE_SAME_SCRIPT(IN_RANGE(0x0400, 0x050F,	// Cyrillic
					IN_RANGE_(0x1D28, 0x1D28)));
	ARE_SAME_SCRIPT(IN_RANGE(0x0531, 0x0587,	// Armenian
					IN_RANGE_(0xFB13, 0xFB17)));
	ARE_SAME_SCRIPT(IN_RANGE(0x05D0, 0x05F2,	// Hebrew
					IN_RANGE_(0xFB1D, 0xFB4F)));
	ARE_SAME_SCRIPT(IN_RANGE(0x0621, 0x06FF,	// Arabic
					IN_RANGE(0xFB50, 0xFDFB,
					IN_RANGE_(0xFE70, 0xFEFC))));
	ARE_SAME_SCRIPT_(0x0780, 0x07B1);			// Thaana
	ARE_SAME_SCRIPT_(0x0901, 0x096F);			// Devanagari
	ARE_SAME_SCRIPT_(0x0981, 0x09F1);			// Bengali
	ARE_SAME_SCRIPT_(0x0A02, 0x0A74);			// Gurmukhi
	ARE_SAME_SCRIPT_(0x0A81, 0x0AEF);			// Gujarati
	ARE_SAME_SCRIPT_(0x0B01, 0x0B71);			// Oriya
	ARE_SAME_SCRIPT_(0x0B82, 0x0BF2);			// Tamil
	ARE_SAME_SCRIPT_(0x0C01, 0x0C6F);			// Telugu
	ARE_SAME_SCRIPT_(0x0C82, 0x0CEF);			// Kannada
	ARE_SAME_SCRIPT_(0x0D02, 0x0D6F);			// Malayalam
	ARE_SAME_SCRIPT_(0x0D82, 0x0DF3);			// Sinhala
	ARE_SAME_SCRIPT_(0x0E01, 0x0E59);			// Thai
	ARE_SAME_SCRIPT_(0x0E81, 0x0EDD);			// Lao
	ARE_SAME_SCRIPT_(0x0F00, 0x0FC6);			// Tibetan
	ARE_SAME_SCRIPT_(0x1000, 0x1059);			// Myanmar
	ARE_SAME_SCRIPT_(0x10A0, 0x10F8);			// Georgian
	ARE_SAME_SCRIPT(IN_RANGE(0x1100, 0x11F9,	// Hangul
					IN_RANGE(0x3131, 0x318E,
					IN_RANGE_(0xAC00, 0xD7A3))));
	ARE_SAME_SCRIPT_(0xFFA0, 0xFFDC);			// Halfwidth Hangul
	ARE_SAME_SCRIPT(IN_RANGE(0x1200, 0x135A,	// Ethiopic
					IN_RANGE_(0x1369, 0x137C)));
	ARE_SAME_SCRIPT_(0x13A0, 0x13F4);			// Cherokee
	ARE_SAME_SCRIPT_(0x1401, 0x1676);			// Canadian Aboriginal
	ARE_SAME_SCRIPT_(0x1681, 0x169A);			// Ogham
	ARE_SAME_SCRIPT_(0x16A0, 0x16F0);			// Runic
	ARE_SAME_SCRIPT_(0x1780, 0x17E9);			// Khmer
	ARE_SAME_SCRIPT_(0x1810, 0x18A9);			// Mongolian
	if(IN_RANGE_(0x3041, 0x309F))				// Hiragana
		return (cp1 = cp2), (IN_RANGE_(0x3041, 0x309F) || cp2 == L'[');
	ARE_SAME_SCRIPT(IN_RANGE(0x30A1, 0x30FF,	// Katakana
					IN_RANGE_(0x31F0, 0x31FF)));
	ARE_SAME_SCRIPT_(0xFF66, 0xFF9F);			// Halfwidth Katakana
	ARE_SAME_SCRIPT(IN_RANGE(0x3105, 0x312C,	// Bopomofo
					IN_RANGE_(0x31A0, 0x31B7)));
	ARE_SAME_SCRIPT(IN_RANGE(0x2E80, 0x2FD5,	// Han
					IN_RANGE(0x3005, 0x303B,
					IN_RANGE(0x3400, 0x4DB5,
					IN_RANGE(0x4E00, 0x9FA5,
					IN_RANGE(0xF900, 0xFA6A,
					IN_RANGE(0x20000, 0x2A6D6,
					IN_RANGE_(0x2F800, 0x2FA1D))))))));
	ARE_SAME_SCRIPT_(0xA000, 0xA4C6);		// Yi
	ARE_SAME_SCRIPT_(0x10300, 0x1031F);		// Old Italic
	ARE_SAME_SCRIPT_(0x10330, 0x1034A);		// Gothic
	ARE_SAME_SCRIPT_(0x10400, 0x1044F);		// Deseret
	ARE_SAME_SCRIPT_(0x1700, 0x1714);		// Tagalog
	ARE_SAME_SCRIPT_(0x1720, 0x1734);		// Hanunoo
	ARE_SAME_SCRIPT_(0x1740, 0x1573);		// Buhid
	ARE_SAME_SCRIPT_(0x1760, 0x1773);		// Tagbanwa
	ARE_SAME_SCRIPT_(0x1900, 0x194F);		// Limbu
	ARE_SAME_SCRIPT_(0x1950, 0x1974);		// Tai Le
	ARE_SAME_SCRIPT_(0x10000, 0x100FA);		// Linear B
	ARE_SAME_SCRIPT_(0x10380, 0x1039D);		// Ugaritic
	ARE_SAME_SCRIPT_(0x10450, 0x1047F);		// Shavian
	ARE_SAME_SCRIPT_(0x10480, 0x104A9);		// Osmanya
	ARE_SAME_SCRIPT_(0x10800, 0x1083F);		// Cypriot
	ARE_SAME_SCRIPT_(0x2800, 0x28FF);		// Braille
	// Unicode 4.1
	ARE_SAME_SCRIPT_(0x1A00, 0x1A16);			// Buginese
	ARE_SAME_SCRIPT(IN_RANGE(0x03E2, 0x03EF,	// Coptic
					IN_RANGE_(0x2C80, 0x2CE4)));
	ARE_SAME_SCRIPT(IN_RANGE(0x1980, 0x19A9,	// New Tai Lue
					IN_RANGE_(0x19C1, 0x19C7)));
	ARE_SAME_SCRIPT(IN_RANGE(0x2C00, 0x2C2E,	// Glagolitic
					IN_RANGE_(0x2C30, 0x2C5E)));
	ARE_SAME_SCRIPT_(0x2D30, 0x2D65);			// Tifinagh
	ARE_SAME_SCRIPT_(0xA800, 0xA822);			// Syloti Nagri
	ARE_SAME_SCRIPT_(0x103A0, 0x103CF);			// Old Persian
	ARE_SAME_SCRIPT_(0x10A00, 0x10A33);			// Kharoshthi

	return false;

#undef IN_RANGE
#undef IN_RANGE_
#undef ARE_SAME_SCRIPT
#undef ARE_SAME_SCRIPT_
}

/**
 *	PꋫEɎgNXԂ
 *	@param cp	ׂR[h|Cg
 *	@return		PꋫENX
 */
CBoundarySearcher::_WBClass CBoundarySearcher::_GetWordBoundaryClass(CodePoint cp) const {
	using CBoundarySearcher::_WBClass;

	const LANGID	langid = PRIMARYLANGID(::GetUserDefaultLangID());

	// General Category  `Cf'  `Zs' ̃R[h|Cg (unicat.pl 萶)
#if(ASCENSION_UNICODE_VERSION != 0x0410)
#error List version differs from Ascension Unicode version. Update correspoding code.
#endif
	static const CodePoint	cf[] = {
		0x00AD, 0x0600, 0x0601, 0x0602, 0x0603, 0x06DD, 0x070F, 0x17B4,
		0x17B5, 0x200B, 0x200C, 0x200D, 0x200E, 0x200F, 0x202A, 0x202B,
		0x202C, 0x202D, 0x202E, 0x2060, 0x2061, 0x2062, 0x2063, 0x206A,
		0x206B, 0x206C, 0x206D, 0x206E, 0x206F, 0xFEFF, 0xFFF9, 0xFFFA,
		0xFFFB, 0x1D173, 0x1D174, 0x1D175, 0x1D176, 0x1D177, 0x1D178, 0x1D179,
		0x1D17A, 0xE0001, 0xE0020, 0xE0021, 0xE0022, 0xE0023, 0xE0024, 0xE0025,
		0xE0026, 0xE0027, 0xE0028, 0xE0029, 0xE002A, 0xE002B, 0xE002C, 0xE002D,
		0xE002E, 0xE002F, 0xE0030, 0xE0031, 0xE0032, 0xE0033, 0xE0034, 0xE0035,
		0xE0036, 0xE0037, 0xE0038, 0xE0039, 0xE003A, 0xE003B, 0xE003C, 0xE003D,
		0xE003E, 0xE003F, 0xE0040, 0xE0041, 0xE0042, 0xE0043, 0xE0044, 0xE0045,
		0xE0046, 0xE0047, 0xE0048, 0xE0049, 0xE004A, 0xE004B, 0xE004C, 0xE004D,
		0xE004E, 0xE004F, 0xE0050, 0xE0051, 0xE0052, 0xE0053, 0xE0054, 0xE0055,
		0xE0056, 0xE0057, 0xE0058, 0xE0059, 0xE005A, 0xE005B, 0xE005C, 0xE005D,
		0xE005E, 0xE005F, 0xE0060, 0xE0061, 0xE0062, 0xE0063, 0xE0064, 0xE0065,
		0xE0066, 0xE0067, 0xE0068, 0xE0069, 0xE006A, 0xE006B, 0xE006C, 0xE006D,
		0xE006E, 0xE006F, 0xE0070, 0xE0071, 0xE0072, 0xE0073, 0xE0074, 0xE0075,
		0xE0076, 0xE0077, 0xE0078, 0xE0079, 0xE007A, 0xE007B, 0xE007C, 0xE007D,
		0xE007E, 0xE007F,
	};
	static const CodePoint	zs[] = {
		0x0009,	// ^u Zs ł͂ȂAł͋󔒗ޕƂĈ
		0x0020, 0x00A0, 0x1680, 0x180E, 0x2000, 0x2001, 0x2002, 0x2003,
		0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009, 0x200A, 0x202F,
		0x205F, 0x3000,
	};

	if(cp == 0x05F3		// Hebrew Punctuation Geresh
			|| m_lexer.IsIdentifierStartCodePoint(cp))
		return aLetter;
	else if(binary_search(zs, _endof(zs), cp))
		return space;
	else if(cp == 0x002E		// Full Stop
			|| (cp == 0x003A	// Colon (for Swedish)
			&& langid == LANG_SWEDISH))
		return midNumLet;
	else if(cp == 0x0027		// Apostrophe
			|| cp == 0x00B7		// Middle Dot
			|| cp == 0x05F4		// Hebrew Punctuation Gershayim
			|| cp == 0x2019		// Right Single Quotation Mark
			|| cp == 0x2027		// Hyphenation Point
			|| (cp == 0x0022	// Quotation Mark (for legacy Hebrew)
			&& langid == LANG_HEBREW))
		return midLetter;
	else if(cp == 0x2024		// One Dot Leader
			|| cp == 0x2025		// Two Dot Leader
			|| cp == 0x2026)	// Horizontal Ellipsis
		return midNum;
	else if(binary_search(cf, _endof(cf), cp))
		return format;
	else if(CLexer::IsDigit(cp))	// Mathematical digits
		return numeric;
	else
		return other;
}

/**
 *	񂪎wʒuɒPꋫEǂׂ
 *	@param str		ׂ镶
 *	@param index	ׂʒu
 *	@return			<var>index</var> PꋫȄꍇ true
 */
bool CBoundarySearcher::HasWordBoundaryAt(const string_t& str, length_t index) const {
	AssertValid();

	if(index == 0 || index == str.length())
		return true;	// (1, 2)
	else if(index > str.length())
		return false;

	const char_t*	pwsz = str.c_str();
	const length_t	cch = str.length();
	CodePoint		cpNext = DecodeUtf16SurrogatesToCodePoint(pwsz + index, cch - index);

	if(!IsGraphemeBase(cpNext))
		return false;	// (3)

	_WBClass	wbcNext = _GetWordBoundaryClass(cpNext);

	if(wbcNext == format)
		return false;	// (4)
	if(wbcNext == aLetter || wbcNext == midLetter
			|| wbcNext == midNumLet || wbcNext == midNum || wbcNext == numeric) {
		length_t	iPrev = index;	// index != 0
		CodePoint	cpPrev;
		_WBClass	wbcPrev;

		while(true) {	// (3)
			if(iPrev == 0) {
				cpPrev = 0x0041;	// 芸...
				break;
			} else if(iPrev > 2
					&& IsUtf16HighSurrogate(pwsz[iPrev - 2])
					&& IsUtf16LowSurrogate(pwsz[iPrev - 1]))
				cpPrev = DecodeUtf16SurrogatesToCodePoint(pwsz + iPrev - 2, 2);
			else
				cpPrev = pwsz[iPrev - 1];
			iPrev -= (cpPrev > 0xFFFF) ? 2 : 1;
			if(IsGraphemeBase(cpPrev))
				break;
		}
		wbcPrev = _GetWordBoundaryClass(cpPrev);

		if(wbcNext == aLetter && wbcPrev == aLetter)	// (5+, !13)
			return !AreSameScriptType(cpPrev, cpNext);
		else if((wbcNext == aLetter || wbcNext == numeric)
				&& (wbcPrev == aLetter || wbcPrev == numeric))	// (8, 9, 10)
			return false;
		else if((wbcPrev == aLetter && (wbcNext == midLetter || wbcNext == midNumLet))
				|| (wbcPrev == numeric && (wbcNext == midNum || wbcNext == midNumLet))) {	// (6, 12)?
			length_t	iNextNext = index + ((cpNext > 0xFFFF) ? 2 : 1);
			CodePoint	cpNextNext;

			while(true) {
				if(iNextNext == cch)
					return true;
				cpNextNext = DecodeUtf16SurrogatesToCodePoint(pwsz + iNextNext, cch - iNextNext);
				if(IsGraphemeBase(cpNextNext))
					break;
			}
			return wbcPrev == _GetWordBoundaryClass(cpNextNext);
		} else if(((wbcPrev == midLetter || wbcPrev == midNumLet) && wbcNext == aLetter)
				|| ((wbcPrev == midNum || wbcPrev == midNumLet) && wbcNext == numeric)) {	// (7, 11)?
			length_t	iPrevPrev = iPrev;
			CodePoint	cpPrevPrev;

			if(iPrevPrev == 0)
				return true;

			while(true) {
				if(iPrevPrev == 0) {
					cpPrevPrev = 0x0041;
					break;
				} else if(iPrevPrev == 1)
					cpPrevPrev = pwsz[0];
				else if(IsUtf16HighSurrogate(pwsz[iPrevPrev - 2])
						&& IsUtf16LowSurrogate(pwsz[iPrevPrev - 1]))
					cpPrevPrev = DecodeUtf16SurrogatesToCodePoint(pwsz + iPrevPrev - 2, 2);
				else
					cpPrevPrev = pwsz[iPrevPrev - 1];
				if(IsGraphemeBase(cpPrevPrev))
					break;
				iPrevPrev -= (cpPrevPrev > 0xFFFF) ? 2 : 1;
			}
			return wbcNext == _GetWordBoundaryClass(cpPrevPrev);
		}
	}
	return true;
}

/**
 *	NX^̍ŏ̕ɂȂ邩𒲂ׂ (A
 *	ʃTQ[g͒ÕR[h|CgɈˑ邽߂̃\bhłׂ͒Ȃ)
 *	@param cp	ׂR[h|Cg
 *	@return		<var>cp</var> NX̐擪̕ɂȂꍇ true
 */
bool CBoundarySearcher::IsGraphemeBase(CodePoint cp) {
	// ʕނ Mn (Mark, Non-Spacing)AMc (Mark, Spacing Combining)A
	// Me (Mark, Enclosing) ̂ꂩłR[h|Cg̃Xg
	// unicat.pl 莩 (Unicode 4.0)
	//
	// NOTE: ̕ނɂĂ Unicode R\[VA
	// uUAX#29: Text BoundariesvɃKChC邪A
	// Ascension  (6, 7, 8, 9) ɂĂ͂ɏ]Ȃ
	// ((9) ɂĂ͏L̈ʕނg)B
	//
	// NOTE: XɈȉ͂̃̕\bhł͔łȂA
	// Lbg󂯎ȂقǂȂB
	//   U+17B4: Khmer Vowel Inherent Aq
	//   U+17B5: Khmer Vowel Inherent Aa
	// 2 Unicode 4.0 ł񐄏ƂȂĂ
	//
	// NOTE: ȉ2͔Oɕ (̕ Character Decomposition Mapping  <compat>)A
	// ŏIIȔɂ͐擪̃R[h|CggB
	//	U+0E33: Thai Character Sara Am (=> U+0E4D U+0E32)
	//	U+0EB3: Lao Vowel Sign Am (=> U+0ECD U+0EB2)
	static const CodePoint	mx[] = {
#if(ASCENSION_UNICODE_VERSION != 0x0410)
#error Included file version differs from Ascension Unicode version. Update correspoding file.
#endif
#include "script\TextSearcher_GraphemeExtender"
	};
	if(cp == 0x0E33)		cp = 0x0E4D;
	else if(cp == 0x0EB3)	cp = 0x0ECD;
	return !std::binary_search(mx, _endof(mx), cp);
}

/**
 *	NX^̐擪̕
 *	@param pos		Jnʒu
 *	@param bForward	O (hLg̏I[) ̏ꍇ true
 *	@return			ʒu (<var>pos</var> Ɠł\)
 */
CCharPos CBoundarySearcher::SearchGraphemeBase(const CCharPos& pos, bool bForward) const {
	AssertValid();

	if(pos.m_iChar == 0 && !bForward) {
		if(pos.m_iLine == 0)
			return pos;
		return CCharPos(pos.m_iLine - 1, m_document.GetLineLength(pos.m_iLine - 1));
	}

	const length_t	cLines = m_document.GetLineCount();
	const string_t&	strLine = m_document.GetLine(pos.m_iLine);
	const length_t	cchLine = strLine.length();

	assert(pos.m_iLine < cLines && pos.m_iChar <= cchLine);

	if(pos.m_iChar == cchLine && pos.m_iLine < cLines - 1)
		return CCharPos(pos.m_iLine + 1, 0);

	const char_t*	pwszLine = strLine.data();
	CodePoint		cp;

	if(bForward) {
		for(length_t i = pos.m_iChar + 1; i < cchLine; ++i) {
			cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + i, cchLine - 1);
			if(CBoundarySearcher::IsGraphemeBase(cp))
				return CCharPos(pos.m_iLine, i);
			if(cp > 0xFFFF)
				++i;
		}
		return CCharPos(pos.m_iLine, cchLine);
	} else {
		for(length_t i = pos.m_iChar - 1; i > 0; --i) {
			if(i > 2
					&& IsUtf16HighSurrogate(pwszLine[i - 2])
					&& IsUtf16LowSurrogate(pwszLine[i - 1]))
				cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + i - 2, 2);
			else
				cp = pwszLine[i - 1];
			if(CBoundarySearcher::IsGraphemeBase(cp))
				return CCharPos(pos.m_iLine, i);
			if(cp > 0xFFFF)
				--i;
		}
		return CCharPos(pos.m_iLine, 0);
	}
}

/**
 *	iE
 *	@param pos		Jnʒu
 *	@param bForward	O (hLg̏I[) ̏ꍇ true
 *	@param part		iÊǂ̕邩
 *	@return			ʒu
 */
CCharPos CBoundarySearcher::SearchParagraphBoundary(const CCharPos& pos, bool bForward, SearchPart part) const {
	AssertValid();
	return pos;	// 
}

/**
 *	ߋE
 *	@param pos		Jnʒu
 *	@param bForward	O (hLg̏I[) ̏ꍇ true
 *	@param part		ߋÊǂ̕邩
 *	@return			ʒu
 */
CCharPos CBoundarySearcher::SearchSentenceBoundary(const CCharPos& pos, bool bForward, SearchPart part) const {
	AssertValid();
	return pos;	// 
}

/**
 *	@brief	PꋫE
 *
 *	ʒu͌JnʒuƂ͈قȂʒuɂȂ
 *	(hLg̐擪ȀꍇȊO)
 *
 *	PꋫE̊TO͒PPʂ̈ړR}h (CCaretMovementCommand)
 *	_uNbNɂJ[\ʒu̒PIȂǂɎgp
 *
 *	Ascension ɂPꋫE̒`͂܂m肵ĂȂB
 *	݂̎ CBoundarySearcher::IsGraphemeBase Ɠ
 *	uUAX #29: Text BoundariesvqgɂĂ邪A
 *	̃KChCSɖĂ킯ł͂Ȃ
 *	({ɓɂȂĂ)
 *
 *	@param pos		Jnʒu
 *	@param bForward	O (hLg̏I[) ̏ꍇ true
 *	@param part		PꋫÊǂ̕邩
 *	@return			ʒu
 */
CCharPos CBoundarySearcher::SearchWordBoundary(const CCharPos& pos, bool bForward, SearchPart part) const {
	AssertValid();

	const bool		bRestrictionEffective = m_document.IsNarrowed() && toBoolean(part & RESTRICTION_EFFECTIVE);
	const CCharPos	posTop = m_document.GetStartPoint();
	const CCharPos	posBottom = m_document.GetEndPoint();
	CCharPos		posFound = pos;

	if(bRestrictionEffective) {
		if(pos < posTop
				|| pos > posBottom
				|| (!bForward && pos == posTop)
				|| (bForward && pos == posBottom))
			return pos;
	}

	if(pos.m_iChar == 0 && !bForward) {	// sO̍sɖ߂낤ƂĂ
		if(pos.m_iLine == 0 || toBoolean(part & ONLY_CURRENT_LINE))
			return pos;
		posFound.m_iChar = m_document.GetLineLength(--posFound.m_iLine);
		if(!toBoolean(part & START))
			return posFound;
	} else if(bForward	// s玟̍sɐiƂĂ
			&& pos.m_iChar == m_document.GetLineLength(pos.m_iLine)) {
		if(pos.m_iLine == m_document.GetLineCount() - 1 || toBoolean(part & ONLY_CURRENT_LINE))
			return pos;
		++posFound.m_iLine;
		const length_t	cchLine =
			(bRestrictionEffective && posFound.m_iLine == posBottom.m_iLine) ?
			posBottom.m_iChar : m_document.GetLineLength(posFound.m_iLine);
		posFound.m_iChar = m_lexer.EatWhiteSpaces(m_document.GetLine(posFound.m_iLine).data(), cchLine, true);
		if(toBoolean(part & START)) {
			if(toBoolean(part & ALPHA_NUMERIC) && posFound.m_iChar < cchLine) {
				const CodePoint	cp = DecodeUtf16SurrogatesToCodePoint(
					m_document.GetLine(posFound.m_iLine).data() + posFound.m_iChar, cchLine - posFound.m_iChar);
				if(m_lexer.IsIdentifierContinueCodePoint(cp))
					return posFound;
			} else
				return posFound;
		}
	}

	// .::.
	// ȉ̃Rg̊ʕt̐ UAX #29 Ɍ鋫EK̂́B
	// !(n) ͋K̗pȂƂA(n)+ ͓YKɓƎ߂{Ƃ\B
	// (0)  Ascension ̒ǉKŁAʂP̐擪AI[AP\ɐꍇɓKpB
	const string_t&	strLine = m_document.GetLine(posFound.m_iLine);
	const char_t*	pwszLine = strLine.data();

	// ׂs̐擪ʒuƏI[ʒuBi[COɂsŜ苷ȂĂ
	const length_t	iStartChar =
		(bRestrictionEffective && posFound.m_iLine == posTop.m_iLine) ? posTop.m_iChar : 0;
	const length_t	iEndChar =
		(bRestrictionEffective && posFound.m_iLine == posBottom.m_iLine) ? posBottom.m_iChar : strLine.length();

	if(iStartChar == iEndChar /*|| (pos.m_iChar >= iEndChar - 1 && bForward)*/)	// eot (2)
		return posFound;

	_WBClass	wbcLeft = uncalculated;			// ׂʒu̍
	_WBClass	wbcRight = uncalculated;		// ׂʒủE
	CodePoint	cp, cpNext = -1, cpPrev = -1;

	if(bForward) {
		_WBClass	wbcRightAnother = uncalculated;	// ׂʒu2E
		while(posFound.m_iChar < iEndChar) {
			if(cpNext != -1) {
				cp = cpNext;
				cpNext = -1;
			} else
				cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + posFound.m_iChar, iEndChar - posFound.m_iChar);
			if(posFound.m_iChar == pos.m_iChar
					|| (posFound.m_iChar == 0 && iEndChar != 0)) {
				wbcLeft = _GetWordBoundaryClass(cp);
				posFound.m_iChar += (cp > 0xFFFF) ? 2 : 1;
				cpPrev = cp;
				continue;
			}
			if(wbcRight == uncalculated)
				wbcRight = _GetWordBoundaryClass(cp);

			// Lbg󂯎ȂR[h|Cg͖ (3)
			// Cf R[h|Cg͖ (4)
			if(wbcRight == format || CBoundarySearcher::IsGraphemeBase(cp)) {
				if(wbcLeft == aLetter && wbcRight == aLetter) {	// (5+, !13)
					if(!AreSameScriptType(cpPrev, cp))
						return posFound;
					posFound.m_iChar += (cp > 0xFFFF) ? 2 : 1;
				} else if((wbcLeft == aLetter || wbcLeft == numeric)
						&& (wbcRight == aLetter || wbcRight == numeric))	// (8, 9, 10)
					posFound.m_iChar += (cp > 0xFFFF) ? 2 : 1;
				else if((wbcLeft == aLetter && (wbcRight == midLetter /*|| wbcRight == midNumLet*/))	// (6, 7)?
						|| (wbcLeft == numeric && (wbcRight == midNum || wbcRight == midNumLet))) {	// (11, 12)?
					const length_t	iNextChar = posFound.m_iChar + ((cp > 0xFFFF) ? 2 : 1);

					if(iNextChar >= iEndChar)
						return posFound;	// (14)
					cpNext = DecodeUtf16SurrogatesToCodePoint(pwszLine + iNextChar, iEndChar - iNextChar);
					wbcRightAnother = _GetWordBoundaryClass(cpNext);
					if(wbcLeft != wbcRightAnother) {	// (14)
						if(!toBoolean(part & ALPHA_NUMERIC)
								|| m_lexer.IsIdentifierContinueCodePoint(cp)
								|| m_lexer.IsIdentifierContinueCodePoint(cpNext))
							return posFound;
					}
					posFound.m_iChar = iNextChar;	// (6, 7, 11, 12)
					wbcRight = wbcRightAnother;
					wbcRightAnother = uncalculated;
					cpPrev = cp;
					cp = cpNext;
					cpNext = -1;
				} else if(((wbcLeft == midLetter /*|| wbcLeft == midNumLet*/) && wbcRight == aLetter)	// (6)?
						|| ((wbcLeft == midNum || wbcLeft == midNumLet) && wbcRight == numeric)) {	// (11)?
					length_t	iPrevAnotherChar = posFound.m_iChar - ((cpPrev > 0xFFFF) ? 2 : 1);

					if(iPrevAnotherChar == 0)
						return posFound;	// (14)
					iPrevAnotherChar -= (iPrevAnotherChar > 1
							&& IsUtf16HighSurrogate(pwszLine[iPrevAnotherChar - 2])
							&& IsUtf16LowSurrogate(pwszLine[iPrevAnotherChar - 1])) ? 2 : 1;
					const CodePoint	cpPrevAnother = DecodeUtf16SurrogatesToCodePoint(pwszLine + iPrevAnotherChar, 2);
					const _WBClass	wbcLeftAnother = _GetWordBoundaryClass(cpPrevAnother);
					if(wbcRight != wbcLeftAnother) {	// (14)
						if(!toBoolean(part & ALPHA_NUMERIC)
								|| m_lexer.IsIdentifierContinueCodePoint(cp)
								|| m_lexer.IsIdentifierContinueCodePoint(cpNext))
							return posFound;
					}
				} else if((!toBoolean(part & END) && wbcRight == space)	// (0)
						|| (!toBoolean(part & START) && wbcLeft == space))	// (0)
					posFound.m_iChar += (cp > 0xFFFF) ? 2 : 1;
				else if(toBoolean(part & ALPHA_NUMERIC)	// (0)
						&& (!toBoolean(part & START) || !m_lexer.IsIdentifierContinueCodePoint(cp))
						&& (!toBoolean(part & END) || !m_lexer.IsIdentifierContinueCodePoint(cpPrev)))
					posFound.m_iChar += (cp > 0xFFFF) ? 2 : 1;
				else
					return posFound;	// (14)
			} else {
				posFound.m_iChar += (cp > 0xFFFF) ? 2 : 1;
				wbcRight = wbcLeft;
				cp = cpPrev;
			}

			wbcLeft = wbcRight;
			wbcRight = wbcRightAnother;
			wbcRightAnother = uncalculated;
			cpPrev = cp;
		}
		return posFound;	// (2)
	} else {
		_WBClass	wbcLeftAnother = uncalculated;	// ׂʒu2
		while(posFound.m_iChar > iStartChar) {
			bool	bEscapedFromSurrogates = false;
			if(cpNext != -1) {
				cp = cpNext;	// ɂ͗ȂC
				cpNext = -1;
			} else if(posFound.m_iChar > 1
					&& IsUtf16LowSurrogate(pwszLine[posFound.m_iChar - 1])
					&& IsUtf16HighSurrogate(pwszLine[posFound.m_iChar - 2]))
				cp = DecodeUtf16SurrogatesToCodePoint(
					pwszLine + posFound.m_iChar - 2, iEndChar - posFound.m_iChar + 2);
			else {
				cp = DecodeUtf16SurrogatesToCodePoint(
					pwszLine + posFound.m_iChar - 1, iEndChar - posFound.m_iChar + 1);
				if(cp > 0xFFFF) {
					--posFound.m_iChar;
					bEscapedFromSurrogates = true;
				}
			}
			if(posFound.m_iChar == pos.m_iChar
					|| (posFound.m_iChar == iEndChar && iEndChar != iStartChar)
					|| bEscapedFromSurrogates) {
				wbcRight = _GetWordBoundaryClass(cp);
				posFound.m_iChar -= (cp > 0xFFFF) ? 2 : 1;
				cpPrev = cp;
				continue;
			}
			if(wbcLeft == uncalculated)
				wbcLeft = _GetWordBoundaryClass(cp);

			// Lbg󂯎ȂR[h|Cg͖ (3)
			// Cf R[h|Cg͖ (4)
			if(wbcLeft == format || CBoundarySearcher::IsGraphemeBase(cp)) {
				if(wbcLeft == aLetter && wbcRight == aLetter) {	// (5+, !13)
					if(!AreSameScriptType(cp, cpPrev))
						return posFound;
					posFound.m_iChar -= (cp > 0xFFFF) ? 2 : 1;
				} else if((wbcLeft == aLetter || wbcLeft == numeric)	// (8, 9, 10)
						&& (wbcRight == aLetter || wbcRight == numeric))
					posFound.m_iChar -= (cp > 0xFFFF) ? 2 : 1;
				else if((wbcRight == aLetter && (wbcLeft == midLetter /*|| wbcLeft == midNumLet*/))	// (6, 7)?
						|| (wbcRight == numeric && (wbcLeft == midNum || wbcLeft == midNumLet))) {	// (11, 12)?
					length_t	iNextChar = posFound.m_iChar - ((cp > 0xFFFF) ? 2 : 1);

					if(iNextChar == iStartChar)
						return posFound;	// (14)
					iNextChar -= (iNextChar > 1
						&& IsUtf16HighSurrogate(pwszLine[iNextChar - 2])
						&& IsUtf16LowSurrogate(pwszLine[iNextChar - 1])) ? 2 : 1;
					cpNext = DecodeUtf16SurrogatesToCodePoint(pwszLine + iNextChar, iEndChar - iNextChar);
					wbcLeftAnother = _GetWordBoundaryClass(cpNext);
					if(wbcRight != wbcLeftAnother) {
						if(!toBoolean(part & ALPHA_NUMERIC)
								|| m_lexer.IsIdentifierContinueCodePoint(cp)
								|| m_lexer.IsIdentifierContinueCodePoint(cpNext))
							return posFound;	// (14)
					}
					posFound.m_iChar = iNextChar;	// (6, 7, 11, 12)
					wbcLeft = wbcLeftAnother;
					wbcLeftAnother = uncalculated;
					cpPrev = cp;
					cp = cpNext;
					cpNext = -1;
				} else if((wbcLeft == aLetter && (wbcRight == midLetter /*|| wbcRight == midNumLet*/))	// (7)?
						|| (wbcLeft == numeric && (wbcRight == midNum || wbcRight == midNumLet))) {	// (12)?
					const length_t	iNextAnotherChar = posFound.m_iChar + ((cpPrev > 0xFFFF) ? 2 : 1);

					if(iNextAnotherChar >= iEndChar)
						return posFound;	// (14)
					const CodePoint	cpPrevAnother = 
							DecodeUtf16SurrogatesToCodePoint(pwszLine + iNextAnotherChar, iEndChar - iNextAnotherChar);
					const _WBClass	wbcRightAnother = _GetWordBoundaryClass(cpPrevAnother);
					if(wbcLeft != wbcRightAnother) {	// (14)
						if(!toBoolean(part & ALPHA_NUMERIC)
								|| m_lexer.IsIdentifierContinueCodePoint(cp)
								|| m_lexer.IsIdentifierContinueCodePoint(cpPrev))
							return posFound;
					}
				} else if((!toBoolean(part & END) && wbcRight == space)	// (0)
						|| (!toBoolean(part & START) && wbcLeft == space))	// (0)
					posFound.m_iChar -= (cp > 0xFFFF) ? 2 : 1;
				else if(toBoolean(part & ALPHA_NUMERIC)	// (0)
						&& (!toBoolean(part & START) || !m_lexer.IsIdentifierContinueCodePoint(cpPrev))
						&& (!toBoolean(part & END) || !m_lexer.IsIdentifierContinueCodePoint(cp)))
					posFound.m_iChar -= (cp > 0xFFFF) ? 2 : 1;
				else
					return posFound;
			} else {
				posFound.m_iChar -= (cp > 0xFFFF) ? 2 : 1;
				wbcLeft = wbcRight;
				cp = cpPrev;
			}

			wbcRight = wbcLeft;
			wbcLeft = wbcLeftAnother;
			wbcLeftAnother = uncalculated;
			cpPrev = cp;
		}
		return posFound;	// (2)
	}
}

#undef MATCH_TAG
#undef NO_MATCH_TAG
#undef MAKE_REGEX_ERROR

/* [EOF] */