// StandardCommands.cpp
// (c) 2003-2005 exeal

/**
 *	@file	StandardCommands.cpp
 *	Ascension::StandardCommands ̃R}hNX̎
 */

#include "StdAfx.h"
#include "EditView.h"
#include "EditPoint.h"
#include "../../Manah/win_utils.h"
#include "../../Manah/WaitCursor.h"
using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Ascension::StandardCommands;
using namespace Manah;
using namespace Manah::Windows;
using namespace std;


#define ASSERT_IFISWINDOW()	assert(GetTarget().IsWindow())
#define ABORT_ISEARCH()										\
	if(GetTarget().GetIncrementalSearcher().IsRunning())	\
		GetTarget().GetIncrementalSearcher().AbortSearch()
#define END_ISEARCH()										\
	if(GetTarget().GetIncrementalSearcher().IsRunning())	\
		GetTarget().GetIncrementalSearcher().EndSearch()
#define CHECK_DOCUMENT_READONLY()				\
	if(GetTarget().GetDocument().IsReadOnly())	\
		return 0
#define CHECK_GUI_EDITABILITY()				\
	if(!GetTarget().CheckGuiEditability())	\
		return 0
#define CLOSE_COMPLETION_WINDOW()	GetTarget().CloseCompletionWindow()
#define ABORT_MODES()			\
	CLOSE_COMPLETION_WINDOW();	\
	ABORT_ISEARCH()


inline CCompletionWindow& CEditorCommand::GetCompletionWindow() const {
	return *m_pView->m_pCompletionWindow;
}

/// ubN}[NSĉBANeBu|CĝsɃubN}[Nݒ/
ulong CBookmarkCommand::Execute() {
	ABORT_MODES();
	if(m_type == CLEAR_ALL)
		GetTarget().GetBookmarker().ClearAllBookmarks();
	else if(m_type == TOGGLE_CURRENT_LINE)
		GetTarget().GetBookmarker().ToggleBookmark(GetTarget().GetSelection().GetActivePoint().GetLineNumber());
	else
		assert(false);
	return 0;
}

/// IBCN^𖾎Iɒ~
ulong CCancelCommand::Execute() {
	ASSERT_IFISWINDOW();
	ABORT_MODES();
	else if(!GetTarget().GetSelection().IsEmpty())	// I
		GetTarget().GetSelection().MoveTo(GetTarget().GetSelection().GetActivePoint(), true);
	return 0;
}

/// LbgړBIg
ulong CCaretMovementCommand::Execute() {
	END_ISEARCH();

	if(GetCompletionWindow().IsWindowVisible()) {
		switch(m_type) {
		case NEXT_LINE:		GetCompletionWindow().SendMessage(WM_KEYDOWN, VK_DOWN);		return 0;
		case PREVIOUS_LINE:	GetCompletionWindow().SendMessage(WM_KEYDOWN, VK_UP);		return 0;
		case NEXT_PAGE:		GetCompletionWindow().SendMessage(WM_KEYDOWN, VK_NEXT);		return 0;
		case PREVIOUS_PAGE:	GetCompletionWindow().SendMessage(WM_KEYDOWN, VK_PRIOR);	return 0;
		}
	}

	CSelection&	selection = GetTarget().GetSelection();

	if(!selection.IsEmpty() && !m_bExtend) {	// I邾
		if(m_type == NEXT_CHARACTER
				|| (m_type == RIGHT_CHARACTER && !GetTarget().IsTextDirectionRightToLeft())
				|| (m_type == LEFT_CHARACTER && GetTarget().IsTextDirectionRightToLeft())) {
			selection.MoveTo(selection.GetEndPoint(), true);
			return 0;
		} else if(m_type == PREVIOUS_CHARACTER
				|| (m_type == LEFT_CHARACTER && !GetTarget().IsTextDirectionRightToLeft())
				|| (m_type == RIGHT_CHARACTER && GetTarget().IsTextDirectionRightToLeft())) {
			selection.MoveTo(selection.GetStartPoint(), true);
			return 0;
		}
	}

	if(m_type == MATCH_BRACKET) {
		const CEditPoint&	activePoint = selection.GetActivePoint();
		CCharPos			posFound;

		if(GetTarget().FindMatchBracket(activePoint, posFound, false)) {
			if(!m_bExtend)
				selection.MoveTo(posFound, true);
			else if(posFound > activePoint)
				selection.Select(activePoint, CCharPos(posFound.m_iLine, posFound.m_iChar + 1), selection.IsRectangle(), true);
			else
				selection.Select(CCharPos(activePoint.GetLineNumber(),
					activePoint.GetCharNumber() + 1), posFound, selection.IsRectangle(), true);
		} else if(!activePoint.IsStartOfLine()
				&& GetTarget().FindMatchBracket(
					CCharPos(activePoint.GetLineNumber(), activePoint.GetCharNumber() - 1), posFound, false)) {
			if(!m_bExtend)
				selection.MoveTo(posFound, true);
			else if(posFound > CCharPos(activePoint.GetLineNumber(), activePoint.GetCharNumber() - 1))
				selection.Select(CCharPos(activePoint.GetLineNumber(), activePoint.GetCharNumber() - 1),
					CCharPos(posFound.m_iLine, posFound.m_iChar + 1), selection.IsRectangle(), true);
			else
				selection.Select(activePoint, posFound, selection.IsRectangle(), true);
		} else
			GetTarget().Beep();	// Ȃ
	} else {
		CVisualPoint&	caret = selection.GetActivePoint();

		if(!m_bExtend)
			selection.SynchronizeAnchorWithActive();
		switch(m_type) {
		case NEXT_CHARACTER:			caret.CharNext(m_c);	break;
		case PREVIOUS_CHARACTER:		caret.CharPrev(m_c);	break;
		case LEFT_CHARACTER:			caret.CharLeft(m_c);	break;
		case RIGHT_CHARACTER:			caret.CharRight(m_c);	break;
		case NEXT_WORD:					caret.WordNext(m_c);	break;
		case PREVIOUS_WORD:				caret.WordPrev(m_c);	break;
		case LEFT_WORD:					caret.WordLeft(m_c);	break;
		case RIGHT_WORD:				caret.WordRight(m_c);	break;
		case NEXT_WORDEND:				caret.WordEndNext(m_c);	break;
		case PREVIOUS_WORDEND:			caret.WordEndPrev(m_c);	break;
		case LEFT_WORDEND:				caret.WordEndLeft(m_c);		break;
		case RIGHT_WORDEND:				caret.WordEndRight(m_c);	break;
		case NEXT_LINE:					caret.LineDown(m_c);	break;
		case PREVIOUS_LINE:				caret.LineUp(m_c);		break;
		case NEXT_PAGE:					GetTarget().SendMessage(WM_VSCROLL, SB_PAGEDOWN); caret.PageDown(m_c);	break;
		case PREVIOUS_PAGE:				GetTarget().SendMessage(WM_VSCROLL, SB_PAGEUP); caret.PageUp(m_c);		break;
		case START_OF_LINE:				caret.MoveToStartOfLine();	break;
		case END_OF_LINE:				caret.MoveToEndOfLine();	break;
		case FIRST_CHAR_OF_LINE:		caret.MoveToFirstCharOfLine();	break;
		case LAST_CHAR_OF_LINE:			caret.MoveToLastCharOfLine();	break;
		case START_OR_FIRST_OF_LINE:	caret.IsFirstCharOfLine() ? caret.MoveToStartOfLine() : caret.MoveToFirstCharOfLine();	break;
		case END_OR_LAST_OF_LINE:		caret.IsLastCharOfLine() ? caret.MoveToEndOfLine() : caret.MoveToLastCharOfLine();		break;
		case START_OF_DOCUMENT:			caret.MoveToStartOfDocument();	break;
		case END_OF_DOCUMENT:			caret.MoveToEndOfDocument();	break;
		case NEXT_BOOKMARK:				caret.MoveToNextBookmark();	break;
		case PREVIOUS_BOOKMARK:			caret.MoveToPrevBookmark();	break;
		}
	}
	return 0;
}

/// Lbgʒu̕R[h|CgɁA邢̓R[h|Cg\𑊓镶ɕϊ
ulong CCharacterCodePointConversionCommand::Execute() {
	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();
	ABORT_MODES();

	CEditView&			view = GetTarget();
	const CEditDoc&		document = view.GetDocument();
	const CEditPoint&	posBottom = view.GetSelection().GetEndPoint();

	if(posBottom.IsStartOfLine()
			|| (document.IsNarrowed() && posBottom.GetPosition() == document.GetStartPoint())) {	// sȊOłȂ΂Ȃ
		view.Beep();
		return 0;
	}

	const char_t* const	pwszLine = document.GetLine(posBottom.GetLineNumber()).data();
	CodePoint			cp;

	if(m_param) {	//  -> R[h|Cg
		char_t	wszCp[7];

		if(posBottom.GetCharNumber() > 1
				&& IsUtf16HighSurrogate(pwszLine[posBottom.GetCharNumber() - 2])
				&& IsUtf16LowSurrogate(pwszLine[posBottom.GetCharNumber() - 1]))
			cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + posBottom.GetCharNumber() - 2, 2);
		else
			cp = pwszLine[posBottom.GetCharNumber() - 1];
		swprintf(wszCp, L"%lX", cp);
		view.GetSelection().Select(
			CCharPos(posBottom.GetLineNumber(),
				posBottom.GetCharNumber() - ((cp > 0xFFFF) ? 2 : 1)), posBottom, false, true);
		view.GetSelection().Replace(string_t(wszCp), false);
	} else {	// R[h|Cg -> 
		length_t	i = posBottom.GetCharNumber() - 1;
		char_t		chOrg = pwszLine[posBottom.GetCharNumber()];

		if(toBoolean(iswxdigit(pwszLine[posBottom.GetCharNumber() - 1]))) {
			while(i != 0 && posBottom.GetCharNumber() - i < 6) {
				if(!toBoolean(iswxdigit(pwszLine[i - 1])))
					break;
				--i;
			}
			const_cast<char_t*>(pwszLine)[posBottom.GetCharNumber()] = 0;
			cp = wcstoul(pwszLine + i, 0, 16);
			const_cast<char_t*>(pwszLine)[posBottom.GetCharNumber()] = chOrg;
			if(cp < 0x110000) {
				view.GetSelection().Select(CCharPos(posBottom.GetLineNumber(), i), posBottom, false, true);
				if(cp < 0x010000) {
					string_t	strChar;	// NUL h
					strChar.push_back(static_cast<char_t>(cp));
					view.GetSelection().Replace(strChar, false);
				} else {
					char_t	wszChar[3] = {0, 0, 0};
					EncodeCodePointToUtf16Surrogates(cp, wszChar);
					view.GetSelection().Replace(string_t(wszChar), false);
				}
				return 0;
			}
		}
		view.Beep();
	}
	return 0;
}

/// 1͂BCN^̖͌ɕǉ
/// @see	CEditView::InputCharacter, CEditView::OnChar, CEditView::OnUniChar
ulong CCharacterInputCommand::Execute() {
	// CN^ -> ɒǉ
	if(GetTarget().GetIncrementalSearcher().IsRunning()) {
		CLOSE_COMPLETION_WINDOW();
		if(m_param == 0x0009 || !toBoolean(iswcntrl(static_cast<wint_t>(m_param))))
			GetTarget().GetIncrementalSearcher().AddCharacter(m_param);
	} else
		return GetTarget().InputCharacter(m_param) ? 1 : 0;
	return 0;
}

/// O/̍s̓ʒu͂̕
ulong CCharacterInputFromNextLineCommand::Execute() {
	ABORT_ISEARCH();
	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();

	// issue: ̎̓i[CO𖳎Ă...

	const CEditPoint&	caret = GetTarget().GetSelection().GetActivePoint();
	const bool&			bFromPrevious = !m_param;	// Oɂ...

	if((caret.GetLineNumber() == 0 && bFromPrevious)
			|| (caret.GetLineNumber() == GetTarget().GetDocument().GetLineCount() - 1 && !bFromPrevious)) {
		GetTarget().Beep();
		return 0;
	}

	// ҏW_ĈʒuvZ
	CVisualPoint*	p = GetTarget().GetDocument().CreateEditPoint();
	p->MoveTo(caret);
	if(bFromPrevious)	p->LineUp();
	else				p->LineDown();

	const length_t	iChar = p->GetCharNumber();
	const string_t&	strLine = GetTarget().GetDocument().GetLine(caret.GetLineNumber() + (bFromPrevious ? -1 : 1));

	delete p;
	if(iChar >= strLine.length()) {
		GetTarget().Beep();
		return 0;
	}
	return CCharacterInputCommand(GetTarget(),
		DecodeUtf16SurrogatesToCodePoint(strLine.data() + iChar, strLine.length() - iChar)).Execute();
}

/// Nbv{[h֘Ȃ
ulong CClipboardCommand::Execute() {
	if(m_type == CUT || m_type == PASTE) {
		ASSERT_IFISWINDOW();
		CHECK_DOCUMENT_READONLY();
		CHECK_GUI_EDITABILITY();
		CLOSE_COMPLETION_WINDOW();
		if(m_type == CUT)
			ABORT_ISEARCH();
	}
	if(m_type == COPY)
		GetTarget().GetSelection().Copy(m_bPerformClipboardRing);
	else if(m_type == CUT)
		GetTarget().GetSelection().Cut(m_bPerformClipboardRing);
	else if(m_type == PASTE)
		GetTarget().GetSelection().Paste(m_bPerformClipboardRing);
	return 0;
}

/// O1AO1PAsŚACN^̌̍폜
ulong CDeletionCommand::Execute() {
	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();
	if(m_type != NEXT_CHARACTER && m_type != PREVIOUS_CHARACTER)
		ABORT_ISEARCH();
	if(GetCompletionWindow().IsWindowVisible() && m_type != PREVIOUS_CHARACTER)
		CLOSE_COMPLETION_WINDOW();

	CEditView&				view = GetTarget();
	CEditDoc&				document = view.GetDocument();
	CSelection&				selection = view.GetSelection();
	CIncrementalSearcher&	isearch = view.GetIncrementalSearcher();

	if(isearch.IsRunning()) {
		if(m_type == NEXT_CHARACTER)
			isearch.Reset();
		else if(m_type == PREVIOUS_CHARACTER)
			isearch.Undo();
	} else if(m_type == NEXT_WORD || m_type == PREVIOUS_WORD) {
		const CCharPos	nextWord =
			view.GetBoundarySearcher().SearchWordBoundary(
				selection.GetAnchorPoint(), m_type == NEXT_WORD, CBoundarySearcher::START);
		if(nextWord != selection.GetAnchorPoint()) {
			view.Freeze();
			document.BeginEditCollection();
			const_cast<CVisualPoint&>(selection.GetAnchorPoint()).Delete(nextWord);	// ׈ȃLXg
			selection.MoveTo(selection.GetAnchorPoint(), true);
			document.EndEditCollection();
			view.Unfreeze();
		}
	} else if(!selection.IsEmpty()) {	// I폜
		view.Freeze();
		document.BeginEditCollection();
		selection.Delete();
		document.EndEditCollection();
		view.Unfreeze();
	} else if(m_type == NEXT_CHARACTER) {
		document.EndEditCollection();
		selection.GetAnchorPoint().Delete(1);
		selection.MoveTo(selection.GetAnchorPoint(), true);
	} else if(m_type == PREVIOUS_CHARACTER) {
		document.EndEditCollection();
		selection.GetAnchorPoint().Delete(-1);
		selection.MoveTo(selection.GetAnchorPoint(), true);
	} else if(m_type == WHOLE_LINE) {
		const length_t	iLine = selection.GetActivePoint().GetLineNumber();

		document.EndEditCollection();
		if(iLine != document.GetLineCount() - 1) {	// ŏIsłȂꍇ
			selection.GetAnchorPoint().LineDown();
			selection.MoveTo(selection.GetAnchorPoint(), true);
		}
		document.DeleteText(CCharPos(iLine, 0), CCharPos(iLine, -1));
	} else
		assert(false);
	return 0;
}

/// ɈvsSăubN}[NB邢͑SĒu
/// @return	ubN}[NsA邢͒u񐔂Ԃ
ulong CFindAllCommand::Execute() {
	ABORT_MODES();
    if(m_bOnlySelection && GetTarget().GetSelection().IsEmpty())
		return 0;

	CEditView&					view = GetTarget();
	CEditDoc&					document = view.GetDocument();
	const length_t				cLines = document.GetLineCount();
	CTextSearcher&				searcher = view.GetTextSearcher();
	const CBoundarySearcher&	boundary = view.GetBoundarySearcher();

	// ͈
	const CCharPos	topPoint = m_bOnlySelection ?
		max<CCharPos>(view.GetSelection().GetStartPoint(), document.GetStartPoint()) : document.GetStartPoint();
	const CCharPos	bottomPoint = m_bOnlySelection ?
		min<CCharPos>(view.GetSelection().GetEndPoint(), document.GetEndPoint()) : document.GetEndPoint();

	ulong		count = 0;
	TMatchRange	result;

	if(m_type == BOOKMARK) {
		for(length_t iLine = topPoint.m_iLine; iLine < bottomPoint.m_iLine + 1; ++iLine) {
			const length_t	iBegin = (iLine == topPoint.m_iLine) ? topPoint.m_iChar : 0;
			const string_t	strSearch = document.GetLine(iLine).substr(iBegin,
				(iLine == bottomPoint.m_iLine) ? bottomPoint.m_iChar - iBegin : string_t::npos);

			if(m_lastResult = searcher.Search(strSearch, 0, true, result, boundary)) {
				view.GetBookmarker().SetBookmark(iLine);
				++count;
			}
#ifndef ASCENSION_NO_REGEXP
			else if(m_lastResult.IsFatalError())	// K\G[ -> ss\
				break;
#endif /* !ASCENSION_NO_REGEXP */
		}
	} else if(m_type == REPLACE) {
		view.Freeze();
		document.BeginEditCollection();

		auto_ptr<CVisualPoint>	pAnchorPointClone(document.CreateEditPoint());
		pAnchorPointClone->SynchronizeWithDocumentUpdate(true);
		pAnchorPointClone->MoveTo(view.GetSelection().GetAnchorPoint());
		auto_ptr<CVisualPoint>	pActivePointClone(document.CreateEditPoint());
		pActivePointClone->SynchronizeWithDocumentUpdate(true);
		pActivePointClone->MoveTo(view.GetSelection().GetActivePoint());

		for(length_t iLine = topPoint.m_iLine; iLine < bottomPoint.m_iLine + 1; ++iLine) {
			const string_t&	strLine = document.GetLine(iLine);
			length_t		iBegin = (iLine == topPoint.m_iLine) ? topPoint.m_iChar : 0;

			while(true) {
				if(m_lastResult = searcher.Search(
						(iLine != bottomPoint.m_iLine) ? strLine : strLine.substr(0, bottomPoint.m_iChar),
						iBegin, true, result, boundary)) {
					document.DeleteText(CCharPos(iLine, result.iFound), CCharPos(iLine, result.iFound + result.cchFound));
					document.InsertText(CCharPos(iLine, result.iFound), searcher.GetReplaceText());
					iBegin = result.iFound + searcher.GetReplaceText().length();
					++count;
				}
#ifndef ASCENSION_NO_REGEXP
				else if(m_lastResult.IsFatalError()) {
					// K\G[ -> ss\
					document.EndEditCollection();
					view.Unfreeze();
					return count;
				}
#endif /* !ASCENSION_NO_REGEXP */
				else
					break;
			}
		}
		document.EndEditCollection();
		if(count != 0)
			view.GetSelection().Select(*pAnchorPointClone,
				*pActivePointClone, view.GetSelection().IsRectangle(), true);
		view.Unfreeze();
	}
	return count;
}

/// Ɉv镔IB邢͑IuŒuĂ猟
/// @return	vꍇ1AȂꍇ0
ulong CFindNextCommand::Execute() {
	if(m_bReplace) {
		CHECK_DOCUMENT_READONLY();
		CHECK_GUI_EDITABILITY();
	}
	END_ISEARCH();
	CLOSE_COMPLETION_WINDOW();

	CWaitCursor		wc;
	CEditView&		view = GetTarget();
	CSelection&		selection = view.GetSelection();
	const CEditDoc&	document = view.GetDocument();
	CTextSearcher&	searcher = view.GetTextSearcher();
	const CCharPos	posEnd = m_bForward ? document.GetEndPoint() : document.GetStartPoint();
	TMatchRange		result;

	if(m_bReplace)
		selection.Replace(searcher.GetReplaceText());

	const CCharPos	posBegin = m_bForward ?
		max<CCharPos>(selection.GetEndPoint(), document.GetStartPoint())
		: min<CCharPos>(selection.GetStartPoint(), document.GetEndPoint());

	for(length_t iLine = posBegin.m_iLine, iChar = posBegin.m_iChar; ; iLine += m_bForward ? 1 : -1) {
		if(iLine != posBegin.m_iLine)	// Jnʒu
			iChar = m_bForward ? 0 : -1;
		if(m_lastResult = searcher.Search(
				(iLine != posEnd.m_iLine) ?
					document.GetLine(iLine) : document.GetLine(iLine).substr(0, posEnd.m_iChar),
				iChar, m_bForward, result, view.GetBoundarySearcher())) {
			selection.Select(CCharPos(iLine, result.iFound),
				CCharPos(iLine, result.iFound + result.cchFound), false, true);
			view.HighlightMatchTexts();
			return 1;
#ifndef ASCENSION_NO_REGEXP
		} else if(m_lastResult.IsFatalError()) {	// K\G[ -> ss\
			view.HighlightMatchTexts(false);
			return 0;
#endif /* !ASCENSION_NO_REGEXP */
		} else if(iLine == posEnd.m_iLine)
			break;
		iChar = m_bForward ? 0 : document.GetLineLength(iLine - 1);
	}
	view.HighlightMatchTexts(false);
	return 0;
}

/// CN^JnB~B̈vʒuփWv
ulong CIncrementalSearchCommand::Execute() {
	CLOSE_COMPLETION_WINDOW();
	CIncrementalSearcher&	isearch = GetTarget().GetIncrementalSearcher();

	if(m_type == CIncrementalSearcher::NOT_RUNNING) {	// ~
		if(isearch.IsRunning())
			isearch.AbortSearch();
	} else if(m_type == CIncrementalSearcher::LITERAL_FORWARD || m_type == CIncrementalSearcher::LITERAL_BACKWARD
			|| m_type == CIncrementalSearcher::REGEXP_FORWARD || m_type == CIncrementalSearcher::REGEXP_BACKWARD
			|| m_type == CIncrementalSearcher::MIGEMO_FORWARD || m_type == CIncrementalSearcher::MIGEMO_BACKWARD) {
		if(isearch.GetState() == CIncrementalSearcher::NOT_RUNNING)	// Jn
			isearch.BeginSearch(GetTarget(), m_type, m_pEventListener);
		else	// ̈vʒuփWv
			m_lastResult = isearch.JumpToNextMatch(m_type);
	}
	return 0;
}

/// Cfg
ulong CIndentationCommand::Execute() {
	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();
	END_ISEARCH();
	CLOSE_COMPLETION_WINDOW();

	CEditView&	view = GetTarget();
	CSelection&	selection = view.GetSelection();
	CCharPos	posAnchorResult;

	view.SetNextCharacterVariation(NCV_NONE);
	view.GetDocument().BeginEditCollection();
	view.Freeze();
	if(m_bTabIndent)
		posAnchorResult = selection.GetActivePoint().TabIndent(
			selection.GetAnchorPoint(), selection.IsRectangle(), m_nLevel * (m_bIndent ? 1 : -1));
	else
		posAnchorResult = selection.GetActivePoint().SpaceIndent(
			selection.GetAnchorPoint(), selection.IsRectangle(), m_nLevel * (m_bIndent ? 1 : -1));
	view.GetDocument().EndEditCollection();
	selection.Select(posAnchorResult, selection.GetActivePoint(), selection.IsRectangle(), true);
	view.Unfreeze();

	return 0;
}

/// IME A㏑A\tgL[{[h̊e[h̃gO
ulong CInputStatusToggleCommand::Execute() {
	if(m_type == IME_STATUS) {
		assert(GetTarget().IsWindow());
		HIMC	hImc = ::ImmGetContext(GetTarget());
		::ImmSetOpenStatus(hImc, !toBoolean(::ImmGetOpenStatus(hImc)));
		::ImmReleaseContext(GetTarget(), hImc);
	} else if(m_type == OVERTYPE_MODE) {
		GetTarget().SetOvertypeMode(!GetTarget().IsOvertypeMode());
		CLOSE_COMPLETION_WINDOW();
	} else if(m_type == SOFT_KEYBOARD) {
		assert(GetTarget().IsWindow());
		HIMC	hImc = ::ImmGetContext(GetTarget());
		DWORD	dwConversionMode, dwSentenceMode;
		::ImmGetConversionStatus(hImc, &dwConversionMode, &dwSentenceMode);
		dwConversionMode = toBoolean(dwConversionMode & IME_CMODE_SOFTKBD) ?
			(dwConversionMode & ~IME_CMODE_SOFTKBD) : (dwConversionMode | IME_CMODE_SOFTKBD);
		::ImmSetConversionStatus(hImc, dwConversionMode, dwSentenceMode);
		::ImmReleaseContext(GetTarget(), hImc);
	} else
		assert(false);
	return 0;
}

/**
 *	@brief	sBO̍ssB[hI
 *
 *	Zk`WJ\ȂƂ͓WJB
 *	CN^͌IB
 *	͕⊮͊m肷 (SɈv₪ꍇ͓͕⊮𒆎~ĉs)
 */
ulong CLineBreakCommand::Execute() {
	CEditView&			view = GetTarget();
	CCompletionWindow&	completionWindow = GetCompletionWindow();

	if(view.GetIncrementalSearcher().IsRunning()) {
		view.GetIncrementalSearcher().EndSearch();
		return 0;
	} else if(completionWindow.IsRunning()) {
		if(completionWindow.GetCurSel() != LB_ERR) {	// SɈv₪Ε⊮
			completionWindow.Complete();
			return 0;
		}
		completionWindow.Abort();
	}

	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();

	CSelection&	selection = view.GetSelection();

	if(m_param) {
		if(selection.GetStartPoint().GetLineNumber() != 0)
			selection.MoveTo(CCharPos(selection.GetStartPoint().GetLineNumber() - 1, -1), false);
		else
			selection.MoveTo(CCharPos(0, 0), false);
	}

	view.Freeze();
	view.GetDocument().BeginEditCollection();
	if(selection.IsEmpty()) {
		view.ExpandPrecedingWordAsAbbreviation();
		view.GetDocument().EndEditCollection();
		selection.GetAnchorPoint().NewLine();
	} else {
		selection.Delete();
		selection.GetAnchorPoint().NewLine();
	}
	selection.MoveTo(selection.GetAnchorPoint(), true);
	view.Unfreeze();
	return 0;
}

/// ɓ͂镶ω
ulong CNextInputVariationCommand::Execute() {
	if(!GetTarget().GetDocument().IsReadOnly())
		GetTarget().SetNextCharacterVariation(m_param);
	return 0;
}

/// ⊮EBhEJ
ulong COpenCompletionWindowCommand::Execute() {
	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();
	ABORT_ISEARCH();
	GetTarget().OpenCompletionWindow();
	return 0;
}

/// ݂̑Iɑ΂ IME ĕϊsBIꍇ`Ȉꍇ͖
ulong CReconversionCommand::Execute() {
	END_ISEARCH();
	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();

	CEditView&		view = GetTarget();
	const string_t	strSelection = view.GetSelection().GetText();
	HIMC			hImc = ::ImmGetContext(view);

	if(!toBoolean(::ImmGetOpenStatus(hImc)))	// I ON ɂȂƖꍇ
		::ImmSetOpenStatus(hImc, true);
	::ImmSetCompositionStringW(hImc, SCS_SETSTR,
		const_cast<char_t*>(strSelection.data()), sizeof(char_t) * strSelection.length(), 0, 0);
	// ϊ񂪒߂Đ؂l߂ĂȂ
	if(::ImmGetCompositionStringW(hImc, GCS_COMPSTR, 0, 0) / sizeof(WCHAR) == strSelection.length())
		::ImmNotifyIME(hImc, NI_OPENCANDIDATE, 0, 0);
	else
		view.Beep();
	::ImmReleaseContext(view, hImc);

	CLOSE_COMPLETION_WINDOW();
	return 0;
}

/// `IJnBIɂꍇ݂͌̑Ig
ulong CRowSelectionExtensionCommand::Execute() {
	CLOSE_COMPLETION_WINDOW();
	END_ISEARCH();

	CSelection&	selection = GetTarget().GetSelection();
	static const int	commandMap[] = {
		NEXT_CHARACTER, CCaretMovementCommand::NEXT_CHARACTER,
		PREVIOUS_CHARACTER, CCaretMovementCommand::PREVIOUS_CHARACTER,
		LEFT_CHARACTER, CCaretMovementCommand::LEFT_CHARACTER,
		RIGHT_CHARACTER, CCaretMovementCommand::RIGHT_CHARACTER,
		NEXT_WORD, CCaretMovementCommand::NEXT_WORD,
		PREVIOUS_WORD, CCaretMovementCommand::PREVIOUS_WORD,
		LEFT_WORD, CCaretMovementCommand::LEFT_WORD,
		RIGHT_WORD, CCaretMovementCommand::RIGHT_WORD,
		NEXT_WORDEND, CCaretMovementCommand::NEXT_WORDEND,
		PREVIOUS_WORDEND, CCaretMovementCommand::PREVIOUS_WORDEND,
		LEFT_WORDEND, CCaretMovementCommand::LEFT_WORDEND,
		RIGHT_WORDEND, CCaretMovementCommand::RIGHT_WORDEND,
		NEXT_LINE, CCaretMovementCommand::NEXT_LINE,
		PREVIOUS_LINE, CCaretMovementCommand::PREVIOUS_LINE,
		START_OF_LINE, CCaretMovementCommand::START_OF_LINE,
		END_OF_LINE, CCaretMovementCommand::END_OF_LINE,
		FIRST_CHAR_OF_LINE, CCaretMovementCommand::FIRST_CHAR_OF_LINE,
		LAST_CHAR_OF_LINE, CCaretMovementCommand::LAST_CHAR_OF_LINE,
		START_OR_FIRST_OF_LINE, CCaretMovementCommand::START_OR_FIRST_OF_LINE,
		END_OR_LAST_OF_LINE, CCaretMovementCommand::END_OR_LAST_OF_LINE
	};

	if(selection.IsEmpty() && !selection.IsRectangle())
		selection.Select(selection.GetAnchorPoint(), selection.GetActivePoint(), true, false);
	assert(m_type >= 0 && m_type < _countof(commandMap));
	for(int i = 0; i < _countof(commandMap); i += 2) {
		if(commandMap[i] == m_type) {
			CCaretMovementCommand(GetTarget(), static_cast<CCaretMovementCommand::Type>(commandMap[i + 1]), true).Execute();
			break;
		}
	}
	return 0;
}

/// hLgSI/Lbgʒu̒PI
ulong CSelectionCreationCommand::Execute() {
	END_ISEARCH();

	if(m_type == ALL)
		GetTarget().GetSelection().Select(
			GetTarget().GetDocument().GetStartPoint(),
			GetTarget().GetDocument().GetEndPoint(), false, true);
	else if(m_type == CURRENT_WORD) {
		CSelection&				selection = GetTarget().GetSelection();
		const CEditPoint&		caret = selection.GetAnchorPoint();
		const CBoundarySearcher	boundary(GetTarget().GetDocument(), GetTarget().GetLexer());
		if(caret.IsEndOfLine()) {
			if(caret.IsStartOfLine())	// 0s
				selection.MoveTo(caret, true);
			else	// s
				selection.Select(boundary.SearchWordBoundary(caret, false, CBoundarySearcher::AROUND), caret, false, true);
		} else if(caret.IsStartOfLine())	// s
			selection.Select(caret, boundary.SearchWordBoundary(caret, true, CBoundarySearcher::AROUND), false, true);
		else
			selection.Select(boundary.SearchWordBoundary(
				CCharPos(caret.GetLineNumber(), caret.GetCharNumber() + 1), false, CBoundarySearcher::AROUND),
				boundary.SearchWordBoundary(caret, true, CBoundarySearcher::AROUND), false, true);
	} else
		assert(false);
	return 0;
}

/// ^uƋ󔒂̕ϊ
ulong CTabifyCommand::Execute() {
	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();
	ABORT_MODES();

	return 0;
}

/// LbgʒuɃeLXg͂BCN^̖͌ɕǉ
ulong CTextInputCommand::Execute() {
	CEditView&	view = GetTarget();

	// CN^ -> ɒǉ
	if(view.GetIncrementalSearcher().IsRunning()) {
		view.GetIncrementalSearcher().AddString(m_param);
		return 0;
	}

	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();
	return view.InsertText(m_param, false) ? 1 : 0;
}

/// LbgO̕APAsAւ
ulong CTranspositionCommand::Execute() {
	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();
	END_ISEARCH();
	CLOSE_COMPLETION_WINDOW();

	CEditView&	view = GetTarget();
	CSelection&	selection = view.GetSelection();

	view.SetNextCharacterVariation(NCV_NONE);
	view.Freeze();
	view.GetDocument().BeginEditCollection();

	CVisualPoint&	caret = selection.GetActivePoint();
	bool			bSucceeded;
	switch(m_type) {
	case CHARACTERS:	bSucceeded = caret.TransposeChars();	break;
	case WORDS:			bSucceeded = caret.TransposeWords();	break;
	case LINES:			bSucceeded = caret.TransposeLines();	break;
//	case SENTENCES:		bSucceeded = caret.TransposeSentences();break;
	}
	selection.MoveTo(selection.GetActivePoint(), true);
	if(!bSucceeded)
		view.Beep();
	view.GetDocument().EndEditCollection();
	view.Unfreeze();

	return 0;
}

/// ɖ߂/蒼
ulong CUndoCommand::Execute() {
	CHECK_DOCUMENT_READONLY();
	CHECK_GUI_EDITABILITY();

	CWaitCursor	wc;
	if(m_param)
		GetTarget().GetDocument().Undo();
	else
		GetTarget().GetDocument().Redo();
	return 0;
}

#undef ASSERT_IFISWINDOW
#undef ABORT_ISEARCH
#undef END_ISEARCH
#undef CHECK_DOCUMENT_READONLY
#undef CHECK_GUI_EDITABILITY
#undef CLOSE_COMPLETION_WINDOW

/* [EOF] */