// LineLayout.h
// (c) 2003-2005 exeal

#ifndef _LINE_LAYOUT_H_
#define _LINE_LAYOUT_H_
#include "Lexer.h"
#include <list>
#include <vector>
#include <memory>


namespace Manah {
	namespace Windows {
		namespace GDI {
			class CDC;
			class CClientDC;
		}
	}
}

namespace Ascension {

	class CEditView;

	/// \eLXg̎
	/// @see	TokenType
	enum EmphaticTextType {
		ETT_NORMAL = TT_COUNT,		///< ʏ̃eLXg
		ETT_SELECTION,				///< Ï (F̂ݗL)
		ETT_INACTIVE_SELECTION,		///< ANeBuÏ (F̂ݗL)
		ETT_INDICATOR_MARGIN,		///< CWP[^}[W
		ETT_LINENUMBER,				///< sԍ
		ETT_EMPHATIC_LINENUMBER,	///< sԍ
		ETT_MATCH_BRACKETS,			///< ʂ̈v
		ETT_END_OF_LINE,			///< s
		ETT_END_OF_FILE,			///< t@C̏I[
		ETT_LINK,					///< N (AĝݗL)
		ETT_MATCHTEXT,				///< veLXg
		ETT_RESTRICTION,			///< i[CÕANZXs\ȗ̈
		ETT_COUNT
	};

	/// gAC̎
	enum BorderType {
		BT_NONE,					///< 
		BT_UNDERLINE_SOLID,			///< ̉
		BT_UNDERLINE_BOLD,			///< ̉
		BT_UNDERLINE_DASHED,		///< j̉
		BT_UNDERLINE_BOLDDASHED,	///< j̉
		BT_UNDERLINE_DOTTED,		///< _̉
		BT_UNDERLINE_BOLDDOTTED,	///< _̉
		BT_UNDERLINE_WAVED,			///< g̉
		BT_BORDER_SOLID,			///< ̘g
		BT_BORDER_DASHED,			///< j̘g
		BT_BORDER_DOTTED,			///< _̘g
	};

	/// ܂Ԃ[h
	enum WrapMode {
		WPM_NONE,		///< ܂ԂȂ
		WPM_SPECIFIED,	///< w蕝Ő܂Ԃ
		WPM_WINDOW		///< EBhEŐ܂Ԃ
	};

	/// ̐FAȂ
	struct TTextFoundation {
		COLORREF	fgColor;		///< OiF (-1 ɂƃeLXg̎ނɉăVXe肩I)
		COLORREF	bgColor;		///< wiF (-1 ɂƃeLXg̎ނɉăVXe肩I)
		COLORREF	borderColor;	///< g̐F (-1 ɂ fgColor Ɠ)
		bool		italic;			///< Α
		bool		bold;			///< 
		BorderType	border;			///< g

		/// RXgN^
		TTextFoundation() {set(-1, -1);}
		/// 
		void set(COLORREF fgColor_ = -1, COLORREF bgColor_ = -1, COLORREF borderColor_ = -1,
				bool bItalic = false, bool bBold = false, BorderType borderType = BT_NONE) {
			fgColor = fgColor_;
			bgColor = bgColor_;
			borderColor = borderColor_;
			italic = bItalic;
			bold = bBold;
			border = borderType;
		}
	};

	/// sԍ̕\`
	struct TLineNumberLayout {
		enum BorderStyle {LNBS_NONE, LNBS_SOLID, LNBS_DASHED, LNBS_DASHED_ROUNDED, LNBS_DOTTED};
		bool		bLeftAlign;				///< 񂹂̏ꍇ trueBE񂹂̏ꍇ false
		bool		bShowLineNumbers;		///< sԍ\
		uchar		cMinimumDigits;			///< sԍ̍ŏ
		length_t	iStartLine;				///< sԍ̊Jnl
		bool		bShowIndicatorMargin;	///< CWP[^}[W\
		ushort		nIMWidth;				///< CWP[^}[W̕
		ushort		nBorderWidth;			///< ؂̑
		BorderStyle	borderStyle;			///< ؂̃X^C

		TLineNumberLayout() : bLeftAlign(false), bShowLineNumbers(false), cMinimumDigits(4), iStartLine(1),
				bShowIndicatorMargin(false), nIMWidth(15), nBorderWidth(1), borderStyle(LNBS_SOLID) {
		}
	};

	/// CAEg̐ݒ
	struct TLayoutSettings {
		length_t	cchTabWidth;	///< ^u (pP)B4
		ushort		nLineSpan;		///< s̊Ԋu
		ushort		nCharSpan;		///< ̊Ԋu
		ushort		nLeadMargin;	///< O] (LTR ̏ꍇ͍]ARTL ̏ꍇ͉E])
		ushort		nTopMargin;		///< ]
		COLORREF	caretLineColor;			///< ݍsɕ\鉺̐F
		COLORREF	inactiveCaretLineColor;	///< ANeBuɌݍsɕ\鉺̐F
		TLineNumberLayout	lineNumberLayout;	///< sԍ̕\@
		length_t	iStartChar;		///< ԍ̊Jnl (1)
		bool	bCloseBoldCharacters;	///< l߂ĕ\B̓It
		bool	bPerformBidirection;	///< ʒuvZőoeLXglB true
		bool	bRightAlign;			///< E񂹁B͍
		bool	bRightToLeftReading;	///< E獶ɓǂށB͍E
		WrapMode	wrapMode;		///< ݂̐܂Ԃ[h (WrapMode `Q)
		length_t	cchWrapWidth;	///< w蕝Ő܂ԂƂ1s̕\ (ϕ*)
		struct {
			char_t		chHorizontalTab;		///< ^u (U+0009)B '^'
			char_t		chGeneralWhiteSpace;	///< ʓIȋ󔒗ޕ (U+1680: Ogham Space Mark ȊO)B '_'
			char_t		chIdeographicSpace;		///< Sp (U+3000)B '\x25A1'
			char_t		chUnixEol;				///< LF s (U+000A)B U+FFFFBU+FFFF Ƒgݍ݂̉Ot
			char_t		chMacintoshEol;			///< CR s (U+000D)B U+FFFFBU+FFFF Ƒgݍ݂̍Ot
			char_t		chWindowsEol;			///< CRLF s (<U+000D U+000A>)B U+FFFFBU+FFFF Ƒgݍ݂̉pOt
			char_t		chEbcdicEol;			///< NEL s (U+0085)B '\x23CE'
			char_t		chLineSeparator;		///< LS s (U+2028)B '\x21A9'
			char_t		chParagraphSeparator;	///< PS s (U+2029)B '\x21E9'
			string_t	strEndOfFile;			///< t@CI[B "[EOF]"
		} substitutionGlyphs;	///< ꕶ̑֕\ɎgOt

		/// RXgN^
		TLayoutSettings() : cchTabWidth(4), nLineSpan(0), nCharSpan(0),
				nLeadMargin(5), nTopMargin(1), caretLineColor(-1), inactiveCaretLineColor(-1), iStartChar(1),
				bCloseBoldCharacters(false), bPerformBidirection(true), bRightAlign(false), bRightToLeftReading(false),
				wrapMode(WPM_NONE), cchWrapWidth(80) {
			substitutionGlyphs.chHorizontalTab = L'^';
			substitutionGlyphs.chGeneralWhiteSpace = L'_';
			substitutionGlyphs.chIdeographicSpace = L'\x25A1';
			substitutionGlyphs.chUnixEol =
			substitutionGlyphs.chMacintoshEol = 
			substitutionGlyphs.chWindowsEol = 0xFFFF;
			substitutionGlyphs.chEbcdicEol = L'\x23CE';
			substitutionGlyphs.chLineSeparator = L'\x21A9';
			substitutionGlyphs.chParagraphSeparator = L'\x21E9';
			substitutionGlyphs.strEndOfFile = L"[EOF]";
		}
	};


	/// ubN}[N̊Ǘ
	class CBookmarker {
	public:
		/// fXgN^
		virtual ~CBookmarker() {}
		/// ubN}[NSč폜
		virtual void ClearAllBookmarks() = 0;
		/**
		 *	ws̎̃ubN}[Ns̍sԍԂ
		 *	@param iLine	̍s̎ȍ~̃ubN}[NsԂB񋓊Jnɂ -1 w肷
		 *	@return			̃ubN}[NsB<var>iLine</var> Ō̃ubN}[Nsł -1 Ԃ
		 *	@throw std::invalid_argument	<var>iLine</var> ubN}[NsłȂ΃X[
		 *	@throw std::out_of_range		<var>iLine</var> hLg͈̔͂OĂ΃X[
		 */
		virtual length_t GetNextBookmark(length_t iLine) const throw(std::invalid_argument, std::out_of_range) = 0;
		/// wsubN}[NĂ邩Ԃ
		virtual bool IsBookmarked(length_t iLine) const throw(std::out_of_range) = 0;
		/// wsɃubN}[Nݒ肷
		virtual void SetBookmark(length_t iLine, bool bMark = true) throw(std::out_of_range) = 0;
		/// ws̃ubN}[ÑgO
		virtual void ToggleBookmark(length_t iLine) throw(std::out_of_range) = 0;
	};


	/**
	 *	@brief	es̃CAEgۑ
	 *
	 *	CLineLayoutManager::GetLine() 擾łA_s̃CAEgێB
	 *	O̍sƂ̊Ԃ̕sRǧpAg[ÑXgAẽLbgʒuA
	 *	ubN}[NsA܂Ԃɕ`悷̂ɕKvȕȂǂƂĎB
	 *
	 *	eȏ CLineLayoutManager NXsB
	 *	s͂̏󋵂 ParseStage 񋓂Ɏ4iKB
	 *	̒iKɕĂ̂͌̂߂łB CEditView
	 *	ANZXƂɂ͈ʒu܂ŊSɉ͍ς݂ł邱Ƃۏ؂B
	 *	NCAg̉͒iKlKv̂ CLineLayoutManager::NotifyAll
	 *	\bhĂяoƂłBႦ΃r[̃tHgωƂA
	 *	SẲ͂蒼Kv͖B̏ꍇACLineLayout::PARSE_STAGE_FULL
	 *	w肵ă\bhĂяoΈʒu񂾂𖳌ɂ邱Ƃł
	 */
	class CLineLayout : public Manah::CSelfAssertable, public Manah::CUseMemoryPool<CLineLayout> {
		// J^
	public:
		/// ͒iK
		enum ParseStage {
			PARSE_STAGE_UNPARSED				= 0,	///< S͂ĂȂ
			PARSE_STAGE_MULTILINE_ANNOTATIONS	= 1,	///< O̍sւ̕sߌp܂ŉ͍ς
			PARSE_STAGE_TOKENS					= 2,	///< g[N܂ŉ͍ς
			PARSE_STAGE_FULL					= 3		///< ʒuƌꏇ܂ (܂Ԃ܂ <- ) ͍ς
		};

		/// 
		class CRun : public Manah::CUseMemoryPool<CRun> {
		public:
			enum {LINE_WIDTH = 0xFFFFFFFF};
			/// RXgN^
			CRun(length_t index, bool bRtl) : m_i(index), m_nWidth(0x7FFFFFFF), m_bRtl(bRtl) {}
			/// 擪ʒuԂ
			length_t GetIndex() const {return m_i;}
			/// `敝Ԃ (LINE_WIDTH Ԃꂽꍇ͍sŜ̒ɓ)
			int GetWidth() const {return (m_nWidth != 0x7FFFFFFF) ? m_nWidth : LINE_WIDTH;}
			/// E獶̏ꍇ true AȄꍇ true Ԃ
			bool IsRightToLeft() const {return m_bRtl;}
		private:
			length_t	m_i;
			ulong		m_nWidth : 31;
			bool		m_bRtl : 1;
			friend class CLineLayoutManager;
		};

		/// ̔z
		class CRuns {
		public:
			/// RXgN^
			CRuns(std::size_t count, CRun*const* array) : m_count(count), m_array(array) {assert(count != 0 && array != 0);}
			/// fXgN^
			~CRuns() {for(std::size_t i = 0; i < m_count; ++i) delete m_array[i]; delete[] m_array;}
			/// wʒũԂ
			const CRun& GetAt(std::size_t i) const {assert(i < m_count); return *(m_array[i]);}
			/// ̑Ԃ
			std::size_t GetCount() const {return m_count;}
		private:
			std::size_t	m_count;
			CRun*const*	m_array;
			friend class CLineLayoutManager;
		};

		/// ܂Ԃʒu̔z
		struct WrapOffsets {
			std::size_t	count;	///< 
			length_t*	array;	///< z
			WrapOffsets() : count(0), array(0) {}
			~WrapOffsets() {delete[] array;}
		};


		// RXgN^
	private:
		/// RXgN^
		CLineLayout::CLineLayout() : m_pNext(0), m_pPrev(0), m_parseStage(PARSE_STAGE_UNPARSED), m_pTokens(0), 
				m_multilineAnnotationFromPrev(NullCookie), m_multilineAnnotationToNext(NullCookie),
				m_caretPositions(0), m_pRuns(0), m_pWrapOffsets(0), m_nWidth(0),
				m_bBookmarked(false), m_nParam(0) {
		}
		/// fXgN^
		CLineLayout::~CLineLayout() {
			_DeleteTokenList();
			delete[] m_caretPositions;
			delete m_pRuns;
			delete m_pWrapOffsets;
		}

		// \bh
	public:
		void				BackParseStage(ParseStage stage);
		int					GetCaretPosition(length_t iChar) const;
		TokenCookie			GetMultilineAnnotationStatus(bool bToNextLine) const;
		const CRuns&		GetRuns() const;
		const Tokens&		GetTokens() const;
		ulong				GetUserDefinedValue() const;
		int					GetWidth() const;
		const WrapOffsets*	GetWrapPoints() const;
		bool				IsBookmarked() const;
		void				SetBookmark(bool bMark = true);
		void				SetUserDefinedValue(ulong nValue);
	private:
		void	_DeleteTokenList();

		// f[^o
	private:
		CLineLayout*	m_pNext;	// O̍s
		CLineLayout*	m_pPrev;	// ̍s
		ParseStage		m_parseStage;	// s̉͒iK
		const Tokens*	m_pTokens;		// g[ÑXg
		TokenCookie	m_multilineAnnotationFromPrev;	// O̕s߂IĂȂ΂̎
		TokenCookie	m_multilineAnnotationToNext;	// s߂̍sɑĂ΂̎
		const int*		m_caretPositions;	// e̍[̈ʒu
		const CRuns*	m_pRuns;			// ̃Xg (1łꂪ LTR ̏ꍇ null)
		WrapOffsets*	m_pWrapOffsets;		// ܂Ԃʒu (܂ԂȂꍇ null)
		int				m_nWidth;			// ܂Ԃɕ`悷̂ɕKvȕ̕ (܂ԂȂꍇ̂ݗL)
		bool	m_bBookmarked;	// ubN}[Ns
		ulong	m_nParam;		// AvP[V`̒l

		static const Tokens			m_nullTokenList;
		static const Tokens			m_simpleTokenList;
		static std::auto_ptr<CRuns>	m_pSimpleRuns;

		friend class CLineLayoutManager;
	};


	/// CLineLayoutManager ̃NCAgC^[tFCX
	class CLayoutSettings : public Manah::CSelfAssertable {
	public:
		/**
		 *	@brief	͂L/ɂ
		 *
		 *	͂𖳌ɂ邱ƂŊes̃g[NɊւ񂪍A
		 *	͂ɂ鎞ԂƏ啝ɉPł
		 *	@see	CLineLayoutManaher::IsLexicalParsingEnabled
		 */
		virtual void EnableLexicalParsing(bool bEnable) = 0;
		/// g[N̗L/
		virtual void EnableToken(int type, bool bEnable = true) throw(std::invalid_argument) = 0;
		/// CAEg̍XV𓀌
		virtual void Freeze() = 0;
		/// ݎgpĂtHg (C^bNłȂ) 1`悷Ƃ̕ϕԂ
		virtual uint GetAverageCharacterWidth() const = 0;
		/// CAEgݒԂ
		virtual const TLayoutSettings& GetSettings() const = 0;
		/// \̐ݒԂ
		virtual TTextFoundation GetTokenFoundation(int type, TokenCookie nCookie) const throw(std::invalid_argument) = 0;
		/// [̕Ԃ
		virtual ushort GetVerticalRulerWidth() const = 0;
		/// ͂L
		virtual bool IsLexicalParsingEnabled() const = 0;
		/// g[N̋LԂ
		virtual bool IsTokenEnabled(int type) const throw(std::invalid_argument) = 0;
		/// ݒSď
		virtual void ResetConfigurations() = 0;
		/// tHg̐ݒ
		virtual void SetFont(const LOGFONTW& font) = 0;
		/// CAEg̐ݒ
		virtual void SetSettings(const TLayoutSettings& settings) = 0;
		/// \̐ݒ
		virtual void SetTokenFoundation(int type, TokenCookie nCookie,
						const TTextFoundation& foundation) throw(std::invalid_argument) = 0;
		/// CAEgXV̓
		virtual void Unfreeze() throw(std::logic_error) = 0;
	};


	/**
	 *	@brief	sCAEg̊Ǘ
	 *
	 *	CEditView NX̃CAEgsPʂŊǗACEditView NXł
	 *	s̍폜A}AXV󂯂āACAEgXVĂB
	 *
	 *	̂߂ɂ̃NX̃\bh͕Kvȏ̑sȂB
	 *	Ⴆ΂sɕsRgJn񂪑}ꂽꍇACEditView
	 *	NX͂̍s̃CAEgXV邽߂ ModifyLine
	 *	ĂяoA̍sւ̉e͖ (C̕Kvȍs͕Ԃ)B
	 *	êsXV邩ǂf̂ CEditView NX̎dł
	 */
	class CLineLayoutManager :
			public Manah::CNoncopyable,
			virtual public CLayoutSettings,
			virtual public CBookmarker,
			virtual public CLexer::IEventListener {
	public:
		/// CAEg}l[W̃CxgXi
		interface IEventListener {
			/// fXgN^
			virtual ~IEventListener() {}
			/// ubN}[N̐ݒ/sꂽ
			virtual void OnChangedBookmark(length_t iLine) = 0;
			/// CAEgύXꂽ
			virtual void OnChangedLayout() = 0;
			/// ő啝s̍sɕύXꂽ
			virtual void OnChangedMaximumWidthLine() = 0;
			/// eLXg̑ʒuύXꂽ
			virtual void OnChangedTextAlignment() = 0;
			/// eLXg̕ύXꂽ
			virtual void OnChangedTextDirection() = 0;
			/// [̕ύXꂽ
			virtual void OnChangedVerticalRulerWidth() = 0;
			/// ubN}[NSč폜ꂽ
			virtual void OnClearedAllBookmarks() = 0;
			/// foCXReLXgKvƂȂ (̃\bh1̃CxgXiɑ΂Ă̂݌Ăяo)
			virtual Manah::Windows::GDI::CClientDC OnQueryDeviceContext() = 0;
		};

		/// R[h|Cg̑փOt񋟂
		class CBidirectionalFormatterSubstitutionDriver {
		private:
			CBidirectionalFormatterSubstitutionDriver();
			~CBidirectionalFormatterSubstitutionDriver();
		public:
			HFONT GetFont() const;
			ushort GetGlyphIndex(HDC hDC, char_t ch) const;
		private:
			void	_Update(int nNewHeight, bool bBold, bool bItalic);
		private:
			enum _Code {
				LRM, RLM, LRE, RLE, PDF, LRO, RLO,
				ISS, ASS, IAFS, AAFS, NADS, NODS, CODE_COUNT
			};
			HFONT	m_hFont;
			ushort	m_glyphCache[CODE_COUNT];
			HMODULE	m_hGdi32Dll;
			DWORD(WINAPI * m_pfnGetGlyphIndicesW)(HDC, const WCHAR*, int, LPWORD, DWORD);
			friend class CLineLayoutManager;
		};

		// RXgN^
	public:
		CLineLayoutManager(CEditDoc& document);
		virtual ~CLineLayoutManager();

		// \bh (BCLayoutSettings C^[tFCX܂)
	public:
		void					AddEventListener(IEventListener& eventListener);
		void					EnableLexicalParsing(bool bEnable);
		void					EnableToken(int type, bool bEnable = true) throw(std::invalid_argument);
		void					Freeze();
		uint					GetAverageCharacterWidth() const;
		const CBidirectionalFormatterSubstitutionDriver&
								GetFontForBidirectionalFormatterSubstitution() const;
		HFONT					GetFontForRenderingToken(int type, TokenCookie nCookie) const;
		CLexer&					GetLexer() const;
		CLineLayout&			GetLine(length_t iLine) const throw(std::out_of_range);
		ushort					GetLineHeight() const;
		CLineLayout::ParseStage	GetLineParseStage(length_t iLine) const throw(std::out_of_range);
		int						GetMaxDisplayWidth() const;
		ulong					GetNextTabStop(ulong x, bool bRight) const;
		HFONT					GetRegularFont() const;
		const TLayoutSettings&	GetSettings() const {return m_settings;}
		TTextFoundation			GetTokenFoundation(int type, TokenCookie nCookie) const throw(std::invalid_argument);
		ushort					GetVerticalRulerWidth() const;
		bool					IsLexicalParsingEnabled() const;
		bool					IsTokenEnabled(int type) const throw(std::invalid_argument);
		static bool				IsRtlSupported();
		void					RemoveEventListener(IEventListener& eventListener);
		void					SetFont(const LOGFONTW& font);
		void					SetSettings(const TLayoutSettings& settings);
		void					SetTokenFoundation(int type, TokenCookie nCookie,
									const TTextFoundation& foundation) throw(std::invalid_argument);
		void					Unfreeze() throw(std::logic_error);
		// \bh ()
	public:
		void		DeleteAllLines();
		void		DeleteLine(length_t iLine) throw(std::out_of_range);
		void		DeleteLines(length_t iStart, length_t iEnd) throw(std::out_of_range);
		void		InsertLine(length_t iLine) throw(std::out_of_range);
		void		InsertLines(length_t iStart, length_t iEnd) throw(std::out_of_range);
		void		Invalidate(CLineLayout::ParseStage stage);
		length_t	ModifyLine(length_t iLine) throw(std::out_of_range);
		void		ParseLine(length_t iLine) throw(std::out_of_range);
		void		ReconstructAll();
		void		ResetConfigurations();

	protected:
	//	static BidiClass	GetBidiClass(ulong cp);
		CLineLayout*		GetLineInternal(length_t iLine) const;
		void				ParseCharacterPositions(length_t iLine, CLineLayout& layout);
		void				ParseMultilineCommentContinue(length_t iLine, CLineLayout& layout);
		void				ParseTokens(length_t iLine, CLineLayout& layout);
		void				UpdateMaxDisplayWidth();

		// CLexer::IEventListener \bh
	public:
		void	OnLexerAddedIdentifiedToken(TokenType type, TokenCookie nCookie);
		void	OnLexerChanged();
		void	OnLexerCleared();
		void	OnLexerRemovedIdentifiedToken(TokenType type, TokenCookie nCookie);

		// CBookmarker \bh
	public:
		void		ClearAllBookmarks();
		length_t	GetNextBookmark(length_t iLine) const;
		bool		IsBookmarked(length_t iLine) const;
		void		SetBookmark(length_t iLine, bool bMark = true);
		void		ToggleBookmark(length_t iLine);

	private:
		uint	_GetLineNumberMaxDigit() const;
		void	_RecalculateVerticalRulerWidth();

		// f[^o
	private:
/*		///	oeLXg
		enum _BidiClass {
			BC_L, BC_LRE, BC_LRO, BC_R, BC_AL, BC_RLE, BC_RLO,
			BC_PDF, BC_EN, BC_ES, BC_ET, BC_AN, BC_CS, BC_NSM,
			BC_BN, BC_B, BC_S, BC_WS, BC_ON,
		};*/

		static class _CBidirectionalLayoutCalculator {
		public:
			_CBidirectionalLayoutCalculator() : m_pfnSetLayout(0) {
				if(m_hGdi32Dll = ::LoadLibraryA("GDI32.DLL"))
					m_pfnSetLayout = reinterpret_cast<DWORD(WINAPI*)(HDC, DWORD)>(::GetProcAddress(m_hGdi32Dll, "SetLayout"));
			}
			~_CBidirectionalLayoutCalculator() {
				if(m_hGdi32Dll != 0)
					::FreeLibrary(m_hGdi32Dll);
			}
			CLineLayout::CRuns* Calculate(Manah::Windows::GDI::CDC& dc,
				const char_t* pwsz, length_t cch, bool bRightToLeftReading, ulong*& runOrders);
			bool IsRtlSupported() const {return m_pfnSetLayout != 0;}
		private:
			HMODULE	m_hGdi32Dll;
			DWORD(WINAPI *m_pfnSetLayout)(HDC, DWORD);
#ifndef LAYOUT_RTL
			enum {LAYOUT_RTL = 1};
#endif /* !LAYOUT_RTL */
			struct _OrderComparer {
				bool operator()(const std::pair<uint, ulong>& lhs, const std::pair<uint, ulong>& rhs) {return lhs.first < rhs.first;}
			};
		} m_bidiCalculator;

		CEditDoc&		m_document;				// hLg
		CLexer*			m_pLexer;				// ͊
		TLayoutSettings	m_settings;				// X̐ݒ
		bool			m_bLexingEnabled;		// ͂ƕs߂L
		ulong			m_nFreezeCount;			// JEg
		CLineLayout*	m_pHead;				// 擪
		int				m_nMaxDisplayWidth;		// ő\
		CLineLayout*	m_pMaxDisplayWidthLine;	// ő\s
		std::set<CLineLayoutManager::IEventListener*>	m_eventListeners;		// CxgXi

		HFONT	m_hRegularFont;		// ̖WtHgBvZɂgp
		HFONT	m_hBoldFont;		// `ɎgptHg
		HFONT	m_hItalicFont;		// C^bN̕`ɎgptHg
		HFONT	m_hBoldItalicFont;	// C^bN̕`ɎgptHg

		ushort	m_nLineHeight;			// s̍ (̍͂ꂩ m_settings.nLineSpan l)
		ushort	m_nCharWidth;			// p () 
		ushort	m_nVerticalRulerWidth;	// [̕

		typedef std::map<TokenCookie, TTextFoundation>	_CookedTokenMap;
		struct {
			bool	bEnabled;	// L
			union {
				_CookedTokenMap*	pCookedFoundations;	// L[[hARg͂gB
														// NbL[lŊeg[NɃANZX
				TTextFoundation*	pFoundation;		// ȊȌꍇ͒AC
			} body;
		} m_tokenFoundations[ETT_COUNT];	// g[N\̐ݒ

		mutable length_t		m_iLineCache;	// ŌɃANZXsԍƗvf
		mutable CLineLayout*	m_pLineCache;	// s̒ǉƍ폜s\bhgpƖɂȂ

		CBidirectionalFormatterSubstitutionDriver	m_bidiFmtSubst;
	};


	/**
	 *	w肵ʒũ̕LbgʒuԂ (̃\bh͋E`FbNȂ)
	 *	@param iChar	ʒu
	 *	@return			Lbgʒu
	 */
	inline int CLineLayout::GetCaretPosition(length_t iChar) const {
		AssertValid();
		assert(m_caretPositions != 0);
		return m_caretPositions[iChar];
	}

	/**
	 *	s߂̌pԂԂ
	 *	@param bToNextLine	̂ւ̌p󋵂擾ꍇ trueB
	 *						O̍šp󋵂擾ꍇ false
	 *	@return				p
	 */
	inline TokenCookie CLineLayout::GetMultilineAnnotationStatus(bool bToNextLine) const {
		return bToNextLine ? m_multilineAnnotationToNext : m_multilineAnnotationFromPrev;
	}

	/// g[ÑXgԂ
	inline const Tokens& CLineLayout::GetTokens() const {
		return *m_pTokens;
	}

	/// sɐݒ肳ꂽ[U`lԂ
	inline ulong CLineLayout::GetUserDefinedValue() const {
		return m_nParam;
	}

	/// ܂ԂȂꍇ̍s̒Ԃ
	inline int CLineLayout::GetWidth() const {
		return m_nWidth;
	}

	/// ܂Ԃʒu̔zԂB܂ԂȂꍇ null Ԃ
	inline const CLineLayout::WrapOffsets* CLineLayout::GetWrapPoints() const {
		return m_pWrapOffsets;
	}

	/// ubN}[NsԂ
	inline bool	CLineLayout::IsBookmarked() const {
		return m_bBookmarked;
	}

	/// ubN}[N̐ݒ
	inline void CLineLayout::SetBookmark(bool bMark /* = true */) {
		m_bBookmarked = bMark;
	}

	/// [U`l̐ݒ
	inline void CLineLayout::SetUserDefinedValue(ulong nValue) {
		m_nParam = nValue;
	}

	/// @see	CLayoutSettings::EnabledToken
	inline void CLineLayoutManager::EnableToken(int type, bool bEnable /* = true */) throw(std::invalid_argument) {
		if(type < TT_FIRST || type >= ETT_COUNT)
			throw std::invalid_argument("Invalid token type.");
		else if(bEnable == m_tokenFoundations[type].bEnabled)
			return;
		m_tokenFoundations[type].bEnabled = bEnable;
		OnLexerChanged();
	}

	/// JEg1₷
	inline void CLineLayoutManager::Freeze() {
		AssertValid();
		++m_nFreezeCount;
	}

	/// ݎgpĂtHg (C^bNłȂ) 1`悷Ƃ̕ϕԂ
	inline uint CLineLayoutManager::GetAverageCharacterWidth() const {
		AssertValid();
		return m_nCharWidth + m_settings.nCharSpan;
	}

	/// R[h̑փOto͂hCoԂ
	inline const CLineLayoutManager::CBidirectionalFormatterSubstitutionDriver&
	CLineLayoutManager::GetFontForBidirectionalFormatterSubstitution() const {
		return m_bidiFmtSubst;
	}

	/**
	 *	w肵g[N`tHgԂ
	 *	@param type		g[N̎
	 *	@param nCookie	g[ÑNbL[l
	 *	@return			tHg
	 */
	inline HFONT CLineLayoutManager::GetFontForRenderingToken(int type, TokenCookie nCookie) const {
		AssertValid();
		const TTextFoundation&	tf = GetTokenFoundation(type, nCookie);
		if(IsTokenEnabled(type) && tf.bold)
			return tf.italic ? m_hBoldItalicFont : m_hBoldFont;
		else
			return (IsTokenEnabled(type) && tf.italic) ? m_hItalicFont : m_hRegularFont;
	}

	/// ͊Ԃ
	inline CLexer& CLineLayoutManager::GetLexer() const {
		AssertValid();
		return *m_pLexer;
	}

	/**
	 *	w肵s̃CAEgԂ
	 *	@param iLine				s
	 *	@return						CAEg
	 *	@throw std::out_of_range	<var>iLine</var> Ȃ΃X[
	 */
	inline CLineLayout& CLineLayoutManager::GetLine(length_t iLine) const throw(std::out_of_range) {
		AssertValid();
		if(CLineLayout* pLine = GetLineInternal(iLine)) {
			if(pLine->m_parseStage != CLineLayout::PARSE_STAGE_FULL)	// łĂȂ
				const_cast<CLineLayoutManager*>(this)->ParseCharacterPositions(iLine, *pLine);
			assert(pLine->m_parseStage == CLineLayout::PARSE_STAGE_FULL);
			return *pLine;
		} else
			throw std::out_of_range("Specified line number is out of range.");
	}

	/// 1s̍Ԃ
	inline ushort CLineLayoutManager::GetLineHeight() const {
		AssertValid();
		return m_nLineHeight;
	}

	/**
	 *	̃^uʒuԂ
	 *	@param x		s̍[̈ʒu
	 *	@param bRight	Ẽ^uʒuvZꍇ trueB̃^uʒȕꍇ false
	 *	@return			^uʒu
	 */
	inline ulong CLineLayoutManager::GetNextTabStop(ulong x, bool bRight) const {
		if(bRight)
			return x + m_settings.cchTabWidth * GetAverageCharacterWidth()
				- x % (m_settings.cchTabWidth * GetAverageCharacterWidth());
		else
			return x - x % (m_settings.cchTabWidth * GetAverageCharacterWidth());
	}

	/// ʏ̃eLXg̕`ɎgtHgԂ
	inline HFONT CLineLayoutManager::GetRegularFont() const {
		AssertValid();
		return GetFontForRenderingToken(ETT_NORMAL, NullCookie);
	}

	/// [̕Ԃ
	inline ushort CLineLayoutManager::GetVerticalRulerWidth() const {
		AssertValid();
		return m_nVerticalRulerWidth;
	}

	/// @see	CLayoutSettings::IsLexicalParsingEnabled
	inline bool CLineLayoutManager::IsLexicalParsingEnabled() const {
		AssertValid();
		return m_bLexingEnabled;
	}

	/// RTL CAEgT|[gĂ邩Ԃ
	inline bool CLineLayoutManager::IsRtlSupported() {
		return m_bidiCalculator.IsRtlSupported();
	}

	/// @see	CLayoutSettings::IsTokenEnabled
	inline bool CLineLayoutManager::IsTokenEnabled(int type) const {
		AssertValid();
		if(type < TT_FIRST || type >= ETT_COUNT)
			throw std::invalid_argument("Invalid token type.");
		return m_tokenFoundations[type].bEnabled;
	}

	/// tHgnhԂ
	inline HFONT CLineLayoutManager::CBidirectionalFormatterSubstitutionDriver::GetFont() const {
		return m_hFont;
	}

	/**
	 *	̃OtԍԂ
	 *	@param hDC	foCXReLXg
	 *	@param ch	
	 *	@return		OtԍBꍇ 0xFFFF
	 */
	inline ushort CLineLayoutManager::CBidirectionalFormatterSubstitutionDriver::GetGlyphIndex(HDC hDC, char_t ch) const {
		static const char_t	codeMap[] = {
			0x200E, 0x200F, 0x202A, 0x202B, 0x202C, 0x202D, 0x202E,
			0x206A, 0x206B, 0x206C, 0x206D, 0x206E, 0x206F
		};
#ifndef GGI_MARK_NONEXISTING_GLYPHS
		static const DWORD	GGI_MARK_NONEXISTING_GLYPHS = 0x0001;
#endif /* !GGI_MARK_NONEXISTING_GLYPHS */

		assert(m_hFont != 0);
		const char_t* const	pch = std::lower_bound(codeMap, _endof(codeMap), ch);
		if(*pch != ch)
			return 0xFFFF;
		const _Code	code = static_cast<_Code>(pch - codeMap);
		if(m_glyphCache[code] == 0xFFFF) {
			HFONT	hOldFont = static_cast<HFONT>(::SelectObject(hDC, m_hFont));
			if(m_pfnGetGlyphIndicesW != 0)
				(*m_pfnGetGlyphIndicesW)(hDC, &ch, 1, &const_cast<ushort*>(m_glyphCache)[code], GGI_MARK_NONEXISTING_GLYPHS);
			else {
				AutoZeroLS<GCP_RESULTSW>	gcpr;
				WCHAR						glyph;
				gcpr.lpGlyphs = &glyph;
				gcpr.nGlyphs = 1;
				::GetCharacterPlacementW(hDC, &ch, 1, 0, &gcpr, GCP_DISPLAYZWG);
				const_cast<ushort*>(m_glyphCache)[code] = (glyph != 0) ? glyph : 0xFFFF;
			}
			::SelectObject(hDC, hOldFont);
		}
		return m_glyphCache[code];
	}

} // namespace Ascension


#endif /* _LINE_LAYOUT_H_ */

/* [EOF] */