// Vietnamese.cpp
// (c) 2004-2005 exeal

#include "StdAfx.h"
#include "Encoder.h"

using namespace Ascension::Encodings;
using namespace std;


BEGIN_ENCODER_DEFINITION()
	DEFINE_ENCODER_CLASS(CPEX_VIETNAMESE_TCVN, Vietnamese_Tcvn, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_VIETNAMESE_VISCII, Vietnamese_Viscii, 1, 1)
	DEFINE_ENCODER_CLASS(CPEX_VIETNAMESE_VPS, Vietnamese_Vps, 1, 1)
END_ENCODER_DEFINITION()


// ȉ̕ϊe[u Mozilla  Vietnamese Enabling Project ̎QƂ
// (http://www.vnet.org/vanlangsj/mozilla/)
namespace {
	const wchar_t	TCVNtoUCS_00[] = {
	/* 0x00 */	0x0000, 0x00DA, 0x1EE4, 0x0003, 0x1EEA, 0x1EEC, 0x1EEE, 0x0007,
				0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	/* 0x10 */	0x0010, 0x1EE8, 0x1EF0, 0x1EF2, 0x1EF6, 0x1EF8, 0x00DD, 0x1EF4,
				0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F
	};
	const wchar_t	TCVNtoUCS_80[] = {
	/* 0x80 */	0x00C0, 0x1EA2, 0x00C3, 0x00C1, 0x1EA0, 0x1EB6, 0x1EAC, 0x00C8,
				0x1EBA, 0x1EBC, 0x00C9, 0x1EB8, 0x1EC6, 0x00CC, 0x1EC8, 0x0128,
	/* 0x90 */	0x00CD, 0x1ECA, 0x00D2, 0x1ECE, 0x00D5, 0x00D3, 0x1ECC, 0x1ED8,
				0x1EDC, 0x1EDE, 0x1EE0, 0x1EDA, 0x1EE2, 0x00D9, 0x1EE6, 0x0168,
	/* 0xA0 */	0x00A0, 0x0102, 0x00C2, 0x00CA, 0x00D4, 0x01A0, 0x01AF, 0x0110,
				0x0103, 0x00E2, 0x00EA, 0x00F4, 0x01A1, 0x01B0, 0x0111, 0x1EB0,
	/* 0xB0 */	0x0300, 0x0309, 0x0303, 0x0301, 0x0323, 0x00E0, 0x1EA3, 0x00E3,
				0x00E1, 0x1EA1, 0x1EB2, 0x1EB1, 0x1EB3, 0x1EB5, 0x1EAF, 0x1EB4,
	/* 0xC0 */	0x1EAE, 0x1EA6, 0x1EA8, 0x1EAA, 0x1EA4, 0x1EC0, 0x1EB7, 0x1EA7,
				0x1EA9, 0x1EAB, 0x1EA5, 0x1EAD, 0x00E8, 0x1EC2, 0x1EBB, 0x1EBD,
	/* 0xD0 */	0x00E9, 0x1EB9, 0x1EC1, 0x1EC3, 0x1EC5, 0x1EBF, 0x1EC7, 0x00EC,
				0x1EC9, 0x1EC4, 0x1EBE, 0x1ED2, 0x0129, 0x00ED, 0x1ECB, 0x00F2,
	/* 0xE0 */	0x1ED4, 0x1ECF, 0x00F5, 0x00F3, 0x1ECD, 0x1ED3, 0x1ED5, 0x1ED7,
				0x1ED1, 0x1ED9, 0x1EDD, 0x1EDF, 0x1EE1, 0x1EDB, 0x1EE3, 0x00F9,
	/* 0xF0 */	0x1ED6, 0x1EE7, 0x0169, 0x00FA, 0x1EE5, 0x1EEB, 0x1EED, 0x1EEF,
				0x1EE9, 0x1EF1, 0x1EF3, 0x1EF7, 0x1EF9, 0x00FD, 0x1EF5, 0x1ED0
	};
	const uchar		UCStoTCVN_0000[] = {
	/* U+0000 */	__NA, __NA, __NA, 0x03, __NA, __NA, __NA, 0x07,
					0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	/* U+0010 */	0x10, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
					0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F
	};
	const uchar		UCStoTCVN_00C0[] = {
	/* U+00C0 */	0x80, 0x83, 0xA2, 0x82, __NA, __NA, __NA, __NA,
					0x87, 0x8A, 0xA3, __NA, 0x8D, 0x90, __NA, __NA,
	/* U+00D0 */	__NA, __NA, 0x92, 0x95, 0xA4, 0x94, __NA, __NA,
					__NA, 0x9D, 0x01, __NA, __NA, 0x16, __NA, __NA,
	/* U+00E0 */	0xB5, 0xB8, 0xA9, 0xB7, __NA, __NA, __NA, __NA,
					0xCC, 0xD0, 0xAA, __NA, 0xD7, 0xDD, __NA, __NA,
	/* U+00F0 */	__NA, __NA, 0xDF, 0xE3, 0xAB, 0xE2, __NA, __NA,
					__NA, 0xEF, 0xF3, __NA, __NA, 0xFD, __NA, __NA,
	/* U+0100 */	__NA, __NA, 0xA1, 0xA8, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+0110 */	0xA7, 0xAE, __NA, __NA, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+0120 */	__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
					0x8F, 0xDC
	};
	const uchar		UCStoTCVN_0168[] = {
	/* U+0168 */	0x9F, 0xF2
	};
	const uchar		UCStoTCVN_01A0[] = {
	/* U+01A0 */	0xA5, 0xAC, __NA, __NA, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xA6,
	/* U+01B0 */	0xAD
	};
	const uchar		UCStoTCVN_0300[] = {
	/* U+0300 */	0xB0, 0xB3, __NA, 0xB2, __NA, __NA, __NA, __NA,
					__NA, 0xB1, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+0310 */	__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+0320 */	__NA, __NA, __NA, 0xB4
	};
	const uchar		UCStoTCVN_1EA0[] = {
	/* U+1EA0 */	0x84, 0xB9, 0x81, 0xB6, 0xC4, 0xCA, 0xC1, 0xC7,
					0xC2, 0xC8, 0xC3, 0xC9, 0x86, 0xCB, 0xC0, 0xBE,
	/* U+1EB0 */	0xAF, 0xBB, 0xBA, 0xBC, 0xBF, 0xBD, 0x85, 0xC6,
					0x8B, 0xD1, 0x88, 0xCE, 0x89, 0xCF, 0xDA, 0xD5,
	/* U+1EC0 */	0xC5, 0xD2, 0xCD, 0xD3, 0xD9, 0xD4, 0x8C, 0xD6,
					0x8E, 0xD8, 0x91, 0xDE, 0x96, 0xE4, 0x93, 0xE1,
	/* U+1ED0 */	0xFF, 0xE8, 0xDB, 0xE5, 0xE0, 0xE6, 0xF0, 0xE7,
					0x97, 0xE9, 0x9B, 0xED, 0x98, 0xEA, 0x99, 0xEB,
	/* U+1EE0 */	0x9A, 0xEC, 0x9C, 0xEE, 0x02, 0xF4, 0x9E, 0xF1,
					0x11, 0xF8, 0x04, 0xF5, 0x05, 0xF6, 0x06, 0xF7,
	/* U+1EF0 */	0x12, 0xF9, 0x13, 0xFA, 0x17, 0xFE, 0x14, 0xFB,
					0x15, 0xFC
	};
	const wchar_t	VISCIItoUCS_00[] = {
	/* 0x00 */	0x0000, 0x0001, 0x1EB2, 0x0003, 0x0004, 0x1EB4, 0x1EAA, 0x0007,
				0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	/* 0x10 */	0x0010, 0x0011, 0x0012, 0x0013, 0x1EF6, 0x0015, 0x0016, 0x0017,
				0x0018, 0x1EF8, 0x001A, 0x001B, 0x001C, 0x001D, 0x1EF4, 0x001F
	};
	const wchar_t	VISCIItoUCS_80[] = {
	/* 0x80 */	0x1EA0, 0x1EAE, 0x1EB0, 0x1EB6, 0x1EA4, 0x1EA6, 0x1EA8, 0x1EAC,
				0x1EBC, 0x1EB8, 0x1EBE, 0x1EC0, 0x1EC2, 0x1EC4, 0x1EC6, 0x1ED0,
	/* 0x90 */	0x1ED2, 0x1ED4, 0x1ED6, 0x1ED8, 0x1EE2, 0x1EDA, 0x1EDC, 0x1EDE,
				0x1ECA, 0x1ECE, 0x1ECC, 0x1EC8, 0x1EE6, 0x0168, 0x1EE4, 0x1EF2,
	/* 0xA0 */	0x00D5, 0x1EAF, 0x1EB1, 0x1EB7, 0x1EA5, 0x1EA7, 0x1EA9, 0x1EAD,
				0x1EBD, 0x1EB9, 0x1EBF, 0x1EC1, 0x1EC3, 0x1EC5, 0x1EC7, 0x1ED1,
	/* 0xB0 */	0x1ED3, 0x1ED5, 0x1ED7, 0x1EE0, 0x01A0, 0x1ED9, 0x1EDD, 0x1EDF,
				0x1ECB, 0x1EF0, 0x1EE8, 0x1EEA, 0x1EEC, 0x01A1, 0x1EDB, 0x01AF,
	/* 0xC0 */	0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x1EA2, 0x0102, 0x1EB3, 0x1EB5,
				0x00C8, 0x00C9, 0x00CA, 0x1EBA, 0x00CC, 0x00CD, 0x0128, 0x1EF3,
	/* 0xD0 */	0x0110, 0x1EE9, 0x00D2, 0x00D3, 0x00D4, 0x1EA1, 0x1EF7, 0x1EEB,
				0x1EED, 0x00D9, 0x00DA, 0x1EF9, 0x1EF5, 0x00DD, 0x1EE1, 0x01B0,
	/* 0xE0 */	0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x1EA3, 0x0103, 0x1EEF, 0x1EAB,
				0x00E8, 0x00E9, 0x00EA, 0x1EBB, 0x00EC, 0x00ED, 0x0129, 0x1EC9,
	/* 0xF0 */	0x0111, 0x1EF1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x1ECF, 0x1ECD,
				0x1EE5, 0x00F9, 0x00FA, 0x0169, 0x1EE7, 0x00FD, 0x1EE3, 0x1EEE
	};
	const uchar		UCStoVISCII_0000[] = {
	/* U+0000 */	0x00, 0x01, __NA, 0x03, 0x04, __NA, __NA, 0x07,
					0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
	/* U+0010 */	0x10, 0x11, 0x12, 0x13, __NA, 0x15, 0x16, 0x17,
					0x18, __NA, 0x1A, 0x1B, 0x1C, 0x1D, __NA, 0x1F
	};
	const uchar		UCStoVISCII_00C0[] = {
	/* U+00C0 */	0xC0, 0xC1, 0xC2, 0xC3, __NA, __NA, __NA, __NA,
					0xC8, 0xC9, 0xCA, __NA, 0xCC, 0xCD, __NA, __NA,
	/* U+00D0 */	__NA, __NA, 0xD2, 0xD3, 0xD4, 0xA0, __NA, __NA,
					__NA, 0xD9, 0xDA, __NA, __NA, 0xDD, __NA, __NA,
	/* U+00E0 */	0xE0, 0xE1, 0xE2, 0xE3, __NA, __NA, __NA, __NA,
					0xE8, 0xE9, 0xEA, __NA, 0xEC, 0xED, __NA, __NA,
	/* U+00F0 */	__NA, __NA, 0xF2, 0xF3, 0xF4, 0xF5, __NA, __NA,
					__NA, 0xF9, 0xFA, __NA, __NA, 0xFD, __NA, __NA,
	/* U+0100 */	__NA, __NA, 0xC5, 0xE5, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+0110 */	0xD0, 0xF0, __NA, __NA, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+0120 */	__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
					0xCE, 0xEE
	};
	const uchar		UCStoVISCII_0168[] = {
	/* U+0168 */	0x9D, 0xFB
	};
	const uchar		UCStoVISCII_01A0[] = {
	/* U+01A0 */	0xB4, 0xBD, __NA, __NA, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xBF,
	/* U+01B0 */	0xDF
	};
	const uchar		UCStoVISCII_1EA0[] = {
	/* U+1EA0 */	0x80, 0xD5, 0xC4, 0xE4, 0x84, 0xA4, 0x85, 0xA5,
					0x86, 0xA6, 0x06, 0xE7, 0x87, 0xA7, 0x81, 0xA1,
	/* U+1EB0 */	0x82, 0xA2, 0x02, 0xC6, 0x05, 0xC7, 0x83, 0xA3,
					0x89, 0xA9, 0xCB, 0xEB, 0x88, 0xA8, 0x8A, 0xAA,
	/* U+1EC0 */	0x8B, 0xAB, 0x8C, 0xAC, 0x8D, 0xAD, 0x8E, 0xAE,
					0x9B, 0xEF, 0x98, 0xB8, 0x9A, 0xF7, 0x99, 0xF6,
	/* U+1ED0 */	0x8F, 0xAF, 0x90, 0xB0, 0x91, 0xB1, 0x92, 0xB2,
					0x93, 0xB5, 0x95, 0xBE, 0x96, 0xB6, 0x97, 0xB7,
	/* U+1EE0 */	0xB3, 0xDE, 0x94, 0xFE, 0x9E, 0xF8, 0x9C, 0xFC,
					0xBA, 0xD1, 0xBB, 0xD7, 0xBC, 0xD8, 0xFF, 0xE6,
	/* U+1EF0 */	0xB9, 0xF1, 0x9F, 0xCF, 0x1E, 0xDC, 0x14, 0xD6,
					0x19, 0xDB
	};
	const wchar_t	VPStoUCS_00[] = {
	/* __NA */	0x0000, 0x0001, 0x1EA0, 0x1EAC, 0x1EB6, 0x1EB8, 0x1EC6, 0x0007,
				0x0008, 0x0009, 0x000A, 0x000B, 0x000C, 0x000D, 0x000E, 0x000F,
	/* 0x10 */	0x1ECA, 0x1ECC, 0x1ED8, 0x1EE2, 0x1EE4, 0x1EF0, 0x0016, 0x0017,
				0x0018, 0x1EF4, 0x001A, 0x001B, 0x1EAA, 0x1EEE, 0x001E, 0x001F,
	/* 0x20 */	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027,
				0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F,
	/* 0x30 */	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
				0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F,
	/* 0x40 */	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
				0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
	/* 0x50 */	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
				0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F,
	/* 0x60 */	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
				0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
	/* 0x70 */	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
				0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F,
	/* 0x80 */	0x00C0, 0x1EA2, 0x00C3, 0x1EA4, 0x1EA6, 0x1EA8, 0x1ECD, 0x1ED7,
				0x0102, 0x1EBF, 0x1EC1, 0x1EC3, 0x1EC7, 0x1EAE, 0x1EB0, 0x1EB2,
	/* 0x90 */	0x1EBE, 0x2018, 0x2019, 0x1EC0, 0x1EC2, 0x1EC4, 0x1ED0, 0x1ED2,
				0x1ED4, 0x1ED6, 0x00FD, 0x1EF7, 0x1EF5, 0x1EDA, 0x1EDC, 0x1EDE,
	/* 0xA0 */	0x00A0, 0x1EAF, 0x1EB1, 0x1EB3, 0x1EB5, 0x1EB7, 0x1EE0, 0x1EDB,
				0x00D9, 0x1EDD, 0x1EDF, 0x1EE1, 0x0168, 0x1EE8, 0x1EE3, 0x1EEA,
	/* 0xB0 */	0x1ED5, 0x1EEC, 0x1EF2, 0x1EF8, 0x00CD, 0x00CC, 0x1ED9, 0x1EC8,
				0x0128, 0x00D3, 0x1EED, 0x1EEF, 0x00D2, 0x1ECE, 0x00D5, 0x1EF1,
	/* 0xC0 */	0x1EA7, 0x00C1, 0x00C2, 0x1EA5, 0x1EA9, 0x1EAB, 0x1EAD, 0x0111,
				0x1EBB, 0x00C9, 0x00CA, 0x1EB9, 0x1EC9, 0x1EC5, 0x1ECB, 0x1EF9,
	/* 0xD0 */	0x01AF, 0x1EE6, 0x1ED3, 0x1ED1, 0x00D4, 0x1ECF, 0x01A1, 0x00C8,
				0x1EEB, 0x1EE9, 0x00DA, 0x0169, 0x01B0, 0x00DD, 0x1EBA, 0x00DF,
	/* 0xE0 */	0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x1EA3, 0x1EA1, 0x0103, 0x00E7,
				0x00E8, 0x00E9, 0x00EA, 0x1EBD, 0x00EC, 0x00ED, 0x00EE, 0x0129,
	/* 0xF0 */	0x1EB4, 0x0110, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x01A0,
				0x1EE5, 0x00F9, 0x00FA, 0x1EE7, 0x00FC, 0x1EF6, 0x1EBC, 0x1EF3
	};
	const uchar		UCStoVPS_0000[] = {
	/* U+0000 */	0x00, 0x01, __NA, __NA, __NA, __NA, __NA, 0x07,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+0010 */	__NA, __NA, __NA, __NA, __NA, __NA, 0x16, 0x17
	};
	const uchar		UCStoVPS_00A0[] = {
	/* U+00A0 */	0xA0, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+00B0 */	__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+00C0 */	0x80, 0xC1, 0xC2, 0x82, __NA, __NA, __NA, __NA,
					0xD7, 0xC9, 0xCA, __NA, 0xB5, 0xB4, __NA, __NA,
	/* U+00D0 */	__NA, __NA, 0xBC, 0xB9, 0xD4, 0xBE, __NA, __NA,
					__NA, 0xA8, 0xDA, __NA, __NA, 0xDD, __NA, 0xDF,
	/* U+00E0 */	0xE0, 0xE1, 0xE2, 0xE3, __NA, __NA, __NA, 0xE7,
					0xE8, 0xE9, 0xEA, __NA, 0xEC, 0xED, 0xEE, __NA,
	/* U+00F0 */	__NA, __NA, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, __NA,
					__NA, 0xF9, 0xFA, __NA, 0xFC, 0x9A, __NA, __NA,
	/* U+0100 */	__NA, __NA, 0x88, 0xE6, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+0110 */	0xF1, 0xC7, __NA, __NA, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
	/* U+0120 */	__NA, __NA, __NA, __NA, __NA, __NA, __NA, __NA,
					0xB8, 0xEF
	};
	const uchar		UCStoVPS_0168[] = {
					0xAC, 0xDB
	};
	const uchar		UCStoVPS_01A0[] = {
	/* U+01A0 */	0xF7, 0xD6, __NA, __NA, __NA, __NA, __NA, __NA,
					__NA, __NA, __NA, __NA, __NA, __NA, __NA, 0xD0,
	/* U+01B0 */	0xDC
	};
	const uchar		UCStoVPS_1EA0[] = {
	/* U+1EA0 */	0x02, 0xE5, 0x81, 0xE4, 0x83, 0xC3, 0x84, 0xC0,
					0x85, 0xC4, 0x1C, 0xC5, 0x03, 0xC6, 0x8D, 0xA1,
	/* U+1EB0 */	0x8E, 0xA2, 0x8F, 0xA3, 0xF0, 0xA4, 0x04, 0xA5,
					0x05, 0xCB, 0xDE, 0xC8, 0xFE, 0xEB, 0x90, 0x89,
	/* U+1EC0 */	0x93, 0x8A, 0x94, 0x8B, 0x95, 0xCD, 0x06, 0x8C,
					0xB7, 0xCC, 0x10, 0xCE, 0x11, 0x86, 0xBD, 0xD5,
	/* U+1ED0 */	0x96, 0xD3, 0x97, 0xD2, 0x98, 0xB0, 0x99, 0x87,
					0x12, 0xB6, 0x9D, 0xA7, 0x9E, 0xA9, 0x9F, 0xAA,
	/* U+1EE0 */	0xA6, 0xAB, 0x13, 0xAE, 0x14, 0xF8, 0xD1, 0xFB,
					0xAD, 0xD9, 0xAF, 0xD8, 0xB1, 0xBA, 0x1D, 0xBB,
	/* U+1EF0 */	0x15, 0xBF, 0xB2, 0xFF, 0x19, 0x9C, 0xFD, 0x9B,
					0xB3, 0xCF
	};
	const uchar		UCStoVPS_2018[] = {
					0x91, 0x92
	};
} // namespace `anonymous'


// xgi (TCVN) ////////////////////////////////////////////////////////

size_t CEncoder_Vietnamese_Tcvn::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i) {
		if(pwszSrc[i] < _countof(UCStoTCVN_0000))
			pszDest[i] = UCStoTCVN_0000[pwszSrc[i]];
		else if(pwszSrc[i] < 0x0080)
			pszDest[i] = static_cast<uchar>(pwszSrc[i]);
		else if(pwszSrc[i] >= 0x00C0 && pwszSrc[i] < 0x00C0 + _countof(UCStoTCVN_00C0))
			pszDest[i] = UCStoTCVN_00C0[pwszSrc[i] - 0x00C0];
		else if(pwszSrc[i] >= 0x0168 && pwszSrc[i] < 0x0168 + _countof(UCStoTCVN_0168))
			pszDest[i] = UCStoTCVN_0168[pwszSrc[i] - 0x0168];
		else if(pwszSrc[i] >= 0x01A0 && pwszSrc[i] < 0x01A0 + _countof(UCStoTCVN_01A0))
			pszDest[i] = UCStoTCVN_01A0[pwszSrc[i] - 0x01A0];
		else if(pwszSrc[i] >= 0x0300 && pwszSrc[i] < 0x0300 + _countof(UCStoTCVN_0300))
			pszDest[i] = UCStoTCVN_0300[pwszSrc[i] - 0x0300];
		else if(pwszSrc[i] >= 0x1EA0 && pwszSrc[i] < 0x1EA0 + _countof(UCStoTCVN_1EA0))
			pszDest[i] = UCStoTCVN_1EA0[pwszSrc[i] - 0x1EA0];
		else
			pszDest[i] = __NA;
		if(pszDest[i] == 0 && pwszSrc[i] != 0)
			CONFIRM_ILLEGAL_CHAR(pszDest[i]);
	}
	return cch;
}

size_t CEncoder_Vietnamese_Tcvn::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i) {
		if(pszSrc[i] < _countof(TCVNtoUCS_00))
			pwszDest[i] = TCVNtoUCS_00[pszSrc[i]];
		else if(pszSrc[i] < 0x80)
			pwszDest[i] = pszSrc[i];
		else
			pwszDest[i] = TCVNtoUCS_80[pszSrc[i] - 0x80];
		if(pwszDest[i] == __REPLACEMENT_CHARACTER)
			CONFIRM_ILLEGAL_CHAR(pwszDest[i]);
	}
	return cch;
}


// xgi (VISCII) //////////////////////////////////////////////////////

size_t CEncoder_Vietnamese_Viscii::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i) {
		if(pwszSrc[i] < _countof(UCStoVISCII_0000))
			pszDest[i] = UCStoVISCII_0000[pwszSrc[i]];
		else if(pwszSrc[i] < 0x0080)
			pszDest[i] = static_cast<uchar>(pwszSrc[i]);
		else if(pwszSrc[i] >= 0x00C0 && pwszSrc[i] < 0x00C0 + _countof(UCStoVISCII_00C0))
			pszDest[i] = UCStoVISCII_00C0[pwszSrc[i] - 0x00C0];
		else if(pwszSrc[i] >= 0x0168 && pwszSrc[i] < 0x0168 + _countof(UCStoVISCII_0168))
			pszDest[i] = UCStoVISCII_0168[pwszSrc[i] - 0x0168];
		else if(pwszSrc[i] >= 0x01A0 && pwszSrc[i] < 0x01A0 + _countof(UCStoVISCII_01A0))
			pszDest[i] = UCStoVISCII_01A0[pwszSrc[i] - 0x01A0];
		else if(pwszSrc[i] >= 0x1EA0 && pwszSrc[i] < 0x1EA0 + _countof(UCStoVISCII_1EA0))
			pszDest[i] = UCStoVISCII_1EA0[pwszSrc[i] - 0x1EA0];
		else
			pszDest[i] = __NA;
		if(pszDest[i] == 0 && pwszSrc[i] != 0)
			CONFIRM_ILLEGAL_CHAR(pszDest[i]);
	}
	return cch;
}

size_t CEncoder_Vietnamese_Viscii::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i) {
		if(pszSrc[i] < _countof(VISCIItoUCS_00))
			pwszDest[i] = VISCIItoUCS_00[pszSrc[i]];
		else if(pszSrc[i] < 0x80)
			pwszDest[i] = pszSrc[i];
		else
			pwszDest[i] = VISCIItoUCS_80[pszSrc[i] - 0x80];
		if(pwszDest[i] == __REPLACEMENT_CHARACTER)
			CONFIRM_ILLEGAL_CHAR(pwszDest[i]);
	}
	return cch;
}


// xgi (VPS) /////////////////////////////////////////////////////////

size_t CEncoder_Vietnamese_Vps::ConvertFromUnicode(CFU_ARGLIST) {
	CFU_CHECKARGS();
	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i) {
		if(pwszSrc[i] < _countof(UCStoVPS_0000))
			pszDest[i] = UCStoVPS_0000[pwszSrc[i]];
		else if(pwszSrc[i] >= 0x00A0 && pwszSrc[i] < 0x00A0 + _countof(UCStoVPS_00A0))
			pszDest[i] = UCStoVPS_00A0[pwszSrc[i] - 0x00A0];
		else if(pwszSrc[i] >= 0x0168 && pwszSrc[i] < 0x0168 + _countof(UCStoVPS_0168))
			pszDest[i] = UCStoVPS_0168[pwszSrc[i] - 0x0168];
		else if(pwszSrc[i] >= 0x01A0 && pwszSrc[i] < 0x01A0 + _countof(UCStoVPS_01A0))
			pszDest[i] = UCStoVPS_01A0[pwszSrc[i] - 0x01A0];
		else if(pwszSrc[i] >= 0x1EA0 && pwszSrc[i] < 0x1EA0 + _countof(UCStoVPS_1EA0))
			pszDest[i] = UCStoVPS_1EA0[pwszSrc[i] - 0x1EA0];
		else if(pwszSrc[i] >= 0x2018 && pwszSrc[i] < 0x2018 + _countof(UCStoVPS_2018))
			pszDest[i] = UCStoVPS_2018[pwszSrc[i] - 0x2018];
		else
			pszDest[i] = __NA;
		if(pszDest[i] == 0 && pwszSrc[i] != 0)
			CONFIRM_ILLEGAL_CHAR(pszDest[i]);
	}
	return cch;
}

size_t CEncoder_Vietnamese_Vps::ConvertToUnicode(CTU_ARGLIST) {
	CTU_CHECKARGS();
	const size_t	cch = min(cchSrc, cchDest);
	for(size_t i = 0; i < cch; ++i)
		pwszDest[i] = VPStoUCS_00[pszSrc[i]];
	return cch;
}

/* [EOF] */