// EditViewMessageHandlers.cpp
// (c) 2004-2005 exeal

/**
 *	@file	EditViewMessageHandlers.cpp
 *	CEditView NX̓AEBhEbZ[WnhW߂
 *	@see	CEditView::DispatchEvent
 */

#include "StdAfx.h"
#include "EditView.h"
#include "EditPoint.h"
using namespace Ascension;
using namespace Ascension::BooleanOptions;
using namespace Manah::Windows::GDI;
using namespace std;


// Ɏg}N (̃t@CłgȂBɌĂԂ)

#define ABORT_ISEARCH()															\
	if(m_incrementalSearcher.GetState() != CIncrementalSearcher::NOT_RUNNING)	\
		m_incrementalSearcher.AbortSearch()

#define ABORT_ABBR()														\
	if(m_modeState.bReadyToExpandAbbrev) {									\
		m_modeState.bReadyToExpandAbbrev = false;							\
		_FOR_EACH_LISTENERS()												\
			(*it)->OnChangedAbbreviationExpansionReadyState(false, L"");	\
	}

#define BEGIN_WORDUNIT_SELECTION()												\
	StandardCommands::CSelectionCreationCommand(*this,							\
		StandardCommands::CSelectionCreationCommand::CURRENT_WORD).Execute();	\
	m_leftDownMode = LDM_SELECTION_WORD;										\
	m_pSelection->BeginWordSelection();											\
	if(toBoolean(::GetKeyState(VK_MENU) & 0x8000))	/* `I */				\
		m_pSelection->Select(m_pSelection->GetAnchorPoint(), m_pSelection->GetActivePoint(), true, true)

#define GENERATE_SELECTED_REGION()																		\
	CCharPos	_pos[2];																				\
	if(m_leftDownMode == LDM_SELECTION_CHARACTER) {														\
		_pos[0] = m_pSelection->GetAnchorPoint();														\
		_pos[1] = CharFromPos(pt, !m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);	\
	} else if(m_leftDownMode == LDM_SELECTION_LINE) {													\
		const HitTestResult	htr = HitTest(pt);															\
		CCharPos			pos =																		\
			CharFromPos(pt, !m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);		\
		if(htr == HTR_INDICATORMARGIN || htr == HTR_LINENUMBERS) {										\
			const length_t	cLines = GetDocument().GetLineCount();										\
			const length_t	iAnchor = m_pSelection->GetLineSelectionOriginalLine();						\
			_pos[0].m_iLine = (pos.m_iLine >= iAnchor) ? iAnchor : iAnchor + 1;							\
			if(_pos[0].m_iLine > cLines - 1)															\
				_pos[0].m_iChar = GetDocument().GetLineLength(--_pos[0].m_iLine);						\
			else																						\
				_pos[0].m_iChar = 0;																	\
			_pos[1].m_iLine = (pos.m_iLine >= iAnchor) ? pos.m_iLine + 1 : pos.m_iLine;					\
			if(_pos[1].m_iLine > cLines - 1)															\
				_pos[1].m_iChar = GetDocument().GetLineLength(--_pos[1].m_iLine);						\
			else																						\
				_pos[1].m_iChar = 0;																	\
		} else {	/* ʏ̑I[hɈڍs */													\
			KillTimer(TIMERID_EXPANDLINESELECTION);														\
			SetTimer(TIMERID_EXPANDSELECTION, 50, 0);													\
			m_leftDownMode = LDM_SELECTION_CHARACTER;													\
			_pos[0] = m_pSelection->GetAnchorPoint();													\
			_pos[1] = pos;																				\
		}																								\
	} else if(m_leftDownMode == LDM_SELECTION_WORD) {													\
		const CCharPos	pos = CharFromPos(pt,															\
			!m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);						\
		CTextRange	originalWord;																		\
		m_pSelection->GetWordSelectionOriginalWord(originalWord);										\
		if(pos.m_iLine < originalWord.m_pos1.m_iLine													\
				|| (pos.m_iLine == originalWord.m_pos1.m_iLine											\
				&& pos.m_iChar < originalWord.m_pos1.m_iChar)) {										\
			_pos[0] = CCharPos(originalWord.m_pos1.m_iLine, originalWord.m_pos2.m_iChar);				\
			_pos[1] = m_pBoundarySearcher->SearchWordBoundary(pos,										\
				false, static_cast<CBoundarySearcher::SearchPart>(										\
					CBoundarySearcher::AROUND | CBoundarySearcher::ONLY_CURRENT_LINE));					\
		} else if(pos.m_iLine > originalWord.m_pos1.m_iLine												\
				|| (pos.m_iLine == originalWord.m_pos1.m_iLine											\
				&& pos.m_iChar > originalWord.m_pos2.m_iChar)) {										\
			_pos[0] = CCharPos(originalWord.m_pos1.m_iLine, originalWord.m_pos1.m_iChar);				\
			_pos[1] = m_pBoundarySearcher->SearchWordBoundary(pos,										\
				true, static_cast<CBoundarySearcher::SearchPart>(										\
					CBoundarySearcher::AROUND | CBoundarySearcher::ONLY_CURRENT_LINE));					\
		} else {																						\
			_pos[0] = CCharPos(originalWord.m_pos1.m_iLine, originalWord.m_pos1.m_iChar);				\
			_pos[1] = CCharPos(originalWord.m_pos2.m_iLine, originalWord.m_pos2.m_iChar);				\
		}																								\
	} else																								\
		assert(false)

#define RESTORE_HIDDEN_CURSOR()							\
	if(m_modeState.bCursorHiddenForCharInput) {			\
		m_modeState.bCursorHiddenForCharInput = false;	\
		::ShowCursor(true);								\
		ReleaseCapture();								\
	}

#define GET_HSCROLL_POSITION()	\



/// @see	CWindow::OnCaptureChanged
void CEditView::OnCaptureChanged(HWND hwndNew) {
	m_leftDownMode = LDM_NONE;
	KillTimer(TIMERID_EXPANDSELECTION);
	KillTimer(TIMERID_EXPANDLINESELECTION);
	KillTimer(TIMERID_AUTOSCROLL);
}

/// ̃\bh̓I[o[ChłȂB OnUniChar ĂяôŁA
///  CEditView::OnUniChar I[o[ChƂ悢
/// @see	CWindow::OnChar
void CEditView::OnChar(UINT nChar, UINT nFlags) {
	OnUniChar(nChar, nFlags);
}

/// @see	CWindow::OnCommand
bool CEditView::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	using namespace Ascension::StandardCommands;
	switch(wID) {
	case WM_UNDO:	// [ɖ߂]
		CUndoCommand(*this, true).Execute();
		break;
	case WM_REDO:	// [蒼]
		CUndoCommand(*this, false).Execute();
		break;
	case WM_CUT:	// [؂]
		CClipboardCommand(*this, CClipboardCommand::CUT, true).Execute();
		break;
	case WM_COPY:	// [Rs[]
		CClipboardCommand(*this, CClipboardCommand::COPY, true).Execute();
		break;
	case WM_PASTE:	// [\t]
		CClipboardCommand(*this, CClipboardCommand::PASTE, false).Execute();
		break;
	case WM_CLEAR:	// [폜]
		CDeletionCommand(*this, CDeletionCommand::NEXT_CHARACTER).Execute();
		break;
	case WM_SELECTALL:	// [ׂđI]
		CSelectionCreationCommand(*this, CSelectionCreationCommand::ALL).Execute();
		break;
	case ID_RTLREADING:	// [E獶ɓǂ]
		SetTextDirection(!IsTextDirectionRightToLeft());
		break;
	case ID_SHOWDIRECTIONALFORMATTERS:	// [Unicode 䕶̕\]
		m_pSharedData->options.appearance.flip(SHOW_UNICODE_CONTROLS);
		InvalidateRect(0, false);
		break;
	case ID_INSERT_LRM:		CCharacterInputCommand(*this, 0x200E).Execute();	break;
	case ID_INSERT_RLM:		CCharacterInputCommand(*this, 0x200F).Execute();	break;
	case ID_INSERT_ZWJ:		CCharacterInputCommand(*this, 0x200D).Execute();	break;
	case ID_INSERT_ZWNJ:	CCharacterInputCommand(*this, 0x200C).Execute();	break;
	case ID_INSERT_LRE:		CCharacterInputCommand(*this, 0x202A).Execute();	break;
	case ID_INSERT_RLE:		CCharacterInputCommand(*this, 0x202B).Execute();	break;
	case ID_INSERT_LRO:		CCharacterInputCommand(*this, 0x202D).Execute();	break;
	case ID_INSERT_RLO:		CCharacterInputCommand(*this, 0x202E).Execute();	break;
	case ID_INSERT_PDF:		CCharacterInputCommand(*this, 0x202C).Execute();	break;
	case ID_INSERT_WJ:		CCharacterInputCommand(*this, 0x2060).Execute();	break;
	case ID_INSERT_NADS:	CCharacterInputCommand(*this, 0x206E).Execute();	break;
	case ID_INSERT_NODS:	CCharacterInputCommand(*this, 0x206F).Execute();	break;
	case ID_INSERT_ASS:		CCharacterInputCommand(*this, 0x206B).Execute();	break;
	case ID_INSERT_ISS:		CCharacterInputCommand(*this, 0x206A).Execute();	break;
	case ID_INSERT_AAFS:	CCharacterInputCommand(*this, 0x206D).Execute();	break;
	case ID_INSERT_IAFS:	CCharacterInputCommand(*this, 0x206C).Execute();	break;
	case ID_INSERT_RS:		CCharacterInputCommand(*this, 0x001E).Execute();	break;
	case ID_INSERT_US:		CCharacterInputCommand(*this, 0x001F).Execute();	break;
	case ID_INSERT_IAA:		CCharacterInputCommand(*this, 0xFFF9).Execute();	break;
	case ID_INSERT_IAT:		CCharacterInputCommand(*this, 0xFFFA).Execute();	break;
	case ID_INSERT_IAS:		CCharacterInputCommand(*this, 0xFFFB).Execute();	break;
	case ID_INSERT_U0020:	CCharacterInputCommand(*this, 0x0020).Execute();	break;
	case ID_INSERT_NBSP:	CCharacterInputCommand(*this, 0x00A0).Execute();	break;
	case ID_INSERT_U1680:	CCharacterInputCommand(*this, 0x1680).Execute();	break;
	case ID_INSERT_MVS:		CCharacterInputCommand(*this, 0x180E).Execute();	break;
	case ID_INSERT_U2000:	CCharacterInputCommand(*this, 0x2000).Execute();	break;
	case ID_INSERT_U2001:	CCharacterInputCommand(*this, 0x2001).Execute();	break;
	case ID_INSERT_U2002:	CCharacterInputCommand(*this, 0x2002).Execute();	break;
	case ID_INSERT_U2003:	CCharacterInputCommand(*this, 0x2003).Execute();	break;
	case ID_INSERT_U2004:	CCharacterInputCommand(*this, 0x2004).Execute();	break;
	case ID_INSERT_U2005:	CCharacterInputCommand(*this, 0x2005).Execute();	break;
	case ID_INSERT_U2006:	CCharacterInputCommand(*this, 0x2006).Execute();	break;
	case ID_INSERT_U2007:	CCharacterInputCommand(*this, 0x2007).Execute();	break;
	case ID_INSERT_U2008:	CCharacterInputCommand(*this, 0x2008).Execute();	break;
	case ID_INSERT_U2009:	CCharacterInputCommand(*this, 0x2009).Execute();	break;
	case ID_INSERT_U200A:	CCharacterInputCommand(*this, 0x200A).Execute();	break;
	case ID_INSERT_ZWSP:	CCharacterInputCommand(*this, 0x200B).Execute();	break;
	case ID_INSERT_NNBSP:	CCharacterInputCommand(*this, 0x202F).Execute();	break;
	case ID_INSERT_MMSP:	CCharacterInputCommand(*this, 0x205F).Execute();	break;
	case ID_INSERT_U3000:	CCharacterInputCommand(*this, 0x3000).Execute();	break;
	case ID_INSERT_NEL:		CCharacterInputCommand(*this, 0x0085).Execute();	break;
	case ID_INSERT_LS:		CCharacterInputCommand(*this, 0x2028).Execute();	break;
	case ID_INSERT_PS:		CCharacterInputCommand(*this, 0x2029).Execute();	break;
	case ID_TOGGLEIMESTATUS:	// [IME J] / [IME ]
		CInputStatusToggleCommand(*this, CInputStatusToggleCommand::IME_STATUS).Execute();
		break;
	case ID_TOGGLESOFTKEYBOARD:	// [\tgL[{[hJ] / [\tgL[{[h]
		CInputStatusToggleCommand(*this, CInputStatusToggleCommand::SOFT_KEYBOARD).Execute();
		break;
	case ID_RECONVERT:	// [ĕϊ]
		CReconversionCommand(*this).Execute();
		break;
	default:
		::SendMessageW(GetParent(), WM_COMMAND,
			MAKEWPARAM(wID, wNotifyCode), reinterpret_cast<LPARAM>(hwndCtrl));
	}

	return _BaseView::OnCommand(wID, wNotifyCode, hwndCtrl);
}

/// @see	CWindow::OnContextMenu
bool CEditView::OnContextMenu(HWND hWnd, POINT pt) {
	RECT	rect;

	CloseCompletionWindow();
	ABORT_ISEARCH();

	// L[{[hɂꍇ
	if(pt.x == 65535 && pt.y == 65535) {
		pt.x = pt.y = 1;	// K...
		ClientToScreen(pt);
	}

	// XN[o[łΏȂ
	GetClientRect(rect);
	ClientToScreen(rect);
	if(!toBoolean(::PtInRect(&rect, pt)))
		return false;

	const CEditDoc&				document = GetDocument();
	const bool					bSelection = !m_pSelection->IsEmpty();
	const bool					bReadOnly = document.IsReadOnly();
	AutoZeroCB<MENUITEMINFOW>	mii;
	HMENU&						hMenu = m_pSharedData->hContextMenu;

	// j[ڂ̏C
	::EnableMenuItem(hMenu, WM_UNDO, MF_BYCOMMAND
		| (!bReadOnly && document.GetUndoHistoryLength(false) != 0) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_REDO, MF_BYCOMMAND
		| (!bReadOnly && document.GetUndoHistoryLength(true) != 0) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_CUT, MF_BYCOMMAND | (!bReadOnly && bSelection) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_COPY, MF_BYCOMMAND | bSelection ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_PASTE, MF_BYCOMMAND | (!bReadOnly && CanPaste()) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_CLEAR, MF_BYCOMMAND | (!bReadOnly && bSelection) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_SELECTALL, MF_BYCOMMAND
		| (document.GetLineCount() > 1 || document.GetLineLength(0) > 0) ? MFS_ENABLED : MFS_DISABLED);
	::CheckMenuItem(hMenu, ID_RTLREADING, MF_BYCOMMAND | MFS_GRAYED |
		(GetLayoutSettings().GetSettings().bRightToLeftReading ? MFS_CHECKED : MFS_UNCHECKED));
	::CheckMenuItem(hMenu, ID_SHOWDIRECTIONALFORMATTERS, MF_BYCOMMAND |
		(m_pSharedData->options.appearance[SHOW_UNICODE_CONTROLS] ? MFS_CHECKED : MFS_UNCHECKED));

	// IME ֘A
	HKL		hKeyboardLayout = ::GetKeyboardLayout(::GetCurrentThreadId());
	UINT	iItem = 13;
	if(/*toBoolean(::ImmIsIME(hKeyboardLayout)) &&*/ ::ImmGetProperty(hKeyboardLayout, IGP_SENTENCE) != IME_SMODE_NONE) {
		const bool	bJapanese = PRIMARYLANGID(::GetUserDefaultLangID()) == LANG_JAPANESE;
		HIMC		hImc = ::ImmGetContext(m_hWnd);
		WCHAR*		wszOpenIme = bJapanese ? L"IME J(&O)" : L"&Open IME";
		WCHAR*		wszCloseIme = bJapanese ? L"IME (&L)" : L"C&lose IME";
		WCHAR*		wszOpenSftKbd = bJapanese ? L"\tgL[{[hJ(&E)" : L"Op&en soft keyboard";
		WCHAR*		wszCloseSftKbd = bJapanese ? L"\tgL[{[h(&F)" : L"Close so&ft keyboard";
		WCHAR*		wszReconvert = bJapanese ? L"ĕϊ(&R)" : L"&Reconvert";

		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(hMenu, ++iItem, true, &mii);

		mii.fMask = MIIM_ID | MIIM_STRING;
		mii.fType = MFT_STRING;
		mii.wID = ID_TOGGLEIMESTATUS;
		mii.dwTypeData = toBoolean(::ImmGetOpenStatus(hImc)) ? wszCloseIme : wszOpenIme;
		::InsertMenuItemW(hMenu, ++iItem, true, &mii);

		if(toBoolean(::ImmGetProperty(hKeyboardLayout, IGP_CONVERSION) & IME_CMODE_SOFTKBD)) {
			DWORD	dwConvMode;
			
			::ImmGetConversionStatus(hImc, &dwConvMode, 0);
			mii.wID = ID_TOGGLESOFTKEYBOARD;
			mii.dwTypeData = toBoolean(dwConvMode & IME_CMODE_SOFTKBD) ? wszCloseSftKbd : wszOpenSftKbd;
			::InsertMenuItemW(hMenu, ++iItem, true, &mii);
		}

		if(toBoolean(::ImmGetProperty(hKeyboardLayout, IGP_SETCOMPSTR) & SCS_CAP_COMPSTR)) {
			mii.wID = ID_RECONVERT;
			mii.dwTypeData = wszReconvert;
			mii.fMask |= MIIM_STATE;
			mii.fState = (!bReadOnly && bSelection) ? MFS_ENABLED : MFS_GRAYED;
			::InsertMenuItemW(hMenu, ++iItem, true, &mii);
		}

		::ImmReleaseContext(m_hWnd, hImc);
	}
	::TrackPopupMenu(hMenu, TPM_LEFTALIGN, pt.x, pt.y, 0, m_hWnd, 0);
	while(iItem > 13)
		::DeleteMenu(hMenu, iItem--, MF_BYPOSITION);

	return true;
}

/// @see	CWindow::OnDestroy
void CEditView::OnDestroy() {
	// r[ȃCxgI点
	_FOR_EACH_CONST_LISTENERS() {
		(*it)->OnChangedAbbreviationExpansionReadyState(false, L"");
		if(m_posHilightedBrackets[0].m_iLine != -1)
			(*it)->OnMatchBracketFoundOutOfView(CCharPos(-1, -1));
	}
	ABORT_ISEARCH();
	EndAutoScroll();

	// D&D 
	RevokeDragDrop();

	// ]EBhE폜
	::DestroyWindow(m_hwndToolTip);
	if(m_pCompletionWindow != 0)		m_pCompletionWindow->DestroyWindow();
	if(m_pAutoScrollOriginMark != 0)	m_pAutoScrollOriginMark->DestroyWindow();
	
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	m_memDC.SelectObject(m_hOldLineBitmap);
	::DeleteObject(m_hLineBitmap);
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	CWindow::OnDestroy();
}

/// @see	CWindow::OnHScroll
void CEditView::OnHScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar) {
	//  nPos ̓XN[o[̍[̈ʒuB
	// ݊݊AԈĂĈōύX邩
	const int					nOrgPos = _MapInternalXToScrollBoxX(m_scrollInfo.position.x);
	int							nNewPos = nOrgPos;
	AutoZeroCB<SCROLLINFO>		scroll;
	const ulong					cVisibleChars = GetVisibleCharCount();
	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = layoutManager.GetSettings();

	scroll.fMask = SIF_PAGE | SIF_RANGE;
	GetScrollInfo(SB_HORZ, scroll);

//	CloseCompletionWindow();
	if(cVisibleChars > static_cast<ulong>(scroll.nMax - scroll.nMin) * m_scrollInfo.nHorizontalRatio) {
		m_scrollInfo.position.x = 0;
		return;
	}

	switch(nSBCode) {
	case SB_LINELEFT:	// 1񕪍
		--nNewPos; break;
	case SB_LINERIGHT:	// 1񕪉E
		++nNewPos; break;
	case SB_PAGELEFT:	// 1y[W
		nNewPos -= cVisibleChars; break;
	case SB_PAGERIGHT:	// 1y[WE
		nNewPos += cVisibleChars; break;
	case SB_LEFT:		// [
		nNewPos = scroll.nMin; break;
	case SB_RIGHT:		// E[
		nNewPos = scroll.nMax; break;
	case SB_THUMBTRACK:	// hbO or zC[
		nNewPos = GetScrollTrackPos(SB_HORZ); break;	// 32rbglg
	case SB_SETPOS:		// IȃXN[	
		nNewPos = nPos; break;
	default:			return;
	}

	// 
	nNewPos = max<int>(nNewPos, scroll.nMin);
	nNewPos = min<int>(nNewPos, scroll.nMax - scroll.nPage + 1);

	if(IsFreezed()) {	// 𓀎ɂ炽߂ăXN[
		m_freezeInfo.scrollPosition.x = _MapScrollBoxXToInternalX(nNewPos);
		return;
	}

	if(nNewPos == nOrgPos)	// XN[Ȃ
		return;

	// ĕ`Ȃ
	if(dif<long>(nNewPos, nOrgPos) < cVisibleChars) {	// XN[ʂ1y[Wȉ
		RECT		rcScroll;				// XN[Ώ
		const int	dx = (nOrgPos - nNewPos) *
							m_scrollInfo.nHorizontalRatio * layoutManager.GetAverageCharacterWidth();

		GetClientRect(rcScroll);
		if(!layout.bRightAlign)
			rcScroll.left += layoutManager.GetVerticalRulerWidth() + layout.nLeadMargin;
		else
			rcScroll.right -= layoutManager.GetVerticalRulerWidth() + layout.nLeadMargin;

		RECT	rcUpdate = rcScroll;	// 蓮ŌvZXV`

		if(dx > 0) {
			rcScroll.left += dx;
			rcUpdate.right = rcUpdate.left + dx;
		} else {
			rcScroll.right -= dx;
			rcUpdate.left = rcUpdate.right + dx;
		}
		ScrollWindowEx(dx, 0, &rcScroll, &rcScroll, 0, 0, SW_INVALIDATE);
		InvalidateRect(&rcUpdate, false);
	} else
		InvalidateRect(0, false);

	HideToolTip();
	SetScrollPos(SB_HORZ, nNewPos);
	m_scrollInfo.position.x = _MapScrollBoxXToInternalX(nNewPos);
	UpdateCaretPosition();
	if(m_bActiveImeComposition)
		UpdateImeCompositionWindowPosition();
//	UpdateWindow();

	CloseCompletionWindow();
}

/// @see	WM_IME_COMPOSITION
bool CEditView::OnImeComposition(WPARAM wParam, LPARAM lParam) {
	if(lParam == 0 || toBoolean(lParam & GCS_RESULTSTR)) {	// m
		if(HIMC	hIMC = ::ImmGetContext(m_hWnd)) {
			const length_t	cch = ::ImmGetCompositionStringW(hIMC, GCS_RESULTSTR, 0, 0) / sizeof(WCHAR);

			if(cch != 0) {	// LZȂꍇ
				char_t* const	pwszText = new char_t[cch + 1];
				::ImmGetCompositionStringW(hIMC, GCS_RESULTSTR, pwszText, cch * sizeof(WCHAR));
				pwszText[cch] = 0;
				StandardCommands::CTextInputCommand(*this, pwszText).Execute();
				delete[] pwszText;
			}

			UpdateImeCompositionWindowPosition();
			::ImmReleaseContext(m_hWnd, hIMC);
		}
		return true;
	}
	return false;
}

/// @see	WM_IME_ENDCOMPOSITION
void CEditView::OnImeEndComposition() {
	ShowCaret();
	m_bActiveImeComposition = false;
}

/// @see	WM_IME_REQUEST
LRESULT CEditView::OnImeRequest(WPARAM command, LPARAM lParam) {
	// ĕϊsƂɂ܂̃R}h2ł
	if(command == IMR_RECONVERTSTRING) {
		if(GetDocument().IsReadOnly())
			Beep();
		else if(m_pSelection->IsEmpty()) {	// Iꍇ IME ɍĕῗ͈߂Ă炤
			const CVisualPoint&	caret = m_pSelection->GetActivePoint();
			if(RECONVERTSTRING* const prcs = reinterpret_cast<RECONVERTSTRING*>(lParam)) {
				const string_t&	strLine = GetDocument().GetLine(caret.GetLineNumber());
				prcs->dwStrLen = strLine.length();
				prcs->dwStrOffset = sizeof(RECONVERTSTRING);
				prcs->dwTargetStrOffset = prcs->dwCompStrOffset = sizeof(char_t) * caret.GetCharNumber();
				prcs->dwTargetStrLen = prcs->dwCompStrLen = 0;
				strLine.copy(reinterpret_cast<char_t*>(reinterpret_cast<char*>(prcs) + prcs->dwStrOffset), prcs->dwStrLen);
			}
			return sizeof(RECONVERTSTRING) + sizeof(char_t) * GetDocument().GetLineLength(caret.GetLineNumber());
		} else if(!m_pSelection->IsRectangle()) {
			const string_t	strSelection = m_pSelection->GetText();
			if(RECONVERTSTRING* const prcs = reinterpret_cast<RECONVERTSTRING*>(lParam)) {
				prcs->dwStrLen = prcs->dwTargetStrLen = prcs->dwCompStrLen = strSelection.length();
				prcs->dwStrOffset = sizeof(RECONVERTSTRING);
				prcs->dwTargetStrOffset = prcs->dwCompStrOffset = 0;
				strSelection.copy(reinterpret_cast<char_t*>(reinterpret_cast<char*>(prcs) + prcs->dwStrOffset), prcs->dwStrLen);
			}
			return sizeof(RECONVERTSTRING) + sizeof(char_t) * strSelection.length();
		}
		return 0L;
	}

	// ĕϊ̒OBRECONVERTSTRING ɍĕϊ͈̔͂ݒ肳Ă
	else if(command == IMR_CONFIRMRECONVERTSTRING) {
		RECONVERTSTRING* const prcs = reinterpret_cast<RECONVERTSTRING*>(lParam);
		const CVisualPoint&	caret = m_pSelection->GetActivePoint();
		const CCharPos		startPoint = GetDocument().GetStartPoint();
		const CCharPos		endPoint = GetDocument().GetEndPoint();
		if(!m_pSelection->IsEmpty()) {
			// ɑIꍇ͑I͈͂ĕϊB
			// I͕sɂȂĂ\
			if(prcs->dwCompStrLen < prcs->dwStrLen)	// ĕῗ͈߂Ă (߂)
				prcs->dwCompStrLen = prcs->dwStrLen;	//  IME xočĕϊ͍sȂB
														// I߂̂݊̓삾...
		} else {
			// Iꍇ IME Ă͈͂ĕϊ (I쐬Ă)B
			// ̏ꍇ͕s̍ĕϊ͔Ȃ (prcs->dwStrXxx ͌ݍsS)
			if(GetDocument().IsNarrowed() && caret.GetLineNumber() == startPoint.m_iLine) {	// i[CO
				if(prcs->dwCompStrOffset / sizeof(char_t) < startPoint.m_iChar) {
					prcs->dwCompStrLen += sizeof(char_t) * startPoint.m_iChar - prcs->dwCompStrOffset;
					prcs->dwTargetStrLen = prcs->dwCompStrOffset;
					prcs->dwCompStrOffset = prcs->dwTargetStrOffset = sizeof(char_t) * startPoint.m_iChar;
				} else if(prcs->dwCompStrOffset / sizeof(char_t) > endPoint.m_iChar) {
					prcs->dwCompStrOffset -= prcs->dwCompStrOffset - sizeof(char_t) * endPoint.m_iChar;
					prcs->dwTargetStrOffset = prcs->dwCompStrOffset;
					prcs->dwCompStrLen = prcs->dwTargetStrLen = sizeof(char_t) * endPoint.m_iChar - prcs->dwCompStrOffset;
				}
			}
			m_pSelection->Select(
				CCharPos(caret.GetLineNumber(), prcs->dwCompStrOffset / sizeof(char_t)),
				CCharPos(caret.GetLineNumber(), prcs->dwCompStrOffset / sizeof(char_t) + prcs->dwCompStrLen),
				false, true);
		}
		return true;
	}

	// ϊEBhËʒu߂KvȂƂɎs
	else if(command == IMR_QUERYCHARPOSITION)
		return false;	// ValidateImeWindowPos ŉƂ...

	return 0L;
}

/// @see	WM_IME_STARTCOMPOSITION
void CEditView::OnImeStartComposition() {
	HIMC		hIMC = ::ImmGetContext(m_hWnd);
	LOGFONTW	lf;

	if(hIMC != 0) {
		::GetObject(m_pSharedData->layoutManager.GetRegularFont(), sizeof(LOGFONTW), &lf);
		::ImmSetCompositionFontW(hIMC, &lf);	// IME ̐ݒɂĂ͔f邾낤
		HideCaret();
		::ImmReleaseContext(m_hWnd, hIMC);
	}
	m_bActiveImeComposition = true;
	UpdateImeCompositionWindowPosition();

	m_pCompletionWindow->ShowWindow(SW_HIDE);
}

/**
 *	@brief	WM_KEYDOWN ̏
 *
 *	̎ Ascension r[̊̃L[蓖Ăɏ]ăR}hs
 *	(ExecuteCommand Ăяo)B̃L[蓖Ă̓eLXgGfB^ƂēT^IȂ̂A
 *	AvP[VŃJX^}CYꍇ͋ŃI[o[ChƂ悢
 *	(ANZ[^gꍇ͂ɔłȂ̂ł̂܂܂ł悢Ȃ)
 *
 *	<h3>I[o[Chꍇ</h3>
 *
 *	̎ CEditView::ExecuteCommand ĂяoăR}hsȊOȂB
 *	L[gݍ킹R}hɊ蓖ĂĂȂꍇ͉Ȃ
 *
 *	<h3>̃L[蓖</h3>
 *
 *	̃L[蓖ĂɂĂ Ascension ̃}jA
 */
bool CEditView::OnKeyDown(UINT nChar, UINT nFlags) {
	using namespace Ascension::StandardCommands;
	const bool	bCtrl = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);
	const bool	bShift = toBoolean(::GetKeyState(VK_SHIFT) & 0x8000);
	const bool	bRepetition = toBoolean(nFlags & (1 << 30));

	switch(nChar) {
	case VK_LEFT:	// []
		if(bCtrl)	CCaretMovementCommand(*this, CCaretMovementCommand::LEFT_WORD, bShift).Execute();
		else		CCaretMovementCommand(*this, CCaretMovementCommand::LEFT_CHARACTER, bShift, bRepetition ? 2 : 1).Execute();
		return true;
	case VK_RIGHT:	// []
		if(bCtrl)	CCaretMovementCommand(*this, CCaretMovementCommand::RIGHT_WORD, bShift).Execute();
		else		CCaretMovementCommand(*this, CCaretMovementCommand::RIGHT_CHARACTER, bShift, bRepetition ? 2 : 1).Execute();
		return true;
	case VK_UP:		// []
		if(bCtrl && !bShift)
			OnVScroll(SB_LINEUP, 0, 0);
		else
			CCaretMovementCommand(*this, CCaretMovementCommand::PREVIOUS_LINE, bShift, bRepetition ? 2 : 1).Execute();
		return true;
	case VK_DOWN:	// []
		if(bCtrl && !bShift)
			OnVScroll(SB_LINEDOWN, 0, 0);
		else
			CCaretMovementCommand(*this, CCaretMovementCommand::NEXT_LINE, bShift, bRepetition ? 2 : 1).Execute();
		return true;
	case VK_HOME:	// [Home]
		if(bCtrl)
			CCaretMovementCommand(*this, CCaretMovementCommand::START_OF_DOCUMENT, bShift).Execute();
		else if(m_pSelection->GetStartPoint().IsStartOfLine())
			CCaretMovementCommand(*this, CCaretMovementCommand::FIRST_CHAR_OF_LINE, bShift).Execute();
		else
			CCaretMovementCommand(*this, CCaretMovementCommand::START_OF_LINE, bShift).Execute();
		return true;
	case VK_END:	// [End]
		if(bCtrl)	CCaretMovementCommand(*this, CCaretMovementCommand::END_OF_DOCUMENT, bShift).Execute();
		else		CCaretMovementCommand(*this, CCaretMovementCommand::END_OF_LINE, bShift).Execute();
		return true;
	case VK_NEXT:	// [PageDown]
		if(bCtrl)	OnVScroll(SB_PAGEDOWN, 0, 0);
		else		CCaretMovementCommand(*this, CCaretMovementCommand::NEXT_PAGE, bShift).Execute();
		return true;
	case VK_PRIOR:	// [PageUp]
		if(bCtrl)	OnVScroll(SB_PAGEUP, 0, 0);
		else		CCaretMovementCommand(*this, CCaretMovementCommand::PREVIOUS_PAGE, bShift).Execute();
		return true;
	case VK_RETURN:	// [Enter]
		CLineBreakCommand(*this, bCtrl);
		return true;
	case VK_DELETE:	// [Delete]
		if(bCtrl && !bShift)	CDeletionCommand(*this, CDeletionCommand::NEXT_WORD).Execute();
		else if(bShift)			CClipboardCommand(*this, CClipboardCommand::CUT, true).Execute();
		else					CDeletionCommand(*this, CDeletionCommand::NEXT_CHARACTER).Execute();
		return true;
	case VK_BACK:	// [BackSpace]
		CDeletionCommand(*this, bCtrl ? CDeletionCommand::PREVIOUS_WORD : CDeletionCommand::PREVIOUS_CHARACTER).Execute();
		return true;
	case VK_INSERT:	// [Insert]
		if(bCtrl && !bShift)	CClipboardCommand(*this, CClipboardCommand::COPY, true).Execute();
		else if(bShift)			CClipboardCommand(*this, CClipboardCommand::PASTE, false).Execute();
		else					CInputStatusToggleCommand(*this, CInputStatusToggleCommand::OVERTYPE_MODE).Execute();
		return true;
	case VK_ESCAPE:	// [Esc]
		CCancelCommand(*this).Execute();
		return true;
	case VK_SHIFT:	// [Shift]
		if(bCtrl && toBoolean(::GetAsyncKeyState(VK_LSHIFT) & 0x8000) && IsTextDirectionRightToLeft()) {
			SetTextDirection(false);
			return true;
		} else if(bCtrl && toBoolean(::GetAsyncKeyState(VK_RSHIFT) & 0x8000) && !IsTextDirectionRightToLeft()) {
			SetTextDirection(true);
			return true;
		}
		return false;
	}
	return false;
}

/// @see	CWindow::OnKillFocus
void CEditView::OnKillFocus(HWND hwndNew) {
	RESTORE_HIDDEN_CURSOR();
	EndAutoScroll();
	if(m_posHilightedBrackets[0].m_iLine != -1
			&& m_posHilightedBrackets[0].m_iChar != -1) {	// Ίʂ̒ʒmI
		_FOR_EACH_LISTENERS()
			(*it)->OnMatchBracketFoundOutOfView(CCharPos(-1, -1));
	}
	if(m_pCompletionWindow->IsWindow() && hwndNew != m_pCompletionWindow->GetSafeHwnd())
		CloseCompletionWindow();
	ABORT_ISEARCH();
	ABORT_ABBR();
	if(m_bActiveImeComposition) {	// IME œ͒ł΂߂
		HIMC	hImc = ::ImmGetContext(m_hWnd);
		::ImmNotifyIME(hImc, NI_COMPOSITIONSTR, CPS_CANCEL, 0);
		::ImmReleaseContext(m_hWnd, hImc);
	}
	if(hwndNew != m_hWnd) {
		HideCaret();
		DestroyCaret();
	}
	InvalidateLines(m_pSelection->GetStartPoint().GetLineNumber(), m_pSelection->GetEndPoint().GetLineNumber());
	UpdateWindow();
}

/// _uNbNւ̃R}h蓖Ă̂߂ɂ̃\bhI[o[Chׂł͂Ȃ
/// @see	CWindow::OnLButtonBblClk
void CEditView::OnLButtonDblClk(UINT nFlags, POINT pt) {
	if(m_nMouseOperationDisabledCount == 0) {
		ABORT_ISEARCH();
		const HitTestResult	htr = HitTest(pt);
		if(htr == HTR_LEADMARGIN || htr == HTR_TOPMARGIN || htr == HTR_TEXT) {
			BEGIN_WORDUNIT_SELECTION();
			SetCapture();
			SetTimer(TIMERID_EXPANDSELECTION, 50, 0);
		}
	}
}

/// }EX{^ւ̃R}h蓖Ă̂߂ɂ̃\bhI[o[Chׂł͂Ȃ
/// @see	CWindow::OnLButtonDown
void CEditView::OnLButtonDown(UINT nFlags, POINT pt) {
#define SELECTION_EXPANSION_INTERVAL	100

	if(m_nMouseOperationDisabledCount != 0)
		return;
	RESTORE_HIDDEN_CURSOR();
	if(EndAutoScroll())
		return;

	bool	bBoxDragging = false;
	char_t*	pwszUri = 0;
	const HitTestResult	htr = HitTest(pt);

	CloseCompletionWindow();
	if(m_incrementalSearcher.GetState() != CIncrementalSearcher::NOT_RUNNING)
		m_incrementalSearcher.EndSearch();

	if(htr == HTR_INDICATORMARGIN || htr == HTR_LINENUMBERS) {	// 1sI
		if(toBoolean(nFlags & MK_CONTROL))	// SsI
			StandardCommands::CSelectionCreationCommand(*this, StandardCommands::CSelectionCreationCommand::ALL).Execute();
		else {
			const CCharPos	pos = CharFromPos(pt, !m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
			m_leftDownMode = LDM_SELECTION_LINE;
			m_pSelection->Select(CCharPos(pos.m_iLine, 0),
				(pos.m_iLine != GetDocument().GetLineCount() - 1) ?
					CCharPos(pos.m_iLine + 1, 0) : CCharPos(pos.m_iLine, GetDocument().GetLineLength(pos.m_iLine)),
				false, true);
			m_pSelection->BeginLineSelection();
		}
		SetCapture();
		SetTimer(TIMERID_EXPANDLINESELECTION, SELECTION_EXPANSION_INTERVAL, 0);
	} else if(m_pSharedData->options.behavior[OLE_DRAG_AND_DROP]
			&& !m_pSelection->IsEmpty()
			&& m_pSelection->IsPointOver(pt)) {	// OLE hbOJn?
		::GetCursorPos(&m_modeState.ptLastMouseDown);
		ScreenToClient(m_modeState.ptLastMouseDown);
		if(m_pSelection->IsRectangle())
			bBoxDragging = true;
	} else if(toBoolean(nFlags & MK_CONTROL)
			&& !m_pSharedData->eventListeners.empty()
			&& IsOverInvokableLink(pt, pwszUri)) {	// N̋N
		_FOR_EACH_LISTENERS()
			(*it)->OnInvokeUriLink(pwszUri);
		delete[] pwszUri;
	} else if(!toBoolean(nFlags & MK_SHIFT)
			&& toBoolean(::GetKeyState(VK_MENU) & 0x8000)) {	// `IJn
		m_leftDownMode = LDM_SELECTION_CHARACTER;
		const CCharPos	pos = CharFromPos(pt, !m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
		m_pSelection->Select(pos, pos, true, true);
		SetCapture();
		SetTimer(TIMERID_EXPANDSELECTION, SELECTION_EXPANSION_INTERVAL, 0);
	} else {	// ̑B`IJnALbgړ
		m_leftDownMode = LDM_SELECTION_CHARACTER;
		const CCharPos	pos = CharFromPos(pt, !m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]);
		if(toBoolean(nFlags & MK_CONTROL)) {	// Ctrl -> ݂̒PI
			GetSelection().MoveTo(pos, true);
			BEGIN_WORDUNIT_SELECTION();
		} else if(toBoolean(nFlags & MK_SHIFT)) {	// Shift -> J[\ʒu܂őI
			if(toBoolean(::GetKeyState(VK_MENU) & 0x8000)) {	// Shift+Alt -> J[\ʒu܂ŋ`I
				m_leftDownMode = LDM_SELECTION_CHARACTER;
				GetSelection().Select(m_pSelection->GetAnchorPoint(), pos, true, true);
			} else
				GetSelection().Select(m_pSelection->GetAnchorPoint(), pos, false, true);
		} else
			GetSelection().MoveTo(pos, true);
		SetCapture();
		SetTimer(TIMERID_EXPANDSELECTION, SELECTION_EXPANSION_INTERVAL, 0);
	}

	if(!m_pSelection->IsRectangle() && !bBoxDragging)
		InvalidateLine(m_pSelection->GetActivePoint().GetLineNumber());
	SetFocus();

#undef SELECTION_EXPANSION_INTERVAL
}

/// @see	CWindow::OnLButtonUp
void CEditView::OnLButtonUp(UINT nFlags, POINT pt) {
	if(m_nMouseOperationDisabledCount != 0)
		return;
	const _LeftDownMode	original = m_leftDownMode;

	if(m_modeState.ptLastMouseDown.x != -1) {	// OLE hbOJn -> LZ
		m_modeState.ptLastMouseDown.x = m_modeState.ptLastMouseDown.y = -1;
		GetSelection().MoveTo(
			CharFromPos(pt, !m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]), true);
		::SetCursor(::LoadCursor(0, IDC_IBEAM));	// [
	}
	ReleaseCapture();

	// I͈͊g咆ɉʊOŃ{^𗣂ƃLbgʒu܂ŃXN[ȂƂ̂
	if(original != LDM_NONE)
		m_pSelection->GetActivePoint().Reveal(*this);
}

/// @see	CWindow::OnMouseMove
void CEditView::OnMouseMove(UINT nFlags, POINT pt) {
	if(m_nMouseOperationDisabledCount != 0)
		return;
	RESTORE_HIDDEN_CURSOR();

	CCharPos	pos;	// J[\ʒu狁܂sƗ

	if(m_modeState.ptLastMouseDown.x != -1) {	// OLE hbOJn?
		POINT&	ptLast = m_modeState.ptLastMouseDown;
		if(!m_pSharedData->options.behavior[OLE_DRAG_AND_DROP] || m_pSelection->IsEmpty())
			ptLast.x = ptLast.y = -1;
		else {
			const int	cxDragBox = ::GetSystemMetrics(SM_CXDRAG);
			const int	cyDragBox = ::GetSystemMetrics(SM_CYDRAG);
			if((pt.x > ptLast.x + cxDragBox / 2) || (pt.x < ptLast.x - cxDragBox / 2)
					|| (pt.y > ptLast.y + cyDragBox / 2) || (pt.y < ptLast.y - cyDragBox / 2)) {
				const bool		bBox = m_pSelection->IsRectangle();
				const string_t	strSelection = m_pSelection->GetText();

				if(bBox) {
					set<CLIPFORMAT>	clipFormats;
					clipFormats.insert(CF_UNICODETEXT);
					clipFormats.insert(::RegisterClipboardFormatW(RECTANGLE_TEXT_CLIP_FORMAT));
					m_pDragging->SetAvailableFormatSet(clipFormats);
				}
				m_pDragging->SetTextData(strSelection.c_str());
				m_leftDownMode = bBox ? LDM_DRAGANDDROPBOXSELF : LDM_DRAGANDDROPSELF;
				SetTimer(TIMERID_DRAGSCROLL, bBox ? 100 : 50, 0);
				m_pDragging->DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);
				KillTimer(TIMERID_DRAGSCROLL);
				m_leftDownMode = LDM_NONE;	// OnLButtonUp ͌Ă΂Ȃ
				ptLast.x = ptLast.y = -1;
				SetFocus();
			}
		}
		return;
	}

	if(toBoolean(pt.x & 0x8000))	pt.x = 0;
	if(toBoolean(pt.y & 0x8000))	pt.y = 0;

	_FOR_EACH_LISTENERS()
		(*it)->OnMoveCursor(pt);

	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = layoutManager.GetSettings();
	if(m_leftDownMode != LDM_NONE) {	// XN[
/*		const long	nMarginWidth = layoutManager.GetVerticalRulerWidth() + layout.nLeadMargin;
		if(pt.y < static_cast<long>(layout.nTopMargin + layoutManager.GetLineHeight() / 2))
			OnVScroll(SB_LINEUP, 0, 0);
		else if(pt.y > static_cast<long>(layout.nTopMargin + layoutManager.GetLineHeight() * GetVisibleLineCount()))
			OnVScroll(SB_LINEDOWN, 0, 0);
		if(!layout.bRightAlign) {
			if(pt.x < nMarginWidth)
				OnHScroll(SB_SETPOS, m_scrollInfo.position.x - layout.cchTabWidth, 0);
//			else if(pt.x >)
		} else {
		}
*/	}
	if(m_leftDownMode == LDM_SELECTION_CHARACTER
			|| m_leftDownMode == LDM_SELECTION_LINE
			|| m_leftDownMode == LDM_SELECTION_WORD) {	// I̊g/k
		GENERATE_SELECTED_REGION();
		GetSelection().Select(_pos[0], _pos[1], GetSelection().IsRectangle(), true);
	} else if(m_leftDownMode == LDM_DRAGANDDROP) {	// IehbO
	}
}

/// @see	CWindow::OnMouseWheel
bool CEditView::OnMouseWheel(UINT nFlags, short zDelta, POINT pt) {
	UINT	nScrollLines;	// XN[s

	if(m_nMouseOperationDisabledCount != 0)
		return true;
	RESTORE_HIDDEN_CURSOR();
	
	if(EndAutoScroll())
		return true;

	// VXeŐݒ肳Ăʂg
	if(!toBoolean(::SystemParametersInfo(SPI_GETWHEELSCROLLLINES, 0, &nScrollLines, 0)))
		nScrollLines = 3;
	zDelta *= nScrollLines;
	OnVScroll(SB_SETPOS, m_scrollInfo.position.y - zDelta / WHEEL_DELTA, 0);

	return true;
}

/// @see	CWindow::OnNotify
bool CEditView::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	// c[`bṽeLXg
	if(lpNMHDR->hwndFrom == m_hwndToolTip && lpNMHDR->code == TTN_GETDISPINFO) {
		::SendMessageW(m_hwndToolTip, TTM_SETMAXTIPWIDTH, 0, 1000);	// sLɂ
		reinterpret_cast<LPNMTTDISPINFOW>(lpNMHDR)->lpszText = m_pwszTipText;
		return true;
	}
	return false;
}

/// @see	CWindow::OnPaint
void CEditView::OnPaint(CPaintDC& dc) {
	if(IsFreezed())	// ͖
		return;
	else if(toBoolean(::IsRectEmpty(&dc.GetPaintStruct().rcPaint)))	// `̕Kvȗ̈悪łΏI
		return;

	const CEditDoc&				document = GetDocument();
	const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
	const TLayoutSettings&		layout = layoutManager.GetSettings();
	RECT						rcClient;

//	CTimer	tm(L"OnPaint");

	const length_t		cLines = document.GetLineCount();			// _s
	const length_t		cDisplayLines = GetDisplayLineCount();		// \s
	const CEditPoint&	startPoint = m_pSelection->GetStartPoint();	// IJnʒu
	const CEditPoint&	endPoint = m_pSelection->GetEndPoint();		// IIʒu
	const RECT&			rcPaint = dc.GetPaintStruct().rcPaint;		// `̕Kvȋ`
	const ushort	nLineHeight = layoutManager.GetLineHeight();
	const ushort	nVerticalRulerWidth = layoutManager.GetVerticalRulerWidth();

	// 
	dc.SetBkMode(OPAQUE);
	GetClientRect(rcClient);

	// `Jnʒu
	int			y = layout.nTopMargin;
	length_t	iLine;			// _s
	length_t	iDisplayLine;	// `Jn\s
	length_t	iOffset;

	if(rcPaint.top >= static_cast<long>(layout.nTopMargin))
		iDisplayLine = (rcPaint.top - layout.nTopMargin) / nLineHeight + m_scrollInfo.GetY();
	else
		iDisplayLine = rcPaint.top / nLineHeight + m_scrollInfo.GetY();
	iDisplayLine = min(iDisplayLine, cDisplayLines - 1);
	if(iDisplayLine < cDisplayLines) {
		GetDisplayLineOffsetIndex(iDisplayLine, iLine, iOffset);
		y += (iDisplayLine - m_scrollInfo.GetY()) * nLineHeight;
		y -= iOffset * nLineHeight;
	}

	// [̕`
	if(rcPaint.left < static_cast<long>(nVerticalRulerWidth))
		DrawVerticalRuler(dc, iDisplayLine,
			min<length_t>(cLines - 1,
				iDisplayLine + (rcPaint.bottom - rcPaint.top + nLineHeight - 1) / nLineHeight));

	// O]̕`
	if(layout.nLeadMargin != 0)
		dc.FillSolidRect(!layout.bRightAlign ?
			rcClient.left + nVerticalRulerWidth : rcClient.right - nVerticalRulerWidth - layout.nLeadMargin,
			rcPaint.top, layout.nLeadMargin, rcPaint.bottom - rcPaint.top,
			layoutManager.GetTokenFoundation(ETT_NORMAL, NullCookie).bgColor);

	// h~̂߂̃NbsO
	if(nVerticalRulerWidth + layout.nLeadMargin > 0)
		dc.ExcludeClipRect(
			!layout.bRightAlign ? rcClient.left : rcClient.right - (nVerticalRulerWidth + layout.nLeadMargin),
			rcPaint.top,
			!layout.bRightAlign ? rcClient.left + (nVerticalRulerWidth + layout.nLeadMargin) : rcClient.right,
			rcPaint.bottom);

	// `JnsŏIs܂͕܂
	if(iLine < cLines) {
		CEditDoc::LineIterator	itLine = document.GetLineIterator(iLine);
		const length_t			iDisplayCaretLine = m_pSelection->IsEmpty() ?	// Lbgs
			DisplayLineFromLogicalLine(m_pSelection->GetActivePoint().GetLineNumber()) : -1;

		for(; y < static_cast<int>(rcPaint.bottom) && iLine < cLines; ++iLine, ++itLine) {
			// _s1s`
			const bool	bCaretLine = m_pSharedData->options.appearance[SHOW_CURRENT_UNDERLINE]
										&& m_pSelection->IsEmpty()
										&& iLine == iDisplayCaretLine;
			y += DrawLine(dc, iLine, y, itLine->GetLine(), itLine->GetLineBreak(), bCaretLine) * nLineHeight;
		}
	}

	// ŏIs
	if(rcPaint.bottom > y
			&& y > static_cast<int>(layout.nTopMargin + nLineHeight - 1))
		dc.FillSolidRect(!layout.bRightAlign ? rcClient.left + nVerticalRulerWidth + layout.nLeadMargin : rcClient.left,
			y, rcClient.right - rcClient.left - (nVerticalRulerWidth + layout.nLeadMargin), rcPaint.bottom - y,
			layoutManager.GetTokenFoundation(ETT_NORMAL, NullCookie).bgColor);

	// ]̕`
	if(layout.nTopMargin > 0)
		dc.FillSolidRect(!layout.bRightAlign ? rcClient.left + nVerticalRulerWidth + layout.nLeadMargin : rcClient.left,
			rcClient.top, rcClient.right - rcClient.left - (nVerticalRulerWidth + layout.nLeadMargin), layout.nTopMargin,
			layoutManager.GetTokenFoundation(ETT_NORMAL, NullCookie).bgColor);
}

/// @see	CWindow::OnRButtonDown
void CEditView::OnRButtonDown(UINT nFlags, POINT pt) {
	if(m_nMouseOperationDisabledCount != 0)
		return;
	RESTORE_HIDDEN_CURSOR();
	if(EndAutoScroll())
		return;
	if(m_pSharedData->options.behavior[MOVE_CARET_BY_RIGHT_CLICK] && !m_pSelection->IsPointOver(pt))
		GetSelection().MoveTo(CharFromPos(pt,
			!m_pSharedData->options.behavior[ACCEPT_CARET_ON_EXTENDER_BY_MOUSE]), true);
}

/// @see	CWindow::OnSetCursor
bool CEditView::OnSetCursor(HWND hWnd, UINT nHitTest, UINT message) {
	static length_t	iDetectedUriLineLast = -1;
	POINT			pt;	// J[\ʒu
	bool			bCursorChanged = false;

	RESTORE_HIDDEN_CURSOR();

	::GetCursorPos(&pt);
	ScreenToClient(pt);

	// [ォ
	const HitTestResult	htr = HitTest(pt);
	if(htr == HTR_INDICATORMARGIN || htr == HTR_LINENUMBERS) {
		::SetCursor(::LoadCursor(0, IDC_ARROW));
		return true;
	}

	// I͈ (hbO\ǂ)
	if(m_pSharedData->options.behavior[OLE_DRAG_AND_DROP] && !m_pSelection->IsEmpty()) {
		if(m_pSelection->IsPointOver(pt)) {
			::SetCursor(::LoadCursor(0, IDC_ARROW));
			bCursorChanged = true;
		}
	}

	// Ñ|bvAbvJ[\̌`ɕςꍇ
	if(!m_autoScroll.bScrolling
			&& (m_pSharedData->options.appearance[SHOW_HAND_ON_LINK]
			|| m_pSharedData->options.appearance[SHOW_HINT_ON_LINK])) {
		char_t*	pwszUri = 0;
		if(IsOverInvokableLink(pt, pwszUri)) {	// URI
			if(m_pSharedData->options.appearance[SHOW_HINT_ON_LINK]) {	// |bvAbvo
				const length_t	iCursorDisplayLine = DisplayLineFromLogicalLine(CharFromPos(pt, true).m_iLine);
				if(iCursorDisplayLine != iDetectedUriLineLast) {
					const string_t	strPopup = QueryInvokableLinkMessage(pwszUri);
					iDetectedUriLineLast = iCursorDisplayLine;
					if(!strPopup.empty())
						ShowToolTip(strPopup, 1000, 30000);
					delete[] pwszUri;
				}
			}
			if(m_pSharedData->options.appearance[SHOW_HAND_ON_LINK] && !bCursorChanged) {	// J[\ς
				::SetCursor(::LoadCursor(0, IDC_HAND));
				bCursorChanged = true;
			}
		} else {
			iDetectedUriLineLast = -1;
			HideToolTip();
		}
	}

	return bCursorChanged;
}

/// @see	CWindow::OnSetFocus
void CEditView::OnSetFocus(HWND hwndOld) {
	_BaseView::OnSetFocus(hwndOld);

	// XN[ʒuɖ߂
	SetScrollPos(SB_HORZ, _MapInternalXToScrollBoxX(m_scrollInfo.position.x), false);
	SetScrollPos(SB_VERT, m_scrollInfo.position.y, true);

	// I͈͂ĕ`
	InvalidateLines(m_pSelection->GetStartPoint().GetLineNumber(), m_pSelection->GetEndPoint().GetLineNumber());
	UpdateWindow();

	if(hwndOld != m_hWnd) {
		// Lbg𕜊
		RecreateCaret();
		UpdateCaretPosition();
	}
}

/// @see	CWindow::OnSize
void CEditView::OnSize(UINT nType, int cx, int cy) {
	CloseCompletionWindow();

	if(nType == SIZE_MINIMIZED)
		return;

	// c[`bvɒʒm
	AutoZeroCB<TOOLINFOW>	ti;
	RECT					rcView;
	GetClientRect(rcView);
	ti.hwnd = m_hWnd;
	ti.uId = 1;
	ti.rect = rcView;
	::SendMessageW(m_hwndToolTip, TTM_NEWTOOLRECT, 0, reinterpret_cast<LPARAM>(&ti));

	// `prbg}bṽTCYύX
#ifndef ASCENSION_NO_DOUBLE_BUFFERING
	_UpdateMemoryDeviceContext();
#endif /* !ASCENSION_NO_DOUBLE_BUFFERING */

	// ܂Ԃ̍XV
	if(GetLayoutSettings().GetSettings().wrapMode == WPM_WINDOW)
		m_pSharedData->layoutManager.Invalidate(CLineLayout::PARSE_STAGE_FULL);

	// 擪s̍XV
	m_iFirstVisibleLine = LogicalCharFromDisplayChar(CCharPos(m_scrollInfo.position.y, 0)).m_iLine;
	OnVScroll(SB_THUMBTRACK, 0, 0);
	OnHScroll(SB_THUMBTRACK, 0, 0);

	UpdateScrollInfo(true, true);

	// E񂹂̏ꍇ͖őSčĕ`
	if(m_pSharedData->layoutManager.GetSettings().bRightAlign) {
		InvalidateLines(0, -1);
		UpdateCaretPosition();
	}
}

/// @see	CWindow::OnSysChar
bool CEditView::OnSysChar(UINT nChar, UINT nFlags) {
	RESTORE_HIDDEN_CURSOR();
	return false;
}

/// @see	CWindow::OnSysColorChange
void CEditView::OnSysColorChange() {
	UpdateGdiObjects();
}

/// @see	CWindow::OnSysKeyDown
bool CEditView::OnSysKeyDown(UINT nChar, UINT nFlags) {
	EndAutoScroll();
	return false;
}

/// @see	CWindow::OnSysKeyUp
bool CEditView::OnSysKeyUp(UINT nChar, UINT nFlags) {
	RESTORE_HIDDEN_CURSOR();
	return false;
}

/// @see	CWindow::OnTimer
void CEditView::OnTimer(UINT nIDEvent) {
	if(nIDEvent == TIMERID_EXPANDSELECTION
			|| nIDEvent == TIMERID_EXPANDLINESELECTION) {	// I𒆂̎XN[
		POINT	pt;
		::GetCursorPos(&pt);
		ScreenToClient(pt);
		const HitTestResult	htr = HitTest(pt);
		if(htr != HTR_INDICATORMARGIN && htr != HTR_LINENUMBERS && htr != HTR_OUTOFVIEW)
			return;
		GENERATE_SELECTED_REGION();
		GetSelection().Select(_pos[0], _pos[1], m_pSelection->IsRectangle(), true);
	} else if(nIDEvent == TIMERID_DRAGSCROLL) {	// hbO̎XN[
		const CLineLayoutManager&	layoutManager = m_pSharedData->layoutManager;
		const TLayoutSettings&		layout = layoutManager.GetSettings();
		const long					nMarginWidth = layoutManager.GetVerticalRulerWidth() + layout.nLeadMargin;
		POINT	pt;
		RECT	rect;

		::GetCursorPos(&pt);
		ScreenToClient(pt);
		GetClientRect(rect);

		if(pt.y >= rect.top &&
				pt.y <= rect.top + static_cast<long>(layout.nTopMargin + layoutManager.GetLineHeight() / 2))
			OnVScroll(SB_LINEUP, 0, 0);
		else if(pt.y >= rect.bottom - static_cast<long>(layoutManager.GetLineHeight()) && pt.y <= rect.bottom)
			OnVScroll(SB_LINEDOWN, 0, 0);
		else if(!layout.bRightAlign) {
			if(pt.x >= rect.left && pt.x <= rect.left + nMarginWidth)
				OnHScroll(SB_SETPOS, m_scrollInfo.position.x - 3, 0);
			else if(pt.x >= rect.right - static_cast<long>(layoutManager.GetAverageCharacterWidth()) && pt.y <= rect.right)
				OnHScroll(SB_SETPOS, m_scrollInfo.position.x + 3, 0);
		} else {
			int	nMinPos, nMaxPos;
			GetScrollRange(SB_HORZ, &nMinPos, &nMaxPos);
			if(pt.x >= rect.left && pt.x <= rect.left + static_cast<long>(layoutManager.GetAverageCharacterWidth()))
				OnHScroll(SB_SETPOS, nMaxPos - nMinPos - m_scrollInfo.position.x + 3, 0);
			else if(pt.x >= rect.right - nMarginWidth && pt.x <= rect.right)
				OnHScroll(SB_SETPOS, nMaxPos - nMinPos - m_scrollInfo.position.x - 3, 0);
		}
	} else if(nIDEvent == TIMERID_LINEPARSE) {	// ͂̍sǂ݂
		// ...
	} else if(nIDEvent == TIMERID_CALLTIP) {	// c[`bv\
		KillTimer(TIMERID_CALLTIP);
		::SendMessageW(m_hwndToolTip, TTM_UPDATE, 0, 0L);
	} else if(nIDEvent == TIMERID_AUTOSCROLL) {	// XN[
		POINT	pt;

		KillTimer(TIMERID_AUTOSCROLL);
		::GetCursorPos(&pt);
		ScreenToClient(pt);

		const long	nYScrollDegree =
			(pt.y - m_autoScroll.indicatorPosition.y) / static_cast<long>(m_pSharedData->layoutManager.GetLineHeight());
//		const long	nXScrollDegree =
//			(pt.x - m_autoScroll.indicatorPosition.x) / static_cast<long>(m_pSharedData->layoutManager.GetLineHeight());
//		const long	nScrollDegree = max(abs(nYScrollDegree), abs(nXScrollDegree));

		if(nYScrollDegree != 0 /*&& abs(nYScrollDegree) >= abs(nXScrollDegree)*/)
			OnVScroll((nYScrollDegree > 0) ? SB_LINEDOWN : SB_LINEUP, 0, 0);
//		else if(nXScrollDegree != 0)
//			OnHScroll((nXScrollDegree > 0) ? SB_RIGHT : SB_LEFT, 0, 0);

		if(nYScrollDegree != 0)
			SetTimer(TIMERID_AUTOSCROLL, 500 / static_cast<uint>((pow(2, abs(nYScrollDegree) / 2))), 0);
		else
			SetTimer(TIMERID_AUTOSCROLL, 300, 0);
	}
}

/// @see	WM_UNICHAR
void CEditView::OnUniChar(UINT nChar, UINT nFlags) {
#ifndef UNICODE_NOCHAR
	const UINT	UNICODE_NOCHAR = 0xFFFF;
#endif /* !UNICODE_NOCHAR */
	if(nChar != UNICODE_NOCHAR) {
		// GUI [U̓͂JnJ[\
		if(StandardCommands::CCharacterInputCommand(*this, nChar).Execute() != 0
				&& !m_modeState.bCursorHiddenForCharInput
				&& m_pSharedData->options.appearance[HIDE_CURSOR_FOR_CHAR_INPUT]
				&& HasFocus()) {
			POINT	pt;

			// J[\Xbh̃EBhEɖƑʖ
			::GetCursorPos(&pt);
			if(::GetWindowThreadProcessId(::WindowFromPoint(pt), 0) == GetWindowThreadId()) {
				m_modeState.bCursorHiddenForCharInput = true;
				::ShowCursor(false);
				SetCapture();
			}
		}
		if(m_bActiveImeComposition)
			UpdateImeCompositionWindowPosition();
	}
}

///	@see	CWindow::OnVScroll
void CEditView::OnVScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar) {
	int						nNewPos = m_scrollInfo.position.y;
	int						nMinPos, nMaxPos;	// őAŏʒu
	const length_t			cVisibleLines = GetVisibleLineCount();
	const TLayoutSettings&	layout = GetLayoutSettings().GetSettings();

	GetScrollRange(SB_VERT, &nMinPos, &nMaxPos);
	if(GetDocument().IsNarrowed()) {
		if(cVisibleLines + 1 > GetDocument().GetStartPoint().m_iLine)
			nMinPos = max(nMinPos, 0);
		else
			nMinPos = max<length_t>(nMinPos,
				(GetDocument().GetStartPoint().m_iLine - cVisibleLines + 1) / m_scrollInfo.nVerticalRatio);
		nMaxPos = min<length_t>(nMaxPos,
			(GetDocument().GetEndPoint().m_iLine + cVisibleLines - 1) / m_scrollInfo.nVerticalRatio);
	}

//	if(m_pCompletionWindow->IsRunning())
//		m_pCompletionWindow->Abort();
	if(cVisibleLines > (nMaxPos - nMinPos) * m_scrollInfo.nVerticalRatio) {
		m_scrollInfo.position.y = 0;
//		DrawVerticalRuler(0, GetVisibleLineCount());
		return;
	}

	switch(nSBCode) {
	case SB_LINEUP:		// 1s
		--nNewPos;	break;
	case SB_LINEDOWN:	// 1s
		++nNewPos;	break;
	case SB_PAGEUP:		// 1y[W
		nNewPos -= GetVisibleLineCount() - 1;	break;
	case SB_PAGEDOWN:	// 1y[W
		nNewPos += GetVisibleLineCount() - 1;	break;
	case SB_TOP:		// [
		nNewPos = nMinPos;	break;
	case SB_BOTTOM:		// [
		nNewPos = nMaxPos;	break;
	case SB_THUMBTRACK:	// hbO or zC[
		nNewPos = GetScrollTrackPos(SB_VERT);	break;	// 32rbglg
	case SB_SETPOS:		// IȃXN[
		nNewPos = nPos;	break;
	default:
		return;
	}

	if(IsFreezed()) {	// 𓀎ɂ炽߂ăXN[
		SetScrollPos(SB_VERT, m_freezeInfo.scrollPosition.y = nNewPos, false);
		return;
	}

	// 
	nNewPos = max<long>(nNewPos, nMinPos);
	nNewPos = min<long>(nNewPos, nMaxPos - GetVisibleLineCount() + 1);

	if(nNewPos == m_scrollInfo.position.y)	// XN[Ȃ
		return;

	// 擪s̍XV
//	if(nNewPos - m_scrollInfo.position.y == 1)

	// ĕ`Ȃ
	if(dif<long>(nNewPos, m_scrollInfo.position.y) < cVisibleLines - 1) {	// XN[ʂ1y[Wȉ
		RECT		rcScroll;			// XN[Ώ
		const int	dy = (m_scrollInfo.position.y - nNewPos) *
			m_scrollInfo.nVerticalRatio * m_pSharedData->layoutManager.GetLineHeight();

		GetClientRect(rcScroll);
		RECT	rcUpdate = rcScroll;
		rcScroll.top = layout.nTopMargin;
		if(dy > 0) {
			rcUpdate.top += layout.nTopMargin;
			rcUpdate.bottom = rcUpdate.top + dy;
		} else
			rcUpdate.top = rcUpdate.bottom + dy;
		ScrollWindowEx(0, dy, &rcScroll, &rcScroll, 0, 0, SW_INVALIDATE);
		InvalidateRect(&rcUpdate, false);
	} else
		InvalidateRect(0, false);

	HideToolTip();
	SetScrollPos(SB_VERT, nNewPos);
	m_scrollInfo.position.y = nNewPos;
	UpdateCaretPosition();
	if(m_bActiveImeComposition)
		UpdateImeCompositionWindowPosition();
	UpdateWindow();

	CloseCompletionWindow();
}

#undef ABORT_ISEARCH
#undef ABORT_ABBR
#undef BEGIN_WORDUNIT_SELECTION
#undef GENERATE_SELECTED_REGION
#undef RESTORE_HIDDEN_CURSOR

/* [EOF] */