// EditPoint.h
// (c) 2003-2005 exeal

#ifndef _EDIT_POINT_H_
#define _EDIT_POINT_H_
#include "AscensionCommon.h"


#define VERIFY_DOCUMENT()		\
	if(IsDocumentDisposed())	\
		throw EDocumentIsAlreadyDisposed()


namespace Ascension {
	class CCharPos;
	struct TDocumentUpdate;
	class CEditView;

	/// ͈͂̃eLXgϊ`
	/// @see	CEditPoint::Convert
	enum RangeConvertType {
		RCT_UPPERCASE_SIMPLE,		///< 啶ɕϊ (P)
		RCT_LOWERCASE_SIMPLE,		///< ɕϊ (P)
		RCT_CAPITALIZE_SIMPLE,		///< Ls^CY (P)
		RCT_UPPERCASE_FULL,			///< 啶ɕϊ (S)
		RCT_LOWERCASE_FULL,			///< ɕϊ (S)
		RCT_CAPITALIZE_FULL,		///< Ls^CY (S)
		RCT_HIRAGANA,				///< ɕϊ
		RCT_KATAKANA,				///< Љɕϊ
		RCT_SIMPLIFIED_CHINESE,		///< ȑ̎ɕϊ
		RCT_TRADITIONAL_CHINESE,	///< ɑ̎ɕϊ
		RCT_FULLWIDTH,				///< Spɕϊ
		RCT_HALFWIDTH,				///< pɕϊ
		RCT_TABIFY,					///< 󔒕^uɕϊ
		RCT_UNTABIFY,				///< ^u󔒕ɕϊ
		RCT_ARABICDIGIT,			///< ArAɕϊ
		RCT_REMOVE_NONSPACE,		///< ꏊƂȂ폜
		RCT_REMOVE_ARABICKASHIDA,	///< ArÃJV_폜
		RCT_COMPOSE,				///< Ɍ
		RCT_DECOMPOSE,				///< 𕪉
	};

	/// 쐬̃hLgɖ CEditPoint IuWFNgLłȂƂ\O
	class EDocumentIsAlreadyDisposed {
	public:
		/// Ԃ
		std::string	GetDescription() const {
			return "Target document is already inavailable. This object is no longer able to be used anyway.";
		}
	};

	/// CAEg񂪕Kvȃ\bhĂяoACAEgێr[1Ƃ\O
	class ELayoutIsNotPrepared {
	public:
		/// Ԃ
		std::string	GetDescription() const {
			return "Though specified command needs layout information, that cannot obtain.";
		}
	};


	/**
	 *	@brief	hLg̕ύXɒǏ]Ĉړu_v
	 *	@see	CCharPos, CEditPoint, CVisualPoint
	 */
	class CSynchronizablePoint : public Manah::CSelfAssertable,
			public Manah::CUnassignable/*, public Manah::CUseMemoryPool<CSynchronizablePoint>*/ {
		// RXgN^
	protected:
		CSynchronizablePoint(CEditDoc& document);
		CSynchronizablePoint(const CSynchronizablePoint& rhs);
	public:
		virtual ~CSynchronizablePoint();

		// Zq
	public:
		operator CCharPos() {return m_position;}
		operator const CCharPos() const {return m_position;}
	protected:
		CSynchronizablePoint& operator =(const CCharPos& rhs) {m_position = rhs;}

		// \bh
	public:
		void			ExcludeFromRestriction(bool bExclude) throw(EDocumentIsAlreadyDisposed);
		CEditDoc*		GetDocument() const;
		CCharPos		GetPosition() const;
		bool			IsDocumentDisposed() const;
		bool			IsExcludedFromRestriction() const throw(EDocumentIsAlreadyDisposed);
		bool			IsSynchronousWithDocumentUpdate() const throw(EDocumentIsAlreadyDisposed);
		virtual void	MoveTo(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed);
		void			SynchronizeWithDocumentUpdate(bool bSync) throw(EDocumentIsAlreadyDisposed);
	protected:
		void			IgnoreDocumentUpdate(bool bIgnore);
		virtual void	Normalize() const throw(EDocumentIsAlreadyDisposed);
		void			OnDocumentDestroyed();
		void			OnUpdateDocument(const TDocumentUpdate& update);

		// f[^o
	protected:
		CCharPos	m_position;
		CEditDoc*	m_pDocument;
	private:
		bool	m_bSync;
		bool	m_bIgnoreDocumentUpdate;								// ꎞI OnUpdateDocument 𖳎
		bool	m_bExcludedFromRestriction;
		void(*m_releaser)(CEditDoc& document, CSynchronizablePoint&);	// j󎞂ɌĂяo (CEditDoc ̕ҏW_쐬\bhŐݒ肳)
		friend class CEditDoc;
	};

	inline bool operator ==(const CSynchronizablePoint& lhs, const CSynchronizablePoint& rhs)
	{return lhs.GetPosition() == rhs.GetPosition();}
	inline bool operator !=(const CSynchronizablePoint& lhs, const CSynchronizablePoint& rhs)
	{return lhs.GetPosition() != rhs.GetPosition();}
	inline bool operator <(const CSynchronizablePoint& lhs, const CSynchronizablePoint& rhs)
	{return lhs.GetPosition() < rhs.GetPosition();}
	inline bool operator <=(const CSynchronizablePoint& lhs, const CSynchronizablePoint& rhs)
	{return lhs.GetPosition() <= rhs.GetPosition();}
	inline bool operator >(const CSynchronizablePoint& lhs, const CSynchronizablePoint& rhs)
	{return lhs.GetPosition() > rhs.GetPosition();}
	inline bool operator >=(const CSynchronizablePoint& lhs, const CSynchronizablePoint& rhs)
	{return lhs.GetPosition() >= rhs.GetPosition();}

	/**
	 *	@brief	GfB^ŕҏWAړ\ȁu_vB^Lbg
	 *
	 *	CEditView ̃NCAg͑I͈͂LbgʒuƂăeLXgҏWł邪A
	 *	̃NXɂCӂ̏ꏊ̕ҏW\ƂȂBNCAǵu_vҏWӏɈړA
	 *	CEditView ̑Ǝ@ŕҏWs
	 *
	 *	ҏW_ɂhLg̕ύXsƁAAҏW_͓K؂ȈʒuɈړB
	 *	Ⴆ n ̕}ƌ݈ʒu n i߂
	 *
	 *	ҏW_͑̕ҏWł̈ʒuύXB CEditPoint::SynchronizeWithOtherEdit
	 *	\bhgΕύXȂ悤ɂ邱Ƃł
	 *
	 *	܂A̕ҏWɂ̂܂߂AҏW_̂ړɂ2̋KKpB
	 *	1ڂ̓obt@̗_IȈʒuɂ̂ŁA݂Ȃ񂩂ŏIցA
	 *	폜ꂽsŏIsւ̈ړIɍs (I CEditPoint::Normalize
	 *	gĂ)B2ڂ͕ɂ̂ŁATQ[gyÅԂ炢ꂩ̃TQ[g̑OցA
	 *	extender ̑O炻̕NX^̑Oւ̈ړsB
	 *	҂̋ CEditPoint::SetUnitBehavior Őł
	 *
	 *	PʁAPPʂŕҏW_̈ړs\bĥAO Left y Right
	 *	ŏIĂ̂́A_ł͂ȂAo̕w肷B
	 *	̓Iɂ̓r[̃eLXgEł XxxxLeft  XxxxPrev ɁAE獶ł
	 *	XxxxLeft  XxxxNext Ƀ}bvB王o̕x[Xɂ\bh́A
	 *	L[{[hȂǂ̃[UC^[tFCXړsƂlĒ񋟂Ă
	 *
	 *	CEditPoint ɂhLg̃Z}eBNXɂĂ
	 *	CEditView::OnUpdate ̉
	 *
	 *	RXgN^ARs[RXgN^͔JłB쐬ɂ CEditView::CreateEditPoint \bhA
	 *	Rs[ɂ CEditDoc::CopyEditPoint \bhgBjɂ͌JfXgN^ (delete) g
	 *
	 *	SẴ\bh̓hLg̃AhDO[v\bhĂяos<strong>Ȃ</strong>B
	 *	āA1܂Ƃ߂ɂꍇ̓NCAg CEditDoc::BeginEditCollection ĂяoȂ΂ȂȂ
	 *
	 *	̃NX̂قƂǂ̃\bh́AΏۃhLgɑ݂Ȃꍇ
	 *	EDocumentIsAlreadyDisposed OX[
	 *
	 *	@see	CEditView, CEditDoc, CSelection, EDocumentIsAlreadyDisposed
	 */
	class CEditPoint : public CSynchronizablePoint {
	public:
		/// ̐BsȈʒu̎C̋ (CEditPoint Q)
		enum CharacterCountingConvention {
			CCC_UTF16,		///< UTF-16 P
			CCC_UTF32,		///< UTF-32 PʁBTQ[gyA1Ƃ݂Ȃ
			CCC_CLUSTER,	///< NX^PʁBTQ[gyAA1Ƃ݂Ȃ
//			CCC_GLYPH,		///< OtP
			CCC_DEFAULT,	///<  (CEditPoint::Delete ł̂ݎgp)
		};

		/// Cxgnh
		interface IEventListener {
			/// fXgN^
			virtual ~IEventListener() {}
			/// _j󂳂ꂽ
			virtual void OnEditPointDestroyed() = 0;
			/**
			 *	_ړ
			 *	@param self			̓_
			 *	@param oldPosition	ړÖʒu
			 */
			virtual void OnEditPointMoved(const CEditPoint& self, const CCharPos& oldPosition) = 0;
		};

		// RXgN^
	protected:
		CEditPoint(CEditDoc& document, IEventListener* pEventListener = 0);
		CEditPoint(const CEditPoint& rhs);
	public:
		virtual ~CEditPoint();

		// \bh
	public:
		/*  */
		length_t					GetAbsoluteCharOffset() const throw(EDocumentIsAlreadyDisposed);
		CharacterCountingConvention	GetCharacterCountingConvention() const throw(EDocumentIsAlreadyDisposed);
		length_t					GetCharNumber() const throw(EDocumentIsAlreadyDisposed);
		CodePoint					GetCodePoint() const throw(EDocumentIsAlreadyDisposed);
		length_t					GetLineLength() const throw(EDocumentIsAlreadyDisposed);
		length_t					GetLineNumber() const throw(EDocumentIsAlreadyDisposed);
		string_t					GetText(signed_length_t cch) const throw(EDocumentIsAlreadyDisposed);
		string_t					GetText(const CCharPos& pos) const throw(EDocumentIsAlreadyDisposed);
		bool						IsEndOfDocument() const throw(EDocumentIsAlreadyDisposed);
		bool						IsEndOfLine() const throw(EDocumentIsAlreadyDisposed);
		bool						IsStartOfDocument() const throw(EDocumentIsAlreadyDisposed);
		bool						IsStartOfLine() const throw(EDocumentIsAlreadyDisposed);
		void						SetCharacterCountingConvention(CharacterCountingConvention convention);

		/*  : ړ */
		void			CharNext(length_t cch = 1) throw(EDocumentIsAlreadyDisposed);
		void			CharPrev(length_t cch = 1) throw(EDocumentIsAlreadyDisposed);
		virtual void	MoveTo(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed);
		void			MoveToAbsoluteCharOffset(length_t nOffset) throw(EDocumentIsAlreadyDisposed);
		void			MoveToEndOfDocument() throw(EDocumentIsAlreadyDisposed);
		void			MoveToEndOfLine() throw(EDocumentIsAlreadyDisposed);
		void			MoveToStartOfDocument() throw(EDocumentIsAlreadyDisposed);
		void			MoveToStartOfLine() throw(EDocumentIsAlreadyDisposed);

		/*  (ҏW) */
		void			Convert(signed_length_t cch, RangeConvertType type) throw(EDocumentIsAlreadyDisposed);
		void			Convert(const CCharPos& pos, RangeConvertType type) throw(EDocumentIsAlreadyDisposed);
		void			Copy(signed_length_t cch) throw(EDocumentIsAlreadyDisposed);
		void			Copy(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed);
		void			Cut(signed_length_t cch) throw(EDocumentIsAlreadyDisposed);
		void			Cut(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed);
		void			Delete(signed_length_t cch = 1,
							CharacterCountingConvention ccc = CCC_DEFAULT) throw(EDocumentIsAlreadyDisposed);
		void			Delete(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed);
		void			DestructiveInsert(const string_t& text) throw(EDocumentIsAlreadyDisposed);
		void			DestructiveInsert(const char_t* first, const char_t* last) throw(EDocumentIsAlreadyDisposed);
		void			Insert(const string_t& text) throw(EDocumentIsAlreadyDisposed);
		void			Insert(const char_t* first, const char_t* last) throw(EDocumentIsAlreadyDisposed);
		virtual void	NewLine() throw(EDocumentIsAlreadyDisposed);
		void			Paste(signed_length_t cch = 0) throw(EDocumentIsAlreadyDisposed);
		virtual void	Paste(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed);
	protected:
		static CCharPos	GetNextCharPos(const CEditPoint& pt, length_t cch, CharacterCountingConvention ccc = CCC_DEFAULT);
		static CCharPos	GetPrevCharPos(const CEditPoint& pt, length_t cch, CharacterCountingConvention ccc = CCC_DEFAULT);

		// f[^o
	protected:
		IEventListener* const	m_pEventListener;	// CxgXi
	private:
		CharacterCountingConvention	m_charCountConvention;	// ̌vZ@ (^`Q)
	};


	/**
	 *	ҏW_̑̂Ãr[ɑ΂čp̂ACAEgQƂ鑀`
	 *	@see	CEditPoint, ELayoutIsNotPrepared
	 */
	class CVisualPoint : public CEditPoint {
		// RXgN^
	protected:
		CVisualPoint(CEditDoc& document, IEventListener* pEventListener = 0);
		CVisualPoint(const CVisualPoint& rhs);
	public:
		virtual ~CVisualPoint();

		// \bh
	public:
		/*  */
		length_t	GetColumnNumber() const throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		bool		IsFirstCharOfLine() const throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		bool		IsLastCharOfLine() const throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);

		/*  : ړ */
		void			CharLeft(length_t cch = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			CharRight(length_t cch = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			LineDown(length_t cLines = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			LineUp(length_t cLines = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		virtual void	MoveTo(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			MoveToFirstCharOfLine() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			MoveToLastCharOfLine() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			MoveToNextBookmark() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			MoveToPrevBookmark() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			PageDown(length_t cPages = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			PageUp(length_t cPages = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			WordEndLeft(length_t cWords = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			WordEndNext(length_t cWords = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			WordEndPrev(length_t cWords = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			WordEndRight(length_t cWords = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			WordNext(length_t cWords = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			WordPrev(length_t cWords = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			WordLeft(length_t cWords = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void			WordRight(length_t cWords = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);

		/*  : r[̃XN[ */
		bool	Center(CEditView& view, signed_length_t cch = 0) throw(std::invalid_argument, EDocumentIsAlreadyDisposed);
		bool	Center(CEditView& view, const CCharPos& pos) throw(std::invalid_argument, EDocumentIsAlreadyDisposed);
		bool	Reveal(CEditView& view, signed_length_t cch = 0) throw(std::invalid_argument, EDocumentIsAlreadyDisposed);
		bool	Reveal(CEditView& view, const CCharPos& pos) throw(std::invalid_argument, EDocumentIsAlreadyDisposed);

		/*  : ҏW */
		void		InsertBox(const string_t& text) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void		InsertBox(const char_t* first, const char_t* last) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void		NewLine() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void		Paste(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		CCharPos	SpaceIndent(const CCharPos& pos, bool bBox, long nLevel = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		CCharPos	TabIndent(const CCharPos& pos, bool bBox, long nLevel = 1) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		bool		TransposeChars() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		bool		TransposeLines() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		bool		TransposeWords() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);

	protected:
		virtual const CEditView&	GetView() const;
	private:
		CCharPos	_Indent(const CCharPos& pos, char_t chIndent,
						bool bBox, long nLevel) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared);
		void		_MoveTo(const CCharPos& pos, bool bUpdateLastX);
		void		_UpdateLastX();

		// f[^o
	private:
		struct {
			bool	bFromLeftEnd;	// [̋̏ꍇ true
			ulong	nDistance;		// 
		} m_lastX;					// _́As\̈[̋BLineDown ALineUp ňړƂɕێĂ
		friend class CEditDoc;
	};


	/// RXgN^
	inline CSynchronizablePoint::CSynchronizablePoint(CEditDoc& document)
			: m_pDocument(&document), m_bSync(false),
			m_bIgnoreDocumentUpdate(false), m_bExcludedFromRestriction(false), m_releaser(0) {
	}

	/// Rs[RXgN^
	inline CSynchronizablePoint::CSynchronizablePoint(const CSynchronizablePoint& rhs) :
			m_position(rhs.m_position), m_pDocument(rhs.m_pDocument),
			m_bIgnoreDocumentUpdate(false), m_bSync(rhs.m_bSync), m_releaser(rhs.m_releaser) {
		// Jɂ邽߂ɎŒ`Ă...
	}

	/// fXgN^
	inline CSynchronizablePoint::~CSynchronizablePoint() {
		if(m_pDocument != 0)
			(*m_releaser)(*m_pDocument, *this);
	}

	/// i[CÕANZXs\̈ւ̐N֎~邩ݒ肷
	inline void CSynchronizablePoint::ExcludeFromRestriction(bool bExclude) throw(EDocumentIsAlreadyDisposed) {
		AssertValid();
		VERIFY_DOCUMENT();
		if(m_bExcludedFromRestriction = bExclude)
			Normalize();
	}

	/// 쐬hLgԂ
	inline CEditDoc* CSynchronizablePoint::GetDocument() const {
		AssertValid();
		return m_pDocument;
	}

	/// ʒuԂ
	inline CCharPos CSynchronizablePoint::GetPosition() const {
		AssertValid();
		return m_position;
	}

	/// OnUpdateDocument ĂяoꎞIɖ
	inline void CSynchronizablePoint::IgnoreDocumentUpdate(bool bIgnore) {
		AssertValid();
		m_bIgnoreDocumentUpdate = bIgnore;
	}

	/// 쐬hLgłɔjĂ true Ԃ
	inline bool CSynchronizablePoint::IsDocumentDisposed() const {
		AssertValid();
		return m_pDocument == 0;
	}

	/// ANZXs\̈ɐNłȂꍇ true Ԃ
	inline bool CSynchronizablePoint::IsExcludedFromRestriction() const throw(EDocumentIsAlreadyDisposed) {
		AssertValid();
		return m_bExcludedFromRestriction;
	}

	/// hLg̍XVɓĈړꍇ true Ԃ
	inline bool CSynchronizablePoint::IsSynchronousWithDocumentUpdate() const throw(EDocumentIsAlreadyDisposed) {
		AssertValid();
		VERIFY_DOCUMENT();
		return m_bSync;
	}

	/// 쐬hLgj󂳂ꂽƂɌĂяo
	inline void CSynchronizablePoint::OnDocumentDestroyed() {
		AssertValid();
		m_pDocument = 0;
	}

	/// hLg̍XVɓĈړ邩ݒ肷
	inline void CSynchronizablePoint::SynchronizeWithDocumentUpdate(bool bSync) throw(EDocumentIsAlreadyDisposed) {
		AssertValid();
		VERIFY_DOCUMENT();
		m_bSync = bSync;
	}

	/// vZ@Ԃ
	inline CEditPoint::CharacterCountingConvention CEditPoint::GetCharacterCountingConvention() const throw(EDocumentIsAlreadyDisposed) {
		AssertValid();
		VERIFY_DOCUMENT();
		return m_charCountConvention;
	}

	/// ԍԂ (UTF-16 P)
	inline length_t CEditPoint::GetCharNumber() const throw(EDocumentIsAlreadyDisposed) {
		AssertValid();
		VERIFY_DOCUMENT();
		return m_position.m_iChar;
	}

	/// sԍԂ
	inline length_t CEditPoint::GetLineNumber() const throw(EDocumentIsAlreadyDisposed) {
		AssertValid();
		VERIFY_DOCUMENT();
		return m_position.m_iLine;
	}

	/// vZ@̐ݒ
	inline void CEditPoint::SetCharacterCountingConvention(
			CEditPoint::CharacterCountingConvention convention) throw(EDocumentIsAlreadyDisposed) {
		AssertValid();
		VERIFY_DOCUMENT();
		assert(convention != CCC_DEFAULT);
		m_charCountConvention = convention;
	}
} /* namespace Ascension */

#endif /* _EDIT_POINT_H_ */

/* [EOF] */