// EditPoint.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "EditPoint.h"
#include "EditView.h"
#include "../../Manah/win_utils.h"

using namespace Ascension;
using namespace Manah;
using namespace Manah::Windows;
using namespace std;


// CSynchronizablePoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	@brief	_Ɉړ
 *
 *	hNX͓_ړ̂ɂ̃\bhgȂ΂ȂȂ
 *	@param pos	ړ
 */
void CSynchronizablePoint::MoveTo(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	if(m_position != pos) {
		m_position = pos;
		Normalize();
	}
}

/**
 *	@brief	ʒuɈړ
 *
 *	̃\bh͓_̈ړCxgXiɒʒmȂ)
 */
void CSynchronizablePoint::Normalize() const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	CCharPos&	position = const_cast<CSynchronizablePoint*>(this)->m_position;
	position.m_iLine = min(position.m_iLine, m_pDocument->GetLineCount() - 1);
	position.m_iChar = min(position.m_iChar, m_pDocument->GetLineLength(position.m_iLine));
	if(m_pDocument->IsNarrowed() && m_bExcludedFromRestriction) {
		position = max(m_position, m_pDocument->GetStartPoint());
		position = min(m_position, m_pDocument->GetEndPoint());
	}
}

/**
 *	hLgύXꂽƂɌĂяo
 *	@param update	XVe
 */
void CSynchronizablePoint::OnUpdateDocument(const TDocumentUpdate& update) {
	AssertValid();
	if(m_pDocument == 0 || m_bIgnoreDocumentUpdate)
		return;

//	Normalize();
	CCharPos	newPosition = m_position;

	// hLg̕ύXɍ킹Ĉʒu𒲐
	if(update.summary == TDocumentUpdate::INSERT_OPERATION) {	// }̏ꍇ
		if(m_position < update.posBegin)	// ݈ʒu
			return;
		else if(m_position.m_iLine > update.posBegin.m_iLine)	// ݍsO
			newPosition.m_iLine += update.posResult.m_iLine - update.posBegin.m_iLine;
		else {	// ݍsƓs
			newPosition.m_iLine += update.posResult.m_iLine - update.posBegin.m_iLine;
			newPosition.m_iChar += update.posResult.m_iChar - update.posBegin.m_iChar;
		}
	} else if(update.summary == TDocumentUpdate::DELETE_OPERATION) {	// 폜̏ꍇ
		if(m_position < update.posEnd)	// ݈ʒu
			return;
		else if(m_position.m_iLine > update.posEnd.m_iLine)	// ݍsO
			newPosition.m_iLine -= update.posEnd.m_iLine - update.posBegin.m_iLine;
		else if(m_position >= update.posBegin && m_position <= update.posEnd) {	// ͈͓
			newPosition.m_iLine = update.posBegin.m_iLine;
			newPosition.m_iChar = update.posBegin.m_iChar;
		} else {	// I_ݍsƓs
			if(m_position.m_iLine == update.posBegin.m_iLine)	// ͈͂1s
				newPosition.m_iChar -= update.posEnd.m_iChar - update.posBegin.m_iChar;
			else {	// ͈͂s
				newPosition.m_iLine -= update.posEnd.m_iLine - update.posBegin.m_iLine;
				newPosition.m_iChar -= update.posEnd.m_iChar - update.posBegin.m_iChar;
			}
		}
	} else
		return;
	MoveTo(newPosition);
}


// CEditPoint class implementation
/////////////////////////////////////////////////////////////////////////////

#define VERIFY_VIEW()					\
	VERIFY_DOCUMENT();					\
	if(m_pDocument->GetCount() == 0)	\
		throw ELayoutIsNotPrepared()
#define PREPARE_X()																		\
	if(GetView().GetLayoutSettings().GetSettings().bRightAlign == m_lastX.bFromLeftEnd)	\
		_UpdateLastX();																	\
	const int	x = m_lastX.bFromLeftEnd ? m_lastX.nDistance :							\
		GetView().m_pSharedData->layoutManager.GetLine(iNewLine).GetWidth() - m_lastX.nDistance

/**
 *	RXgN^
 *	@param document			Ώۂ̃hLg
 *	@paran pEventListener	CxgXi
 */
CEditPoint::CEditPoint(CEditDoc& document, CEditPoint::IEventListener* pEventListener /* = 0 */)
		: CSynchronizablePoint(document), m_pEventListener(pEventListener), m_charCountConvention(CCC_CLUSTER) {
}

/// Rs[RXgN^
CEditPoint::CEditPoint(const CEditPoint& rhs) :
		CSynchronizablePoint(rhs), m_pEventListener(rhs.m_pEventListener), m_charCountConvention(rhs.m_charCountConvention) {
	// Jɂ邽߂ɎŒ`Ă...
}

///	fXgN^
CEditPoint::~CEditPoint() {
	if(m_pEventListener != 0)
		m_pEventListener->OnEditPointDestroyed();
}

/**
 *	̕Ɉړ
 *	@param cch	ړ邩
 */
void CEditPoint::CharNext(length_t cch /* = 1 */) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	Normalize();
	MoveTo(GetNextCharPos(*this, cch));
}

/**
 *	O̕Ɉړ
 *	@param cch	ړ邩
 */
void CEditPoint::CharPrev(length_t cch /* = 1 */) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	Normalize();
	MoveTo(GetPrevCharPos(*this, cch));
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param cch	1̈ʒu܂ł̕ (ł悢)
 *	@param type	ϊ̎
 */
void CEditPoint::Convert(signed_length_t cch, RangeConvertType type) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly())
		return;

	CEditPoint	pt(*this);

	if(cch > 0)
		pt.m_position = GetNextCharPos(pt, cch);
	else {	// 폜̏ꍇ͌ȕ폜
		while(cch++ != 0) {
			if(pt.m_position.m_iChar == 0) {
				if(pt.m_position.m_iLine == 0)
					break;
				--pt.m_position.m_iLine;
				pt.m_position.m_iChar = m_pDocument->GetLineLength(pt.m_position.m_iLine);
			} else
				--pt.m_position.m_iChar;
		}
	}
	Convert(pt, type);
}

/**
 *	wʒu܂ł̃eLXgϊ
 *	@param pos	1̈ʒu
 *	@param type	ϊ̎ށBw͕s
 */
void CEditPoint::Convert(const CCharPos& pos, RangeConvertType type) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly() || m_position == pos)
		return;

//	if(type == RCT)
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param cch	Rs[镶 (ł悢)
 */
void CEditPoint::Copy(signed_length_t cch) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	const string_t	str = GetText(cch);
	CClipboard::SetClipboardText(0, str.data(), str.length());
}

/**
 *	wʒu܂ł̃eLXgNbv{[hɃRs[
 *	@param pos	1̈ʒu
 */
void CEditPoint::Copy(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	const string_t	str = GetText(pos);
	CClipboard::SetClipboardText(0, str.data(), str.length());
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param cch	폜镶 (ł悢)
 */
void CEditPoint::Cut(signed_length_t cch) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly())
		return;
	const string_t	str = GetText(cch);
	CClipboard::SetClipboardText(0, str.data(), str.length());
	Delete(cch);
}

/**
 *	wʒu܂ł̃eLXg폜ăNbv{[hɃRs[
 *	@param pos	1̈ʒu
 */
void CEditPoint::Cut(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly())
		return;
	const string_t	str = GetText(pos);
	CClipboard::SetClipboardText(0, str.data(), str.length());
	Delete(pos);
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param cch	1̈ʒu܂ł̕ (ł悢)
 *	@param ccc	̌vZ@BCCC_DEFAULT w肷ƌ݂̐ݒ肪gp
 */
void CEditPoint::Delete(signed_length_t cch /* = 1 */,
		CEditPoint::CharacterCountingConvention ccc /* = CCC_DEFAULT */) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly() || cch == 0)
		return;

	CEditPoint	pt(*this);

	if(cch > 0)
		pt.m_position = GetNextCharPos(pt, cch);
	else {	// 폜̏ꍇ͌ȕ폜
		while(cch++ != 0) {
			if(pt.m_position.m_iChar == 0) {
				if(pt.m_position.m_iLine == 0)
					break;
				--pt.m_position.m_iLine;
				pt.m_position.m_iChar = m_pDocument->GetLineLength(pt.m_position.m_iLine);
			} else
				--pt.m_position.m_iChar;
		}
	}
	Delete(pt);
}

/**
 *	wʒu܂ł̃eLXg폜
 *	@param pos	1̈ʒu
 */
void CEditPoint::Delete(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly() || pos == m_position)
		return;
	IgnoreDocumentUpdate(true);
	MoveTo(m_pDocument->DeleteText(CTextRange(m_position, pos)));
	IgnoreDocumentUpdate(false);
}

/**
 *	_̈ʒũeLXg폜ĕ}B݈ʒu͓͕i߂
 *	@param text	}eLXg
 */
void CEditPoint::DestructiveInsert(const string_t& text) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	DestructiveInsert(text.data(), text.data() + text.length());
}

/**
 *	_̈ʒũeLXg폜ĕ}B݈ʒu͓͕i߂
 *	@param first, last	}eLXg
 */
void CEditPoint::DestructiveInsert(const char_t* first, const char_t* last) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly())
		return;

	CEditPoint	pos(*this);

	pos.CharNext();
	m_pDocument->BeginEditCollection();
	IgnoreDocumentUpdate(true);
	m_pDocument->DeleteText(CTextRange(m_position, pos));
	MoveTo(m_pDocument->InsertText(m_position, first, last));
	IgnoreDocumentUpdate(false);
	m_pDocument->EndEditCollection();
}

/// hLg̐擪 (i[COĂꍇ̓ANZX\̈̐擪)
/// ̕Ԃ (UTF-16 PʁAs1)
length_t CEditPoint::GetAbsoluteCharOffset() const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	length_t				nOffset = 0;
	const CCharPos			posStart = m_pDocument->GetStartPoint();
	CEditDoc::LineIterator	itLines = m_pDocument->GetLineIterator(posStart.m_iLine);

	Normalize();
	for(length_t iLine = posStart.m_iLine; ; ++iLine, ++itLines) {
		if(iLine == m_position.m_iLine) {
			nOffset += m_position.m_iChar;
			break;
		} else {
			nOffset += itLines->GetLine().length() + 1;	// +1 ͉s
			if(iLine == posStart.m_iLine)
				nOffset -= posStart.m_iChar;
		}
	}
	return nOffset;
}

/// ݈ʒũR[h|CgԂBs̏ꍇ͎ۂ̉sR[hɊ֌W 0x000A A
/// ̖̏ꍇ 0xFFFFFFFF Ԃ
CodePoint CEditPoint::GetCodePoint() const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	const string_t&	strLine = m_pDocument->GetLine(m_position.m_iLine);
	if(m_position.m_iChar == strLine.length())
		return (m_position.m_iLine == m_pDocument->GetLineCount() - 1) ? 0xFFFFFFFF : 0x000A;
	return DecodeUtf16SurrogatesToCodePoint(strLine.data() + m_position.m_iChar, strLine.length() - m_position.m_iChar);
}

/// _s̒Ԃ (UTF-16 P)
length_t CEditPoint::GetLineLength() const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	Normalize();
	return m_pDocument->GetLineLength(m_position.m_iLine);
}

/**
 *	^ꂽʒuw蕶i񂾈ʒuԂ
 *	@param pt	ʒu
 *	@param cch	
 *	@param ccc	vZ@Bȗ <var>pt</var> ̐ݒl
 */
CCharPos CEditPoint::GetNextCharPos(const CEditPoint& pt,
		length_t cch, CEditPoint::CharacterCountingConvention ccc /* = CCC_DEFAULT */) {
	const length_t	cLines = pt.m_pDocument->GetLineCount();
	string_t		strLine = pt.m_pDocument->GetLine(pt.m_position.m_iLine);
	const char_t* 	pwszLine = strLine.data();
	CCharPos		pos = pt;

	if(ccc == CCC_DEFAULT)
		ccc = pt.m_charCountConvention;
	while(cch-- > 0) {
		if(pos.m_iChar == strLine.length()) {	// sȂ̂Ŏ̍sɈړ
			if(pos.m_iLine == cLines - 1)	// ŏIsłΈړȂ
				return pos;
			strLine = pt.m_pDocument->GetLine(++pos.m_iLine);
			pwszLine = strLine.data();
			pos.m_iChar = 0;
		} else if(ccc == CCC_UTF16)
			++pos.m_iChar;
		else {
			CodePoint	cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + pos.m_iChar, strLine.length() - pos.m_iChar);
			pos.m_iChar += (cp > 0xFFFF) ? 2 : 1;
			while(ccc == CCC_CLUSTER && pos.m_iChar < strLine.length()) {
				cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + pos.m_iChar, strLine.length() - pos.m_iChar);
				if(CBoundarySearcher::IsGraphemeBase(cp))
					break;
				pos.m_iChar += (cp > 0xFFFF) ? 2 : 1;
			}
		}
	}
	return pos;
}

/**
 *	^ꂽʒuw蕶߂ʒuԂ
 *	@param pt	ʒu
 *	@param cch	
 *	@param ccc	vZ@Bȗ <var>pt</var> ̐ݒl
 */
CCharPos CEditPoint::GetPrevCharPos(const CEditPoint& pt,
		length_t cch, CEditPoint::CharacterCountingConvention ccc /* = CCC_DEFAULT */) {
	string_t		strLine = pt.m_pDocument->GetLine(pt.m_position.m_iLine);
	const char_t*	pwszLine = strLine.data();
	CCharPos		pos = pt;

	if(ccc == CCC_DEFAULT)
		ccc = pt.m_charCountConvention;
	while(cch-- > 0) {
		if(pos.m_iChar == 0) {	// sȂ̂őO̍sɈړ
			if(pos.m_iLine == 0)	// 擪słΈړȂ
				return pos;
			strLine = pt.m_pDocument->GetLine(--pos.m_iLine);
			pwszLine = strLine.data();
			pos.m_iChar = strLine.length();
		} else if(ccc == CCC_UTF16 || pos.m_iChar == 0)
			--pos.m_iChar;
		else {
			CodePoint	cp;
			if(IsUtf16HighSurrogate(pwszLine[pos.m_iChar - 2])
					&& IsUtf16LowSurrogate(pwszLine[pos.m_iChar - 1]))
				cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + pos.m_iChar - 2, 2);
			else
				cp = pwszLine[pos.m_iChar - 1];
			pos.m_iChar -= (cp > 0xFFFF) ? 2 : 1;
			while(ccc == CCC_CLUSTER
					&& pos.m_iChar != 0
					&& !CBoundarySearcher::IsGraphemeBase(cp)) {
				if(pos.m_iChar != 1
						&& IsUtf16HighSurrogate(pwszLine[pos.m_iChar - 2])
						&& IsUtf16LowSurrogate(pwszLine[pos.m_iChar - 1])) {
					cp = DecodeUtf16SurrogatesToCodePoint(pwszLine + pos.m_iChar - 2, 2);
					pos.m_iChar -= 2;
				} else {
					cp = pwszLine[pos.m_iChar - 1];
					--pos.m_iChar;
				}
			}
		}
	}
	return pos;
}

/**
 *	͈͓̃eLXgԂ
 *	@param cch	1̈ʒu܂ł̕ (ł悢)
 */
string_t CEditPoint::GetText(signed_length_t cch) const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	Normalize();
	if(cch == 0)
		return L"";
	return GetText((cch > 0) ? GetNextCharPos(*this, cch) : GetPrevCharPos(*this, -cch));
}

/**
 *	͈͓̃eLXgԂ
 *	@param pos	1̈ʒu
 */
string_t CEditPoint::GetText(const CCharPos& pos) const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	CCharPos	pos_ = pos;
	
	pos_.m_iLine = min(pos.m_iLine, m_pDocument->GetLineCount() - 1);
	Normalize();
	if(pos == m_position)
		return L"";

	const CCharPos&	posStart = min(m_position, pos_);
	const CCharPos&	posEnd = max(m_position, pos_);

	if(posStart.m_iLine == posEnd.m_iLine)	// 1s̏ꍇ
		return m_pDocument->GetLine(posEnd.m_iLine).substr(posStart.m_iChar, posEnd.m_iChar - posStart.m_iChar);
	else {	// s̏ꍇ
		ostringstream_t			text;
		length_t				iLine = posStart.m_iLine;
		CEditDoc::LineIterator	itLines = m_pDocument->GetLineIterator(iLine);

		while(true) {
			if(iLine == posStart.m_iLine)	// 擪s
				text << itLines->GetLine().substr(posStart.m_iChar)
						<< CEditDoc::GetLineBreakString(itLines->GetLineBreak());
			else if(iLine == posEnd.m_iLine) {	// ŏIs
				text << itLines->GetLine().substr(0, posEnd.m_iChar);
				break;
			} else
				text << itLines->GetLine()
						<< CEditDoc::GetLineBreakString(itLines->GetLineBreak());
			++iLine;
			++itLines;
		}
		return text.str();
	}
}

/**
 *	_̈ʒuɕ}B݈ʒu͓͕i߂
 *	@param text	}eLXg
 */
void CEditPoint::Insert(const string_t& text) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	Insert(text.data(), text.data() + text.length());
}

/**
 *	_̈ʒuɕ}B݈ʒu͓͕i߂
 *	@param first, last	}eLXg
 */
void CEditPoint::Insert(const char_t* first, const char_t* last) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly())
		return;
	IgnoreDocumentUpdate(true);
	MoveTo(m_pDocument->InsertText(m_position, first, last));
	IgnoreDocumentUpdate(false);
}

///	݈ʒuhLg̏I[ł邩ǂԂ
bool CEditPoint::IsEndOfDocument() const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	Normalize();
	return IsExcludedFromRestriction() ?
		m_position == m_pDocument->GetEndPoint()
		: m_position.m_iLine == m_pDocument->GetLineCount() - 1
			&& m_position.m_iChar == m_pDocument->GetLineLength(m_position.m_iLine);
}

///	݈ʒusł邩ǂԂ
bool CEditPoint::IsEndOfLine() const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	Normalize();
	const CCharPos	endPoint = m_pDocument->GetEndPoint();
	Normalize();
	if(IsExcludedFromRestriction())
		return (endPoint.m_iLine == m_position.m_iLine) ?
			m_position.m_iChar == endPoint.m_iChar : m_position.m_iChar == m_pDocument->GetLineLength(m_position.m_iLine);
	else
		return m_position.m_iChar == m_pDocument->GetLineLength(m_position.m_iLine);
}

///	݈ʒuhLg̐擪ł邩ǂԂ
bool CEditPoint::IsStartOfDocument() const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	Normalize();
	return IsExcludedFromRestriction() ? m_position == m_pDocument->GetStartPoint() : m_position == CCharPos(0, 0);
}

///	݈ʒusł邩ǂԂ
bool CEditPoint::IsStartOfLine() const throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	const CCharPos	startPoint = m_pDocument->GetStartPoint();
	Normalize();
	if(IsExcludedFromRestriction())
		return (startPoint.m_iLine == m_position.m_iLine) ?
			startPoint.m_iChar == m_position.m_iChar : m_position.m_iChar == 0;
	else
		return m_position.m_iChar == 0;
}

/**
 *	hLg擪̕Ŏw肵ʒuɈړ
 *	@param nOffset	hLg擪̕
 */
void CEditPoint::MoveToAbsoluteCharOffset(length_t nOffset) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	length_t				cRead = 0;
	const CCharPos			posStart = m_pDocument->GetStartPoint();
	const CCharPos			posEnd = m_pDocument->GetEndPoint();
	CEditDoc::LineIterator	itLines = m_pDocument->GetLineIterator(posStart.m_iLine);

	if(itLines->GetLine().length() + 1 - posStart.m_iChar >= nOffset) {
		MoveTo(CCharPos(posStart.m_iLine, posStart.m_iChar + nOffset));
		return;
	}
	cRead += itLines->GetLine().length() + 1 - posStart.m_iChar;
	++itLines;
	for(length_t iLine = posStart.m_iLine + 1; iLine <= posEnd.m_iLine; ++iLine, ++itLines) {
		const length_t	cchLine = itLines->GetLine().length() + 1;	// +1 ͉s
		if(cRead + cchLine >= nOffset) {
			MoveTo(CCharPos(iLine, cRead + cchLine - nOffset));
			return;
		}
		cRead += cchLine;
	}
	MoveTo(CCharPos(posEnd.m_iLine, itLines->GetLine().length()));
}

///	hLg̏I[Ɉړ
void CEditPoint::MoveToEndOfDocument() throw(EDocumentIsAlreadyDisposed) {
	const length_t	cLines = m_pDocument->GetLineCount();
	MoveTo(CCharPos(cLines - 1, m_pDocument->GetLineLength(cLines - 1)));
}

///	sɈړ
void CEditPoint::MoveToEndOfLine() throw(EDocumentIsAlreadyDisposed) {
	MoveTo(CCharPos(
		min(m_position.m_iLine, m_pDocument->GetLineCount() - 1), m_pDocument->GetLineLength(m_position.m_iLine)));
}

/**
 *	wʒuɈړ
 *	@param pos	ړ
 */
void CEditPoint::MoveTo(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	if(pos != m_position) {
		const CCharPos	oldPosition = m_position;
		CSynchronizablePoint::MoveTo(pos);
		if(m_pEventListener != 0)
			m_pEventListener->OnEditPointMoved(*this, oldPosition);
	}
}

///	hLg̐擪Ɉړ
void CEditPoint::MoveToStartOfDocument() throw(EDocumentIsAlreadyDisposed) {
	MoveTo(CCharPos(0, 0));
}

/// sɈړ
void CEditPoint::MoveToStartOfLine() throw(EDocumentIsAlreadyDisposed) {
	MoveTo(CCharPos(min(m_position.m_iLine, m_pDocument->GetLineCount() - 1), 0));
}

///	s
void CEditPoint::NewLine() throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly())
		return;
	Insert(CEditDoc::GetLineBreakString(m_pDocument->GetLineBreak()));
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param cch	1̈ʒu܂ł̕ (ł悢)
 */
void CEditPoint::Paste(signed_length_t cch /* = 0 */) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly() || cch == 0) {
		Paste(m_position);
		return;
	}

	CEditPoint	pt(*this);

	if(cch > 0)
		pt.CharNext(cch);
	else {	// 폜̏ꍇ͌ȕ폜
		while(cch++ != 0) {
			if(pt.m_position.m_iChar == 0) {
				if(pt.m_position.m_iLine == 0)
					break;
				--pt.m_position.m_iLine;
				pt.m_position.m_iChar = m_pDocument->GetLineLength(pt.m_position.m_iLine);
			} else
				--pt.m_position.m_iChar;
		}
	}
	Paste(pt);
}

/**
 *	͈͓̃eLXgNbv{[h̓eŒu
 *	@param pos	1̈ʒu
 */
void CEditPoint::Paste(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();

	if(m_pDocument->IsReadOnly())
		return;
	else if(const UINT nAvailableClipFormat = CEditView::CanPaste()) {
		if(pos != m_position)
			Delete(pos);

		const length_t	cch = CClipboard::GetClipboardTextSize(0) - 1;
		char_t* const	pwszText = new char_t[cch + 1];

		CClipboard::ReadClipboardText(0, pwszText, cch + 1);
		Insert(pwszText);
		delete[] pwszText;
	}
}


// CVisualPoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param document			Ώۂ̃hLg
 *	@paran pEventListener	CxgXi
 */
CVisualPoint::CVisualPoint(CEditDoc& document, CEditPoint::IEventListener* pEventListener /* = 0 */) : CEditPoint(document, pEventListener) {
}

/// Rs[RXgN^
CVisualPoint::CVisualPoint(const CVisualPoint& rhs) : CEditPoint(rhs), m_lastX(rhs.m_lastX) {
}

/// fXgN^
CVisualPoint::~CVisualPoint() {
}

/**
 *	w͈͂r[̒ɂȂ悤ɃXN[BɉȂ牽Ȃ
 *	@param view						Ώۃr[
 *	@param cch						͈͂\̓_܂ł̕
 *	@return							͈͂r[ɔ[܂ꍇ true Ԃ
 *	@throw std::invalid_argument	<var>view</var> 쐬hLgɊ܂܂ĂȂ΃X[
 */
bool CVisualPoint::Center(CEditView& view, signed_length_t cch /* = 0 */) throw(invalid_argument, EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	if(&view.GetDocument() != m_pDocument)
		throw invalid_argument("Specified view does not belong to the document created this point.");
	return Center(view, (cch >= 0) ? GetNextCharPos(*this, cch) : GetPrevCharPos(*this, -cch));
}

/**
 *	w͈͂r[̒ɂȂ悤ɃXN[BɉȂ牽Ȃ
 *	@param view	Ώۃr[
 *	@param pos	͈͂\̓_
 *	@return		͈͂r[ɔ[܂ꍇ true Ԃ (ɂ true)
 *	@throw std::invalid_argument	<var>view</var> 쐬hLgɊ܂܂ĂȂ΃X[
 */
bool CVisualPoint::Center(CEditView& view, const CCharPos& pos) throw(invalid_argument, EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	if(&view.GetDocument() != m_pDocument)
		throw invalid_argument("Specified view does not belong to the document created this point.");

	const CCharPos	posDisplay = view.DisplayCharFromLogicalChar(m_position);
	const length_t	cVisibleLines = view.GetVisibleLineCount();

	view.SendMessage(WM_HSCROLL, MAKEWPARAM(SB_LEFT, 0));
	view.SendMessage(WM_VSCROLL, MAKEWPARAM(SB_SETPOS, posDisplay.m_iLine - cVisibleLines / 2));

	return true;
}

/**
 *	̕Ɉړ
 *	@param cch	ړ邩
 */
void CVisualPoint::CharLeft(length_t cch /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(!GetView().GetLayoutSettings().GetSettings().bRightToLeftReading ?
		GetPrevCharPos(*this, cch) : GetNextCharPos(*this, cch));
}

/**
 *	E̕Ɉړ
 *	@param cch	ړ邩
 */
void CVisualPoint::CharRight(length_t cch /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(!GetView().GetLayoutSettings().GetSettings().bRightToLeftReading ?
		GetNextCharPos(*this, cch) : GetPrevCharPos(*this, cch));
}

/// \̗ԍ (ԍ) Ԃ
length_t CVisualPoint::GetColumnNumber() const throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	return GetView().ColumnFromChar(m_position);
}

/// Ώۂ̃r[𓾂
const CEditView& CVisualPoint::GetView() const {
	assert(m_pDocument != 0 && m_pDocument->GetCount() != 0);
	return m_pDocument->GetActiveView();
}

/**
 *	͈͓̃eLXgCfg
 *	@param pos		1̈ʒu
 *	@param chIndent	CfgɎg
 *	@param bBox		`Cfg (Cfgx̂Ƃ͖)
 *	@param nLevel	Cfgx
 *	@return			̌ <var>pos</var> ړƂ悢ʒu
 */
CCharPos CVisualPoint::_Indent(const CCharPos& pos, char_t chIndent,
		bool bBox, long nLevel) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pDocument->IsReadOnly() || nLevel == 0)
		return pos;

	const string_t		strIndent = string_t(abs(nLevel), chIndent);
	const CTextRange	range(m_position, pos);

	if(range.GetTop().m_iLine == range.GetBottom().m_iLine) {	// I1sȓ -> Pȕ}
		m_pDocument->DeleteText(range);
		m_pDocument->InsertText(range.GetTop(), strIndent);
		return m_position;
	}

	const CCharPos	oldPosition = m_position;
	const CLexer&	lexer = GetView().GetLexer();
	CCharPos		posOtherRes = pos;
	length_t		iLine = range.GetTop().m_iLine;

	IgnoreDocumentUpdate(true);

	// ŏ̍s (t) Cfg
	if(nLevel > 0) {
		m_pDocument->InsertText(CCharPos(iLine, bBox ? range.GetTop().m_iChar : 0), strIndent);
		if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
			posOtherRes.m_iChar += nLevel;
		if(iLine == m_position.m_iLine && m_position.m_iChar != 0)
			m_position.m_iChar += nLevel;
	} else {
		const length_t	cchIndent = lexer.EatWhiteSpaces(
				m_pDocument->GetLine(iLine).data(), m_pDocument->GetLineLength(iLine), true);
		if(cchIndent > 0) {
			const length_t	cchDelete = min<length_t>(-nLevel, cchIndent);
			m_pDocument->DeleteText(CCharPos(iLine, 0), CCharPos(iLine, cchDelete));
			if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
				posOtherRes.m_iChar -= cchDelete;
			if(iLine == m_position.m_iLine && m_position.m_iChar != 0)
				m_position.m_iChar -= cchDelete;
		}
	}

	// ÎSĂ̍s (t) Cfg
	if(nLevel > 0) {
		for(++iLine; iLine <= range.GetBottom().m_iLine; ++iLine) {
			if(m_pDocument->GetLineLength(iLine) != 0
					&& (iLine != range.GetBottom().m_iLine || range.GetBottom().m_iChar > 0)) {
				length_t	iInsert = 0;
				if(bBox)
					GetView().GetSelection().GetRangeOnLine(iLine, &iInsert, 0);
				m_pDocument->InsertText(CCharPos(iLine, iInsert), strIndent);
				if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
					posOtherRes.m_iChar += nLevel;
				if(iLine == m_position.m_iLine && m_position.m_iChar != 0)
					m_position.m_iChar += nLevel;
			}
		}
	} else {
		for(++iLine; iLine <= range.GetBottom().m_iLine; ++iLine) {
			const length_t	cchIndent = lexer.EatWhiteSpaces(
					m_pDocument->GetLine(iLine).data(), m_pDocument->GetLineLength(iLine), true);
			if(cchIndent > 0) {
				const length_t	cchDelete = min<length_t>(-nLevel, cchIndent);
				m_pDocument->DeleteText(CCharPos(iLine, 0), CCharPos(iLine, cchDelete));
				if(iLine == posOtherRes.m_iLine && posOtherRes.m_iChar != 0)
					posOtherRes.m_iChar -= cchDelete;
				if(iLine == m_position.m_iLine && m_position.m_iChar != 0)
					m_position.m_iChar -= cchDelete;
			}
		}
	}

	IgnoreDocumentUpdate(false);
	if(m_pEventListener != 0)
		m_pEventListener->OnEditPointMoved(*this, oldPosition);
	return posOtherRes;
}

/**
 *	_̈ʒuɕ`}B݈ʒu͓͕i߂
 *	@param text	}eLXg
 */
void CVisualPoint::InsertBox(const string_t& text) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	InsertBox(text.data(), text.data() + text.length());
}

/**
 *	_̈ʒuɕ`}B݈ʒu͓͕i߂
 *	@param first, last	}eLXg
 */
void CVisualPoint::InsertBox(const char_t* first, const char_t* last) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pDocument->IsReadOnly() || first == last)
		return;

	const length_t	cLines = m_pDocument->GetLineCount();
	const string_t	strBreak = CEditDoc::GetLineBreakString(m_pDocument->GetLineBreak());
	list<const char_t*>	lines;

	// sʒũXg
	lines.push_back(first);
	for(const char_t* pBreak = first; pBreak != last; ) {
		pBreak = find_first_of(pBreak, last, CEditDoc::m_wszBreakChars, _endof(CEditDoc::m_wszBreakChars));
		pBreak += (*pBreak == L'\r' && pBreak < last - 1 && *(pBreak + 1) == L'\n') ? 2 : 1;
		lines.push_back(pBreak);
	}

	length_t	iLine = m_position.m_iLine;	// }s
	string_t	strLine;					// }sƂȂ镔
	const int	xFirstLineInsert =			// }擪s̑}ʒu (s[̈ʒu)
		GetView().m_pSharedData->layoutManager.GetLine(m_position.m_iLine).GetCaretPosition(m_position.m_iChar);
	for(list<const char_t*>::const_iterator it = lines.begin(); it != lines.end(); ++it, ++iLine) {
		if(*it == lines.back())	// ŏIs
			strLine.assign(*it, last);
		else {
			++it;
			length_t	cchLine = *it - first - ((*(*it - 1) == L'\n' && *(*it - 2) == L'\r') ? 2 : 1);
			cchLine -= *(--it) - first;
			strLine.assign(*it, cchLine);
		}
		if(iLine >= cLines - 1 && *it != lines.back())	// }ʒuɍs݂Ȃꍇ͍쐬
			strLine += strBreak;

		if(!strLine.empty())
			MoveTo(m_pDocument->InsertText(CCharPos(iLine,
				GetView()._MapAbsoluteXToCharacter(iLine, xFirstLineInsert,
					!GetView().m_pSharedData->options.behavior[BooleanOptions::ACCEPT_CARET_ON_EXTENDER_BY_MOUSE])),
					GetView().CalculateSpacesReachingVirtualPoint(iLine, xFirstLineInsert) + strLine));
	}
}

/// ݈ʒus̍ŏ̕ł邩Ԃ
bool CVisualPoint::IsFirstCharOfLine() const throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	const CCharPos	startPoint = IsExcludedFromRestriction() ? m_pDocument->GetStartPoint() : CCharPos(0, 0);
	const length_t	nOffset = (startPoint.m_iLine == m_position.m_iLine) ? startPoint.m_iChar : 0;
	return m_position.m_iChar - nOffset
		== GetView().GetLexer().EatWhiteSpaces(
			m_pDocument->GetLine(m_position.m_iLine).data() + nOffset,
			m_pDocument->GetLineLength(m_position.m_iLine) - nOffset, true);
}

/// ݈ʒus̍Ō̕ł邩Ԃ
bool CVisualPoint::IsLastCharOfLine() const throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	const CCharPos	endPoint = IsExcludedFromRestriction() ?
		m_pDocument->GetEndPoint()
		: CCharPos(m_pDocument->GetLineCount() - 1, m_pDocument->GetLineLength(m_pDocument->GetLineCount() - 1));
	const string_t&	strLine = m_pDocument->GetLine(m_position.m_iLine);
	const length_t	cchLine = (endPoint.m_iLine == m_position.m_iLine) ? endPoint.m_iChar : strLine.length();
	return cchLine - m_position.m_iChar
		== GetView().GetLexer().EatWhiteSpaces(strLine.data() + m_position.m_iChar, cchLine - m_position.m_iChar, true);
}

/**
 *	̍sɈړ
 *	@param cLines	ړs
 */
void CVisualPoint::LineDown(length_t cLines /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	const length_t	iNewLine = min(m_position.m_iLine + cLines,
		IsExcludedFromRestriction() ? m_pDocument->GetEndPoint().m_iLine : m_pDocument->GetLineCount() - 1);
	if(iNewLine != m_position.m_iLine) {
		PREPARE_X();
		_MoveTo(CCharPos(iNewLine,
			GetView()._MapAbsoluteXToCharacter(
				iNewLine, x, GetCharacterCountingConvention() != CCC_UTF16)), false);
	}
}

/**
 *	O̍sɈړ
 *	@param cLines	ړs
 */
void CVisualPoint::LineUp(length_t cLines /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	const length_t	iTopLine = IsExcludedFromRestriction() ? m_pDocument->GetStartPoint().m_iLine : 0;
	const length_t	iNewLine = (m_position.m_iLine > cLines) ? max(m_position.m_iLine - cLines, iTopLine) : 0;
	if(iNewLine != m_position.m_iLine) {
		PREPARE_X();
		_MoveTo(CCharPos(iNewLine,
			GetView()._MapAbsoluteXToCharacter(
				iNewLine, x, GetCharacterCountingConvention() != CCC_UTF16)), false);
	}
}

/// s̍ŏ̕Ɉړ
void CVisualPoint::MoveToFirstCharOfLine() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	const length_t	iLine = min(m_position.m_iLine,
		IsExcludedFromRestriction() ? m_pDocument->GetEndPoint().m_iLine : m_pDocument->GetLineCount() - 1);
	MoveTo(CCharPos(iLine,
		GetView().GetLexer().EatWhiteSpaces(
			m_pDocument->GetLine(iLine).data(), m_pDocument->GetLineLength(iLine), true)));
}

/// s̍Ō̕Ɉړ
void CVisualPoint::MoveToLastCharOfLine() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	const length_t		iLine = min(m_position.m_iLine,
		IsExcludedFromRestriction() ? m_pDocument->GetEndPoint().m_iLine : m_pDocument->GetLineCount() - 1);
	const length_t		cchLine = m_pDocument->GetLineLength(iLine);
	const char_t* const	pwszLine = m_pDocument->GetLine(iLine).data();

	for(length_t cchSpaces = 0; cchSpaces < cchLine; ++cchSpaces) {
		if(GetView().GetLexer().IsWhiteSpace(pwszLine[cchLine - cchSpaces - 1], true)) {
			MoveTo(CCharPos(iLine, cchLine - cchSpaces));
			return;
		}
	}
	MoveTo(CCharPos(iLine, cchLine));
}

///	̃ubN}[Ns̍sɈړ
void CVisualPoint::MoveToNextBookmark() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();

	const CBookmarker&	bookmarks = GetView().GetBookmarker();
	length_t			iLine;
	const length_t		iEndLine = m_pDocument->GetEndPoint().m_iLine;

	// T
	for(iLine = m_position.m_iLine + 1; iLine <= iEndLine; ++iLine) {
		if(bookmarks.IsBookmarked(iLine)) {
			MoveTo(CCharPos(iLine, 0));
			return;
		}
	}

	// Ȃΐ܂Ԃ
	for(iLine = m_pDocument->GetStartPoint().m_iLine; iLine < m_position.m_iLine; ++iLine) {
		if(bookmarks.IsBookmarked(iLine)) {
			MoveTo(CCharPos(iLine, 0));
			return;
		}
	}
}

/// @see	CEditPoint::MoveTo
void CVisualPoint::MoveTo(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	_MoveTo(pos, true);
}

/// CVisualPoint::MoveTo Ȃǂ̃wp
inline void CVisualPoint::_MoveTo(const CCharPos& pos, bool bUpdateLastX) {
	CEditPoint::MoveTo(pos);
	if(bUpdateLastX)
		_UpdateLastX();
}

///	ÕubN}[Ns̍sɈړ
void CVisualPoint::MoveToPrevBookmark() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();

	const CBookmarker&	bookmarks = GetView().GetBookmarker();
	length_t			iLine = m_position.m_iLine;
	const length_t		iStartLine = m_pDocument->GetStartPoint().m_iLine;

	// T
	while(iLine-- != iStartLine) {
		if(bookmarks.IsBookmarked(iLine)) {
			MoveTo(CCharPos(iLine, 0));
			return;
		}
	}

	// Ȃΐ܂Ԃ
	for(iLine = m_pDocument->GetEndPoint().m_iLine; iLine > m_position.m_iLine; --iLine) {
		if(bookmarks.IsBookmarked(iLine)) {
			MoveTo(CCharPos(iLine, 0));
			return;
		}
	}
}

///	sBݒɂăX}[gCfgAubNCfgs
void CVisualPoint::NewLine() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pDocument->IsReadOnly())
		return;

	string_t	strBreak = CEditDoc::GetLineBreakString(m_pDocument->GetLineBreak());
	bool		bDoneSmartIndent = false;	// X}[gCfg

//	if(GetView().m_options.autoIndentType == AIT_SMART)
//		bDoneSmartIndent = SmartIndent(L'\n');
	if(!bDoneSmartIndent && GetView().m_pSharedData->options.autoIndentType == AIT_BLOCK) {	// I[gCfg
		const string_t&	strCurrentLine = m_pDocument->GetLine(m_position.m_iLine);
		const length_t	cch = GetView().GetLexer().EatWhiteSpaces(strCurrentLine.data(), m_position.m_iChar, true);
		strBreak += strCurrentLine.substr(0, cch);
	}
	if(!bDoneSmartIndent)
		Insert(strBreak);
}

/**
 *	̃y[WɈړ
 *	@param cPages	ړy[W
 */
void CVisualPoint::PageDown(length_t cPages /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	LineDown((GetView().GetVisibleLineCount() - 1) * cPages);
}

/**
 *	Õy[WɈړ
 *	@param cPages	ړy[W
 */
void CVisualPoint::PageUp(length_t cPages /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	LineUp((GetView().GetVisibleLineCount() - 1)* cPages);
}

/// @see	CEditPoint::Paste
void CVisualPoint::Paste(const CCharPos& pos) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pDocument->IsReadOnly())
		return;
	else if(const UINT nAvailableClipFormat = CEditView::CanPaste()) {
		if(pos != m_position)
			Delete(pos);

		const length_t	cch = CClipboard::GetClipboardTextSize(0) - 1;
		char_t* const	pwszText = new char_t[cch + 1];

		CClipboard::ReadClipboardText(0, pwszText, cch + 1);
		if(nAvailableClipFormat == ::RegisterClipboardFormatW(RECTANGLE_TEXT_CLIP_FORMAT))
			InsertBox(pwszText);
		else
			Insert(pwszText);
		delete[] pwszText;
	}
}

/**
 *	w͈͂ɂȂ悤Ƀr[XN[
 *	@param view	Ώۃr[
 *	@param cch	͈͂\̓_܂ł̕
 *	@return		͈͂r[ɔ[܂ꍇ true Ԃ (ɂ true)
 */
bool CVisualPoint::Reveal(CEditView& view, signed_length_t cch /* = 0 */) throw(invalid_argument, EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	return Reveal(view, (cch >= 0) ? GetNextCharPos(*this, cch) : GetPrevCharPos(*this, -cch));
}

/**
 *	_ɂȂ悤Ƀr[XN[
 *	@param view	Ώۃr[
 *	@param pos	͈͂\̓_
 *	@return		͈͂r[ɔ[܂ꍇ true Ԃ (ɂ true)
 */
bool CVisualPoint::Reveal(CEditView& view, const CCharPos& pos) throw(invalid_argument, EDocumentIsAlreadyDisposed) {
	AssertValid();
	VERIFY_DOCUMENT();
	if(&view.GetDocument() != m_pDocument)
		throw invalid_argument("Specified view does not belong to the document created this point.");

	const CLineLayoutManager&	layout = view.m_pSharedData->layoutManager;
	const CCharPos	posDisplay = view.DisplayCharFromLogicalChar(m_position);
	const length_t	cVisibleLines = view.GetVisibleLineCount();
	const length_t	cVisibleChars = view.GetVisibleCharCount();

	// 
	if(posDisplay.m_iLine < view.m_scrollInfo.position.y * view.GetScrollRatio(false))	// ʂ
		view.OnVScroll(SB_SETPOS, posDisplay.m_iLine * view.GetScrollRatio(false), 0);
	else if(posDisplay.m_iLine - view.m_scrollInfo.position.y * view.GetScrollRatio(false) > cVisibleLines - 1)	// ʂ艺
		view.OnVScroll(SB_SETPOS, (posDisplay.m_iLine - cVisibleLines + 1) * view.GetScrollRatio(false), 0);

	// 
	if(layout.GetSettings().wrapMode == WPM_NONE) {
		const CLineLayout&	line = layout.GetLine(m_position.m_iLine);
		const ulong	x = !layout.GetSettings().bRightAlign ?	// Œs̍[̋
			line.GetCaretPosition(m_position.m_iChar)
			: layout.GetMaxDisplayWidth() - line.GetWidth() + line.GetCaretPosition(m_position.m_iChar);
		const ulong	nScrollOffset =
			view.GetScrollPos(SB_HORZ) * view.GetScrollRatio(true) * layout.GetAverageCharacterWidth();

		if(x <= nScrollOffset)	// ʂ荶
			view.OnHScroll(SB_SETPOS, x / layout.GetAverageCharacterWidth() - cVisibleChars / 4, 0);
		else if(x > (view.GetScrollPos(SB_HORZ) * view.GetScrollRatio(true)
				+ cVisibleChars) * layout.GetAverageCharacterWidth())	// ʂE
			view.OnHScroll(SB_SETPOS, x / layout.GetAverageCharacterWidth() - cVisibleChars * 3 / 4, 0);
	} else {
		// ...
	}

	return true;
}

/**
 *	͈͓̃eLXgXy[XCfg
 *	@param pos		1̈ʒu
 *	@param bBox		`Cfg (CfgxłΖ)
 *	@param nLevel	Cfgx
 *	@return			Cfg <var>pos</var> ړׂʒu
 */
CCharPos CVisualPoint::SpaceIndent(const CCharPos& pos, bool bBox,
		long nLevel /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	return _Indent(pos, L' ', bBox, nLevel);
}

/**
 *	͈͓̃eLXg^uCfg
 *	@param pos		1̈ʒu
 *	@param bBox		`Cfg (CfgxłΖ)
 *	@param nLevel	Cfgx
 *	@return			Cfg <var>pos</var> ړׂʒu
 */
CCharPos CVisualPoint::TabIndent(const CCharPos& pos, bool bBox,
		long nLevel /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	return _Indent(pos, L'\t', bBox, nLevel);
}

/**
 *	@brief	O̕ւ
 *
 *	̃\bh͕NX^PʂŃeLXgւB
 *	݈ʒuNX^̐擪łȂΏ͎sB
 *	ւΏۂݍsɖꍇ͎s
 *
 *	@return	ւȂꍇ false
 */
bool CVisualPoint::TransposeChars() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();

#define IS_RESTRICTION(position)	(position < posTop || position > posBottom)

	if(m_pDocument->IsReadOnly())
		return false;

	// As transposing characters in string "ab":
	//
	//  a b -- transposing clusters 'a' and 'b'. result is "ba"
	// ^ ^ ^
	// | | next-cluster (named pos[2])
	// | middle-cluster (named pos[1]; usually current-position)
	// previous-cluster (named pos[0])

	CCharPos		pos[3];
	const CCharPos	posTop = m_pDocument->GetStartPoint();
	const CCharPos	posBottom = m_pDocument->GetEndPoint();

	if(!CBoundarySearcher::IsGraphemeBase(GetCodePoint()))	// NX^̐擪łȂ
		return false;
	else if(IS_RESTRICTION(m_position))	// ANZXs\̈
		return false;

	const CBoundarySearcher&	boundary = GetView().GetBoundarySearcher();
	if(m_position.m_iChar == 0 || m_position == posTop) {
		pos[0] = m_position;
		pos[1] = boundary.SearchGraphemeBase(pos[0], true);
		if(pos[1].m_iLine != pos[0].m_iLine || pos[1] == pos[0] || IS_RESTRICTION(pos[1]))
			return false;
		pos[2] = boundary.SearchGraphemeBase(pos[1], true);
		if(pos[2].m_iLine != pos[1].m_iLine || pos[2] == pos[1] || IS_RESTRICTION(pos[2]))
			return false;
	} else if(m_position.m_iChar == m_pDocument->GetLineLength(m_position.m_iLine) || m_position == posBottom) {
		pos[2] = m_position;
		pos[1] = boundary.SearchGraphemeBase(pos[2], false);
		if(pos[1].m_iLine != pos[2].m_iLine || pos[1] == pos[2] || IS_RESTRICTION(pos[1]))
			return false;
		pos[0] = boundary.SearchGraphemeBase(pos[1], false);
		if(pos[0].m_iLine != pos[1].m_iLine || pos[0] == pos[1] || IS_RESTRICTION(pos[0]))
			return false;
	} else {
		pos[1] = m_position;
		pos[2] = boundary.SearchGraphemeBase(pos[1], true);
		if(pos[2].m_iLine != pos[1].m_iLine || pos[2] == pos[1] || IS_RESTRICTION(pos[2]))
			return false;
		pos[0] = boundary.SearchGraphemeBase(pos[1], false);
		if(pos[0].m_iLine != pos[1].m_iLine || pos[0] == pos[1] || IS_RESTRICTION(pos[0]))
			return false;
	}

	m_position.m_iChar = pos[1].m_iChar;
	string_t	str = GetText(pos[2]);
	m_position.m_iChar = pos[0].m_iChar;
	str += GetText(pos[1]);
	Delete(pos[2]);
	Insert(str);

	return true;

#undef IS_POSITION
}

/**
 *	ݍsƑO̍s (ݍs擪s̏ꍇ͎̍s) ւB
 *	sR[h͌Ȃ
 *	@param	ւȂꍇ false
 */
bool CVisualPoint::TransposeLines() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pDocument->IsReadOnly())
		return false;

	const CCharPos	posTop = m_pDocument->GetStartPoint();
	const CCharPos	posBottom = m_pDocument->GetEndPoint();

	if(posTop.m_iLine == posBottom.m_iLine)	// 1s
		return false;

	if(m_position.m_iLine == posTop.m_iLine)
		++m_position.m_iLine;

	const string_t	str1 = (m_position.m_iLine - 1 == posTop.m_iLine) ?
		m_pDocument->GetLine(m_position.m_iLine - 1).substr(posTop.m_iChar) : m_pDocument->GetLine(m_position.m_iLine - 1);
	const string_t	str2 = (m_position.m_iLine == posBottom.m_iLine) ?
		m_pDocument->GetLine(m_position.m_iLine).substr(0, posBottom.m_iChar) : m_pDocument->GetLine(m_position.m_iLine);

	// 2sƂɂ
	if(!str2.empty()) {
		m_position.m_iChar = 0;
		Delete(str2.length(), CCC_UTF16);
	}
	if(!str1.empty()) {
		--m_position.m_iLine;
		m_position.m_iChar = (m_position.m_iLine == posTop.m_iLine) ? posTop.m_iChar : 0;
		Delete(str1.length(), CCC_UTF16);
		++m_position.m_iLine;
	}

	// sɏ
	if(!str1.empty()) {
		m_position.m_iChar = 0;
		Insert(str1);
	}
	--m_position.m_iLine;
	if(!str2.empty()) {
		m_position.m_iChar = (m_position.m_iLine == posTop.m_iLine) ? posTop.m_iChar : 0;
		Insert(str2);
	}
	MoveTo(CCharPos(m_position.m_iLine + 2, 0));

	return true;
}

/**
 *	@brief	O̒Pւ
 *
 *	ւΏۂݍsɖꍇA͎s (̍s̒PƂ̌͋NȂ)
 *
 *	@return	ւȂꍇ false
 */
bool CVisualPoint::TransposeWords() throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();

	if(m_pDocument->IsReadOnly())
		return false;

	// As transposing words in string "(\w+)[^\w*](\w+)":
	//
	//  abc += xyz -- transposing words "abc" and "xyz". result is "xyz+=abc"
	// ^   ^  ^   ^
	// |   |  |   2nd-word-end (named pos[3])
	// |   |  2nd-word-start (named pos[2])
	// |   1st-word-end (named pos[1])
	// 1st-word-start (named pos[0])

	const CBoundarySearcher&	boundary = *GetView().m_pBoundarySearcher;
	const CCharPos				posTop = m_pDocument->GetStartPoint();
	const CCharPos				posBottom = m_pDocument->GetEndPoint();
	CCharPos					pos[4];

	// ܂O̒P (1st-word-*) T
	pos[0] = boundary.SearchWordBoundary(m_position, false,
		static_cast<CBoundarySearcher::SearchPart>(CBoundarySearcher::WORD_START | CBoundarySearcher::RESTRICTION_EFFECTIVE));
	pos[1] = boundary.SearchWordBoundary(pos[0], true,
		static_cast<CBoundarySearcher::SearchPart>(CBoundarySearcher::WORD_END | CBoundarySearcher::RESTRICTION_EFFECTIVE));
	if(pos[1] == pos[0])	// Pꂪ
		return false;

	// Ɍ̒P (2nd-word-*) T
	pos[2] = boundary.SearchWordBoundary(m_position, true,
		static_cast<CBoundarySearcher::SearchPart>(CBoundarySearcher::WORD_START | CBoundarySearcher::RESTRICTION_EFFECTIVE));
	if(pos[2] == m_position)
		pos[2] = boundary.SearchWordBoundary(pos[0], false,
			static_cast<CBoundarySearcher::SearchPart>(CBoundarySearcher::WORD_START | CBoundarySearcher::RESTRICTION_EFFECTIVE));
	pos[3] = boundary.SearchWordBoundary(pos[2], true,
		static_cast<CBoundarySearcher::SearchPart>(CBoundarySearcher::WORD_END | CBoundarySearcher::RESTRICTION_EFFECTIVE));
/*
	const length_t	iOrgChar = m_position.m_iChar;
	m_position.m_iChar = pos1stWordHead.m_iChar;
	const string_t	str1 = GetText(pos1stWordEnd);
	Delete(pos1stWordEnd);
	m_position.m_iChar = pos2ndWordHead.m_iChar - (pos1stWordEnd.m_iChar - pos1stWordHead.m_iChar);
	Insert(str1);
	const string_t	str2 = GetText(CCharPos(m_position.m_iLine,
		m_position.m_iChar + (pos2ndWordEnd.m_iChar - pos2ndWordHead.m_iChar)));
	Delete(CCharPos(m_position.m_iLine, m_position.m_iChar + (pos2ndWordEnd.m_iChar - pos2ndWordHead.m_iChar)));
	m_position.m_iChar = pos1stWordHead.m_iChar;
	Insert(str2);
	MoveTo(CCharPos(m_position.m_iLine, iOrgChar + (pos2ndWordEnd.m_iChar - pos1stWordEnd.m_iChar)));
*/
	return true;
}

///	m_lastX ݈ʒuɍXV
inline void CVisualPoint::_UpdateLastX() {
	AssertValid();
	if(!IsDocumentDisposed()) {
		const CLineLayoutManager&	layout = GetView().m_pSharedData->layoutManager;
		const CLineLayout&			line = layout.GetLine(m_position.m_iLine);
		m_lastX.bFromLeftEnd = !layout.GetSettings().bRightAlign;
		m_lastX.nDistance = m_lastX.bFromLeftEnd ?
			line.GetCaretPosition(m_position.m_iChar) : line.GetWidth() - line.GetCaretPosition(m_position.m_iChar);
	}
}

/**
 *	̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CVisualPoint::WordEndLeft(length_t cWords /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(GetView().m_pBoundarySearcher->SearchWordBoundary(m_position,
		GetView().GetLayoutSettings().GetSettings().bRightToLeftReading, CBoundarySearcher::END));
}

/**
 *	̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CVisualPoint::WordEndNext(length_t cWords /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(GetView().m_pBoundarySearcher->SearchWordBoundary(m_position, true, CBoundarySearcher::END));
}

/**
 *	O̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CVisualPoint::WordEndPrev(length_t cWords /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(GetView().m_pBoundarySearcher->SearchWordBoundary(m_position, false, CBoundarySearcher::END));
}

/**
 *	E̒P̖Ɉړ
 *	@param cWords	ړPꐔ
 */
void CVisualPoint::WordEndRight(length_t cWords /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(GetView().m_pBoundarySearcher->SearchWordBoundary(m_position,
		!GetView().GetLayoutSettings().GetSettings().bRightToLeftReading, CBoundarySearcher::END));
}

/**
 *	̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CVisualPoint::WordLeft(length_t cWords /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(GetView().m_pBoundarySearcher->SearchWordBoundary(m_position,
		GetView().GetLayoutSettings().GetSettings().bRightToLeftReading, CBoundarySearcher::START));
}

/**
 *	̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CVisualPoint::WordNext(length_t cWords /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(GetView().m_pBoundarySearcher->SearchWordBoundary(m_position, true, CBoundarySearcher::START));
}

/**
 *	O̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CVisualPoint::WordPrev(length_t cWords /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(GetView().m_pBoundarySearcher->SearchWordBoundary(m_position, false, CBoundarySearcher::START));
}

/**
 *	E̒P̐擪Ɉړ
 *	@param cWords	ړPꐔ
 */
void CVisualPoint::WordRight(length_t cWords /* = 1 */) throw(EDocumentIsAlreadyDisposed, ELayoutIsNotPrepared) {
	AssertValid();
	VERIFY_VIEW();
	Normalize();
	MoveTo(GetView().m_pBoundarySearcher->SearchWordBoundary(m_position,
		!GetView().GetLayoutSettings().GetSettings().bRightToLeftReading, CBoundarySearcher::START));
}


#undef VERIFY_VIEW
#undef PREPARE_X

/* [EOF] */