// CompletionWindow.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "CompletionWindow.h"
#include "EditView.h"	// CEditView
#include "EditPoint.h"

using namespace Ascension;
using namespace std;

namespace {
	const length_t COMPLETION_MAX_TRACKBACK_CCH = 100;
}


/// RXgN^
CCompletionWindow::CCompletionWindow(CEditView& view) 
		: m_view(view), m_hDefaultFont(0), m_bRunning(false), m_contextEnd(*view.GetDocument().CreateEditPoint()) {
}

/// fXgN^
CCompletionWindow::~CCompletionWindow() {
	delete &m_contextEnd;
}

/// ⊮𒆎~
void CCompletionWindow::Abort() {
	AssertValid();
	if(IsRunning()) {
		m_bRunning = false;
		m_contextEnd.SynchronizeWithDocumentUpdate(false);
		ShowWindow(SW_HIDE);
	}
}

/// ⊮ (SɈv₪ꍇ͒~)
void CCompletionWindow::Complete() {
	AssertValid();

	const int	iSel = GetCurSel();

	if(iSel != LB_ERR) {
		CEditDoc&		document = m_view.GetDocument();
		CSelection&		selection = m_view.GetSelection();
		const length_t	cchItem = GetTextLen(iSel);
		char_t*			pwszItem = new char_t[cchItem + 1];

		if(!selection.IsEmpty())
			selection.MoveTo(selection.GetActivePoint(), false);

		const string_t	strLeftWord = m_view.GetPrecedingWord(COMPLETION_MAX_TRACKBACK_CCH);

		GetText(iSel, pwszItem);
		m_view.Freeze();
		document.BeginEditCollection();
		document.DeleteText(CCharPos(
			selection.GetActivePoint().GetLineNumber(), selection.GetActivePoint().GetCharNumber() - strLeftWord.length()),
			selection.GetActivePoint());
		selection.MoveTo(document.InsertText(selection.GetActivePoint(), pwszItem, pwszItem + cchItem), true);
		document.EndEditCollection();
		m_view.Unfreeze();

		delete[] pwszItem;
	}
	Abort();
}

/**
 *	EBhE쐬
 *	@return	
 */
bool CCompletionWindow::Create() {
	AssertValid();

	using namespace Manah::Windows::Controls;

	if(CListBox::Create(m_view, DefaultWindowRect(), 0, 0,
			WS_CHILD | WS_TABSTOP | WS_VSCROLL | LBS_NOINTEGRALHEIGHT | LBS_NOTIFY | LBS_SORT,
			WS_EX_CLIENTEDGE | WS_EX_NOPARENTNOTIFY | WS_EX_TOOLWINDOW)
			&& SubclassWindow()) {
		_UpdateDefaultFont();
		SetWindowPos(HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);

#if 0
		// etĂ݂肷...
#ifndef CS_DROPSHADOW
		const ULONG_PTR	CS_DROPSHADOW = 0x00020000;
#endif /* !CS_DROPSHADOW */
		const ULONG_PTR	nStyleBits = ::GetClassLongPtrW(m_hWnd, GCL_STYLE);
		::SetClassLongPtrW(m_hWnd, GCL_STYLE, nStyleBits | CS_DROPSHADOW);
#endif
		return true;
	}
	return false;
}

/// @see	CListBox::DispatchEvent
LRESULT CCompletionWindow::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_DESTROY:
		::DeleteObject(m_hDefaultFont);
		break;
	case WM_KILLFOCUS:
		Abort();
		break;
	case WM_LBUTTONDBLCLK:	// _uNbNł⊮
		Complete();
		return true;
	case WM_LBUTTONDOWN: {	// ŎȂȂ̂
			POINT		pt = {LOWORD(lParam), HIWORD(lParam)};
			bool		bOutside;
			const int	iSel = ItemFromPoint(pt, bOutside);
			if(!bOutside)
				SetCurSel(iSel);
		}
		return true;
	case WM_SETTINGCHANGE:
		_UpdateDefaultFont();
		break;
	case WM_SHOWWINDOW:
		if(!wParam)
			ResetContent();
		break;
	}

	return CListBox::DispatchEvent(message, wParam, lParam);
}

/**
 *	tHg̐ݒ
 *	@param hFont	tHgBnull Ɗ̃tHg
 */
void CCompletionWindow::SetFont(const HFONT hFont) {
	AssertValidAsWindow();
	CListBox::SetFont((hFont != 0) ? hFont : m_hDefaultFont);
}

/**
 *	@brief	⊮Jn
 *
 *	̃\bh̓EBhE̕\ʒu߂sȂ
 *	@param candidateWords	⃊Xg
 */
void CCompletionWindow::Start(const set<string_t>& candidateWords) {
	AssertValidAsWindow();

//	const bool	bRightToLeft = toBoolean(m_view.GetStyleEx() & WS_EX_RTLREADING);
	const bool	bRightToLeft = m_view.IsTextDirectionRightToLeft();

	ResetContent();
	ModifyStyleEx(bRightToLeft ? WS_EX_LTRREADING : WS_EX_RTLREADING, bRightToLeft ? WS_EX_RTLREADING : WS_EX_LTRREADING);
	for(set<string_t>::const_iterator it = candidateWords.begin(); it != candidateWords.end(); ++it) {
		if(!it->empty())
			AddString(it->c_str());
	}

	CSelection&			selection = m_view.GetSelection();
	const CVisualPoint&	caret = selection.GetActivePoint();
	const string_t&		strLine = m_view.GetDocument().GetLine(caret.GetLineNumber());

	selection.MoveTo(caret, true);
	m_contextStart.m_iLine = caret.GetLineNumber();
	m_contextStart.m_iChar = caret.GetCharNumber() - m_view.GetPrecedingWord(COMPLETION_MAX_TRACKBACK_CCH).length();
	m_contextEnd.MoveTo(caret);
	if(m_view.GetLexer().IsIdentifierContinueCodePoint(m_contextEnd.GetCodePoint()))
		m_contextEnd.WordEndNext();
	m_contextEnd.SynchronizeWithDocumentUpdate(true);
	m_bRunning = true;
}

/// tHg̍XV
void CCompletionWindow::_UpdateDefaultFont() {
	AutoZeroCB<NONCLIENTMETRICSW>	ncm;

	::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, &ncm, 0);
	HFONT	hNewFont = ::CreateFontIndirectW(&ncm.lfStatusFont);
	if(m_hDefaultFont != 0 && IsWindow() && GetFont() == m_hDefaultFont) {
		HFONT	hOldFont = GetFont();
		CListBox::SetFont(hNewFont);
		::DeleteObject(hOldFont);
	} else
		CListBox::SetFont(hNewFont);
	m_hDefaultFont = hNewFont;
}

/**
 *	r[̏󋵂ɍ킹ăXg̑IXV
 *	@return					₪ɍiꂽꍇ true
 *	@throw std::logic_error	⊮łȂꍇX[
 */
bool CCompletionWindow::UpdateListCursel() throw(logic_error) {
	AssertValidAsWindow();

	if(!IsRunning())
		throw std::logic_error("Completion is not running.");

	const string_t	strLeftWord = m_view.GetPrecedingWord(COMPLETION_MAX_TRACKBACK_CCH);

	if(!strLeftWord.empty()) {
		const int	iFound = FindString(-1, strLeftWord.c_str());
		SetCurSel((iFound != LB_ERR) ? iFound : -1);
		if(iFound != LB_ERR) {
			if(iFound != 0)	// ̂܂܂Ə񂾂IڂsɂȂ݂
				SetCurSel(iFound - 1);
			SetCurSel(iFound);
			if(iFound != GetCount() - 1) {
				const size_t	cchCompare = min<size_t>(strLeftWord.length(), GetTextLen(iFound + 1));
				wchar_t*		pwszLeftWord = CLexer::CaseFoldString(strLeftWord.data(), cchCompare);
				wchar_t*		pwszNextCand = new wchar_t[GetTextLen(iFound + 1) + 1];

				GetText(iFound + 1, pwszNextCand);
				CLexer::CaseFoldString(pwszNextCand, cchCompare);
				const bool	bUnique = wcsncmp(pwszLeftWord, pwszNextCand, cchCompare) != 0;

				delete[] pwszLeftWord;
				delete[] pwszNextCand;
				return bUnique;
			}
		}
	} else
		SetCurSel(-1);
	return false;
}

/* [EOF] */