// AlphaDoc.cpp
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "AlphaDoc.h"
#include "AlphaView.h"
#include "Ambient.h"
using Alpha::CAlphaDoc;
using Alpha::CAlphaView;
using namespace std;


// CAlphaDoc class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAlphaDoc::CAlphaDoc() : m_pAutomation(0) {
}

///	fXgN^
CAlphaDoc::~CAlphaDoc() {
	if(m_pAutomation != 0) {
		m_pAutomation->Dispose();
		m_pAutomation->Release();
	}
}

/// @see	CEditDoc::GetActiveView
CAlphaView& CAlphaDoc::GetActiveView() const throw(logic_error) {
	AssertValid();
	return reinterpret_cast<CAlphaView&>(CEditDoc::GetActiveView());
}

/// @see	CEditDoc::GetView
CAlphaView& CAlphaDoc::GetView(size_t iView) const throw(out_of_range) {
	AssertValid();
	return reinterpret_cast<CAlphaView&>(CEditDoc::GetView(iView));
}

///	I[g[VpC^[tFCXIuWFNgԂ
HRESULT CAlphaDoc::GetAutomation(Alpha::CAlphaApp& app, IBuffer** ppBuffer) const {
	AssertValid();
	VERIFY_POINTER(ppBuffer);

	CAlphaDoc*	pThis = const_cast<CAlphaDoc*>(this);
	if(pThis->m_pAutomation == 0) {	// ܂΍쐬
		if(pThis->m_pAutomation = new Alpha::Ambient::CBuffer(app, *pThis))
			pThis->m_pAutomation->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(*ppBuffer = pThis->m_pAutomation)->AddRef();
	return S_OK;
}

/// @see	CEditDoc::GetFileName
const TCHAR* CAlphaDoc::GetFileName() const {
	static const wstring	strUntitled = CAlphaApp::GetInstance().LoadString(MSG_DEFAULT_UNTITLED_BUFFER);
	const TCHAR* const	pwsz = CEditDoc::GetFileName();
	return (pwsz != 0) ? pwsz : strUntitled.c_str();
}

/* [EOF] */