// Alpha.cpp : AvP[Vp̃Gg |Cg̒`
// (c) 2003-2005 exeal

#include "StdAfx.h"
#include "Alpha.h"
#include "Ambient.h"
#include "CommandManager.h"
#include "EventHandlerScript.h"
#include "MRUManager.h"
#include "AboutDlg.h"
#include "FindDlg.h"
#include "GotoLineDlg.h"
#include "BookmarkDlg.h"
#include "CodePagesDlg.h"
#include "FilePropertyDlg.h"
#include "FileOperationDlg.h"
#include "ExecuteCommandDlg.h"
//#include "DebugDlg.h"
#include "SelectLanguageDlg.h"
#include "ConfirmUnsavedDocumentDlg.h"
#include "NewFileFormatDlg.h"
#include "../Manah/WaitCursor.h"
#include "../Manah/DC.h"
#include "../Manah/GDIObject.h"
#include "../Manah/ComboBox.h"
#include <algorithm>
#include <fstream>
#include <dlgs.h>
//#include "Msxml3.tlh"	// MSXML2::IXMLDOMDocument
using namespace Alpha;
using namespace Ascension;
using namespace Ascension::Encodings;
using namespace Ascension::StandardCommands;
using namespace Manah::Windows;
using namespace Manah::Windows::GDI;
using namespace Manah::Windows::Controls;
using namespace Armaiti;
using namespace std;


// O[o֐
/////////////////////////////////////////////////////////////////////////////

///	Gg|Cg
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE /* hPrevInstance */, LPSTR /* lpCmdLine */, int nCmdShow) {
	OSVERSIONINFOA	osvi;

#ifdef _DEBUG
	::_CrtSetDbgFlag(_CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF | _CRTDBG_CHECK_EVERY_1024_DF);
#endif /* _DEBUG */

	// NT nׂ
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOA);
	::GetVersionExA(&osvi);
	if(!toBoolean(osvi.dwPlatformId & VER_PLATFORM_WIN32_NT)) {
		char	szPrompt[100];
		::LoadStringA(hInstance, MSG_UNSUPPORTED_OS_VERSION, szPrompt, _countof(szPrompt));
		::MessageBoxA(0, szPrompt, "Alpha", MB_ICONHAND);	// title is obtained from IDS_APPNAME
		return -1;
	}
	HANDLE	hMutex = ::CreateMutexW(0, false, IDS_APPFULLVERSION);

	int	nExitCode = 0/*EXIT_SUCCESS*/;

	// ȒPȑdN}~
	if(::GetLastError() != ERROR_ALREADY_EXISTS) {	// B Alpha vZX
		CAlphaApp*				pApplication = new CAlphaApp();
		INITCOMMONCONTROLSEX	iccex;

		::OleInitialize(0);	// STA ɓ + T[rX̏
		memset(&iccex, 0, sizeof(INITCOMMONCONTROLSEX));
		iccex.dwSize = sizeof(INITCOMMONCONTROLSEX);
		iccex.dwICC = ICC_WIN95_CLASSES | ICC_COOL_CLASSES;
		::InitCommonControlsEx(&iccex);
		pApplication->InitApplication(hInstance);
		pApplication->InitInstance(nCmdShow);
		nExitCode = pApplication->Run();
		delete pApplication;
		::OleUninitialize();
	} else {	// ̃vZXɃR}hCn
		HWND	hExistWnd = ::FindWindowW(IDS_APPNAME, 0);
		while(!toBoolean(::IsWindow(hExistWnd))) {
			::Sleep(1000);
			hExistWnd = ::FindWindowW(IDS_APPNAME, 0);
		}
		COPYDATASTRUCT	cd = {0,
			(wcslen(::GetCommandLineW()) + 1) * sizeof(wchar_t), ::GetCommandLineW()};
		::SendMessageW(hExistWnd, WM_COPYDATA, 0, reinterpret_cast<LPARAM>(&cd));
		::Sleep(300);
		::SetForegroundWindow(hExistWnd);
	}
	::CloseHandle(hMutex);

	return nExitCode;
}

namespace {
	///	ChooseFontW ̂߂̃tbNvVW
	UINT CALLBACK CFHookProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) {
		if(message == WM_COMMAND && LOWORD(wParam) == psh3) {	// [Kp] {^
			LOGFONTW	lf;
			::SendMessageW(hDlg, WM_CHOOSEFONT_GETLOGFONT, 0, reinterpret_cast<LPARAM>(&lf));
			CAlphaApp::GetInstance().SetFont(lf);
			return TRUE;
		} else if(message == WM_INITDIALOG) {
			::EnableWindow(::GetDlgItem(hDlg, stc2), false);	// [X^C] 𖳌
			::EnableWindow(::GetDlgItem(hDlg, cmb2), false);
		}
		return 0;
	}

	///	GetOpenFileNameW AGetSaveFileNameW ̂߂̃tbNvVW
	UINT CALLBACK OFNHookProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
		CComboBox	codePageCombobox, breakCodeCombobox;
		CWindow		codePageLabel, breakCodeLabel;

		switch(message) {
		case WM_COMMAND:
			// [R[hy[W] ύXꂽ
			if(LOWORD(wParam) == IDC_COMBO_CHARCODE && HIWORD(wParam) == CBN_SELCHANGE) {
				if(!breakCodeCombobox.Attach(::GetDlgItem(hWnd, IDC_COMBO_BREAKCODE)))
					break;
				codePageCombobox.Attach(::GetDlgItem(hWnd, IDC_COMBO_CHARCODE));

				const wstring	strUnchange = CAlphaApp::GetInstance().LoadString(MSG_UNCHANGE_BREAK_TYPE);
				const CodePage	cp = codePageCombobox.GetItemData(codePageCombobox.GetCurSel());
				const int		iBreakCode = (breakCodeCombobox.GetCount() != 0) ? breakCodeCombobox.GetCurSel() : 0;

				if(cp == CPEX_UNICODE_UTF5 || cp == CP_UTF7 || cp == CP_UTF8
						|| cp == CPEX_UNICODE_UTF16LE || cp == CPEX_UNICODE_UTF16BE
						|| cp == CPEX_UNICODE_UTF32LE || cp == CPEX_UNICODE_UTF32BE) {
					if(breakCodeCombobox.GetCount() != 7) {
						breakCodeCombobox.ResetContent();
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(strUnchange.c_str()), Ascension::LB_AUTO);
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(IDS_BREAK_CRLF), Ascension::LB_CRLF);
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(IDS_BREAK_LF), Ascension::LB_LF);
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(IDS_BREAK_CR), Ascension::LB_CR);
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(IDS_BREAK_NEL), Ascension::LB_NEL);
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(IDS_BREAK_LS), Ascension::LB_LS);
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(IDS_BREAK_PS), Ascension::LB_PS);
						breakCodeCombobox.SetCurSel(iBreakCode);
					}
				} else {
					if(breakCodeCombobox.GetCount() != 4) {
						breakCodeCombobox.ResetContent();
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(strUnchange.c_str()), Ascension::LB_AUTO);
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(IDS_BREAK_CRLF), Ascension::LB_CRLF);
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(IDS_BREAK_LF), Ascension::LB_LF);
						breakCodeCombobox.SetItemData(breakCodeCombobox.AddString(IDS_BREAK_CR), Ascension::LB_CR);
						breakCodeCombobox.SetCurSel((iBreakCode < 4) ? iBreakCode : 0);
					}
				}
				codePageCombobox.Detach();
				breakCodeCombobox.Detach();
			}
			break;
		case WM_INITDIALOG: {
			LPOPENFILENAMEW	lpOFN = reinterpret_cast<LPOPENFILENAMEW>(lParam);
			HWND			hDlg = ::GetParent(hWnd);
			set<CodePage>	codePages;
			POINT			pt;
			RECT			rect;
			long			x;

			codePageCombobox.Attach(::GetDlgItem(hWnd, IDC_COMBO_CHARCODE));
			codePageLabel.Attach(::GetDlgItem(hWnd, IDC_STATIC_1));
			breakCodeCombobox.Attach(::GetDlgItem(hWnd, IDC_COMBO_BREAKCODE));
			breakCodeLabel.Attach(::GetDlgItem(hWnd, IDC_STATIC_2));

			// _CAOev[g̃Rg[̈ʒu킹
			::GetWindowRect(hWnd, &rect);
			pt.x = rect.left;
			pt.y = rect.top;

			// x
			::GetWindowRect(::GetDlgItem(hDlg, stc2), &rect);
			x = rect.left;
			codePageLabel.GetWindowRect(rect);
			codePageLabel.SetWindowPos(0, x - pt.x, rect.top - pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
			if(breakCodeLabel.IsWindow()) {
				breakCodeLabel.GetWindowRect(rect);
				breakCodeLabel.SetWindowPos(0, x - pt.x, rect.top - pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
			}

			// R{{bNX
			::GetWindowRect(::GetDlgItem(hDlg, cmb1), &rect);
			x = rect.left;
			codePageCombobox.GetWindowRect(rect);
			codePageCombobox.SetWindowPos(0, x - pt.x, rect.top - pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
			if(breakCodeCombobox.IsWindow()) {
				breakCodeCombobox.GetWindowRect(rect);
				breakCodeCombobox.SetWindowPos(0, x - pt.x, rect.top - pt.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
			}

			const CEncoderFactory&	encoders = CEncoderFactory::GetInstance();
			encoders.EnumCodePages(codePages);
			for(set<CodePage>::const_iterator it = codePages.begin(); it != codePages.end(); ++it) {
				if(breakCodeCombobox.IsWindow()
						&& (encoders.IsCodePageForAutoDetection(*it) || encoders.IsCodePageForAutoDetection(*it)))
					continue;
				const wchar_t*	pwszCPName = CAlphaApp::GetCodePageName(*it);
				if(pwszCPName == 0)
					continue;
				codePageCombobox.SetItemData(codePageCombobox.AddString(pwszCPName), *it);
			}

			const UINT	cCodePages = codePageCombobox.GetCount();
			codePageCombobox.SetCurSel(0);
			for(UINT i = 0; i < cCodePages; ++i) {
				if((lpOFN->lCustData & 0x00FFFFFF) == codePageCombobox.GetItemData(i)) {
					codePageCombobox.SetCurSel(i);
					break;
				}
			}

			if(breakCodeCombobox.IsWindow()) {
				switch(lpOFN->lCustData >> 24) {
				case LB_AUTO:	breakCodeCombobox.SetCurSel(0);	break;
				case LB_CRLF:	breakCodeCombobox.SetCurSel(1);	break;
				case LB_LF:		breakCodeCombobox.SetCurSel(2);	break;
				case LB_CR:		breakCodeCombobox.SetCurSel(3);	break;
				case LB_NEL:	breakCodeCombobox.SetCurSel(4);	break;
				case LB_LS:		breakCodeCombobox.SetCurSel(5);	break;
				case LB_PS:		breakCodeCombobox.SetCurSel(6);	break;
				}
				::SendMessageW(hWnd, WM_COMMAND, MAKEWPARAM(IDC_COMBO_CHARCODE, CBN_SELCHANGE), 0);
			}

			codePageCombobox.Detach();
			codePageLabel.Detach();
			breakCodeCombobox.Detach();
			breakCodeLabel.Detach();
		}
			break;
		case WM_NOTIFY: {
			if(reinterpret_cast<LPNMHDR>(lParam)->code == CDN_FILEOK) {
				LPOFNOTIFYW	lpOFNOIFY = reinterpret_cast<LPOFNOTIFYW>(lParam);

				codePageCombobox.Attach(::GetDlgItem(hWnd, IDC_COMBO_CHARCODE));
				breakCodeCombobox.Attach(::GetDlgItem(hWnd, IDC_COMBO_BREAKCODE));

				lpOFNOIFY->lpOFN->lCustData = codePageCombobox.GetItemData(codePageCombobox.GetCurSel());
				if(breakCodeCombobox.IsWindow()) {
					switch(breakCodeCombobox.GetCurSel()) {
					case 0:	lpOFNOIFY->lpOFN->lCustData |= LB_AUTO << 24;	break;
					case 1:	lpOFNOIFY->lpOFN->lCustData |= LB_CRLF << 24;	break;
					case 2:	lpOFNOIFY->lpOFN->lCustData |= LB_LF << 24;		break;
					case 3:	lpOFNOIFY->lpOFN->lCustData |= LB_CR << 24;		break;
					case 4:	lpOFNOIFY->lpOFN->lCustData |= LB_NEL << 24;	break;
					case 5:	lpOFNOIFY->lpOFN->lCustData |= LB_LS << 24;		break;
					case 6:	lpOFNOIFY->lpOFN->lCustData |= LB_PS << 24;		break;
					}
				}

				codePageCombobox.Detach();
				breakCodeCombobox.Detach();
			}
		}
			break;
		}

		return 0L;
	}

	class CFileIoCallback : virtual public IFileIoCallback {
	public:
		CFileIoCallback(CAlphaApp& app, bool bForLoading, const wchar_t* pwszFile, CodePage encoding)
				: m_app(app), m_bForLoading(bForLoading), m_pwszFile(pwszFile),
				m_encoding(encoding), m_bRetryWithOtherCodePage(false) {}
		bool DoesUserWantToChangeCodePage() const {
			return m_bRetryWithOtherCodePage;
		}
		bool OnFoundUnconvertableCharacter() {
			const int	nAnswer = m_app.MessageBox(m_bForLoading ?
				MSG_UNCONVERTABLE_NATIVE_CHAR : MSG_UNCONVERTABLE_UCS_CHAR,
				MB_YESNOCANCEL | MB_ICONEXCLAMATION, __MARGS__ % m_pwszFile % CAlphaApp::GetCodePageName(m_encoding));
			if(nAnswer == IDYES)
				m_bRetryWithOtherCodePage = true;
			return nAnswer == IDNO;
		}
	private:
		CAlphaApp&				m_app;
		const bool				m_bForLoading;
		const wchar_t* const	m_pwszFile;
		const CodePage			m_encoding;
		bool					m_bRetryWithOtherCodePage;
	};
} // namespace `anonymous'


// CDocumentTypeManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDocumentTypeManager::CDocumentTypeManager() {
	TDocumentType	type;

	wcscpy(type.wszFileSpec, L"");
	type.strName = L"default";
	type.bPrivate = false;
	m_documentTypes.push_back(type);
}

/**
 *	^Cv̒ǉ
 *	@param type	o^镶^Cv
 */
void CDocumentTypeManager::Add(const TDocumentType& type) throw(invalid_argument) {
	if(type.strName.empty())
		throw invalid_argument("Document type name can not be empty.");
	else if(wcslen(type.wszFileSpec) == 0)
		throw invalid_argument("File name specification can not be empty.");
	m_documentTypes.push_back(type);
}

/**
 *	w肵O̕^Cv̔ԍԂ
 *	@param strName	^Cv
 *	@return			ԍBȂꍇ0
 */
size_t CDocumentTypeManager::Find(const wstring& strName) const {
	for(size_t i = 1; i < m_documentTypes.size(); ++i) {
		if(m_documentTypes[i].strName == strName)
			return i;
	}
	return 0;
}

/**
 *	wʒu̕^CvԂ
 *	@param iType	ʒu
 *	@return			^Cv
 */
const TDocumentType& CDocumentTypeManager::GetAt(size_t iType) const throw(out_of_range) {
	try {
		return m_documentTypes.at(iType);
	} catch(...) {
		throw out_of_range("Specified index is invalid.");
	}
}

/**
 *	gqɓK镶^CvԂ
 *	@param strFileName	t@C
 *	@return				^CvBK镶^CvȂꍇ0Ԗ () Ԃ
 */
const TDocumentType& CDocumentTypeManager::GetByFileName(const wstring& strFileName) const {
	if(strFileName.empty())
		return m_documentTypes[0];
	for(size_t i = 1; i < m_documentTypes.size(); ++i) {
		if(toBoolean(::PathMatchSpecW(strFileName.c_str(), m_documentTypes[i].wszFileSpec)))
			return m_documentTypes[i];
	}
	return m_documentTypes[0];
}

///	o^Ă镶^Cv̑Ԃ
size_t CDocumentTypeManager::GetCount() const {
	return m_documentTypes.size();
}

///	o^Ă镶Sč폜
void CDocumentTypeManager::RemoveAll() {
	m_documentTypes.clear();
	CDocumentTypeManager();
}


// CEditorWindow class implementation
/////////////////////////////////////////////////////////////////////////////

/// RXgN^
CEditorPane::CEditorPane(CAlphaView* pInitialView /* = 0 */) :
		m_pVisibleView(pInitialView), m_pLastVisibleView(0), m_pAutomation(0) {
	if(pInitialView != 0)
		AddView(*pInitialView);
}

/// Rs[RXgN^
CEditorPane::CEditorPane(const CEditorPane& rhs) : m_pAutomation(0) {
	for(set<CAlphaView*>::const_iterator it = rhs.m_views.begin(); it != rhs.m_views.end(); ++it) {
		CAlphaView*	pView = new CAlphaView(*(*it));
		const bool	bSucceeded = pView->Create((*it)->GetParent(), DefaultWindowRect(),
			WS_CHILD | WS_CLIPCHILDREN | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_CLIENTEDGE);

		assert(bSucceeded);
		m_views.insert(pView);
		if(*it == rhs.m_pVisibleView)
			m_pVisibleView = pView;
		if(*it == rhs.m_pLastVisibleView)
			m_pLastVisibleView = pView;
	}
}

/// fXgN^
CEditorPane::~CEditorPane() {
	RemoveAll();
	if(m_pAutomation != 0) {
		reinterpret_cast<Ambient::CEditorPane*>(m_pAutomation)->Dispose();
		m_pAutomation->Release();
	}
}

/// r[ǉ
void CEditorPane::AddView(CAlphaView& view) {
	m_views.insert(&view);
	if(m_views.size() == 1)
		ShowBuffer(view.GetDocument());
}


/// IEditorPane I[g[VIuWFNgԂ
HRESULT CEditorPane::GetAutomation(IEditorPane** pp) const {
	VERIFY_POINTER(pp);
	CEditorPane*	pThis = const_cast<CEditorPane*>(this);
	if(pThis->m_pAutomation == 0) {
		if(pThis->m_pAutomation = new Ambient::CEditorPane(CAlphaApp::GetInstance().GetEditorPane(), *pThis))
			pThis->m_pAutomation->AddRef();
		else
			return E_OUTOFMEMORY;
	}
	(*pp = pThis->m_pAutomation)->AddRef();
	return S_OK;
}

/// SẴr[폜
void CEditorPane::RemoveAll() {
	for(set<CAlphaView*>::iterator it = m_views.begin(); it != m_views.end(); ++it)
		(*it)->GetDocument().RemoveAndReleaseView(**it);
	m_views.clear();
	m_pVisibleView = m_pLastVisibleView = 0;
}

/// w肵obt@̃r[폜
void CEditorPane::RemoveBuffer(const CAlphaDoc& buffer) {
	for(set<CAlphaView*>::iterator it = m_views.begin(); it != m_views.end(); ++it) {
		if(&(*it)->GetDocument() == &buffer) {
			CAlphaView&	removing = **it;

			m_views.erase(it);
			if(&removing == m_pVisibleView) {
				m_pVisibleView = 0;
				if(&removing == m_pLastVisibleView)
					m_pLastVisibleView = 0;
				if(m_views.size() == 1 || m_pLastVisibleView == 0)
					ShowBuffer((*m_views.begin())->GetDocument());
				else if(!m_views.empty()) {
					ShowBuffer(m_pLastVisibleView->GetDocument());
					m_pLastVisibleView = 0;
				}
			}
			removing.GetDocument().RemoveAndReleaseView(removing);
			return;
		}
	}
}

/// w肵obt@̃r[\
void CEditorPane::ShowBuffer(const CAlphaDoc& buffer) {
	if(m_pVisibleView != 0 && &m_pVisibleView->GetDocument() == &buffer)
		return;
	for(set<CAlphaView*>::iterator it = m_views.begin(); it != m_views.end(); ++it) {
		if(&(*it)->GetDocument() == &buffer) {
			const bool	bHadFocus = m_pVisibleView == 0 || m_pVisibleView->HasFocus();
			m_pLastVisibleView = m_pVisibleView;
			m_pVisibleView = *it;
			CAlphaApp::GetInstance().GetEditorPane().AdjustPanes();
			m_pVisibleView->ShowWindow(SW_SHOW);
			if(m_pLastVisibleView != 0)
				m_pLastVisibleView->ShowWindow(SW_HIDE);
			if(bHadFocus)
				m_pVisibleView->SetFocus();
			break;
		}
	}
}


// CAlphaApp class implementation
/////////////////////////////////////////////////////////////////////////////

CAlphaApp* CAlphaApp::m_pInstance = 0;

///	RXgN^
CAlphaApp::CAlphaApp()
		: m_pMenu(0), m_pFileOpeMenu(0), m_pNewDocTypeMenu(0), m_pAppDocTypeMenu(0), m_pBufferBarMenu(0),
		m_bSizingOutputWnd(false), m_hCommonFont(0),
		m_pEventHandlerScript(0), /*m_pActiveDebugger(0), m_pDebuggingEditor(0),*/
		m_pMRUManager(0), m_pScriptMacroManager(0), m_pApplication(0), m_pBuffers(0),
		m_2Stroke1stKey(VK_NULL), m_2Stroke1stModifiers(0), m_hNarrowingIcon(0) {
	assert(CAlphaApp::m_pInstance == 0);
	CAlphaApp::m_pInstance = this;
	m_pNewDocTypeMenu = new CMenu();
	m_pCommandManager = new CCommandManager(*this);
	m_pScriptMacroManager = new CScriptMacroManager(*this);
	m_pdlgSearch = new CFindDlg(*this);
	m_pdlgGotoLine = new CGotoLineDlg(*this);
	m_pdlgBookmark = new CBookmarkDlg(*this);
/*	m_pdlgDebugBreakPoints = new CDebugBreakPointsDlg;
	m_pdlgDebugCallStack = new CDebugCallStackDlg;
	m_pdlgDebugImmediate = new CDebugImmediateDlg;
	m_pdlgDebugRunningDocuments = new CDebugRunningDocumentsDlg;
	m_pdlgDebugThreads = new CDebugThreadsDlg;
	m_pdlgDebugVariables = new CDebugVariablesDlg;*/
	OnSettingChange(0, 0);	// m_hStatusFont ̏
}

///	fXgN^
CAlphaApp::~CAlphaApp() {
	::DestroyAcceleratorTable(m_hAcceleratorTable);
	::DeleteObject(m_hStatusFont);
	::DestroyIcon(m_hNarrowingIcon);
//	delete m_pMenu;
	delete m_pFileOpeMenu;
	delete m_pNewDocTypeMenu;
	delete m_pAppDocTypeMenu;
	delete m_pBufferBarMenu;
	delete m_pEventHandlerScript;
	delete m_pCommandManager;
	delete m_pScriptMacroManager;
	delete m_pdlgSearch;
	delete m_pdlgGotoLine;
	delete m_pdlgBookmark;
/*	delete m_pdlgDebugBreakPoints;
	delete m_pdlgDebugCallStack;
	delete m_pdlgDebugImmediate;
	delete m_pdlgDebugRunningDocuments;
	delete m_pdlgDebugThreads;
	delete m_pdlgDebugVariables;*/
	if(m_pApplication != 0)
		m_pApplication->Release();
	if(m_pBuffers != 0)
		m_pBuffers->Release();
	CAlphaApp::m_pInstance = 0;
}

/**
 *	w肵r[ɃhLg^CvKp
 *	@param iBuffer		obt@ԍ
 *	@param strTypeName	Kp镶^CvB󕶎w肷Ɗgqɍ̂Kp
 */
void CAlphaApp::ApplyDocumentType(size_t iBuffer, const wstring& strTypeName /* = L"" */) throw(out_of_range) {
	AssertValid();

	Manah::Windows::CWaitCursor	wc;
	CAlphaView&	view = m_buffers.GetAt(iBuffer).GetActiveView();

	// CxgnhĂяo
	const wstring	strDocTypeName = strTypeName.empty() ?
		m_buffers.GetDocumentTypeManager().GetByFileName(view.GetDocument().GetFileName()).strName : strTypeName;

	if(strDocTypeName.empty()
			|| strDocTypeName != view.GetDocument().m_strDocType) {
		AutoZero<DISPPARAMS>	params;
		ITextEditor*			pEditor;

		view.GetAutomation(&pEditor);
		view.Freeze();
		view.GetLexer().Freeze();
		view.GetLexer().Reset();
		params.cArgs = 2;
		params.rgvarg = new VARIANTARG[params.cArgs];
		params.rgvarg[1].vt = VT_BSTR;
		params.rgvarg[1].bstrVal = ::SysAllocString(strDocTypeName.c_str());
		params.rgvarg[0].vt = VT_DISPATCH;
		params.rgvarg[0].pdispVal = pEditor;
		const HRESULT	hr = m_pEventHandlerScript->Invoke(OLESTR("OnApplyDocumentType"), &params);
		::SysFreeString(params.rgvarg[1].bstrVal);
		params.rgvarg[0].pdispVal->Release();
		delete[] params.rgvarg;
		view.GetLexer().Unfreeze();
		view.GetDocument().m_strDocType = strDocTypeName;
		view.Unfreeze();
	}
	_UpdateStatusBar(SBP_DOCUMENTTYPE);
}

LRESULT CALLBACK CAlphaApp::AppWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	return (m_pInstance != 0) ?
		m_pInstance->DispatchEvent(hWnd, message, wParam, lParam) : ::DefWindowProc(hWnd, message, wParam, lParam);
}

///	[tHg] _CAO\ăGfB^̃tHgύX
void CAlphaApp::_ChangeFont() {
	CAlphaView&				activeView = GetActiveView();
	LOGFONTW				lf;
	AutoZeroLS<CHOOSEFONTW>	cf;

	::GetObject(m_hCommonFont, sizeof(LOGFONTW), &lf);
	cf.hwndOwner = GetMainWindow().GetSafeHwnd();
	cf.lpLogFont = &lf;
	cf.lpfnHook = CFHookProc;
	cf.Flags = CF_APPLY | CF_ENABLEHOOK | CF_INITTOLOGFONTSTRUCT | CF_NOVERTFONTS | CF_SCREENFONTS;
	cf.hInstance = m_hInstance;

	if(toBoolean(::ChooseFontW(&cf))) {
		lf.lfItalic = false;
		lf.lfWeight = FW_REGULAR;
		SetFont(lf);
	}
}

/**
 *	SāA͔ANeBuȑSẴobt@
 *	@param bExceptActive	ANeBuȃobt@cꍇ true
 *	@return					1[UɋۂȂ true
 */
bool CAlphaApp::CloseAllBuffers(bool bQueryUser, bool bExceptActive /* = false */) {
	const size_t	iCurrent = GetActiveBufferIndex();

	GetMainWindow().LockWindowUpdate();

	// ۑ̕Kv̖obt@S
	for(size_t i = m_buffers.GetCount(); i != 0; --i) {
		if(bExceptActive && i - 1 == iCurrent)
			continue;
		if(!m_buffers.GetAt(i - 1).IsModified())
			CloseBuffer(i - 1, false);
	}

	GetMainWindow().UnlockWindowUpdate();

	// ۑ̃obt@ΏI
	if(m_buffers.GetCount() == 1) {
		if(bExceptActive || !GetActiveBuffer().IsModified())
			return true;
	}

	// ۑ̃obt@1Ȃʏ̊mF_CAOoďI
	if(m_buffers.GetCount() - (bExceptActive ? 1 : 0) == 1) {
		const size_t	iDirty = !bExceptActive ? 0 : ((iCurrent == 0) ? 1 : 0);

		if(m_buffers.GetAt(iDirty).IsModified()) {
			if(bExceptActive)
				SetActiveBuffer(m_buffers.GetAt(iDirty));
			return CloseBuffer(GetActiveBufferIndex(), bQueryUser);
		}
	}

	// ̃obt@ۑ邩ǂmF_CAOo
	CConfirmUnsavedDocumentDlg	dlg;
	for(size_t i = 0; i < m_buffers.GetCount(); ++i) {
		if(bExceptActive && i == iCurrent)
			continue;
		TDirtyFile	tf;
		tf.index = i;
		tf.strFileName = m_buffers.GetAt(i).GetFileName();
		tf.bSave = true;
		dlg.m_files.push_back(tf);
	}
	dlg.Create(m_hInstance, GetMainWindow());
	if(IDOK != dlg.DoModal())
		return false;

	// ۑ
	for(vector<TDirtyFile>::reverse_iterator it = dlg.m_files.rbegin(); it != dlg.m_files.rend(); ++it) {
		if(it->bSave) {
			if(!SaveBuffer(it->index))
				return false;
		}
		if(!CloseBuffer(it->index, false))
			return false;
	}

	return true;
}

/**
 *	obt@
 *	@param iBuffer		obt@̃CfNX
 *	@param bQueryUser	ۑ̃obt@̏ꍇA[UɊmF邩
 *	@return				obt@ۂɕꍇ true
 *	@throw out_of_range	<var>iBuffer</var> sȂƂX[
 */
bool CAlphaApp::CloseBuffer(size_t iBuffer, bool bQueryUser) throw (out_of_range) {
	AssertValid();

	CAlphaDoc&	buffer = m_buffers.GetAt(iBuffer);

	if(bQueryUser) {	// [UɊmFꍇ
		// fobO~̊mF
/*		if(m_pDebuggingEditor != 0 && pActiveEditor == m_pDebuggingEditor) {
			if(IDNO == MessageBox(MSG_DEBUG_DOCUMENTISDEBUGGING, MB_YESNO | MB_ICONQUESTION)))
				return false;
			m_pActiveDebugger->Abort();
		}
*/
		// ۑ̊mF
		if(buffer.IsModified()) {
			SetActiveBuffer(buffer);
			const int	nAnswer = MessageBox(MSG_FILE_IS_DIRTY,
				MB_YESNOCANCEL | MB_ICONEXCLAMATION, __MARGS__ % buffer.GetFileName());
			if(nAnswer == IDCANCEL)
				return false;
			else if(nAnswer == IDYES && !SaveBuffer(iBuffer))
				return false;
		}
	}

	// mFȂƂ̂
/*	if(m_pDebuggingEditor != 0 && pActiveEditor == m_pDebuggingEditor) {
		if(m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging())
			m_pActiveDebugger->Abort();
	}*/

	if(m_buffers.GetCount() > 1) {
		// ʂ̃r[ANeBuɂ
		m_bufferBar.DeleteButton(m_buffers.GetCount() - 1);
		for(EditorWindow::Iterator it = m_editorWindow.EnumeratePanes(); !it.IsEnd(); it.Next())
			it.Get().RemoveBuffer(buffer);

		m_buffers.Remove(iBuffer);

		if(m_buffers.GetCount() == 0)
			NewBuffer();
		else {
			if(iBuffer == 0)	// obt@o[̃{^𐳂łȂ݂Ȃ...
				OnActiveViewChanged(GetActiveView());
			for(size_t i = iBuffer; i < m_buffers.GetCount(); ++i)
				m_bufferBar.SetButtonText(CMD_VIEW_BUFFERLIST_START + i, GetBufferName(m_buffers.GetAt(i)).c_str());
			_ResetBufferBarIcons();
		}
	} else {	// Ō1̏ꍇ
		buffer.Close(true);
		ApplyDocumentType(0);
		_ResetBufferBarIcons();
		_UpdateStatusBar(SBP_ALL);
		_UpdateTitleBar();
	}

	return true;
}

LRESULT	CAlphaApp::DispatchEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_ACTIVATE:
//		if(wParam != WA_INACTIVE && !m_vecDocuments.empty() && m_iActiveTab != -1)
//			::SetFocus(GetActiveTab()->GetWindow());
		return 0L;
//	case WM_ACTIVATEAPP:
//		if(toBoolean(wParam) && m_pMainWindow != 0)
//			m_pMainWindow->SetFocus();
//		return 0L;
	case WM_COMMAND:
		return OnCommand(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
	case WM_CLOSE:
		OnClose();
		return 0;
	case WM_COPYDATA:
		OnCopyData(reinterpret_cast<HWND>(wParam), reinterpret_cast<PCOPYDATASTRUCT>(lParam));
		break;
	case WM_CREATE:
		break;
	case WM_DESTROY:
		OnDestroy();
		break;
	case WM_DRAWITEM:
		OnDrawItem(wParam, reinterpret_cast<LPDRAWITEMSTRUCT>(lParam));
		break;
	case WM_DROPFILES:
		OnDropFiles(reinterpret_cast<HDROP>(wParam));
		break;
	case WM_ENTERMENULOOP:
		OnEnterMenuLoop(toBoolean(wParam));
		break;
	case WM_EXITMENULOOP:
		OnExitMenuLoop(toBoolean(wParam));
		break;
	case WM_INITMENU:
		OnInitMenu(reinterpret_cast<HMENU>(wParam));
		break;
	case WM_INITMENUPOPUP:
		OnInitMenuPopup(reinterpret_cast<HMENU>(wParam), LOWORD(lParam), toBoolean(HIWORD(lParam)));
		break;
//	case WM_KILLFOCUS:
//		// r[ɓ]
//		if(!m_vecDocuments.empty())
//			return ::SendMessage(GetActiveTab()->GetWindow(), message, wParam, lParam);
//		return 0L;
	case WM_MEASUREITEM:
		OnMeasureItem(wParam, reinterpret_cast<LPMEASUREITEMSTRUCT>(lParam));
		break;
	case WM_MENUCHAR: {
		CMenu*	pActivePopup = new CMenu(reinterpret_cast<HMENU>(lParam));
		LRESULT	res = OnMenuChar(LOWORD(wParam), HIWORD(wParam), pActivePopup);
//		res = pActivePopup->ExecuteMenuChar(LOWORD(wParam), HIWORD(wParam));
		delete pActivePopup;
		return res;
	}
	case WM_MENUSELECT:
		OnMenuSelect(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HMENU>(lParam));
		break;
	case WM_MOUSEMOVE: {
		POINT	pt = {LOWORD(lParam), HIWORD(lParam)};
		OnMouseMove(wParam, pt);
		return 0L;
	}
	case WM_NOTIFY:
		OnNotify(wParam, reinterpret_cast<LPNMHDR>(lParam));
		break;
	case WM_QUERYENDSESSION:
		return OnClose();
	case WM_SETCURSOR:
		if(OnSetCursor(reinterpret_cast<HWND>(wParam),
				static_cast<UINT>(LOWORD(lParam)), static_cast<UINT>(HIWORD(lParam))))
			return false;
		break;
	case WM_SETFOCUS:
		// m_iActiveView 悤ƂĂr[w\
//		if(m_buffers.GetCount() != 0 && m_buffers.GetActiveDocumentIndex() != -1
//				&& reinterpret_cast<HWND>(wParam) != m_documents.GetActiveDocument()->GetWindow())
//			::SendMessage(m_documents.GetActiveDocument()->GetWindow(), message, wParam, lParam);
		m_editorWindow.SetFocus();
		return 0L;
	case WM_SETTINGCHANGE:
		OnSettingChange(wParam, reinterpret_cast<wchar_t*>(lParam));
		break;
	case WM_SIZE:
		OnSize(wParam, LOWORD(lParam), HIWORD(lParam));
		break;
	case WM_TIMER:
		OnTimer(wParam);
		break;
	case MYWM_CALLOVERTHREAD:
		reinterpret_cast<_ICallable*>(lParam)->Call();
		return true;
	case MYWM_ENDSCRIPTMACRO: {
		CAlphaView&	view = m_editorWindow.GetActivePane().GetVisibleView();
		view.InvalidateRect(0);
		view.EnableWindow(true);	// [ (ScriptMacroManager.cpp  _InputBlocker Q)
//		view.SetFocus();
		m_editorWindow.SetFocus();
		}
		return true;
	case MYWM_EVENTHANDLER:
		m_pEventHandlerScript->Invoke(
			reinterpret_cast<pair<const OLECHAR*, DISPPARAMS*>*>(lParam)->first,
			reinterpret_cast<pair<const OLECHAR*, DISPPARAMS*>*>(lParam)->second);
		return true;
	}
	return ::DefWindowProc(hWnd, message, wParam, lParam);
}

/**
 *	I[g[VpC^[tFCXIuWFNgԂ
 *	@param ppApplication	[out] AvP[V (KvȂ null ł悢)
 *	@param ppDocuments		[out] RNV (KvȂ null ł悢)
 */
HRESULT CAlphaApp::GetAutomation(
		Alpha::Ambient::CApplication** ppApplication, Alpha::Ambient::CBuffers** ppBuffers) const {
	AssertValid();

	CAlphaApp*	pThis = const_cast<CAlphaApp*>(this);

	if(ppApplication != 0)	*ppApplication = 0;
	if(ppBuffers != 0)		*ppBuffers = 0;

	if(ppApplication != 0) {
		if(m_pApplication == 0) {
			pThis->m_pApplication = new Alpha::Ambient::CApplication(*pThis);
			if(m_pApplication == 0)
				return E_OUTOFMEMORY;
			pThis->m_pApplication->AddRef();
		}
		*ppApplication = m_pApplication;
		(*ppApplication)->AddRef();
	}
	if(ppBuffers != 0) {
		if(m_pBuffers == 0) {
			pThis->m_pBuffers = new Alpha::Ambient::CBuffers(*pThis);
			if(m_pBuffers == 0)
				return E_OUTOFMEMORY;
			pThis->m_pBuffers->AddRef();
		}
		*ppBuffers = m_pBuffers;
		(*ppBuffers)->AddRef();
	}
	return S_OK;
}

/**
 *	R[hy[W̖OԂBR[hy[WȂ null
 *	@param cp	R[hy[W
 */
const wchar_t* CAlphaApp::GetCodePageName(CodePage cp) {
	static map<CodePage, const wchar_t*>	names;

	if(names.empty()) {
		names[37] = L"č/Ji_ (IBM EBCDIC)";
		names[437] = L"č (ibm-437)";
		names[500] = L"C^[iVi (IBM EBCDIC)";
		names[708] = L"ArA (ASMO)";
		names[709] = L"ArA (ASMO 449+, BCON V4)";	// [*]
		names[710] = L"ArA (Transparent Arabic)";	// [*]
		names[720] = L"ArA (Transparent ASMO)";
		names[737] = L"MV (437G, ibm-737)";
		names[775] = L"og (ibm-775)";
		names[850] = L"[bp (ibm-850)";
		names[852] = L"[bp (ibm-852)";
		names[855] = L"L (ibm-855)";
		names[857] = L"gR (ibm-857)";
		names[858] = L"ꃉe I + [bp (ibm-858)";
		names[860] = L"|gK (ibm-860)";
		names[861] = L"ACXh (ibm-861)";
		names[862] = L"wuC (ibm-862)";
		names[863] = L"Ji_/tX (ibm-863)";
		names[864] = L"ArA (ibm-864)";
		names[865] = L"k (ibm-865)";
		names[866] = L"VA (ibm-866)";
		names[869] = L"MV (ibm-869)";
		names[870] = L"}`K/ROECE (e-2, IBM EBCDIC)";
		names[874] = L"^C (ibm-874)";
		names[875] = L"MV (IBM EBCDIC)";
		names[932] = L"{ (Vtg JIS, windows-932)";
		names[936] = L"ȑ̎ (GBK, windows-936)";
		names[949] = L"؍ (windows-949)";
		names[950] = L"ɑ̎ (Big5, windows-950)";
		names[1026] = L"gR (IBM EBCDIC)";
		names[1047] = L"e-1/Open System (IBM EBCDIC)";
		names[1140] = L"č/Ji_ (37 + [, IBM EBCDIC)";
		names[1141] = L"hCc (20273 + [, IBM EBCDIC)";
		names[1142] = L"f}[N/mEF[ (20277 + [, IBM EBCDIC)";
		names[1143] = L"tBh/XEF[f (20278 + [, IBM EBCDIC)";
		names[1144] = L"C^A (20280 + [, IBM EBCDIC)";
		names[1145] = L"e AJ/XyC (20284 + [, IBM EBCDIC)";
		names[1146] = L"p (20285 + [, IBM EBCDIC)";
		names[1147] = L"tX (20297 + [, IBM EBCDIC)";
		names[1148] = L"C^[iVi (500 + [, IBM EBCDIC)";
		names[1149] = L"ACXh (20871 + [, IBM EBCDIC)";
		names[1200] = L"Unicode (UTF-16)";
		names[1201] = L"Unicode (UTF-16 big endian)";
		names[1250] = L"[bp (windows-1250)";
		names[1251] = L"L (windows-1251)";
		names[1252] = L"[bp (windows-1252)";
		names[1253] = L"MV (windows-1253)";
		names[1254] = L"gR (windows-1254)";
		names[1255] = L"wuC (windows-1255)";
		names[1256] = L"ArA (windows-1256)";
		names[1257] = L"og (windows-1257)";
		names[1258] = L"xgi (windows-1258)";
		names[1361] = L"؍ (Johab)";
		names[10000] = L"[} (Macintosh)";
		names[10001] = L"{ (Macintosh)";
		names[10002] = L"ɑ̎ (Big5, Macintosh)";
		names[10003] = L"؍ (Macintosh)";
		names[10004] = L"ArA (Macintosh)";
		names[10005] = L"wuC (Macintosh)";
		names[10006] = L"MV I (Macintosh)";
		names[10007] = L"L (Macintosh)";
		names[10008] = L"ȑ̎ (GB2312, Macintosh)";
		names[10010] = L"[}jA (Macintosh)";
		names[10017] = L"ENCi (Macintosh)";
		names[10021] = L"^C (Macintosh)";
		names[10029] = L"[bp (Macintosh)";
		names[10079] = L"ACXh (Macintosh)";
		names[10081] = L"gR (Macintosh)";
		names[10082] = L"NA`A (Macintosh)";
		names[12000] = L"Unicode (UTF-32)";
		names[12001] = L"Unicode (UTF-32 big endian)";
		names[20000] = L"p (CNS)";
		names[20001] = L"p (TCA)";
		names[20002] = L"p (Eten)";
		names[20003] = L"p (IBM5550)";
		names[20004] = L"p (TeleText)";
		names[20005] = L"p (Wang)";
		names[20105] = L"IRV C^[iVi At@xbg No.5 (IA5)";
		names[20106] = L"hCc (IA5)";
		names[20107] = L"XEF[f (IA5)";
		names[20108] = L"mEF[ (IA5)";
		names[20127] = L"US-ASCII";
		names[20261] = L"T.61";
		names[20269] = L"Non-Spacing Accent (ISO 6937)";
		names[20273] = L"hCc (IBM EBCDIC)";
		names[20277] = L"f}[N/mEF[ (IBM EBCDIC)";
		names[20278] = L"tBh/XEF[f (IBM EBCDIC)";
		names[20280] = L"C^A (IBM EBCDIC)";
		names[20284] = L"e AJ/XyC (IBM EBCDIC)";
		names[20285] = L"p (IBM EBCDIC)";
		names[20290] = L"{ (J^Jig, IBM EBCDIC)";
		names[20297] = L"tX (IBM EBCDIC)";
		names[20420] = L"ArA (IBM EBCDIC)";
		names[20423] = L"MV (IBM EBCDIC)";
		names[20424] = L"wuC (IBM EBCDIC)";
		names[20833] = L"؍g (IBM EBCDIC)";
		names[20838] = L"^C (IBM EBCDIC)";
		names[20866] = L"VA (KOI8)";
		names[20871] = L"ACXh (IBM EBCDIC)";
		names[20880] = L"L (VA, IBM EBCDIC)";
		names[20905] = L"gR (IBM EBCDIC)";
		names[20924] = L"e-1/Open System (1047 + [, IBM EBCDIC)";
		names[20932] = L"{ (JIS X 0208-1990 & 0212-1990, windows-20932)";
		names[20936] = L"ȑ̎ (GB2312)";
		names[21025] = L"L (ZrAAuKA, IBM EBCDIC)";
		names[21027] = L"Ext Alpha Lowercase";
		names[21866] = L"ENCi (KOI8-U)";
		names[28591] = L"[bp (ISO-8859-1)";
		names[28592] = L"[bp (ISO-8859-2)";
		names[28593] = L"새[bp (ISO-8859-3)";
		names[28594] = L"og (ISO-8859-4)";
		names[28595] = L"L (ISO-8859-5)";
		names[28596] = L"ArA (ISO-8859-6)";
		names[28597] = L"MV (ISO-8859-7)";
		names[28598] = L"wuC (ISO-8859-8, o)";
		names[28599] = L"gR (ISO-8859-9)";
		names[28600] = L"k (ISO-8859-10)";	// [Ǝ]
		names[28601] = L"^C (ISO-8859-11)";	// [Ǝ]
		names[28603] = L"og (ISO-8859-13)";	// [Ǝ]
		names[28604] = L"Pg (ISO-8859-14)";	// [Ǝ]
		names[28605] = L"[bp (ISO-8859-15)";
		names[28606] = L"[bp (ISO-8859-16)";	// [Ǝ]
		names[29001] = L"[bp 3";	// [*]
		names[38598] = L"wuC (ISO-8859-8, _)";
		names[50001] = L"I";	// [*]
		names[50220] = L"{ (ISO-2022-JP, pJ^JiȂ, windows-50220)";
		names[50221] = L"{ (ISO-2022-JP, pJ^Ji, windows-50221)";
		names[50222] = L"{ (ISO-2022-JP, JIS X 0201-1989, windows-50222)";
		names[50225] = L"؍ (ISO-2022-KR)";
		names[50227] = L"ȑ̎ (ISO-2022-CN)";
		names[50229] = L"ɑ̎ (ISO-2022-CN)";
		names[50930] = L"{ (J^Jig)";	// [*]
		names[50931] = L"{ + č/Ji_";	// [*]
		names[50932] = L"{ (I)";	// [*]
		names[50933] = L"؍ + ؍g";	// [*]
		names[50935] = L"ȑ̎ + ȑ̎g";	// [*]
		names[50936] = L"ȑ̎";	// [*]
		names[50937] = L"ɑ̎ + č/Ji_";	// [*]
		names[50939] = L"{ + {ꃉeg";	// [*]
		names[50949] = L"؍ (I)";	// [*]
		names[51932] = L"{ (EUC, windows-51932)";	// [*]
		names[51936] = L"ȑ̎ (EUC, windows-51936)";	// [*]
		names[51949] = L"؍ (EUC, windows-51949)";
		names[51950] = L"ɑ̎ (EUC, windows-51950)";	// [*]
		names[52936] = L"ȑ̎ (HZ-GB2312)";
		names[54936] = L"ȑ̎ (GB18030)";	// [WinXP ̂]
		names[57002] = L"qfB[ (ISCII, foiK)";
		names[57003] = L"xK (ISCII)";
		names[57004] = L"^~ (ISCII)";
		names[57005] = L"eO (ISCII)";
		names[57006] = L"AbT (ISCII)";
		names[57007] = L"I[ (ISCII)";
		names[57008] = L"Ji_ (ISCII)";
		names[57009] = L"} (ISCII)";
		names[57010] = L"OW[g (ISCII)";
		names[57011] = L"pWu (ISCII, OL[)";
		names[65000] = L"Unicode (UTF-7)";
		names[65001] = L"Unicode (UTF-8)";
		names[CPEX_AUTODETECT_SYSTEMLANG] = L"I (VXě)";
		names[CPEX_AUTODETECT_USERLANG] = L"I ([Ǔ)";
		names[CPEX_UNICODE_AUTODETECT] = L"Unicode (I)";
		names[CPEX_UNICODE_UTF5] = L"Unicode (UTF-5)";
		names[CPEX_ARMENIAN_AUTODETECT] = L"AjA (I)";
		names[CPEX_ARMENIAN_ARMSCII7] = L"AjA (ARMSCII-7)";
		names[CPEX_ARMENIAN_ARMSCII8] = L"AjA (ARMSCII-8)";
		names[CPEX_ARMENIAN_ARMSCII8A] = L"AjA (ARMSCII-8A)";
		names[CPEX_VIETNAMESE_AUTODETECT] = L"xgi (I)";
		names[CPEX_VIETNAMESE_TCVN] = L"xgi (TCVN)";
		names[CPEX_VIETNAMESE_VISCII] = L"xgi (VISCII)";
		names[CPEX_VIETNAMESE_VPS] = L"xgi (VPS)";
		names[CPEX_JAPANESE_ISO2022JP] = L"{ (ISO-2022-JP)";
		names[CPEX_JAPANESE_SHIFTJIS] = L"{ (Vtg JIS)";
		names[CPEX_JAPANESE_ISO2022JP1] = L"{ (ISO-2022-JP-1)";
		names[CPEX_JAPANESE_ISO2022JP2] = L"{ (ISO-2022-JP-2)";
		names[CPEX_JAPANESE_EUC] = L"{ (EUC)";
		names[CPEX_JAPANESE_ISO2022JP2004] = L"{ (ISO-2022-JP-2004)";
		names[CPEX_JAPANESE_ISO2022JP2004_STRICT] = L"{ (ISO-2022-JP-2004-Strict)";
		names[CPEX_JAPANESE_ISO2022JP2004_COMPATIBLE] = L"{ (ISO-2022-JP-2004-Compatible)";
		names[CPEX_JAPANESE_ISO2022JP3] = L"{ (ISO-2022-JP-3)";
		names[CPEX_JAPANESE_ISO2022JP3_STRICT] = L"{ (ISO-2022-JP-3-Strict)";
		names[CPEX_JAPANESE_ISO2022JP3_COMPATIBLE] = L"{ (ISO-2022-JP-3-Compatible)";
		names[CPEX_JAPANESE_SHIFTJIS2004] = L"{ (Shift_JIS-2004)";
		names[CPEX_JAPANESE_EUCJIS2004] = L"{ (EUC-JIS-2004)";
		names[CPEX_MULTILINGUAL_ISO2022_7BIT] = L"}`K (ISO-2022, 7rbg)";
		names[CPEX_MULTILINGUAL_ISO2022_7BITSS2] = L"}`K (ISO-2022, 7rbg, SS2)";
		names[CPEX_MULTILINGUAL_ISO2022_7BITSISO] = L"}`K (ISO-2022, 7rbg, SI/SO)";
		names[CPEX_MULTILINGUAL_ISO2022_8BITSS2] = L"}`K (ISO-2022, 8rbg, SS2)";
		names[CPEX_UNCATEGORIZED_BINARY] = L"oCi";
//		names[CPEX_UNCATEGORIZED_NEXTSTEP] = L"NextSTEP";
		names[CPEX_UNCATEGORIZED_ATARIST] = L"Atari ST/TT";
		names[CPEX_THAI_TIS620] = L"^C (TIS 620-2533:1990)";
		names[CPEX_LAO_MULELAO] = L"I (MuleLao-1)";
		names[CPEX_LAO_CP1133] = L"I (ibm-1133)";
		names[CPEX_IRISH_IS434] = L"ACh (I.S. 434:1999)";
		names[CPEX_TAMIL_TAB] = L"^~ (TAB)";
		names[CPEX_TAMIL_TAM] = L"^~ (TAM)";
		names[CPEX_TAMIL_TSCII] = L"^~ (TSCII 1.7)";
		names[CPEX_HINDI_MACINTOSH] = L"qfB[ (Macintosh, foiK)";
		names[CPEX_GUJARATI_MACINTOSH] = L"OW[g (Macintosh)";
		names[CPEX_PANJABI_MACINTOSH] = L"pWu (Macintosh, OL[)";
	}

	const map<CodePage, const wchar_t*>::const_iterator	it = names.find(cp);
	return (it != names.end()) ? it->second : 0;
}

/**
 *	R}h̃j[LvVԂ
 *	@param id	R}h ID
 */
const wchar_t* CAlphaApp::_GetMenuLabel(CommandId id) const {

	static wchar_t	wsz[MAX_PATH + 8];
	wchar_t*		psz = 0;

	if(id >= CMD_EDIT_PLUGINLIST_START && id < CMD_EDIT_PLUGINLIST_END) {
		if(m_pScriptMacroManager->GetCount() != 0) {
			wcscpy(wsz, m_pScriptMacroManager->GetName(id - CMD_EDIT_PLUGINLIST_START).c_str());
			wcscat(wsz, L"\t");
			wcscat(wsz, m_keyboardMap.GetKeyString(id, m_bUseShortKeyNames).c_str());
		} else
			wcscpy(wsz, LoadString(MSG_FAILED_TO_LOAD).c_str());
		return wsz;
	} else if(id >= CMD_FILE_MRULIST_START && id < CMD_FILE_MRULIST_END) {
		const TMRU&	file = m_pMRUManager->GetFileInfoAt(id - CMD_FILE_MRULIST_START);
		swprintf(wsz, L"&%X  %s", id - CMD_FILE_MRULIST_START, file.strFileName.c_str());
		return wsz;
	} else if(id >= CMD_VIEW_BUFFERLIST_START && id < CMD_VIEW_BUFFERLIST_END) {
		assert(static_cast<size_t>(id - CMD_VIEW_BUFFERLIST_START) < m_buffers.GetCount());
		if(id - CMD_VIEW_BUFFERLIST_START < 0x10)
			swprintf(wsz, L"&%X  %s", id - CMD_VIEW_BUFFERLIST_START,
				m_buffers.GetAt(id - CMD_VIEW_BUFFERLIST_START).GetFileName());
		else
			wcscpy(wsz, m_buffers.GetAt(id - CMD_VIEW_BUFFERLIST_START).GetFileName());
		return wsz;
	}
	LoadString(id, wsz, MAX_PATH + 8);
	psz = wcschr(wsz, L'\n');
	if(psz != 0)
		*psz = 0;
	wcscat(wsz, L"\t");
	wcscat(wsz, m_keyboardMap.GetKeyString(id, m_bUseShortKeyNames).c_str());
	return wsz;
}

/**
 *	XNvgt@CɑΉtĂ錾GW CLSID Ԃ
 *	@param pwszFileName	XNvgt@C
 *	@param clsid		[out] GW CLSIDBȂꍇ CLSID_NULL
 */
void CAlphaApp::GetScriptLanguageByFileName(const wchar_t* pwszFileName, CLSID& clsid) const {
	assert(pwszFileName != 0);
	clsid = CLSID_NULL;

	static map<wstring, CLSID>	registeredEngines;
	static const CATID	CATID_ActiveScript = {
							0xf0b7a1a1, 0x9847, 0x11cf, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
	static const CATID	CATID_ActiveScriptParse = {
							0xf0b7a1a2, 0x9847, 0x11cf, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
	const wchar_t*		pwszExtension = ::PathFindExtensionW(pwszFileName);

	if(*pwszExtension == 0)
		return;
	++pwszExtension;
	if(registeredEngines.empty()) {
		// R|[lgJeSXNvgGW񋓂AINI gqE
		CComPtr<ICatInformation>	pCatInfo;

		if(SUCCEEDED(pCatInfo.CreateInstance(CLSID_StdComponentCategoriesMgr))) {
			CComPtr<IEnumCLSID>	pClsidEnumerator;

			if(SUCCEEDED(pCatInfo->EnumClassesOfCategories(
					1, const_cast<CATID*>(&CATID_ActiveScript),
					1, const_cast<CATID*>(&CATID_ActiveScriptParse), &pClsidEnumerator))) {
				CLSID		clsid;
				OLECHAR*	pwszProgId;

				for(pClsidEnumerator->Reset(); pClsidEnumerator->Next(1, &clsid, 0) == S_OK; ) {
					if(SUCCEEDED(::ProgIDFromCLSID(clsid, &pwszProgId))) {
						set<wstring>	extensions;

						if(wchar_t* pwszFirstPeriod = wcschr(pwszProgId, L'.'))	// ProgID ꖼɕϊ
							*pwszFirstPeriod = 0;
						const_cast<CAlphaApp*>(this)->_GetProfileSet(INI_SECTION_SCRIPTENGINES, pwszProgId, extensions);
						for(set<wstring>::const_iterator it = extensions.begin(); it != extensions.end(); ++it)
							registeredEngines.insert(make_pair(*it, clsid));
						::CoTaskMemFree(pwszProgId);
					}
				}
			}
		}
	}
	map<wstring, CLSID>::const_iterator	it = registeredEngines.find(pwszExtension);
	if(it != registeredEngines.end())
		clsid = it->second;
}

/**
 *	t@CJۑ肷̂ɎsƂ̏
 *	@param bLoad	t@CJƂƂ true
 *	@param result	G[e
 *	@return			ʓIɃG[łꍇ false
 */
bool CAlphaApp::_HandleFileIoError(bool bLoad, CEditDoc::FileIoResult result) {
	AssertValid();

	if(result == CEditDoc::FIR_OK) {
		_ResetBufferBarIcons();
		return true;
	} else if(result == CEditDoc::FIR_ABORTED_FOR_UNCONVERTABLE) {
		if(bLoad)
			CloseBuffer(GetActiveBufferIndex(), false);
		return false;
	} else {
		DWORD	dwMessageId;
		bool	bSucceeded = true;
		switch(result) {
		case CEditDoc::FIR_LOCK_DENIED:					dwMessageId = MSG_FAILED_TO_LOCK_FILE;			break;
		case CEditDoc::FIR_READ_READONLY:				dwMessageId = MSG_OPENED_AS_READONLY;			break;
		case CEditDoc::FIR_READ_USED_BY_OTHER_PROCESS:	dwMessageId = MSG_FILE_IS_USED_BY_OTHER_PROCESS;break;
		default:
			bSucceeded = false;
			switch(result) {
			case CEditDoc::FIR_ACCESS_DENIED:			dwMessageId = MSG_FILE_ACCESS_DENIED;			break;
			case CEditDoc::FIR_INVALID_CODEPAGE:		dwMessageId = MSG_ILLEGAL_CODEPAGE;				break;
			case CEditDoc::FIR_UNKNOWN_ERROR:			dwMessageId = MSG_UNKNOWN_ERROR;				break;
			case CEditDoc::FIR_READ_HUGE_FILE:			dwMessageId = MSG_TOO_LARGE_FILE;				break;
			case CEditDoc::FIR_READ_NOT_EXIST:			dwMessageId = MSG_FILE_NOT_FOUND;				break;
			case CEditDoc::FIR_WRITE_FULL_DISK:			dwMessageId = MSG_FAILED_TO_WRITE_FOR_FULLDISK;	break;
			case CEditDoc::FIR_WRITE_READONLY:			dwMessageId = MSG_FAILED_TO_WRITE_FOR_READONLY;	break;
			}
		}
		MessageBox(dwMessageId, bSucceeded ? MB_ICONEXCLAMATION : MB_ICONHAND, __MARGS__ % GetActiveBuffer().GetPathName());
		bSucceeded ? _ResetBufferBarIcons() : CloseBuffer(GetActiveBufferIndex(), false);
		return bSucceeded;
	}
}

/**
 *	L[gݍ킹R}hɕϊĎs
 *	@param key			zL[
 *	@param modifiers	CL[
 *	@return				R}hɕϊłꍇ true
 */
bool CAlphaApp::_HandleKeyDown(VirtualKey key, KeyModifier modifiers) {
	if(key == VK_MENU && modifiers == 0) {	// [Alt] ̂ -> j[ANeBuɂ
		GetMainWindow().SendMessage(WM_INITMENU, reinterpret_cast<WPARAM>(m_pMenu->GetSafeHmenu()));
		return true;
	} else if(key == VK_CONTROL || key == VK_MENU || key == VK_SHIFT)	// CL[PƂŉꂽ -> 
		return false;

	if(m_2Stroke1stKey == VK_NULL) {	// 1Xg[N
		CCommand*	pCommand = m_keyboardMap.GetCommand(TKeyCombination(key, modifiers));
		if(pCommand == 0)
			return false;
		else if(pCommand->IsBuiltIn() && pCommand->GetId() == CMD_SPECIAL_WAITFOR2NDKEYS) {
			m_2Stroke1stKey = key;
			m_2Stroke1stModifiers = modifiers;
			const wstring	str = LoadString(MSG_WAITING_FOR_2ND_KEYS,
				__MARGS__ % CKeyboardMap::GetStrokeString(TKeyCombination(key, modifiers), m_bUseShortKeyNames));
			m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
		} else
			pCommand->Execute();
	} else {	// 2Xg[N
		CCommand*	pCommand = m_keyboardMap.GetCommand(
			TKeyCombination(m_2Stroke1stKey, m_2Stroke1stModifiers), TKeyCombination(key, modifiers));
		if(pCommand != 0) {
			m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
			pCommand->Execute();
		} else {
			const wstring	str = LoadString(MSG_ILLEGAL_2STROKE_COMBINATION,
				__MARGS__ % CKeyboardMap::GetStrokeString(
					TKeyCombination(m_2Stroke1stKey, m_2Stroke1stModifiers),
					TKeyCombination(key, modifiers), m_bUseShortKeyNames));
			::MessageBeep(MB_OK);
			m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
		}
		m_2Stroke1stKey = VK_NULL;
	}
	return true;
}

/**
 *	AvP[VEBhENX̓o^
 *	@param hInstance	CX^Xnh
 *	@return				
 *	@see				CWinApp::InitApplication, CAlphaApp::InitInstance, WinMain
 */
bool CAlphaApp::InitApplication(HINSTANCE hInstance) {
	AssertValid();

	WNDCLASSEXW	windowClass;

	windowClass.cbSize			= sizeof(WNDCLASSEXW);
	windowClass.style			= CS_DBLCLKS/* | CS_DROPSHADOW*/;
	windowClass.lpfnWndProc		= CAlphaApp::AppWndProc;
	windowClass.cbClsExtra		= 0;
	windowClass.cbWndExtra		= 0;
	windowClass.hInstance		= hInstance;
	windowClass.hIcon			= ::LoadIconW(hInstance, MAKEINTRESOURCE(IDR_ICONS));
	windowClass.hIconSm			= ::LoadIconW(hInstance, MAKEINTRESOURCE(IDR_ICONS));
	windowClass.hCursor			= ::LoadCursorW(0, IDC_ARROW);
	windowClass.hbrBackground	= reinterpret_cast<HBRUSH>(COLOR_3DFACE + 1);
	windowClass.lpszClassName	= IDS_APPNAME;
	windowClass.lpszMenuName	= MAKEINTRESOURCE(IDR_MENU);

	return toBoolean(::RegisterClassEx(&windowClass));
}

/**
 *	AvP[VEBhE̍쐬Ȃ
 *	@param nCmdShow EBhȄ̕\
 *	@return			
 *	@see			CWinApp::InitInstance, CAlphaApp::InitApplication, WinMain
 */
bool CAlphaApp::InitInstance(int nCmdShow) {
	AssertValid();

	static CWindow	applicationWindow;

	try {
		Ascension::LineBreak	lineBreak =
			static_cast<Ascension::LineBreak>(GetProfileInt(L"File", L"defaultBreakType", LB_CRLF));
		if(lineBreak == LB_AUTO)
			lineBreak = LB_CRLF;
		CEditDoc::SetDefaultCode(GetProfileInt(L"File", L"defaultCodePage", ::GetACP()), lineBreak);
	} catch(invalid_argument&) {
		// TODO: ݒ肪ԈĂ邱Ƃ[Uɒʒm
	}

	// gbvxEBhE
	if(!applicationWindow.Create(IDS_APPNAME, reinterpret_cast<HWND>(::GetModuleHandle(0)),
			DefaultWindowRect(), 0, /*WS_VISIBLE |*/ WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_OVERLAPPEDWINDOW))
		return false;
	m_pMainWindow = &applicationWindow;

	// GfB^EBhE (WS_CLIPCHILDREN tƕEBhẼTCYύXgsɂȂ...)
	CEditorPane*	pPane = new CEditorPane();
	if(!m_editorWindow.Create(applicationWindow, DefaultWindowRect(), WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE, 0, *pPane))
		return false;

	// ʐݒ̓ǂݍ
	_LoadINISettings();

	// XNvgɂݒ
	wchar_t									wszScriptName[MAX_PATH];
	wchar_t*								pwszFileName = 0;
	CComPtr<Alpha::Ambient::CApplication>	pApplication;

	GetAutomation(&pApplication, 0);
	::GetModuleFileNameW(0, wszScriptName, MAX_PATH);
	pwszFileName = ::PathFindFileNameW(wszScriptName);
	wcscpy(pwszFileName, IDS_MACRO_DIRECTORY_NAME IDS_EVENTSCRIPTFILENAME);
	m_pEventHandlerScript = new CEventHandlerScript(GetMainWindow(), *this);
	m_pEventHandlerScript->LoadScript(wszScriptName);

	// MRU Xg̍쐬
	m_pMRUManager = new CMRUManager(GetProfileInt(L"File", L"mruLimit", 8), CMD_FILE_MRULIST_START, true);
	unsigned int	iMRU = 0;
	wchar_t			szKeyName[30];
	stack<TMRU>		files;
	while(true) {
		TMRU	file;
		swprintf(szKeyName, L"strPath(%u)", iMRU);
		file.strFileName = GetProfileString(L"MRU", szKeyName, L"");
		if(file.strFileName.empty())
			break;
		swprintf(szKeyName, L"nCodePage(%u)", iMRU);
		file.nCodePage = GetProfileInt(L"MRU", szKeyName, CPEX_AUTODETECT_USERLANG);
		files.push(file);
		++iMRU;
	}
	while(!files.empty()) {
		m_pMRUManager->Add(files.top().strFileName, files.top().nCodePage);
		files.pop();
	}

	// macros.xml ̃[h
	_ReloadScriptMacros();

	// ACR̗p
	m_hNarrowingIcon = static_cast<HICON>(::LoadImageW(m_hInstance,
		MAKEINTRESOURCE(IDR_ICON_NARROWING), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR));

	// o[̍쐬
	REBARINFO	rbi = {sizeof(REBARINFO), 0, 0};
	m_rebar.Create(applicationWindow, DefaultWindowRect(), 0, 0,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN | RBS_BANDBORDERS | RBS_VARHEIGHT | CCS_NODIVIDER,
		WS_EX_TOOLWINDOW);
	m_rebar.SetBarInfo(rbi);

	// c[o[̍쐬
	_SetupToolbar();

	// Xe[^Xo[̍쐬
	m_statusBar.Create(applicationWindow, DefaultWindowRect(), 0, IDC_STATUSBAR,
		WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE | CCS_BOTTOM | CCS_NODIVIDER | SBARS_SIZEGRIP | SBT_TOOLTIPS);
//	m_statusBar.SetMinHeight(4);

	// ̑̏
	m_strReadOnlySignature = LoadString(MSG_READONLY_TITLE);
	applicationWindow.DragAcceptFiles(true);
	applicationWindow.SetTimer(ID_TIMER_QUERYCOMMAND, 200, 0);
	applicationWindow.SetWindowPos(0, 0, 0, 760, 560, SWP_NOMOVE | SWP_NOZORDER);
	applicationWindow.CenterWindow();

	// R}hC̉
	vector<wstring>	arguments;
	GetCommandLineArguments(arguments);

	// OnApplicationInitialized Cxg
	AutoZero<DISPPARAMS>	params;
	VARIANTARG				arg0;

	arg0.vt = VT_DISPATCH;
	arg0.pdispVal = new Ambient::CArguments(arguments);
	arg0.pdispVal->AddRef();
	params.cArgs = 1;
	params.rgvarg = &arg0;
	m_pEventHandlerScript->Invoke(OLESTR("OnApplicationInitialized"), &params);
	arg0.pdispVal->Release();

	// ̃r[̍쐬
	NewBuffer();

	_SetupMenus();
	if(!toBoolean(GetProfileInt(L"View", L"visibleToolbar", true)))
		m_rebar.ShowBand(m_rebar.IdToIndex(IDC_TOOLBAR), false);
	if(!toBoolean(GetProfileInt(L"View", L"visibleStatusBar", true)))
		m_statusBar.ShowWindow(SW_HIDE);
	if(!toBoolean(GetProfileInt(L"View", L"visibleBufferBar", true)))
		m_rebar.ShowBand(m_rebar.IdToIndex(IDC_BUFFERBAR), false);
	applicationWindow.ShowWindow(nCmdShow);

	// R}hC^ꂽt@CJ
	ParseCommandLine(arguments);

	// ...
	m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);

	// AEgvbgEBhE̍쐬
//	m_wndOutput.Create(m_pMainWindow);
//	m_wndOutput.WriteLine(OTT_GENERAL, IDS_APPFULLVERSION);

	// c[_CAO̍쐬
	m_pdlgSearch->Create(m_hInstance, applicationWindow);
	m_pdlgSearch->DoModeless(false);
	PushModelessDialog(*m_pdlgSearch);
	if(toBoolean(GetProfileInt(L"View", L"applyMainFontToSomeControls", 1))) {
		m_pdlgSearch->SendDlgItemMessage(IDC_COMBO_FINDWHAT,
			WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
		m_pdlgSearch->SendDlgItemMessage(IDC_COMBO_REPLACEWITH,
			WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
	}
	m_pdlgGotoLine->Create(m_hInstance, applicationWindow);
	m_pdlgBookmark->Create(m_hInstance, applicationWindow);
//	m_pdlgDebugBreakPoints->Create(m_hInstance, IDD_DLG_DEBUGBREAKPOINTS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugCallStack->Create(m_hInstance, IDD_DLG_DEBUGCALLSTACK, m_pMainWindow->m_hWnd);
//	m_pdlgDebugImmediate->Create(m_hInstance, IDD_DLG_DEBUGIMMEDIATE, m_pMainWindow->m_hWnd);
//	m_pdlgDebugRunningDocuments->Create(m_hInstance, IDD_DLG_DEBUGACTIVEDOCUMENTS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugThreads->Create(m_hInstance, IDD_DLG_DEBUGTHREADS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugVariables->Create(m_hInstance, IDD_DLG_DEBUGVARIABLES, m_pMainWindow->m_hWnd);

	applicationWindow.SetFocus();
	return true;
}

///	INI t@Cݒǂݍ
void CAlphaApp::_LoadINISettings() {
	AssertValid();

	// \Ɋւݒ
	AutoZero<LOGFONTW>	lf;
	if(!GetProfileStruct(L"View", L"oFont.pLogfont", &lf, sizeof(LOGFONTW))) {
		lf.lfCharSet = ANSI_CHARSET;
		lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
		lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
		lf.lfQuality = DEFAULT_QUALITY;
		lf.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
		wcscpy(lf.lfFaceName, L"Terminal");
	}
	SetFont(lf);
	m_nOutputWndHeight = 0;//GetProfileInt(L"View", L"nOutputWindowHeight", 98);

	// Migemo DLL pX
	const wchar_t*	pwszMigemoPath = GetProfileString(L"Find", L"migemoRuntimePath", L"");
	if(const size_t cch = wcslen(pwszMigemoPath)) {
		wchar_t*	pwsz = new wchar_t[cch + 1];

		replace_copy_if(pwszMigemoPath, pwszMigemoPath + cch + 1, pwsz, bind2nd(equal_to<wchar_t>(), L'/'), L'\\');
		CEditView::SetMigemoPath(pwsz, true);
		delete[] pwsz;
	}

	// Migemo  pX
	pwszMigemoPath = GetProfileString(L"Find", L"migemoDictionaryPath", L"");
	if(const size_t cch = wcslen(pwszMigemoPath)) {
		wchar_t*	pwsz = new wchar_t[cch + 1];

		replace_copy_if(pwszMigemoPath, pwszMigemoPath + cch + 1, pwsz, bind2nd(equal_to<wchar_t>(), L'/'), L'\\');
		CEditView::SetMigemoPath(pwsz, false);
		delete[] pwsz;
	}

	// ̗
	wchar_t	wszKeyName[30];
	wstring	strValue;
	list<wstring>	findWhats, replacesWiths;
	for(ushort iText = 0; iText < 16; ++iText) {
		swprintf(wszKeyName, L"strFindWhat(%u)", iText);
		strValue = GetProfileString(L"Find", wszKeyName);
		if(strValue.empty())
			break;
		findWhats.push_back(strValue);
	}
	for(ushort iText = 0; iText < 16; ++iText) {
		swprintf(wszKeyName, L"strReplaceWith(%u)", iText);
		strValue = GetProfileString(L"Find", wszKeyName);
		if(strValue.empty())
			break;
		replacesWiths.push_back(strValue);
	}
	m_pdlgSearch->ClearHistory(false);
	m_pdlgSearch->ClearHistory(true);
	m_pdlgSearch->SetHistory(findWhats, replacesWiths);

	// ̑
	m_bUseShortKeyNames = toBoolean(GetProfileInt(L"Edit", L"useShortKeyNames", 0));
	m_bShowMessageBoxOnFind = toBoolean(GetProfileInt(L"Find", L"showMessageBox", 1));
	m_bInitializeFindTextFromEditor = toBoolean(GetProfileInt(L"Find", L"initializeFromEditor", 1));
}

/**
 *	L[ () 蓖
 *	@param strSchemeName	gpL[{[h}bvXL[̖OB
 *	󕶎w肷ƃAvP[VɌѕtĂL[蓖ăIuWFNgANZ[^e[uč\z
 */
void CAlphaApp::LoadKeyBinds(const wstring& strSchemeName) {
	AssertValid();

	if(!strSchemeName.empty()) {
		wchar_t	wszPathName[MAX_PATH];
		::GetModuleFileNameW(0, wszPathName, MAX_PATH);
		wcscpy(::PathFindFileNameW(wszPathName), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
		if(wcslen(wszPathName) + strSchemeName.length() + 4 >= MAX_PATH)
			return;
		wcscat(wszPathName, strSchemeName.c_str());
		wcscat(wszPathName, L".akm");
		m_keyboardMap.Load(wszPathName);
	}

	// j[̍č\z
	if(m_pMenu != 0)
		_SetupMenus();
}

/**
 *	bZ[We[u̕bZ[W{bNXɕ\
 *	@param dwID		bZ[Wʎq
 *	@param nType	_CAÕ^Cv (::MessageBox Ɠ)
 *	@param args		bZ[Ẅ
 *	@return			[U̕ԓ (::MessageBox Ɠ)
 */
int CAlphaApp::MessageBox(DWORD dwID, UINT nType, Manah::Windows::CMessageArguments& args /* = CMessageArguments() */) {
	AssertValid();
	return GetMainWindow().MessageBox(LoadString(dwID, args).c_str(), IDS_APPNAME, nType);
}

/**
 *	̐VKobt@J
 *	@param cp			R[hy[WBȗƊ̃R[hy[W
 *	@param bt			sR[hBȗƊ̉sR[h
 *	@param strDocType	Kp^CvBȗƊ̕^Cv
 */
void CAlphaApp::NewBuffer(CodePage cp /* = CPEX_AUTODETECT_USERLANG */,
		Ascension::LineBreak lineBreak /* = LB_AUTO */, const wstring& strDocType /* = L"" */) {
	if(::GetCurrentThreadId() != GetMainWindow().GetWindowThreadId()) {
		// EBhE̍쐬CXbhɈϏ
		struct _ : virtual public _ICallable {
			_(CAlphaApp& app, CodePage cp, Ascension::LineBreak lineBreak, const wstring& strDocType)
				: m_app(app), m_cp(cp), m_bt(lineBreak), m_doctype(strDocType) {}
			void Call() {m_app.NewBuffer(m_cp, m_bt, m_doctype);}
			CAlphaApp&					m_app;
			const CodePage				m_cp;
			const Ascension::LineBreak	m_bt;
			const wstring				m_doctype;
		} __(*this, cp, lineBreak, strDocType);
		GetMainWindow().SendMessage(MYWM_CALLOVERTHREAD, 0, reinterpret_cast<LPARAM>(static_cast<_ICallable*>(&__)));
		return;
	}

	static bool	bLoadedKeyboardMacro = false;
	CAlphaDoc*	pNewBuffer = new CAlphaDoc();

	if(cp != CPEX_AUTODETECT_USERLANG)	pNewBuffer->SetCodePage(cp);
	if(lineBreak != LB_AUTO)			pNewBuffer->SetLineBreak(lineBreak);

	// ݂̃yC̐r[쐬
	CAlphaView*	pOriginalView = 0;
	for(EditorWindow::Iterator it = m_editorWindow.EnumeratePanes(); !it.IsEnd(); it.Next()) {
		CAlphaView*	pView = (pOriginalView == 0) ?
						new CAlphaView(*pNewBuffer, *this) : new CAlphaView(*pOriginalView);
		const bool	bSucceededToCreate = pView->Create(m_editorWindow, DefaultWindowRect(),
			WS_CHILD | WS_CLIPCHILDREN | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_CLIENTEDGE | WS_EX_RTLREADING);

		if(pOriginalView == 0)
			pOriginalView = pView;
		assert(bSucceededToCreate);
		it.Get().AddView(*pView);
	}


	// łɃL[}N[h
	if(!bLoadedKeyboardMacro) {
//		pView->CmdKeymacroLoad(IDS_KEYMACROFILENAME);	// TODO: L[}Ñ[h
		bLoadedKeyboardMacro = true;
	}

	// tHg̐ݒ
	CAlphaView&	view = pNewBuffer->GetActiveView();
	LOGFONTW	lf;
	::GetObject(m_hCommonFont, sizeof(LOGFONTW), &lf);
	view.AddEventListener(*this);
	pNewBuffer->AddEventListener(*this);
	view.GetLayoutSettings().SetFont(lf);

	// obt@o[Ƀ{^ǉ
	AutoZero<TBBUTTON>	button;
	button.idCommand = CMD_VIEW_BUFFERLIST_START + m_bufferBar.GetButtonCount();
	button.iBitmap = m_buffers.GetCount();
	button.fsState = TBSTATE_ENABLED;
	button.fsStyle = BTNS_AUTOSIZE | BTNS_BUTTON | BTNS_GROUP | BTNS_NOPREFIX;
	button.iString = reinterpret_cast<INT_PTR>(pNewBuffer->GetFileName());
	m_bufferBar.InsertButton(m_bufferBar.GetButtonCount(), button);

	m_buffers.Add(*pNewBuffer);
	_ResetBufferBarIcons();
	SetActiveBuffer(*pNewBuffer);
	ApplyDocumentType(GetActiveBufferIndex(), strDocType);
}

///	[w肵ĐVK] _CAOJAobt@VK쐬
void CAlphaApp::NewBufferWithFormat() {
	CNewFileFormatDlg	dlg;

	dlg.Create(m_hInstance, GetMainWindow());
	dlg.m_nCodePage = GetProfileInt(L"File", L"defaultCodePage", ::GetACP());
	if(dlg.m_nCodePage == CP_ACP)
		dlg.m_nCodePage = ::GetACP();
	dlg.m_lineBreak = static_cast<Ascension::LineBreak>(GetProfileInt(L"file", L"defaultBreakType", LB_AUTO));
	if(dlg.m_lineBreak == LB_AUTO)
		dlg.m_lineBreak = LB_CRLF;
	dlg.m_iDocumentType = 0;
	dlg.m_documentTypes.clear();

	const CDocumentTypeManager&	types = m_buffers.GetDocumentTypeManager();
	for(size_t i = 0; i < types.GetCount(); ++i)
		dlg.m_documentTypes.push_back(types.GetAt(i).strName);

	if(dlg.DoModal() != IDOK)
		return;
	NewBuffer(dlg.m_nCodePage, dlg.m_lineBreak, types.GetAt(dlg.m_iDocumentType).strName);
}

/**
 *	[J] _CAO\ăt@CJ
 *	@return ۂȂ
 */
OpenFileResult CAlphaApp::OpenFile() {
	wstring		strFilter = GetProfileString(L"File", L"filter", LoadString(MSG_DEFAULT_OPEN_FILE_FILTER).c_str());
	wchar_t*	pwszFilter = new wchar_t[strFilter.length() + 2];
	wchar_t		wszFileName[MAX_PATH + 1] = L"";
	wstring		strErrorMessage;

	// tB^𐮌`
	replace_if(strFilter.begin(), strFilter.end(), bind2nd(equal_to<wchar_t>(), L':'), L'\0');
	strFilter.copy(pwszFilter, strFilter.length());
	pwszFilter[strFilter.length()] = L'\0';
	pwszFilter[strFilter.length() + 1] = L'\0';

	OSVERSIONINFOW	osVersion;
	memset(&osVersion, 0, sizeof(OSVERSIONINFOW));
	osVersion.dwOSVersionInfoSize = sizeof(OSVERSIONINFOW);
	::GetVersionEx(&osVersion);

	AutoZeroLS<OPENFILENAMEW>		ofn;
	AutoZeroLS<OPENFILENAME_NT4W>	ofn400;
	OPENFILENAMEW*					pOfn = (osVersion.dwMajorVersion > 4) ? &ofn : reinterpret_cast<OPENFILENAMEW*>(&ofn400);
	pOfn->hwndOwner = GetMainWindow().GetSafeHwnd();
	pOfn->hInstance = m_hInstance;
	pOfn->lpstrFilter = pwszFilter;
	pOfn->lpstrFile = wszFileName;
	pOfn->nFilterIndex = GetProfileInt(L"File", L"activeFilter", 0);
	pOfn->nMaxFile = MAX_PATH;
	pOfn->Flags = OFN_ALLOWMULTISELECT | OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
		| OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST/* | OFN_SHOWHELP*/;
	pOfn->lCustData = CPEX_AUTODETECT_USERLANG | 0;
	pOfn->lpfnHook = OFNHookProc;
	pOfn->lpTemplateName = MAKEINTRESOURCE(IDD_DLG_OPENFILE);

	const bool	bSucceeded = toBoolean(::GetOpenFileNameW(pOfn));
	delete[] pwszFilter;
	WriteProfileInt(L"File", L"activeFilter", pOfn->nFilterIndex);	// ŌɎgtB^ۑ

	if(bSucceeded) {
		const CodePage	cp = pOfn->lCustData & 0x00FFFFFF;
		const wstring	strDirectory = pOfn->lpstrFile;

		if(strDirectory.length() > pOfn->nFileOffset)	// Jt@C1
			return OpenFile(strDirectory, cp, toBoolean(pOfn->Flags & OFN_READONLY));	// pOfn->lpstrFile ͊St@C
		else {	// ̃t@CJꍇ
			wchar_t*	pwszFileName = pOfn->lpstrFile + pOfn->nFileOffset;
			bool		bFailedOnce = false;

			while(*pwszFileName != 0) {
				const size_t	cchFileName = wcslen(pwszFileName);

				if(OpenFile(strDirectory + L"\\" + wstring(pwszFileName, cchFileName),
						cp, toBoolean(pOfn->Flags & OFN_READONLY)) != OPENFILERESULT_SUCCEEDED)
					bFailedOnce = true;
				pwszFileName += cchFileName + 1;
			}
			return bFailedOnce ? OPENFILERESULT_FAILED : OPENFILERESULT_SUCCEEDED;
		}
	} else {
//		ShowLastErrorMessage();
		return OPENFILERESULT_FAILED;
	}
}

/**
 *	t@CeLXgGfB^ŐVr[ɊJÃr[ANeBuɂB
 *	܂AgqɉăhLg^CvKpB̃\bh̓t@CI[v
 *	ʂ_CAO\邱Ƃ
 *	@param strPathName	t@C̃pX
 *	@param cp			t@C̃R[hy[WBȗƎ
 *	@param strDocType	Kp镶^CvBȗ󕶎̏ꍇ͊gq画
 *	@param bAsReadOnly	ǂݎpƂĊJ
 *	@param bAddToMRU	Jt@Cŋߎgt@Cɒǉ邩
 *	@return				ۂȂ
 */
OpenFileResult CAlphaApp::OpenFile(const wstring& strPathName,
		UINT cp /* = EXTCP_AUTOSELECT */, bool bAsReadOnly /* = false */, bool bAddToMRU /* = true */) {
	AssertValid();

	wchar_t	wszPathName[MAX_PATH];

	// V[gJbg̉
	const wchar_t*	pwszExtension = ::PathFindExtensionW(strPathName.c_str());
	if(wcslen(pwszExtension) != 0 && (
			(::StrCmpIW(pwszExtension + 1, L"lnk") == 0)
			/*|| (::StrCmpIW(pwszExtension + 1, L"url") == 0)*/)) {
		CComPtr<IShellLink>		pShellLink;
		CComPtr<IPersistFile>	pFile;
		HRESULT					hr;

		try {
			if(FAILED(hr = pShellLink.CreateInstance(CLSID_ShellLink)))
				throw hr;
			if(FAILED(hr = pShellLink->QueryInterface(IID_IPersistFile, reinterpret_cast<void**>(&pFile))))
				throw hr;
			if(FAILED(hr = pFile->Load(strPathName.c_str(), STGM_READ)))
				throw hr;
			if(FAILED(hr = pShellLink->Resolve(0, SLR_ANY_MATCH | SLR_NO_UI)))
				throw hr;
			if(FAILED(hr = pShellLink->GetPath(wszPathName, MAX_PATH, 0, 0)))
				throw hr;
		} catch(HRESULT /*hr_*/) {
			MessageBox(MSG_FAILED_TO_RESOLVE_SHORTCUT, MB_ICONHAND, __MARGS__ % strPathName);
			return OPENFILERESULT_FAILED;
		}
	} else
		wcscpy(wszPathName, strPathName.c_str());

	// (eLXgGfB^) ɊJĂ邩ׂ
	for(size_t i = 0; i < m_buffers.GetCount(); ++i) {
		CAlphaDoc&	document = m_buffers.GetAt(i);
		if(document.GetPathName() != 0 && ::StrCmpIW(document.GetPathName(), wszPathName) == 0) {	// ł͕sS
			SetActiveBuffer(document);
			return OPENFILERESULT_SUCCEEDED;
		}
	}

	CAlphaDoc*				pDocument = &GetActiveBuffer();
	CEditDoc::FileOpenMode	mode;

	// bNȂ
	if(bAsReadOnly)
		mode = CEditDoc::FOM_AS_READONLY;
	else {
		switch(GetProfileInt(L"File", L"shareMode", 0)) {
		case 0:	mode = CEditDoc::FOM_DENY_NONE;	break;
		case 1:	mode = CEditDoc::FOM_DENY_WRITE;	break;
		case 2:	mode = CEditDoc::FOM_DENY_READ;	break;
		}
	}

	if(pDocument->IsModified() || pDocument->GetPathName() != 0) {	// VReiŊJ
		NewBuffer(cp);
		pDocument = &GetActiveBuffer();
	}

	if(!CEncoderFactory::GetInstance().IsCodePageForAutoDetection(cp)) {
		try {
			pDocument->SetCodePage(cp);
		} catch(invalid_argument& /* e */) {
			if(IDNO == MessageBox(MSG_ILLEGAL_CODEPAGE, MB_YESNO | MB_ICONEXCLAMATION))
				return OPENFILERESULT_USERCANCELED;
			cp = ::GetACP();
			pDocument->SetCodePage(cp);
		}
	}

	const wstring			str = LoadString(MSG_LOADING_FILE, __MARGS__ % wszPathName);
	CEditDoc::FileIoResult	result;
	do {
		CWaitCursor		wc;
		CFileIoCallback	callback(*this, true, wszPathName, cp);

		m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
		GetMainWindow().LockWindowUpdate();
		pDocument->SetPathName(wszPathName);

		// ł̂Ńt@CJ
		result = pDocument->Load(wszPathName, mode, cp, &callback);
		m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
		_UpdateStatusBar(SBP_ALL);
		GetMainWindow().UnlockWindowUpdate();

		// [UR[hy[W̕ύXvĂ
		if(callback.DoesUserWantToChangeCodePage()) {
			assert(result == CEditDoc::FIR_ABORTED_FOR_UNCONVERTABLE);
			CCodePagesDlg	dlg(true);

			dlg.Create(m_hInstance, GetMainWindow());
			dlg.m_codePage = cp;
			if(dlg.DoModal() == IDOK) {
				cp = dlg.m_codePage;
				continue;	// R[hy[WςčĒ
			}
		}
		break;
	} while(true);

	GetMainWindow().ShowWindow(m_pMainWindow->IsWindowVisible() ? SW_SHOW : SW_RESTORE);
	m_buffers.UpdateList();

	if(_HandleFileIoError(true, result)) {
		if(bAddToMRU) {
			m_pMRUManager->Add(pDocument->GetPathName(), pDocument->GetCodePage());
			m_pMenu->GetSubMenu(0).SetChildPopup(*m_pMRUManager->GetPopupMenu(), CMD_FILE_MRU, false, true);
		}
		return OPENFILERESULT_SUCCEEDED;
	}
	return (result != CEditDoc::FIR_ABORTED_FOR_UNCONVERTABLE) ? OPENFILERESULT_FAILED : OPENFILERESULT_USERCANCELED;
}

/**
 *	[t@C] _CAO\ăt@Cs
 *	@param id	R}h ID
 */
void CAlphaApp::OperateActiveFile(UINT id) {
	assert(id >= CMD_FILE_RENAME && id <= CMD_FILE_DELETE);

	CAlphaDoc&						activeDocument = GetActiveBuffer();
	CEditDoc::FileOperationResult	result = CEditDoc::FOR_OK;

	if(activeDocument.GetPathName() == 0)
		return;
	else if(id != CMD_FILE_DELETE) {
		CFileOperationDlg	dlg(id, activeDocument.GetPathName());
		dlg.Create(m_hInstance, GetMainWindow());
		if(dlg.DoModal() == IDOK) {
			switch(id) {
			case CMD_FILE_COPY:
				result = activeDocument.Copy(dlg.m_strFilePath.c_str());
				break;
			case CMD_FILE_MOVE:
			case CMD_FILE_RENAME:
				result = activeDocument.Move(dlg.m_strFilePath.c_str());
				break;
			}
		}
	} else {
		result = activeDocument.Delete();
		if(result == CEditDoc::FOR_OK)
			CloseBuffer(GetActiveBufferIndex(), false);
	}

	// ^Cgo[ƃ^uXV
	_UpdateTitleBar();

	// G[bZ[W̐
	switch(result) {
	case CEditDoc::FOR_OK:
	case CEditDoc::FOR_ABORTED:
		return;
	case CEditDoc::FOR_ALREADY_EXISTS:
		MessageBox(MSG_FAILED_TO_OPERATE_FILE, MB_ICONEXCLAMATION);
		break;
	case CEditDoc::FOR_REOPENED_AS_READONLY:
		MessageBox(MSG_REOPENED_AS_READONLY, MB_ICONEXCLAMATION);
		break;
	case CEditDoc::FOR_CANNOT_REOPEN:
		// ...
		break;
	case CEditDoc::FOR_UNKNOWN_ERROR:
		// ...
//		::FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, 0, ::GetLastError(),
//			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), wszError + wcslen(wszError), 200, 0);
		break;
	}
}

/**
 *	R}hC͂ĎsBȈ͖
 *	@param arguments	eR}hCIvVBCWinApp::GetCommandLineArguments ̏o͂g
 *	@see				CWinApp::GetCommandLineArguments
 */
void CAlphaApp::ParseCommandLine(const vector<wstring>& arguments) {
	AssertValid();

	list<wstring>	paths;	// t@CpX̃Xg
	CodePage		cp = CPEX_AUTODETECT_USERLANG;
	unsigned long	iLine = 0;
	unsigned long	iChar = 0;
	bool			bReadOnly = false;

	for(vector<wstring>::size_type i = 0; i < arguments.size(); ++i) {
		const wstring& strArgument = arguments[i];
		if(strArgument.empty())
			continue;
		if(strArgument[0] == L'-') {	// IvV
			if(strArgument == L"-r")
				bReadOnly = true;
			else if(strArgument.compare(1, 2, L"cp:") == 0)
				cp = wcstoul(strArgument.c_str() + 3, 0, 0);
			else if(strArgument.compare(1, 5, L"line:") == 0)
				iLine = wcstoul(strArgument.c_str() + 6, 0, 0);
			else if(strArgument.compare(1, 5, L"char:") == 0)
				iChar = wcstoul(strArgument.c_str() + 6, 0, 0);
		} else	// t@CpX
			paths.push_back(strArgument);
	}

	// ԂɃt@CJ
	for(list<wstring>::const_iterator it = paths.begin(); it != paths.end(); ++it) {
		if(OpenFile(*it, cp) == OPENFILERESULT_SUCCEEDED)
			if(iLine != 0 || iChar != 0)
				GetActiveBuffer().GetActiveView().GetSelection().MoveTo(CCharPos(iLine, iChar), true);
	}
}

/// @see	CWinApp::PreTranslateMessage
bool CAlphaApp::PreTranslateMessage(const MSG& msg) {
	// R}hɊ蓖ĂĂL[gݍ킹ŕߑ
	if(msg.hwnd == GetActiveView()) {
		if(msg.message == WM_KEYDOWN || msg.message == WM_SYSKEYDOWN) {	// WM_CHAR sȂ悤ɂ
			KeyModifier	modifiers = 0;
			if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000))
				modifiers |= KM_CTRL;
			if(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000))
				modifiers |= KM_SHIFT;
			if(msg.message == WM_SYSKEYDOWN || toBoolean(::GetKeyState(VK_MENU) & 0x8000))
				modifiers |= KM_ALT;
			return _HandleKeyDown(msg.wParam, modifiers);
		} else if(msg.message == WM_SYSCHAR) {
			// L[gݍ킹L[{[hXL[ɓo^Ă邩ׂB
			// o^ĂΊ̏ (j[̃ANeBx[V) WQ
			const VirtualKey	key = LOBYTE(::VkKeyScanExW(msg.wParam, ::GetKeyboardLayout(0)));
			KeyModifier			modifiers = KM_ALT;
			if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000))	modifiers |= KM_CTRL;
			if(toBoolean(::GetKeyState(VK_SHIFT) & 0x8000))		modifiers |= KM_SHIFT;

			if(m_2Stroke1stKey == VK_NULL)
				return m_keyboardMap.GetCommand(TKeyCombination(key, modifiers)) != 0;
			else
				return m_keyboardMap.GetCommand(
					TKeyCombination(m_2Stroke1stKey, m_2Stroke1stModifiers), TKeyCombination(key, modifiers)) != 0;
		}
	}
	return false;
}

/**
 *	obt@J
 *	@param iBuffer			obt@̃CfNX
 *	@param bChangeCodePage	R[hy[WύX邩
 *	@return					ۂȂ
 *	@throw out_of_range	<var>iBuffer</var> sȂƂX[
 */
OpenFileResult CAlphaApp::ReopenFile(size_t iBuffer, bool bChangeCodePage) throw(out_of_range) {
	CAlphaDoc&	buffer = m_buffers.GetAt(iBuffer);

	if(buffer.GetPathName() == 0)	// t@C݂Ȃ
		return OPENFILERESULT_FAILED;

	if(buffer.IsModified()
			&& IDNO == MessageBox(MSG_ASK_REOPEN_IN_DIRTY, MB_YESNO | MB_ICONQUESTION))
		return OPENFILERESULT_USERCANCELED;

	CodePage	cp = buffer.GetCodePage();
	if(bChangeCodePage) {
		CCodePagesDlg	dlg(true);

		dlg.Create(m_hInstance, GetMainWindow());
		dlg.m_codePage = cp;
		if(dlg.DoModal() != IDOK)
			return OPENFILERESULT_USERCANCELED;
		cp = dlg.m_codePage;
	}

	CEditDoc::FileIoResult	result;
	do {
		CFileIoCallback		callback(*this, true, buffer.GetPathName(), cp);

		result = buffer.Load(buffer.GetPathName(), buffer.GetShareMode(), cp, &callback);
		if(callback.DoesUserWantToChangeCodePage()) {
			assert(result == CEditDoc::FIR_ABORTED_FOR_UNCONVERTABLE);
			CCodePagesDlg	dlg(true);

			dlg.Create(m_hInstance, GetMainWindow());
			dlg.m_codePage = cp;
			if(dlg.DoModal() != IDOK)
				return OPENFILERESULT_USERCANCELED;
			cp = dlg.m_codePage;
			continue;
		}
		break;
	} while(true);
	_UpdateStatusBar(SBP_ALL);
	if(_HandleFileIoError(true, result)) {
		m_pMRUManager->Add(buffer.GetPathName(), buffer.GetCodePage());
		return OPENFILERESULT_SUCCEEDED;
	} else
		return (result != CEditDoc::FIR_ABORTED_FOR_UNCONVERTABLE) ? OPENFILERESULT_FAILED : OPENFILERESULT_USERCANCELED;
}

///	}N () [h
void CAlphaApp::_ReloadScriptMacros() {
	wchar_t	wszMacroPath[MAX_PATH];

	wcscpy(wszMacroPath, m_szModulePath);
	wcscpy(::PathFindFileNameW(wszMacroPath), IDS_MACRO_DIRECTORY_NAME L"macros.xml");
	try {
		m_pScriptMacroManager->Load(wszMacroPath);
	} catch(CScriptMacroManager::EFailedToParseXml& /* e */) {
		// }l[W_CAOo...
	}
}

/**
 *	@brief	݈ʒuȍ~̌SĒu
 *
 *	̃\bh͒u_CAO\ł@\
 */
void CAlphaApp::ReplaceAll() {
	CAlphaView&		activeView = GetActiveView();
	CFindAllCommand	command(activeView, CFindAllCommand::REPLACE,
						toBoolean(m_pdlgSearch->IsDlgButtonChecked(IDC_RADIO_SELECTION)));

	m_pdlgSearch->UpdateOptions();
	activeView.GetTextSearcher().SetSearchText(m_pdlgSearch->GetFindText());
	activeView.GetTextSearcher().SetReplaceText(m_pdlgSearch->GetReplaceText());
	if(const ulong cReplaced = command.Execute()) {
		if(m_bShowMessageBoxOnFind)
			MessageBox(MSG_REPLACE_SUCCEEDED, MB_ICONINFORMATION, __MARGS__ % cReplaced);
		// ɒǉ
		m_pdlgSearch->AddToHistory(m_pdlgSearch->GetFindText(), false);
		m_pdlgSearch->AddToHistory(m_pdlgSearch->GetReplaceText(), true);
	} else if(m_bShowMessageBoxOnFind) {
		if(command.GetLastResult().IsFatalError())
			MessageBox(MSG_REGEXP_PATTERN_SYNTAX_ERROR, MB_ICONEXCLAMATION,
				__MARGS__ % LoadString(MSG_BAD_REGEX_PATTERN_START + command.GetLastResult().GetCode()
					- CSearchError::BADPATTERN_BACK_REFERENCE_TO_NON_EXSISTANT) % command.GetLastResult().GetPosition());
		else
			MessageBox(MSG_TEXT_NOT_FOUND, MB_ICONINFORMATION);
	}

	if(m_pdlgSearch->IsWindow()) {
		if(m_pdlgSearch->IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [ׂĒu_CAO]
			GetMainWindow().SendMessage(WM_COMMAND, CMD_SEARCH_FIND);
		else
			::SetFocus(m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT));
	}
}

/**
 *	@brief	݂̑I͈͂łΒus
 *
 *	uA͑I͈͂Ŗꍇ͎̌IԂɂB
 *	̃\bh͒u_CAO\ł@\
 */
void CAlphaApp::ReplaceAndSearchNext() {
	CAlphaView&	activeView = GetActiveView();

	m_pdlgSearch->UpdateOptions();
	activeView.GetTextSearcher().SetSearchText(m_pdlgSearch->GetFindText());
	activeView.GetTextSearcher().SetReplaceText(m_pdlgSearch->GetReplaceText());

	CFindNextCommand	command(activeView, true, !m_pdlgSearch->IsDlgButtonChecked(IDC_CHK_SHIFT));

	if(command.Execute())	// u
		m_pdlgSearch->AddToHistory(m_pdlgSearch->GetReplaceText(), true);
	else if(m_bShowMessageBoxOnFind) {
		if(command.GetLastResult().IsFatalError())
			MessageBox(MSG_REGEXP_PATTERN_SYNTAX_ERROR, MB_ICONEXCLAMATION,
				__MARGS__ % LoadString(MSG_BAD_REGEX_PATTERN_START + command.GetLastResult().GetCode()
					- CSearchError::BADPATTERN_BACK_REFERENCE_TO_NON_EXSISTANT) % command.GetLastResult().GetPosition());
		else
			MessageBox(MSG_TEXT_NOT_FOUND, MB_ICONINFORMATION);
	}

	if(m_pdlgSearch->IsWindowVisible()) {
//		if(m_dlgFind.IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [_CAO]
//			GetMainWindow().SendMessage(WM_COMMAND, CMD_SEARCH_FIND);
//		else
			::SetFocus(m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT));
	}
}

///	obt@o[̃ACRXV
void CAlphaApp::_ResetBufferBarIcons() {
	m_buffers.UpdateList();
	m_bufferBar.SetImageList(m_buffers.GetImageList());
}

/**
 *	obt@Sĕۑ
 *	@return	rŒfȂ true
 */
bool CAlphaApp::SaveAllBuffers() {
	for(size_t i = 0; i < m_buffers.GetCount(); ++i) {
		if(!SaveBuffer(i))
			return false;
	}
	m_bufferBar.RedrawWindow();
	return true;
}

/**
 *	obt@㏑ۑ
 *	@param iBuffer		obt@̃CfNX
 *	@return				 (ۑKvꍇ true)
 *	@throw out_of_range	<var>iBuffer</var> sȂƂX[
 */
bool CAlphaApp::SaveBuffer(size_t iBuffer) throw(out_of_range) {
	AssertValid();

	CAlphaDoc&		buffer = m_buffers.GetAt(iBuffer);
	const wchar_t*	pwszPath = buffer.GetPathName();

	if(pwszPath != 0 && !buffer.IsModified())	// ۑ̕Kv͖
		return true;

	if(pwszPath == 0 || !toBoolean(::PathFileExistsW(pwszPath)))	// t@C݂Ȃꍇ͖OKv
		return SaveBufferWithName(iBuffer);

	CodePage	cp = buffer.GetCodePage();
	bool		bWriteBOM = false;
	switch(cp) {
	case CP_UTF8:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF8", 0));
		break;
	case CPEX_UNICODE_UTF16LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16LE", 1));
		break;
	case CPEX_UNICODE_UTF16BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16bE", 1));
		break;
	case CPEX_UNICODE_UTF32LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32LE", 1));
		break;
	case CPEX_UNICODE_UTF32BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32BE", 1));
		break;
	}

	CEditDoc::FileIoResult	result;
	do {
		CFileIoCallback	callback(*this, false, buffer.GetPathName(), cp);

		result = buffer.Save(buffer.GetPathName(), bWriteBOM ? CEditDoc::SDO_WRITE_BOM : 0, LB_AUTO, cp, &callback);
		if(callback.DoesUserWantToChangeCodePage()) {
			CCodePagesDlg	dlg(false);

			assert(result == CEditDoc::FIR_ABORTED_FOR_UNCONVERTABLE);
			dlg.m_codePage = cp;
			dlg.Create(m_hInstance, GetMainWindow());
			if(dlg.DoModal() == IDOK) {
				cp = dlg.m_codePage;
				continue;
			}
		}
		break;
	} while(true);

	_UpdateStatusBar(SBP_ALL);

	if(_HandleFileIoError(false, result))
		m_pMRUManager->Add(buffer.GetPathName(), buffer.GetCodePage());
	else
		return false;

	if(iBuffer != GetActiveBufferIndex()) {	// ANeBułȂobt@ۑ
		AutoZero<TBBUTTONINFOW>	button;
		button.dwMask = TBIF_TEXT;
		button.pszText = const_cast<wchar_t*>(buffer.GetFileName());
		m_bufferBar.SetButtonInfo(iBuffer, button);
	}

	return true;
}

/**
 *	obt@ɖOĕۑ
 *	@param iBuffer		obt@̃CfNX
 *	@return				 (ۑKvꍇ true)
 *	@throw out_of_range	<var>iBuffer</var> sȂƂX[
 */
bool CAlphaApp::SaveBufferWithName(size_t iBuffer) throw(out_of_range) {
	AssertValid();

	CAlphaDoc&				buffer = m_buffers.GetAt(iBuffer);
	const wstring			strFilter = LoadString(MSG_SAVE_FILE_FILTER);
	wchar_t*				pwszFilter = new wchar_t[strFilter.length() + 6];
	wchar_t					wszFileName[MAX_PATH + 1] = L"";
	Ascension::LineBreak	lineBreak = LB_AUTO;
	bool					bWriteBOM = false;

	strFilter.copy(pwszFilter, strFilter.length());
	wcsncpy(pwszFilter + strFilter.length(), L"\0*.*\0\0", 6);
	if(buffer.GetPathName() != 0)
		wcscpy(wszFileName, buffer.GetPathName());

	OSVERSIONINFOW	osVersion;
	memset(&osVersion, 0, sizeof(OSVERSIONINFOW));
	osVersion.dwOSVersionInfoSize = sizeof(OSVERSIONINFOW);
	::GetVersionEx(&osVersion);

	AutoZeroLS<OPENFILENAMEW>		ofn;
	AutoZeroLS<OPENFILENAME_NT4W>	ofn400;
	OPENFILENAMEW*					pOfn = (osVersion.dwMajorVersion > 4) ? &ofn : reinterpret_cast<OPENFILENAMEW*>(&ofn400);
	pOfn->hwndOwner = GetMainWindow().GetSafeHwnd();
	pOfn->hInstance = m_hInstance;
	pOfn->lpstrFilter = pwszFilter;
	pOfn->lpstrFile = wszFileName;
	pOfn->nMaxFile = MAX_PATH;
	pOfn->Flags = OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
		| OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT /* | OFN_SHOWHELP*/;
	pOfn->lCustData = buffer.GetCodePage() | (lineBreak << 24);
	pOfn->lpfnHook = OFNHookProc;
	pOfn->lpTemplateName = MAKEINTRESOURCE(IDD_DLG_SAVEFILE);

	if(!toBoolean(::GetSaveFileNameW(pOfn))) {
//		ShowLastErrorMessage();
		return false;
	}

	CodePage	cp = pOfn->lCustData & 0x00FFFFFF;
	switch(cp) {
	case CP_UTF8:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF8", 0));
		break;
	case CPEX_UNICODE_UTF16LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16LE", 1));
		break;
	case CPEX_UNICODE_UTF16BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16BE", 1));
		break;
	case CPEX_UNICODE_UTF32LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32LE", 1));
		break;
	case CPEX_UNICODE_UTF32BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32BE", 1));
		break;
	}

	CEditDoc::SaveDocumentOption	options = bWriteBOM ? CEditDoc::SDO_WRITE_BOM : 0;
	const wstring&			strDocType = buffer.m_strDocType;
	CEditDoc::FileIoResult	result;

	do {
		CFileIoCallback	callback(*this, false, pOfn->lpstrFile, cp);

		result = buffer.Save(pOfn->lpstrFile, options,
				static_cast<Ascension::LineBreak>(pOfn->lCustData >> 24), cp, &callback);
		if(callback.DoesUserWantToChangeCodePage()) {
			CCodePagesDlg	dlg(false);

			assert(result == CEditDoc::FIR_ABORTED_FOR_UNCONVERTABLE);
			dlg.m_codePage = cp;
			dlg.Create(m_hInstance, GetMainWindow());
			if(dlg.DoModal() == IDOK) {
				cp = dlg.m_codePage;
				continue;
			}
		}
		break;
	} while(true);

	_UpdateStatusBar(SBP_ALL);

	if(_HandleFileIoError(false, result))
		m_pMRUManager->Add(buffer.GetPathName(), buffer.GetCodePage());
	else
		return false;

	const CDocumentTypeManager&	types = m_buffers.GetDocumentTypeManager();
	const TDocumentType&		type = types.GetByFileName(buffer.GetFileName());
	if(type.strName != types.GetAt(m_buffers.GetDocumentTypeManager().Find(strDocType)).strName)
		ApplyDocumentType(iBuffer, type.strName);
	if(iBuffer != GetActiveBufferIndex()) {	// ANeBułȂobt@ۑ
		AutoZero<TBBUTTONINFOW>	button;
		button.dwMask = TBIF_TEXT;
		button.pszText = const_cast<wchar_t*>(buffer.GetFileName());
		m_bufferBar.SetButtonInfo(iBuffer, button);
	}
	m_buffers.UpdateList();
	_ResetBufferBarIcons();
	_UpdateStatusBar(SBP_DOCUMENTTYPE);
	if(m_pdlgBookmark->IsWindow())
		m_pdlgBookmark->UpdateList();

	return true;
}

///	INI t@Cɐݒۑ
void CAlphaApp::_SaveINISettings() {
	wchar_t			wszKeyName[30];
	unsigned short	iItem;

	// o[̉̕ۑ
	AutoZero<REBARBANDINFOW>	rbbi;
	rbbi.fMask = RBBIM_STYLE;
	m_rebar.GetBandInfo(m_rebar.IdToIndex(IDC_TOOLBAR), rbbi);
	WriteProfileInt(L"View", L"visibleToolbar", toBoolean(rbbi.fStyle & RBBS_HIDDEN) ? 0 : 1);
	m_rebar.GetBandInfo(m_rebar.IdToIndex(IDC_BUFFERBAR), rbbi);
	WriteProfileInt(L"View", L"visibleBufferBar", toBoolean(rbbi.fStyle & RBBS_HIDDEN) ? 0 : 1);
	WriteProfileInt(L"View", L"visibleStatusBar", m_statusBar.IsWindowVisible() ? 1 : 0);

	// MRU Xg̕ۑ
	for(iItem = 0; ; ++iItem) {
		swprintf(wszKeyName, L"strPath(%u)", iItem);
		if(iItem == m_pMRUManager->GetCount()) {
			WriteProfileString(L"MRU", wszKeyName, L"");	// Xg̏I[\
			break;
		} else {
			const TMRU&	file = m_pMRUManager->GetFileInfoAt(iItem);
			WriteProfileString(L"MRU", wszKeyName, file.strFileName.c_str());
			swprintf(wszKeyName, L"nCodePage(%u)", iItem);
			WriteProfileInt(L"MRU", wszKeyName, file.nCodePage);
		}
	}

	// 񗚗̕ۑ
	list<wstring>					findWhats, replaceWiths;
	list<wstring>::const_iterator	it;
	m_pdlgSearch->GetHistory(findWhats, replaceWiths);
	for(iItem = 0, it = findWhats.begin(); it != findWhats.end(); ++iItem, ++it) {
		swprintf(wszKeyName, L"strFindWhat(%u)", iItem);
		WriteProfileString(L"Find", wszKeyName, it->c_str());
	}
	swprintf(wszKeyName, L"strFindWhat(%u)", iItem);
	WriteProfileString(L"Find", wszKeyName, L"");
	for(iItem = 0, it = replaceWiths.begin(); it != replaceWiths.end(); ++iItem, ++it) {
		swprintf(wszKeyName, L"strReplaceWith(%u)", iItem);
		WriteProfileString(L"Find", wszKeyName, it->c_str());
	}
	swprintf(wszKeyName, L"strReplaceWith(%u)", iItem);
	WriteProfileString(L"Find", wszKeyName, L"");
}

///	[ׂă}[N]
void CAlphaApp::SearchAndBookmarkAll() {
	CAlphaView&		activeView = GetActiveView();
	CFindAllCommand	command(activeView, CFindAllCommand::BOOKMARK,
						toBoolean(m_pdlgSearch->IsDlgButtonChecked(IDC_RADIO_SELECTION)));

	m_pdlgSearch->UpdateOptions();
	activeView.GetTextSearcher().SetSearchText(m_pdlgSearch->GetFindText());
	if(const ulong cFound = command.Execute())
		m_pdlgSearch->AddToHistory(m_pdlgSearch->GetFindText(), false);
	else if(m_bShowMessageBoxOnFind && command.GetLastResult().IsFatalError())
		MessageBox(MSG_REGEXP_PATTERN_SYNTAX_ERROR, MB_ICONEXCLAMATION,
			__MARGS__ % LoadString(MSG_BAD_REGEX_PATTERN_START + command.GetLastResult().GetCode()
				- CSearchError::BADPATTERN_BACK_REFERENCE_TO_NON_EXSISTANT) % command.GetLastResult().GetPosition());
}

/**
 *	@brief	݂̌ɏ]ĎA͑O̕
 *
 *	̃\bh̓qbgIԂɂB
 *	܂A_CAO\ł@\
 *	@param bForward				O
 *	@param bMessageOnFailure	sƂɃvvg\
 */
void CAlphaApp::SearchNext(bool bForward, bool bMessageOnFailure) {
	CAlphaView&			activeView = GetActiveView();
	CFindNextCommand	command(activeView, false, bForward);

	m_pdlgSearch->UpdateOptions();
	activeView.GetTextSearcher().SetSearchText(m_pdlgSearch->GetFindText());
	if(command.Execute()) {
		if(m_pdlgSearch->IsWindow())
			m_pdlgSearch->CheckDlg2StateButton(IDC_CHK_SHIFT, !bForward);
		m_pdlgSearch->AddToHistory(m_pdlgSearch->GetFindText(), false);
	} else if(bMessageOnFailure && m_bShowMessageBoxOnFind) {
		if(command.GetLastResult().IsFatalError())
			MessageBox(MSG_REGEXP_PATTERN_SYNTAX_ERROR, MB_ICONEXCLAMATION,
				__MARGS__ % LoadString(MSG_BAD_REGEX_PATTERN_START + command.GetLastResult().GetCode()
					- CSearchError::BADPATTERN_BACK_REFERENCE_TO_NON_EXSISTANT) % command.GetLastResult().GetPosition());
		else
			MessageBox(MSG_TEXT_NOT_FOUND, MB_ICONINFORMATION);
	}
	if(m_pdlgSearch->IsWindowVisible()) {
		if(m_pdlgSearch->IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [_CAO]
			GetMainWindow().SendMessage(WM_COMMAND, CMD_SEARCH_FIND);
		else
			::SetFocus(m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT));
	}
}

void CAlphaApp::SetActiveBuffer(CAlphaDoc& buffer, size_t iPane /* = -1 */) throw(out_of_range) {
	assert(iPane == -1);
	m_editorWindow.GetActivePane().ShowBuffer(buffer);
}

void CAlphaApp::SetActiveBuffer(size_t iBuffer, size_t iPane /* = -1 */) throw(out_of_range) {
	SetActiveBuffer(m_buffers.GetAt(iBuffer), iPane);
}

///	SẴGfB^ƈꕔ̃Rg[ɐVtHgݒ
void CAlphaApp::SetFont(const LOGFONTW& lf) {
	LOGFONTW	lf_ = lf;

	lf_.lfWeight = FW_NORMAL;
	::DeleteObject(m_hCommonFont);
	m_hCommonFont = ::CreateFontIndirectW(&lf_);

	// SẴr[̃tHgXV
	CAlphaView*	pView = 0;
	for(size_t i = 0; i < m_buffers.GetCount(); ++i)
		m_buffers.GetAt(i).GetView(0).GetLayoutSettings().SetFont(lf_);

	// ꕔ̃Rg[ɂݒ
	if(toBoolean(GetProfileInt(L"View", L"applyMainFontToSomeControls", 1))) {
		if(m_pdlgBookmark != 0 && m_pdlgBookmark->IsWindow())
			m_pdlgBookmark->SendDlgItemMessage(IDC_LIST_BOOKMARKS,
				WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
		if(m_pdlgSearch != 0 && m_pdlgSearch->IsWindow()) {
			m_pdlgSearch->SendDlgItemMessage(IDC_COMBO_FINDWHAT,
				WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
			m_pdlgSearch->SendDlgItemMessage(IDC_COMBO_REPLACEWITH,
				WM_SETFONT, reinterpret_cast<WPARAM>(m_hCommonFont), true);
		}
	}

	// INI t@Cɕۑ
	WriteProfileStruct(L"View", L"oFont.pLogfont", &lf_, sizeof(LOGFONTW));

	//  <-> ϕŕ\LςKv
	_UpdateStatusBar(SBP_POSITION);
}

///	j[̏
void CAlphaApp::_SetupMenus() {
	AssertValid();

	if(m_pMenu != 0) {
		while(true) {
			const UINT	cItems = m_pMenu->GetItemCount();
			if(cItems == 0 || cItems == -1)
				break;
			m_pMenu->RemoveMenuItem(0, false);
		}
		delete m_pMenu;
	}
	m_pMenu = new CMenu(GetMainWindow().GetMenu());
	m_pMenu->DeleteMenuItem(0, false);	// _~[ (Ӗ̂͏̂)

	// j[o[
	m_pMenu->AppendMenuItem(CMD_FILE_TOP, MFT_STRING, LoadString(CMD_FILE_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_EDIT_TOP, MFT_STRING, LoadString(CMD_EDIT_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_SEARCH_TOP, MFT_STRING, LoadString(CMD_SEARCH_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_VIEW_TOP, MFT_STRING, LoadString(CMD_VIEW_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_MACRO_TOP, MFT_STRING, LoadString(CMD_MACRO_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_TOOL_TOP, MFT_STRING, LoadString(CMD_TOOL_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_HELP_TOP, MFT_STRING, LoadString(CMD_HELP_TOP).c_str());

	// [t@C]
	CMenu* pFileMenu = new CMenu();
	pFileMenu->AppendMenuItem(CMD_FILE_NEW, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_NEWWITHFORMAT, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MF_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_OPEN, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_REOPEN, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_REOPENWITHCODEPAGE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_MRU, MFT_OWNERDRAW);
	pFileMenu->SetChildPopup(*m_pMRUManager->GetPopupMenu(), CMD_FILE_MRU, false, true);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_CLOSE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_CLOSEALL, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_CLOSEOTHERS, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SAVE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SAVEAS, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SAVEALL, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_PROPERTY, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_OPERATE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SENDMAIL, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_EXIT, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(*pFileMenu, CMD_FILE_TOP, true, true);

	// [t@C]-[t@C]
	delete m_pFileOpeMenu;
	m_pFileOpeMenu = new CMenu();
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_RENAME, MFT_OWNERDRAW);
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_COPY, MFT_OWNERDRAW);
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_MOVE, MFT_OWNERDRAW);
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_DELETE, MFT_OWNERDRAW);
	pFileMenu->SetChildPopup(*m_pFileOpeMenu, CMD_FILE_OPERATE, false, true);

	// [ҏW]
	CMenu* pEditMenu = new CMenu();
	pEditMenu->AppendMenuItem(CMD_EDIT_UNDO, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_REDO, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_CUT, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_COPY, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_PASTE, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_PASTEFROMCLIPBOARDRING, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_DELETE, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_SELECTALL, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_ADVANCED, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_OPENCANDIDATEWINDOW, MF_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_SHOWABBREVIATIONDLG, MF_OWNERDRAW);
	m_pMenu->SetChildPopup(*pEditMenu, CMD_EDIT_TOP, true, true);

	// [ҏW]-[xȑ]
	CMenu* pAdvEditMenu = new CMenu();
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_CHARTOCODEPOINT, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_CODEPOINTTOCHAR, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_NARROWTOSELECTION, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_WIDEN, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTGRAVE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTACUTE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTCIRCUMFLEX, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTTILDE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTMACRON, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTBREVE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTDIAERESIS, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTCARON, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTCEDILLA, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTSUPER, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTSUB, MFT_OWNERDRAW);
	pEditMenu->SetChildPopup(*pAdvEditMenu, CMD_EDIT_ADVANCED, true, true);

	// []
	CMenu* pFindMenu = new CMenu();
	pFindMenu->AppendMenuItem(CMD_SEARCH_FIND, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_FINDNEXT, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_FINDPREV, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCH, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHR, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHRF, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHRR, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHMF, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHMR, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_REVOKEMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_GOTOLINE, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_TOGGLEBOOKMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_NEXTBOOKMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_PREVBOOKMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_CLEARBOOKMARKS, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_MANAGEBOOKMARKS, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_GOTOMATCHBRACKET, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_EXTENDTOMATCHBRACKET, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(*pFindMenu, CMD_SEARCH_TOP, true, true);

	// [\]
	CMenu*	pViewMenu = new CMenu();
	pViewMenu->AppendMenuItem(CMD_VIEW_TOOLBAR, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_STATUSBAR, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_BUFFERBAR, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_BUFFERS, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_NEXTBUFFER, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_PREVBUFFER, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_SPLITNS, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_SPLITWE, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_UNSPLITOTHERS, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_UNSPLITACTIVE, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_NEXTPANE, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_PREVPANE, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_WRAPNO, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_WRAPBYSPECIFIEDWIDTH, MFT_OWNERDRAW, MFS_GRAYED);
	pViewMenu->AppendMenuItem(CMD_VIEW_WRAPBYWINDOWWIDTH, MFT_OWNERDRAW, MFS_GRAYED);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_TOPMOSTALWAYS, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_REFRESH, MFT_OWNERDRAW);
	pViewMenu->SetChildPopup(m_buffers.GetBufferListMenu(), CMD_VIEW_BUFFERS, false, true);
	m_pMenu->SetChildPopup(*pViewMenu, CMD_VIEW_TOP, true, true);

	// [}N]
	CMenu*	pMacroMenu = new CMenu();
	pMacroMenu->AppendMenuItem(CMD_MACRO_RECORD, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_PLAY, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_STOP, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_ABORT, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_PAUSERESTART, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_SAVEAS, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_SCRIPTS, MFT_OWNERDRAW);
/*	pDebugMenu->AppendMenuItem(CMD_DEBUG_INSERTBREAKPOINT, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_INSERTBREAKPOINT));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_BREAKPOINTS, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_BREAKPOINTS));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_ACTIVEDOCUMENTS, MF_OWNERDRAW | MF_GRAYED, GetMenuLabel(CMD_DEBUG_ACTIVEDOCUMENTS));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(CMD_DEBUG_START, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_START));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_RESTART, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_RESTART));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STOP, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STOP));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STEPINTO, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STEPINTO));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STEPOVER, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STEPOVER));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STEPOUT, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STEPOUT));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(CMD_DEBUG_CALLSTACK, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_CALLSTACK));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_VARIABLES, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_VARIABLES));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_IMMEDIATE, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_IMMEDIATE));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_THREADS, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_THREADS));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_EXCEPTION, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_EXCEPTION));
*/	m_pMenu->SetChildPopup(*pMacroMenu, CMD_MACRO_TOP, true, true);

	// [}N]-[XNvg] (b)
	CMenu*	pScriptMenu = new CMenu();
//	pScriptMenu->AppendMenuItem(CMD_EDIT_RELOADPLUGIN, MF_OWNERDRAW, GetMenuLabel(CMD_EDIT_RELOADPLUGIN));
//	pScriptMenu->AppendMenuItem(0, MFT_SEPARATOR, 0);
	const size_t	cScripts = m_pScriptMacroManager->GetCount();
	if(cScripts != 0) {
//		pScriptMenu->AppendMenuItem(CMD_MACRO_INTERRUPT, MFT_OWNERDRAW);
//		pScriptMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
		for(size_t i = 0; i < cScripts; ++i)
			pScriptMenu->AppendMenuItem(CMD_EDIT_PLUGINLIST_START + i, MFT_OWNERDRAW);
	} else
		pScriptMenu->AppendMenuItem(CMD_EDIT_PLUGINLIST_START, MFT_OWNERDRAW, MF_GRAYED | MF_DISABLED);
	pMacroMenu->SetChildPopup(*pScriptMenu, CMD_MACRO_SCRIPTS, true, true);

	// [c[]
	CMenu* pToolMenu = new CMenu();
	pToolMenu->AppendMenuItem(CMD_TOOL_EXECUTE, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_EXECUTECOMMAND, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_APPDOCTYPES, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_DOCTYPEOPTION, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_COMMONOPTION, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_FONT, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(*pToolMenu, CMD_TOOL_TOP, true, true);
	delete m_pAppDocTypeMenu;
	m_pAppDocTypeMenu = new CMenu();	// [Kp^Cv]
	pToolMenu->SetChildPopup(*m_pAppDocTypeMenu, CMD_TOOL_APPDOCTYPES, false, true);

	// [wv]
	CMenu* pHelpMenu = new CMenu();
	pHelpMenu->AppendMenuItem(CMD_HELP_ABOUT, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(*pHelpMenu, CMD_HELP_TOP, true, true);

	// ^u
	delete m_pBufferBarMenu;
	m_pBufferBarMenu = new CMenu();
	m_pBufferBarMenu->AppendMenuItem(CMD_FILE_CLOSE, MFT_OWNERDRAW);
	m_pBufferBarMenu->AppendMenuItem(CMD_FILE_CLOSEOTHERS, MFT_OWNERDRAW);
	m_pBufferBarMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	m_pBufferBarMenu->AppendMenuItem(CMD_FILE_PROPERTY, MFT_OWNERDRAW);
	m_pBufferBarMenu->AppendMenuItem(CMD_FILE_OPERATE, MFT_OWNERDRAW);
	m_pBufferBarMenu->SetDefaultMenuItem(CMD_FILE_CLOSE);
	m_pBufferBarMenu->SetChildPopup(*m_pFileOpeMenu, CMD_FILE_OPERATE, false, true);

	GetMainWindow().DrawMenuBar();
}

///	c[o[̏
void CAlphaApp::_SetupToolbar() {
	AssertValid();

	// Wc[o[
	CommandId*		pCommands = 0;	// c[o[ɏ悹{^ɑΉR}h
	size_t			cButtons;		// {^
	list<wstring>	buttons;

	// ݒǂݍ
	_GetProfileList(L"ToolbarButtons", L"standard", buttons, L"");

	if(!buttons.empty()) {	// Ggꍇ
		list<wstring>::const_iterator	it;
		size_t							i = 0;

		cButtons = buttons.size();
		pCommands = new CommandId[cButtons];
		for(i = 0, it = buttons.begin(); it != buttons.end(); ++i, ++it)
			pCommands[i] = static_cast<CommandId>(wcstoul(it->c_str(), 0, 10));
	} else {	// ftHg̐ݒg
		cButtons = 16;
		pCommands = new CommandId[cButtons];
		pCommands[0] = CMD_FILE_NEW;			pCommands[1] = CMD_FILE_OPEN;
		pCommands[2] = CMD_FILE_SAVE;			pCommands[3] = CMD_FILE_SAVEAS;
		pCommands[4] = CMD_FILE_SAVEALL;		pCommands[5] = 0;
		pCommands[6] = CMD_EDIT_CUT;			pCommands[7] = CMD_EDIT_COPY;
		pCommands[8] = CMD_EDIT_PASTE;			pCommands[9] = 0;
		pCommands[10] = CMD_EDIT_UNDO;			pCommands[11] = CMD_EDIT_REDO;
		pCommands[12] = 0;						pCommands[13] = CMD_SEARCH_FIND;
		pCommands[14] = CMD_SEARCH_FINDNEXT;	pCommands[15] = CMD_SEARCH_FINDPREV;
	}

	// C[WXg쐬
	wchar_t		wszIconDir[MAX_PATH];

	::GetModuleFileNameW(0, wszIconDir, MAX_PATH);
	::PathFindFileNameW(wszIconDir)[0] = 0;
	wcscat(wszIconDir, IDS_ICON_DIRECTORY_NAME);
	m_pCommandManager->CreateImageList(wszIconDir);

	// {^
	TBBUTTON*	pButtons = new TBBUTTON[cButtons];
	bool		bHasDropArrow;
	for(size_t i = 0; i < cButtons; ++i) {
		bHasDropArrow = pCommands[i] == CMD_FILE_NEW || pCommands[i] == CMD_FILE_OPEN;
		ZeroMemory(pButtons + i, sizeof(TBBUTTON));
		pButtons[i].fsState = TBSTATE_ENABLED;
		if(pCommands[i] == 0)
			pButtons[i].fsStyle = BTNS_SEP;
		else {
			size_t	iIcon = m_pCommandManager->GetIconIndex(pCommands[i]);

			if(bHasDropArrow)		pButtons[i].fsStyle = BTNS_BUTTON | BTNS_DROPDOWN;
			else if(iIcon == -1)	pButtons[i].fsStyle = BTNS_AUTOSIZE | BTNS_BUTTON;
			else					pButtons[i].fsStyle = BTNS_BUTTON;
			if(iIcon != -1 /*&& !bHasDropArrow*/)
				pButtons[i].iBitmap = iIcon;
			else {
				const wstring	strCaption = m_pCommandManager->GetCaption(pCommands[i]);
				wchar_t*		pwszCaption = new wchar_t[strCaption.length() + 1];
				wcscpy(pwszCaption, strCaption.c_str());
				pButtons[i].iString = reinterpret_cast<INT_PTR>(pwszCaption);
				pButtons[i].iBitmap = bHasDropArrow ? iIcon : I_IMAGENONE;
			}
		}
		pButtons[i].idCommand = pCommands[i];
	}

	if(!m_toolbar.IsWindow()) {
		m_toolbar.Create(m_rebar, DefaultWindowRect(), L"", IDC_TOOLBAR,
			WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE
			| CCS_NODIVIDER | CCS_NOPARENTALIGN | CCS_NORESIZE | CCS_TOP
			| TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT, WS_EX_TOOLWINDOW);
		HWND	hTooltip = m_toolbar.GetToolTips();
		m_toolbar.SetButtonStructSize();
		m_toolbar.SetExtendedStyle(TBSTYLE_EX_DRAWDDARROWS /*| TBSTYLE_EX_HIDECLIPPEDBUTTONS*/);
		::SetWindowLongPtrW(hTooltip, GWL_STYLE, ::GetWindowLongPtrW(hTooltip, GWL_STYLE) | TTS_NOPREFIX);
	} else {
		m_toolbar.SetImageList(0);
		m_toolbar.SetDisabledImageList(0);
		while(m_toolbar.GetButtonCount() != 0)
			m_toolbar.DeleteButton(0);
	}
	m_toolbar.AddButtons(cButtons, pButtons);
	m_toolbar.SetImageList(m_pCommandManager->GetImageList(CCommandManager::ICONSTATE_NORMAL));
	m_toolbar.SetDisabledImageList(m_pCommandManager->GetImageList(CCommandManager::ICONSTATE_DISABLED));
	m_toolbar.SetHotImageList(m_pCommandManager->GetImageList(CCommandManager::ICONSTATE_HOT));
//	m_toolbar.SetPadding(6, 6);

	for(size_t i = 0; i < cButtons; ++i) {
		delete[] reinterpret_cast<wchar_t*>(pButtons[i].iString);
		if(pButtons[i].fsStyle != BTNS_SEP
				&& pButtons[i].iBitmap != I_IMAGENONE) {	// ACRt{^̕ŌŒ肷
			TBBUTTONINFOW	tbi;

			tbi.cbSize = sizeof(TBBUTTONINFOW);
			tbi.dwMask = TBIF_SIZE;
			tbi.cx = (pButtons[i].idCommand != CMD_FILE_NEW && pButtons[i].idCommand != CMD_FILE_OPEN) ? 22 : 38;
			m_toolbar.SetButtonInfo(pButtons[i].idCommand, tbi);
		}
	}
	delete[] pCommands;
	delete[] pButtons;

	// obt@o[
	if(!m_bufferBar.IsWindow()) {
		m_bufferBar.Create(m_rebar, DefaultWindowRect(), 0, IDC_BUFFERBAR,
			WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE
			| CCS_NODIVIDER | CCS_NOPARENTALIGN | CCS_NORESIZE | CCS_TOP
			| TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_REGISTERDROP | TBSTYLE_TOOLTIPS | TBSTYLE_TRANSPARENT, WS_EX_TOOLWINDOW);
		HWND	hTooltip = m_bufferBar.GetToolTips();
		m_bufferBar.SetButtonStructSize();
		::SetWindowLongPtrW(hTooltip, GWL_STYLE, ::GetWindowLongPtrW(hTooltip, GWL_STYLE) | TTS_NOPREFIX);
	}

	// o[ɏ悹
	if(m_rebar.GetBandCount() == 0) {
		AutoZeroCB<REBARBANDINFOW>	rbbi;
		const wstring				strCaption = LoadString(MSG_BUFFERBAR_CAPTION);

		rbbi.fMask = RBBIM_CHILD | RBBIM_CHILDSIZE | RBBIM_ID | RBBIM_STYLE;
		rbbi.fStyle = /*RBBS_CHILDEDGE |*/ RBBS_GRIPPERALWAYS | RBBS_USECHEVRON;
		rbbi.wID = IDC_TOOLBAR;
		rbbi.hwndChild = m_toolbar.GetSafeHwnd();
		rbbi.cxMinChild = 0;
		rbbi.cyMinChild = 22;
		m_rebar.InsertBand(0, rbbi);
		rbbi.fMask |= RBBIM_TEXT;
		rbbi.fStyle |= RBBS_BREAK;
		rbbi.wID = IDC_BUFFERBAR;
		rbbi.lpText = const_cast<wchar_t*>(strCaption.c_str());
		rbbi.hwndChild = m_bufferBar.GetSafeHwnd();
		m_rebar.InsertBand(1, rbbi);
	}

	// c[o[̃VFu镝̐ݒ
	AutoZeroCB<REBARBANDINFOW>	rbbi;
	RECT						rect;

	m_toolbar.GetItemRect(m_toolbar.GetButtonCount() - 1, rect);
	rbbi.fMask = RBBIM_IDEALSIZE;
	rbbi.cxIdeal = rect.right;
	m_rebar.SetBandInfo(m_rebar.IdToIndex(IDC_TOOLBAR), rbbi);
}

///	[ƒu] _CAO̕\/\
void CAlphaApp::ShowSearchDialog() {
	CAlphaView&	activeView = GetActiveView();

	if(!m_pdlgSearch->IsWindowVisible()) {
		if(activeView.GetSelection().IsEmpty()) {
			string_t	str;
			activeView.GetNearestWordFromCaret(0, 0, &str);
			m_pdlgSearch->SetDlgItemText(IDC_COMBO_FINDWHAT, str.c_str());
		} else if(activeView.GetSelection().GetAnchorPoint().GetLineNumber()
				!= activeView.GetSelection().GetActivePoint().GetLineNumber())
			m_pdlgSearch->SetDlgItemText(IDC_COMBO_FINDWHAT, L"");
		else
			m_pdlgSearch->SetDlgItemText(IDC_COMBO_FINDWHAT, activeView.GetSelection().GetText().c_str());
		m_pdlgSearch->ShowWindow(SW_SHOW);
	} else
		m_pdlgSearch->ShowWindow(SW_HIDE);
}

/**
 *	Xe[^Xo[̍XV
 *	@param pane	XVyC
 */
void CAlphaApp::_UpdateStatusBar(StatusBarPane panes) {
	AssertValid();

	if(!m_statusBar.IsWindowVisible())
		return;

	const int			ICON_WIDTH = 16;
	CAlphaDoc&			activeBuffer = GetActiveBuffer();
	const CAlphaView&	activeView = GetActiveView();

	// p[c̕XVKv
	if(toBoolean(panes & (SBP_DOCUMENTTYPE | SBP_ENCODING))) {
		CClientDC	dc = m_statusBar.GetDC();
		HFONT		hOldFont = static_cast<HFONT>(dc.SelectObject(m_hStatusFont));
		int			parts[9];
		int			borders[3];
		RECT		rcStatusBar;

		m_statusBar.SetSimple(false);
		m_statusBar.GetWindowRect(rcStatusBar);
		m_statusBar.GetBorders(borders);
		const int	nPadding = (borders[0] + borders[2]) * 2 + 5;

		// E[
		parts[8] = rcStatusBar.right - rcStatusBar.left;
		// TCYObv
		parts[7] = parts[8] - (GetMainWindow().IsZoomed() ? 0 : (rcStatusBar.bottom - rcStatusBar.top - borders[1] * 2));
		// i[CO
		parts[6] = parts[7] - ICON_WIDTH - nPadding;
		// ㏑/}[h
		const wstring	strOvertypeMode = LoadString(MSG_OVERTYPE_MODE);
		const wstring	strInsertMode = LoadString(MSG_INSERT_MODE);
		parts[5] = parts[6] - max(
			dc.GetTextExtent(strOvertypeMode.data(), strOvertypeMode.length()).cx,
			dc.GetTextExtent(strInsertMode.data(), strInsertMode.length()).cx) - nPadding;
		// fobO[h
		parts[4] = parts[5] - ICON_WIDTH - nPadding;
		// L[{[h}N
		parts[3] = parts[4] - ICON_WIDTH - nPadding;
		// GR[fBO
		const wstring	strEncoding = GetCodePageName(activeBuffer.GetCodePage());
		parts[2] = parts[3] - dc.GetTextExtent(strEncoding.data(), strEncoding.length()).cx - nPadding;
		// ^Cv
		parts[1] = parts[2] - dc.GetTextExtent(activeBuffer.m_strDocType.data(), activeBuffer.m_strDocType.length()).cx - nPadding;
		// Lbgʒu
		const wstring	strCaretPosition = activeView.GetCurrentPositionString();
		parts[0] = parts[1] - dc.GetTextExtent(strCaretPosition.data(), strCaretPosition.length()).cx - nPadding;

		m_statusBar.SetParts(_countof(parts), parts);
		m_statusBar.SetText(8 | SBT_NOBORDERS, L"");
		dc.SelectObject(hOldFont);
	} else if(toBoolean(panes & SBP_POSITION)) {
		CClientDC		dc = m_statusBar.GetDC();
		int				parts[9];
		int				borders[3];
		const wstring	strCaretPosition = activeView.GetCurrentPositionString();
		HFONT			hOldFont = static_cast<HFONT>(dc.SelectObject(m_hStatusFont));

		m_statusBar.GetBorders(borders);
		m_statusBar.GetParts(_countof(parts), parts);
		const int	nOldWidth = parts[0];
		parts[0] = parts[1] - dc.GetTextExtent(strCaretPosition.data(), strCaretPosition.length()).cx - (borders[0] + borders[2]) * 2 - 6;
		if(parts[0] != nOldWidth)
			m_statusBar.SetParts(_countof(parts), parts);
		dc.SelectObject(hOldFont);
	}

#define UPDATE_PANE(index, pane, text)	if(toBoolean(panes & pane))	m_statusBar.SetText(index, text)
#define UPDATE_PANE_WITH_ICON(index, pane, text, icon)	\
	if(toBoolean(panes & pane)) {						\
		m_statusBar.SetText(index, text);				\
		m_statusBar.SetTipText(index, text);			\
		m_statusBar.SetIcon(index, icon);				\
	}

	UPDATE_PANE_WITH_ICON(7, SBP_NARROWING,
		activeBuffer.IsNarrowed() ? LoadString(MSG_NARROWING).c_str() : L"", activeBuffer.IsNarrowed() ? m_hNarrowingIcon : 0);
	UPDATE_PANE(6, SBP_OVERTYPEMODE, LoadString(activeView.IsOvertypeMode() ? MSG_OVERTYPE_MODE : MSG_INSERT_MODE).c_str());
//	UPDATE_PANE(5, SBP_DEBUGMODE, /*(m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging()) ? LoadString(MSG_DEBUGGING) :*/ L"");
//	UPDATE_PANE(4, SBP_KEYBOARDMACRO, /*view.GetKeyboardMacro().IsRecording() ? LoadString(MSG_MACRO_RECORDING) :*/ L"");
	UPDATE_PANE(3, SBP_ENCODING, GetCodePageName(activeBuffer.GetCodePage()));
	UPDATE_PANE(2, SBP_DOCUMENTTYPE, activeBuffer.m_strDocType.c_str());
	UPDATE_PANE(1, SBP_POSITION, activeView.GetCurrentPositionString());

#undef UPDATE_PANE
#undef UPDATE_PANE_WITH_ICON
}

///	^Cgo[ƃobt@o[{^LvV̍XV
void CAlphaApp::_UpdateTitleBar() {
	AssertValid();

	static wstring	strTitleCache;

	if(!GetMainWindow().IsWindow())
		return;

	const CAlphaDoc&	activeBuffer = GetActiveBuffer();
	wstring				strTitle = GetBufferName(activeBuffer);

	if(strTitle == strTitleCache)
		return;
	strTitleCache = strTitle;

	// obt@o[
	if(m_bufferBar.IsWindow())
		m_bufferBar.SetButtonText(CMD_VIEW_BUFFERLIST_START + m_buffers.Find(activeBuffer), strTitle.c_str());

	// ^Cgo[
	strTitle += L" - " IDS_APPFULLVERSION;
	GetMainWindow().SetWindowText(strTitle.c_str());
}

/// @see	CIncrementalSearcher::IEventListener::OnISearchAborted
void CAlphaApp::OnISearchAborted() {
}

/// @see	CIncrementalSearcher::IEventListener::OnISearchCompleted
void CAlphaApp::OnISearchCompleted() {
	m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
	if(toBoolean(GetProfileInt(L"View", L"applyMainFontToSomeControls", 1)))
		m_statusBar.SetFont(0);
}

/// @see	CIncrementalSearcher::IEventListener::OnISearchPatternChanged
void CAlphaApp::OnISearchPatternChanged(const SearchResult& result) {
	const CIncrementalSearcher&	isearch = GetActiveView().GetIncrementalSearcher();
	UINT		msg;
	const bool	bForward = isearch.GetState() == CIncrementalSearcher::LITERAL_FORWARD
				|| isearch.GetState() == CIncrementalSearcher::REGEXP_FORWARD
				|| isearch.GetState() == CIncrementalSearcher::MIGEMO_FORWARD;

	if(isearch.GetSearchText().empty()) {
		msg = bForward ? MSG_ISEARCH_TEXT_IS_EMPTY : MSG_RISEARCH_TEXT_IS_EMPTY;
		m_statusBar.SetText(0, LoadString(msg).c_str(), SBT_NOBORDERS);
		return;
	} else if(result.GetCode() == CSearchError::SUCCEEDED)
		msg = bForward ? MSG_ISEARCH_PROMPT : MSG_RISEARCH_PROMPT;
	else if(result.GetCode() == CSearchError::NO_MATCH)
		msg = bForward ? MSG_ISEARCH_NOT_FOUND_PROMPT : MSG_RISEARCH_NOT_FOUND_PROMPT;
	else
		msg = bForward ? MSG_ISEARCH_BAD_REGEXP : MSG_RISEARCH_BAD_REGEXP;

	string_t	strPrompt = LoadString(msg, __MARGS__ % isearch.GetSearchText());
	replace_if(strPrompt.begin(), strPrompt.end(), std::bind2nd(std::equal_to<wchar_t>(), L'\t'), L' ');
	m_statusBar.SetText(0, strPrompt.c_str(), SBT_NOBORDERS);
}

/// @see	CIncrementalSearcher::IEventListener::OnISearchStarted
void CAlphaApp::OnISearchStarted() {
	// Xe[^Xo[̃tHgGfB^̂̂Ɉv
	if(toBoolean(GetProfileInt(L"View", L"applyMainFontToSomeControls", 1)))
		m_statusBar.SetFont(m_hCommonFont);
}

///	@see	IEditViewEventListener::OnInvokeUriLink
void CAlphaApp::OnInvokeUriLink(const char_t* pwszUri) {
	::ShellExecuteW(0, 0, pwszUri, 0, 0, SW_SHOWNORMAL);
}

///	[c[]-[fobO]-[u[N|Cg̊Ǘ]
void CAlphaApp::OnToolDebugBreakPoints() {
/*	BreakPointList							listBreakPoints;
	list<TAppDefinedLine>					listLineAttrs;
	list<TAppDefinedLine>::const_iterator	it;

	if(CAlphaEditController* pActiveEditor = GetActiveTab()->GetTextEditor()) {
		// AvP[Vsu[N|Cgɕϊ
		CAlphaView*		pActiveView = pActiveEditor->GetPrimaryView();
		TBreakPointInfo	bpi;

		pActiveView->GetAllLineParams(listLineAttrs);
		for(it = listLineAttrs.begin(); it != listLineAttrs.end(); ++it) {
			if(it->dwParam & LA_BREAKPOINT_ENABLED)
				bpi.bEnabled = true;
			else if(it->dwParam & LA_BREAKPOINT_DISABLED)
				bpi.bEnabled = false;
			else
				continue;
			bpi.iLine = it->iLine;
			listBreakPoints.push_back(bpi);
		}

		m_pdlgDebugBreakPoints->m_listBreakPoints = listBreakPoints;
		if(IDOK == m_pdlgDebugBreakPoints->DoModal()) {
			// u[N|Cgݒ肵
			unsigned long	cLines = pActiveView->GetDocument()->GetLineCount();

			for(unsigned long iLine = 0; iLine < cLines; ++iLine)	// xSĉ
				pActiveView->SetLineParam(iLine, LA_NONE, LA_BREAKPOINT_MASK);
			for(BreakPointList::const_iterator it
					= m_pdlgDebugBreakPoints->m_listBreakPoints.begin();
					it != m_pdlgDebugBreakPoints->m_listBreakPoints.end(); ++it)	// ݒ肷
				pActiveView->SetLineParam(it->iLine, it->bEnabled ?
					LA_BREAKPOINT_ENABLED : LA_BREAKPOINT_DISABLED, LA_BREAKPOINT_MASK);
		}
	}*/
}


///	[c[]-[fobO]-[R[X^bN]
void CAlphaApp::OnToolDebugCallStack() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugCallStack->IsWindow()) {
			m_pdlgDebugCallStack->DoModeless();
			m_pdlgDebugCallStack->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugCallStack->SendMessage(WM_CLOSE);
	}*/
}

///	[c[]-[fobO]-[C~fBGCg]
void CAlphaApp::OnToolDebugImmediate() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugImmediate->IsWindow()) {
			m_pdlgDebugImmediate->DoModeless();
			m_pdlgDebugImmediate->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugImmediate->SendMessage(WM_CLOSE);
	}*/
}

///	[c[]-[fobO]-[u[N|Cg̑}//폜]
void CAlphaApp::OnToolDebugInsertBreakPoint() {
/*	if(CAlphaEditController* pActiveEditor = GetActiveTab()->GetTextEditor()) {
		CCharPos	posBegin, posEnd;
		CAlphaView*	pView = pActiveEditor->GetPrimaryView();
		DWORD		dwLineAttr;

		pView->GetSel(posBegin, posEnd);
		dwLineAttr= pView->GetLineParam(posEnd.m_iLine);
		if(toBoolean(dwLineAttr & LA_BREAKPOINT_ENABLED)) {	// L -> 
			dwLineAttr &= ~LA_BREAKPOINT_ENABLED;
			dwLineAttr |= LA_BREAKPOINT_DISABLED;
		} else if(toBoolean(dwLineAttr & LA_BREAKPOINT_DISABLED))	//  -> 폜
			dwLineAttr &= ~LA_BREAKPOINT_DISABLED;
		else	//  -> L
			dwLineAttr |= LA_BREAKPOINT_ENABLED;
		pView->SetLineParam(posEnd.m_iLine, dwLineAttr);
	}*/
}

///	[c[]-[fobO]-[Jn]
void CAlphaApp::OnToolDebugStart() {
/*	if(GetActiveTab()->GetTextEditor() == 0)
		return;
	if(m_pActiveDebugger != 0) {	// fobOłΑs
		m_pActiveDebugger->Continue();
		return;
	}

	Alpha::BreakPointList	listBreakPoints;
	list<TAppDefinedLine>	listLines;
	CAlphaDoc*				pActiveDoc = GetActiveTab()->GetTextEditor()->GetDocument();
	Alpha::TBreakPointInfo	bpi;
	wstring					strLanguageName = m_oScriptLanguages.LanguageNameFromExtension(pActiveDoc->GetExtensionName());

	// GWŶꍇ̓_CAOŐu
	if(strLanguageName.empty()) {
		CSelectLanguageDlg	oDlg;

		oDlg.m_setLanguages = m_oScriptLanguages.GetLanguages();
		oDlg.Create(m_hInstance, IDD_DLG_SELECTLANGUAGE, m_pMainWindow->m_hWnd);
		if(IDOK != oDlg.DoModal())
			return;
		strLanguageName = oDlg.m_strSelection;
	}

	// fobOT|[gĂȂꍇɑs邩q˂
	if(!CScriptLanguageManager::QueryDebuggable(strLanguageName)
			&& IDNO == MessageBox(MSG_DEBUG_ENGINENOTSUPPORTDEBUGGING, MB_YESNO | MB_ICONQUESTION))
		return;

	m_pDebuggingEditor = GetActiveTab()->GetTextEditor();
	m_pDebuggingEditor->GetPrimaryView()->GetAllLineParams(listLines);
	for(list<TAppDefinedLine>::const_iterator it = listLines.begin(); it != listLines.end(); ++it) {
		if(it->dwParam & LA_BREAKPOINT_ENABLED)
			bpi.bEnabled = true;
		else if(it->dwParam & LA_BREAKPOINT_DISABLED)
			bpi.bEnabled = false;
		else
			continue;
		bpi.iLine = it->iLine;
		listBreakPoints.push_back(bpi);
	}

	m_pActiveDebugger = new CAlphaApplicationDebugger(m_pMainWindow->m_hWnd, listBreakPoints);
	m_pActiveDebugger->AddRef();
	m_pActiveDebugger->SetEventListener(static_cast<IAlphaApplicationDebuggerEventListener*>(this));
	m_pActiveDebugger->StartDebugging(pActiveDoc, strLanguageName);*/
}

///	[c[]-[fobO]-[Xbh]
void CAlphaApp::OnToolDebugThreads() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugThreads->IsWindow()) {
			CComPtr<IRemoteDebugApplication>	pApplication;
			m_pActiveDebugger->GetDebuggingApplication(&pApplication);
			m_pdlgDebugThreads->DoModeless();
			m_pdlgDebugThreads->Update(pApplication);
		} else
			m_pdlgDebugThreads->SendMessage(WM_CLOSE);
	}*/
}

///	[c[]-[fobO]-[ϐ]
void CAlphaApp::OnToolDebugVariables() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugVariables->IsWindow()) {
			m_pdlgDebugVariables->DoModeless();
			m_pdlgDebugVariables->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugVariables->SendMessage(WM_CLOSE);
	}*/
}

///	[s]
void CAlphaApp::OnToolExecute() {
	const CAlphaDoc&			activeBuffer = GetActiveBuffer();
	const wstring				strPathName = (activeBuffer.GetPathName() != 0) ? activeBuffer.GetPathName() : L"";
	const CDocumentTypeManager&	types = m_buffers.GetDocumentTypeManager();
	wstring						strCommand = types.GetAt(types.Find(activeBuffer.m_strDocType)).strCommand;

	if(strCommand.empty()) {	// R}hݒ肳ĂȂ
		MessageBox(MSG_EXE_NOT_REGISTERED, MB_ICONEXCLAMATION, __MARGS__ % activeBuffer.m_strDocType);
		return;
	}

	// '$F' WJ
	size_t	i = 0;
	while(wstring::npos != (i = strCommand.find(L"$F", i))) {
		strCommand.replace(i, 2, L"\"" + strPathName + L"\"");
		i += strPathName.length() + 2;
	}

	AutoZeroS<STARTUPINFO, DWORD, &STARTUPINFO::cb>	si;
	PROCESS_INFORMATION								pi;
	if(!toBoolean(::CreateProcessW(0,
			const_cast<wchar_t*>(strCommand.c_str()), 0, 0, false, NORMAL_PRIORITY_CLASS, 0, 0, &si, &pi)))
		MessageBox(MSG_FAILED_TO_RUN_EXE, MB_ICONEXCLAMATION);
}

///	[R}h̎s]
void CAlphaApp::OnToolExecuteCommand() {
	CExecuteCommandDlg	dlg(*this);

	dlg.m_bHijackConsole = toBoolean(GetProfileInt(L"CommandExecuting", L"bHijackConsole", 1));
	dlg.m_bUseUnicode = toBoolean(GetProfileInt(L"CommandExecuting", L"bUseUnicode", 0));
	dlg.Create(m_hInstance, GetMainWindow());
	dlg.DoModal();
}

/// @see	CActiveViewListener::OnActiveViewChanged
void CAlphaApp::OnActiveViewChanged(const CAlphaView& activeView) {
	const size_t	i = m_buffers.Find(activeView.GetDocument());

	if(i != -1) {
		m_bufferBar.CheckButton(i + CMD_VIEW_BUFFERLIST_START);
		for(EditorWindow::Iterator it = m_editorWindow.EnumeratePanes(); !it.IsEnd(); it.Next()) {
			if(it.Get().GetCount() > 0 && &it.Get().GetVisibleView() == &activeView) {
				m_editorWindow.SetDefaultActivePane(it.Get());
				break;
			}
		}
		_UpdateTitleBar();
		_UpdateStatusBar(SBP_ALL);
	}
}

///	@see	IEditViewEventListener::OnChangedAbbreviationExpansionReadyState
void CAlphaApp::OnChangedAbbreviationExpansionReadyState(bool bReady, const string_t& strAbbrev) {
	if(!m_statusBar.IsWindow())
		return;
	else if(bReady) {
		if(!strAbbrev.empty()) {
			const wstring	str = LoadString(MSG_INDICATE_CAN_EXPAND_ABBREV,
					__MARGS__ % strAbbrev % CEditView::GetAbbreviations().Expand(strAbbrev));
			m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
		}
	} else
		m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
}

///	@see	IClipboardRingEventListener::OnClipboardRingChanged
void CAlphaApp::OnClipboardRingChanged() {
}

///	@see	IClipboardRingEventListener::OnClipboardRingDeniedAdding
void CAlphaApp::OnClipboardRingDeniedAdding() {
}

///	@see	WM_CLOSE
bool CAlphaApp::OnClose() {
	DISPPARAMS	params = {0, 0, 0, 0};
	m_pEventHandlerScript->Invoke(OLESTR("OnApplicationTerminating"), &params);
	if(CloseAllBuffers(true)) {
		_SaveINISettings();
		GetMainWindow().DestroyWindow();
		return true;
	}
	return false;	// [ULZ
}

///	@see	CWindow::OnCommand
bool CAlphaApp::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(::GetCurrentThreadId() != GetMainWindow().GetWindowThreadId())
		GetMainWindow().SendMessage(WM_COMMAND, MAKEWPARAM(wID, wNotifyCode), reinterpret_cast<LPARAM>(hwndCtrl));
	if(wID == CMD_SPECIAL_ILLEGAL2STROKE) {
		::MessageBeep(MB_OK);
		return true;
	} else if(wID >= CMD_VIEW_BUFFERLIST_START && wID < CMD_VIEW_BUFFERLIST_END) {
		if(m_pCommandManager->IsEnabled(wID, true))
			SetActiveBuffer(m_buffers.GetAt(wID - CMD_VIEW_BUFFERLIST_START));
	} else
		m_pCommandManager->ExecuteCommand(static_cast<CommandId>(wID), true);

/*	case CMD_DEBUG_START:	// [fobO]-[Jn/s]
		OnToolDebugStart();
		break;
	case CMD_DEBUG_STOP:	// [fobO]-[~]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->Abort();
		break;
	case CMD_DEBUG_STEPOVER:	// [fobO]-[XebvI[o[]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepOver();
		break;
	case CMD_DEBUG_STEPINTO:	// [fobO]-[XebvC]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepInto();
		break;
	case CMD_DEBUG_STEPOUT:	// [fobO]-[XebvAEg]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepOut();
		break;
	case CMD_DEBUG_INSERTBREAKPOINT:	// [fobO]-[u[N|Cg̑}/폜]
		OnToolDebugInsertBreakPoint();
		break;
	case CMD_DEBUG_BREAKPOINTS:		// [fobO]-[u[N|Cg̊Ǘ]
		OnToolDebugBreakPoints();
		break;
	case CMD_DEBUG_ACTIVEDOCUMENTS:	// [fobO]-[s̃hLg]
		if(m_pdlgDebugRunningDocuments->IsWindowVisible())
			m_pdlgDebugRunningDocuments->SendMessage(WM_CLOSE);
		else
			m_pdlgDebugRunningDocuments->DoModeless();
		break;
	case CMD_DEBUG_CALLSTACK:	// [fobO]-[Ăяo]
		OnToolDebugCallStack();
		break;
	case CMD_DEBUG_IMMEDIATE:	// [fobO]-[C~fBGCg]
		OnToolDebugImmediate();
		break;
	case CMD_DEBUG_THREADS:	// [fobO]-[Xbh]
		OnToolDebugThreads();
		break;
	case CMD_DEBUG_VARIABLES:	// [fobO]-[ϐ]
		OnToolDebugVariables();
		break;*/

	return true;
}

///	@see	WM_COPYDATA
void CAlphaApp::OnCopyData(HWND hWnd, PCOPYDATASTRUCT pcds) {
	vector<wstring>	vecArguments;
	GetCommandLineArguments(static_cast<wchar_t*>(pcds->lpData), vecArguments);
	vecArguments.erase(vecArguments.begin());
	ParseCommandLine(vecArguments);
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugEnd
/*void CAlphaApp::OnDebugEnd() {
	if(m_pActiveDebugger != 0) {
		m_pActiveDebugger->Release();
		m_pActiveDebugger = 0;
		m_pDebuggingEditor->GetPrimaryView()->SetAppDefinedLine(-1);
		m_pDebuggingEditor->GetDocument()->SetReadOnly(false);
		m_pDebuggingEditor = 0;
		m_wndOutput.WriteLine(OTT_DEBUG, L"fobOI܂ ----------------\r\n");

		// fobO_CAOЕt
		if(m_pdlgDebugCallStack->IsWindow())	m_pdlgDebugCallStack->SendMessage(WM_CLOSE);
		if(m_pdlgDebugImmediate->IsWindow())	m_pdlgDebugImmediate->SendMessage(WM_CLOSE);
		if(m_pdlgDebugVariables->IsWindow())	m_pdlgDebugVariables->SendMessage(WM_CLOSE);
		if(m_pdlgDebugThreads->IsWindow())		m_pdlgDebugThreads->SendMessage(WM_CLOSE);
	}
	UpdateStatusBar();
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugIllegalStatus
void CAlphaApp::OnDebugIllegalStatus(DebugStatus ds) {
	wstring	strPrompt;

	switch(ds) {
	case DS_OK:
		return;
	case DS_FAILEDTOGETPDM:
		MessageBox(MSG_DEBUG_FAILEDTOGETPDM, MB_ICONEXCLAMATION);
		break;
	case DS_UNKNOWNSCRIPTLANGUAGE:
		MessageBox(MSG_DEBUG_INVALIDLANGUAGENAME, MB_ICONEXCLAMATION);
		break;
	case DS_ENGINENOTSUPPORTPARSER:
		MessageBox(MSG_DEBUG_ENGINENOTSUPPORTPARSING, MB_ICONEXCLAMATION);
		break;
	case DS_ENGINENOTSUPPORTDEBUGGING:
		return;
//		strPrompt = IDS_SENOTSUPPORTDEBUG;
//		break;
	}
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStart
void CAlphaApp::OnDebugStart() {
	m_pDebuggingEditor->GetDocument()->SetReadOnly(true);
	m_wndOutput.Clear(OTT_DEBUG);
	m_wndOutput.WriteLine(OTT_DEBUG, L"fobOJn܂ ----------------");
	UpdateStatusBar();
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStepTo
void CAlphaApp::OnDebugStepTo(unsigned long iLine) {
	if(m_pDebuggingEditor == 0)
		return;
	m_pDebuggingEditor->GetActiveView()->SetSelWithoutSelection(iLine, 0);
	m_pDebuggingEditor->GetPrimaryView()->SetAppDefinedLine(iLine);

	// fobO_CAO̍XV
	if(m_pdlgDebugCallStack->IsWindow())
		m_pdlgDebugCallStack->Update(m_pActiveDebugger);
	if(m_pdlgDebugVariables->IsWindow())
		m_pdlgDebugVariables->Update(m_pActiveDebugger);
	if(m_pdlgDebugThreads->IsWindow()) {
		CComPtr<IRemoteDebugApplication>	pApplication;
		m_pActiveDebugger->GetDebuggingApplication(&pApplication);
		m_pdlgDebugThreads->Update(pApplication);
	}

	// fobÕhLgANeBuɂ
	if(GetActiveTab()->GetTextEditor() != m_pDebuggingEditor) {
		for(unsigned int iTab = 0; iTab < m_vecDocuments.size(); ++iTab) {
			if(CAlphaEditController* pEditor = m_vecDocuments[iTab]->GetTextEditor()) {
				if(pEditor == m_pDebuggingEditor) {
					SetActiveTab(iTab);
					break;
				}
			}
		}
	}
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStopAtBreakPoint
void CAlphaApp::OnDebugStopAtBreakPoint(unsigned long iLine) {
	wostringstream	output;

	OnDebugStepTo(iLine);
	output << L"u[N|CgŒ~܂ [s:" << iLine << L"]";
	m_wndOutput.WriteLine(OTT_DEBUG, output.str());
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStopByError
void CAlphaApp::OnDebugStopByError(unsigned long iLine) {
	wostringstream	output;

	OnDebugStepTo(iLine);
	output << L"^CG[܂ [s:" << iLine << L"]";
	m_wndOutput.WriteLine(OTT_DEBUG, output.str());
}*/

///	@see	CWindow::OnDestroy
void CAlphaApp::OnDestroy() {
	// nȂ (CAlphaApp::OnClose Q)
	GetMainWindow().KillTimer(ID_TIMER_QUERYCOMMAND);

	delete m_pMenu;
	delete m_pMRUManager;
//	m_toolbar.DestroyWindow();
//	m_bufferBar.DestroyWindow();
//	m_statusBar.DestroyWindow();

	for(EditorWindow::Iterator it = m_editorWindow.EnumeratePanes(); !it.IsEnd(); it.Next())
		it.Get().RemoveAll();

	::PostQuitMessage(0);	// STA XbhI
}

///	@see	IEditDocEventListener::OnDocumentLoaded
void CAlphaApp::OnDocumentLoaded() {
	ApplyDocumentType(GetActiveBufferIndex());
}

///	@see	IEditDocEventListener::OnDocumentModified
void CAlphaApp::OnDocumentModified() {
	_UpdateTitleBar();
}

///	@see	IEditDocEventListener::OnDocumentOverwrittenByOtherProcess
void CAlphaApp::OnDocumentOverwrittenByOtherProcess(CEditDoc& document) {
	if(IDYES == MessageBox(MSG_FILE_HAS_BEEN_MODIFIED_BY_OTHER,
			MB_YESNO | MB_ICONQUESTION, __MARGS__ % document.GetPathName())) {
		for(size_t i = 0; i < m_buffers.GetCount(); ++i) {
			if(&m_buffers.GetAt(i) == &document) {
				SetActiveBuffer(m_buffers.GetAt(i));
				ReopenFile(GetActiveBufferIndex(), false);
				break;
			}
		}
	}
}
/*
///	@see	IEditViewEventListener::OnDrawIndicatorMargin
void CAlphaApp::OnDrawIndicatorMargin(length_t iLine,
		CDC& dc, const RECT& rcMargin, bool bBookmarked, DWORD dwParam, bool bSingleEmphasis) {
	CPen	pen;
	CBrush	brush;
	HPEN	hOldPen;
	HBRUSH	hOldBrush;
	int		nMinWidth = min(rcMargin.right - rcMargin.left, rcMargin.bottom - rcMargin.top);

	nMinWidth -= (nMinWidth + 1) % 2;	// ~ȂȂ悤ɓK...

	if(toBoolean(dwParam & LINEATTR_BREAKPOINT_ENABLED)) {	// Lȃu[N|Cg
		RECT	rcCircle = {0, 0, nMinWidth - 2, nMinWidth - 2};
		pen.CreatePen(PS_SOLID, 1, RGB(0x80, 0x00, 0x00));
		brush.CreateSolidBrush(RGB(0x80, 0x00, 0x00));
		hOldPen = dc.SelectObject(pen);
		hOldBrush = dc.SelectObject(brush);
		::OffsetRect(&rcCircle,
			rcMargin.left + (rcMargin.right - rcMargin.left) / 2 - nMinWidth / 2,
			rcMargin.top + (rcMargin.bottom - rcMargin.top) / 2 - nMinWidth / 2);
		dc.Ellipse(rcCircle);
		dc.SelectObject(hOldPen);
		dc.SelectObject(hOldBrush);
	} else if(toBoolean(dwParam & LINEATTR_BREAKPOINT_DISABLED)) {	// ȃu[N|Cg
		RECT	rcCircle = {0, 0, nMinWidth - 2, nMinWidth - 2};
		pen.CreatePen(PS_SOLID, 1, RGB(0x80, 0x00, 0x00));
		brush.CreateSolidBrush(RGB(0xFF, 0xF9, 0xF9));
		hOldPen = dc.SelectObject(pen);
		hOldBrush = dc.SelectObject(brush);
		::OffsetRect(&rcCircle,
			rcMargin.left + (rcMargin.right - rcMargin.left) / 2 - nMinWidth / 2,
			rcMargin.top + (rcMargin.bottom - rcMargin.top) / 2 - nMinWidth / 2);
		dc.Ellipse(rcCircle);
		dc.SelectObject(hOldPen);
		dc.SelectObject(hOldBrush);
	}
	if(bSingleEmphasis) {	// fobOg[Xs
		// TODO: fobOg[Xs̖`
	}
}*/

///	@see	WM_DRAWITEM
void CAlphaApp::OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem) {
	CAutoDC		dc;
	const RECT&	rcItem = lpDrawItem->rcItem;
	RECT		rcCaption;
	HPEN		hOldPen, hPen;
	HBRUSH		hOldBrush, hBrush;
	wchar_t*	pszCaption = 0;
	wchar_t*	pszAccel = 0;	// ANZ[^At@C

	const bool	bChecked = toBoolean(lpDrawItem->itemState & ODS_CHECKED);
	const bool	bDisabled = toBoolean(lpDrawItem->itemState & ODS_DISABLED);
	const bool	bSelected = toBoolean(lpDrawItem->itemState & ODS_SELECTED);

	dc.Attach(lpDrawItem->hDC);

	if(lpDrawItem->CtlType == ODT_MENU) {	// j[̕`
		const CommandId	id = lpDrawItem->itemID;
		const COLORREF	clrHighlight = ::GetSysColor(COLOR_HIGHLIGHT);
		const COLORREF	clrHighlightBack = RGB(GetRValue(clrHighlight) / 3 + 170,
										GetGValue(clrHighlight) / 3 + 170, GetBValue(clrHighlight) / 3 + 170);
		const COLORREF	clrHighlightIconBack = RGB((GetRValue(clrHighlightBack) + 0xFF) / 2,
										(GetGValue(clrHighlightBack) + 0xFF) / 2, (GetBValue(clrHighlightBack) + 0xFF) / 2);

		// wi̕`
		if(bSelected) {
			hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
			hBrush = ::CreateSolidBrush(clrHighlightBack);
			hOldPen = dc.SelectObject(hPen);
			hOldBrush = dc.SelectObject(hBrush);
			dc.Rectangle(rcItem);
			dc.SelectObject(hOldPen);
			dc.SelectObject(hOldBrush);
			::DeleteObject(hPen);
			::DeleteObject(hBrush);
		} else {
			dc.FillSolidRect(rcItem, ::GetSysColor(COLOR_MENU));
//			dc.FillSolidRect(rcItem.left, rcItem.top,
//				rcItem.bottom - rcItem.top, rcItem.bottom - rcItem.top,
//				::GetSysColor(COLOR_3DFACE));
		}

		if(id >= CMD_FILE_MRULIST_START && id < CMD_FILE_MRULIST_END) {	// MRU Xg
			const wchar_t*	pwszNumber = _GetMenuLabel(id);
			const wchar_t*	pwszFilePath = wcsstr(pwszNumber, L"  ") + 2;
			const wchar_t*	pwszFileName = ::PathFindFileNameW(pwszFilePath);
			rcCaption = rcItem;
			rcCaption.left += 14;
			rcCaption.right -= 14;
			dc.SetBkMode(TRANSPARENT);

			// ԍ̕`
			dc.DrawText(pwszNumber, pwszFilePath - pwszNumber, rcCaption, DT_SINGLELINE | DT_VCENTER);
			dc.DrawText(pwszNumber, pwszFilePath - pwszNumber, rcCaption, DT_CALCRECT | DT_SINGLELINE | DT_VCENTER);
			::SetRect(&rcCaption, rcCaption.right, rcItem.top, rcItem.right, rcItem.bottom);

			// pX̕`
			if(pwszFilePath != pwszFileName) {
				dc.DrawText(pwszFilePath, pwszFileName - pwszFilePath, rcCaption, DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
				dc.DrawText(pwszFilePath, pwszFileName - pwszFilePath, rcCaption, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
				::SetRect(&rcCaption, rcCaption.right, rcItem.top, rcItem.right, rcItem.bottom);
			}

			// t@C̕`
			dc.DrawText(pwszFileName, -1, rcCaption, DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);
			dc.DrawText(pwszFileName, -1, rcCaption, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE | DT_VCENTER);

			// t@C̉ɉ
			HPEN	hPen = ::CreatePen(PS_SOLID, 1, dc.GetTextColor());
			HPEN	hOldPen = dc.SelectObject(hPen);
			dc.MoveTo(rcCaption.left, rcCaption.bottom - 1);
			dc.LineTo(rcCaption.right, rcCaption.bottom - 1);
			dc.SelectObject(hOldPen);
			::DeleteObject(hPen);
		} else {
			// ACR̕`
			const bool		bIsBuffers = id >= CMD_VIEW_BUFFERLIST_START && id < CMD_VIEW_BUFFERLIST_END;
			const size_t	iIcon = !bIsBuffers ? m_pCommandManager->GetIconIndex(id) : id - CMD_VIEW_BUFFERLIST_START;
			RECT			rcIcon;
			HIMAGELIST		hIcons;
			
			if(bIsBuffers)		hIcons = m_buffers.GetImageList();
			else if(bDisabled)	hIcons = m_pCommandManager->GetImageList(CCommandManager::ICONSTATE_DISABLED);
			else if(bSelected)	hIcons = m_pCommandManager->GetImageList(CCommandManager::ICONSTATE_HOT);
			else				hIcons = m_pCommandManager->GetImageList(CCommandManager::ICONSTATE_NORMAL);

			rcIcon.left = rcItem.left + (rcItem.bottom - rcItem.top - 16) / 2 - 1;
			rcIcon.top = rcItem.top + (rcItem.bottom - rcItem.top - 16) / 2 - 1;
			rcIcon.right = rcIcon.left + 18;
			rcIcon.bottom = rcIcon.top + 18;
			if((hIcons != 0 && iIcon != -1) || bIsBuffers) {	// ACRpłꍇ
				if(bChecked) {	// `FbN
					hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
					hBrush = ::CreateSolidBrush(clrHighlightIconBack);
					hOldPen = dc.SelectObject(hPen);
					hOldBrush = dc.SelectObject(hBrush);
					dc.Rectangle(rcIcon);
					dc.SelectObject(hOldPen);
					dc.SelectObject(hOldBrush);
					::DeleteObject(hPen);
					::DeleteObject(hBrush);
				}
				::InflateRect(&rcIcon, -1, -1);
				::ImageList_Draw(hIcons, iIcon, dc, rcIcon.left, rcIcon.top, ILD_NORMAL);
				::InflateRect(&rcIcon, 1, 1);
			} else if(bChecked) {
				const int	nCheckBoxWidth = rcItem.bottom - rcItem.top;
				hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
				hBrush = ::CreateSolidBrush(clrHighlightIconBack);
				hOldPen = dc.SelectObject(hPen);
				hOldBrush = dc.SelectObject(hBrush);
				dc.Rectangle(rcItem.left + 1, rcItem.top + 1, rcItem.left + rcItem.bottom - rcItem.top - 1, rcItem.bottom - 1);
				dc.SelectObject(hOldPen);
				dc.SelectObject(hOldBrush);
				::DeleteObject(hPen);
				::DeleteObject(hBrush);
				hPen = ::CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));	// v񂩂?
				hOldPen = dc.SelectObject(hPen);
				dc.MoveTo(rcItem.left + nCheckBoxWidth / 2 - 3, rcItem.top + nCheckBoxWidth / 2 - 1);	// `FbN}[N
				dc.LineTo(rcItem.left + nCheckBoxWidth / 2 - 1, rcItem.top + nCheckBoxWidth / 2 + 1);
				dc.LineTo(rcItem.left + nCheckBoxWidth / 2 + 4, rcItem.top + nCheckBoxWidth / 2 - 4);
				dc.MoveTo(rcItem.left + nCheckBoxWidth / 2 - 3, rcItem.top + nCheckBoxWidth / 2 + 0);
				dc.LineTo(rcItem.left + nCheckBoxWidth / 2 - 1, rcItem.top + nCheckBoxWidth / 2 + 2);
				dc.LineTo(rcItem.left + nCheckBoxWidth / 2 + 4, rcItem.top + nCheckBoxWidth / 2 - 3);
				dc.SelectObject(hOldPen);
				::DeleteObject(hPen);
			}

			if(id == 0	// ؂̕`
					&& (lpDrawItem->itemData == 0 || wcslen(reinterpret_cast<wchar_t*>(lpDrawItem->itemData)) == 0)) {
				HPEN	hOldPen = dc.SelectObject(::CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_3DSHADOW)));

				dc.MoveTo(lpDrawItem->rcItem.left + 1, lpDrawItem->rcItem.top + 1);
				dc.LineTo(lpDrawItem->rcItem.right - 1, lpDrawItem->rcItem.top + 1);
				::DeleteObject(dc.SelectObject(hOldPen));
				dc.SelectObject(::CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_3DHIGHLIGHT)));
				dc.MoveTo(lpDrawItem->rcItem.left + 1, lpDrawItem->rcItem.top + 2);
				dc.LineTo(lpDrawItem->rcItem.right - 1, lpDrawItem->rcItem.top + 2);
				::DeleteObject(dc.SelectObject(hOldPen));
			} else {	// LvV̕`
				dc.SetBkMode(TRANSPARENT);
				rcCaption = lpDrawItem->rcItem;
		//		if(reinterpret_cast<HMENU>(lpDrawItem->hwndItem) != m_pMenu->GetSafeHmenu()) {
					COLORREF	clrCaption = ::GetSysColor(bDisabled ? COLOR_GRAYTEXT : COLOR_MENUTEXT);
					const wchar_t*	pwszOrgCaption = (lpDrawItem->itemData == 0) ?
						_GetMenuLabel(lpDrawItem->itemID) : reinterpret_cast<const wchar_t*>(lpDrawItem->itemData);
					if(id != 0 && m_pCommandManager->GetLastCommand() == id)
						clrCaption = RGB(GetRValue(clrCaption),
							(GetGValue(clrCaption) + 0xFF) / 2, GetBValue(clrCaption));
					dc.SetTextColor(clrCaption);
					rcCaption.left = rcIcon.right + 6;
					rcCaption.right -= 6;
					pszCaption = new wchar_t[wcslen(pwszOrgCaption) + 1];
					wcscpy(pszCaption, pwszOrgCaption);
					pszAccel = wcschr(pszCaption, L'\t');
					if(pszAccel != 0) {
						*pszAccel = 0;
						dc.DrawText(pszCaption, -1, rcCaption, DT_SINGLELINE | DT_VCENTER);
						dc.DrawText(pszAccel + 1, -1, rcCaption, DT_RIGHT | DT_SINGLELINE | DT_VCENTER);
					} else
						dc.DrawText(pszCaption, -1, rcCaption, DT_SINGLELINE | DT_VCENTER);
					delete[] pszCaption;
		//		} else {	// j[o[̏ꍇ
		//			if(lpDrawItem->itemState & ODS_SELECTED || lpDrawItem->itemState & ODS_HOTLIGHT) {
		//				dc.FillSolidRect(&rectCaption, ::GetSysColor(COLOR_HIGHLIGHT));
		//				dc.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
		//			} else {
		//				dc.FillSolidRect(&rectCaption, ::GetSysColor(COLOR_BTNFACE));
		//				dc.SetTextColor(::GetSysColor(COLOR_MENUTEXT));
		//			}
		//			dc.DrawText(reinterpret_cast<const wchar_t*>(lpDrawItem->itemData),
		//				-1, &rectCaption, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
		//		}
			}
		}
	}
	dc.Detach();
}

///	@see	WM_DROPFILES
void CAlphaApp::OnDropFiles(HDROP hDrop) {
	const uint	cFiles = ::DragQueryFileW(hDrop, 0xFFFFFFFF, 0, 0);
	wchar_t		wszFilePath[MAX_PATH];

	for(uint iFile = 0; iFile < cFiles; ++iFile) {
		::DragQueryFileW(hDrop, iFile, wszFilePath, MAX_PATH);
		if(!toBoolean(::PathIsDirectoryW(wszFilePath)))
			OpenFile(wszFilePath);
	}
	::DragFinish(hDrop);

	CAlphaView&	activeView = GetActiveView();
	if(activeView.IsWindow())
		activeView.SetFocus();
}

///	@see	WM_ENTERMENULOOP
void CAlphaApp::OnEnterMenuLoop(bool bIsTrackPopup) {
	m_statusBar.SetSimple(true);
}

///	@see	WM_EXITMENULOOP
void CAlphaApp::OnExitMenuLoop(bool bIsTrackPopup) {
	m_statusBar.SetSimple(false);
}

///	@see	WM_INITMENU
void CAlphaApp::OnInitMenu(HMENU hMenu) {
	// j[ACe̗L//`FbN

	// ͑1Kŵ
	for(int j = 0; j < m_pMenu->GetItemCount(); ++j) {
		CMenu		menu = m_pMenu->GetSubMenu(j);
		const int	cItems = menu.GetItemCount();

		for(int i = 0; i < cItems; ++i) {
			if(menu.HasSubMenu(i)) {
				CMenu		subMenu = menu.GetSubMenu(i);
				const int	cItems = subMenu.GetItemCount();

				for(int i = 0; i < cItems; ++i) {
					const CommandId	id = subMenu.GetMenuItemID(i);
					subMenu.EnableMenuItem(id, m_pCommandManager->IsEnabled(id, true));
					subMenu.CheckMenuItem(id, m_pCommandManager->IsChecked(id));
				}
			} else {
				const CommandId	id = menu.GetMenuItemID(i);
				menu.EnableMenuItem(id, m_pCommandManager->IsEnabled(id, true));
				menu.CheckMenuItem(id, m_pCommandManager->IsChecked(id));
			}
		}
	}

	// [ŋߎgt@C]
	m_pMenu->GetSubMenu(0).SetChildPopup(*m_pMRUManager->GetPopupMenu(), CMD_FILE_MRU, false, true);

	// obt@o[j[
	m_pBufferBarMenu->EnableMenuItem(CMD_FILE_CLOSEOTHERS, m_buffers.GetCount() > 1);

	// t@C
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_RENAME, m_pCommandManager->IsEnabled(CMD_FILE_RENAME, true));
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_COPY, m_pCommandManager->IsEnabled(CMD_FILE_COPY, true));
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_MOVE, m_pCommandManager->IsEnabled(CMD_FILE_MOVE, true));
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_DELETE, m_pCommandManager->IsEnabled(CMD_FILE_DELETE, true));
}

///	@see	WM_INITMENUPOPUP
void CAlphaApp::OnInitMenuPopup(HMENU hMenu, UINT nIndex, bool bSysMenu) {
	// Kp^Cv
	if(m_pAppDocTypeMenu->GetSafeHmenu() == hMenu) {
		const CAlphaDoc&			activeDocument = GetActiveBuffer();
		const CDocumentTypeManager&	types = m_buffers.GetDocumentTypeManager();
		const bool					bCtrlPressed = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);

		while(m_pAppDocTypeMenu->GetItemCount() > 0)	// ׂč폜
			m_pAppDocTypeMenu->DeleteMenuItem(0, false);
		for(size_t i = 0; i < types.GetCount(); ++i) {
			const TDocumentType&	type = types.GetAt(i);
			if(type.bPrivate && !bCtrlPressed)
				continue;
			m_pAppDocTypeMenu->AppendMenuItem(
				CMD_TOOL_DOCTYPELIST_START + i, MFT_OWNERDRAW, type.strName.c_str());
		}
		m_pAppDocTypeMenu->CheckMenuItem(CMD_TOOL_DOCTYPELIST_START + types.Find(activeDocument.m_strDocType));
	}
	// [obt@] j[ CDocumentManager Ă
//	if(hMenu == m_buffers.GetBufferListMenu().GetSafeHmenu()) {
//		m_buffers.GetBufferListMenu().CheckMenuRadioItem(CMD_TOOL_DOCTYPELIST_START, CMD_TOOL_DOCTYPELIST_START + m_buffers.GetDocumentTypeManager().GetCount(), Get);
//	}
}

///	@see	IEditViewEventListener::OnMatchBracketFoundOutOfView
void CAlphaApp::OnMatchBracketFoundOutOfView(const CCharPos& pos) {
	if(pos.m_iLine == -1 && pos.m_iChar == -1)
		m_statusBar.SetText(0, IDS_DEFAULTSTATUSTEXT, SBT_NOBORDERS);
	else {
		const CAlphaDoc&			activeDocument = GetActiveBuffer();
		const CAlphaView&			activeView = GetActiveView();
		const CLexer&				lexer = activeView.GetLexer();
		const length_t				cLines = activeDocument.GetLineCount();
		const CEditView::TOptions&	options = activeView.GetOptions();
		char_t						wsz[50];

		// Ίʂ̎ӂ\ (NUL ܂ރeLXg͖Ή)
		wsz[0] = 0;
		for(length_t iLine = pos.m_iLine; iLine < cLines; ++iLine) {
			const string_t	strLine = activeDocument.GetLine(iLine);
			const length_t	cchIndent = lexer.EatWhiteSpaces(strLine.c_str(), strLine.length(), true);

			if(iLine == pos.m_iLine) {	// Ίʂ̌s
				// Ίʂ̑O
				if(pos.m_iChar - cchIndent <= 20)
					wcsncat(wsz, strLine.c_str() + cchIndent, pos.m_iChar - cchIndent + 1);
				else {
					wcscpy(wsz, L"... ");
					wcsncat(wsz, strLine.c_str() + pos.m_iChar - 16, 17);
				}
				// ʂ̌
				if(strLine.length() - pos.m_iChar - 1 <= 20)
					wcscat(wsz, strLine.c_str() + pos.m_iChar + 1);
				else {
					wcsncat(wsz, strLine.c_str() + pos.m_iChar + 1, 16);
					wcscat(wsz, L" ...");
					break;
				}
			} else {
				wcscat(wsz, L"^J");	// s
				if(cchIndent != 0)
					wcscat(wsz, L" ");
				if(wcslen(wsz) >= 37) {
					wcscat(wsz, L" ...");
					break;
				}
				if(wcslen(wsz) + strLine.length() - cchIndent >= 41) {
					wcsncat(wsz, strLine.c_str() + cchIndent, 41 - wcslen(wsz));
					wcscat(wsz, L" ...");
					break;
				} else
					wcscat(wsz, strLine.c_str() + cchIndent);
			}

			// Ίʂ̌
		}
		for(char_t* p = wsz; *p != 0; ++p) {
			if(*p == L'\t')
				*p = L' ';
		}
		const length_t	iStartLine = activeView.GetLayoutSettings().GetSettings().lineNumberLayout.iStartLine;
		const wstring	str = LoadString(MSG_MATCH_BRACKET_OUT_OF_VIEW, __MARGS__ % (pos.m_iLine + iStartLine) % wsz);
		m_statusBar.SetText(0, str.c_str(), SBT_NOBORDERS);
	}
}

///	@see	WM_MEASUREITEM
void CAlphaApp::OnMeasureItem(UINT idCtrl, LPMEASUREITEMSTRUCT lpMI) {
	NONCLIENTMETRICSW	ncm;
	RECT				rect;
	HFONT				hMenuFont, hOldFont;

	// j[
	if(lpMI->CtlType == ODT_MENU) {
		if(lpMI->itemID == 0	// ؂
				&& (lpMI->itemData == 0 || wcslen(reinterpret_cast<wchar_t*>(lpMI->itemData)) == 0)) {
			lpMI->itemHeight = 4;
			lpMI->itemWidth = 30;	// ̒l͑gȂ
		} else {
			// j[̃tHg擾
			ncm.cbSize = sizeof(NONCLIENTMETRICSW);
			::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, &ncm, 0);
			if(lpMI->itemID == CMD_FILE_CLOSE)	// 
				ncm.lfMenuFont.lfWeight = FW_BOLD;
			hMenuFont = ::CreateFontIndirectW(&ncm.lfMenuFont);

			CClientDC	dc = GetMainWindow().GetDC();
			hOldFont = static_cast<HFONT>(dc.SelectObject(hMenuFont));
			dc.DrawTextW(lpMI->itemData == 0 ?
				_GetMenuLabel(lpMI->itemID) : reinterpret_cast<wchar_t*>(lpMI->itemData),
				-1, rect, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE);
			dc.SelectObject(hOldFont);
			::DeleteObject(hMenuFont);

			if(lpMI->itemID == 0)	// |bvAbv̏ꍇA̕𑫂
				rect.right += 24;
			if(lpMI->itemID > COMMAND_END) {
				lpMI->itemHeight = rect.bottom - rect.top + 4;
				lpMI->itemWidth = rect.right - rect.left + 28;
			} else {
				lpMI->itemHeight = (rect.bottom - rect.top < 20) ? 20 : rect.bottom - rect.top;
				lpMI->itemWidth = rect.right - rect.left + ((lpMI->itemID >= COMMAND_START) ? 24 : 0);
			}
		}
	}
}

///	@see	WM_MENUCHAR
LRESULT CAlphaApp::OnMenuChar(wchar_t ch, UINT nFlags, CMenu* pMenu) {
	const UINT					cItems = pMenu->GetItemCount();
	AutoZeroCB<MENUITEMINFOW>	mii;

	mii.fMask = MIIM_FTYPE | MIIM_ID;

	if(ch >= L'a' && ch <= L'z')	// 啶ɂ
		ch -= 0x20;
	for(UINT iItem = 0; iItem < cItems; ++iItem) {
		pMenu->GetMenuItemInfo(iItem, mii, false);
		if(mii.wID != 0 && !toBoolean(mii.fType & MFT_SEPARATOR)) {
			const wchar_t*	pwszAccel = wcschr(_GetMenuLabel(mii.wID), L'&');
			if(pwszAccel != 0) {
				if(pwszAccel[1] == ch)
					return (iItem | 0x00020000);
			}
		}
	}
	return MNC_IGNORE;
}

///	@see	WM_MENUSELECT
void CAlphaApp::OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu) {
	// IڂɑΉXe[^Xo[ɕ\
	if(nItemID >= CMD_EDIT_PLUGINLIST_START && nItemID < CMD_EDIT_PLUGINLIST_END) {	// }N
		m_statusBar.SetText(m_statusBar.IsSimple() ? SB_SIMPLEID : 0,
			(m_pScriptMacroManager->GetCount() != 0) ?
			m_pScriptMacroManager->GetDescription(nItemID - CMD_EDIT_PLUGINLIST_START).c_str() : L"", SBT_NOBORDERS);
	} else if(nItemID >= CMD_VIEW_BUFFERLIST_START && nItemID < CMD_VIEW_BUFFERLIST_END)	// obt@
		m_statusBar.SetText(m_statusBar.IsSimple() ? SB_SIMPLEID : 0,
			m_buffers.GetAt(nItemID - CMD_VIEW_BUFFERLIST_START).GetPathName(), SBT_NOBORDERS);
	else {
		wchar_t	wszPrompt[200] = L"";
		if(!toBoolean(nFlags & MF_POPUP) && !toBoolean(nFlags & MFT_SEPARATOR))
			LoadString(nItemID, wszPrompt, 200);
		m_statusBar.SetText(m_statusBar.IsSimple() ? SB_SIMPLEID : 0,
			(*wszPrompt != 0) ? wcschr(wszPrompt, L'\n') + 1 : L"", SBT_NOBORDERS);
	}
}

///	@see	WM_MOUSEMOVE
void CAlphaApp::OnMouseMove(UINT nFlags, POINT pt) {
	if(m_bSizingOutputWnd) {	// o̓EBhE̍ύX
	} 
}

///	@see	IEditViewEventListener::OnMoveCaret
void CAlphaApp::OnMoveCaret(const CCharPos& pos) {
	_UpdateStatusBar(SBP_POSITION);
}

///	@see	IEditViewEventListener::OnMoveCursor
void CAlphaApp::OnMoveCursor(const POINT& pt) {
	GetMainWindow().SetTimer(ID_TIMER_MOUSEMOVE, 1200, 0);
}

///	@see	CWindow::OnNotify
bool CAlphaApp::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	switch(lpNMHDR->code) {
	case NM_RCLICK:	// obt@o[̉ENbN
		if(idCtrl == IDC_BUFFERBAR) {
			const NMMOUSE*	pMouse = reinterpret_cast<NMMOUSE*>(lpNMHDR);
			if(pMouse->dwItemSpec != -1) {
				POINT	pt = pMouse->pt;

				m_bufferBar.ClientToScreen(pt);
				SetActiveBuffer(m_buffers.GetAt(pMouse->dwItemSpec - CMD_VIEW_BUFFERLIST_START));
				m_pBufferBarMenu->TrackPopupMenu(
					TPM_LEFTALIGN | TPM_TOPALIGN | TPM_LEFTBUTTON, pt.x, pt.y, GetMainWindow());
				return true;
			}
		}
		break;
	case RBN_HEIGHTCHANGE:	// o[̍ς
		OnSize(0, -1, -1);
		return true;
	case RBN_CHEVRONPUSHED:	// c[o[̃VFuꂽ
		OnRebarChevronPushed(reinterpret_cast<LPNMREBARCHEVRON>(lpNMHDR));
		return true;
	case TBN_DROPDOWN: {	// c[o[̃hbv_E
		RECT		rect;
		POINT		pt;
		const bool	bCtrlPressed = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);

		m_toolbar.GetRect(reinterpret_cast<LPNMTOOLBAR>(lpNMHDR)->iItem, rect);
		pt.x = rect.left;
		pt.y = rect.bottom;
		GetMainWindow().ClientToScreen(pt);
		switch(reinterpret_cast<LPNMTOOLBAR>(lpNMHDR)->iItem) {
		case CMD_FILE_NEW:
			while(m_pNewDocTypeMenu->GetItemCount() > 0)	// ׂč폜
				m_pNewDocTypeMenu->DeleteMenuItem(0, false);
			for(size_t i = 0; i < m_buffers.GetDocumentTypeManager().GetCount(); ++i) {
				const TDocumentType&	type = m_buffers.GetDocumentTypeManager().GetAt(i);
				if(type.bPrivate && !bCtrlPressed)
					continue;
				m_pNewDocTypeMenu->AppendMenuItem(
					CMD_FILE_DOCTYPELIST_START + i, MFT_OWNERDRAW, type.strName.c_str());
			}
			m_pNewDocTypeMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, GetMainWindow());
			return true;
		case CMD_FILE_OPEN:
			m_pMRUManager->GetPopupMenu()->TrackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, GetMainWindow());
			return true;
		}
		break;
	}
	case TBN_GETOBJECT:
		OnCommand(reinterpret_cast<LPNMOBJECTNOTIFY>(lpNMHDR)->iItem, 0, 0);
		return 0;
	case TTN_GETDISPINFOW: {	// c[o[̃c[`bv
		static wchar_t	wszTipText[500];
		LPNMTTDISPINFOW	lpNMTTDI = reinterpret_cast<LPNMTTDISPINFOW>(lpNMHDR);

		lpNMTTDI->hinst = m_hInstance;
		if(lpNMTTDI->hdr.idFrom >= CMD_VIEW_BUFFERLIST_START && lpNMTTDI->hdr.idFrom < CMD_VIEW_BUFFERLIST_END) {
			CAlphaDoc&	buffer = m_buffers.GetAt(lpNMTTDI->hdr.idFrom - CMD_VIEW_BUFFERLIST_START);
			wcscpy(wszTipText, (buffer.GetPathName() != 0) ? buffer.GetPathName() : buffer.GetFileName());
		} else {
			LoadString(lpNMTTDI->hdr.idFrom, wszTipText, 500);

			wchar_t*	pwsz = wcschr(wszTipText, L'(');
			if(pwsz != 0)
				pwsz[0] = 0;

			const wstring strKey = m_keyboardMap.GetKeyString(lpNMTTDI->hdr.idFrom, false);
			if(!strKey.empty()) {
				wcscat(wszTipText, L" (");
				wcscat(wszTipText, strKey.c_str());
				wcscat(wszTipText, L")");
			}
		}
		lpNMTTDI->lpszText = wszTipText;
		return true;
	}
//	case TBN_HOTITEMCHANGE:
//		lpNMTHI = reinterpret_cast<LPNMTBHOTITEM>(lpNMHDR);
//		if(0 != LoadString(lpNMTHI->idNew, wszCommandCaption, 200)) {
//			psz = wcschr(wszCommandCaption, L'\n');
//			if(psz != 0)
//				::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS | SBT_OWNERDRAW, reinterpret_cast<LPARAM>(psz + 1));
//		} else
//			::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS | SBT_OWNERDRAW, reinterpret_cast<LPARAM>(L""));
//		break;
	}
	return false;
}

///	RBN_CHEVRONPUSHED ̏
void CAlphaApp::OnRebarChevronPushed(LPNMREBARCHEVRON lpNMRebarChevron) {
	assert(lpNMRebarChevron != 0);

	AutoZeroCB<REBARBANDINFOW>	rbi;
	RECT						rectBand;

	// c[o[𓾂 (obt@o[łʂ̃R[hg)
	m_rebar.GetRect(lpNMRebarChevron->uBand, rectBand);
	rbi.fMask = RBBIM_CHILD | RBBIM_IDEALSIZE;
	m_rebar.GetBandInfo(lpNMRebarChevron->uBand, rbi);
	const long	cButtons = ::SendMessage(rbi.hwndChild, TB_BUTTONCOUNT, 0, 0L);

	// \̃{^܂Ői
	long	iButton;
	RECT	rectButton;
	for(iButton = 0; iButton < cButtons; ++iButton) {
		::SendMessage(rbi.hwndChild, TB_GETITEMRECT, iButton, reinterpret_cast<LPARAM>(&rectButton));
		if(rectButton.right + rectBand.left > lpNMRebarChevron->rc.left)
			break;
	}

	// \̃{^j[ڂɕϊ
	HMENU	hPopupMenu = ::CreatePopupMenu();
	POINT	pt = {lpNMRebarChevron->rc.left, lpNMRebarChevron->rc.bottom};
	AutoZeroCB<TBBUTTONINFOW>	tbbi;
	AutoZeroCB<MENUITEMINFOW>	item;

    tbbi.dwMask = TBIF_BYINDEX | TBIF_COMMAND | TBIF_STYLE;
	item.fMask = MIIM_DATA | MIIM_FTYPE | MIIM_ID | MIIM_STATE;
	for(; iButton < cButtons; ++iButton) {
		::SendMessage(rbi.hwndChild, TB_GETBUTTONINFOW, iButton, reinterpret_cast<LPARAM>(&tbbi));
		if(toBoolean(tbbi.fsStyle & TBSTYLE_SEP))
			::AppendMenu(hPopupMenu, MFT_OWNERDRAW | MFT_SEPARATOR, 0, 0);
		else {
			item.fType = MFT_OWNERDRAW;
			item.fState = m_pCommandManager->IsEnabled(tbbi.idCommand, true) ? MFS_ENABLED : MFS_DISABLED;
			item.fState |= (m_pCommandManager->IsChecked(tbbi.idCommand)) ? MFS_CHECKED : 0;
			item.wID = tbbi.idCommand;
			item.dwItemData = 0/*reinterpret_cast<DWORD>(GetMenuLabel(tbbi.idCommand))*/;
			::InsertMenuItemW(hPopupMenu, ::GetMenuItemCount(hPopupMenu), true, &item);
		}
	}
	m_rebar.ClientToScreen(pt);
	::TrackPopupMenu(hPopupMenu, TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, 0, GetMainWindow().GetSafeHwnd(), 0);
	::DestroyMenu(hPopupMenu);
}

///	@see	CWindow::OnSetCursor
bool CAlphaApp::OnSetCursor(HWND hWnd, UINT nHitTest, UINT message) {
	POINT	pt;		// J[\ʒu
	RECT	rectClient, rectStatusBar;

	GetMainWindow().GetClientRect(rectClient);
	if(m_statusBar.IsWindowVisible())	m_statusBar.GetWindowRect(rectStatusBar);
	else								::SetRect(&rectStatusBar, 0, 0, 0, 0);
	::GetCursorPos(&pt);
	GetMainWindow().ScreenToClient(pt);

	if(pt.y >= rectClient.bottom - m_nOutputWndHeight - (rectStatusBar.bottom - rectStatusBar.top) - 3
			&& pt.y <= rectClient.bottom - m_nOutputWndHeight - (rectStatusBar.bottom - rectStatusBar.top)) {
		::SetCursor(::LoadCursor(0, IDC_SIZENS));
		return true;
	}

	return false;
}

/// @see	WM_SETTINGCHNAGE
void CAlphaApp::OnSettingChange(UINT nFlags, const wchar_t* pwszSection) {
	AutoZeroCB<NONCLIENTMETRICSW>	ncm;

	::DeleteObject(m_hStatusFont);
	::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, sizeof(NONCLIENTMETRICSW), &ncm, 0);
	m_hStatusFont = ::CreateFontIndirectW(&ncm.lfStatusFont);
	_UpdateStatusBar(SBP_ALL);
}

/**
 *	@see			CWindow::OnSize
 *	@param nType	CWindow::OnSize Q
 *	@param cx, cy	-1ɂƂ̃\bh݂͌̃EBhETCYgB
 *					̃\bhs̏PɎgpꍇɂĂяoƂł
 */
void CAlphaApp::OnSize(UINT nType, int cx, int cy) {
	RECT	rectRebar, rectStatusBar, rectEditor;

	if(cx == -1 && cy == -1) {
		RECT	rect;
		GetMainWindow().GetClientRect(rect);
		cx = rect.right - rect.left;
		cy = rect.bottom - rect.top;
	}

	if(m_statusBar.IsWindowVisible()) {
		m_statusBar.SendMessage(WM_SIZE, cx, cy);
		m_statusBar.GetWindowRect(rectStatusBar);
		_UpdateStatusBar(SBP_ALL);
	} else
		::SetRect(&rectStatusBar, 0, 0, 0, 0);

	if(m_rebar.IsWindowVisible()) {
		m_rebar.SendMessage(WM_SIZE, cx, cy);
		m_rebar.GetWindowRect(rectRebar);
		m_toolbar.SendMessage(WM_SIZE, cx, rectRebar.bottom - rectRebar.top - 2);
	} else
		::SetRect(&rectRebar, 0, 0, 0, 0);

	rectEditor.left =  0;
	rectEditor.top = rectRebar.bottom - rectRebar.top;
	rectEditor.right = cx;
	rectEditor.bottom = cy
		- (m_statusBar.IsWindowVisible() ? rectStatusBar.bottom - rectStatusBar.top : 0);
//	if(m_wndOutput.IsWindow() && m_wndOutput.IsWindowVisible())
//		rectEditor.bottom -= m_nOutputWndHeight;
	if(m_editorWindow.IsWindow())
		m_editorWindow.MoveWindow(rectEditor, true);

//	if(m_wndOutput.IsWindow()) {
//		m_wndOutput.MoveWindow(0, rectEditor.bottom + 2, cx, m_nOutputWndHeight);
//		m_wndOutput.ShowWindow(SW_SHOW);
//	}
}

///	@see	WM_TIMER
void CAlphaApp::OnTimer(UINT nIDTimer) {
	if(nIDTimer == ID_TIMER_QUERYCOMMAND && m_buffers.GetCount() != 0) {
		// c[o[ACe̗L/ƃobt@o[̗z̍ČvZ
		const size_t	cButtons = m_toolbar.GetButtonCount();
		TBBUTTON		button;

		for(size_t iButton = 0; iButton < cButtons; ++iButton) {
			m_toolbar.GetButton(iButton, button);
			m_toolbar.CheckButton(button.idCommand, m_pCommandManager->IsChecked(button.idCommand));
			m_toolbar.EnableButton(button.idCommand, m_pCommandManager->IsEnabled(button.idCommand, true));
		}

		AutoZero<REBARBANDINFOW>	rbbi;
		RECT						rect;
		rbbi.fMask = RBBIM_IDEALSIZE;
		m_bufferBar.GetItemRect(m_bufferBar.GetButtonCount() - 1, rect);
		rbbi.cxIdeal = rect.right;
		m_rebar.SetBandInfo(m_rebar.IdToIndex(IDC_BUFFERBAR), rbbi);
	} else if(nIDTimer == ID_TIMER_MOUSEMOVE) {	// qg\
/*		if(GetActiveTab()->GetTextEditor() != 0
				&& m_pActiveDebugger != 0
				&& m_pActiveDebugger->IsDebugging()) {
			CAlphaView*			pActiveView = GetActiveTab()->GetTextEditor()->GetActiveView();
			DebugPropertyInfo	dpi;
			POINT				pt, ptView;
			wstring				strExpression;
			wostringstream		ssResult;

			::GetCursorPos(&pt);
			ptView = pt;
			pActiveView->ScreenToClient(&ptView);
			strExpression = (pActiveView->HasSelection() && pActiveView->IsOverSelection(ptView)) ?
				pActiveView->GetSelection() : pActiveView->GetNearestWordFromCursor();
			dpi.m_dwValidFields = DBGPROP_INFO_NAME | DBGPROP_INFO_TYPE | DBGPROP_INFO_VALUE;
			if(!strExpression.empty()
						&& SUCCEEDED(m_pActiveDebugger->EvaluateExpression(strExpression, 10, true, &dpi))) {
				if(dpi.m_bstrType != 0
						&& wcscmp(dpi.m_bstrType, L"Error") != 0	// VC6
						&& wcscmp(dpi.m_bstrType, L"G[") != 0)	// VC7
					ssResult << dpi.m_bstrName << L" = " << dpi.m_bstrValue;
				if(dpi.m_dwValidFields & DBGPROP_INFO_NAME)		::SysFreeString(dpi.m_bstrName);
				if(dpi.m_dwValidFields & DBGPROP_INFO_TYPE)		::SysFreeString(dpi.m_bstrType);
				if(dpi.m_dwValidFields & DBGPROP_INFO_VALUE)	::SysFreeString(dpi.m_bstrValue);
			}
		}
*/		GetMainWindow().KillTimer(ID_TIMER_MOUSEMOVE);
	}
}

/* [EOF] */