/**
 *	@file	events.js
 *
 *	Alpha から呼び出されるイベントハンドラの定義が含まれています。
 *	Alpha の設定を変更するにはイベントハンドラを書き換えます。
 *
 *	@author	exeal
 *	@date	2005.02.05
 */


// 現在、文書タイプの定義を幾つか用意していますが、これらの定義は正しくないかもしれません。
// 何か文書タイプを作ったら連絡してね。

Array.prototype.forEach = function(pred) {
	for(var i = 0; i < this.length; ++i)
		pred(this[i]);
};

Function.prototype.bind1st = function(x) {
	var self = this;
	return function(y) {
		return self(x, y);
	};
};

Function.prototype.bind2nd = function(y) {
	var self = this;
	return function(x) {
		return self(x, y);
	};
};


/**
 *	Alpha 起動時に呼び出される
 *	@param args : Arguments	コマンドライン
 */
function OnApplicationInitialized(args) {
	// 文書タイプの登録
	var conf = Ambient.Configurations;
	conf.AddDocumentType("ReadMe", "readme.txt", "", true);	// お遊び (^^;
	conf.AddDocumentType("マクロスクリプト構成", "macros.xml", "", true);
	conf.AddDocumentType("テキスト", "*.txt;*.wtx");
	conf.AddDocumentType("JavaScript", "*.js", "WScript $F");
	conf.AddDocumentType("VBScript", "*.vbs", "WScript $F");
	conf.AddDocumentType("Perl", "*.pl;*.pm;*.cgi;*.pls", "perl $F");
	conf.AddDocumentType("Ruby", "*.rb", "ruby $F");
	conf.AddDocumentType("Python", "*.py;*.pys", "python $F");
	conf.AddDocumentType("Haskell", "*.has;*.hash;*.hs;*.hls", "C:\\hugs98\\hugs.exe $F");
	conf.AddDocumentType("Windows Script Host", "*.wsf;*.wsh", "WScript $F");
	conf.AddDocumentType("Windows Script Component", "*.wsc", "WScript $F");
	conf.AddDocumentType("XHTML", "*.htm;*.html", "\"C:\\Program Files\\Internet Explorer\\iexplore.exe\" $F");
	conf.AddDocumentType("RSS", "*.rdf", "\"C:\\Program Files\\Internet Explorer\\iexplore.exe\" $F");
	conf.AddDocumentType("XML", "*.xml", "\"C:\\Program Files\\Internet Explorer\\iexplore.exe\" $F");

	// キー割り当て
	var keys = conf.KeyboardSchemes("basic");
/*	keys.Assign("Ctrl+N", 1000);
	keys.Assign("Ctrl+O", 1002);
	keys.Assign("Ctrl+F4", 1003);
	keys.Assign("Ctrl+S", 1005);
	keys.Assign("Ctrl+Shift+S", 1006);
	keys.Assign("Alt+F4", 1010);
	keys.Assign("Del", 2000);
	keys.Assign("Ctrl+Shift+L", 2004);
	keys.Assign("Ctrl+Z", 2007);
	keys.Assign("Alt+Bs", 2007);
	keys.Assign("Ctrl+Y", 2008);
	keys.Assign("Ctrl+Shift+Z", 2008);
	keys.Assign("Shift+Alt+Bs", 2008);
	keys.Assign("Ctrl+X", 2009);
	keys.Assign("Shift+Del", 2009);
	keys.Assign("Ctrl+C", 2010);
	keys.Assign("Ctrl+Ins", 2010);
	keys.Assign("Ctrl+V", 2011);
	keys.Assign("Shift+Ins", 2011);
	keys.Assign("Shift+Alt+X", 2016);
	keys.Assign("Alt+X", 2017);
	keys.Assign("Ctrl+Shift+@", 2018);
	keys.Assign("Ctrl+Shift+7", 2019);
	keys.Assign("Ctrl+^", 2020);
	keys.Assign("Ctrl+Shift+^", 2021);
	keys.Assign("Ctrl+:", 2022);
	keys.Assign("Ctrl+,", 2023);
	keys.Assign("Ctrl+Sp", 2026);
	keys.Assign("Alt+Right", 2026);
	keys.Assign("Ctrl+A", 2055);
	keys.Assign("Ctrl+W", 2056);
	keys.Assign("Ctrl+Shift+-", 2068);
	keys.Assign("Ctrl+-", 2069);
	keys.Assign("Shift+Alt+Right", 2070);
	keys.Assign("Shift+Alt+Left", 2071);
	keys.Assign("Shift+Alt+Down", 2072);
	keys.Assign("Shift+Alt+Up", 2073);
	keys.Assign("Shift+Alt+End", 2074);
	keys.Assign("Shift+Alt+Home", 2075);
	keys.Assign("Ctrl+Shift+Alt+Right", 2076);
	keys.Assign("Ctrl+Shift+Alt+Left", 2077);
	keys.Assign("Ctrl+Shift+V", 2080);
	keys.Assign("Ctrl+Shift+Ins", 2080);
	keys.Assign("Ctrl+U", 2081);
	keys.Assign("Ctrl+Shift+U", 2082);
	keys.Assign("Shift+Alt+T", 2083);
	keys.Assign("Ctrl+T", 2084);
	keys.Assign("Ctrl+Shift+T", 2085);
	keys.Assign("Alt+-", 2087);
	keys.Assign("Alt+U", 2088);
	keys.Assign("Alt+^", 2089);
	keys.Assign("Ctrl+F", 3000);
	keys.Assign("F3", 3001);
	keys.Assign("Shift+F3", 3002);
	keys.Assign("Ctrl+H", 3003);
	keys.Assign("Ctrl+G", 3008);
	keys.Assign("Ctrl+F2", 3009);
	keys.Assign("F2", 3010);
	keys.Assign("Shift+F2", 3011);
	keys.Assign("Ctrl+Shift+F2", 3012);
	keys.Assign("Alt+F2", 3013);
	keys.Assign("Ctrl+[", 3014);
	keys.Assign("Ctrl+]", 3014);
	keys.Assign("Ctrl+Shift+[", 3015);
	keys.Assign("Ctrl+Shift+]", 3015);
	keys.Assign("Ctrl+I", 3016);
	keys.Assign("Ctrl+Shift+I", 3017);
	keys.Assign("Ctrl+Alt+I", 3018);
	keys.Assign("Ctrl+Shift+Alt+I", 3019);
	keys.Assign("Ctrl+M F", 3020);
	keys.Assign("Ctrl+M R", 3021);
	keys.Assign("Alt+F5", 4005);
	keys.Assign("Ctrl+Tab", 4007);
	keys.Assign("Ctrl+Shift+Tab", 4008);
	keys.Assign("Ctrl+Shift+R", 5000);
	keys.Assign("Ctrl+Shift+P", 5001);
	keys.Assign("F5", 6003);
	keys.Assign("Shift+F5", 6004);
	keys.Assign("Ctrl+Alt+U", 11300);
	keys.Assign("Ctrl+Shift+Alt+U", 11301);
	keys.Assign("F8", 11303);
	keys.Save("default");*/
	keys.Load("default");
//	setAinuInput(keys);	// アイヌ文字の割り当て
	conf.Apply();

	// 検索条件の読み込み
/*	var fso = new ActiveXObject("Scripting.FileSystemObject");
	var searcher = Ambient.ActiveDocument.TextProcessor.TextSearcher;
	try {
		var file = fso.OpenTextFile("searchOptions", 1);
		var s = file.Read(1);
		searcher.UseRegularExpression = s == "1";
		file.close();
	} catch(e) {
	}
*/
	// ウィンドウの初期状態。
	// 起動時のウィンドウの位置やサイズを変える場合は
	// コメントを外し、値を指定してください
//	Ambient.Left = 0;
//	Ambient.Top = 0;

	loadAbbreviations();	// 短縮形の読み込み
}

/// アプリケーション終了時に呼び出される
function OnApplicationTerminating() {
	// ここでウィンドウのサイズや開いているファイルの一覧を
	// テキストファイルに保存するなどすれば
	// 次回起動時に復元できる

	saveAbbreviations();	// 短縮形の保存

	// 検索条件の保存
/*	var fso = new ActiveXObject("Scripting.FileSystemObject");
	var searcher = Ambient.ActiveDocument.TextProcessor.TextSearcher;
	try {
		var file = fso.CreateTextFile("searchOptions", true);
		file.Write(searcher.UseRegularExpression ? "1" : "0");
		file.close();
	} catch(e) {
	}*/
}

/**
 *	文書タイプ適用時に呼び出される
 *	@param typeName : string		タイプ名
 *	@param editor : TextProcessor	適用先テキストエディタ
 */
function OnApplyDocumentType(typeName, editor) {
	var lexer = editor.Lexer;
	var pref = editor.Preferences;
	var cookies = new Object;

	pref.Reset();
//	pref.ShowHandOnLink = true;	// リンクテキスト上でハンドカーソルを表示

	// NOTE:
	// cookies は注釈 (コメント) とキーワードに名前を付けるのに使ってます。
	// Lexer::AddXXXX の戻り値のコレクションで、
	// 例えば定数を表すキーワードの場合は cookies.constant で
	// クッキー値にアクセスできます。
	// (この管理方法は一例であり、別の書き方をしても構いません)

	pref.TokenDecoration("link").BorderStyle = BorderType.UnderlineSolid;
	pref.TokenDecoration("link").BorderColor = 0x3333FF;

	// default
	if(typeName == "default") {
	}

	// ReadMe
	else if(typeName == "ReadMe") {
		lexer.TokenEnabled("otherQuotation") = false;
		pref.TokenDecoration("normal").Color = 0x666666;
		cookies.bracket = lexer.AddSinglelineAnnotation("[", "]", AnnotationRestriction.OnlyHeadOfLine);
		pref.TokenDecoration("annotation_".concat(cookies.bracket)).Color = 0xFFFFFF;
		pref.TokenDecoration("annotation_".concat(cookies.bracket)).BackgroundColor = 0x666666;
		pref.TokenDecoration("annotation_".concat(cookies.bracket)).BoldFont = true;
		cookies.productName = lexer.AddKeywords("Alpha");
		pref.TokenDecoration("keyword_".concat(cookies.productName)).BorderStyle = BorderType.UnderlineWaved;
		pref.TokenDecoration("doubleQuotation").BackgroundColor = 0xEEEEEE;
		pref.TokenDecoration("link").BorderStyle = BorderType.UnderlineDotted;
		pref.TokenDecoration("link").BorderColor = 0x666666;
	}

	// マクロスクリプト構成
	else if(typeName == "マクロスクリプト構成") {
		applyXML(editor, cookies);
		cookies.xmlElement = lexer.AddKeywords("description macro macros script");
		cookies.xmlAttribute = lexer.AddKeywords("language name src");
	}

	// テキスト
	else if(typeName == "テキスト") {
		pref.TabWidth = 8;
		cookies.quotation = lexer.AddSinglelineAnnotation(">", "", AnnotationRestriction.OnlyHeadOfLine);
		pref.TokenDecoration("annotation_".concat(cookies.quotation)).Color = 0x990000;
		cookies.additional = lexer.AddSinglelineAnnotation("#", "", AnnotationRestriction.OnlyHeadOfLine);
		pref.TokenDecoration("annotation_".concat(cookies.additional)).Color = 0x3366FF;
	}

	// JavaScript 1.5
	else if(typeName == "JavaScript") {
		cookies.singlelineDocumentationComment = lexer.AddSinglelineAnnotation("///");
		cookies.multilineDocumentationComment = lexer.AddMultilineAnnotation("/**", "*/");
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("//");
		cookies.multilineComment = lexer.AddMultilineAnnotation("/*", "*/");
		cookies.entity = lexer.AddKeywords("function var");
		cookies.control = lexer.AddKeywords("break case continue default do else for if return switch while with");
		cookies.operator = lexer.AddKeywords("delete in instanceof new typeof void");
		cookies.exception = lexer.AddKeywords("catch throw try");
		cookies.constant = lexer.AddKeywords("false Infinity null this true undefined");
		cookies.futureReserved = lexer.AddKeywords("abstract boolean byte char class double enum extends final float goto implements int interface long native package private protected public short static super synchronized throws transient volatile");
		cookies.msExtended = lexer.AddKeywords("@cc_on @if @set debugger");
		cookies.nsExtended = lexer.AddKeywords("const export get import set");
		lexer.SetOperators("++ -- + - ~ ! * / % << >> >>> < > <= >= == != === !== & ^ | && || ? : = *= /= %= += -= <<= >>= >>>= &= ^= |= , ( ) . [ ]");
		lexer.SetAdditionalAlphabets("@_$");
		lexer.SetBrackets("([{");
	}

	// VBScript 5.6
	else if(typeName == "VBScript") {
		lexer.CaseSensitive = false;
		cookies.singlelineDocumentationComment = lexer.AddSinglelineAnnotation("\'\'\'");
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("\'");
		cookies.vbscriptPragma = lexer.AddSinglelineAnnotation("Option ", "", AnnotationRestriction.OnlyStartOfLine);
//		lexer.AddSinglelineAnnotation("Rem", "", 1);
		cookies.entity = lexer.AddKeywords("Class Const Dim Function Get Private Property Public ReDim Set Sub");
		cookies.attribute = lexer.AddKeywords("ByRef ByVal");
		cookies.control = lexer.AddKeywords("Case Default Do Each Else ElseIf End Error Exit For GoTo If In Loop Next On Resume Select Step To Then Wend While");
		cookies.operator = lexer.AddKeywords("And Eqv Imp Is Mod New Not Or Xor");
		cookies.command = lexer.AddKeywords("Call Execute ExecuteGlobal Let Raise Randomize Stop");
		cookies.constant = lexer.AddKeywords("Empty False Me Null Nothing True");
		lexer.SetOperators("+ - ^ * / \\ & = < <= > >= <> . ( )");
		lexer.SetAdditionalAlphabets("_");
		lexer.SetBrackets("(");
		lexer.TokenEnabled("singleQuotation") = false;
	}

	// Perl
	else if(typeName == "Perl") {
		cookies.perlRubyCommandLine = lexer.AddSinglelineAnnotation("#!", AnnotationRestriction.OnlyStartOfLine);
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("# ");
		cookies.multilineComment = lexer.AddMultilineAnnotation("=", "=cut", AnnotationRestriction.OnlyStartOfLine);
		cookies.entity = lexer.AddKeywords("local my package sub");
		cookies.control = lexer.AddKeywords("continue elsif else for foreach goto if last next redo return unless until while");
		cookies.operator = lexer.AddKeywords("and cmp eq ge gt le lt ne not or x xor");
		cookies.command = lexer.AddKeywords("format no require use");
		lexer.SetOperators("-> ++ -- ** ! ~ \\ + - =~ !~ * / % . << >> < > <= >= == != <=> & | ^ && || .. ... ? : = += -= *= /= %= |= &= ^= <<= >>= **= ||= &&= .= x= , => ( ) [ ]");
		lexer.SetAdditionalAlphabets("_$@%");
		lexer.SetBrackets("([{");
	}

	// Ruby
	else if(typeName == "Ruby") {
		cookies.perlRubyCommandLine = lexer.AddSinglelineAnnotation("#!", AnnotationRestriction.OnlyStartOfLine);
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("# ");
		cookies.multilineComment = lexer.AddMultilineAnnotation("=begin", "=end", AnnotationRestriction.OnlyStartOfLine);
		cookies.entity = lexer.AddKeywords("alias class def defined? module undef");
		cookies.control = lexer.AddKeywords("BEGIN begin break case do else elsif END end for if in next redo retry return then unless until when while");
		cookies.operator = lexer.AddKeywords("and not or");
		cookies.command = lexer.AddKeywords("super yield");
		cookies.exception = lexer.AddKeywords("ensure raise rescue");
		cookies.constant = lexer.AddKeywords("__FILE__ __LINE__ false nil self true");
		lexer.SetOperators(":: . ** - + ! ~ * / % << >> & | ^ > >= < <= <=> == === != =~ !~ && || .. ... ? : = += -= *= /= %= |= &= ^= <<= >>= **= ||= &&= => ( ) [ ]");
		lexer.SetAdditionalAlphabets("@_!?$");
		lexer.SetBrackets("([");
	}

	// Python
	else if(typeName == "Python") {
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("#");
		cookies.multilineComment = lexer.AddMultilineAnnotation("\"\"\"", "\"\"\"");
		cookies.multilineComment2 = lexer.AddMultilineAnnotation("\'\'\'", "\'\'\'");
		cookies.entity = lexer.AddKeywords("class def global lambda");
		cookies.control = lexer.AddKeywords("break continue elif else for if return while");
		cookies.operator = lexer.AddKeywords("and in is not or");
		cookies.command = lexer.AddKeywords("assert del exec from future import pass print yield");
		cookies.exception = lexer.AddKeywords("except finally raise try");
		cookies.constant = lexer.AddKeywords("Ellipse False None NotImplemented True");
		lexer.SetOperators("+ - * ** / // % << >> & | ^ ~ < > <= >= == != <> ( ) [ ] , : . ` = ; += -= *= /= //= %= &= |= ^= >>= <<= **=");
		lexer.SetAdditionalAlphabets("_");
		lexer.SetBrackets("([{");
	}

	// Haskell
	else if(typeName == "Haskell") {
		cookies.singlelineComment = lexer.AddSinglelineAnnotation("--");
	}

	// Windows Script Host
	else if(typeName == "Windows Script Host") {
		applyXML(editor, cookies);
		cookies.wshJobDecl = lexer.AddSinglelineAnnotation("<?job", "?>");
		cookies.xmlElement = lexer.AddKeywords("description example job named object package reference resource runtime script unnamed usage");
		cookies.xmlAttribute = lexer.AddKeywords("classid debug error guid helpstring id language many name object progid required src type version");
	}

	// Windows Script Component
	else if(typeName == "Windows Script Component") {
		applyXML(editor, cookies);
		cookies.wshJobDecl = lexer.AddSinglelineAnnotation("<?component", "?>");
		cookies.xmlElement = lexer.AddKeywords("comment component event get implements method object package parameter property public put reference registration resource script");
		cookies.xmlAttribute = lexer.AddKeywords("classid debug default description dispid error events guid id internalName language name object progid remotable type version");
	}

	// XHTML 1.0 Strict (0)
	// XHTML 1.0 Transitional (1)
	// XHTML 1.0 Frameset (2)
	// XHTML 1.1 + Ruby (3; default)
	// XHTML Basic (4)
	else if(typeName == "XHTML") {
		var version = 3;
		var document = editor.Document;
		var cLines = Math.min(document.LineCount, 3);
		var iLine = 0;
		var iDoctypeLine = -1;

		if(document.Line(iLine).match(/<!DOCTYPE\s+/)
				|| ((cLines > 1) && document.Line(++iLine).match(/<!DOCTYPE\s+/)))
			iDoctypeLine = iLine;
		if(iDoctypeLine != -1) {
			var content = "";
			for(; iLine < cLines; ++iLine) {
				var line = document.Line(iLine);
				var iHome = (iLine == iDoctypeLine) ? RegExp.lastIndex : 0;
				var iEndDelimiter = line.indexOf(">", iHome);
				if(iEndDelimiter != -1) {
					content += line.substring(iHome, iEndDelimiter);
					break;
				}
				content += line.substring(iHome) + "\n";
			}
			if(content.match(/html\s+PUBLIC\s+[\"\']-\/\/W3C\/\/DTD\s+XHTML\s+1\.0(\s+Strict)?\/\/EN[\"\']/))
				version = 0;
			else if(content.match(/html\s+PUBLIC\s+[\"\']-\/\/W3C\/\/DTD\s+XHTML\s+1\.0\s+Transitional\/\/EN[\"\']/))
				version = 1;
			else if(content.match(/html\s+PUBLIC\s+[\"\']-\/\/W3C\/\/DTD\s+XHTML\s+1\.0\s+Frameset\/\/EN[\"\']/))
				version = 2;
			else if(content.match(/html\s+PUBLIC\s+[\"\']-\/\/W3C\/\/DTD\s+XHTML\s+1\.1\/\/EN[\"\']/))
				version = 3;
//			else if(content.match(/html\s+PUBLIC\s+[\"\']-\/\/W3C\/\/DTD\s+XHTML\s+Basic\s+1\.0\/\/EN[\"\']/))
//				version = 4;
		}
		applyXML(editor, cookies);
/*		cookies.xhtml1Structure = lexer.AddKeywords("body head html title");
		cookies.xhtml1Text = lexer.AddKeywords("abbr acronym address blockquote br cite code dfn div em h1 h2 h3 h4 h5 h6 kbd p pre q samp span strong var");
		cookies.xhtml1Hypertext = lexer.AddKeywords("a");
		cookies.xhtml1List = lexer.AddKeywords("dd dl dt li ol ul");
		cookies.xhtml1Applet = lexer.AddKeywords("applet");
		cookies.xhtml1TextExtension = lexer.AddKeywords("b bdo big del hr i insert small sub sup tt");
		cookies.xhtml1Forms = lexer.AddKeywords("button fieldset form input label legend optgroup option select textarea");
		cookies.xhtml1Table = lexer.AddKeywords("caption col colgroup table tbody td tfoot th thead tr");
		cookies.xhtml1Image = lexer.AddKeywords("img");
		cookies.xhtml1ClientSideImageMap = lexer.AddKeywords("area map");
		cookies.xhtml1Object = lexer.AddKeywords("object param");
		cookies.xhtml1Frames = lexer.AddKeywords("frame frameset noframes");
		cookies.xhtml1IFrame = lexer.AddKeywords("iframe");
		cookies.xhtml1Metainformation = lexer.AddKeywords("meta");
		cookies.xhtml1Scripting = lexer.AddKeywords("noscript script");
		cookies.xhtml1StyleSheet = lexer.AddKeywords("style");
		cookies.xhtml1Link = lexer.AddKeywords("link");
		cookies.xhtml1Base = lexer.AddKeywords("base");
		cookies.xhtml1Ruby = lexer.AddKeywords("rb rbc rp rt rtc ruby");
		cookies.xhtml1Legacy = lexer.AddKeywords("basefont center dir font isindex menu s strike u");
*/
		cookies.xmlElement = lexer.AddKeywords("a abbr acronym address applet area base bdo big blockquote body br button caption cite code col colgroup dd del dfn div dl dt em fieldset form frame frameset h1 h2 h3 h4 h5 h6 head hr html i iframe img input ins kbd label legend li link map meta noframe noscript object ol optgroup option p param pre q rb rbc rp rt rtc ruby samp script select small span strong style sub sup table tbody td textarea tfoot th thead title tr tt ul var");
		cookies.xmlAttribute = lexer.AddKeywords("abbr accept accept-charset accesskey action align alt archive axis border cellpadding cellspacing charset checked cite class classid codebase codetype cols colspan content coords data datetime declare defer dir disabled enctype for frame headers height href hreflang ismap http-equiv id label long maxlength media method multiple name nohref onblur onchange onclick ondblclick onfocus onkeydown onkeypress onkeyup onload onmousedown onmousemove onmouseout onmouseover onmouseup onreset onselect onsubmit onunload rbspan readonly rel rev rows rowspan rules scheme scope selected shape size span src standby summary tabindex title type usemap valign value valuetype version width xml:lang xml:space xmlns");
	}

	// RSS 1.0 (without extension modules)
	else if(typeName == "RSS") {
		applyXML(editor, cookies);
		cookies.xmlElement = lexer.AddKeywords("channel description image item items link name rdf:li rdf:RDF rdf:Seq textinput title url");
		cookies.xmlAttribute = lexer.AddKeywords("rdf:about rdf:resource xml:lang xmlns xmlns:rdf");
	}

	// XML
	else if(typeName == "XML")
		applyXML(editor, cookies);

	pref.TokenDecoration("asciiControl").Color = 0x808000;

	if(typeName == "default");
	else if(typeName == "ReadMe"
			|| typeName == "テキスト") {
		pref.SelectEndOfLine = false;
		pref.ShowEndOfFile = false;
		pref.ShowEndOfLine = false;
		pref.ShowCurrentUnderline = false;
		pref.ShowWhiteSpaceAlternative = false;
		pref.ThinCaret = true;
	} else {	// プログラミング用の設定
		// 雑多な設定
		pref.SelectEndOfLine = true;
		pref.ShowEndOfFile = true;
		pref.ShowEndOfLine = true;
		pref.ShowCurrentUnderline = true;
		pref.ShowIndicatorMargin = true;
		pref.ShowLineNumber = true;
		pref.ThinCaret = false;
		pref.LineNumberBorderStyle = BorderType.BorderDotted;
		pref.ShowWhiteSpaceAlternative = true;

		lexer.TokenEnabled("otherQuotation") = false;

//		pref.TokenDecoration("normal").Color = 0x333333;
//		pref.TokenDecoration("normal").BackgroundColor = 0xFFFFF9;

		// 空白類文字
		pref.TokenDecoration("whiteSpace").Color = 0xD0E0E0;
		pref.TokenDecoration("tab").Color = 0xD0E0E0;

		// コメント
		if("singlelineComment" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.singlelineComment)).Color = 0x008000;
		if("singlelineComment2" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.singlelineComment2)).Color = 0x008000;
		if("multilineComment" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.multilineComment)).Color = 0x008000;
		if("multilineComment2" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.multilineComment2)).Color = 0x008000;
		if("singlelineDocumentationComment" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.singlelineDocumentationComment)).Color = 0x408000;
		if("multilineDocumentationComment" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.multilineDocumentationComment)).Color = 0x408000;

		// その他の注釈
		if("vbscriptPragma" in cookies) {
			pref.TokenDecoration("annotation_".concat(cookies.vbscriptPragma)).Color = 0xFFFFFF;
			pref.TokenDecoration("annotation_".concat(cookies.vbscriptPragma)).BackgroundColor = 0x666666;
			pref.TokenDecoration("annotation_".concat(cookies.vbscriptPragma)).BoldFont = true;
		}
		if("perlRubyCommandLine" in cookies) {
			pref.TokenDecoration("annotation_".concat(cookies.perlRubyCommandLine)).Color = 0x999999;
//			pref.TokenDecoration("annotation_".concat(cookies.perlRubyCommandLine)).BackgroundColor = ;
		}
		if("xmlDecl" in cookies) {
			pref.TokenDecoration("annotation_".concat(cookies.xmlDecl)).Color = 0xFFFFFF;
			pref.TokenDecoration("annotation_".concat(cookies.xmlDecl)).BackgroundColor = 0x666666;
		}
		if("xmlCDataSec" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.xmlCDataSec)).BackgroundColor = 0xFFFFF0;
		if("xmlDocType" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.xmlDocType)).Color = 0xFF8000;
		if("wshJobDecl" in cookies)
			pref.TokenDecoration("annotation_".concat(cookies.wshJobDecl)).Color = 0x808000;

		// キーワード
		if("entity" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.entity)).Color = 0x0000FF;
		if("control" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.control)).Color = 0x0000FF;
		if("operator" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.operator)).Color = 0x800080;
		if("attribute" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.attribute)).Color = 0x0000FF;
		if("exception" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.exception)).Color = 0x0000FF;
		if("constant" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.constant)).Color = 0x800000;
		if("command" in cookies)
			pref.TokenDecoration("keyword_".concat(cookies.command)).Color = 0x0000FF;
		if("xmlElement" in cookies) {
			pref.TokenDecoration("keyword_".concat(cookies.xmlElement)).Color = 0x800000;
			pref.TokenDecoration("keyword_".concat(cookies.xmlAttribute)).Color = 0x008080;
		}
		if("futureReserved" in cookies) {
			pref.TokenDecoration("keyword_".concat(cookies.futureReserved)).Color = 0x0000FF;
			pref.TokenDecoration("keyword_".concat(cookies.futureReserved)).BorderColor = 0xCC0000;
			pref.TokenDecoration("keyword_".concat(cookies.futureReserved)).BorderStyle = BorderType.UnderlineWaved;
		}
		if("msExtended" in cookies) {
			pref.TokenDecoration("keyword_".concat(cookies.msExtended)).Color
			= pref.TokenDecoration("keyword_".concat(cookies.nsExtended)).Color = 0x0000FF;
			pref.TokenDecoration("keyword_".concat(cookies.msExtended)).BorderColor
			= pref.TokenDecoration("keyword_".concat(cookies.nsExtended)).BorderColor = 0xCC0000;
			pref.TokenDecoration("keyword_".concat(cookies.msExtended)).BorderStyle
			= pref.TokenDecoration("keyword_".concat(cookies.nsExtended)).BorderStyle = BorderType.UnderlineWaved;
		}

		// その他
		pref.TokenDecoration("number").Color = 0x800000;
		pref.TokenDecoration("operator").Color = 0x666600;
		pref.TokenDecoration("singleQuotation").Color = 0x000066;
		pref.TokenDecoration("singleQuotation").BackgroundColor = 0xF6FFF6;
		pref.TokenDecoration("doubleQuotation").Color = 0x000066;
		pref.TokenDecoration("doubleQuotation").BackgroundColor = 0xF9F9FF;
//		pref.TokenDecoration("indicatorMargin").Color = 0x808080;
//		pref.TokenDecoration("indicatorMargin").BackgroundColor = 0xECE9D8;
		pref.TokenDecoration("lineNumber").Color = 0x008080;
		pref.TokenDecoration("emphaticLineNumber").Color = 0x008080;
		pref.TokenDecoration("emphaticLineNumber").BoldFont = true;
		pref.TokenDecoration("matchBrackets").Color = 0x990000;
		pref.TokenDecoration("matchBrackets").BoldFont = true;
//		pref.TokenDecoration("matchBrackets").BorderStyle = BorderType.BorderSolid;
//		pref.TokenDecoration("matchBrackets").BorderColor = 0x3366CC;
		pref.TokenDecoration("endOfLine").Color = 0x669999;
		pref.TokenDecoration("endOfFile").Color = 0x008080;
//		pref.TokenDecoration("endOfFile").Color = 0x006699;
//		pref.TokenDecoration("endOfFile").BackgroundColor = 0x99CCFF;

		// XML 用の追加定義
		if(typeName == "マクロスクリプト構成"
				|| typeName == "XHTML" || typeName == "XML" || typeName == "RSS"
				|| typeName == "Windows Script Host" || typeName == "Windows Script Component") {
			pref.TokenDecoration("operator").Color = 0x3333FF;
			pref.TabWidth = 2;
		}
		// Unicode アルファベットの使用
		if(typeName == "VBScript" || typeName == "Perl" || typeName == "Ruby")
			lexer.UnicodeAlphabetsEnabled = false;
	}
}

/// Alpha のパスを返す
function getBinaryPath() {
	var path = Ambient.FullName;
	return path.substring(0, path.lastIndexOf("\\") + 1);
}

/**
 *	XML 字句規則の適用
 *	@param editor : TextProcessor	テキストエディタ
 *	@param cookies : Object			クッキーのコレクション
 */
function applyXML(editor, cookies) {
	var lexer = editor.Lexer;
	cookies.xmlDecl = lexer.AddMultilineAnnotation("<?xml", "?>");
	cookies.xmlDocType = lexer.AddMultilineAnnotation("<!DOCTYPE", ">");
	cookies.xmlCDataSec = lexer.AddMultilineAnnotation("<![CDATA[", "]]>");
	cookies.multilineComment = lexer.AddMultilineAnnotation("<!--", "-->");
	lexer.SetOperators("< > = /");
	lexer.SetAdditionalAlphabets(".-_:");
	lexer.SetBrackets("<");
	lexer.TokenEnabled("number") = false;
	editor.Preferences.MatchBracketScanLines = 8;
}

/// 短縮形の読み込み
function loadAbbreviations() {
	try {
		var fso = new ActiveXObject("Scripting.FileSystemObject");
		WScript.LoadConstants(fso);
		
		var abbrs = Ambient.Abbreviations;
		var s = fso.OpenTextFile(getBinaryPath() + "abbreviations",
					IOMode.ForReading, false, Tristate.TristateUseDefault);

		while(!s.AtEndOfStream) {
			var key = s.ReadLine();
			var value = s.ReadLine();
			if(key.length == 0 || value.length == 0)
				break;
			abbrs.Register(key, value);
		}
		s.Close();
	} catch(e) {
	}
}

/// 短縮形の保存
function saveAbbreviations() {
	try {
		var fso = new ActiveXObject("Scripting.FileSystemObject");
		var abbrs = new Enumerator(Ambient.Abbreviations);
		var s = fso.OpenTextFile(getBinaryPath() + "abbreviations",
					IOMode.ForWriting, true, Tristate.TristateUseDefault);

		for(abbrs.moveFirst(); !abbrs.atEnd(); abbrs.moveNext()) {
			var abbr = abbrs.item();
			s.WriteLine(abbr);
			s.WriteLine(Ambient.Abbreviations.Expand(abbr));
		}
		s.Close();
	} catch(e) {
	}
}

/// アイヌ文字をキーボードから入力できるようにする。
/// キー割り当ては ROM さんの "ainu_input 1.10" によった (http://hp.vector.co.jp/authors/VA038316/)
function setAinuInput(keys) {
	var ainuKeyMap = [
		"€", "C-S-4",
		"セ゚", "C-M-p",
		"ツ゚", "C-M-z",
		"ト゚", "C-M-s",
		"ㇰ", "C-S-h",
		"ㇱ", "C-S-d",
		"ㇲ", "C-S-r",
		"ㇳ", "C-S-s",
		"ㇴ", "C-S-1",
		"ㇵ", "C-S-f",
		"ㇶ", "C-S-v",
		"ㇷ", "C-S-2",
		"ㇷ゚", "C-M-2",
		"ㇸ", "C-S-^",
		"ㇹ", "C-S--",
		"ㇺ", "C-S-]",
		"ㇻ", "C-S-o",
		"ㇼ", "C-S-l",
		"ㇽ", "C-S-.",
		"ㇾ", "C-S-;",
		"ㇿ", "C-S-\\"
	];
	function input(str) {
		Ambient.ActiveDocument.Editor.InputChar(str);
	}
	for(var i = 0; i < ainuKeyMap.length; i += 2)
		keys.Assign(ainuKeyMap[i + 1], input.bind1st(ainuKeyMap[i]));
}
