/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.service.resolver.BundleSpecification;

public class GroupingChecker {
    HashMap bundles = new HashMap();
    private boolean checkCycles = false;

    private ResolverExport[] getConstraints(ResolverExport constrained) {
        Object[] cachedResults = this.getCachedConstraints(constrained);
        if (cachedResults != null && cachedResults[1] != null) {
            if (!constrained.getExporter().isResolved()) {
                ResolverExport[] constraints = (ResolverExport[])cachedResults[1];
                boolean dropped = false;
                int i = 0;
                while (!dropped && i < constraints.length) {
                    dropped = constraints[i].isDropped();
                    ++i;
                }
                if (!dropped) {
                    return constraints;
                }
            } else {
                return (ResolverExport[])cachedResults[1];
            }
        }
        ArrayList resultlist = this.getConstraintsList(constrained);
        ResolverExport[] results = resultlist.toArray(new ResolverExport[resultlist.size()]);
        if (!this.checkCycles || constrained.getExporter().isResolved()) {
            if (cachedResults == null) {
                cachedResults = this.createConstraintsCache(constrained);
            }
            cachedResults[1] = results;
        }
        return results;
    }

    private Object[] getCachedConstraints(ResolverExport constrained) {
        HashMap exports = (HashMap)this.bundles.get(constrained.getExporter());
        return exports == null ? null : (Object[])exports.get(constrained);
    }

    private ArrayList getConstraintsList(ResolverExport constrained) {
        ArrayList results = new ArrayList();
        this.getTransitiveConstraints(constrained, results);
        return results;
    }

    private void getTransitiveConstraints(ResolverExport constrained, ArrayList results) {
        if (constrained.isDropped()) {
            return;
        }
        ResolverExport[] constrainedRoots = constrained.getRoots();
        int i = 0;
        while (i < constrainedRoots.length) {
            if (constrainedRoots[i] != constrained) {
                this.getTransitiveConstraints(constrainedRoots[i], results);
            }
            ++i;
        }
        Object[] cachedConstraints = this.getCachedConstraints(constrained);
        ArrayList constraints = (ArrayList)(cachedConstraints != null ? cachedConstraints[0] : null);
        if (constraints == null) {
            return;
        }
        Iterator iter = constraints.iterator();
        while (iter.hasNext()) {
            Object constraint = iter.next();
            ResolverExport[] moreConstraints = null;
            if (constraint instanceof ResolverExport) {
                ResolverExport export = (ResolverExport)constraint;
                moreConstraints = export.getRoots();
            } else if (constraint instanceof ResolverImport) {
                ResolverImport imp = (ResolverImport)constraint;
                if (imp.getMatchingExport() != null) {
                    moreConstraints = imp.getMatchingExport().getRoots();
                }
            } else if (constraint instanceof UsesRequiredExport) {
                moreConstraints = ((UsesRequiredExport)constraint).getRoots();
            }
            if (moreConstraints == null) continue;
            int i2 = 0;
            while (i2 < moreConstraints.length) {
                if (!results.contains(moreConstraints[i2])) {
                    results.add(moreConstraints[i2]);
                    if (moreConstraints[i2] != constraint) {
                        this.getTransitiveConstraints(moreConstraints[i2], results);
                    }
                }
                ++i2;
            }
        }
    }

    private Object[] createConstraintsCache(ResolverExport constrained) {
        Object[] constraints;
        HashMap<ResolverExport, Object[]> exports = (HashMap<ResolverExport, Object[]>)this.bundles.get(constrained.getExporter());
        if (exports == null) {
            exports = new HashMap<ResolverExport, Object[]>();
            this.bundles.put(constrained.getExporter(), exports);
        }
        if ((constraints = (Object[])exports.get(constrained)) == null) {
            constraints = new Object[2];
            exports.put(constrained, constraints);
        }
        return constraints;
    }

    private ArrayList createConstraints(ResolverExport constrained) {
        Object[] constraints = this.createConstraintsCache(constrained);
        if (constraints[0] == null) {
            constraints[0] = new ArrayList();
        }
        return (ArrayList)constraints[0];
    }

    private void addConstraint(ResolverExport constrained, Object constraint) {
        ArrayList list = this.createConstraints(constrained);
        if (!list.contains(constraint)) {
            list.add(constraint);
        }
    }

    private void addConstraint(ArrayList export, Object constraint) {
        Iterator iExport = export.iterator();
        while (iExport.hasNext()) {
            this.addConstraint((ResolverExport)iExport.next(), constraint);
        }
    }

    void removeAllExportConstraints(ResolverBundle bundle) {
        this.bundles.remove(bundle);
    }

    ResolverBundle isConsistent(BundleConstraint req, ResolverBundle bundle) {
        BundleConstraint[] requires = req.getBundle().getRequires();
        ArrayList visited = new ArrayList(requires.length);
        int i = 0;
        while (i < requires.length) {
            ResolverBundle match = requires[i].getMatchingBundle();
            if (match != bundle && match != null) {
                ResolverExport[] exports = match.getSelectedExports();
                int j = 0;
                while (j < exports.length) {
                    if (this.checkReqExpConflict(exports[j], this.getConstraints(exports[j]), bundle, visited) != null) {
                        return match;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    ResolverExport isConsistent(ResolverImport imp, ResolverExport exp) {
        ResolverExport[] expConstraints = this.getConstraints(exp);
        ResolverImport[] imports = imp.getBundle().getImportPackages();
        int i = 0;
        while (i < imports.length) {
            ResolverExport conflict = this.checkImpExpConflict(imp, imports[i].getMatchingExport(), exp, expConstraints);
            if (conflict != null) {
                return conflict;
            }
            ++i;
        }
        BundleConstraint[] requires = imp.getBundle().getRequires();
        ArrayList visited = new ArrayList(requires.length);
        int i2 = 0;
        while (i2 < requires.length) {
            ResolverExport conflict = this.checkReqExpConflict(exp, expConstraints, requires[i2].getMatchingBundle(), visited);
            if (conflict != null) {
                return conflict;
            }
            ++i2;
        }
        return null;
    }

    private ResolverExport checkImpExpConflict(ResolverImport imp, ResolverExport existing, ResolverExport candidate, ResolverExport[] candConstraints) {
        if (existing == null) {
            return null;
        }
        if (existing != candidate) {
            ResolverExport[] impConstraints = this.getConstraints(existing);
            int j = 0;
            while (j < impConstraints.length) {
                if (this.isConflict(candidate, impConstraints[j])) {
                    return existing;
                }
                ++j;
            }
        }
        int i = 0;
        while (i < candConstraints.length) {
            ResolverImport alsoImported;
            ResolverExport[] importerExp;
            if (imp.getBundle() != candConstraints[i].getExporter() && (importerExp = imp.getBundle().getExports(candConstraints[i].getName())).length > 0 && ((alsoImported = imp.getBundle().getImport(candConstraints[i].getName())) == null || alsoImported.getMatchingExport() != null)) {
                int j = 0;
                while (j < importerExp.length) {
                    if (!importerExp[j].isDropped() && !this.isOnRoot(importerExp[j].getRoots(), candConstraints[i])) {
                        return existing;
                    }
                    ++j;
                }
            }
            if (this.isConflict(existing, candConstraints[i])) {
                return existing;
            }
            ++i;
        }
        return null;
    }

    private ResolverExport checkReqExpConflict(ResolverExport exp, ResolverExport[] expConstraints, ResolverBundle bundle, ArrayList visited) {
        if (bundle == null) {
            return null;
        }
        if (visited.contains(bundle)) {
            return null;
        }
        visited.add(bundle);
        ResolverExport[] exports = bundle.getSelectedExports();
        int i = 0;
        while (i < exports.length) {
            int j = 0;
            while (j < expConstraints.length) {
                if (this.isConflict(exports[i], expConstraints[j])) {
                    return exp;
                }
                ++j;
            }
            ResolverExport[] constraints = this.getConstraints(exports[i]);
            int j2 = 0;
            while (j2 < constraints.length) {
                if (this.isConflict(exp, constraints[j2])) {
                    return exp;
                }
                ++j2;
            }
            ++i;
        }
        BundleConstraint[] requires = bundle.getRequires();
        int i2 = 0;
        while (i2 < requires.length) {
            ResolverExport conflict;
            if (((BundleSpecification)requires[i2].getVersionConstraint()).isExported() && (conflict = this.checkReqExpConflict(exp, expConstraints, requires[i2].getMatchingBundle(), visited)) != null) {
                return exp;
            }
            ++i2;
        }
        return null;
    }

    private boolean isConflict(ResolverExport candidate, ResolverExport candidateRoot) {
        return candidateRoot.getExporter().isResolvable() && candidateRoot.getName().equals(candidate.getName()) && !this.isOnRoot(candidate.getRoots(), candidateRoot);
    }

    private boolean isOnRoot(ResolverExport[] roots, ResolverExport re) {
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getExporter() == re.getExporter()) {
                return true;
            }
            ++i;
        }
        return roots.length == 1 && !roots[0].getExportPackageDescription().isRoot();
    }

    void addInitialGroupingConstraints(ResolverBundle initBundle) {
        if (this.bundles.containsKey(initBundle)) {
            return;
        }
        ResolverExport[] exports = initBundle.getExportPackages();
        int j = 0;
        while (j < exports.length) {
            ArrayList<ResolverExport> export = new ArrayList<ResolverExport>();
            export.add(exports[j]);
            this.addInitialGroupingConstraints(export, null);
            ++j;
        }
        if (this.bundles.get(initBundle) == null) {
            this.bundles.put(initBundle, null);
        }
    }

    private void addInitialGroupingConstraints(ArrayList exports, ResolverExport constraint) {
        String[] uses;
        ResolverExport cur = (ResolverExport)exports.get(0);
        if (cur == constraint) {
            return;
        }
        if (constraint == null) {
            if (this.getCachedConstraints(cur) != null) {
                return;
            }
            constraint = cur;
        }
        if ((uses = (String[])constraint.getExportPackageDescription().getDirective("uses")) == null) {
            return;
        }
        boolean constraintAdded = false;
        if (!exports.contains(constraint) && this.getCachedConstraints(constraint) == null) {
            exports.add(constraint);
            constraintAdded = true;
        }
        ResolverBundle exporter = cur.getExporter();
        int i = 0;
        while (i < uses.length) {
            ResolverExport[] constraintExports = exporter.getExports(uses[i]);
            int j = 0;
            while (j < constraintExports.length) {
                if (!this.createConstraints(cur).contains(constraintExports[j])) {
                    this.addConstraint(exports, (Object)constraintExports[j]);
                    this.addInitialGroupingConstraints(exports, constraintExports[j]);
                }
                ++j;
            }
            ResolverImport constraintImport = exporter.getImport(uses[i]);
            if (constraintImport != null && !constraintImport.isDynamic()) {
                this.addConstraint(exports, (Object)constraintImport);
            }
            if (constraintExports.length == 0 && (constraintImport == null || constraintImport.isDynamic())) {
                this.addConstraint(exports, (Object)new UsesRequiredExport(constraint, uses[i]));
            }
            ++i;
        }
        if (constraintAdded) {
            exports.remove(constraint);
        }
    }

    public void setCheckCycles(boolean checkCycles) {
        this.checkCycles = checkCycles;
    }

    private class UsesRequiredExport {
        private ResolverExport export;
        private String usesName;

        UsesRequiredExport(ResolverExport export, String usesName) {
            this.export = export;
            this.usesName = usesName;
        }

        public ResolverExport[] getRoots() {
            ArrayList<ResolverExport> results = new ArrayList<ResolverExport>(1);
            BundleConstraint[] requires = this.export.getExporter().getRequires();
            int i = 0;
            while (i < requires.length) {
                ResolverExport requiredExport;
                if (requires[i].getMatchingBundle() != null && (requiredExport = requires[i].getMatchingBundle().getExport(this.usesName)) != null && !requiredExport.isDropped()) {
                    ResolverExport[] roots = requiredExport.getRoots();
                    int j = 0;
                    while (j < roots.length) {
                        if (!results.contains(requiredExport)) {
                            results.add(roots[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return results.toArray(new ResolverExport[results.size()]);
        }

        public boolean equals(Object o) {
            if (!(o instanceof UsesRequiredExport)) {
                return false;
            }
            return ((UsesRequiredExport)o).export.getExporter() == this.export.getExporter() && this.usesName.equals(((UsesRequiredExport)o).usesName);
        }
    }
}

