/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools.dvdtoxvid;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import jp.sourceforge.akjrcp.util.PrintStreamProcessPrinter;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.CheckToRadio;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.DVDData;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.DVDTitleSet;
import jp.sourceforge.akjrcp.videotools.dvdtoxvid.DVDTitleSetComposite;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DVDToXvidView
extends ViewPart {
    public static Log log = LogFactory.getLog(DVDToXvidView.class);
    public static final String ID = DVDToXvidView.class.getName();
    DVDTitleSetComposite[] titleSetComposits;
    private Composite composite;
    private DVDData dvdData;
    private ScrolledComposite scroll;
    private Text saveFilePath;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite actionPanel = new Composite(parent, 0);
        actionPanel.setLayout((Layout)new RowLayout());
        Button bt = new Button(actionPanel, 0);
        ImageDescriptor opendirIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.akjrcp.akj_betas", (String)"icons/opendir.gif");
        bt.setImage(opendirIcon.createImage());
        bt.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DVDToXvidView.this.openDir();
            }
        });
        this.scroll = new ScrolledComposite(parent, 2560);
        GridData gdata = new GridData(1808);
        gdata.grabExcessVerticalSpace = true;
        this.scroll.setLayoutData((Object)gdata);
        this.composite = new Composite((Composite)this.scroll, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.dvdData = new DVDData();
        this.scroll.setContent((Control)this.composite);
        this.scroll.setMinSize(-1, 100);
        this.scroll.setExpandHorizontal(true);
        this.scroll.setExpandVertical(true);
        Composite execPanel = new Composite(parent, 0);
        execPanel.setLayoutData((Object)new GridData(768));
        execPanel.setLayout((Layout)new GridLayout(3, false));
        Button convertButton = new Button(execPanel, 0);
        convertButton.setText("    convert    ");
        convertButton.addSelectionListener((SelectionListener)new StartExec());
        this.saveFilePath = new Text(execPanel, 8);
        this.saveFilePath.setLayoutData((Object)new GridData(768));
        Button saveButton = new Button(execPanel, 0);
        saveButton.setText("save");
        saveButton.addSelectionListener((SelectionListener)new SaveFile());
    }

    public String mixCommand(File[] files) {
        String ret = "";
        int i = 0;
        while (i < files.length) {
            ret = String.valueOf(ret) + "\"" + files[i].getAbsolutePath() + "\"";
            if (i != files.length - 1) {
                ret = String.valueOf(ret) + "+";
            }
            ++i;
        }
        return ret;
    }

    public void exec(File[] files, File export) {
        log.info((Object)ArrayUtils.toString((Object)files));
        log.info((Object)export);
        File tmpFile = null;
        try {
            String msCommand = "copy /b " + this.mixCommand(files) + " " + "\"" + export + "\"";
            tmpFile = File.createTempFile("tmp", ".bat");
            tmpFile.deleteOnExit();
            FileUtils.writeStringToFile((File)tmpFile, (String)msCommand);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String[] command = new String[]{"cmd.exe", "/c", tmpFile.getAbsolutePath()};
        Runtime r = Runtime.getRuntime();
        try {
            log.info((Object)ArrayUtils.toString((Object)command));
            PrintStreamProcessPrinter s = new PrintStreamProcessPrinter(new PrintWriter(System.out));
            Process process = r.exec(command);
            ProcessMonitor monitor = new ProcessMonitor(process, s);
            monitor.startMonitor();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openDir(String path) {
        if (path == null) {
            return;
        }
        Control[] cs = this.composite.getChildren();
        int i = 0;
        while (i < cs.length) {
            cs[i].dispose();
            ++i;
        }
        this.dvdData.open(new File(path));
        CheckToRadio checkToRadio = new CheckToRadio();
        DVDTitleSet[] titleSets = this.dvdData.getTitleSets();
        log.info((Object)("titleset:" + titleSets.length));
        this.titleSetComposits = new DVDTitleSetComposite[titleSets.length];
        int i2 = 0;
        while (i2 < titleSets.length) {
            this.titleSetComposits[i2] = new DVDTitleSetComposite(this.composite, 0, titleSets[i2], checkToRadio);
            this.titleSetComposits[i2].setLayoutData(new GridData(768));
            ++i2;
        }
        this.scroll.setMinHeight(140 * titleSets.length);
        this.scroll.pack();
    }

    public void openDir() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        String path = dialog.open();
        this.openDir(path);
    }

    public void setFocus() {
    }

    public class StartExec
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (DVDToXvidView.this.saveFilePath.getText().length() == 0) {
                return;
            }
            if (DVDToXvidView.this.titleSetComposits == null || DVDToXvidView.this.titleSetComposits.length == 0) {
                return;
            }
            DVDTitleSetComposite titleSet = null;
            int i = 0;
            while (i < DVDToXvidView.this.titleSetComposits.length) {
                if (DVDToXvidView.this.titleSetComposits[i].getSlected()) {
                    titleSet = DVDToXvidView.this.titleSetComposits[i];
                    break;
                }
                ++i;
            }
            if (titleSet != null) {
                File[] files = titleSet.getEncodingFile();
                DVDToXvidView.this.exec(files, new File(DVDToXvidView.this.saveFilePath.getText()));
            }
        }
    }

    public class SaveFile
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.avi"});
            dialog.setFilterExtensions(new String[]{"*.vob"});
            String path = dialog.open();
            if (path != null) {
                FileOverwriteControler controler;
                boolean r;
                File f = new File(path);
                if (f.exists() && !(r = (controler = new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 1)).canOverwrite(f))) {
                    return;
                }
                DVDToXvidView.this.saveFilePath.setText(path);
            }
        }
    }
}

