/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import org.eclipse.swt.graphics.RGB;

public class ColorUtils {
    public static RGB hexToRGB(String hex) {
        if (hex == null || hex.length() == 0) {
            return null;
        }
        int value = ColorUtils.hexToInt(hex);
        int r = (0xFF0000 & value) >> 16;
        int g = (0xFF00 & value) >> 8;
        int b = 0xFF & value;
        return new RGB(r, g, b);
    }

    public static String rgbToHex(RGB rgb) {
        String b;
        String g;
        if (rgb == null) {
            return null;
        }
        String r = Integer.toHexString(rgb.red);
        if (r.length() < 2) {
            r = "0" + r;
        }
        if ((g = Integer.toHexString(rgb.green)).length() < 2) {
            g = "0" + g;
        }
        if ((b = Integer.toHexString(rgb.blue)).length() < 2) {
            b = "0" + b;
        }
        return "#" + r + g + b;
    }

    public static int hexToInt(String hex) {
        String h = hex;
        if (h.startsWith("#")) {
            h = hex.substring(1);
        }
        return Integer.parseInt(h, 16);
    }
}

