/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.param;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.ui.param.AbstractParamCompositeItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ParamRadioGroup
extends AbstractParamCompositeItem {
    private String key;
    private String label;
    private String[] paramsValues;
    private String[] paramLabels;
    private String value = "";
    List<Button> buttons = new ArrayList<Button>();
    private Group group;

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setToolTipText(String text) {
        this.group.setToolTipText(text);
        int i = 0;
        while (i < this.buttons.size()) {
            this.buttons.get(i).setToolTipText(text);
            ++i;
        }
    }

    public String[] getParams() {
        return this.paramsValues;
    }

    public String getValue() {
        String ret = "";
        int i = 0;
        while (i < this.buttons.size()) {
            Button bt = this.buttons.get(i);
            if (bt.getSelection()) {
                return this.paramsValues[i];
            }
            ++i;
        }
        return ret;
    }

    public void setValue(String value) {
        int index = -1;
        int i = 0;
        while (i < this.paramsValues.length) {
            if (this.paramsValues[i].equals(value)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            String selectLabel = this.paramLabels[index];
            int i2 = 0;
            while (i2 < this.buttons.size()) {
                Button bt = this.buttons.get(i2);
                if (bt.getText().equals(selectLabel)) {
                    bt.setSelection(true);
                    this.value = value;
                    if (this.paramActionListener != null) {
                        this.paramActionListener.paramItemModified(this);
                    }
                } else {
                    bt.setSelection(false);
                }
                ++i2;
            }
        }
    }

    public ParamRadioGroup(Composite parent, int style, String key, String label, String[] values, String[] labels) {
        this(parent, style, key, label, values, labels, 1);
    }

    public ParamRadioGroup(Composite parent, int style, String key, String label, String[] values, String[] labels, int grid) {
        super(parent, style);
        this.key = key;
        this.label = label;
        this.paramsValues = values;
        this.paramLabels = labels;
        this.setLayout((Layout)new FillLayout());
        this.group = new Group((Composite)this, 0);
        this.group.setText(label);
        this.group.setLayout((Layout)new GridLayout(grid, false));
        AbstractParamCompositeItem.SelectionCheck ch = new AbstractParamCompositeItem.SelectionCheck();
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button((Composite)this.group, 16);
            if (i == 0) {
                radio.setSelection(true);
            }
            radio.addSelectionListener((SelectionListener)ch);
            radio.setText(labels[i]);
            this.buttons.add(radio);
            ++i;
        }
    }

    public boolean isModified() {
        String newValue = this.getValue();
        return !this.value.equals(newValue);
    }
}

