/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.akjrcp.ui.param.AbstractParamItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ParamRadioContainer
extends AbstractParamItem {
    private String key;
    private String value = "";
    List<Button> buttons = new ArrayList<Button>();
    Map<Button, String> valueMap = new HashMap<Button, String>();
    private AbstractParamItem.SelectionCheck selectionCheck = new AbstractParamItem.SelectionCheck();

    public String getKey() {
        return this.key;
    }

    public void setToolTipText(String text) {
        int i = 0;
        while (i < this.buttons.size()) {
            this.buttons.get(i).setToolTipText(text);
            ++i;
        }
    }

    public String getValue() {
        String ret = "";
        int i = 0;
        while (i < this.buttons.size()) {
            Button bt = this.buttons.get(i);
            if (bt.getSelection()) {
                return this.valueMap.get(bt);
            }
            ++i;
        }
        return ret;
    }

    public void setValue(String value) {
        int i = 0;
        while (i < this.buttons.size()) {
            Button bt = this.buttons.get(i);
            String btKey = this.valueMap.get(bt);
            if (btKey.equals(value)) {
                bt.setSelection(true);
            } else {
                bt.setSelection(false);
            }
            ++i;
        }
        this.value = value;
    }

    public ParamRadioContainer(String key) {
        this.key = key;
    }

    public Button createButton(Composite parent, int layout, String label, String v) {
        Button radio = new Button(parent, 0x10 | layout);
        if (this.buttons.size() == 0) {
            radio.setSelection(true);
            this.value = v != null ? v : label;
        }
        radio.addSelectionListener((SelectionListener)this.selectionCheck);
        radio.setText(label);
        this.buttons.add(radio);
        if (v != null) {
            this.valueMap.put(radio, v);
        } else {
            this.valueMap.put(radio, label);
        }
        return radio;
    }

    public Button createButton(Composite parent, int layout, String label) {
        return this.createButton(parent, layout, label, null);
    }

    public boolean isModified() {
        String newValue = this.getValue();
        return !this.value.equals(newValue);
    }
}

