/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import jp.sourceforge.akjrcp.ffmpeg.AdvancedAudioFFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegInput;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;

public class WavFFMpegPreference
extends AdvancedAudioFFMpegPreference {
    public String[] toCommand(FFMpegInput[] inputs, String output) {
        FFMpegFLVParser parser = new FFMpegFLVParser(this.getFfmpegPath());
        String path = inputs[inputs.length - 1].getPath();
        int i = inputs.length - 1;
        while (i >= 0) {
            FLVInfomation info = parser.parseFile(new File(inputs[i].getPath()));
            if (info.isHaveAudio()) {
                path = inputs[i].getPath();
                break;
            }
            --i;
        }
        return this.customToCommand(path, null, output);
    }

    public String[] customToCommand(String input, String avsInput, String output) {
        FFMpegFLVParser parser = new FFMpegFLVParser(this.getFfmpegPath());
        FLVInfomation info = parser.parseFile(new File(input));
        if (!info.isHaveAudio()) {
            if (avsInput == null) {
                log.warn((Object)"no aduio stream");
                return null;
            }
            info = parser.parseFile(new File(avsInput));
            if (!info.isHaveAudio()) {
                log.warn((Object)"no aduio stream even in avs");
                return null;
            }
        }
        log.info((Object)("info:" + info.getAudioRate() + "," + info.getAudioChannel()));
        if (!this.isForceConvert()) {
            this.setAudioRate(info.getAudioRate());
            this.setAudioChannel(info.getAudioChannel());
        } else {
            if (this.getConvertChannel() == -1) {
                this.setAudioChannel(info.getAudioChannel());
            } else {
                this.setAudioChannel(this.getConvertChannel());
            }
            if (this.getConvertFramerate() == -1) {
                this.setAudioRate(info.getAudioRate());
            } else {
                this.setAudioRate(this.getConvertFramerate());
            }
        }
        int bps = this.getAudioRate() * this.getAudioChannel() * 16 / 1000;
        this.setGuessSize(FFMpegPreference.toKBytes(info.getDuration(), bps));
        if (input == null || output == null) {
            return null;
        }
        FFMpegInput[] inputs = new FFMpegInput[]{avsInput == null ? new FFMpegInput(input) : new FFMpegInput(avsInput)};
        return super.toCommand(inputs, output);
    }
}

