/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audio;

import jp.sourceforge.akjrcp.audio.Messages;
import jp.sourceforge.akjrcp.audio.MpegAudioFormatUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MP3AudioSettingComposite
extends Composite {
    public static final String FRAMERATE = "FRAMERATE";
    public static final String BITRATE = "BITRATE";
    public static final String CHANNEL = "CHANNEL";
    public static final int SAME_SOURCE = -1;
    private String preferenceKey;
    private IPreferenceStore preferenceStore;
    private CCombo frameRate;
    private CCombo channel;
    private CCombo bitrate;

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void setPreferenceStore(IPreferenceStore store) {
        this.preferenceStore = store;
        if (this.preferenceStore.contains(String.valueOf(this.preferenceKey) + "." + FRAMERATE)) {
            int fr = this.preferenceStore.getInt(String.valueOf(this.preferenceKey) + "." + FRAMERATE);
            this.setFrameRate(fr);
        }
        if (this.preferenceStore.contains(String.valueOf(this.preferenceKey) + "." + BITRATE)) {
            int bt = this.preferenceStore.getInt(String.valueOf(this.preferenceKey) + "." + BITRATE);
            this.setBitrate(bt);
        }
        if (this.preferenceStore.contains(String.valueOf(this.preferenceKey) + "." + CHANNEL)) {
            int ch = this.preferenceStore.getInt(String.valueOf(this.preferenceKey) + "." + CHANNEL);
            this.setChannel(ch);
        }
    }

    public void updateStoreValue(String value, CCombo combo) {
        int s = combo.getItemCount();
        int i = 0;
        while (i < s) {
            if (value.equals(combo.getItem(i))) {
                combo.select(i);
                return;
            }
            ++i;
        }
        combo.select(0);
    }

    public void updateBitrate() {
        int framerate = this.getFramerate();
        int[] newBitrates = null;
        newBitrates = framerate == -1 ? MpegAudioFormatUtil.common_mp3_bitrate : MpegAudioFormatUtil.getAvailableMP3Bitrate(framerate);
        this.updateBitrate(newBitrates);
    }

    public void updateFramerate(int[] framerates) {
        int oldbitrate = this.getFramerate();
        this.frameRate.removeAll();
        this.frameRate.add(Messages.getString("MP3AudioSettingComposite.same_source"));
        int i = 0;
        while (i < framerates.length) {
            this.frameRate.add("" + framerates[i]);
            ++i;
        }
        this.updateStoreValue("" + oldbitrate, this.frameRate);
    }

    public void updateBitrate(int[] bitrates) {
        int oldbitrate = this.getBitrate();
        this.bitrate.removeAll();
        this.bitrate.add(Messages.getString("MP3AudioSettingComposite.same_source"));
        int i = 0;
        while (i < bitrates.length) {
            this.bitrate.add("" + bitrates[i]);
            ++i;
        }
        this.updateStoreValue("" + oldbitrate, this.bitrate);
    }

    public int toStoredValue(CCombo combo) {
        String value = "";
        value = combo.getSelectionIndex() <= 0 ? "-1" : (combo != this.channel ? combo.getItem(combo.getSelectionIndex()) : "" + combo.getSelectionIndex());
        return Integer.parseInt(value);
    }

    public void setChannel(int ch) {
        if (ch > 0) {
            this.channel.select(ch);
        } else {
            this.channel.select(0);
        }
    }

    public int getChannel() {
        if (this.channel.getSelectionIndex() == 0) {
            return -1;
        }
        return this.channel.getSelectionIndex();
    }

    public void setBitrate(int bitrates) {
        this.updateStoreValue("" + bitrates, this.bitrate);
    }

    public void setFrameRate(int framerate) {
        this.updateStoreValue("" + framerate, this.frameRate);
    }

    public int getBitrate() {
        if (this.bitrate.getSelectionIndex() <= 0) {
            return -1;
        }
        return Integer.parseInt(this.bitrate.getItem(this.bitrate.getSelectionIndex()));
    }

    public int getFramerate() {
        if (this.frameRate.getSelectionIndex() <= 0) {
            return -1;
        }
        return Integer.parseInt(this.frameRate.getItem(this.frameRate.getSelectionIndex()));
    }

    public void setEnabled(boolean bool) {
        super.setEnabled(bool);
        this.frameRate.setEnabled(bool);
        this.bitrate.setEnabled(bool);
        this.channel.setEnabled(bool);
    }

    public MP3AudioSettingComposite(Composite parent, int style, boolean horizontal, String preferenceKey) {
        super(parent, style);
        this.preferenceKey = preferenceKey;
        if (horizontal) {
            this.setLayout((Layout)new RowLayout());
        } else {
            this.setLayout((Layout)new GridLayout(3, false));
        }
        Label label3 = new Label((Composite)this, 0);
        label3.setText(Messages.getString("MP3AudioSettingComposite.convertbitrate"));
        this.bitrate = new CCombo((Composite)this, 8);
        Label label31 = new Label((Composite)this, 0);
        label31.setText("kbps");
        Label label4 = new Label((Composite)this, 0);
        label4.setText(Messages.getString("MP3AudioSettingComposite.convertframerate"));
        this.frameRate = new CCombo((Composite)this, 8);
        this.frameRate.add(Messages.getString("MP3AudioSettingComposite.same_source"));
        Label label41 = new Label((Composite)this, 0);
        label41.setText("hz");
        this.updateFramerate(MpegAudioFormatUtil.official_mp3_framerate);
        this.setFrameRate(44100);
        this.updateBitrate();
        this.setBitrate(128);
        Label label5 = new Label((Composite)this, 0);
        label5.setText(Messages.getString("MP3AudioSettingComposite.convertchannel"));
        this.channel = new CCombo((Composite)this, 8);
        this.channel.add(Messages.getString("MP3AudioSettingComposite.same_source"));
        this.channel.add(Messages.getString("monoral"));
        this.channel.add(Messages.getString("stereo"));
        this.channel.select(2);
        ValueChanged valueChanged = new ValueChanged();
        this.bitrate.addSelectionListener((SelectionListener)valueChanged);
        this.frameRate.addSelectionListener((SelectionListener)valueChanged);
        this.channel.addSelectionListener((SelectionListener)valueChanged);
        this.pack();
    }

    public class ValueChanged
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == MP3AudioSettingComposite.this.frameRate) {
                MP3AudioSettingComposite.this.updateBitrate();
                if (MP3AudioSettingComposite.this.preferenceStore != null) {
                    MP3AudioSettingComposite.this.preferenceStore.setValue(String.valueOf(MP3AudioSettingComposite.this.preferenceKey) + "." + MP3AudioSettingComposite.FRAMERATE, MP3AudioSettingComposite.this.toStoredValue(MP3AudioSettingComposite.this.frameRate));
                }
            } else if (e.getSource() == MP3AudioSettingComposite.this.bitrate) {
                if (MP3AudioSettingComposite.this.preferenceStore != null) {
                    MP3AudioSettingComposite.this.preferenceStore.setValue(String.valueOf(MP3AudioSettingComposite.this.preferenceKey) + "." + MP3AudioSettingComposite.BITRATE, MP3AudioSettingComposite.this.toStoredValue(MP3AudioSettingComposite.this.bitrate));
                }
            } else if (e.getSource() == MP3AudioSettingComposite.this.channel && MP3AudioSettingComposite.this.preferenceStore != null) {
                MP3AudioSettingComposite.this.preferenceStore.setValue(String.valueOf(MP3AudioSettingComposite.this.preferenceKey) + "." + MP3AudioSettingComposite.CHANNEL, MP3AudioSettingComposite.this.toStoredValue(MP3AudioSettingComposite.this.channel));
            }
        }
    }
}

