/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.jface.util.Util;
import org.eclipse.ui.internal.menus.ILocationElementTokenizer;
import org.eclipse.ui.internal.menus.LeafLocationElement;
import org.eclipse.ui.internal.menus.LocationElement;
import org.eclipse.ui.internal.menus.LocationElementToken;
import org.eclipse.ui.internal.menus.SLocation;

public final class SPopup
extends LeafLocationElement {
    private final String id;

    public SPopup(String id, String path) {
        super(path);
        this.id = id;
    }

    public final LocationElement createChild(String id) {
        String parentPath = this.getPath();
        String path = parentPath == null ? id : String.valueOf(parentPath) + '/' + id;
        return new SPopup(this.getId(), path);
    }

    public final String getId() {
        return this.id;
    }

    public final ILocationElementTokenizer getTokenizer() {
        return new ILocationElementTokenizer(){
            String remainingPath;
            String parsedPath;
            {
                this.remainingPath = SPopup.this.getPath();
                this.parsedPath = null;
            }

            public final LocationElementToken nextToken() {
                String id;
                SLocation location = new SLocation(new SPopup(SPopup.this.getId(), this.parsedPath));
                int separator = this.remainingPath.indexOf(47);
                if (separator == -1) {
                    id = this.remainingPath;
                    this.remainingPath = null;
                } else {
                    id = this.remainingPath.substring(0, separator);
                    this.remainingPath = this.remainingPath.substring(separator + 1);
                }
                this.parsedPath = String.valueOf(this.parsedPath) + id;
                return new LocationElementToken(location, id);
            }

            public final boolean hasMoreTokens() {
                return this.remainingPath != null;
            }
        };
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SPopup(");
        buffer.append(this.id);
        buffer.append(',');
        buffer.append(this.getPath());
        buffer.append(')');
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SPopup) {
            SPopup popup = (SPopup)obj;
            return Util.equals((Object)this.id, (Object)popup.id) && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return Util.hashCode((Object)this.id) + super.hashCode();
    }
}

