/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceContentProvider;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.CapabilityFilter;
import org.eclipse.ui.internal.dialogs.PreferenceBoldLabelProvider;
import org.eclipse.ui.internal.dialogs.PreferenceHistoryEntry;
import org.eclipse.ui.internal.dialogs.PreferenceNodeFilter;
import org.eclipse.ui.internal.dialogs.PreferencePageHistory;
import org.eclipse.ui.internal.dialogs.PreferencePatternFilter;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class FilteredPreferenceDialog
extends PreferenceDialog
implements IWorkbenchPreferenceContainer {
    protected PreferenceFilteredTree filteredTree;
    private Object pageData;
    IWorkingCopyManager workingCopyManager;
    private Collection updateJobs = new ArrayList();
    PreferencePageHistory history = new PreferencePageHistory(this);

    public FilteredPreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
    }

    protected IPreferenceNode findNodeMatching(String nodeId) {
        IPreferenceNode node = super.findNodeMatching(nodeId);
        if (WorkbenchActivityHelper.filterItem(node)) {
            return null;
        }
        return node;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Text filterText;
        int styleBits = 260;
        this.filteredTree = new PreferenceFilteredTree(parent, styleBits, new PreferencePatternFilter());
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 7;
        this.filteredTree.setBackground(parent.getDisplay().getSystemColor(25));
        TreeViewer tree = this.filteredTree.getViewer();
        this.setContentAndLabelProviders(tree);
        tree.setInput((Object)this.getPreferenceManager());
        if (this.hasAtMostOnePage(tree) && (filterText = this.filteredTree.getFilterControl()) != null) {
            this.filteredTree.getFilterControl().setEnabled(false);
        }
        tree.addFilter((ViewerFilter)new CapabilityFilter());
        tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FilteredPreferenceDialog.this.handleTreeSelectionChanged(event);
            }
        });
        super.addListeners(this.filteredTree.getViewer());
        return this.filteredTree.getViewer();
    }

    private boolean hasAtMostOnePage(TreeViewer tree) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)tree.getContentProvider();
        Object[] children = contentProvider.getElements(tree.getInput());
        if (children.length <= 1) {
            if (children.length == 0) {
                return true;
            }
            return !contentProvider.hasChildren(children[0]);
        }
        return false;
    }

    protected void setContentAndLabelProviders(TreeViewer treeViewer) {
        treeViewer.setLabelProvider((IBaseLabelProvider)new PreferenceBoldLabelProvider(this.filteredTree));
        treeViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
    }

    protected void handleTreeSelectionChanged(SelectionChangedEvent event) {
    }

    protected Control createTreeAreaContents(Composite parent) {
        Composite leftArea = new Composite(parent, 0);
        leftArea.setBackground(parent.getDisplay().getSystemColor(25));
        leftArea.setFont(parent.getFont());
        GridLayout leftLayout = new GridLayout();
        leftLayout.numColumns = 1;
        leftLayout.marginHeight = 0;
        leftLayout.marginTop = 7;
        leftLayout.marginWidth = 0;
        leftLayout.marginLeft = 7;
        leftLayout.horizontalSpacing = 0;
        leftLayout.verticalSpacing = 0;
        leftArea.setLayout((Layout)leftLayout);
        TreeViewer viewer = this.createTreeViewer(leftArea);
        this.setTreeViewer(viewer);
        this.updateTreeFont(JFaceResources.getDialogFont());
        GridData viewerData = new GridData(1808);
        viewer.getControl().getParent().setLayoutData((Object)viewerData);
        this.layoutTreeAreaControl((Control)leftArea);
        return leftArea;
    }

    public void showOnly(String[] filteredIds) {
        this.filteredTree.addFilter(new PreferenceNodeFilter(filteredIds));
    }

    public void setPageData(Object pageData) {
        this.pageData = pageData;
    }

    protected void createPage(IPreferenceNode node) {
        super.createPage(node);
        if (this.pageData == null) {
            return;
        }
        IPreferencePage page = node.getPage();
        if (page instanceof PreferencePage) {
            ((PreferencePage)page).applyData(this.pageData);
        }
    }

    public IPreferencePage getCurrentPage() {
        return super.getCurrentPage();
    }

    public boolean openPage(String pageId, Object data) {
        this.setPageData(data);
        this.setCurrentPageId(pageId);
        IPreferencePage page = this.getCurrentPage();
        if (page instanceof PreferencePage) {
            ((PreferencePage)page).applyData(data);
        }
        return true;
    }

    public final void setCurrentPageId(String preferencePageId) {
        IPreferenceNode node = this.findNodeMatching(preferencePageId);
        if (node != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node));
            this.showPage(node);
        }
    }

    public IWorkingCopyManager getWorkingCopyManager() {
        if (this.workingCopyManager == null) {
            this.workingCopyManager = new WorkingCopyManager();
        }
        return this.workingCopyManager;
    }

    protected void okPressed() {
        super.okPressed();
        if (this.getReturnCode() == 2) {
            return;
        }
        if (this.workingCopyManager != null) {
            try {
                this.workingCopyManager.applyChanges();
            }
            catch (BackingStoreException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = WorkbenchMessages.FilteredPreferenceDialog_PreferenceSaveFailed;
                }
                Status errorStatus = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, msg, (Throwable)e);
                ErrorDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.PreferencesExportDialog_ErrorDialogTitle, (String)WorkbenchMessages.FilteredPreferenceDialog_PreferenceSaveFailed, (IStatus)errorStatus);
            }
        }
        Iterator updateIterator = this.updateJobs.iterator();
        while (updateIterator.hasNext()) {
            ((Job)updateIterator.next()).schedule();
        }
    }

    public void registerUpdateJob(Job job) {
        this.updateJobs.add(job);
    }

    Control getContainerToolBar(Composite composite) {
        ToolBarManager historyManager = new ToolBarManager(0x800100);
        historyManager.createControl(composite);
        this.history.createHistoryControls(historyManager.getControl(), historyManager);
        historyManager.update(false);
        return historyManager.getControl();
    }

    protected boolean showPage(IPreferenceNode node) {
        boolean success = super.showPage(node);
        if (success) {
            this.history.addHistoryEntry(new PreferenceHistoryEntry(node.getId(), node.getLabelText(), null));
        }
        return success;
    }

    public boolean close() {
        this.history.dispose();
        return super.close();
    }

    protected Composite createTitleArea(Composite parent) {
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        parentLayout.numColumns = 2;
        parentLayout.marginHeight = 0;
        parentLayout.marginTop = 7;
        parent.setLayout((Layout)parentLayout);
        Composite titleComposite = super.createTitleArea(parent);
        Composite toolbarArea = new Composite(parent, 0);
        GridLayout toolbarLayout = new GridLayout();
        toolbarLayout.marginHeight = 0;
        toolbarLayout.verticalSpacing = 0;
        toolbarArea.setLayout((Layout)toolbarLayout);
        toolbarArea.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        Control topBar = this.getContainerToolBar(toolbarArea);
        topBar.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        return titleComposite;
    }

    protected void selectSavedItem() {
        Text filterText;
        this.getTreeViewer().setInput((Object)this.getPreferenceManager());
        super.selectSavedItem();
        if (this.getTreeViewer().getTree().getItemCount() > 1 && (filterText = this.filteredTree.getFilterControl()) != null) {
            filterText.setFocus();
        }
    }

    protected void updateTreeFont(Font dialogFont) {
        FilteredPreferenceDialog.applyDialogFont((Control)this.filteredTree);
    }

    protected class PreferenceFilteredTree
    extends FilteredTree {
        private ViewerFilter viewerFilter;
        private String cachedTitle;

        PreferenceFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter);
        }

        protected void addFilter(ViewerFilter filter) {
            this.viewerFilter = filter;
            this.getViewer().addFilter(filter);
            this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
            if (this.filterText != null) {
                this.setFilterText(WorkbenchMessages.FilteredTree_FilterMessage);
                this.textChanged();
            }
            this.cachedTitle = this.getShell().getText();
            this.getShell().setText(NLS.bind((String)WorkbenchMessages.FilteredTree_FilteredDialogTitle, (Object)this.cachedTitle));
        }

        protected void updateToolbar(boolean visible) {
            if (this.filterToolBar != null) {
                this.filterToolBar.getControl().setVisible(this.viewerFilter != null || visible);
            }
        }

        protected void clearText() {
            this.setFilterText("");
            if (this.viewerFilter != null) {
                this.getViewer().removeFilter(this.viewerFilter);
                this.viewerFilter = null;
                this.getShell().setText(this.cachedTitle);
            }
            this.textChanged();
        }
    }
}

