/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools.bitrate;

import java.io.File;
import java.math.BigDecimal;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ffmpeg.CachedFFMpegFileInfomationParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFileInfomation;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import jp.sourceforge.akjrcp.ui.EditableFileList;
import jp.sourceforge.akjrcp.ui.LabelScale;
import jp.sourceforge.akjrcp.ui.LabelTextLabel;
import jp.sourceforge.akjrcp.ui.param.ParamTime;
import jp.sourceforge.akjrcp.util.ExecutingControlerView;
import jp.sourceforge.akjrcp.util.TimeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class BitrateCalcuraterView
extends ExecutingControlerView {
    public static Log log = LogFactory.getLog(BitrateCalcuraterView.class);
    public static final String ID = BitrateCalcuraterView.class.getName();
    private SimpleCommandExecuter commandExecuter;
    private LabelTextLabel sizeResult1;
    private LabelTextLabel sizeResult2;
    private LabelTextLabel bitrateResult1;
    private LabelTextLabel bitrateResult2;
    private LabelTextLabel timeResult1;
    private Button videoTimeRadio;
    private Button optionTimeRadio;
    private Button customSizeRadio;
    private Button cdSizeRadio;
    private Button dvdSizeRadio;
    private Button dvddlSizeRadio;
    private CCombo customSizeCombo;
    private ParamTime optionTime;
    private ParamTime videoTime;
    private LabelScale videoBitrateScale;
    private LabelScale audioBitrateScale;
    private LabelTextLabel timeResult2;
    private CachedFFMpegFileInfomationParser cachedFFMpegFileInfomationParser;
    private EditableFileList fileList;

    public void createPartControl(Composite parent) {
        UpdateResult updateResult = new UpdateResult();
        parent.setLayout((Layout)new GridLayout(1, false));
        Group sizeGroup = new Group(parent, 0);
        sizeGroup.setText(Messages.getString("bitrate_calcurate.size_based"));
        sizeGroup.setLayout((Layout)new GridLayout(1, false));
        sizeGroup.setLayoutData((Object)new GridData(768));
        Composite sizeResult = new Composite((Composite)sizeGroup, 0);
        sizeResult.setLayout((Layout)new GridLayout(2, false));
        this.sizeResult1 = new LabelTextLabel(sizeResult, 2048, Messages.getString("bitrate_calcurate.result_bitrate"), "", "kbps");
        this.sizeResult1.setLayoutData(this.maekGridData(230, 0), this.maekGridData(50, 0), this.maekGridData(30, 0));
        this.sizeResult2 = new LabelTextLabel(sizeResult, 2048, Messages.getString("bitrate_calcurate.result_time"), "", "");
        this.sizeResult2.setLayoutData(this.maekGridData(230, 0), this.maekGridData(50, 0), this.maekGridData(30, 0));
        Composite sizeList = new Composite((Composite)sizeGroup, 0);
        sizeList.setLayout((Layout)new GridLayout(6, false));
        sizeList.setLayoutData((Object)this.maekGridData(540, 0));
        this.customSizeRadio = new Button(sizeList, 16);
        this.customSizeRadio.setText("custom");
        this.customSizeRadio.addSelectionListener((SelectionListener)updateResult);
        this.customSizeCombo = new CCombo(sizeList, 0);
        this.customSizeCombo.add("");
        this.customSizeCombo.add("3900(4GB MSDuo)");
        this.customSizeCombo.add("1900(2GB MSDuo)");
        this.customSizeCombo.add("950(1GB MSDuo)");
        this.customSizeCombo.select(3);
        this.customSizeCombo.addModifyListener((ModifyListener)updateResult);
        new Label(sizeList, 0).setText("MB");
        this.cdSizeRadio = new Button(sizeList, 16);
        this.cdSizeRadio.setText("CD(700MB)");
        this.cdSizeRadio.addSelectionListener((SelectionListener)updateResult);
        this.dvdSizeRadio = new Button(sizeList, 16);
        this.dvdSizeRadio.setText("DVD(4.37GB)");
        this.dvdSizeRadio.setSelection(true);
        this.dvdSizeRadio.addSelectionListener((SelectionListener)updateResult);
        this.dvddlSizeRadio = new Button(sizeList, 16);
        this.dvddlSizeRadio.setText("DVD DL(7.95GB)");
        this.dvddlSizeRadio.addSelectionListener((SelectionListener)updateResult);
        Group bitrateGroup = new Group(parent, 0);
        bitrateGroup.setText(Messages.getString("bitrate_calcurate.bitrate_based"));
        bitrateGroup.setLayout((Layout)new GridLayout());
        bitrateGroup.setLayoutData((Object)new GridData(768));
        Composite bitreteResult = new Composite((Composite)bitrateGroup, 0);
        bitreteResult.setLayout((Layout)new GridLayout(2, false));
        this.bitrateResult1 = new LabelTextLabel(bitreteResult, 2048, Messages.getString("bitrate_calcurate.result_time"), "", "");
        this.bitrateResult1.setLayoutData(this.maekGridData(230, 0), this.maekGridData(50, 0), this.maekGridData(30, 0));
        this.bitrateResult2 = new LabelTextLabel(bitreteResult, 2048, Messages.getString("bitrate_calcurate.result_size"), "", "MB");
        this.bitrateResult2.setLayoutData(this.maekGridData(230, 0), this.maekGridData(50, 0), this.maekGridData(30, 0));
        Composite bitrateControler = new Composite((Composite)bitrateGroup, 0);
        bitrateControler.setLayout((Layout)new GridLayout(2, false));
        bitrateControler.setLayoutData((Object)new GridData(768));
        this.videoBitrateScale = new LabelScale(bitrateControler, 0, 1, 64, 308){

            public String toLabel() {
                return String.valueOf(this.getHeaderText()) + this.getScale().getSelection() * 32 + this.getFooterText();
            }
        };
        this.videoBitrateScale.setLayoutData(new GridData(768));
        this.videoBitrateScale.setHeaderText(String.valueOf(Messages.getString("bitrate_calcurate.video_bitrate")) + " ");
        this.videoBitrateScale.setFooterText(" kbps");
        this.videoBitrateScale.setLayoutData(this.maekGridData(150, 0), new GridData(768));
        this.videoBitrateScale.getScale().addSelectionListener((SelectionListener)updateResult);
        this.audioBitrateScale = new LabelScale(bitrateControler, 0, 1, 4, 48){

            public String toLabel() {
                return String.valueOf(this.getHeaderText()) + this.getScale().getSelection() * 32 + this.getFooterText();
            }
        };
        this.audioBitrateScale.setLayoutData(new GridData(768));
        this.audioBitrateScale.setHeaderText(String.valueOf(Messages.getString("bitrate_calcurate.audio_bitrate")) + " ");
        this.audioBitrateScale.setFooterText(" kbps");
        this.audioBitrateScale.setLayoutData(this.maekGridData(150, 0), new GridData(768));
        this.audioBitrateScale.getScale().addSelectionListener((SelectionListener)updateResult);
        Group timeGroup = new Group(parent, 0);
        timeGroup.setText(Messages.getString("bitrate_calcurate.time_based"));
        timeGroup.setLayout((Layout)new GridLayout());
        timeGroup.setLayoutData((Object)new GridData(1808));
        Composite timeResult = new Composite((Composite)timeGroup, 0);
        timeResult.setLayout((Layout)new GridLayout(2, false));
        this.timeResult1 = new LabelTextLabel(timeResult, 2048, Messages.getString("bitrate_calcurate.result_bitrate"), "", "kbps");
        this.timeResult1.setLayoutData(this.maekGridData(230, 0), this.maekGridData(50, 0), this.maekGridData(30, 0));
        this.timeResult2 = new LabelTextLabel(timeResult, 2048, Messages.getString("bitrate_calcurate.result_size"), "", "MB");
        this.timeResult2.setLayoutData(this.maekGridData(230, 0), this.maekGridData(50, 0), this.maekGridData(30, 0));
        Composite timeControler = new Composite((Composite)timeGroup, 0);
        timeControler.setLayout((Layout)new GridLayout(4, false));
        timeControler.setLayoutData((Object)new GridData(768));
        this.optionTimeRadio = new Button(timeControler, 16);
        this.optionTimeRadio.setText(Messages.getString("bitrate_calcurate.inputed_time"));
        this.optionTimeRadio.setSelection(true);
        this.optionTime = new ParamTime(timeControler, 0, "option", "", true, true, true, false);
        this.optionTime.setValue("1:0:0");
        this.optionTime.addModifyListener(updateResult);
        this.videoTimeRadio = new Button(timeControler, 16);
        this.videoTimeRadio.setText(Messages.getString("bitrate_calcurate.videoTime"));
        this.videoTimeRadio.addSelectionListener((SelectionListener)updateResult);
        this.videoTime = new ParamTime(timeControler, 8, "video", "", true, true, true, false);
        this.videoTime.setEnabled(false);
        this.fileList = new EditableFileList(timeControler, 0);
        this.fileList.setInput(this.getSite());
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        this.fileList.getTable().setLayoutData((Object)data);
        String[] cols = new String[]{"Time", "Path"};
        int i = 0;
        while (i < cols.length) {
            TableColumn col = new TableColumn(this.fileList.getTable(), 16384);
            col.setText(cols[i]);
            if (i == 0) {
                col.setWidth(120);
            } else {
                col.setWidth(550);
            }
            ++i;
        }
        String ffmpegPath = FFMpegUI.getFFmpegOrPureFFMpeg();
        if (ffmpegPath == null) {
            log.warn((Object)"ffmpeg is null");
        }
        this.cachedFFMpegFileInfomationParser = new CachedFFMpegFileInfomationParser(ffmpegPath);
        PlayTimeLabelProvider provider = new PlayTimeLabelProvider(this.cachedFFMpegFileInfomationParser);
        this.fileList.setLabelProvider((IBaseLabelProvider)provider);
        this.fileList.addPropertyChangeListener(new UpdateVideoTime());
        this.calcurate();
    }

    public GridData maekGridData(int w, int h) {
        GridData data = new GridData();
        if (w != 0) {
            data.widthHint = w;
        }
        if (h != 0) {
            data.heightHint = h;
        }
        return data;
    }

    public void setFocus() {
    }

    private void calcurate() {
        long targetKByte = this.getTargetSize();
        int videoBitrate = this.getVideoBitrate();
        int audioBitrate = this.getAudioBitrate();
        long targetTime = this.getTargetTime();
        long targetSec = 0L;
        if (targetTime > 0L) {
            targetSec = targetTime / 1000L;
        }
        long audioKByte = (long)(this.kbps2kbyte(audioBitrate) * (double)targetSec);
        String targetTimeString = String.valueOf(Messages.getString("bitrate_calcurate.time")) + " " + TimeUtils.toTimeText(targetTime, true, true, true, false);
        String targetKByteString = String.valueOf(Messages.getString("bitrate_calcurate.bitrate")) + " " + videoBitrate + " kbps";
        String targetSizeString = String.valueOf(Messages.getString("bitrate_calcurate.size")) + " " + targetKByte / 1024L + " MByte";
        long sizeResultKByte = 0L;
        if (targetSec > 0L) {
            sizeResultKByte = (long)this.kbyte2kbps((int)((targetKByte - audioKByte) / targetSec));
        }
        this.sizeResult1.setText("" + sizeResultKByte);
        this.sizeResult1.getHeaderLabel().setText(String.valueOf(targetTimeString) + " " + Messages.getString("bitrate_calcurate.result_bitrate"));
        long ssec = (long)((double)targetKByte / this.kbps2kbyte(audioBitrate + videoBitrate));
        this.sizeResult2.setText(TimeUtils.toTimeText(ssec * 1000L, true, true, true, false));
        this.sizeResult2.getHeaderLabel().setText(String.valueOf(targetKByteString) + " " + Messages.getString("bitrate_calcurate.result_time"));
        this.bitrateResult1.setText(TimeUtils.toTimeText(ssec * 1000L, true, true, true, false));
        this.bitrateResult1.getHeaderLabel().setText(String.valueOf(targetSizeString) + " " + Messages.getString("bitrate_calcurate.result_time"));
        double bsize = this.kbps2kbyte(audioBitrate + videoBitrate) * (double)targetSec / 1024.0;
        double sc2 = new BigDecimal(bsize).setScale(2, 4).doubleValue();
        this.bitrateResult2.setText("" + sc2);
        this.bitrateResult2.getHeaderLabel().setText(String.valueOf(targetTimeString) + " " + Messages.getString("bitrate_calcurate.result_size"));
        this.timeResult1.setText("" + sizeResultKByte);
        this.timeResult1.getHeaderLabel().setText(String.valueOf(targetSizeString) + " " + Messages.getString("bitrate_calcurate.result_bitrate"));
        this.timeResult2.setText("" + sc2);
        this.timeResult2.getHeaderLabel().setText(String.valueOf(targetKByteString) + " " + Messages.getString("bitrate_calcurate.result_size"));
    }

    private double kbyte2kbps(long kbyte) {
        return kbyte * 1024L * 8L / 1000L;
    }

    private double kbps2kbyte(long kbps) {
        return kbps * 1000L / 8L / 1024L;
    }

    private int getVideoBitrate() {
        return this.videoBitrateScale.getScale().getSelection() * 32;
    }

    private int getAudioBitrate() {
        return this.audioBitrateScale.getScale().getSelection() * 32;
    }

    private long getTargetTime() {
        long ret = 0L;
        ret = this.optionTimeRadio.getSelection() ? this.optionTime.getTime() : this.videoTime.getTime();
        return ret;
    }

    private int getTargetSize() {
        int size = 1;
        if (this.cdSizeRadio.getSelection()) {
            size = 700;
        } else if (this.dvdSizeRadio.getSelection()) {
            size = 4474;
        } else if (this.dvddlSizeRadio.getSelection()) {
            size = 8140;
        } else {
            String text = this.customSizeCombo.getText();
            log.info((Object)("text:" + text));
            String[] vs = text.split("\\(");
            try {
                size = Integer.parseInt(vs[0]);
            }
            catch (Exception exception) {}
        }
        return size * 1024;
    }

    public void doAfterExecute() {
    }

    public void doBeforeExecute() {
    }

    public boolean doCanExecute() {
        return true;
    }

    public void doCancelExecute() {
        if (this.commandExecuter != null) {
            this.commandExecuter.cancel();
        }
    }

    public void doInExecute() {
    }

    class UpdateVideoTime
    implements IPropertyChangeListener {
        UpdateVideoTime() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("add") || event.getProperty().equals("remove")) {
                BitrateCalcuraterView.this.videoTimeRadio.setSelection(true);
                BitrateCalcuraterView.this.optionTimeRadio.setSelection(false);
                File[] file = BitrateCalcuraterView.this.fileList.getFileList();
                long totalTime = 0L;
                int i = 0;
                while (i < file.length) {
                    FFMpegFileInfomation info = BitrateCalcuraterView.this.cachedFFMpegFileInfomationParser.parseFileInfomation(file[i]);
                    totalTime += TimeUtils.toMillisecond(info.getDuration());
                    ++i;
                }
                BitrateCalcuraterView.this.videoTime.setValue(TimeUtils.toTimeText(totalTime));
                BitrateCalcuraterView.this.calcurate();
            }
        }
    }

    class PlayTimeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CachedFFMpegFileInfomationParser parser;

        public PlayTimeLabelProvider(CachedFFMpegFileInfomationParser parser) {
            this.parser = parser;
        }

        public String getColumnText(Object obj, int index) {
            File file = (File)obj;
            if (index == 0) {
                String duration = this.parser.parseFileInfomation(file).getDuration();
                if (duration == null) {
                    duration = "";
                }
                return duration;
            }
            return file.getName();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    public class UpdateResult
    implements SelectionListener,
    ModifyListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            BitrateCalcuraterView.this.calcurate();
        }

        public void modifyText(ModifyEvent e) {
            BitrateCalcuraterView.this.calcurate();
        }
    }
}

